/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.cleaner;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.cleaner.Cleaner;
import com.sleepycat.je.cleaner.FileSelector;
import com.sleepycat.je.cleaner.LNInfo;
import com.sleepycat.je.cleaner.PackedOffsets;
import com.sleepycat.je.cleaner.TrackedFileSummary;
import com.sleepycat.je.cleaner.UtilizationProfile;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.dbi.DatabaseImpl;
import com.sleepycat.je.dbi.DbTree;
import com.sleepycat.je.dbi.EnvironmentImpl;
import com.sleepycat.je.dbi.MemoryBudget;
import com.sleepycat.je.log.CleanerFileReader;
import com.sleepycat.je.tree.BIN;
import com.sleepycat.je.tree.ChildReference;
import com.sleepycat.je.tree.DIN;
import com.sleepycat.je.tree.IN;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.tree.SearchResult;
import com.sleepycat.je.tree.Tree;
import com.sleepycat.je.tree.TreeLocation;
import com.sleepycat.je.tree.WithRootLatched;
import com.sleepycat.je.txn.BasicLocker;
import com.sleepycat.je.txn.LockGrantType;
import com.sleepycat.je.txn.LockResult;
import com.sleepycat.je.txn.LockType;
import com.sleepycat.je.utilint.DaemonThread;
import com.sleepycat.je.utilint.DbLsn;
import com.sleepycat.je.utilint.Tracer;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.logging.Level;

class FileProcessor
extends DaemonThread {
    private static final int PROCESS_PENDING_EVERY_N_LNS = 100;
    private static final boolean PROHIBIT_DELTAS_WHEN_FETCHING = false;
    private static final boolean DEBUG_TRACING = false;
    private EnvironmentImpl env;
    private Cleaner cleaner;
    private FileSelector fileSelector;
    private UtilizationProfile profile;
    private int nINsObsoleteThisRun = 0;
    private int nINsCleanedThisRun = 0;
    private int nINsDeadThisRun = 0;
    private int nINsMigratedThisRun = 0;
    private int nLNsObsoleteThisRun = 0;
    private int nLNsCleanedThisRun = 0;
    private int nLNsDeadThisRun = 0;
    private int nLNsLockedThisRun = 0;
    private int nLNsMigratedThisRun = 0;
    private int nLNsMarkedThisRun = 0;
    private int nLNQueueHitsThisRun = 0;
    private int nEntriesReadThisRun;
    private long nRepeatIteratorReadsThisRun;
    static final /* synthetic */ boolean $assertionsDisabled;

    FileProcessor(String name, EnvironmentImpl env, Cleaner cleaner, UtilizationProfile profile, FileSelector fileSelector) {
        super(0L, name, env);
        this.env = env;
        this.cleaner = cleaner;
        this.fileSelector = fileSelector;
        this.profile = profile;
    }

    public void clearEnv() {
        this.env = null;
        this.cleaner = null;
        this.fileSelector = null;
        this.profile = null;
    }

    protected int nDeadlockRetries() throws DatabaseException {
        return this.cleaner.nDeadlockRetries;
    }

    public void addToQueue(Object o) throws DatabaseException {
        throw new DatabaseException("Cleaner.addToQueue should never be called.");
    }

    public void onWakeup() throws DatabaseException {
        this.doClean(true, true, false);
    }

    public synchronized int doClean(boolean invokedFromDaemon, boolean cleanMultipleFiles, boolean forceCleaning) throws DatabaseException {
        if (this.env.isClosed()) {
            return 0;
        }
        int nOriginalLogFiles = this.profile.getNumberOfFiles();
        int nFilesCleaned = 0;
        while (nFilesCleaned < nOriginalLogFiles && !this.env.isClosing()) {
            String traceMsg;
            Object var14_13;
            this.cleaner.processPending();
            this.cleaner.deleteSafeToDeleteFiles();
            boolean needLowUtilizationSet = this.cleaner.clusterResident || this.cleaner.clusterAll;
            Long fileNum = this.fileSelector.selectFileForCleaning(this.profile, forceCleaning, needLowUtilizationSet, this.cleaner.maxBatchFiles);
            this.cleaner.updateReadOnlyFileCollections();
            if (fileNum == null) break;
            this.resetPerRunCounters();
            boolean finished = false;
            long fileNumValue = fileNum;
            int runId = ++this.cleaner.nCleanerRuns;
            try {
                block8: {
                    try {
                        String traceMsg2 = "CleanerRun " + runId + " on file 0x" + Long.toHexString(fileNumValue) + " begins backlog=" + this.cleaner.nBacklogFiles;
                        Tracer.trace(Level.INFO, this.env, traceMsg2);
                        if (!this.processFile(fileNum)) break block8;
                        this.fileSelector.addCleanedFile(fileNum);
                        ++nFilesCleaned;
                        this.accumulatePerRunCounters();
                        finished = true;
                    }
                    catch (IOException IOE) {
                        Tracer.trace(this.env, "Cleaner", "doClean", "", IOE);
                        throw new DatabaseException(IOE);
                    }
                }
                var14_13 = null;
                if (!finished) {
                    this.fileSelector.putBackFileForCleaning(fileNum);
                }
                traceMsg = "CleanerRun " + runId + " on file 0x" + Long.toHexString(fileNumValue) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsObsolete=" + this.nINsObsoleteThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsDead=" + this.nINsDeadThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsObsolete=" + this.nLNsObsoleteThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsMarked=" + this.nLNsMarkedThisRun + " nLNQueueHits=" + this.nLNQueueHitsThisRun + " nLNsLocked=" + this.nLNsLockedThisRun;
            }
            catch (Throwable throwable) {
                var14_13 = null;
                if (!finished) {
                    this.fileSelector.putBackFileForCleaning(fileNum);
                }
                traceMsg = "CleanerRun " + runId + " on file 0x" + Long.toHexString(fileNumValue) + " invokedFromDaemon=" + invokedFromDaemon + " finished=" + finished + " nEntriesRead=" + this.nEntriesReadThisRun + " nINsObsolete=" + this.nINsObsoleteThisRun + " nINsCleaned=" + this.nINsCleanedThisRun + " nINsDead=" + this.nINsDeadThisRun + " nINsMigrated=" + this.nINsMigratedThisRun + " nLNsObsolete=" + this.nLNsObsoleteThisRun + " nLNsCleaned=" + this.nLNsCleanedThisRun + " nLNsDead=" + this.nLNsDeadThisRun + " nLNsMigrated=" + this.nLNsMigratedThisRun + " nLNsMarked=" + this.nLNsMarkedThisRun + " nLNQueueHits=" + this.nLNQueueHitsThisRun + " nLNsLocked=" + this.nLNsLockedThisRun;
                Tracer.trace(Level.SEVERE, this.env, traceMsg);
                throw throwable;
            }
            Tracer.trace(Level.SEVERE, this.env, traceMsg);
            if (cleanMultipleFiles) continue;
            break;
        }
        return nFilesCleaned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean processFile(Long fileNum) throws DatabaseException, IOException {
        PackedOffsets obsoleteOffsets = new PackedOffsets();
        TrackedFileSummary tfs = this.profile.getObsoleteDetail(fileNum, obsoleteOffsets, true);
        PackedOffsets.Iterator obsoleteIter = obsoleteOffsets.iterator();
        long nextObsolete = -1L;
        int readBufferSize = this.cleaner.readBufferSize;
        int lookAheadCacheSize = this.cleaner.lookAheadCacheSize;
        int adjustMem = 2 * readBufferSize + obsoleteOffsets.getLogSize() + lookAheadCacheSize;
        MemoryBudget budget = this.env.getMemoryBudget();
        budget.updateMiscMemoryUsage(adjustMem);
        this.env.getEvictor().doCriticalEviction();
        LookAheadCache lookAheadCache = new LookAheadCache(lookAheadCacheSize);
        HashSet<DatabaseId> checkPendingDbSet = new HashSet<DatabaseId>();
        HashMap dbCache = new HashMap();
        try {
            CleanerFileReader reader = new CleanerFileReader(this.env, readBufferSize, -1L, fileNum);
            reader.setAlwaysValidateChecksum(true);
            DbTree dbMapTree = this.env.getDbMapTree();
            TreeLocation location = new TreeLocation();
            int nProcessedLNs = 0;
            while (reader.readNextEntry()) {
                DatabaseId dbId;
                ++this.cleaner.nEntriesRead;
                long lsn = reader.getLastLsn();
                long fileOffset = DbLsn.getFileOffset(lsn);
                boolean isLN = reader.isLN();
                boolean isIN = reader.isIN();
                boolean isRoot = reader.isRoot();
                boolean isObsolete = false;
                if (this.env.isClosing()) {
                    boolean bl = false;
                    return bl;
                }
                while (nextObsolete < fileOffset && obsoleteIter.hasNext()) {
                    nextObsolete = obsoleteIter.next();
                }
                if (nextObsolete == fileOffset) {
                    isObsolete = true;
                }
                if (!(isObsolete || isLN || isIN || isRoot)) {
                    isObsolete = true;
                }
                if (!isObsolete && isLN && reader.getLN().isDeleted()) {
                    isObsolete = true;
                }
                if (!isObsolete && tfs != null && tfs.containsObsoleteOffset(fileOffset)) {
                    isObsolete = true;
                }
                if (isObsolete) {
                    DatabaseId dbId2;
                    if (isLN) {
                        ++this.nLNsObsoleteThisRun;
                    } else if (isIN) {
                        ++this.nINsObsoleteThisRun;
                    }
                    if ((dbId2 = reader.getDatabaseId()) == null) continue;
                    checkPendingDbSet.add(dbId2);
                    continue;
                }
                this.env.getEvictor().doCriticalEviction();
                if (isLN) {
                    LN targetLN = reader.getLN();
                    dbId = reader.getDatabaseId();
                    byte[] key = reader.getKey();
                    byte[] dupKey = reader.getDupTreeKey();
                    lookAheadCache.add(new Long(DbLsn.getFileOffset(lsn)), new LNInfo(targetLN, dbId, key, dupKey));
                    if (lookAheadCache.isFull()) {
                        this.processLN(fileNum, location, lookAheadCache, dbCache);
                    }
                    if (++nProcessedLNs % 100 != 0) continue;
                    this.cleaner.processPending();
                    continue;
                }
                if (isIN) {
                    IN targetIN = reader.getIN();
                    dbId = reader.getDatabaseId();
                    DatabaseImpl db = dbMapTree.getDb(dbId, this.cleaner.lockTimeout, dbCache);
                    targetIN.setDatabase(db);
                    this.processIN(targetIN, db, lsn);
                    continue;
                }
                if (isRoot) {
                    this.env.rewriteMapTreeRoot(lsn);
                    continue;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
            }
            while (!lookAheadCache.isEmpty()) {
                this.env.getEvictor().doCriticalEviction();
                this.processLN(fileNum, location, lookAheadCache, dbCache);
            }
            Iterator i = checkPendingDbSet.iterator();
            while (i.hasNext()) {
                DatabaseId dbId = (DatabaseId)i.next();
                DatabaseImpl db = dbMapTree.getDb(dbId, this.cleaner.lockTimeout, dbCache);
                this.cleaner.addPendingDB(db);
            }
            this.nEntriesReadThisRun = reader.getNumRead();
            this.nRepeatIteratorReadsThisRun = reader.getNRepeatIteratorReads();
        }
        finally {
            budget.updateMiscMemoryUsage(0 - adjustMem);
            if (tfs != null) {
                tfs.setAllowFlush(true);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processLN(Long fileNum, TreeLocation location, LookAheadCache lookAheadCache, Map dbCache) throws DatabaseException {
        ++this.nLNsCleanedThisRun;
        Long offset = lookAheadCache.nextOffset();
        LNInfo info = lookAheadCache.remove(offset);
        LN ln = info.getLN();
        byte[] key = info.getKey();
        byte[] dupKey = info.getDupKey();
        long logLsn = DbLsn.makeLsn(fileNum, offset);
        DatabaseImpl db = this.env.getDbMapTree().getDb(info.getDbId(), this.cleaner.lockTimeout, dbCache);
        boolean processedHere = true;
        boolean obsolete = false;
        boolean completed = false;
        IN bin = null;
        IN parentDIN = null;
        try {
            long treeLsn;
            if (db == null || db.isDeleted()) {
                this.cleaner.addPendingDB(db);
                ++this.nLNsDeadThisRun;
                obsolete = true;
                completed = true;
                return;
            }
            Tree tree = db.getTree();
            if (!$assertionsDisabled && tree == null) {
                throw new AssertionError();
            }
            boolean parentFound = tree.getParentBINForChildLN(location, key, dupKey, ln, false, true, false, false);
            bin = location.bin;
            int index = location.index;
            if (!parentFound) {
                ++this.nLNsDeadThisRun;
                obsolete = true;
                completed = true;
                return;
            }
            if (bin.isEntryKnownDeleted(index)) {
                ++this.nLNsDeadThisRun;
                obsolete = true;
                completed = true;
                return;
            }
            boolean isDupCountLN = ln.containsDuplicates();
            if (isDupCountLN) {
                parentDIN = (DIN)bin.fetchTarget(index);
                parentDIN.latch(false);
                ChildReference dclRef = ((DIN)parentDIN).getDupCountLNRef();
                treeLsn = dclRef.getLsn();
            } else {
                treeLsn = bin.getLsn(index);
            }
            processedHere = false;
            this.processFoundLN(info, logLsn, treeLsn, (BIN)bin, index, (DIN)parentDIN);
            completed = true;
            if (!isDupCountLN) {
                for (int i = 0; i < bin.getNEntries(); ++i) {
                    Long myOffset;
                    LNInfo myInfo;
                    long lsn = bin.getLsn(i);
                    if (i == index || bin.isEntryKnownDeleted(i) || bin.isEntryPendingDeleted(i) || DbLsn.getFileNumber(lsn) != fileNum || (myInfo = lookAheadCache.remove(myOffset = new Long(DbLsn.getFileOffset(lsn)))) == null) continue;
                    ++this.nLNQueueHitsThisRun;
                    ++this.nLNsCleanedThisRun;
                    this.processFoundLN(myInfo, lsn, lsn, (BIN)bin, i, null);
                }
            }
            return;
        }
        finally {
            if (parentDIN != null) {
                parentDIN.releaseLatchIfOwner();
            }
            if (bin != null) {
                bin.releaseLatchIfOwner();
            }
            if (processedHere) {
                this.cleaner.trace(this.cleaner.detailedTraceLevel, "CleanLN:", ln, logLsn, completed, obsolete, false);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processFoundLN(LNInfo info, long logLsn, long treeLsn, BIN bin, int index, DIN parentDIN) throws DatabaseException {
        LN ln = info.getLN();
        byte[] key = info.getKey();
        byte[] dupKey = info.getDupKey();
        DatabaseImpl db = bin.getDatabase();
        boolean isDupCountLN = parentDIN != null;
        boolean obsolete = false;
        boolean migrated = false;
        boolean lockDenied = false;
        boolean completed = false;
        long nodeId = ln.getNodeId();
        BasicLocker locker = null;
        try {
            Tree tree = db.getTree();
            if (!$assertionsDisabled && tree == null) {
                throw new AssertionError();
            }
            if (treeLsn != logLsn) {
                locker = new BasicLocker(this.env);
                LockResult lockRet = locker.nonBlockingLock(nodeId, LockType.READ, db);
                if (lockRet.getLockGrant() == LockGrantType.DENIED) {
                    ++this.nLNsLockedThisRun;
                    lockDenied = true;
                } else {
                    ++this.nLNsDeadThisRun;
                    obsolete = true;
                }
            }
            if (!obsolete && !lockDenied) {
                if (isDupCountLN) {
                    ChildReference dclRef = parentDIN.getDupCountLNRef();
                    dclRef.setMigrate(true);
                    parentDIN.setDirty(true);
                    if (treeLsn == logLsn && dclRef.getTarget() == null) {
                        ln.postFetchInit(db, logLsn);
                        parentDIN.updateDupCountLN(ln);
                    }
                } else {
                    bin.setMigrate(index, true);
                    bin.setDirty(true);
                    if (treeLsn == logLsn && bin.getTarget(index) == null) {
                        ln.postFetchInit(db, logLsn);
                        bin.updateEntry(index, ln);
                    }
                    bin.setGeneration();
                }
                ++this.nLNsMarkedThisRun;
                migrated = true;
            }
            completed = true;
        }
        finally {
            if (locker != null) {
                locker.operationEnd();
            }
            if (completed && lockDenied) {
                this.fileSelector.addPendingLN(ln, db.getId(), key, dupKey);
            }
            this.cleaner.trace(this.cleaner.detailedTraceLevel, "CleanLN:", ln, logLsn, completed, obsolete, migrated);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processIN(IN inClone, DatabaseImpl db, long lsn) throws DatabaseException {
        boolean obsolete = false;
        boolean dirtied = false;
        boolean completed = false;
        try {
            ++this.nINsCleanedThisRun;
            if (db == null || db.isDeleted()) {
                this.cleaner.addPendingDB(db);
                ++this.nINsDeadThisRun;
                obsolete = true;
                completed = true;
                return;
            }
            Tree tree = db.getTree();
            if (!$assertionsDisabled && tree == null) {
                throw new AssertionError();
            }
            IN inInTree = this.findINInTree(tree, db, inClone, lsn);
            if (inInTree == null) {
                ++this.nINsDeadThisRun;
                obsolete = true;
            } else {
                ++this.nINsMigratedThisRun;
                inInTree.setDirty(true);
                inInTree.setProhibitNextDelta();
                inInTree.releaseLatch();
                dirtied = true;
            }
            completed = true;
        }
        finally {
            this.cleaner.trace(this.cleaner.detailedTraceLevel, "CleanIN:", inClone, lsn, completed, obsolete, dirtied);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IN findINInTree(Tree tree, DatabaseImpl db, IN inClone, long lsn) throws DatabaseException {
        if (inClone.isDbRoot()) {
            IN rootIN = this.isRoot(tree, db, inClone, lsn);
            if (rootIN == null) {
                return null;
            }
            return rootIN;
        }
        inClone.latch(false);
        SearchResult result = null;
        try {
            IN in;
            result = tree.getParentINForChildIN(inClone, true, false, inClone.getLevel(), null);
            if (!result.exactParentFound) {
                IN iN = null;
                return iN;
            }
            int compareVal = DbLsn.compareTo(result.parent.getLsn(result.index), lsn);
            if (compareVal > 0) {
                IN iN = null;
                return iN;
            }
            if (compareVal == 0) {
                in = (IN)result.parent.getTarget(result.index);
                if (in == null) {
                    in = inClone;
                    in.postFetchInit(db, lsn);
                    result.parent.updateEntry(result.index, in);
                }
            } else {
                in = (IN)result.parent.fetchTarget(result.index);
            }
            in.latch(false);
            IN iN = in;
            return iN;
        }
        finally {
            if (result != null && result.exactParentFound) {
                result.parent.releaseLatch();
            }
        }
    }

    private IN isRoot(Tree tree, DatabaseImpl db, IN inClone, long lsn) throws DatabaseException {
        RootDoWork rdw = new RootDoWork(db, inClone, lsn);
        return tree.withRootLatchedShared(rdw);
    }

    private void resetPerRunCounters() {
        this.nINsObsoleteThisRun = 0;
        this.nINsCleanedThisRun = 0;
        this.nINsDeadThisRun = 0;
        this.nINsMigratedThisRun = 0;
        this.nLNsObsoleteThisRun = 0;
        this.nLNsCleanedThisRun = 0;
        this.nLNsDeadThisRun = 0;
        this.nLNsMigratedThisRun = 0;
        this.nLNsMarkedThisRun = 0;
        this.nLNQueueHitsThisRun = 0;
        this.nLNsLockedThisRun = 0;
        this.nEntriesReadThisRun = 0;
        this.nRepeatIteratorReadsThisRun = 0L;
    }

    private void accumulatePerRunCounters() {
        this.cleaner.nINsObsolete += this.nINsObsoleteThisRun;
        this.cleaner.nINsCleaned += this.nINsCleanedThisRun;
        this.cleaner.nINsDead += this.nINsDeadThisRun;
        this.cleaner.nINsMigrated += this.nINsMigratedThisRun;
        this.cleaner.nLNsObsolete += this.nLNsObsoleteThisRun;
        this.cleaner.nLNsCleaned += this.nLNsCleanedThisRun;
        this.cleaner.nLNsDead += this.nLNsDeadThisRun;
        this.cleaner.nLNsMigrated += this.nLNsMigratedThisRun;
        this.cleaner.nLNsMarked += this.nLNsMarkedThisRun;
        this.cleaner.nLNQueueHits += this.nLNQueueHitsThisRun;
        this.cleaner.nLNsLocked += this.nLNsLockedThisRun;
        this.cleaner.nRepeatIteratorReads += this.nRepeatIteratorReadsThisRun;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Cleaner name=\"").append(this.name).append("\"/>");
        return sb.toString();
    }

    static {
        $assertionsDisabled = !FileProcessor.class.desiredAssertionStatus();
    }

    private static class LookAheadCache {
        private SortedMap map = new TreeMap();
        private int maxMem;
        private int usedMem;

        LookAheadCache(int lookAheadCacheSize) {
            this.maxMem = lookAheadCacheSize;
            this.usedMem = MemoryBudget.TREEMAP_OVERHEAD;
        }

        boolean isEmpty() {
            return this.map.isEmpty();
        }

        boolean isFull() {
            return this.usedMem >= this.maxMem;
        }

        Long nextOffset() {
            return (Long)this.map.firstKey();
        }

        void add(Long lsnOffset, LNInfo info) {
            this.map.put(lsnOffset, info);
            this.usedMem += info.getMemorySize();
            this.usedMem += MemoryBudget.TREEMAP_ENTRY_OVERHEAD;
        }

        LNInfo remove(Long offset) {
            LNInfo info = (LNInfo)this.map.remove(offset);
            if (info != null) {
                this.usedMem -= info.getMemorySize();
                this.usedMem -= MemoryBudget.TREEMAP_ENTRY_OVERHEAD;
            }
            return info;
        }
    }

    private static class RootDoWork
    implements WithRootLatched {
        private DatabaseImpl db;
        private IN inClone;
        private long lsn;

        RootDoWork(DatabaseImpl db, IN inClone, long lsn) {
            this.db = db;
            this.inClone = inClone;
            this.lsn = lsn;
        }

        public IN doWork(ChildReference root) throws DatabaseException {
            if (root == null || root.fetchTarget(this.db, null).getNodeId() != this.inClone.getNodeId()) {
                return null;
            }
            if (DbLsn.compareTo(root.getLsn(), this.lsn) <= 0) {
                IN rootIN = (IN)root.fetchTarget(this.db, null);
                rootIN.latch(false);
                return rootIN;
            }
            return null;
        }
    }
}

