/*
 * Decompiled with CFR 0.152.
 */
package quickfix.mina.acceptor;

import java.net.SocketAddress;
import java.security.GeneralSecurityException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.net.ssl.SSLContext;
import org.apache.mina.common.ByteBuffer;
import org.apache.mina.common.ByteBufferAllocator;
import org.apache.mina.common.IoAcceptor;
import org.apache.mina.common.IoFilter;
import org.apache.mina.common.IoFilterChainBuilder;
import org.apache.mina.common.IoHandler;
import org.apache.mina.common.IoServiceConfig;
import org.apache.mina.common.SimpleByteBufferAllocator;
import org.apache.mina.common.ThreadModel;
import org.apache.mina.common.TransportType;
import org.apache.mina.filter.SSLFilter;
import org.apache.mina.filter.codec.ProtocolCodecFactory;
import org.apache.mina.filter.codec.ProtocolCodecFilter;
import org.apache.mina.transport.socket.nio.SocketAcceptorConfig;
import quickfix.Acceptor;
import quickfix.Application;
import quickfix.ConfigError;
import quickfix.DefaultSessionFactory;
import quickfix.FieldConvertError;
import quickfix.LogFactory;
import quickfix.MessageFactory;
import quickfix.MessageStoreFactory;
import quickfix.RuntimeError;
import quickfix.ScreenLogFactory;
import quickfix.Session;
import quickfix.SessionFactory;
import quickfix.SessionID;
import quickfix.SessionSettings;
import quickfix.mina.CompositeIoFilterChainBuilder;
import quickfix.mina.EventHandlingStrategy;
import quickfix.mina.NetworkingOptions;
import quickfix.mina.ProtocolFactory;
import quickfix.mina.SessionConnector;
import quickfix.mina.acceptor.AcceptorIoHandler;
import quickfix.mina.acceptor.AcceptorSessionProvider;
import quickfix.mina.message.FIXProtocolCodecFactory;
import quickfix.mina.ssl.SSLContextFactory;
import quickfix.mina.ssl.SSLSupport;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSocketAcceptor
extends SessionConnector
implements Acceptor {
    private final Map<SocketAddress, AcceptorSessionProvider> sessionProviders = new HashMap<SocketAddress, AcceptorSessionProvider>();
    private final SessionFactory sessionFactory;
    private final Map<SocketAddress, AcceptorSocketDescriptor> socketDescriptorForAddress = new HashMap<SocketAddress, AcceptorSocketDescriptor>();
    private final Map<TransportType, IoAcceptor> ioAcceptorForTransport = new HashMap<TransportType, IoAcceptor>();

    protected AbstractSocketAcceptor(SessionSettings settings, SessionFactory sessionFactory) throws ConfigError {
        super(settings, sessionFactory);
        ByteBuffer.setAllocator((ByteBufferAllocator)new SimpleByteBufferAllocator());
        ByteBuffer.setUseDirectBuffers((boolean)false);
        this.sessionFactory = sessionFactory;
        try {
            this.createSessions(settings);
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e);
        }
    }

    protected AbstractSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, MessageFactory messageFactory) throws ConfigError {
        this(application, messageStoreFactory, settings, new ScreenLogFactory(settings), messageFactory);
    }

    protected AbstractSocketAcceptor(Application application, MessageStoreFactory messageStoreFactory, SessionSettings settings, LogFactory logFactory, MessageFactory messageFactory) throws ConfigError {
        this(settings, new DefaultSessionFactory(application, messageStoreFactory, logFactory, messageFactory));
    }

    protected synchronized void startAcceptingConnections(EventHandlingStrategy eventHandlingStrategy) throws ConfigError {
        try {
            this.startSessionTimer();
            SessionSettings settings = this.getSettings();
            for (AcceptorSocketDescriptor socketDescriptor : this.socketDescriptorForAddress.values()) {
                IoAcceptor ioAcceptor = this.getIoAcceptor(socketDescriptor.getAddress());
                IoServiceConfig serviceConfig = ioAcceptor.getDefaultConfig();
                CompositeIoFilterChainBuilder ioFilterChainBuilder = new CompositeIoFilterChainBuilder(this.getIoFilterChainBuilder());
                if (socketDescriptor.isUseSSL()) {
                    this.installSSL(socketDescriptor, ioFilterChainBuilder);
                }
                ioFilterChainBuilder.addLast("FIXCodec", (IoFilter)new ProtocolCodecFilter((ProtocolCodecFactory)new FIXProtocolCodecFactory()));
                serviceConfig.setFilterChainBuilder((IoFilterChainBuilder)ioFilterChainBuilder);
                serviceConfig.setThreadModel(ThreadModel.MANUAL);
                AcceptorSessionProvider sessionProvider = this.sessionProviders.get(socketDescriptor.getAddress());
                if (sessionProvider == null) {
                    sessionProvider = new StaticAcceptorSessionProvider(socketDescriptor.getAcceptedSessions());
                }
                if (serviceConfig instanceof SocketAcceptorConfig) {
                    ((SocketAcceptorConfig)serviceConfig).setDisconnectOnUnbind(false);
                }
                ioAcceptor.bind(socketDescriptor.getAddress(), (IoHandler)new AcceptorIoHandler(sessionProvider, new NetworkingOptions(settings.getDefaultProperties()), eventHandlingStrategy));
                this.log.info(new StringBuffer().append("Listening for connections at ").append(socketDescriptor.getAddress()).toString());
            }
        }
        catch (FieldConvertError e) {
            throw new ConfigError(e);
        }
        catch (Exception e) {
            throw new RuntimeError(e);
        }
    }

    private void installSSL(AcceptorSocketDescriptor descriptor, CompositeIoFilterChainBuilder ioFilterChainBuilder) throws GeneralSecurityException {
        this.log.info(new StringBuffer().append("Installing SSL filter for ").append(descriptor.getAddress()).toString());
        SSLContext sslContext = SSLContextFactory.getInstance(descriptor.getKeyStoreName(), descriptor.getKeyStorePassword().toCharArray());
        SSLFilter sslFilter = new SSLFilter(sslContext);
        sslFilter.setUseClientMode(false);
        ioFilterChainBuilder.addLast("SSLFilter", (IoFilter)sslFilter);
    }

    private IoAcceptor getIoAcceptor(SocketAddress address) {
        TransportType transportType = ProtocolFactory.getAddressTransportType(address);
        IoAcceptor ioAcceptor = this.ioAcceptorForTransport.get(transportType);
        if (ioAcceptor == null) {
            ioAcceptor = ProtocolFactory.createIoAcceptor(transportType);
            this.ioAcceptorForTransport.put(transportType, ioAcceptor);
        }
        return ioAcceptor;
    }

    private AcceptorSocketDescriptor getAcceptorSocketDescriptor(SessionSettings settings, SessionID sessionID) throws ConfigError, FieldConvertError {
        SocketAddress acceptorAddress;
        AcceptorSocketDescriptor descriptor;
        TransportType acceptTransportType = TransportType.SOCKET;
        if (settings.isSetting(sessionID, "SocketAcceptProtocol")) {
            try {
                acceptTransportType = TransportType.getInstance((String)settings.getString(sessionID, "SocketAcceptProtocol"));
            }
            catch (IllegalArgumentException e) {
                throw new ConfigError(e);
            }
        }
        boolean useSSL = false;
        String keyStoreName = null;
        String keyStorePassword = null;
        if (this.getSettings().isSetting(sessionID, "SocketUseSSL") && this.getSettings().getBool(sessionID, "SocketUseSSL")) {
            if (acceptTransportType == TransportType.SOCKET) {
                useSSL = true;
                keyStoreName = SSLSupport.getKeystoreName(this.getSettings(), sessionID);
                keyStorePassword = SSLSupport.getKeystorePasswd(this.getSettings(), sessionID);
            } else {
                this.log.warn(new StringBuffer().append("SSL will not be enabled for transport type=").append(acceptTransportType).append(", session=").append(sessionID).toString());
            }
        }
        int acceptPort = (int)settings.getLong(sessionID, "SocketAcceptPort");
        String acceptHost = null;
        if (settings.isSetting(sessionID, "SocketAcceptAddress")) {
            acceptHost = settings.getString(sessionID, "SocketAcceptAddress");
        }
        if ((descriptor = this.socketDescriptorForAddress.get(acceptorAddress = ProtocolFactory.createSocketAddress(acceptTransportType, acceptHost, acceptPort))) != null) {
            if (descriptor.isUseSSL() && !useSSL || !this.equals(descriptor.getKeyStoreName(), keyStoreName) || !this.equals(descriptor.getKeyStorePassword(), keyStorePassword)) {
                throw new ConfigError(new StringBuffer().append("Conflicting configurations of acceptor socket: ").append(acceptorAddress).toString());
            }
        } else {
            descriptor = new AcceptorSocketDescriptor(acceptorAddress, useSSL, keyStoreName, keyStorePassword);
            this.socketDescriptorForAddress.put(acceptorAddress, descriptor);
        }
        return descriptor;
    }

    private boolean equals(Object object1, Object object2) {
        return object1 == null ? object2 == null : object1.equals(object2);
    }

    private void createSessions(SessionSettings settings) throws ConfigError, FieldConvertError {
        HashMap<SessionID, Session> allSessions = new HashMap<SessionID, Session>();
        Iterator<SessionID> i = settings.sectionIterator();
        while (i.hasNext()) {
            SessionID sessionID = i.next();
            String connectionType = settings.getString(sessionID, "ConnectionType");
            boolean isTemplate = false;
            if (settings.isSetting(sessionID, "AcceptorTemplate")) {
                isTemplate = settings.getBool(sessionID, "AcceptorTemplate");
            }
            if (!connectionType.equals("acceptor")) continue;
            AcceptorSocketDescriptor descriptor = this.getAcceptorSocketDescriptor(settings, sessionID);
            if (isTemplate) continue;
            Session session = this.sessionFactory.create(sessionID, settings);
            descriptor.acceptSession(session);
            allSessions.put(sessionID, session);
        }
        this.setSessions(allSessions);
        if (this.socketDescriptorForAddress.size() == 0) {
            throw new ConfigError("No acceptor sessions found in settings.");
        }
    }

    protected void stopAcceptingConnections() {
        for (AcceptorSocketDescriptor socketDescriptor : this.socketDescriptorForAddress.values()) {
            SocketAddress acceptorSocketAddress = socketDescriptor.getAddress();
            this.log.info(new StringBuffer().append("No longer accepting connections on ").append(acceptorSocketAddress).toString());
            IoAcceptor ioAcceptor = this.getIoAcceptor(acceptorSocketAddress);
            if (!ioAcceptor.isManaged(acceptorSocketAddress)) continue;
            ioAcceptor.unbind(acceptorSocketAddress);
        }
        this.ioAcceptorForTransport.clear();
    }

    public Collection<IoAcceptor> getEndpoints() {
        return this.ioAcceptorForTransport.values();
    }

    public Map<SessionID, SocketAddress> getAcceptorAddresses() {
        HashMap<SessionID, SocketAddress> sessionIdToAddressMap = new HashMap<SessionID, SocketAddress>();
        for (AcceptorSocketDescriptor descriptor : this.socketDescriptorForAddress.values()) {
            Iterator<SessionID> sessionIDs = descriptor.getAcceptedSessions().keySet().iterator();
            while (sessionIDs.hasNext()) {
                sessionIdToAddressMap.put(sessionIDs.next(), descriptor.getAddress());
            }
        }
        return sessionIdToAddressMap;
    }

    public void setSessionProvider(SocketAddress address, AcceptorSessionProvider provider) {
        this.sessionProviders.put(address, provider);
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class StaticAcceptorSessionProvider
    implements AcceptorSessionProvider {
        private final Map<SessionID, Session> acceptorSessions;

        public StaticAcceptorSessionProvider(Map<SessionID, Session> acceptorSessions) {
            this.acceptorSessions = acceptorSessions;
        }

        @Override
        public Session getSession(SessionID sessionID) {
            return this.acceptorSessions.get(sessionID);
        }
    }

    /*
     * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AcceptorSocketDescriptor {
        private final SocketAddress address;
        private final boolean useSSL;
        private final String keyStoreName;
        private final String keyStorePassword;
        private final Map<SessionID, Session> acceptedSessions = new HashMap<SessionID, Session>();

        public AcceptorSocketDescriptor(SocketAddress address, boolean useSSL, String keyStoreName, String keyStorePassword) {
            this.address = address;
            this.useSSL = useSSL;
            this.keyStoreName = keyStoreName;
            this.keyStorePassword = keyStorePassword;
        }

        public void acceptSession(Session session) {
            this.acceptedSessions.put(session.getSessionID(), session);
        }

        public Map<SessionID, Session> getAcceptedSessions() {
            return Collections.unmodifiableMap(this.acceptedSessions);
        }

        public SocketAddress getAddress() {
            return this.address;
        }

        public String getKeyStoreName() {
            return this.keyStoreName;
        }

        public String getKeyStorePassword() {
            return this.keyStorePassword;
        }

        public boolean isUseSSL() {
            return this.useSSL;
        }
    }
}

