/*
 * Decompiled with CFR 0.152.
 */
package quickfix;

import java.io.ByteArrayOutputStream;
import java.text.DecimalFormat;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import quickfix.DataDictionary;
import quickfix.Field;
import quickfix.FieldException;
import quickfix.FieldMap;
import quickfix.FieldNotFound;
import quickfix.Group;
import quickfix.InvalidMessage;
import quickfix.MessageParseError;
import quickfix.MessageUtils;
import quickfix.SessionID;
import quickfix.StringField;
import quickfix.field.BodyLength;
import quickfix.field.CheckSum;
import quickfix.field.MsgType;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Message
extends FieldMap {
    static final long serialVersionUID = -3193357271891865972L;
    protected Header header = new Header();
    protected Trailer trailer = new Trailer();
    private FieldException exception;
    private static DecimalFormat checksumFormat = new DecimalFormat("000");
    private String messageData;
    private int position;
    private StringField pushedBackField;

    public Message() {
    }

    protected Message(int[] fieldOrder) {
        super(fieldOrder);
    }

    public Message(String string) throws InvalidMessage {
        this.fromString(string, null, true);
    }

    public Message(String string, boolean validate) throws InvalidMessage {
        this.fromString(string, null, validate);
    }

    public Message(String string, DataDictionary dd) throws InvalidMessage {
        this.fromString(string, dd, true);
    }

    public Message(String string, DataDictionary dd, boolean validate) throws InvalidMessage {
        this.fromString(string, dd, validate);
    }

    public static boolean InitializeXML(String url) {
        throw new UnsupportedOperationException();
    }

    public Object clone() {
        try {
            Message message = (Message)this.getClass().newInstance();
            return this.cloneTo(message);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private Object cloneTo(Message message) {
        message.initializeFrom(this);
        message.header.initializeFrom(this.getHeader());
        message.trailer.initializeFrom(this.getTrailer());
        return message;
    }

    public String toString() {
        this.header.setField(new BodyLength(this.bodyLength()));
        this.trailer.setField(new CheckSum(this.checkSum()));
        StringBuffer sb = new StringBuffer();
        this.header.calculateString(sb, null, null);
        this.calculateString(sb, null, null);
        this.trailer.calculateString(sb, null, null);
        return sb.toString();
    }

    public int bodyLength() {
        return this.header.calculateLength() + this.calculateLength() + this.trailer.calculateLength();
    }

    private int checkSum(String s) {
        int offset = s.lastIndexOf("\u000110=");
        int sum = 0;
        for (int i = 0; i < offset; ++i) {
            sum += s.charAt(i);
        }
        return (sum + 1) % 256;
    }

    private String checkSum() {
        return checksumFormat.format((this.header.calculateTotal() + this.calculateTotal() + this.trailer.calculateTotal()) % 256);
    }

    public void headerAddGroup(Group group) {
        this.header.addGroup(group);
    }

    public void headerReplaceGroup(int num, Group group) {
        this.header.replaceGroup(num, group);
    }

    public Group headerGetGroup(int num, Group group) throws FieldNotFound {
        return this.header.getGroup(num, group);
    }

    public void headerRemoveGroup(Group group) {
        this.header.removeGroup(group);
    }

    public boolean headerHasGroup(int field) {
        return this.header.hasGroup(field);
    }

    public boolean headerHasGroup(int num, int field) {
        return this.header.hasGroup(num, field);
    }

    public boolean headerHasGroup(int num, Group group) {
        return this.headerHasGroup(num, group.getFieldTag());
    }

    public boolean headerHasGroup(Group group) {
        return this.headerHasGroup(group.getFieldTag());
    }

    public void trailerAddGroup(Group group) {
        this.trailer.addGroup(group);
    }

    public Group trailerGetGroup(int num, Group group) throws FieldNotFound {
        return this.trailer.getGroup(num, group);
    }

    public void trailerReplaceGroup(int num, Group group) {
        this.trailer.replaceGroup(num, group);
    }

    public void trailerRemoveGroup(Group group) {
        this.trailer.removeGroup(group);
    }

    public boolean trailerHasGroup(int field) {
        return this.trailer.hasGroup(field);
    }

    public boolean trailerHasGroup(int num, int field) {
        return this.trailer.hasGroup(num, field);
    }

    public boolean trailerHasGroup(int num, Group group) {
        return this.trailerHasGroup(num, group.getFieldTag());
    }

    public boolean trailerHasGroup(Group group) {
        return this.trailerHasGroup(group.getFieldTag());
    }

    public String toXML() {
        return this.toXML(null);
    }

    public String toXML(DataDictionary dataDictionary) {
        try {
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Element message = document.createElement("message");
            document.appendChild(message);
            this.toXMLFields(message, "header", this.header, dataDictionary);
            this.toXMLFields(message, "body", this, dataDictionary);
            this.toXMLFields(message, "trailer", this.trailer, dataDictionary);
            DOMSource domSource = new DOMSource(document);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(out);
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer serializer = tf.newTransformer();
            serializer.setOutputProperty("encoding", "ISO-8859-1");
            serializer.setOutputProperty("indent", "yes");
            serializer.transform(domSource, streamResult);
            return out.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void toXMLFields(Element message, String section, FieldMap fieldMap, DataDictionary dataDictionary) throws FieldNotFound {
        Document document = message.getOwnerDocument();
        Element fields = document.createElement(section);
        message.appendChild(fields);
        Iterator<Field<?>> fieldItr = fieldMap.iterator();
        while (fieldItr.hasNext()) {
            Field<?> field = fieldItr.next();
            Element fieldElement = document.createElement("field");
            if (dataDictionary != null) {
                String enumValue;
                String name = dataDictionary.getFieldName(field.getTag());
                if (name != null) {
                    fieldElement.setAttribute("name", name);
                }
                if ((enumValue = dataDictionary.getValueName(field.getTag(), field.getObject().toString())) != null) {
                    fieldElement.setAttribute("enum", enumValue);
                }
            }
            fieldElement.setAttribute("tag", Integer.toString(field.getTag()));
            CDATASection value = document.createCDATASection(field.getObject().toString());
            fieldElement.appendChild(value);
            fields.appendChild(fieldElement);
        }
        Iterator<Integer> groupKeyItr = fieldMap.groupKeyIterator();
        while (groupKeyItr.hasNext()) {
            String name;
            int groupKey = groupKeyItr.next();
            Element groupsElement = document.createElement("groups");
            fields.appendChild(groupsElement);
            if (dataDictionary != null && (name = dataDictionary.getFieldName(groupKey)) != null) {
                groupsElement.setAttribute("name", name);
            }
            groupsElement.setAttribute("tag", Integer.toString(groupKey));
            List<Group> groups = fieldMap.getGroups(groupKey);
            for (Group group : groups) {
                this.toXMLFields(groupsElement, "group", group, dataDictionary);
            }
        }
    }

    public final Header getHeader() {
        return this.header;
    }

    public final Trailer getTrailer() {
        return this.trailer;
    }

    public boolean isAdmin() {
        if (this.header.isSetField(35)) {
            try {
                String msgType = this.header.getString(35);
                return msgType.length() == 1 && "0A12345".indexOf(msgType.charAt(0)) != -1;
            }
            catch (FieldNotFound fieldNotFound) {
                // empty catch block
            }
        }
        return false;
    }

    public boolean isApp() {
        return !this.isAdmin();
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.header.isEmpty() && this.trailer.isEmpty();
    }

    @Override
    public void clear() {
        super.clear();
        this.header.clear();
        this.trailer.clear();
    }

    public void reverseRoute(Header header) throws FieldNotFound {
        this.header.removeField(8);
        this.header.removeField(49);
        this.header.removeField(50);
        this.header.removeField(142);
        this.header.removeField(56);
        this.header.removeField(57);
        this.header.removeField(143);
        if (header.isSetField(8)) {
            this.copyField(header, 8, 8);
            this.copyField(header, 49, 56);
            this.copyField(header, 50, 57);
            this.copyField(header, 142, 143);
            this.copyField(header, 56, 49);
            this.copyField(header, 57, 50);
            this.copyField(header, 143, 142);
            this.header.removeField(115);
            this.header.removeField(116);
            this.header.removeField(128);
            this.header.removeField(129);
            this.copyField(header, 115, 128);
            this.copyField(header, 116, 129);
            this.copyField(header, 128, 115);
            this.copyField(header, 129, 116);
            this.header.removeField(144);
            this.header.removeField(145);
            if (header.getString(8).compareTo("FIX.4.1") >= 0) {
                this.copyField(header, 144, 145);
                this.copyField(header, 145, 144);
            }
        }
    }

    private void copyField(Header header, int fromField, int toField) throws FieldNotFound {
        String value;
        if (header.isSetField(fromField) && (value = header.getString(fromField)).length() > 0) {
            this.header.setString(toField, value);
        }
    }

    void setSessionID(SessionID sessionID) {
        this.header.setString(8, sessionID.getBeginString());
        this.header.setString(49, sessionID.getSenderCompID());
        this.optionallySetID(this.header, 50, sessionID.getSenderSubID());
        this.optionallySetID(this.header, 142, sessionID.getSenderLocationID());
        this.header.setString(56, sessionID.getTargetCompID());
        this.optionallySetID(this.header, 57, sessionID.getTargetSubID());
        this.optionallySetID(this.header, 143, sessionID.getTargetLocationID());
    }

    private void optionallySetID(Header header, int field, String value) {
        if (!value.equals("")) {
            header.setString(field, value);
        }
    }

    public void fromString(String messageData, DataDictionary dd, boolean doValidation) throws InvalidMessage {
        this.parse(messageData, dd, dd, doValidation);
    }

    public void fromString(String messageData, DataDictionary sessionDictionary, DataDictionary applicationDictionary, boolean doValidation) throws InvalidMessage {
        if (MessageUtils.isAdminMessage(MessageUtils.getMessageType(messageData))) {
            applicationDictionary = sessionDictionary;
        }
        this.parse(messageData, sessionDictionary, applicationDictionary, doValidation);
    }

    void parse(String messageData, DataDictionary sessionDataDictionary, DataDictionary applicationDataDictionary, boolean doValidation) throws InvalidMessage {
        this.messageData = messageData;
        try {
            this.parseHeader(sessionDataDictionary, doValidation);
            this.parseBody(applicationDataDictionary);
            this.parseTrailer(sessionDataDictionary);
            if (doValidation) {
                this.validateCheckSum(messageData);
            }
        }
        catch (FieldException e) {
            this.exception = e;
        }
    }

    private void validateCheckSum(String messageData) throws InvalidMessage {
        try {
            int checkSum = this.trailer.getInt(10);
            if (checkSum != this.checkSum(messageData)) {
                throw new InvalidMessage(new StringBuffer().append("Expected CheckSum=").append(this.checkSum(messageData)).append(", Received CheckSum=").append(checkSum).toString());
            }
        }
        catch (FieldNotFound e) {
            throw new InvalidMessage(new StringBuffer().append("Field not found: ").append(e.field).toString());
        }
    }

    private void parseHeader(DataDictionary dd, boolean doValidation) throws InvalidMessage {
        boolean validHeaderFieldOrder;
        boolean bl = validHeaderFieldOrder = this.isNextField(dd, this.header, 8) && this.isNextField(dd, this.header, 9) && this.isNextField(dd, this.header, 35);
        if (doValidation && !validHeaderFieldOrder) {
            throw new InvalidMessage("Header fields out of order");
        }
        StringField field = this.extractField(dd, this.header);
        while (field != null && Message.isHeaderField(field, dd)) {
            this.header.setField(field);
            if (dd != null && dd.isGroup("HEADER", field.getField())) {
                this.parseGroup("HEADER", field, dd, this.header);
            }
            field = this.extractField(dd, this.header);
        }
        this.pushBack(field);
    }

    private boolean isNextField(DataDictionary dd, Header fields, int tag) throws InvalidMessage {
        StringField field = this.extractField(dd, this.header);
        if (field == null || field.getTag() != tag) {
            return false;
        }
        fields.setField(field);
        return true;
    }

    private String getMsgType() throws InvalidMessage {
        String res = null;
        try {
            res = this.header.getString(35);
        }
        catch (FieldNotFound e) {
            throw new InvalidMessage(e.getMessage());
        }
        return res;
    }

    private void parseBody(DataDictionary dd) throws InvalidMessage {
        StringField field = this.extractField(dd, this);
        while (field != null) {
            if (Message.isTrailerField(field.getField())) {
                this.pushBack(field);
                return;
            }
            if (Message.isHeaderField(field.getField())) {
                this.setField(this.header, field);
                throw new FieldException(14, field.getTag());
            }
            this.setField(this, field);
            if (dd != null && dd.isGroup(this.getMsgType(), field.getField())) {
                this.parseGroup(this.getMsgType(), field, dd, this);
            }
            field = this.extractField(dd, this);
        }
    }

    private void setField(FieldMap fields, StringField field) {
        if (fields.isSetField(field)) {
            throw new FieldException(13, field.getTag());
        }
        fields.setField(field);
    }

    private void parseGroup(String msgType, StringField field, DataDictionary dd, FieldMap parent) throws InvalidMessage {
        DataDictionary.GroupInfo rg = dd.getGroup(msgType, field.getField());
        DataDictionary groupDataDictionary = rg.getDataDictionary();
        int[] fieldOrder = groupDataDictionary.getOrderedFields();
        int previousOffset = -1;
        int groupCountTag = field.getField();
        int declaredGroupCount = Integer.parseInt(field.getValue());
        parent.setField(groupCountTag, field);
        int firstField = rg.getDelimeterField();
        boolean firstFieldFound = false;
        Group group = null;
        boolean inGroupParse = true;
        while (inGroupParse) {
            field = this.extractField(group, dd, parent);
            if (field.getTag() == firstField) {
                if (group != null) {
                    parent.addGroup(group);
                }
                group = new Group(groupCountTag, firstField, groupDataDictionary.getOrderedFields());
                group.setField(field);
                firstFieldFound = true;
                previousOffset = -1;
                continue;
            }
            if (groupDataDictionary.isGroup(msgType, field.getField())) {
                if (firstFieldFound) {
                    this.parseGroup(msgType, field, groupDataDictionary, group);
                    continue;
                }
                throw new InvalidMessage(new StringBuffer().append("The group ").append(groupCountTag).append(" must set the delimiter field ").append(firstField).toString());
            }
            if (groupDataDictionary.isField(field.getTag())) {
                int offset;
                if (!firstFieldFound) {
                    throw new FieldException(15, field.getTag());
                }
                if (fieldOrder != null && dd.isCheckFieldsOutOfOrder() && (offset = this.index(fieldOrder, field.getTag())) >= 0) {
                    if (offset > previousOffset) {
                        previousOffset = offset;
                    } else {
                        throw new FieldException(15, field.getTag());
                    }
                }
                group.setField(field);
                continue;
            }
            if (group != null) {
                parent.addGroup(group);
            }
            this.pushBack(field);
            inGroupParse = false;
        }
        parent.setGroupCount(groupCountTag, declaredGroupCount);
    }

    private int index(int[] fieldOrder, int tag) {
        for (int i = 0; i < fieldOrder.length; ++i) {
            if (fieldOrder[i] != tag) continue;
            return i;
        }
        return -1;
    }

    private void parseTrailer(DataDictionary dd) throws InvalidMessage {
        StringField field = this.extractField(dd, this.trailer);
        while (field != null) {
            if (!Message.isTrailerField(field, dd)) {
                throw new FieldException(14, field.getTag());
            }
            this.trailer.setField(field);
            field = this.extractField(dd, this.trailer);
        }
    }

    static boolean isHeaderField(Field<?> field, DataDictionary dd) {
        return Message.isHeaderField(field.getField()) || dd != null && dd.isHeaderField(field.getField());
    }

    static boolean isHeaderField(int field) {
        switch (field) {
            case 8: 
            case 9: 
            case 34: 
            case 35: 
            case 43: 
            case 49: 
            case 50: 
            case 52: 
            case 56: 
            case 57: 
            case 90: 
            case 97: 
            case 115: 
            case 116: 
            case 122: 
            case 128: 
            case 129: 
            case 142: 
            case 143: 
            case 144: 
            case 145: 
            case 212: 
            case 213: 
            case 347: 
            case 369: 
            case 370: 
            case 1128: 
            case 1129: {
                return true;
            }
        }
        return false;
    }

    static boolean isTrailerField(Field<?> field, DataDictionary dd) {
        return Message.isTrailerField(field.getField()) || dd != null && dd.isTrailerField(field.getField());
    }

    static boolean isTrailerField(int field) {
        switch (field) {
            case 10: 
            case 89: 
            case 93: {
                return true;
            }
        }
        return false;
    }

    public void pushBack(StringField field) {
        this.pushedBackField = field;
    }

    private StringField extractField(DataDictionary dataDictionary, FieldMap fields) throws InvalidMessage {
        return this.extractField(null, dataDictionary, fields);
    }

    private StringField extractField(Group group, DataDictionary dataDictionary, FieldMap fields) throws InvalidMessage {
        if (this.pushedBackField != null) {
            StringField f = this.pushedBackField;
            this.pushedBackField = null;
            return f;
        }
        if (this.position >= this.messageData.length()) {
            return null;
        }
        int equalsOffset = this.messageData.indexOf(61, this.position);
        if (equalsOffset == -1) {
            throw new InvalidMessage("Equal sign not found in field");
        }
        int tag = -1;
        try {
            tag = Integer.parseInt(this.messageData.substring(this.position, equalsOffset));
        }
        catch (NumberFormatException e) {
            this.position = this.messageData.indexOf(1, this.position + 1) + 1;
            throw new InvalidMessage(new StringBuffer().append("bad tag format: ").append(e.getMessage()).toString());
        }
        int sohOffset = this.messageData.indexOf(1, equalsOffset + 1);
        if (sohOffset == -1) {
            throw new InvalidMessage(new StringBuffer().append("SOH not found at end of field: ").append(tag).toString());
        }
        if (dataDictionary != null && dataDictionary.isDataField(tag)) {
            int fieldLength;
            int lengthField = tag - 1;
            if (tag == 89) {
                lengthField = 93;
            }
            try {
                fieldLength = group == null ? fields.getInt(lengthField) : group.getInt(lengthField);
            }
            catch (FieldNotFound e1) {
                throw new InvalidMessage(new StringBuffer().append("Tag ").append(e1.field).append(" not found.").toString());
            }
            sohOffset = equalsOffset + 1 + fieldLength;
        }
        this.position = sohOffset + 1;
        return new StringField(tag, this.messageData.substring(equalsOffset + 1, sohOffset));
    }

    synchronized boolean hasValidStructure() {
        return this.exception == null;
    }

    public synchronized FieldException getException() {
        return this.exception;
    }

    synchronized int getInvalidTag() {
        return this.exception != null ? this.exception.getField() : 0;
    }

    public static MsgType identifyType(String message) throws MessageParseError {
        try {
            return new MsgType(MessageUtils.getMessageType(message));
        }
        catch (InvalidMessage e) {
            throw new MessageParseError(e.getMessage(), e);
        }
    }

    public static class Trailer
    extends FieldMap {
        static final long serialVersionUID = -3193357271891865972L;
        private static final int[] TRAILER_FIELD_ORDER = new int[]{93, 89, 10};

        public Trailer() {
            super(TRAILER_FIELD_ORDER);
        }

        protected void calculateString(StringBuffer buffer, int[] excludedFields, int[] postFields) {
            super.calculateString(buffer, null, new int[]{10});
        }
    }

    public static class Header
    extends FieldMap {
        static final long serialVersionUID = -3193357271891865972L;
        private static final int[] EXCLUDED_HEADER_FIELDS = new int[]{8, 9, 35};

        protected void calculateString(StringBuffer buffer, int[] excludedFields, int[] postFields) {
            super.calculateString(buffer, EXCLUDED_HEADER_FIELDS, postFields);
        }
    }
}

