/*
 * Decompiled with CFR 0.152.
 */
package mx4j.loading;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.StreamCorruptedException;
import java.lang.reflect.Proxy;

public class ClassLoaderObjectInputStream
extends ObjectInputStream {
    private ClassLoader classLoader;

    public ClassLoaderObjectInputStream(InputStream stream, ClassLoader classLoader) throws IOException, StreamCorruptedException {
        super(stream);
        this.classLoader = classLoader;
    }

    protected Class resolveClass(ObjectStreamClass osc) throws IOException, ClassNotFoundException {
        String name = osc.getName();
        return this.loadClass(name);
    }

    protected Class resolveProxyClass(String[] interfaces) throws IOException, ClassNotFoundException {
        Class[] classes = new Class[interfaces.length];
        for (int i = 0; i < interfaces.length; ++i) {
            classes[i] = this.loadClass(interfaces[i]);
        }
        return Proxy.getProxyClass(this.classLoader, classes);
    }

    private Class loadClass(String name) throws ClassNotFoundException {
        if (this.classLoader != null) {
            return this.classLoader.loadClass(name);
        }
        return Class.forName(name, true, null);
    }
}

