.\" Copyright 1993, 1994, 1998  The Open Group
.\" Portions copyright 1988 Evans & Sutherland Computer Corporation.
.\" Portions copyright 1989 Hewlett-Packard Company
.\" Portions copyright 2003-2011 Apple Inc.  All rights reserved.
.\" 
.\" Permission to use, copy, modify, distribute, and sell this software and its
.\" documentation for any purpose is hereby granted without fee, provided that
.\" the above copyright notice appear in all copies and that both that
.\" copyright notice and this permission notice appear in supporting
.\" documentation.
.\" 
.\" The above copyright notice and this permission notice shall be included
.\" in all copies or substantial portions of the Software.
.\" 
.\" THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
.\" OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
.\" MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
.\" IN NO EVENT SHALL THE OPEN GROUP BE LIABLE FOR ANY CLAIM, DAMAGES OR
.\" OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE,
.\" ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
.\" OTHER DEALINGS IN THE SOFTWARE.
.\" 
.\" Except as contained in this notice, the name of The Open Group shall
.\" not be used in advertising or otherwise to promote the sale, use or
.\" other dealings in this Software without prior written authorization
.\" from The Open Group.
.\"
.\"
.Dd May 13, 2011
.Dt quartz-wm 1
.Os
.Sh NAME
.Nm quartz-wm
.Nd Aqua Window Manager for the X Window System on OS X
.Sh SYNOPSIS
.Nm
.Op Fl -prefs-domain Ar domain
.Sh DESCRIPTION
.Nm
is a window manager for the X Window System. It provides titlebars for 
X11 windows that aim to match the look and feel of native
.Ar Mac OS X
windows.
.Pp
The following options are available:
.Bl -tag -width indent
.It Fl -prefs-domain Ar domain
This option can be used to override the domain used to read preferences
from.  This is useful if you want to have multiple X11.apps running at
the same time.
.El
.Sh CUSTOMIZATION
.Nm
can be customized using the
.Xr defaults 1
command.  Examples are shown using the default __bundle_id_prefix__.X11 domain.  If you
use another domain (either through the X11_PREFS_DOMAIN environment
variable or the --prefs-domain command line argument), then you need
to substitute that instead.
.Nm
can be forced to re-read these preferences by sending it a SIGHUP using 
.Xr kill 1 .
.Pp
The available options are:
.Pp
.Bl -tag -width indent
.It defaults write __bundle_id_prefix__.X11 wm_ffm -bool true
Enables focus-follows-mouse mode. Windows belonging to the X server may
then be focused by moving the pointer over them, as well as the default
mode of clicking in them.
.It defaults write __bundle_id_prefix__.X11 wm_click_through -bool true
Disables the default behavior of swallowing window-activating mouse events.
.It defaults write __bundle_id_prefix__.X11 wm_limit_size -bool true
Limit the size of each window to the size of the current head.
.It defaults write __bundle_id_prefix__.x11 wm_focus_on_new_window -bool false
Don't tell X11.app to take focus when a new X11 window is created.
.It defaults write __bundle_id_prefix__.X11 wm_window_shading -bool true
Enables double clicking on a titlebar to shade the window
.It defaults write __bundle_id_prefix__.X11 wm_auto_quit -bool true
Automatically quit
.Nm
(thus shutting down the X11 server) when the last window is closed.
.It defaults write __bundle_id_prefix__.X11 wm_auto_quit_timeout -int 3
Set the timeout for the auto-quit feature.  If wm_auto_quit is true, quartz-wm
will wait this many seconds before attempting to shutdown.  If another window
is created in that time, quartz-wm will not shutdown.
.It defaults write __bundle_id_prefix__.X11 wm_show_shortcut -bool true
Show each window's key equivalent, if it has one, in its title bar.
.El
.Sh LOGGING
.Pp
quartz-wm sends messages to
.Xr syslogd 8
using
.Xr asl 3 .
These logs are sent to the __bundle_id_prefix__ facility, and you can watch
these logs using the following
.Xr syslog 1
command:
.Bl -tag -width indent
.It $ syslog -w -k Facility eq __bundle_id_prefix__
.El
.Pp
By default, debugging logs are filtered out.  You can adjust the filter to
print debugging information for the running quartz-wm with this
.Xr
syslog 1
command
.Bl -tag -width indent
.It $ syslog -c quartz-wm -d
.El
.Pp
See
.Xr syslog 1
or
.Xr asl 3
for more information on syslog filtering.
.Sh ENVIRONMENT VARIABLES
.Pp
.Bl -tag -width indent
.It DISPLAY
This variable is used to determine which X server to use.
.It X11_PREFS_DOMAIN
This variable is used as Ar domain if the Fl -prefs-domain command line option
is not given.  If neither Fl -prefs-domain nor X11_PREFS_DOMAIN are set, then
the default value of __bundle_id_prefix__.X11 is used instead.
.It DEBUG
If this variable is set, debug logging will be printed to stderr in addition to asl.
.El
.Sh SEE ALSO
.Xr X 7 ,
.Xr Xquartz 1 ,
.Xr xpbproxy 1 ,
.Xr xrdb 1 ,
.Xr twm 1
