"""
***************************************************************************
    acceptable_missing_doc.py
    ---------------------
    Date                 : March 2016
    Copyright            : (C) 2016 by Stéphane Brunner
    Email                : stephane dot brunner at camptocamp dot com
***************************************************************************
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
***************************************************************************
"""

__author__ = 'Stéphane Brunner'
__date__ = 'March 2016'
__copyright__ = '(C) 2016, Stéphane Brunner'

# -*- coding: utf-8 -*-
"""
The list of acceptable documentation missing
"""
__author__ = 'Stéphane Brunner'
__date__ = '18/03/2016'
__copyright__ = 'Copyright 2016, The QGIS Project'

ACCEPTABLE_MISSING_DOCS = {
    "QgsGeometryLineIntersectionCheck": ["QgsGeometryLineIntersectionCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()"],
    "QgsRangeConfigDlg": ["rangeWidgetChanged(int index)", "QgsRangeConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)"],
    "QgsFeatureListViewDelegate": ["setEditSelectionModel(QItemSelectionModel *editSelectionModel)", "positionToElement(QPoint pos)", "editButtonClicked(QModelIndex &index)", "setFeatureSelectionModel(QgsFeatureSelectionModel *featureSelectionModel)", "Element", "QgsFeatureListViewDelegate(QgsFeatureListModel *listModel, QObject *parent=nullptr)", "setCurrentFeatureEdited(bool state)"],
    "QgsPenStyleComboBox": ["iconForPen(Qt::PenStyle style)", "QgsPenStyleComboBox(QWidget *parent=nullptr)", "penStyle() const", "setPenStyle(Qt::PenStyle style)"],
    "QgsRelationReferenceFactory": ["QgsRelationReferenceFactory(const QString &name, QgsMapCanvas *canvas, QgsMessageBar *messageBar)"],
    "QgsVectorLayerSelectionManager": ["QgsVectorLayerSelectionManager(QgsVectorLayer *layer, QObject *parent=nullptr)"],
    "QgsAuthMethodConfig": ["setMethod(const QString &method)", "setUri(const QString &uri)"],
    "QgsRuleBasedLabeling": ["rootRule()", "rootRule() const"],
    "QgsDrawSourceWidget": ["QgsDrawSourceWidget(QWidget *parent=nullptr)", "create()"],
    "QgsLegendSymbolItem": ["QgsLegendSymbolItem(const QgsLegendSymbolItem &other)"],
    "QgsMeshDatasetGroupProxyModel": ["QgsMeshDatasetGroupProxyModel(QAbstractItemModel *sourceModel)"],
    "QgsStyleManagerDialog": ["editColorRamp()", "currentItemType()", "editSymbol()", "currentItemName()"],
    "QgsDirectoryItem": ["directoryChanged()"],
    "QgsSymbolLayer": ["drawPreviewIcon(QgsSymbolRenderContext &context, QSize size)=0", "setMapUnitScale(const QgsMapUnitScale &scale)", "type() const", "mapUnitScale() const", "ogrFeatureStyle(double mmScaleFactor, double mapUnitScaleFactor) const"],
    "QgsGraduatedSymbolRenderer": ["sortByLabel(Qt::SortOrder order=Qt::AscendingOrder)", "deleteAllClasses()", "updateRangeLabel(int rangeIndex, const QString &label)", "updateRangeLowerValue(int rangeIndex, double value)", "updateRangeSymbol(int rangeIndex, QgsSymbol *symbol)", "updateRangeUpperValue(int rangeIndex, double value)", "sortByValue(Qt::SortOrder order=Qt::AscendingOrder)", "addClass(QgsSymbol *symbol)", "updateRangeRenderState(int rangeIndex, bool render)", "QgsGraduatedSymbolRenderer(const QString &attrName=QString(), const QgsRangeList &ranges=QgsRangeList())", "deleteClass(int idx)"],
    "QgsGeometryAngleCheck": ["factoryDescription()", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()", "QgsGeometryAngleCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)"],
    "QgsMapRendererSequentialJob": ["internalFinished()", "QgsMapRendererSequentialJob(const QgsMapSettings &settings)"],
    "QgsLayerTreeRegistryBridge": ["groupWillRemoveChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "layersWillBeRemoved(const QStringList &layerIds)", "layersAdded(const QList< QgsMapLayer * > &layers)", "groupRemovedChildren()", "setNewLayersVisible(bool enabled)", "isEnabled() const", "removeLayersFromRegistry(const QStringList &layerIds)", "setEnabled(bool enabled)", "newLayersVisible() const"],
    "QgsDirectoryParamWidget": ["showHideColumn()", "QgsDirectoryParamWidget(const QString &path, QWidget *parent=nullptr)"],
    "QgsDiagramRenderer": ["diagram() const", "QgsDiagramRenderer(const QgsDiagramRenderer &other)", "rendererName() const =0", "setDiagram(QgsDiagram *d)"],
    "QgsVectorLayer": ["vectorJoins() const", "setDiagramLayerSettings(const QgsDiagramLayerSettings &s)", "diagramLayerSettings() const", "diagramRenderer() const"],
    "QgsRelationReferenceConfigDlg": ["QgsRelationReferenceConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)"],
    "QgsDial": ["setMaximum(const QVariant &max)", "setSingleStep(const QVariant &step)", "setValue(const QVariant &value)", "variantValue() const", "valueChanged(const QVariant &)", "setMinimum(const QVariant &min)"],
    "QgsHillshadeFilter": ["lightAzimuth() const", "setLightAngle(float angle)", "QgsHillshadeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat, double lightAzimuth=300, double lightAngle=40)", "lightAngle() const", "setLightAzimuth(float azimuth)"],
    "QgsClipToMinMaxEnhancement": ["QgsClipToMinMaxEnhancement(Qgis::DataType, double, double)"],
    "QgsRenderChecker": ["setElapsedTimeTarget(int target)", "setControlPathSuffix(const QString &name)", "setMapSettings(const QgsMapSettings &mapSettings)"],
    "QgsDateTimeEditConfig": ["QgsDateTimeEditConfig(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsGeometryDuplicateCheck": ["factoryDescription()", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()", "QgsGeometryDuplicateCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)"],
    "QgsVectorLayerRenderer": ["QgsVectorLayerRenderer(QgsVectorLayer *layer, QgsRenderContext &context)"],
    "QgsGeometrySliverPolygonCheck": ["QgsGeometrySliverPolygonCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryId()", "factoryDescription()"],
    "QgsRendererRange": ["QgsRendererRange(const QgsRendererRange &range)", "operator<(const QgsRendererRange &other) const", "swap(QgsRendererRange &other)"],
    "QgsRasterMinMaxWidget": ["setBands(const QList< int > &bands)"],
    "QgsDataDefinedWidthDialog": ["QgsDataDefinedWidthDialog(const QList< QgsSymbol * > &symbolList, QgsVectorLayer *layer)"],
    "QgsVectorLayerEditBuffer": ["attributeDeleted(int idx)", "committedFeaturesRemoved(const QString &layerId, const QgsFeatureIds &deletedFeatureIds)", "updateLayerFields()", "committedAttributesAdded(const QString &layerId, const QList< QgsField > &addedAttributes)", "QgsVectorLayerEditBuffer(QgsVectorLayer *layer)", "attributeValueChanged(QgsFeatureId fid, int idx, const QVariant &)", "undoIndexChanged(int index)", "committedGeometriesChanges(const QString &layerId, const QgsGeometryMap &changedGeometries)", "committedFeaturesAdded(const QString &layerId, const QgsFeatureList &addedFeatures)", "featureAdded(QgsFeatureId fid)", "committedAttributeValuesChanges(const QString &layerId, const QgsChangedAttributesMap &changedAttributesValues)", "attributeAdded(int idx)", "featureDeleted(QgsFeatureId fid)"],
    "QgsLinearMinMaxEnhancement": ["QgsLinearMinMaxEnhancement(Qgis::DataType, double, double)"],
    "QgsVectorLayerEditUtils": ["QgsVectorLayerEditUtils(QgsVectorLayer *layer)"],
    "QgsPointLocator_VisitorNearestEdge": ["QgsPointLocator_VisitorNearestEdge(QgsPointLocator *pl, QgsPointLocator::Match &m, const QgsPointXY &srcPoint, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "QgsFieldCalculator": ["QgsFieldCalculator(QgsVectorLayer *vl, QWidget *parent=nullptr)"],
    "QgsLayerTreeGroup": ["QgsLayerTreeGroup(const QgsLayerTreeGroup &other)", "nodeVisibilityChanged(QgsLayerTreeNode *node)"],
    "QgsLongLongValidator": ["QgsLongLongValidator(qint64 bottom, qint64 top, QObject *parent)", "setRange(qint64 bottom, qint64 top)", "setBottom(qint64 bottom)", "setTop(qint64 top)", "QgsLongLongValidator(QObject *parent)", "bottom() const", "top() const"],
    "QgsScopeLogger": ["QgsScopeLogger(const char *file, const char *func, int line)"],
    "QgsPythonRunner": ["evalCommand(QString command, QString &result)=0", "runCommand(QString command, QString messageOnError=QString())=0"],
    "QgsAttributeActionDialog": ["init(const QgsActionManager &action, const QgsAttributeTableConfig &attributeTableConfig)", "QgsAttributeActionDialog(const QgsActionManager &actions, QWidget *parent=nullptr)", "attributeTableWidgetStyle() const", "actions() const", "showWidgetInAttributeTable() const"],
    "QgsRasterRendererWidget": ["setStdDev(const QString &value)", "setMin(const QString &value, int index=0)", "max(int index=0)", "stdDev()", "selectedBand(int index=0)", "QgsRasterRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent)", "min(int index=0)", "setMax(const QString &value, int index=0)"],
    "QgsRasterDataProvider": ["colorTable(int bandNo) const", "setUserNoDataValue(int bandNo, const QgsRasterRangeList &noData)"],
    "QgsHueSaturationFilter": ["colorizeStrength() const", "setColorizeStrength(int colorizeStrength)", "QgsHueSaturationFilter(QgsRasterInterface *input=nullptr)", "colorizeColor() const", "setColorizeOn(bool colorizeOn)", "setSaturation(int saturation)", "GrayscaleMode", "grayscaleMode() const", "setGrayscaleMode(QgsHueSaturationFilter::GrayscaleMode grayscaleMode)", "setColorizeColor(const QColor &colorizeColor)", "colorizeOn() const", "saturation() const"],
    "QgsSymbolLevelItem": ["QgsSymbolLevelItem(QgsSymbol *symbol, int layer)"],
    "QgsCredentials": ["getMasterPassword(QString &password, bool stored=false)"],
    "QgsDataDefinedRotationDialog": ["QgsDataDefinedRotationDialog(const QList< QgsSymbol * > &symbolList, QgsVectorLayer *layer)"],
    "QgsCptCityColorRamp": ["loadFile()", "setSchemeName(const QString &schemeName)", "variantName() const", "copyingInfo() const", "setName(const QString &schemeName, const QString &variantName=QString(), const QStringList &variantList=QStringList())", "setVariantName(const QString &variantName)", "variantList() const", "setVariantList(const QStringList &variantList)", "cloneGradientRamp() const", "loadPalette()", "hasMultiStops() const", "schemeName() const", "fileName() const", "copyingFileName() const", "fileLoaded() const", "descFileName() const", "copy(const QgsCptCityColorRamp *other)"],
    "QgsMapToolIdentifyFeature": ["featureIdentified(QgsFeatureId)", "featureIdentified(const QgsFeature &)"],
    "QgsGroupBoxCollapseButton": ["QgsGroupBoxCollapseButton(QWidget *parent=nullptr)", "setAltDown(bool updown)", "setShiftDown(bool shiftdown)", "shiftDown() const", "altDown() const"],
    "QgsGlowWidget": ["QgsGlowWidget(QWidget *parent=nullptr)", "create()"],
    "QgsRuggednessFilter": ["QgsRuggednessFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsIFeatureSelectionManager": ["QgsIFeatureSelectionManager(QObject *parent)"],
    "QgsGraduatedSymbolRendererWidget": ["classifyGraduated()", "updateUiFromRenderer(bool updateCount=true)", "QgsGraduatedSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "connectUpdateHandlers()", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "reapplySizes()", "rangesDoubleClicked(const QModelIndex &idx)", "changeRange(int rangeIdx)", "changeCurrentValue(QStandardItem *item)", "showSymbolLevels()", "changeSelectedSymbols()", "selectedRanges()", "reapplyColorRamp()", "disconnectUpdateHandlers()", "rowsOrdered()", "modelDataChanged()", "graduatedColumnChanged(const QString &field)", "rowsMoved()", "findSymbolForRange(double lowerBound, double upperBound, const QgsRangeList &ranges) const", "labelFormatChanged()", "changeRangeSymbol(int rangeIdx)", "rangesClicked(const QModelIndex &idx)"],
    "QgsPointLocator": ["destroyIndex()", "rebuildIndex(int maxFeaturesToIndex=-1)"],
    "QgsRuleBasedRenderer": ["FeatureFlags", "rootRule()"],
    "QgsSimpleFillSymbolLayerWidget": ["setColor(const QColor &color)", "setStrokeColor(const QColor &color)"],
    "pal::Pal": ["FnIsCanceled)(void *ctx)"],
    "QgsColorSwatchDelegate": ["QgsColorSwatchDelegate(QWidget *parent=nullptr)"],
    "QgsMeshDatasetGroupTreeItemDelegate": ["QgsMeshDatasetGroupTreeItemDelegate(QObject *parent=nullptr)"],
    "QgsAspectFilter": ["QgsAspectFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsRasterMatrix": ["asinus()", "setData(int cols, int rows, double *data, double nodataValue)", "power(const QgsRasterMatrix &other)", "number() const", "multiply(const QgsRasterMatrix &other)", "greaterThan(const QgsRasterMatrix &other)", "equal(const QgsRasterMatrix &other)", "greaterEqual(const QgsRasterMatrix &other)", "lesserEqual(const QgsRasterMatrix &other)", "nColumns() const", "logicalOr(const QgsRasterMatrix &other)", "QgsRasterMatrix(const QgsRasterMatrix &m)", "log10()", "tangens()", "divide(const QgsRasterMatrix &other)", "logicalAnd(const QgsRasterMatrix &other)", "sinus()", "squareRoot()", "changeSign()", "nRows() const", "cosinus()", "atangens()", "acosinus()", "lesserThan(const QgsRasterMatrix &other)", "OneArgOperator", "TwoArgOperator", "setNodataValue(double d)", "notEqual(const QgsRasterMatrix &other)", "nodataValue() const", "log()"],
    "QgsVectorFileWriter::Option": ["Option(const QString &docString, QgsVectorFileWriter::OptionType type)"],
    "QgsErrorMessage": ["file() const", "message() const", "function() const", "line() const", "tag() const"],
    "QgsTextEditConfigDlg": ["QgsTextEditConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsMarkerLineSymbolLayerWidget": ["setInterval(double val)", "setOffsetAlongLine(double val)"],
    "QgsNineCellFilter": ["setCellSizeY(double size)", "setZFactor(double factor)", "outputNodataValue() const", "setCellSizeX(double size)", "setInputNodataValue(double value)", "cellSizeY() const", "cellSizeX() const", "setOutputNodataValue(double value)", "inputNodataValue() const", "zFactor() const"],
    "QgsIdentifyMenu": ["showFeatureActions()", "maxFeatureDisplay()", "execWithSingleResult()", "allowMultipleReturn()", "maxLayerDisplay()", "resultsIfExternalAction()", "MenuLevel"],
    "QgsRuleBasedRendererModel": ["finishedAddingRules()", "updateRule(const QModelIndex &index)", "willAddRules(const QModelIndex &parent, int count)", "clearFeatureCounts()", "insertRule(const QModelIndex &parent, int before, QgsRuleBasedRenderer::Rule *newrule)", "removeRule(const QModelIndex &index)", "updateRule(const QModelIndex &parent, int row)", "ruleForIndex(const QModelIndex &index) const"],
    "QgsSymbolLevelsDialog": ["setForceOrderingEnabled(bool enabled)"],
    "QgsSimpleMarkerSymbolLayerWidget": ["setColorStroke(const QColor &color)", "setColorFill(const QColor &color)"],
    "QgsActionMenu": ["reinit()"],
    "QgsFieldComboBox": ["indexChanged(int i)"],
    "QgsPaintEffect": ["QgsPaintEffect(const QgsPaintEffect &other)"],
    "QgsMeshDatasetGroupTreeModel": ["Roles", "QgsMeshDatasetGroupTreeModel(QObject *parent=nullptr)"],
    "QgsPaintEngineHack": ["fixFlags()", "fixEngineFlags(QPaintEngine *engine)"],
    "QgsHeatmapRenderer": ["convertFromRenderer(const QgsFeatureRenderer *renderer)"],
    "QgsShadowEffectWidget": ["QgsShadowEffectWidget(QWidget *parent=nullptr)", "create()"],
    "QgsCentroidFillSymbolLayer": ["createFromSld(QDomElement &element)", "setPointOnSurface(bool pointOnSurface)", "pointOnSurface() const"],
    "QgsPluginLayerType": ["QgsPluginLayerType(const QString &name)", "name() const"],
    "QgsConditionalStyle": ["QgsConditionalStyle(const QString &rule)", "QgsConditionalStyle(const QgsConditionalStyle &other)"],
    "QgsContrastEnhancement": ["contrastEnhancementAlgorithm() const", "readXml(const QDomElement &elem)", "writeXml(QDomDocument &doc, QDomElement &parentElem) const", "QgsContrastEnhancement(const QgsContrastEnhancement &ce)"],
    "QgsFontMarkerSymbolLayerWidget": ["setFontFamily(const QFont &font)", "setColor(const QColor &color)", "setAngle(double angle)", "setSize(double size)"],
    "QgsBrushStyleComboBox": ["iconForBrush(Qt::BrushStyle style)", "QgsBrushStyleComboBox(QWidget *parent=nullptr)", "setBrushStyle(Qt::BrushStyle style)", "brushStyle() const"],
    "QgsGlowEffect": ["QgsGlowEffect(const QgsGlowEffect &other)"],
    "QgsLabelCandidate": ["QgsLabelCandidate(const QRectF &r, double c)"],
    "pal::LabelPosition": ["getReversed() const", "resetNumOverlaps()", "getPartId() const", "getProblemFeatureId() const", "getWidth() const", "getNumOverlaps() const", "getHeight() const", "getQuadrant() const", "setPartId(int id)", "getUpsideDown() const"],
    "QgsAttributesFormProperties": ["initSuppressCombo()", "QgsAttributesFormProperties(QgsVectorLayer *layer, QWidget *parent=nullptr)", "initLayoutConfig()", "initFormLayoutTree()", "updateButtons()", "FieldPropertiesRoles", "loadRelations()", "initAvailableWidgetsTree()", "init()", "initInitPython()"],
    "QgsWkbException": ["QgsWkbException(QString const &what)"],
    "QgsVectorFileWriter": ["driverMetadata(const QString &driverName, MetaData &driverMetadata)", "OptionType", "WriterError"],
    "QgsBlurWidget": ["QgsBlurWidget(QWidget *parent=nullptr)", "create()"],
    "QgsDataItem": ["icon()", "setIconName(const QString &iconName)", "populate(bool foreground=false)", "deleteLater(QVector< QgsDataItem * > &items)", "children() const", "hasChildren()", "beginInsertItems(QgsDataItem *parent, int first, int last)", "rowCount()", "dataChanged(QgsDataItem *item)", "type() const", "beginRemoveItems(QgsDataItem *parent, int first, int last)", "endRemoveItems()", "path() const", "endInsertItems()", "refresh()", "setIcon(const QIcon &icon)", "findItem(QVector< QgsDataItem * > items, QgsDataItem *item)", "childrenCreated()", "setPath(const QString &path)", "setToolTip(const QString &msg)", "state() const", "populate(const QVector< QgsDataItem * > &children)", "toolTip() const"],
    "QgsMapCanvas": ["setCurrentLayer(QgsMapLayer *layer)"],
    "QgsLayerTreeViewDefaultActions": ["actionRenameGroupOrLayer(QObject *parent=nullptr)", "actionShowInOverview(QObject *parent=nullptr)", "addGroup()", "showInOverview()", "QgsLayerTreeViewDefaultActions(QgsLayerTreeView *view)", "actionShowFeatureCount(QObject *parent=nullptr)", "uniqueGroupName(QgsLayerTreeGroup *parentGroup)", "actionGroupSelected(QObject *parent=nullptr)", "groupSelected()", "removeGroupOrLayer()", "zoomToGroup(QgsMapCanvas *canvas)", "renameGroupOrLayer()", "showFeatureCount()", "zoomToGroup()", "actionAddGroup(QObject *parent=nullptr)", "actionZoomToGroup(QgsMapCanvas *canvas, QObject *parent=nullptr)", "actionRemoveGroupOrLayer(QObject *parent=nullptr)", "zoomToLayers(QgsMapCanvas *canvas, const QList< QgsMapLayer * > &layers)"],
    "QgsGeometryPointInPolygonCheck": ["factoryDescription()", "factoryIsCompatible(QgsVectorLayer *layer)", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "QgsGeometryPointInPolygonCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryId()"],
    "QgsMeshRendererMeshSettingsWidget": ["MeshType"],
    "QgsDummyConfigDlg": ["QgsDummyConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent, const QString &description)"],
    "QgsRasterLayerSaveAsDialog": ["mode() const", "xResolution() const", "tileMode() const", "yResolution() const", "noData() const", "outputCrs()", "pyramidsConfigOptions() const", "nColumns() const", "hideFormat()", "ResolutionState", "pyramidsResamplingMethod() const", "nRows() const", "outputFormat() const", "Mode", "hideOutput()", "outputRectangle() const", "maximumTileSizeX() const", "maximumTileSizeY() const", "outputFileName() const", "createOptions() const", "CrsState", "pyramidsList() const"],
    "QgsSlider": ["setMaximum(const QVariant &max)", "setSingleStep(const QVariant &step)", "setValue(const QVariant &value)", "variantValue() const", "valueChanged(const QVariant &)", "setMinimum(const QVariant &min)"],
    "QgsSearchQueryBuilder": ["loadQuery()", "saveQuery()"],
    "QgsGpsdConnection": ["QgsGpsdConnection(const QString &host, qint16 port, const QString &device)"],
    "QgsSpatialIndexCopyVisitor": ["QgsSpatialIndexCopyVisitor(SpatialIndex::ISpatialIndex *newIndex)"],
    "pal::PointSet": ["getCentroid(double &px, double &py, bool forceInside=false) const", "PointSet(double x, double y)", "invalidateGeos() const", "getGeosType() const", "PointSet(int nbPoints, double *x, double *y)", "getNumPoints() const", "deleteCoords()", "preparedGeom() const", "PointSet(const PointSet &ps)", "createGeosGeom() const"],
    "QgsSimpleFillSymbolLayer": ["createFromSld(QDomElement &element)", "setBrushStyle(Qt::BrushStyle style)", "setStrokeWidth(double strokeWidth)", "strokeWidth() const", "brushStyle() const", "strokeWidthMapUnitScale() const", "strokeStyle() const", "setPenJoinStyle(Qt::PenJoinStyle style)", "QgsSimpleFillSymbolLayer(const QColor &color=DEFAULT_SIMPLEFILL_COLOR, Qt::BrushStyle style=DEFAULT_SIMPLEFILL_STYLE, const QColor &strokeColor=DEFAULT_SIMPLEFILL_BORDERCOLOR, Qt::PenStyle strokeStyle=DEFAULT_SIMPLEFILL_BORDERSTYLE, double strokeWidth=DEFAULT_SIMPLEFILL_BORDERWIDTH, Qt::PenJoinStyle penJoinStyle=DEFAULT_SIMPLEFILL_JOINSTYLE)", "setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)", "penJoinStyle() const", "setStrokeStyle(Qt::PenStyle strokeStyle)"],
    "QgsSingleCategoryDiagramRenderer": ["setDiagramSettings(const QgsDiagramSettings &s)"],
    "QgsPointDisplacementRendererWidget": ["QgsPointDisplacementRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)"],
    "QgsSingleBandGrayRendererWidget": ["create(QgsRasterLayer *layer, const QgsRectangle &extent)", "QgsSingleBandGrayRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())"],
    "QgsLayerTreeModel": ["nodeWillRemoveChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "disconnectFromLayers(QgsLayerTreeGroup *parentGroup)", "connectToLayers(QgsLayerTreeGroup *parentGroup)", "nodeLayerWillBeUnloaded()", "legendInvalidateMapBasedData()", "nodeCustomPropertyChanged(QgsLayerTreeNode *node, const QString &key)", "legendNodeData(QgsLayerTreeModelLegendNode *node, int role) const", "legendCleanup()", "Flag", "iconGroup()", "disconnectFromRootNode()", "layerNeedsUpdate()", "addLegendToLayer(QgsLayerTreeLayer *nodeL)", "nodeVisibilityChanged(QgsLayerTreeNode *node)", "layerLegendChanged()", "legendRootRowCount(QgsLayerTreeLayer *nL) const", "removeLegendFromLayer(QgsLayerTreeLayer *nodeLayer)", "legendNodeRowCount(QgsLayerTreeModelLegendNode *node) const", "legendNodeDataChanged()", "connectToRootNode()", "legendNodeFlags(QgsLayerTreeModelLegendNode *node) const", "indexOfParentLayerTreeNode(QgsLayerTreeNode *parentNode) const", "nodeLayerLoaded()", "nodeWillAddChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "nodeRemovedChildren()", "legendRootIndex(int row, int column, QgsLayerTreeLayer *nL) const", "connectToLayer(QgsLayerTreeLayer *nodeLayer)", "legendIconEmbeddedInParent(QgsLayerTreeLayer *nodeLayer) const", "nodeAddedChildren(QgsLayerTreeNode *node, int indexFrom, int indexTo)", "legendNodeIndex(int row, int column, QgsLayerTreeModelLegendNode *node) const", "invalidateLegendMapBasedData()", "disconnectFromLayer(QgsLayerTreeLayer *nodeLayer)", "legendEmbeddedInParent(QgsLayerTreeLayer *nodeLayer) const", "legendParent(QgsLayerTreeModelLegendNode *legendNode) const"],
    "QgsEditorWidgetRegistry": ["createSearchWidget(const QString &widgetId, QgsVectorLayer *vl, int fieldIdx, const QVariantMap &config, QWidget *parent, const QgsAttributeEditorContext &context=QgsAttributeEditorContext())"],
    "QgsGeometryCheckerUtils": ["lineIntersections(const QgsLineString *line1, const QgsLineString *line2, double tol)", "polygonRings(const QgsPolygon *polygon)", "getGeomPart(const QgsAbstractGeometry *geom, int partIdx)", "canDeleteVertex(const QgsAbstractGeometry *geom, int iPart, int iRing)", "sharedEdgeLength(const QgsAbstractGeometry *geom1, const QgsAbstractGeometry *geom2, double tol)", "createGeomEngine(const QgsAbstractGeometry *geometry, double tolerance)", "pointOnLine(const QgsPoint &p, const QgsLineString *line, double tol, bool excludeExtremities=false)", "getGeomPart(QgsAbstractGeometry *geom, int partIdx)", "filter1DTypes(QgsAbstractGeometry *geom)"],
    "QgsLayerTreeLayer": ["QgsLayerTreeLayer(const QgsLayerTreeLayer &other)", "QgsLayerTreeLayer(QgsMapLayer *layer)", "attachToLayer()"],
    "QgsMasterPasswordResetDialog": ["requestMasterPasswordReset(QString *newpass, QString *oldpass, bool *keepbackup)", "QgsMasterPasswordResetDialog(QWidget *parent=nullptr)"],
    "pal::FeaturePart": ["FeaturePart(const FeaturePart &other)"],
    "QgsEffectDrawModeComboBox": ["QgsEffectDrawModeComboBox(QWidget *parent SIP_TRANSFERTHIS=nullptr)"],
    "QgsSingleBandColorDataRenderer": ["create(const QDomElement &elem, QgsRasterInterface *input)", "QgsSingleBandColorDataRenderer(QgsRasterInterface *input, int band)"],
    "QgsLayerTreeMapCanvasBridge": ["mapCanvas() const", "rootGroup() const", "autoSetupOnFirstLayer() const"],
    "QgsGeometrySegmentLengthCheck": ["QgsGeometrySegmentLengthCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()"],
    "QgsAttributeDialog": ["attributeForm()", "feature()"],
    "QgsDiagramSettings": ["LabelPlacementMethod"],
    "QgsPalLayerSettings": ["QgsPalLayerSettings(const QgsPalLayerSettings &s)"],
    "ParametricLine": ["calcSecDer(float t, Vector3D *v)=0", "setParent(ParametricLine *paral)=0", "add(ParametricLine *pl)=0", "calcFirstDer(float t, Vector3D *v)=0", "getParent() const =0", "getControlPoly() const =0", "calcPoint(float t, QgsPoint *p)=0", "getDegree() const =0", "setControlPoly(QVector< QgsPoint * > *cp)=0", "changeDirection()=0", "remove(int i)=0", "getControlPoint(int number) const =0"],
    "QgsPalettedRasterRenderer": ["create(const QDomElement &elem, QgsRasterInterface *input)"],
    "QgsDataCollectionItem": ["addChild(QgsDataItem *item)"],
    "QgsMapLayerModel": ["addLayers(const QList< QgsMapLayer * > &layers)", "removeLayers(const QStringList &layerIds)"],
    "QgsLinePatternFillSymbolLayer": ["ogrFeatureStyleWidth(double widthScaleFactor) const"],
    "QgsMeshAvailableDatasetGroupTreeModel": ["QgsMeshAvailableDatasetGroupTreeModel(QObject *parent=nullptr)"],
    "QgsSymbolLayerUtils": ["drawStippledBackground(QPainter *painter, QRect rect)", "createLineLayerFromSld(QDomElement &element)", "createDisplacementElement(QDomDocument &doc, QDomElement &element, QPointF offset)", "decodeMapUnitScale(const QString &str)", "createFillLayerFromSld(QDomElement &element)", "decodeBlendMode(const QString &s)", "decodePenJoinStyle(const QString &str)", "encodeSldAlpha(int alpha)", "encodeSldFontWeight(int weight)", "fillToSld(QDomDocument &doc, QDomElement &element, Qt::BrushStyle brushStyle, const QColor &color=QColor())", "createOnlineResourceElement(QDomDocument &doc, QDomElement &element, const QString &path, const QString &format)", "geometryFromSldElement(QDomElement &element, QString &geomFunc)", "needLinePatternFill(QDomElement &element)", "needSvgFill(QDomElement &element)", "hasWellKnownMark(QDomElement &element)", "decodePenStyle(const QString &str)", "clearSymbolMap(QgsSymbolMap &symbols)", "fillFromSld(QDomElement &element, Qt::BrushStyle &brushStyle, QColor &color)", "decodeSldFontWeight(const QString &str)", "needPointPatternFill(QDomElement &element)", "decodeSldFontStyle(const QString &str)", "encodeSldFontStyle(QFont::Style style)", "externalMarkerFromSld(QDomElement &element, QString &path, QString &format, int &markIndex, QColor &color, double &size)", "getVendorOptionList(QDomElement &element)", "needSvgMarker(QDomElement &element)", "lineFromSld(QDomElement &element, Qt::PenStyle &penStyle, QColor &color, double &width, Qt::PenJoinStyle *penJoinStyle=nullptr, Qt::PenCapStyle *penCapStyle=nullptr, QVector< qreal > *customDashPattern=nullptr, double *dashOffset=nullptr)", "decodeSldAlpha(const QString &str)", "needFontMarker(QDomElement &element)", "decodeSldLineCapStyle(const QString &str)", "encodePenCapStyle(Qt::PenCapStyle style)", "decodeBrushStyle(const QString &str)", "onlineResourceFromSldElement(QDomElement &element, QString &path, QString &format)", "createFunctionElement(QDomDocument &doc, QDomElement &element, const QString &function)", "createMarkerLayerFromSld(QDomElement &element)", "encodeSldBrushStyle(Qt::BrushStyle style)", "encodeSldLineJoinStyle(Qt::PenJoinStyle style)", "externalGraphicToSld(QDomDocument &doc, QDomElement &element, const QString &path, const QString &mime, const QColor &color, double size=-1)", "encodeRealVector(const QVector< qreal > &v)", "encodeBrushStyle(Qt::BrushStyle style)", "encodeMapUnitScale(const QgsMapUnitScale &mapUnitScale)", "encodePenStyle(Qt::PenStyle style)", "decodePenCapStyle(const QString &str)", "opacityFromSldElement(QDomElement &element, QString &alphaFunc)", "rotationFromSldElement(QDomElement &element, QString &rotationFunc)", "wellKnownMarkerToSld(QDomDocument &doc, QDomElement &element, const QString &name, const QColor &color, const QColor &strokeColor, Qt::PenStyle strokeStyle, double strokeWidth=-1, double size=-1)", "needMarkerLine(QDomElement &element)", "createOpacityElement(QDomDocument &doc, QDomElement &element, const QString &alphaFunc)", "decodeSldLineJoinStyle(const QString &str)", "decodeSldRealVector(const QString &s)", "encodeColor(const QColor &color)", "displacementFromSldElement(QDomElement &element, QPointF &offset)", "encodePenJoinStyle(Qt::PenJoinStyle style)", "decodeSldBrushStyle(const QString &str)", "externalGraphicFromSld(QDomElement &element, QString &path, QString &mime, QColor &color, double &size)", "encodeSldRealVector(const QVector< qreal > &v)", "externalMarkerToSld(QDomDocument &doc, QDomElement &element, const QString &path, const QString &format, int *markIndex=nullptr, const QColor &color=QColor(), double size=-1)", "createRotationElement(QDomDocument &doc, QDomElement &element, const QString &rotationFunc)", "createGeometryElement(QDomDocument &doc, QDomElement &element, const QString &geomFunc)", "labelTextToSld(QDomDocument &doc, QDomElement &element, const QString &label, const QFont &font, const QColor &color=QColor(), double size=-1)", "decodeRealVector(const QString &s)", "functionFromSldElement(QDomElement &element, QString &function)", "getSvgParameterList(QDomElement &element)", "encodeSldLineCapStyle(Qt::PenCapStyle style)", "decodeColor(const QString &str)", "createSvgParameterElement(QDomDocument &doc, const QString &name, const QString &value)", "needEllipseMarker(QDomElement &element)", "createVendorOptionElement(QDomDocument &doc, const QString &name, const QString &value)"],
    "QgsMapRendererQImageJob": ["QgsMapRendererQImageJob(const QgsMapSettings &settings)"],
    "QgsSvgSelectorWidget": ["currentSvgPath() const", "svgSelected(const QString &path)", "populateList()"],
    "QgsMeshDatasetGroupListModel": ["QgsMeshDatasetGroupListModel(QObject *parent)", "variableNames() const", "setDisplayProviderName(bool displayProviderName)"],
    "QgsSmartGroupEditorDialog": ["QgsSmartGroupEditorDialog(QgsStyle *style, QWidget *parent=nullptr)"],
    "QgsSvgMarkerSymbolLayer": ["createFromSld(QDomElement &element)", "strokeWidth() const", "setStrokeWidth(double w)", "setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)", "strokeWidthMapUnitScale() const"],
    "QgsLUDialog": ["lowerValue() const", "QgsLUDialog(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)", "setLowerValue(const QString &val)", "setUpperValue(const QString &val)", "upperValue() const"],
    "QgsMapRendererCustomPainterJob": ["QgsMapRendererCustomPainterJob(const QgsMapSettings &settings, QPainter *painter)"],
    "QgsFeatureRenderer": ["type() const", "QgsFeatureRenderer(const QString &type)", "setUsingSymbolLevels(bool usingSymbolLevels)", "usingSymbolLevels() const"],
    "QgsExpressionFieldBuffer": ["expressions() const"],
    "QgsValueRelationConfigDlg": ["QgsValueRelationConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)", "editExpression()"],
    "QgsRasterPyramidsOptionsWidget": ["checkAllLevels(bool checked)", "overviewList() const", "overviewListChanged()", "apply()", "configOptions() const", "someValueChanged()", "createOptionsWidget()", "setRasterFileName(const QString &file)", "setRasterLayer(QgsRasterLayer *rasterLayer)", "resamplingMethod() const"],
    "QgsBrowserModel": ["endInsertItems()", "itemDataChanged(QgsDataItem *item)", "updateProjectHome()", "beginRemoveItems(QgsDataItem *parent, int first, int last)", "ItemDataRole", "beginInsertItems(QgsDataItem *parent, int first, int last)", "removeRootItems()", "endRemoveItems()"],
    "QgsRasterFileWriter": ["pyramidsResampling() const", "setPyramidsResampling(const QString &str)"],
    "QgsExternalResourceWidget": ["setDocumentPath(const QVariant &documentPath)", "DocumentViewerContent"],
    "QgsStyleExportImportDialog": ["doExportImport()", "importTypeChanged(int)"],
    "pal::Util": ["unmulti(const GEOSGeometry *the_geom)"],
    "QgsProjectFileTransform": ["updateRevision(const QgsProjectVersion &version)", "convertRasterProperties(QDomDocument &doc, QDomNode &parentNode, QDomElement &rasterPropertiesElem, QgsRasterLayer *rlayer)"],
    "QgsGeometryDegeneratePolygonCheck": ["factoryDescription()", "QgsGeometryDegeneratePolygonCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()"],
    "QgsRelief": ["setZFactor(double factor)", "setReliefColors(const QList< QgsRelief::ReliefColor > &c)", "QgsRelief(const QString &inputFile, const QString &outputFile, const QString &outputFormat)", "addReliefColorClass(const QgsRelief::ReliefColor &color)", "reliefColors() const", "clearReliefColors()", "zFactor() const"],
    "QgsValueMapConfigDlg": ["QgsValueMapConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent)"],
    "QgsSnappingUtils": ["mapSettings() const", "IndexingStrategy"],
    "QgsVectorFileWriter::BoolOption": ["BoolOption(const QString &docString, bool defaultValue)"],
    "QgsNewNameDialog": ["nameChanged()", "fullNames(const QString &name, const QStringList &extensions)", "matching(const QStringList &newNames, const QStringList &existingNames, Qt::CaseSensitivity cs=Qt::CaseSensitive)", "highlightText(const QString &text)"],
    "QgsMeshActiveDatasetGroupTreeView": ["QgsMeshActiveDatasetGroupTreeView(QWidget *parent=nullptr)"],
    "pal::PriorityQueue": ["print()", "decreaseKey(int key)", "getSize() const", "remove(int key)", "downheap(int id)", "getSizeByPos() const", "getId(int key) const", "isIn(int key) const", "setPriority(int key, double new_p)", "upheap(int key)", "getBest()", "insert(int key, double p)", "sort()"],
    "QgsSvgSelectorGroupsModel": ["QgsSvgSelectorGroupsModel(QObject *parent)"],
    "QgsEncodingFileDialog": ["pbnCancelAll_clicked()", "saveUsedEncoding()"],
    "QgsDefaultRasterLayerLegend": ["QgsDefaultRasterLayerLegend(QgsRasterLayer *rl)"],
    "QgsDetailedItemDelegate": ["verticalSpacing() const", "horizontalSpacing() const", "setVerticalSpacing(int value)", "setHorizontalSpacing(int value)"],
    "QgsStyleGroupSelectionDialog": ["QgsStyleGroupSelectionDialog(QgsStyle *style, QWidget *parent=nullptr)"],
    "QgsFeatureModel": ["fidToIndex(QgsFeatureId fid)=0"],
    "QgsMimeDataUtils": ["decodeUriList(const QMimeData *data)", "isUriList(const QMimeData *data)"],
    "QgsVectorFileWriter::HiddenOption": ["HiddenOption(const QString &value)"],
    "QgsAttributeTableDelegate": ["setFeatureSelectionModel(QgsFeatureSelectionModel *featureSelectionModel)"],
    "QgisInterface": ["actionAddPgLayer()=0", "actionShowPythonDialog()=0", "actionSaveAllEdits()=0", "actionPluginListSeparator()=0", "actionAddRasterLayer()=0", "actionCancelAllEdits()=0", "actionOpenFieldCalculator()=0", "pluginManagerInterface()=0", "actionHideSelectedLayers()=0", "actionShowAllLayers()=0", "actionLayerProperties()=0", "actionLayerSaveAs()=0", "actionAddToOverview()=0", "actionAddOgrLayer()=0", "actionOptions()=0", "actionAddAllToOverview()=0", "layerTreeView()=0", "actionDuplicateLayer()=0", "actionRollbackEdits()=0", "actionCheckQgisVersion()=0", "actionAddWmsLayer()=0", "actionCustomProjection()=0", "actionQgisHomePage()=0", "actionPasteLayerStyle()=0", "actionShowSelectedLayers()=0", "actionNewVectorLayer()=0", "actionRollbackAllEdits()=0", "actionManagePlugins()=0", "actionCopyLayerStyle()=0", "actionToggleEditing()=0", "actionSaveActiveLayerEdits()=0", "actionCancelEdits()=0", "actionRemoveAllFromOverview()=0", "actionToggleFullScreen()=0", "actionHelpContents()=0", "actionSaveEdits()=0", "actionAllEdits()=0", "actionHideAllLayers()=0", "actionOpenTable()=0", "actionAbout()=0"],
    "QgsConnectionPoolGroup": ["initTimer(QObject *parent)", "QgsConnectionPoolGroup(const QString &ci)", "onConnectionExpired()", "release(T conn)", "invalidateConnections()"],
    "QgsLinearMinMaxEnhancementWithClip": ["QgsLinearMinMaxEnhancementWithClip(Qgis::DataType, double, double)"],
    "QgsFeatureSelectionModel": ["QgsFeatureSelectionModel(QAbstractItemModel *model, QgsFeatureModel *featureModel, QgsIFeatureSelectionManager *featureSelectionHandler, QObject *parent)", "setFeatureSelectionManager(QgsIFeatureSelectionManager *featureSelectionManager)"],
    "QgsRasterResampleFilter": ["zoomedOutResampler() const", "setMaxOversampling(double os)", "maxOversampling() const", "QgsRasterResampleFilter(QgsRasterInterface *input=nullptr)", "zoomedInResampler() const"],
    "QgsAlignRaster": ["setGridOffset(QPointF offset)", "gridOffset() const"],
    "QgsLinearlyInterpolatedDiagramRenderer": ["classificationAttributeIsExpression() const", "lowerValue() const", "upperSize() const", "setUpperValue(double val)", "lowerSize() const", "classificationAttributeExpression() const", "setClassificationAttributeIsExpression(bool isExpression)", "setUpperSize(QSizeF s)", "upperValue() const", "setLowerValue(double val)", "setDiagramSettings(const QgsDiagramSettings &s)", "setLowerSize(QSizeF s)", "setClassificationAttributeExpression(const QString &expression)"],
    "QgsRasterBlock": ["toString() const", "applyNoDataValues(const QgsRasterRangeList &rangeList)"],
    "QgsRasterLayer": ["showStatusMessage(const QString &message)", "isValidRasterFileName(const QString &fileNameQString)"],
    "QgsZipItem": ["iconZip()", "getZipFileList()"],
    "QgsVectorDataProvider": ["convertValue(QVariant::Type type, const QString &value)"],
    "QgsQueryBuilder": ["setDatasourceDescription(const QString &uri)", "clear()"],
    "QgsFillSymbolLayer": ["QgsFillSymbolLayer(bool locked=false)"],
    "QgsGeometryCollection": ["QgsGeometryCollection(const QgsGeometryCollection &c)"],
    "QgsMultiBandColorRendererWidget": ["create(QgsRasterLayer *layer, const QgsRectangle &extent)", "QgsMultiBandColorRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())"],
    "QgsTransaction": ["QgsTransaction(const QString &connString)"],
    "QgsExpressionHighlighter": ["QgsExpressionHighlighter(QTextDocument *parent=nullptr)", "addFields(const QStringList &fieldList)"],
    "QgsPenCapStyleComboBox": ["setPenCapStyle(Qt::PenCapStyle style)", "QgsPenCapStyleComboBox(QWidget *parent=nullptr)", "penCapStyle() const"],
    "QgsRuleBasedRendererWidget": ["refineRuleScalesGui(const QModelIndexList &index)", "refineRuleScales()", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "saveSectionWidth(int section, int oldSize, int newSize)", "currentRule()", "QgsRuleBasedRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "selectedRules()", "currentRuleChanged(const QModelIndex &current=QModelIndex(), const QModelIndex &previous=QModelIndex())", "selectedRulesChanged()", "clearFeatureCounts()", "editRule()", "refineRuleCategories()", "restoreSectionWidths()", "setRenderingOrder()", "countFeatures()", "refineRule(int type)", "editRule(const QModelIndex &index)", "removeRule()", "addRule()", "refineRuleRanges()"],
    "QgsPointLocator_Stream": ["QgsPointLocator_Stream(const QLinkedList< RTree::Data * > &dataList)"],
    "QgsCheckBoxConfigDlg": ["QgsCheckBoxConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsAttributeTableView": ["repaintRequested()", "setModel(QgsAttributeTableFilterModel *filterModel)", "_q_selectRow(int row)", "selectRow(int row)", "repaintRequested(const QModelIndexList &indexes)", "finished()"],
    "QgsAttributesDnDTree": ["setType(QgsAttributesDnDTree::Type value)", "QgsAttributesDnDTree(QgsVectorLayer *layer, QWidget *parent=nullptr)", "type() const", "selectFirstMatchingItem(const QgsAttributesFormProperties::DnDTreeItemData &data)", "Type"],
    "QgsAbstractFeatureIteratorFromSource": ["QgsAbstractFeatureIteratorFromSource(T *source, bool ownSource, const QgsFeatureRequest &request)"],
    "QgsPointPatternFillSymbolLayer": ["createFromSld(QDomElement &element)"],
    "QgsRasterProjector": ["precisionLabel(Precision precision)", "setPrecision(Precision precision)", "precision() const"],
    "QgsColorBrewerPalette": ["listSchemeVariants(const QString &schemeName)", "listSchemes()", "listSchemeColors(const QString &schemeName, int colors)"],
    "QgsDerivativeFilter": ["QgsDerivativeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsVertexMarker": ["setPenWidth(int width)", "QgsVertexMarker(QgsMapCanvas *mapCanvas)", "setIconType(int iconType)", "setIconSize(int iconSize)"],
    "QgsAttributeFormLegacyInterface": ["QgsAttributeFormLegacyInterface(const QString &function, const QString &pyFormName, QgsAttributeForm *form)"],
    "QgsGpsDetector": ["detectionFailed()", "connDestroyed(QObject *)", "advance()", "detected(const QgsGpsInformation &)", "QgsGpsDetector(const QString &portName)", "availablePorts()"],
    "QgsSimpleLineSymbolLayerWidget": ["updatePatternIcon()"],
    "QgsMeshVariableStrokeWidthButton": ["widgetChanged()"],
    "QgsRunProcess": ["create(const QString &action, bool capture)"],
    "pal::GeomFunction": ["findLineCircleIntersection(double cx, double cy, double radius, double x1, double y1, double x2, double y2, double &xRes, double &yRes)", "cross_product(double x1, double y1, double x2, double y2, double x3, double y3)"],
    "QgsLayerTreeModelLegendNode": ["isEmbeddedInParent() const", "setUserLabel(const QString &userLabel)", "isScaleOK(double scale) const", "userLabel() const", "setEmbeddedInParent(bool embedded)"],
    "QgsCollapsibleGroupBox": ["saveCollapsedState()", "saveCheckedState()", "saveKey() const", "QgsCollapsibleGroupBox(QWidget *parent=nullptr, QgsSettings *settings=nullptr)", "setSettings(QgsSettings *settings)", "QgsCollapsibleGroupBox(const QString &title, QWidget *parent=nullptr, QgsSettings *settings=nullptr)", "init()"],
    "QgsFieldValidator": ["dateFormat() const", "QgsFieldValidator(QObject *parent, const QgsField &field, const QString &defaultValue, const QString &dateFormat=\"yyyy-MM-dd\")"],
    "QgsDiagram": ["QgsDiagram(const QgsDiagram &other)", "clearCache()"],
    "QgsSourceFieldsProperties": ["setRow(int row, int idx, const QgsField &field)", "QgsSourceFieldsProperties(QgsVectorLayer *layer, QWidget *parent=nullptr)", "apply()", "AttrColumns", "updateButtons()", "toggleEditing()", "loadRows()", "init()"],
    "QgsCptCityAllRampsItem": ["QgsCptCityAllRampsItem(QgsCptCityDataItem *parent, const QString &name, const QVector< QgsCptCityDataItem * > &items)"],
    "QgsExpressionBuilderDialog": ["setExpressionText(const QString &text)", "QgsExpressionBuilderDialog(QgsVectorLayer *layer, const QString &startText=QString(), QWidget *parent SIP_TRANSFERTHIS=nullptr, const QString &key=\"generic\", const QgsExpressionContext &context=QgsExpressionContext())", "expressionText()"],
    "QgsUniqueValuesConfigDlg": ["QgsUniqueValuesConfigDlg(QgsVectorLayer *vl, int fieldIdx, QWidget *parent=nullptr)"],
    "QgsUnitSelectionWidget": ["changed()"],
    "QgsRendererRangeLabelFormat": ["setPrecision(int precision)", "setTrimTrailingZeroes(bool trimTrailingZeroes)", "formatNumber(double value) const", "setFormat(const QString &format)", "setFromDomElement(QDomElement &element)", "trimTrailingZeroes() const", "QgsRendererRangeLabelFormat(const QString &format, int precision=4, bool trimTrailingZeroes=false)", "format() const", "precision() const", "saveToDomElement(QDomElement &element)", "labelForRange(const QgsRendererRange &range) const"],
    "QgsAbstractLabelProvider": ["Flag"],
    "QgsGmlFeatureClass": ["fields()", "geometryAttributes()", "fieldIndex(const QString &name)", "QgsGmlFeatureClass(const QString &name, const QString &path)", "path() const"],
    "QgsCategorizedSymbolRendererWidget": ["changeCategorySymbol()", "QgsCategorizedSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "addCategories()", "changeCategorizedSymbol()", "deleteCategories()", "updateUiFromRenderer()", "categoriesDoubleClicked(const QModelIndex &idx)", "deleteAllCategories()", "rowsMoved()", "showSymbolLevels()", "categoryColumnChanged(const QString &field)", "addCategory()", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "selectedCategoryList()", "populateCategories()"],
    "QgsMessageViewer": ["setCheckBoxText(const QString &text)", "setCheckBoxState(Qt::CheckState state)", "checkBoxState()", "setCheckBoxVisible(bool visible)", "setCheckBoxQgsSettingsLabel(const QString &label)", "QgsMessageViewer(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags, bool deleteOnClose=true)", "setMessageAsPlainText(const QString &msg)", "setMessageAsHtml(const QString &msg)"],
    "QgsCurvePolygon": ["QgsCurvePolygon(const QgsCurvePolygon &p)"],
    "QgsRuleBasedRenderer::Rule": ["setLabel(const QString &label)", "legendSymbolItems(int currentLevel=-1) const", "label() const", "save(QDomDocument &doc, QgsSymbolMap &symbolMap) const", "initFilter()", "dependsOnScale() const", "symbol()"],
    "QgsValueRelationSearchWidgetWrapper": ["value() const"],
    "QgsGml": ["dataReadProgress(int progress)", "totalStepsUpdate(int totalSteps)", "QgsGml(const QString &typeName, const QString &geometryAttribute, const QgsFields &fields)"],
    "QgsCptCitySelectionItem": ["QgsCptCitySelectionItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "parseXml()", "selectionsList() const"],
    "QgsRasterFormatSaveOptionsWidget": ["apply()", "optionsChanged()", "QgsRasterFormatSaveOptionsWidget(QWidget *parent SIP_TRANSFERTHIS=nullptr, const QString &format=\"GTiff\", QgsRasterFormatSaveOptionsWidget::Type type=Default, const QString &provider=\"gdal\")", "Type"],
    "QgsSymbolLayerAbstractMetadata": ["visibleName() const", "type() const", "name() const"],
    "QgsMultiBandColorRenderer": ["setRedBand(int band)", "greenBand() const", "redBand() const", "create(const QDomElement &elem, QgsRasterInterface *input)", "blueBand() const", "setBlueBand(int band)", "QgsMultiBandColorRenderer(QgsRasterInterface *input, int redBand, int greenBand, int blueBand, QgsContrastEnhancement *redEnhancement=nullptr, QgsContrastEnhancement *greenEnhancement=nullptr, QgsContrastEnhancement *blueEnhancement=nullptr)", "setGreenBand(int band)"],
    "QgsPreviewEffect": ["PreviewMode", "QgsPreviewEffect(QObject *parent)"],
    "QgsPixmapLabel": ["setPixmap(const QPixmap &)"],
    "QgsCapabilitiesCache": ["QgsCapabilitiesCache(int size)"],
    "QgsCompoundCurve": ["QgsCompoundCurve(const QgsCompoundCurve &curve)"],
    "QgsVectorFileWriter::SetOption": ["SetOption(const QString &docString, const QStringList &values, const QString &defaultValue, bool allowNone=false)"],
    "QgsVectorFileWriter::StringOption": ["StringOption(const QString &docString, const QString &defaultValue=QString())"],
    "QgsOWSSourceSelect": ["enableLayersForCrs(QTreeWidgetItem *item)"],
    "QgsGeometry::Error": ["Error(const QString &m, const QgsPointXY &p)", "Error(const QString &m)"],
    "QgisPlugin": ["name()"],
    "QgsXmlUtils": ["readRectangle(const QDomElement &element)"],
    "QgsAttributeTableFilterModel": ["fidToIndexList(QgsFeatureId fid)", "mapFromMaster(const QModelIndex &sourceIndex) const", "mapToMaster(const QModelIndex &proxyIndex) const"],
    "QgsVectorLayerLegendWidget": ["QgsVectorLayerLegendWidget(QWidget *parent=nullptr)"],
    "QgsSymbolRenderContext": ["setFeature(const QgsFeature *f)"],
    "QgsDartMeasurement": ["send() const", "QgsDartMeasurement(const QString &name, Type type, const QString &value)", "Type", "toString() const"],
    "QgsShapeburstFillSymbolLayer": ["setOffsetMapUnitScale(const QgsMapUnitScale &scale)", "setDistanceMapUnitScale(const QgsMapUnitScale &scale)", "offsetMapUnitScale() const", "distanceMapUnitScale() const"],
    "QgsJoinDialog": ["QgsJoinDialog(QgsVectorLayer *layer, QList< QgsMapLayer * > alreadyJoinedLayers, QWidget *parent=nullptr, Qt::WindowFlags f=Qt::WindowFlags())"],
    "QgsGeometryLineLayerIntersectionCheck": ["factoryDescription()", "QgsGeometryLineLayerIntersectionCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()"],
    "QgsVectorFileWriter::IntOption": ["IntOption(const QString &docString, int defaultValue)"],
    "QgsAttributeTableModel": ["Role", "idToIndex(QgsFeatureId id) const", "idToIndexList(QgsFeatureId id) const", "finished()"],
    "QgsFeatureListModel": ["Role", "featureByIndex(const QModelIndex &index, QgsFeature &feat)", "mapSelectionFromMaster(const QItemSelection &selection) const", "mapToMaster(const QModelIndex &proxyIndex) const", "setSourceModel(QgsAttributeTableFilterModel *sourceModel)", "mapFromMaster(const QModelIndex &sourceIndex) const", "mapSelectionToMaster(const QItemSelection &selection) const", "fidToIndexList(QgsFeatureId fid)", "masterModel()", "displayExpression() const"],
    "QgsColorEffectWidget": ["QgsColorEffectWidget(QWidget *parent=nullptr)", "create()"],
    "QgsDetailedItemWidget": ["setChecked(bool flag)", "setData(const QgsDetailedItemData &data)"],
    "QgsGeos": ["getGEOSHandler()", "coordSeqPoint(const GEOSCoordSequence *cs, int i, bool hasZ, bool hasM)", "fromGeosPolygon(const GEOSGeometry *geos)"],
    "QgsRasterShaderFunction": ["QgsRasterShaderFunction(double minimumValue=0.0, double maximumValue=255.0)", "minimumMaximumRange() const"],
    "QgsGeometryChecker": ["execute(int *totalSteps=nullptr)", "getContext() const", "getMessages() const", "setMergeAttributeIndices(const QMap< QString, int > &mergeAttributeIndices)", "QgsGeometryChecker(const QList< QgsGeometryCheck * > &checks, QgsGeometryCheckContext *context, const QMap< QString, QgsFeaturePool * > &featurePools)", "errorAdded(QgsGeometryCheckError *error)", "fixError(QgsGeometryCheckError *error, int method, bool triggerRepaint=false)", "featurePools() const", "errorUpdated(QgsGeometryCheckError *error, bool statusChanged)", "progressValue(int value)", "getChecks() const"],
    "QgsRendererRulePropsDialog": ["buildExpression()", "testFilter()", "rule()"],
    "QgsCptCityArchive": ["initArchives(bool loadAll=false)", "defaultArchive()", "archiveRegistry()", "initDefaultArchive()", "copyingInfo(const QString &fileName)", "isEmpty()", "baseDir(QString archiveName)", "archiveName() const", "findFileName(const QString &target, const QString &startDir, const QString &baseDir)", "defaultBaseDir()", "rootItems() const", "descFileName(const QString &dirName) const", "setBaseDir(const QString &dirName)", "copyingFileName(const QString &dirName) const", "QgsCptCityArchive(const QString &archiveName=DEFAULT_CPTCITY_ARCHIVE, const QString &baseDir=QString())", "baseDir() const", "clearArchives()", "description(const QString &fileName)", "initArchive(const QString &archiveName, const QString &archiveBaseDir)", "selectionItems() const"],
    "QgsSingleBandGrayRenderer": ["gradient() const", "grayBand() const", "setGradient(Gradient gradient)", "create(const QDomElement &elem, QgsRasterInterface *input)", "Gradient", "QgsSingleBandGrayRenderer(QgsRasterInterface *input, int grayBand)", "setGrayBand(int band)", "contrastEnhancement() const"],
    "QgsGeometryContainedCheck": ["factoryDescription()", "ResolutionMethod", "QgsGeometryContainedCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()"],
    "QgsVectorLayerJoinBuffer": ["vectorJoins() const", "QgsVectorLayerJoinBuffer(QgsVectorLayer *layer=nullptr)"],
    "QgsAbstractFeatureSource": ["iteratorClosed(QgsAbstractFeatureIterator *it)", "iteratorOpened(QgsAbstractFeatureIterator *it)"],
    "QgsRasterCalcNode": ["parseRasterCalcString(const QString &str, QString &parserErrorMsg)", "setRight(QgsRasterCalcNode *right)", "QgsRasterCalcNode(Operator op, QgsRasterCalcNode *left, QgsRasterCalcNode *right)", "QgsRasterCalcNode(QgsRasterMatrix *matrix)", "QgsRasterCalcNode(double number)", "type() const", "setLeft(QgsRasterCalcNode *left)", "QgsRasterCalcNode(const QString &rasterName)"],
    "QgsFields": ["FieldOrigin"],
    "QgsSymbolSelectorDialog": ["lockLayer()", "removeLayer()", "updatePreview()", "addLayer()", "symbolModified()", "layerChanged()", "moveLayerUp()", "updateLayerPreview()", "moveLayerDown()"],
    "QgsEffectStack": ["QgsEffectStack(const QgsEffectStack &other)"],
    "QgsRelationReferenceWidget": ["setRelation(const QgsRelation &relation, bool allowNullValue)", "CanvasExtent", "setOpenFormButtonVisible(bool openFormButtonVisible)", "QgsRelationReferenceWidget(QWidget *parent)", "setReadOnlySelector(bool readOnly)", "setRelationEditable(bool editable)", "init()", "setAllowMapIdentification(bool allowMapIdentification)", "setEmbedForm(bool display)"],
    "QgsDiagramProperties": ["mAttributesTreeWidget_itemDoubleClicked(QTreeWidgetItem *item, int column)", "scalingTypeChanged()", "mAddCategoryPushButton_clicked()", "mEngineSettingsButton_clicked()", "apply()", "mRemoveCategoryPushButton_clicked()", "showSizeLegendDialog()", "QgsDiagramProperties(QgsVectorLayer *layer, QWidget *parent, QgsMapCanvas *canvas)", "mDiagramAttributesTreeWidget_itemDoubleClicked(QTreeWidgetItem *item, int column)", "mDiagramStackedWidget_currentChanged(int index)", "mDiagramTypeComboBox_currentIndexChanged(int index)", "mFindMaximumValueButton_clicked()", "showAddAttributeExpressionDialog()", "auxiliaryFieldCreated()", "updatePlacementWidgets()"],
    "QgsFeatureListView": ["repaintRequested()", "repaintRequested(const QModelIndexList &indexes)"],
    "QgsGradientFillSymbolLayerWidget": ["setGradientSpread(int index)", "setColor(const QColor &color)", "setCoordinateMode(int index)", "setColor2(const QColor &color)", "setGradientType(int index)"],
    "QgsFillSymbol": ["setAngle(double angle) const"],
    "QgsSmartGroupCondition": ["QgsSmartGroupCondition(int id, QWidget *parent=nullptr)", "removed(int)", "destruct()"],
    "QgsRasterRendererRegistry": ["insert(const QgsRasterRendererRegistryEntry &entry)", "entries() const", "renderersList() const", "insertWidgetFunction(const QString &rendererName, QgsRasterRendererWidgetCreateFunc func)", "rendererData(const QString &rendererName, QgsRasterRendererRegistryEntry &data) const"],
    "QgsAdvancedDigitizingCanvasItem": ["QgsAdvancedDigitizingCanvasItem(QgsMapCanvas *canvas, QgsAdvancedDigitizingDockWidget *cadDockWidget)"],
    "QgsSimplifyMethod": ["MethodType"],
    "QgsExpressionItem": ["QgsExpressionItem(const QString &label, const QString &expressionText, QgsExpressionItem::ItemType itemType=ExpressionNode)", "ItemType", "QgsExpressionItem(const QString &label, const QString &expressionText, const QString &helpText, QgsExpressionItem::ItemType itemType=ExpressionNode)", "getExpressionText() const"],
    "QgsCptCityBrowserModel": ["endInsertItems()", "connectItem(QgsCptCityDataItem *item)", "QgsCptCityBrowserModel(QObject *parent=nullptr, QgsCptCityArchive *archive=QgsCptCityArchive::defaultArchive(), ViewType Type=Authors)", "refresh(const QString &path)", "reload()", "findItem(QgsCptCityDataItem *item, QgsCptCityDataItem *parent=nullptr) const", "refresh(const QModelIndex &index=QModelIndex())", "addRootItems()", "beginRemoveItems(QgsCptCityDataItem *parent, int first, int last)", "removeRootItems()", "endRemoveItems()", "ViewType", "beginInsertItems(QgsCptCityDataItem *parent, int first, int last)"],
    "QgsDxfPaintEngine": ["setLayer(const QString &layer)", "layer() const", "setShift(QPointF shift)", "QgsDxfPaintEngine(const QgsDxfPaintDevice *dxfDevice, QgsDxfExport *dxf)"],
    "QgsGeometryRubberBand": ["IconType"],
    "QgsProject": ["relationManager() const"],
    "QgsMapLayerLegendUtils": ["hasLegendNodeOrder(QgsLayerTreeLayer *nodeLayer)", "legendNodeOrder(QgsLayerTreeLayer *nodeLayer)", "hasLegendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex)", "legendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex)", "setLegendNodeOrder(QgsLayerTreeLayer *nodeLayer, const QList< int > &order)", "setLegendNodeUserLabel(QgsLayerTreeLayer *nodeLayer, int originalIndex, const QString &newLabel)"],
    "QgsTransformWidget": ["create()", "QgsTransformWidget(QWidget *parent=nullptr)"],
    "QgsBusyIndicatorDialog": ["message() const", "setMessage(const QString &message)"],
    "QgsSingleBandPseudoColorRenderer": ["classificationMax() const", "setClassificationMax(double max)", "create(const QDomElement &elem, QgsRasterInterface *input)", "setClassificationMin(double min)", "classificationMin() const"],
    "QgsShapeburstFillSymbolLayerWidget": ["setColor2(const QColor &color)", "setColor(const QColor &color)"],
    "QgsExpression": ["SpatialOperator", "BuiltinFunctions()", "Functions()"],
    "EditBlockerDelegate": ["EditBlockerDelegate(QObject *parent=nullptr)"],
    "QgsGeometryMultipartCheck": ["factoryDescription()", "QgsGeometryMultipartCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()"],
    "QgsGenericFeatureSelectionManager": ["QgsGenericFeatureSelectionManager(QObject *parent=nullptr)", "QgsGenericFeatureSelectionManager(const QgsFeatureIds &initialSelection, QObject *parent=nullptr)"],
    "QgsAbstractGeometry": ["QgsAbstractGeometry(const QgsAbstractGeometry &geom)"],
    "QgsMeshDatasetGroupSaveMenu": ["createSaveMenu(int groupIndex, QMenu *parentMenu=nullptr)", "setMeshLayer(QgsMeshLayer *meshLayer)", "QgsMeshDatasetGroupSaveMenu(QObject *parent=nullptr)", "datasetGroupSaved(const QString &uri)"],
    "QgsBrightnessContrastFilter": ["QgsBrightnessContrastFilter(QgsRasterInterface *input=nullptr)"],
    "QgsRasterRenderer": ["rasterTransparency() const", "usesTransparency() const", "setAlphaBand(int band)", "alphaBand() const", "setRasterTransparency(QgsRasterTransparency *t)"],
    "QgsDiagramLayerSettings": ["Placement"],
    "QgsPalettedRendererWidget": ["create(QgsRasterLayer *layer, const QgsRectangle &extent)", "QgsPalettedRendererWidget(QgsRasterLayer *layer, const QgsRectangle &extent=QgsRectangle())"],
    "CharacterWidget": ["updateFontMerging(bool enable)"],
    "QgsDataDefinedValueDialog": ["dataDefinedChanged()"],
    "QgsSlopeFilter": ["QgsSlopeFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsLayerPropertiesWidget": ["populateLayerTypes()", "changed()", "changeLayer(QgsSymbolLayer *)", "emitSignalChanged()", "layerTypeChanged()", "updateSymbolLayerWidget(QgsSymbolLayer *layer)"],
    "QgsVectorLayerCache": ["QgsVectorLayerCache(QgsVectorLayer *layer, int cacheSize, QObject *parent=nullptr)"],
    "QgsAttributeTableAction": ["execute()", "featureForm()"],
    "QgsAttributesFormProperties::DnDTreeItemData": ["visibilityExpression() const", "setQmlElementEditorConfiguration(QmlElementEditorConfiguration qmlElementEditorConfiguration)", "operator QVariant()", "setType(Type type)", "setShowLabel(bool showLabel)", "setDisplayName(const QString &displayName)", "DnDTreeItemData(Type type, const QString &name, const QString &displayName, const QColor &backgroundColor=QColor())", "setColumnCount(int count)", "displayName() const", "backgroundColor() const", "columnCount() const", "htmlElementEditorConfiguration() const", "type() const", "setHtmlElementEditorConfiguration(HtmlElementEditorConfiguration htmlElementEditorConfiguration)", "Type", "name() const", "relationEditorConfiguration() const", "qmlElementEditorConfiguration() const", "showLabel() const", "DnDTreeItemData()=default", "setRelationEditorConfiguration(RelationEditorConfiguration relationEditorConfiguration)", "setName(const QString &name)", "setBackgroundColor(const QColor &backgroundColor)"],
    "QgsVectorFieldSymbolLayer": ["angleUnits() const", "vectorFieldType() const", "createFromSld(QDomElement &element)", "xAttribute() const", "setAngleOrientation(AngleOrientation orientation)", "setScale(double s)", "AngleUnits", "setVectorFieldType(VectorFieldType type)", "yAttribute() const", "scale() const", "setXAttribute(const QString &attribute)", "AngleOrientation", "setAngleUnits(AngleUnits units)", "setDistanceMapUnitScale(const QgsMapUnitScale &scale)", "angleOrientation() const", "setYAttribute(const QString &attribute)", "distanceMapUnitScale() const", "VectorFieldType"],
    "QgsGeometryEngine": ["simplify(double tolerance, QString *errorMsg=nullptr) const =0", "interpolate(double distance, QString *errorMsg=nullptr) const =0", "envelope(QString *errorMsg=nullptr) const =0", "QgsGeometryEngine(const QgsAbstractGeometry *geometry)", "isEmpty(QString *errorMsg) const =0", "buffer(double distance, int segments, QString *errorMsg=nullptr) const =0", "area(QString *errorMsg=nullptr) const =0", "length(QString *errorMsg=nullptr) const =0"],
    "QgsRenderContext": ["QgsRenderContext(const QgsRenderContext &rh)"],
    "QgsCptCityDirectoryItem": ["dataItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "QgsCptCityDirectoryItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)", "dirEntries() const", "rampsMap()"],
    "QgsGeometryValidator": ["addError(const QgsGeometry::Error &)", "stop()"],
    "QgsWms::QgsWmsParameters": ["PdfFormatOption"],
    "QgsConstWkbPtr": ["operator>>(float &r) const", "operator const unsigned char *() const", "operator-=(int n) const", "operator+=(int n) const", "QgsConstWkbPtr(const unsigned char *p, int size)", "operator>>(double &v) const", "operator>>(int &v) const", "operator>>(unsigned int &v) const", "operator>>(char &v) const"],
    "QgsLineSymbolLayer": ["widthMapUnitScale() const", "setWidthMapUnitScale(const QgsMapUnitScale &scale)", "QgsLineSymbolLayer(bool locked=false)"],
    "QgsMapOverviewCanvas": ["updateFullExtent()", "mapRenderingFinished()", "enableAntiAliasing(bool flag)", "QgsMapOverviewCanvas(QWidget *parent=nullptr, QgsMapCanvas *mapCanvas=nullptr)"],
    "QgsDxfPaintDevice": ["setLayer(const QString &layer)", "QgsDxfPaintDevice(QgsDxfExport *dxf)", "setOutputSize(const QRectF &r)", "setDrawingSize(QSizeF size)", "setShift(QPointF shift)"],
    "QgsVectorLayerEditPassthrough": ["QgsVectorLayerEditPassthrough(QgsVectorLayer *layer)"],
    "QgsGeometrySelfContactCheck": ["QgsGeometrySelfContactCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()"],
    "QgsCollapsibleGroupBoxBasic": ["clearModifiers()", "titleRect() const", "QgsCollapsibleGroupBoxBasic(QWidget *parent=nullptr)", "QgsCollapsibleGroupBoxBasic(const QString &title, QWidget *parent=nullptr)", "checkToggled(bool ckd)", "checkClicked(bool ckd)", "toggleCollapsed()", "updateStyle()", "init()"],
    "QgsPenJoinStyleComboBox": ["setPenJoinStyle(Qt::PenJoinStyle style)", "QgsPenJoinStyleComboBox(QWidget *parent=nullptr)", "penJoinStyle() const"],
    "QgsAttributeActionPropertiesDialog": ["QgsAttributeActionPropertiesDialog(QgsVectorLayer *layer, QWidget *parent=nullptr)", "shortTitle() const", "notificationMessage() const", "type() const", "description() const", "actionText() const", "isEnabledOnlyWhenEditable() const", "capture() const", "iconPath() const", "actionScopes() const"],
    "QgsInterpolator": ["QgsInterpolator(const QList< QgsInterpolator::LayerData > &layerData)"],
    "QgsCptCityCollectionItem": ["setPopulated()", "childrenRamps(bool recursive)", "addChild(QgsCptCityDataItem *item)", "QgsCptCityCollectionItem(QgsCptCityDataItem *parent, const QString &name, const QString &path)"],
    "QgsRasterChecker": ["report() const"],
    "QgsRasterInterface": ["yBlockSize() const", "ySize() const", "QgsRasterInterface(QgsRasterInterface *input=nullptr)"],
    "HalfEdge": ["HalfEdge(int dual, int next, int point, bool mbreak, bool forced)"],
    "QgsRasterLayerRenderer": ["QgsRasterLayerRenderer(QgsRasterLayer *layer, QgsRenderContext &rendererContext)"],
    "QgsGeometrySelfIntersectionCheck": ["QgsGeometrySelfIntersectionCheck(const QgsGeometryCheckContext *context, const QVariantMap &configuration=QVariantMap())", "ResolutionMethod"],
    "QgsOfflineEditing": ["ProgressMode"],
    "QgsMeshDatasetGroupTreeView": ["resetDefault(QgsMeshLayer *meshLayer)", "apply()", "selectAllGroups()", "QgsMeshDatasetGroupTreeView(QWidget *parent=nullptr)", "syncToLayer(QgsMeshLayer *layer)", "deselectAllGroups()", "datasetGroupTreeRootItem()"],
    "QgsMapLayerComboBox": ["indexChanged(int i)", "rowsChanged()"],
    "QgsGeometryTypeCheck": ["factoryDescription()", "QgsGeometryTypeCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration, int allowedTypes)", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()"],
    "QgsRendererWidget": ["QgsRendererWidget(QgsVectorLayer *layer, QgsStyle *style)", "copy()", "contextMenuViewCategories(QPoint p)", "paste()", "refreshSymbolView()"],
    "QgsVectorLayerProperties": ["toggleEditing(QgsMapLayer *)", "exportAuxiliaryLayer(QgsAuxiliaryLayer *layer)", "QgsVectorLayerProperties(QgsMapCanvas *canvas, QgsMessageBar *messageBar, QgsVectorLayer *lyr=nullptr, QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)"],
    "QgsGeometrySelfIntersectionCheckError": ["QgsGeometrySelfIntersectionCheckError(const QgsSingleGeometryCheck *check, const QgsGeometry &geometry, const QgsGeometry &errorLocation, QgsVertexId vertexId, const QgsGeometryUtils::SelfIntersection &intersection)", "intersection() const"],
    "QgsSingleSymbolRendererWidget": ["QgsSingleSymbolRendererWidget(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)", "create(QgsVectorLayer *layer, QgsStyle *style, QgsFeatureRenderer *renderer)"],
    "QgsCategorizedSymbolRenderer": ["rebuildHash()"],
    "QgsDualView": ["openConditionalStyles()"],
    "QgsRuleBasedLabelProvider": ["QgsRuleBasedLabelProvider(const QgsRuleBasedLabeling &rules, QgsVectorLayer *layer, bool withFeatureLoop=true)"],
    "QgsMapToolAdvancedDigitizing": ["cadDockWidget() const"],
    "QgsOptionsDialogBase": ["warnAboutMissingObjects()", "updateWindowTitle()", "setSettings(QgsSettings *settings)"],
    "QgsSymbolsListWidget": ["updateDataDefinedMarkerAngle()", "setMarkerSize(double size)", "changed()", "setLineWidth(double width)", "updateDataDefinedMarkerSize()", "setMarkerAngle(double angle)", "clipFeaturesToggled(bool checked)", "updateDataDefinedLineWidth()", "setSymbolColor(const QColor &color)"],
    "QgsRasterShader": ["rasterShaderFunction() const", "QgsRasterShader(double minimumValue=0.0, double maximumValue=255.0)", "rasterShaderFunction()"],
    "QgsGeometryAreaCheck": ["factoryDescription()", "QgsGeometryAreaCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()"],
    "QgsWkbPtr": ["operator>>(float &r) const", "QgsWkbPtr(unsigned char *p, int size)", "operator+=(int n) const", "operator>>(double &v) const", "operator unsigned char *() const"],
    "QgsMapToolEdit": ["QgsMapToolEdit(QgsMapCanvas *canvas)"],
    "QgsSymbolLegendNode": ["iconSize() const"],
    "QgsDataDefinedSizeDialog": ["QgsDataDefinedSizeDialog(const QList< QgsSymbol * > &symbolList, QgsVectorLayer *layer)"],
    "QgsGeometryDuplicateNodesCheck": ["QgsGeometryDuplicateNodesCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryDescription()", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()"],
    "QgsTotalCurvatureFilter": ["QgsTotalCurvatureFilter(const QString &inputFile, const QString &outputFile, const QString &outputFormat)"],
    "QgsAttributeFormInterface": ["featureChanged()", "form()", "feature()", "QgsAttributeFormInterface(QgsAttributeForm *form)", "acceptChanges(const QgsFeature &feature)", "initForm()"],
    "QgsGeometryPointCoveredByLineCheck": ["factoryDescription()", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "QgsGeometryPointCoveredByLineCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()"],
    "QgsGeometryContainedCheckError": ["QgsGeometryContainedCheckError(const QgsGeometryCheck *check, const QgsGeometryCheckerUtils::LayerFeature &layerFeature, const QgsPointXY &errorLocation, const QgsGeometryCheckerUtils::LayerFeature &containingFeature)", "containingFeature() const"],
    "QgsAuthCertInfo": ["trustCacheRebuilt()"],
    "QgsGeometryHoleCheck": ["factoryDescription()", "factoryIsCompatible(QgsVectorLayer *layer)", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "QgsGeometryHoleCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "factoryId()"],
    "QgsMapRendererJob": ["QgsMapRendererJob(const QgsMapSettings &settings)"],
    "QgsRendererCategory": ["swap(QgsRendererCategory &other)"],
    "pal::Problem": ["init_sol_falp()", "reduce()"],
    "QgsPaintEffectWidget": ["QgsPaintEffectWidget(QWidget *parent=nullptr)"],
    "QgsBrowserTreeView": ["setSettingsSection(const QString &section)", "hasExpandedDescendant(const QModelIndex &index) const"],
    "QgsAttributeTypeLoadDialog": ["QgsAttributeTypeLoadDialog(QgsVectorLayer *vl)"],
    "QgsMapSettings": ["updateDerived()", "readXml(QDomNode &node)", "writeXml(QDomNode &node, QDomDocument &doc)", "mapToPixel() const"],
    "QgsManageConnectionsDialog": ["selectionChanged()", "clearSelection()", "doExportImport()", "Mode", "selectAll()", "Type"],
    "QgsLayerTreeNode": ["QgsLayerTreeNode(const QgsLayerTreeNode &other)"],
    "QgsPointLocator_VisitorNearestVertex": ["QgsPointLocator_VisitorNearestVertex(QgsPointLocator *pl, QgsPointLocator::Match &m, const QgsPointXY &srcPoint, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "QgsErrorItem": ["QgsErrorItem(QgsDataItem *parent, const QString &error, const QString &path)"],
    "QgsAttributeForm": ["QgsAttributeForm(QgsVectorLayer *vl, const QgsFeature &feature=QgsFeature(), const QgsAttributeEditorContext &context=QgsAttributeEditorContext(), QWidget *parent=nullptr)", "feature()"],
    "QgsSocketMonitoringThread": ["run()"],
    "QgsMeshDatasetGroupTreeWidget": ["datasetGroupAdded()"],
    "QgsWmsDimensionDialog": ["setInfo(const QgsMapLayerServerProperties::WmsDimensionInfo &info)", "QgsWmsDimensionDialog(QgsVectorLayer *layer, QStringList alreadyDefinedDimensions, QWidget *parent=nullptr, Qt::WindowFlags f=Qt::WindowFlags())", "info() const"],
    "QgsMapToolIdentify": ["formatChanged(QgsRasterLayer *layer)", "identifyMessage(const QString &)", "IdentifyMode", "identifyProgress(int, int)", "Type", "changedRasterResults(QList< QgsMapToolIdentify::IdentifyResult > &)"],
    "QgsEllipseSymbolLayer": ["createFromSld(QDomElement &element)", "strokeWidth() const", "strokeWidthMapUnitScale() const", "symbolWidth() const", "setStrokeWidth(double w)", "strokeStyle() const", "symbolHeight() const", "setSymbolHeightMapUnitScale(const QgsMapUnitScale &scale)", "setSymbolWidth(double w)", "symbolWidthMapUnitScale() const", "setStrokeWidthMapUnitScale(const QgsMapUnitScale &scale)", "setSymbolWidthMapUnitScale(const QgsMapUnitScale &scale)", "setStrokeStyle(Qt::PenStyle strokeStyle)", "setSymbolHeight(double h)", "symbolHeightMapUnitScale() const"],
    "QgsPluginLayer": ["QgsPluginLayer(const QString &layerType, const QString &layerName=QString())"],
    "QgsMapRendererParallelJob": ["QgsMapRendererParallelJob(const QgsMapSettings &settings)"],
    "QgsVectorLayerFeatureIterator": ["QgsVectorLayerFeatureIterator(QgsVectorLayerFeatureSource *source, bool ownSource, const QgsFeatureRequest &request)"],
    "QgsMapLayer": ["readSld(const QDomNode &node, QString &errorMessage)"],
    "QgsFieldExpressionWidget": ["setLeftHandButtonStyle(bool isLeft)", "currentFieldChanged()", "isExpressionValid(const QString &expressionStr)"],
    "QgsContrastEnhancementFunction": ["QgsContrastEnhancementFunction(const QgsContrastEnhancementFunction &f)", "QgsContrastEnhancementFunction(Qgis::DataType, double, double)"],
    "QgsAttributeTableMapLayerAction": ["execute()", "QgsAttributeTableMapLayerAction(const QString &name, QgsDualView *dualView, QgsMapLayerAction *action, const QModelIndex &fieldIdx)"],
    "QgsSymbolLayerWidget": ["symbolLayer()=0", "setSymbolLayer(QgsSymbolLayer *layer)=0", "updateDataDefinedProperty()"],
    "QgsGeometryFollowBoundariesCheck": ["factoryDescription()", "QgsGeometryFollowBoundariesCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration, QgsVectorLayer *checkLayer)", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()"],
    "QgsLayerTreeView": ["onCurrentChanged()", "onExpandedChanged(QgsLayerTreeNode *node, bool expanded)", "updateExpandedStateToNode(const QModelIndex &index)", "modelRowsRemoved()", "updateExpandedStateFromNode(QgsLayerTreeNode *node)", "onModelReset()", "modelRowsInserted(const QModelIndex &index, int start, int end)", "layerForIndex(const QModelIndex &index) const"],
    "CloughTocherInterpolator": ["setTriangulation(NormVecDecorator *tin)"],
    "QgsDefaultVectorLayerLegend": ["QgsDefaultVectorLayerLegend(QgsVectorLayer *vl)"],
    "QgsAttributeEditorContext": ["QgsAttributeEditorContext(const QgsAttributeEditorContext &parentContext, FormMode formMode)", "FormMode", "QgsAttributeEditorContext(const QgsAttributeEditorContext &parentContext, const QgsRelation &relation, RelationMode relationMode, FormMode widgetMode)", "parentContext() const"],
    "QgsGpsConnectionRegistry": ["connectionList() const"],
    "QgsGeometryDangleCheck": ["factoryDescription()", "QgsGeometryDangleCheck(QgsGeometryCheckContext *context, const QVariantMap &configuration)", "ResolutionMethod", "factoryCompatibleGeometryTypes()", "factoryCheckType()", "factoryIsCompatible(QgsVectorLayer *layer)", "factoryId()"],
    "QgsCptCityDataItem": ["icon()", "toolTip() const", "parent() const", "children() const", "hasChildren()", "populate()", "icon(QSize size)", "rowCount()", "paramWidget()", "handleDrop(const QMimeData *, Qt::DropAction)", "type() const", "beginRemoveItems(QgsCptCityDataItem *parent, int first, int last)", "endRemoveItems()", "path() const", "Type", "isPopulated()", "endInsertItems()", "name() const", "refresh()", "setIcon(const QIcon &icon)", "deleteChildItem(QgsCptCityDataItem *child)", "leafCount() const", "isValid()", "setToolTip(const QString &msg)", "createChildren()", "QgsCptCityDataItem(QgsCptCityDataItem::Type type, QgsCptCityDataItem *parent, const QString &name, const QString &path)", "setParent(QgsCptCityDataItem *parent)", "addChildItem(QgsCptCityDataItem *child, bool refresh=false)", "beginInsertItems(QgsCptCityDataItem *parent, int first, int last)", "shortInfo() const", "acceptDrop()", "info() const", "findItem(QVector< QgsCptCityDataItem * > items, QgsCptCityDataItem *item)", "removeChildItem(QgsCptCityDataItem *child)", "equal(const QgsCptCityDataItem *other)"],
    "QgsRasterNuller": ["setNoData(int bandNo, const QgsRasterRangeList &noData)", "noData(int bandNo) const", "QgsRasterNuller(QgsRasterInterface *input=nullptr)"],
    "QgsMapThemeCollection": ["setProject(QgsProject *project)"],
    "QgsLayerItem": ["iconDefault()", "iconRaster()", "iconPoint()", "iconPolygon()", "iconTable()", "iconLine()"],
    "QgsCacheIndexFeatureId": ["QgsCacheIndexFeatureId(QgsVectorLayerCache *)"],
    "QgsPointLocator_VisitorEdgesInRect": ["QgsPointLocator_VisitorEdgesInRect(QgsPointLocator *pl, QgsPointLocator::MatchList &lst, const QgsRectangle &srcRect, QgsPointLocator::MatchFilter *filter=nullptr)"],
    "QgsCptCityColorRampItem": ["ramp() const", "QgsCptCityColorRampItem(QgsCptCityDataItem *parent, const QString &name, const QString &path, const QStringList &variantList, bool initialize=false)", "init()", "QgsCptCityColorRampItem(QgsCptCityDataItem *parent, const QString &name, const QString &path, const QString &variantName=QString(), bool initialize=false)"],
    "QgsTextDiagram": ["Shape", "Orientation"],
    "QgsSublayersDialog": ["ProviderType"],
    "QgsCharacterSelectorDialog": ["QgsCharacterSelectorDialog(QWidget *parent=nullptr, Qt::WindowFlags fl=QgsGuiUtils::ModalDialogFlags)"],
    "QgisVisitor": ["QgisVisitor(QList< QgsFeatureId > &list)"],
    "QgsLabelingEngine": ["processProvider(QgsAbstractLabelProvider *provider, QgsRenderContext &context, pal::Pal &p)"],
    "QgsNetworkAccessManager": ["requestTimedOut(QNetworkReply *)", "QgsNetworkAccessManager(QObject *parent=nullptr)"],
    "QgsGpsConnection": ["Status"],
}

ACCEPTABLE_MISSING_ADDED_NOTE = [
    "QgsProcessingContext",
    "QgsPointDistanceRenderer",
    "QgsScaleBarRenderer",
    "QgsVector3D",
    "QgsPropertyCollectionStack",
    "QgsWkbTypes",
    "QgsProcessingParameterNumber",
    "QgsRasterSymbolLegendNode",
    "QgsTessellator",
    "QgsRuleBasedLabeling",
    "QgsSqlExpressionCompiler",
    "QgsAnnotation",
    "QgsListWidgetWrapper",
    "QgsTerrainGenerator",
    "QgsRandomColorRamp",
    "QgsLayoutItemMapItem",
    "QgsService",
    "QgsLayoutModel",
    "QgsAttributeFormEditorWidget",
    "QgsLegendSymbolItem",
    "QgsTextFormatPanelWidget",
    "QgsColorBrewerColorRampDialog",
    "QgsServerResponse",
    "QgsActionScope",
    "QgsServerLogger",
    "QgsLocatorProxyModel",
    "QgsMultiRenderChecker",
    "QgsEffectPainter",
    "QgsFeatureRequest::OrderByClause",
    "QgsServiceNativeLoader",
    "QgsCurveEditorWidget",
    "QgsEditorWidgetSetup",
    "QgsTextRenderer",
    "QgsWms::QgsRenderer",
    "QgsDataItemProviderRegistry",
    "QgsLayoutSize",
    "QgsServerException",
    "QgsOptionsDialogHighlightWidget",
    "QgsGraph",
    "QgsTicksScaleBarRenderer",
    "QgsLimitedRandomColorRamp",
    "QgsProjectionSelectionDialog",
    "QgsVectorLayerUtils::QgsDuplicateFeatureContext",
    "QgsHelp",
    "QgsCodeEditorSQL",
    "QgsProjectionSelectionWidget",
    "QgsMapRendererSequentialJob",
    "QgsLayerTreeRegistryBridge",
    "QgsPrintLayout",
    "QgsNetworkSpeedStrategy",
    "QgsStyleSaveDialog",
    "QgsGeometryUtils",
    "QgsTinInterpolator",
    "QgsProcessingOutputString",
    "QgsKeyValueWidgetWrapper",
    "QgsMapThemeCollection::MapThemeLayerRecord",
    "QgsPresetColorRampWidget",
    "QgsVectorLayer3DRendererMetadata",
    "QgsFieldFormatter",
    "QgsGradientStopEditor",
    "QgsVectorLayerUndoPassthroughCommandDeleteFeatures",
    "QgsVectorLayerRenderer",
    "QgsMasterLayoutInterface",
    "QgsPropertyOverrideButton",
    "QgsFeatureFilter",
    "QgsLayoutItemMapOverviewStack",
    "QgsProjectHomeItem",
    "QgsRasterCalculatorEntry",
    "QgsSvgAnnotation",
    "QgsMapLayerDependency",
    "QgsUserProfile",
    "QgsBearingUtils",
    "QgsNullSymbolRenderer",
    "QgsSnappingConfig::IndividualLayerSettings",
    "QgsFcgiServerResponse",
    "QgsWfs::QgsBadRequestException",
    "QgsFloatingWidget",
    "QgsServiceModule",
    "QgsRegularPolygon",
    "QgsLayoutItemBaseWidget",
    "QgsColorRampButton",
    "Qgs3DAlgorithms",
    "QgsAbstract3DRenderer",
    "QgsLayerTreeGroup",
    "QgsLayoutGuideProxyModel",
    "QgsSnappingConfig",
    "QgsAttributeFormRelationEditorWidget",
    "QgsValueRelationFieldFormatter",
    "QgsFeatureSink",
    "QgsHtmlUtils",
    "QgsExtentGroupBox",
    "QgsFeatureListComboBox",
    "QgsLayoutItemGroup",
    "QgsLayoutItemMapGrid",
    "QgsProcessingParameterFolderDestination",
    "QgsLayoutTableColumn",
    "QgsWebPage",
    "QgsFeatureFilterProviderGroup",
    "QgsTableWidgetBase",
    "QgsLayoutViewRubberBand",
    "QgsGeometrySnapper",
    "QgsLayoutTable",
    "QgsAccessControl",
    "QgsPasswordLineEdit",
    "QgsVectorLayerUndoPassthroughCommand",
    "QgsGmlStreamingParser",
    "QgsFieldConditionalFormatWidget",
    "QgsVectorLayerDirector",
    "QgsLocator",
    "QgsFeatureSource",
    "QgsAbstractVectorLayerLabeling",
    "QgsPointLocator",
    "QgsOptionsDialogHighlightButton",
    "QgsColorSwatchDelegate",
    "QgsCustomDropHandler",
    "QgsMargins",
    "QgsVectorLayerExporter",
    "QgsCodeEditorCSS",
    "QgsFormAnnotation",
    "QgsFieldValuesLineEdit",
    "QgsPropertyCollection",
    "QgsOgcUtils::LayerProperties",
    "QgsCircularString",
    "QgsLayerTreeViewMenuProvider",
    "QgsGraphEdge",
    "QgsFieldComboBox",
    "QgsVectorLayerUndoPassthroughCommandRenameAttribute",
    "QgsPaintEffect",
    "QgsSingleBoxScaleBarRenderer",
    "QgsAbstractMetadataBaseValidator::ValidationResult",
    "QgsInvertedPolygonRenderer",
    "QgsPhongMaterialSettings",
    "QgsColorSwatchGridAction",
    "QgsMapRendererCache",
    "QgsFilterResponseDecorator",
    "QgsColorWidget",
    "QgsLayoutReportContext",
    "QgsLayoutViewToolTemporaryKeyZoom",
    "QgsHeatmapRenderer",
    "QgsGplColorScheme",
    "Qgs3DRendererAbstractMetadata",
    "QgsHillshadeRenderer",
    "QgsVectorLayer3DRenderer",
    "QgsMenuHeaderWidgetAction",
    "QgsCircle",
    "QgsLayoutGridSettings",
    "QgsVScrollArea",
    "QgsSensorMetadata",
    "QgsGlowEffect",
    "QgsListWidgetFactory",
    "QgsLayoutTableStyle",
    "QgsTextFormat",
    "QgsCodeEditor",
    "QgsServiceRegistry",
    "QgsColorSwatchGrid",
    "QgsExpressionFunction::Parameter",
    "QgsLayoutView",
    "QgsProcessingParameterMultipleLayers",
    "QgsVertexIterator",
    "QgsLayoutItemRenderContext",
    "QgsProxyFeatureSink",
    "QgsPainting",
    "QgsLayerTree",
    "QgsNewAuxiliaryLayerDialog",
    "QgsSymbolWidgetContext",
    "QgsLayerTreeViewDefaultActions",
    "QgsLayoutNodesItem",
    "QgsCompoundColorWidget",
    "QgsDataDefinedSizeLegend",
    "QgsProcessingParameterMapLayer",
    "QgsPaintEffectRegistry",
    "QgsExpressionContextScopeGenerator",
    "QgsDoubleRange",
    "QgsOptionsPageWidget",
    "QgsWfs::QgsServiceException",
    "QgsStringUtils",
    "QgsInnerShadowEffect",
    "QgsProcessingOutputDefinition",
    "QgsLayoutItemPolyline",
    "QgsLayoutImageExportOptionsDialog",
    "QgsLayerTreeModel",
    "QgsEncodingSelectionDialog",
    "QgsFavoritesItem",
    "QgsLayoutManager",
    "QgsLayerTreeLayer",
    "Qgs3DUtils",
    "QgsProcessingParameterMatrix",
    "QgsReadWriteContext",
    "QgsEffectDrawModeComboBox",
    "QgsTask",
    "QgsLayerTreeMapCanvasBridge",
    "QgsMapCanvasSnappingUtils",
    "QgsPresetSchemeColorRamp",
    "QgsLine3DSymbol",
    "QgsProcessingFeatureSink",
    "QgsProcessingOutputFolder",
    "QgsLayerMetadata",
    "QgsFontButton",
    "QgsMultiPolygon",
    "QgsCheckboxSearchWidgetWrapper",
    "QgsMapHitTest",
    "QgsFeatureFilterProvider",
    "QgsKeyValueWidget",
    "QgsFileDownloader",
    "QgsProcessingParameterField",
    "QgsEditorWidgetAutoConfPlugin",
    "QgsRelationReferenceFieldFormatter",
    "QgsLayoutMultiFrameAbstractMetadata",
    "QgsAbstractGeometry::vertex_iterator",
    "QgsLocatorAutomaticModel",
    "QgsMapCanvasTracer",
    "QgsSubstitutionListWidget",
    "QgsLocatorModel",
    "QgsPageSize",
    "QgsMultiCurve",
    "QgsMapLayerModel",
    "QgsJsonUtils",
    "QgsLayoutViewMouseEvent",
    "QgsGeometryEditUtils",
    "QgsColorBox",
    "QgsLegendModel",
    "QgsProcessingFeatureSource",
    "QgsLayoutPoint",
    "Qgs3DMapScene",
    "QgsDemTerrainGenerator",
    "Qgs3DMapSettings",
    "QgsProcessingParameterPoint",
    "QgsLayerTreeUtils",
    "QgsVectorFileWriter::FieldValueConverter",
    "QgsSimpleMarkerSymbolLayerBase",
    "QgsMapRendererQImageJob",
    "QgsBlurEffect",
    "QgsFileUtils",
    "QgsRecentColorScheme",
    "QgsDoubleBoxScaleBarRenderer",
    "QgsOWSServerFilterRestorer",
    "QgsVectorLayerUndoPassthroughCommandChangeAttributes",
    "QgsVectorLayerLabelProvider",
    "QgsTextShadowSettings",
    "QgsDatumTransform",
    "QgsLayoutDesignerInterface",
    "QgsInternalGeometrySnapper",
    "QgsCadUtils::AlignMapPointConstraint",
    "QgsVariableEditorWidget",
    "QgsMapUnitScaleWidget",
    "QgsMapRendererCustomPainterJob",
    "QgsExpressionFieldBuffer",
    "QgsColorEffect",
    "QgsWms::QgsMapRendererJobProxy",
    "QgsColorScheme",
    "QgsLayoutMeasurement",
    "QgsSnapIndicator",
    "QgsFeaturePickerModel",
    "QgsAuthSettingsWidget",
    "QgsGradientStop",
    "QgsProcessingDestinationParameter",
    "QgsSQLStatement",
    "QgsOpacityWidget",
    "QgsLegendSettings",
    "QgsLayoutViewToolAddNodeItem",
    "QgsOptionsDialogHighlightLabel",
    "QgsProjectPropertyValue",
    "QgsWidgetStateHelper",
    "QgsListWidget",
    "QgsSnappingUtils",
    "QgsLayoutViewToolTemporaryMousePan",
    "QgsServerSettingsEnv",
    "QgsValueMapFieldFormatter",
    "QgsNewNameDialog",
    "QgsLegendFilterButton",
    "QgsTaskManagerWidget",
    "QgsImageOperation",
    "QgsPaintEffectAbstractMetadata",
    "QgsTextEditSearchWidgetWrapper",
    "QgsCameraController",
    "QgsDefaultRasterLayerLegend",
    "QgsMapLayerProxyModel",
    "QgsMapRendererTask",
    "QgsServerSettings",
    "QgsTextFormatWidget",
    "QgsAbstract3DSymbol",
    "QgsPointClusterRendererWidget",
    "QgsLayoutTableBackgroundColorsDialog",
    "QgsNativeAlgorithms",
    "QgsProcessingParameterExpression",
    "QgsProcessingFeedback",
    "QgsProcessingUtils",
    "QgsDataDefinedSizeLegendNode",
    "QgsLayoutViewToolPan",
    "QgsCodeEditorPython",
    "QgsAttributeTableConfig",
    "QgsGenericNumericTransformer",
    "QgsProjectionSelectionTreeWidget",
    "QgsTextPreview",
    "QgsMenuHeader",
    "QgsLocatorWidget",
    "QgsDropShadowEffect",
    "QgsProcessingParameterFile",
    "QgsMetadataWidget",
    "QgsExpressionContextScope",
    "QgsProcessingOutputHtml",
    "QgsLayoutItemGuiGroup",
    "QgsAlignRaster",
    "QgsHillshadeRendererWidget",
    "QgsWcs::QgsServiceException",
    "QgsLayoutItemMetadata",
    "QgsLayoutPageCollection",
    "QgsColorRamp",
    "QgsStringReplacementCollection",
    "QgsLayoutItemMapOverview",
    "QgsColorBrewerColorRamp",
    "QgsProcessingParameters",
    "QgsProcessingOutputRasterLayer",
    "QgsLayoutUtils",
    "QgsServerPlugins",
    "QgsSensorGuiMetadata",
    "QgsAuxiliaryStorage",
    "QgsLayoutFrame",
    "QgsLayoutItemRegistry",
    "QgsGeometryCollection",
    "QgsLayoutViewTriangleRubberBand",
    "QgsIntRange",
    "QgsLayoutViewToolEditNodes",
    "QgsMemoryProviderUtils",
    "QgsGradientColorRampDialog",
    "QgsProcessing",
    "QgsProjectPropertyKey",
    "QgsVectorFileWriterTask",
    "QgsAnnotationManager",
    "QgsNetworkContentFetcher",
    "QgsFavoriteItem",
    "QgsLayoutViewTool",
    "QgsHistogramWidget",
    "QgsLayoutViewMenuProvider",
    "QgsLayoutItemGuiRegistry",
    "QgsOuterGlowEffect",
    "QgsArrowSymbolLayer",
    "QgsPolygon3DSymbol",
    "QgsProcessingParameterBoolean",
    "QgsSourceSelectProvider",
    "QgsColorWheel",
    "QgsExpressionContext",
    "QgsMapDecoration",
    "QgsProcessingParameterCrs",
    "QgsDataItemProvider",
    "QgsColorSchemeModel",
    "QgsOptionsDialogHighlightCheckBox",
    "QgsOptionalExpression",
    "QgsMultiLineString",
    "QgsLayoutAligner",
    "QgsTemporalRange",
    "QgsLayoutItemPropertiesWidget",
    "QgsLabelFeature",
    "QgsLayerTreeEmbeddedWidgetRegistry",
    "QgsLayerTreeModelLegendNode",
    "QgsAbstractDataSourceWidget",
    "QgsOptionsWidgetFactory",
    "QgsLayoutConfigObject",
    "QgsEllipse",
    "QgsCurveTransform",
    "QgsMapThemeCollection::MapThemeRecord",
    "QgsLabelingEngineSettings",
    "QgsObjectCustomProperties",
    "QgsLayoutUndoObjectInterface",
    "QgsOptionsDialogHighlightTree",
    "QgsWmsLegendNode",
    "QgsRendererRangeLabelFormat",
    "QgsAbstractLabelProvider",
    "QgsCheckableItemModel",
    "QgsServerRequest",
    "QgsColorTextWidget",
    "QgsCustomLayerOrderWidget",
    "QgsLayoutProxyModel",
    "QgsWms::QgsServiceException",
    "QgsWfs::QgsWfsParameters",
    "QgsFeedback",
    "QgsExpressionLineEdit",
    "QgsNewAuxiliaryFieldDialog",
    "QgsFieldConstraints",
    "QgsRasterFileWriterTask",
    "QgsCurvePolygon",
    "QgsLayoutViewToolMoveItemContent",
    "QgsOptionsDialogHighlightGroupBox",
    "QgsNetworkDistanceStrategy",
    "QgsTaskManager",
    "QgsDateTimeSearchWidgetWrapper",
    "QgsUserInputWidget",
    "QgsCadUtils",
    "QgsProcessingOutputLayerDefinition",
    "QgsProcessingParameterEnum",
    "QgsProcessingException",
    "QgsLayerMetadataFormatter",
    "QgsEffectStackPropertiesWidget",
    "QgsLayoutItemPolygon",
    "QgsDatabaseFilterProxyModel",
    "QgsFlatTerrainGenerator",
    "QgsInterval",
    "QgsProjectProperty",
    "QgsShadowEffect",
    "QgsProcessingParameterRange",
    "QgsProcessingProvider",
    "QgsCompoundCurve",
    "QgsStringStatisticalSummary",
    "QgsMapToolExtent",
    "QgsUserProfileManager",
    "QgsSignalBlocker",
    "QgsLayoutItemAttributeTable",
    "QgsKeyValueWidgetFactory",
    "QgsPageSizeRegistry",
    "QgsTextBufferSettings",
    "QgsHistogram",
    "QgsLayoutAtlas",
    "QgsWfs::QgsSecurityAccessException",
    "QgsProcessingAlgorithm",
    "QgsFcgiServerRequest",
    "QgsLayoutItemPicture",
    "QgsReferencedPointXY",
    "QgsLayoutExporter",
    "QgsVectorLayerFeatureCounter",
    "QgsRange",
    "QgsLayerRestorer",
    "QgsAggregateCalculator",
    "QgsLayoutObject",
    "QgsMultiEditToolButton",
    "QgsRasterBlockFeedback",
    "QgsMapCanvasAnnotationItem",
    "QgsConfigureShortcutsDialog",
    "QgsColorWidgetAction",
    "QgsLayoutSerializableObject",
    "QgsColorButton",
    "QgsTessellatedPolygonGeometry",
    "QgsLayoutViewToolSelect",
    "QgsProcessingParameterVectorLayer",
    "QgsLayoutItemShape",
    "QgsLimitedRandomColorRampDialog",
    "QgsCptCityColorRampDialog",
    "QgsLayoutItemScaleBar",
    "sqlite3_database_unique_ptr",
    "QgsColorSliderWidget",
    "QgsProcessingParameterLimitedDataTypes",
    "QgsPoint3DSymbol",
    "QgsMapSettingsUtils",
    "QgsStringReplacement",
    "QgsGeometryFactory",
    "QgsProperty",
    "QgsProjectColorScheme",
    "QgsProcessingFeatureSourceDefinition",
    "QgsNmeaConnection",
    "QgsPropertyDefinition",
    "QgsInnerGlowEffect",
    "QgsVectorLayerSaveAsDialog",
    "QgsAbstractFeatureSource",
    "QgsProcessingAlgRunnerTask",
    "sqlite3_statement_unique_ptr",
    "QgsUnitTypes",
    "QgsAABB",
    "QgsVectorFileWriter::SaveVectorOptions",
    "QgsProcessingParameterFileDestination",
    "QgsProcessingParameterBand",
    "QgsPaintEffectPropertiesWidget",
    "QgsEffectStack",
    "QgsLayoutItemGuiMetadata",
    "QgsNativeMetadataValidator",
    "QgsVectorLayerUndoPassthroughCommandAddFeatures",
    "QgsPaintEffectMetadata",
    "QgsLayoutGuideCollection",
    "QgsEffectStackPropertiesDialog",
    "QgsServerInterfaceImpl",
    "QgsDataSourceManagerDialog",
    "QgsPoint",
    "QgsFieldProxyModel",
    "QgsVectorLayerSelectedFeatureSource",
    "QgsLayerTreeEmbeddedWidgetProvider",
    "QgsSimplifyMethod",
    "QgsStatusBar",
    "QgsProcessingParameterExtent",
    "QgsLayoutUnitsComboBox",
    "QgsLayoutItemHtml",
    "QgsVectorLayerUtils",
    "QgsProcessingParameterRasterDestination",
    "QgsNullSymbolRendererWidget",
    "QgsLayoutGuide",
    "QgsSettings",
    "QgsMapLayerLegendUtils",
    "QgsPolygon",
    "QgsTriangle",
    "QgsCadUtils::AlignMapPointContext",
    "QgsShortcutsManager",
    "QgsLayoutUndoStack",
    "QgsMapLayerConfigWidget",
    "QgsCheckBoxDelegate",
    "QgsTreeWidgetItemObject",
    "QgsProjectArchive",
    "QgsPointXY",
    "QgsVectorLayerDiagramProvider",
    "QgsAbstractGeometry",
    "QgsProcessingOutputMapLayer",
    "QgsMapLayerStore",
    "QgsColorRampTransformer",
    "QgsRasterFillSymbolLayer",
    "QgsMultiSurface",
    "QgsLayoutCustomDropHandler",
    "QgsLayoutViewToolZoom",
    "QgsFieldModel",
    "QgsFilledMarkerSymbolLayer",
    "QgsProcessingParameterFeatureSink",
    "QgsLayoutItemTextTable",
    "QgsMeshRenderer3DAveragingWidget",
    "QgsDrawSourceEffect",
    "QgsFileDownloaderDialog",
    "QgsGeometryEngine",
    "QgsBrowserDockWidget",
    "QgsBufferServerResponse",
    "QgsLayoutItemMapGridStack",
    "QgsColorDialog",
    "QgsWfs::QgsRequestNotWellFormedException",
    "QgsGraduatedHistogramWidget",
    "QgsDataDefinedSizeLegendWidget",
    "QgsFallbackFieldFormatter",
    "QgsLayoutItemLabel",
    "QgsArchive",
    "QgsTextAnnotation",
    "QgsLabelingUtils",
    "QgsWms::QgsWmsParameters",
    "QgsRasterMinMaxOrigin",
    "QgsWms::QgsBadRequestException",
    "QgsMapLayerRenderer",
    "QgsProcessingMultiStepFeedback",
    "QgsVectorLayerUndoCommandRenameAttribute",
    "QgsSymbolButton",
    "QgsFilledMarkerSymbolLayerWidget",
    "QgsRangeFieldFormatter",
    "QgsFocusWatcher",
    "QgsColorBrewerColorRampWidget",
    "QgsProcessingParameterRasterLayer",
    "QgsGui",
    "QgsLayoutItemPage",
    "QgsProcessingContext::LayerDetails",
    "QgsLabelingResults",
    "QgsLayerTreeEmbeddedConfigWidget",
    "QgsEffectStackCompactWidget",
    "QgsTreeWidgetItem",
    "QgsTracer",
    "QgsLayoutViewToolTemporaryKeyPan",
    "QgsVectorLayerJoinInfo",
    "QgsOrganizeTableColumnsDialog",
    "QgsReferencedRectangle",
    "QgsVertexId",
    "QgsActionScopeRegistry",
    "QgsRasterLayerRenderer",
    "QgsMapLayerComboBox",
    "QgsDefaultValue",
    "QgsProcessingOutputNumber",
    "QgsProcessingOutputMultipleLayers",
    "QgsRatioLockButton",
    "QgsMapLayerStyleManager",
    "QgsCurve",
    "QgsTilingScheme",
    "QgsFieldFormatterRegistry",
    "QgsWcs::QgsRequestNotWellFormedException",
    "QgsColorRampWidget",
    "QgsFeatureRequest::OrderBy",
    "QgsImageLegendNode",
    "QgsLayoutItemLegend",
    "QgsLegendRenderer",
    "QgsOptional",
    "QgsSearchWidgetToolButton",
    "QgsScrollArea",
    "QgsAbstractLayoutUndoCommand",
    "QgsBox3D",
    "QgsCompositionConverter",
    "QgsRelationAggregateSearchWidgetWrapper",
    "QgsAbstractMaterialSettings",
    "QgsGraphVertex",
    "QgsProcessingParameterFeatureSource",
    "QgsTransformEffect",
    "QgsOgrUtils",
    "QgsAbstractLayoutIterator",
    "QgsLayoutItemPropertiesDialog",
    "QgsSimpleLegendNode",
    "QgsLayoutMeasurementConverter",
    "QgsBufferServerRequest",
    "QgsScopedExpressionFunction",
    "QgsLayout",
    "QgsNetworkStrategy",
    "QgsWithVariableExpressionFunction",
    "QgsVectorLayerSimpleLabeling",
    "QgsLayoutItemMap",
    "QgsSymbolLegendNode",
    "QgsSymbolLevelsWidget",
    "QgsReferencedGeometryBase",
    "spatialite_database_unique_ptr",
    "QgsColorSchemeRegistry",
    "QgsLayoutMultiFrameMetadata",
    "QgsLayoutItemMapItemStack",
    "QgsCheckableComboBox",
    "QgsEllipsoidUtils",
    "QgsAbstractPropertyCollection",
    "QgsProcessingParameterString",
    "QgsLayoutItemComboBox",
    "QgsVectorLayerUndoPassthroughCommandDeleteAttribute",
    "QgsCodeEditorHTML",
    "QgsVectorSimplifyMethod",
    "QgsStatisticalSummary",
    "QgsProcessingRegistry",
    "QgsLocatorFilter",
    "QgsProcessingOutputFile",
    "QgsKeyValueFieldFormatter",
    "QgsMapRendererJob",
    "QgsConfigCache",
    "QgsAttributeFormWidget",
    "QgsColorSchemeList",
    "QgsRelationReferenceSearchWidgetWrapper",
    "QgsPaintEffectWidget",
    "QgsAbstractMetadataBaseValidator",
    "QgsVectorLayerExporterTask",
    "QgsBrowserTreeView",
    "QgsListFieldFormatter",
    "QgsPropertyTransformer",
    "QgsMapLayerConfigWidgetFactory",
    "QgsDateTimeStatisticalSummary",
    "QgsRasterBandComboBox",
    "QgsLayoutItemAbstractMetadata",
    "QgsTextBackgroundSettings",
    "QgsCustomColorScheme",
    "QgsLimitedRandomColorRampWidget",
    "QgsLayoutRuler",
    "QgsMapSettings",
    "QgsLayerTreeNode",
    "QgsLayoutItemAbstractGuiMetadata",
    "QgsScaleBarSettings",
    "QgsWms::QgsSecurityException",
    "QgsNewOgrConnection",
    "QgsSizeScaleTransformer",
    "QgsLayoutViewToolAddItem",
    "QgsImageFetcher",
    "QgsCadUtils::AlignMapPointOutput",
    "QgsProcessingFeatureBasedAlgorithm",
    "QgsAuxiliaryLayer",
    "QgsLayoutItem",
    "QgsMapRendererParallelJob",
    "QgsPointClusterRenderer",
    "QgsProcessingParameterVectorDestination",
    "QgsTabWidget",
    "QgsVectorLayerUndoPassthroughCommandChangeAttribute",
    "QgsTextFormatDialog",
    "QgsSubstitutionListDialog",
    "QgsMapLayerStyle",
    "QgsLayoutSnapper",
    "QgsExpressionContextGenerator",
    "QgsAggregateToolButton",
    "QgsWcs::QgsSecurityAccessException",
    "QgsOrderByDialog",
    "QgsLineString",
    "QgsPresetColorRampDialog",
    "QgsLayerTreeView",
    "QgsLayoutViewRectangularRubberBand",
    "QgsFeatureFilterModel",
    "QgsDateTimeFieldFormatter",
    "QgsVectorLayerUndoPassthroughCommandAddAttribute",
    "QgsCoordinateFormatter",
    "QgsPropertyAssistantWidget",
    "QgsJsonExporter",
    "QgsLocatorResult",
    "QgsLayoutViewEllipticalRubberBand",
    "QgsLocatorContext",
    "Qgs3DRendererRegistry",
    "QgsLayoutMultiFrame",
    "QgsNumericScaleBarRenderer",
    "QgsVectorLayerUndoPassthroughCommandUpdate",
    "QgsProcessingParameterDefinition",
    "QgsColorPreviewWidget",
    "QgsDefaultVectorLayerLegend",
    "QgsKernelDensityEstimation",
    "QgsOgcServiceException",
    "QgsRuleBasedLabeling::Rule",
    "QgsSourceSelectProviderRegistry",
    "QgsExpressionContextUtils",
    "QgsHtmlAnnotation",
    "QgsDockWidget",
    "QgsPathResolver",
    "QgsInvertedPolygonRendererWidget",
    "QgsGradientColorRamp",
    "QgsMapThemeCollection",
    "QgsMultiPoint",
    "QgsUserColorScheme",
    "QgsProcessingOutputVectorLayer",
    "QgsCoordinateTransformContext",
    "QgsVectorLayerUndoPassthroughCommandChangeGeometry",
    "QgsMapLayerLegend",
    "QgsLayoutRenderContext",
    "QgsLabelingEngine",

    "QgsOgcUtilsExprToFilter",
    "QgsGeometryLineIntersectionCheck",
    "QgsRangeConfigDlg",
    "QgsFeatureListViewDelegate",
    "QgsPenStyleComboBox",
    "QgsRaster",
    "QgsRelationReferenceFactory",
    "QgsVectorLayerSelectionManager",
    "QgsAuthMethodConfig",
    "QgsCheckboxWidgetFactory",
    "QgsRendererRulePropsWidget",
    "pal::InternalException::WrongGeometry",
    "TriDecorator",
    "QgsSQLStatement::RecursiveVisitor",
    "QgsDrawSourceWidget",
    "QgsGradientFillSymbolLayer",
    "Bezier3D",
    "QgsAuthIdentitiesEditor",
    "QgsMessageOutput",
    "QgsMeshDatasetGroupProxyModel",
    "QgsStyleManagerDialog",
    "QgsGeometryGeneratorSymbolLayer",
    "QgsDirectoryItem",
    "QgsRangeWidgetWrapper",
    "QgsSymbol",
    "QgsGridFileWriter",
    "QgsSymbolLayer",
    "QgsGraduatedSymbolRenderer",
    "QgsOgcUtils",
    "QgsSymbolLayerMetadata",
    "QgsAuthCrypto",
    "pal::InternalException::Empty",
    "QgsSvgSelectorListModel",
    "QgsGeometryAngleCheck",
    "QgsFeatureSelectionDlg",
    "QgsExternalResourceConfigDlg",
    "pal::Sol",
    "QgsSQLComposerDialog::SQLValidatorCallback",
    "QgsDirectoryParamWidget",
    "QgsDiagramRenderer",
    "QgsVectorLayer",
    "QgsRelationReferenceConfigDlg",
    "QgsDial",
    "pal::LabelInfo",
    "QgsHillshadeFilter",
    "QgsSVGFillSymbolLayer",
    "Vector3D",
    "QgsClipToMinMaxEnhancement",
    "QgsRenderChecker",
    "QgsDateTimeEditConfig",
    "QgsVectorLayerUndoCommand",
    "QgsGeometryDuplicateCheck",
    "QgsLogger",
    "QgsRectangle",
    "QgsGeometry",
    "QgsGeometrySliverPolygonCheck",
    "QgsRasterHistogramWidget",
    "QgsSurface",
    "QgsRendererRegistry",
    "pal::PalException::NotImplemented",
    "pal::PalException::ValueNotInRange",
    "QgsRendererRange",
    "QgsPanelWidgetStack",
    "QgsEnumerationWidgetWrapper",
    "QgsRasterMinMaxWidget",
    "QgsDataDefinedWidthDialog",
    "QWebSettings",
    "QgsVectorLayerEditBuffer",
    "QgsLinearMinMaxEnhancement",
    "QgsVectorLayerEditUtils",
    "QgsPointLocator_VisitorNearestEdge",
    "QgsFieldCalculator",
    "QgsLongLongValidator",
    "QgsScopeLogger",
    "QgsPythonRunner",
    "QgsPkiConfigBundle",
    "QgsDistanceArea",
    "QgsMeshRendererScalarSettingsWidget",
    "QgsAttributeActionDialog",
    "QgsRasterRendererWidget",
    "QgsAbstractGeometrySimplifier",
    "QgsProjectItem",
    "QgsExternalResourceWidgetFactory",
    "QgsRasterDataProvider",
    "QgsRelation::FieldPair",
    "QgsSpatialIndex",
    "QgsHueSaturationFilter",
    "QgsRendererMeshPropertiesWidget",
    "QgsSymbolLevelItem",
    "QgsCredentials",
    "QgsDataDefinedRotationDialog",
    "QgsCptCityColorRamp",
    "QgsMapToolIdentifyFeature",
    "QgsGroupBoxCollapseButton",
    "pal::Feats",
    "QgsRasterDrawer",
    "QgsAttributeEditorElement",
    "QgsConditionalLayerStyles",
    "QgsMessageLogConsole",
    "QgsGlowWidget",
    "QgsAuthConfigIdEdit",
    "QgsRubberBand",
    "QgsRuggednessFilter",
    "QgsIFeatureSelectionManager",
    "QgsGraduatedSymbolRendererWidget",
    "QgsRuleBasedRenderer",
    "QgsSimpleFillSymbolLayerWidget",
    "LinTriangleInterpolator",
    "QgsTextEditWidgetFactory",
    "pal::Pal",
    "QgsAuthSslErrorsDialog",
    "QgsMeshDatasetGroupTreeItemDelegate",
    "QgsSVGFillSymbolLayerWidget",
    "QgsAspectFilter",
    "QgsRasterMatrix",
    "QgsVectorFileWriter::Option",
    "QgsErrorMessage",
    "QgsTextEditConfigDlg",
    "QgsHeatmapRendererWidget",
    "QgsHiddenWidgetWrapper",
    "QgsMarkerLineSymbolLayerWidget",
    "QgsNineCellFilter",
    "QgsIdentifyMenu",
    "QgsRuleBasedRendererModel",
    "QgsSymbolLevelsDialog",
    "QgsErrorDialog",
    "QgsExpressionNodeCondition",
    "QgsSimpleMarkerSymbolLayerWidget",
    "QgsActionMenu",
    "QgsSymbolSelectorWidget",
    "QgsMeshDatasetGroupTreeModel",
    "QgsPaintEngineHack",
    "QgsRendererAbstractMetadata",
    "QgsExpressionFunction",
    "pal::PalStat",
    "QgsAuthConfigEditor",
    "QgsMessageLogViewer",
    "QgsRuntimeProfiler",
    "QgsExpressionNodeFunction",
    "QgsShadowEffectWidget",
    "QgsCentroidFillSymbolLayer",
    "QgsPluginManagerInterface",
    "QgsMarkerSymbolLayer",
    "QgsPluginLayerType",
    "QgsFontMarkerSymbolLayer",
    "QgsConditionalStyle",
    "QgsContrastEnhancement",
    "QgsFontMarkerSymbolLayerWidget",
    "QgsBrushStyleComboBox",
    "QgsLabelCandidate",
    "QgsMapLayerActionRegistry",
    "QgsVectorLayerFeatureSource",
    "pal::LabelPosition",
    "QgsAuthCertTrustPolicyComboBox",
    "QgsAttributesFormProperties",
    "QgsWkbException",
    "Qgs25DRendererWidget",
    "QgsVectorFileWriter",
    "QgsSQLStatement::Visitor",
    "QgsBlurWidget",
    "QgsDataItem",
    "QgsGraphBuilder",
    "QgsMapToolPan",
    "QgsVectorLayerTools",
    "QgsMapCanvas",
    "QgsMapMouseEvent",
    "QgsSQLStatement::NodeColumnSorted",
    "QgsGeometryPointInPolygonCheck",
    "QgsServerInterface",
    "QgsPanelWidgetWrapper",
    "TriangleInterpolator",
    "QgsMeshRendererMeshSettingsWidget",
    "QgsEllipseSymbolLayerWidget",
    "QgsColorRampShader",
    "QgsDummyConfigDlg",
    "QgsRasterLayerSaveAsDialog",
    "QgsAuthCertUtils",
    "QgsSlider",
    "QgsSearchQueryBuilder",
    "QgsHistogramDiagram",
    "QgsGpsdConnection",
    "pal::CostCalculator",
    "QgsSvgSelectorDialog",
    "QgsSpatialIndexCopyVisitor",
    "QgsValueMapSearchWidgetWrapper",
    "QgsSQLStatement::NodeBinaryOperator",
    "QgsDataProvider",
    "pal::PointSet",
    "QgsQtLocationConnection",
    "QgsSimpleFillSymbolLayer",
    "QgsSingleCategoryDiagramRenderer",
    "QgsPointDisplacementRendererWidget",
    "QgsEditorWidgetFactory",
    "QgsRangeWidgetFactory",
    "QgsSingleBandGrayRendererWidget",
    "QgsMessageBarItem",
    "QgsMessageOutputConsole",
    "QgsEditorWidgetRegistry",
    "QgsColorWidgetFactory",
    "QgsMasterPasswordResetDialog",
    "pal::FeaturePart",
    "QgsSingleBandColorDataRenderer",
    "QgsRelationReferenceWidgetWrapper",
    "QgsValueMapWidgetFactory",
    "QgsGeometrySegmentLengthCheck",
    "QgsEditorConfigWidget",
    "QgsAttributeDialog",
    "QgsDiagramSettings",
    "QgsSQLStatement::NodeUnaryOperator",
    "QgsPalLayerSettings",
    "QgsAuthCertManager",
    "ParametricLine",
    "QgsPalettedRasterRenderer",
    "QgsPieDiagram",
    "QgsRendererRasterPropertiesWidget",
    "QgsDataCollectionItem",
    "QgsTableWidgetItem",
    "pal::InternalException::NoLabelPosition",
    "QgsMarkerSymbol",
    "QgsLinePatternFillSymbolLayer",
    "QgsAuthCertInfoDialog",
    "QgsRelationManager",
    "QgsUniqueValueWidgetFactory",
    "QgsExpressionNodeLiteral",
    "QgsMapLayerStyleManagerWidget",
    "QgsMeshAvailableDatasetGroupTreeModel",
    "QgsDatumTransformDialog",
    "QgsSymbolLayerUtils",
    "QgsSvgSelectorWidget",
    "QgsRasterCalculator",
    "QgsMeshDatasetGroupListModel",
    "QgsSmartGroupEditorDialog",
    "QgsSvgMarkerSymbolLayer",
    "QgsMapServiceException",
    "QgsLUDialog",
    "QgsNewGeoPackageLayerDialog",
    "QgsFeatureRenderer",
    "QgsFeatureIterator",
    "QgsValueRelationConfigDlg",
    "QgsRasterPyramidsOptionsWidget",
    "QgsEditorWidgetWrapper",
    "QgsBrowserModel",
    "QgsTextLabelFeature",
    "QgsSQLStatement::NodeList",
    "QgsTolerance",
    "QgsMapToolEmitPoint",
    "QgsRasterFileWriter",
    "QgsSingleBandPseudoColorRendererWidget",
    "QgsRasterIterator",
    "QgsExternalResourceWidget",
    "QgsStyleExportImportDialog",
    "pal::Util",
    "QgsHighlight",
    "QgsGraphBuilderInterface",
    "QgsProjectFileTransform",
    "QgsDoubleSpinBox",
    "QgsGeometryDegeneratePolygonCheck",
    "QgsRelief",
    "QgsSQLStatement::Node",
    "QgsCheckboxWidgetWrapper",
    "QgsValueMapConfigDlg",
    "QgsPkiBundle",
    "QgsVectorFileWriter::BoolOption",
    "QgsExpressionNodeCondition::WhenThen",
    "QgsCoordinateReferenceSystem",
    "QgsClipper",
    "QgsMapToolCapture",
    "QgsMeshActiveDatasetGroupTreeView",
    "pal::PriorityQueue",
    "QgsExpressionNodeColumnRef",
    "QgsSymbolLayerRegistry",
    "QgsSvgSelectorGroupsModel",
    "QgsEncodingFileDialog",
    "QgsAuthMethodRegistry",
    "QgsDetailedItemDelegate",
    "QgsDateTimeEdit",
    "QgsSQLStatementCollectTableNames",
    "QgsAuthMethodPlugins",
    "QgsStyleGroupSelectionDialog",
    "pal::InternalException::Full",
    "QgsFeatureModel",
    "QgsNewHttpConnection",
    "QgsMimeDataUtils",
    "QgsVectorFileWriter::HiddenOption",
    "QgsFeatureStore",
    "QgsAttributeTableDelegate",
    "QgisInterface",
    "QgsConnectionPoolGroup",
    "QgsLinearMinMaxEnhancementWithClip",
    "QgsDiagramInterpolationSettings",
    "QgsFeatureSelectionModel",
    "QgsMessageBar",
    "QgsRendererPropertiesDialog",
    "pal::InternalException::UnknownGeometry",
    "QgsScaleUtils",
    "QWebPage",
    "QgsCsException",
    "QgsFilterLineEdit",
    "QgsCachedFeatureWriterIterator",
    "QgsRasterResampleFilter",
    "QgsAdvancedDigitizingDockWidget",
    "QgsAuthConfigSelect",
    "QgsExpressionNode::NodeList",
    "QgsLinearlyInterpolatedDiagramRenderer",
    "QgsRasterBlock",
    "QgsZonalStatistics",
    "QgsDetailedItemData",
    "QgsRasterLayer",
    "QgsZipItem",
    "QgsRendererMetadata",
    "QgsSQLStatement::NodeInOperator",
    "QgsVectorDataProvider",
    "QgsTextEditWrapper",
    "QgsAuthEditorWidgets",
    "QgsQueryBuilder",
    "QgsIndexedFeature",
    "QgsFillSymbolLayer",
    "QgsTransactionGroup",
    "QgsMultiBandColorRendererWidget",
    "QgsRasterIdentifyResult",
    "QgsTransaction",
    "QgsExpressionHighlighter",
    "QgsPenCapStyleComboBox",
    "QgsRuleBasedRendererWidget",
    "QgsPointLocator_Stream",
    "QgsMeshRendererActiveDatasetWidget",
    "QgsCheckBoxConfigDlg",
    "QgsScaleVisibilityDialog",
    "QgsAttributeTableView",
    "QgsLayerDefinition::DependencySorter",
    "QgsAttributesDnDTree",
    "QgsAbstractFeatureIteratorFromSource",
    "QgsMapTip",
    "QgsPointPatternFillSymbolLayer",
    "QgsRasterProjector",
    "QgsColorBrewerPalette",
    "QgsDateTimeEditFactory",
    "QgsRasterPipe",
    "QgsBlendModeComboBox",
    "QgsDerivativeFilter",
    "QgsAccessControlFilter",
    "QgsVertexMarker",
    "QgsAttributeFormLegacyInterface",
    "QgsFontUtils",
    "QgsApplication",
    "QgsRasterFillSymbolLayerWidget",
    "QgsGeometryGeneratorSymbolLayerWidget",
    "QgsSQLStatement::NodeTableDef",
    "QgsMapToolZoom",
    "QgsWidgetWrapper",
    "QgsValueRelationWidgetFactory",
    "pal::PalException::UnknownFeature",
    "QgsGpsDetector",
    "QgsSimpleLineSymbolLayerWidget",
    "pal::PalException::LayerExists",
    "QgsMeshVariableStrokeWidthButton",
    "QgsRunProcess",
    "pal::GeomFunction",
    "QgsVectorLayerUndoCommandChangeGeometry",
    "QgsCollapsibleGroupBox",
    "QgsFieldValidator",
    "QgsDiagram",
    "QgsPointDisplacementRenderer",
    "QgsCredentialDialog",
    "QgsSourceFieldsProperties",
    "QgsMeshStaticDatasetWidget",
    "QgsCredentialsNone",
    "QgsSQLStatement::NodeCast",
    "QgsCptCityAllRampsItem",
    "QgsExpressionBuilderDialog",
    "QgsCredentialsConsole",
    "QgsVectorLayerUndoCommandDeleteAttribute",
    "QgsUniqueValuesConfigDlg",
    "QgsSQLComposerDialog",
    "QgsAuthServersEditor",
    "QgsExpressionNodeInOperator",
    "QgsUnitSelectionWidget",
    "QgsMeshVariableStrokeWidthWidget",
    "QgsRelation",
    "QgsGpsInformation",
    "QgsStyle",
    "QgsActionManager",
    "QgsGeometryDuplicateCheckError",
    "QgsGmlFeatureClass",
    "QgsCategorizedSymbolRendererWidget",
    "QgsMarkerLineSymbolLayer",
    "QgsMessageViewer",
    "QgsRuleBasedRenderer::Rule",
    "QgsVector",
    "QgsLinePatternFillSymbolLayerWidget",
    "QgsValueRelationSearchWidgetWrapper",
    "QgsGml",
    "QgsWebView",
    "QgsMapUnitScaleDialog",
    "QgsExpressionNode",
    "QgsCptCitySelectionItem",
    "QgsScaleRangeWidget",
    "QgsAuthMethodEdit",
    "QgsRasterFormatSaveOptionsWidget",
    "QgsConnectionPool",
    "QgsEnumerationWidgetFactory",
    "QgsSymbolLayerAbstractMetadata",
    "QgsMultiBandColorRenderer",
    "QgsPreviewEffect",
    "QgsPixmapLabel",
    "QgsCapabilitiesCache",
    "QgsVectorFileWriter::SetOption",
    "QgsSQLStatement::NodeBetweenOperator",
    "QgsRasterTransparencyWidget",
    "QgsVectorFileWriter::StringOption",
    "QgsException",
    "QgsAuthSslConfigDialog",
    "QgsGeometryCheckFactoryT",
    "QgsFileWidget",
    "QgsOWSSourceSelect",
    "QgsMapToPixelSimplifier",
    "QgsAuthMethodMetadata",
    "QgsCubicRasterResampler",
    "QgsGeometry::Error",
    "QgsRequestHandler",
    "QgisPlugin",
    "QgsRasterRange",
    "QgsXmlUtils",
    "QgsAttributeTableFilterModel",
    "QgsVectorLayerLegendWidget",
    "QgsVirtualLayerDefinition::SourceLayer",
    "QgsSQLStatement::NodeSelect",
    "QgsMeshDatasetListModel",
    "QgsSymbolRenderContext",
    "QgsUniqueValuesWidgetWrapper",
    "QgsUuidWidgetFactory",
    "QgsDartMeasurement",
    "QgsShapeburstFillSymbolLayer",
    "QgsJoinDialog",
    "QgsLabelSearchTree",
    "QgsDiagramLabelFeature",
    "QgsAnimatedIcon",
    "QgsIDWInterpolator",
    "QgsGeometryLineLayerIntersectionCheck",
    "QgsVectorFileWriter::IntOption",
    "QgsRelationWidgetWrapper",
    "QgsGraphDirector",
    "QgsImageFillSymbolLayer",
    "QgsAttributeTableModel",
    "QgsSQLStatement::NodeJoin",
    "QgsFeatureListModel",
    "QgsMapLayerAction",
    "QgsMapCanvasItem",
    "QgsGraphAnalyzer",
    "QgsColorEffectWidget",
    "QgsSQLStatement::NodeFunction",
    "QgsError",
    "QgsDetailedItemWidget",
    "QgsGeos",
    "QgsRasterShaderFunction",
    "QgsLineSymbol",
    "QgsProviderRegistry",
    "QgsRendererRulePropsDialog",
    "QgsAction",
    "QgsMessageLog",
    "QgsCptCityArchive",
    "QgsPointLocator_VisitorArea",
    "QgsSingleBandGrayRenderer",
    "QgsGeometryContainedCheck",
    "QgsLayoutEffect",
    "QgsFeature",
    "QgsVectorLayerJoinBuffer",
    "QgsAuthGuiUtils",
    "QgsRasterCalcNode",
    "QgsFields",
    "QgsScaleCalculator",
    "QgsSymbolSelectorDialog",
    "QgsRasterResampler",
    "QgsRelationReferenceWidget",
    "QgsDiagramProperties",
    "QgsFeatureListView",
    "QgsVirtualLayerDefinition",
    "QgsGradientFillSymbolLayerWidget",
    "QgsFillSymbol",
    "QgsSmartGroupCondition",
    "QgsAuthImportIdentityDialog",
    "QgsExpressionNodeBinaryOperator",
    "pal::PalException",
    "QgsTrackedVectorLayerTools",
    "QgsRasterRendererRegistry",
    "QgsAdvancedDigitizingCanvasItem",
    "NormVecDecorator",
    "QgsMapUnitScale",
    "QgsExpressionItem",
    "QgsCptCityBrowserModel",
    "QgsDxfPaintEngine",
    "QgsVectorLayerUndoCommandChangeAttribute",
    "QgsUuidWidgetWrapper",
    "QgsGeometryRubberBand",
    "QgsProject",
    "QgsAuthConfigSslServer",
    "QgsTransformWidget",
    "QgsBilinearRasterResampler",
    "QgsSearchWidgetWrapper",
    "QgsVectorLayerUndoCommandAddFeature",
    "QgsBusyIndicatorDialog",
    "QgsSingleBandPseudoColorRenderer",
    "QgsLabelPosition",
    "QgsShapeburstFillSymbolLayerWidget",
    "QgsAttributes",
    "QgsExpression",
    "EditBlockerDelegate",
    "QgsTopologyPreservingSimplifier",
    "QgsGeometryMultipartCheck",
    "QgsAbstractCacheIndex",
    "QgsGenericFeatureSelectionManager",
    "QgsAuthConfigEdit",
    "QgsMeshDatasetGroupSaveMenu",
    "QgsBrightnessContrastFilter",
    "QgsRasterRenderer",
    "QgsDiagramLayerSettings",
    "QgsPalettedRendererWidget",
    "QgsValueRelationWidgetWrapper",
    "CharacterWidget",
    "QgsEditFormConfig",
    "QgsDataDefinedValueDialog",
    "QgsAuthMethod",
    "QgsSlopeFilter",
    "QgsLayerPropertiesWidget",
    "QgsVectorLayerCache",
    "QgsAttributeTableAction",
    "QgsAttributesFormProperties::DnDTreeItemData",
    "QgsVectorFieldSymbolLayer",
    "QgsInternalGeometryEngine",
    "QgsAttributesFormInitCode",
    "QgsCentroidFillSymbolLayerWidget",
    "QgsProviderMetadata",
    "QgsRenderContext",
    "QgsCptCityDirectoryItem",
    "QgsDashSpaceDialog",
    "QgsAuthManager",
    "QgsVectorLayerUndoCommandDeleteFeature",
    "QgsGeometryValidator",
    "QgsScaleWidget",
    "QgsRasterHistogram",
    "QgsSvgMarkerSymbolLayerWidget",
    "QgsConstWkbPtr",
    "QgsDefaultSearchWidgetWrapper",
    "QgsGroupWmsDataDialog",
    "QgsLineSymbolLayer",
    "QgsMapOverviewCanvas",
    "QgsLegendStyle",
    "QgsDxfPaintDevice",
    "QgsVectorLayerEditPassthrough",
    "QgsGeometrySelfContactCheck",
    "QgsCollapsibleGroupBoxBasic",
    "QgsMeshRendererVectorSettingsWidget",
    "QgsPenJoinStyleComboBox",
    "QgsNetworkReplyParser",
    "QgsAttributeActionPropertiesDialog",
    "QgsColorWidgetWrapper",
    "QgsAttributeEditorRelation",
    "QgsAuthAuthoritiesEditor",
    "QgsAbstractFeatureIterator",
    "QgsInterpolator",
    "QgsCptCityCollectionItem",
    "QgsAuthSslImportDialog",
    "QgsRasterChecker",
    "QgsRasterInterface",
    "HalfEdge",
    "QgsGeometrySelfIntersectionCheck",
    "QgsOfflineEditing",
    "QgsMeshDatasetGroupTreeView",
    "QgsGmlSchema",
    "QgsClassificationWidgetWrapperFactory",
    "QWebFrame",
    "QgsGeometryTypeCheck",
    "QgsSatelliteInfo",
    "QgsNewVectorLayerDialog",
    "QgsRendererWidget",
    "pal::Layer",
    "QgsVectorLayerProperties",
    "QgsDialog",
    "QgsAttributeEditorContainer",
    "QgsAdvancedDigitizingDockWidget::CadConstraint",
    "QgsGeometrySelfIntersectionCheckError",
    "QgsNewMemoryLayerDialog",
    "QgsSingleSymbolRendererWidget",
    "QgsCategorizedSymbolRenderer",
    "QgsArrowSymbolLayerWidget",
    "QgsDualView",
    "QgsRuleBasedLabelProvider",
    "QgsSvgCache",
    "QgsSQLComposerDialog::TableSelectedCallback",
    "QgsMapToolAdvancedDigitizing",
    "QgsExpressionBuilderWidget",
    "QgsOptionsDialogBase",
    "QgsSymbolsListWidget",
    "QgsRasterShader",
    "QgsField",
    "QgsGeometryAreaCheck",
    "QgsGeometryTypeCheckError",
    "QgsWkbPtr",
    "QgsSingleSymbolRenderer",
    "QgsMapToolEdit",
    "QgsDataDefinedSizeDialog",
    "QgsGeometryDuplicateNodesCheck",
    "QgsAuthTrustedCAsDialog",
    "QgsTotalCurvatureFilter",
    "QgsAttributeFormInterface",
    "QgsGeometryPointCoveredByLineCheck",
    "QgsPalLabeling",
    "QgsMapCanvas::CanvasProperties",
    "QgsRasterPyramid",
    "QgsSimpleLineSymbolLayer",
    "QgsGeometryContainedCheckError",
    "QgsMapTool",
    "QgsPluginLayerRegistry",
    "QgsRasterTransparency",
    "QgsAuthCertInfo",
    "QgsValueMapWidgetWrapper",
    "QgsGeometryHoleCheck",
    "QgsLocaleNumC",
    "QgsRendererCategory",
    "QgsProjectVersion",
    "QgsDateTimeEditWrapper",
    "QgsVectorFieldSymbolLayerWidget",
    "pal::Problem",
    "QgsRasterBandStats",
    "QgsAttributeTypeLoadDialog",
    "QgsGmlStreamingParser::LayerProperties",
    "QgsManageConnectionsDialog",
    "QgsPointLocator_VisitorNearestVertex",
    "QgsErrorItem",
    "QgsAttributeForm",
    "QgsScaleComboBox",
    "QgsAttributeEditorField",
    "QgsNetworkDiskCache",
    "QgsMeshDatasetGroupTreeWidget",
    "QgsDataSourceUri",
    "QgsAuthConfigUriEdit",
    "QgsLayerDefinition",
    "QgsWmsDimensionDialog",
    "QgsMapToolIdentify",
    "QgsCachedFeatureIterator",
    "QgsOwsConnection",
    "QgsExpressionSelectionDialog",
    "QgsEllipseSymbolLayer",
    "QgsExternalResourceWidgetWrapper",
    "QgsPluginLayer",
    "QgsVectorLayerFeatureIterator",
    "QgsMapLayer",
    "pal::PalException::FeatureExists",
    "QgsMapToPixel",
    "QgsPointPatternFillSymbolLayerWidget",
    "Qgis",
    "QgsFieldExpressionWidget",
    "QgsStaticExpressionFunction",
    "QgsSpinBox",
    "QgsVectorLayerUndoCommandAddAttribute",
    "QgsContrastEnhancementFunction",
    "QgsAttributeTableMapLayerAction",
    "pal::PalException::UnknownLayer",
    "pal::InternalException",
    "QgsServer",
    "QgsSymbolLayerWidget",
    "QgsFeatureRequest",
    "QgsGeometryFollowBoundariesCheck",
    "QgsServerFilter",
    "QgsSimpleMarkerSymbolLayer",
    "QgsCoordinateTransform",
    "CloughTocherInterpolator",
    "QgsPointLocator_DumpTree",
    "QgsClassificationWidgetWrapper",
    "QgsAuthCertEditors",
    "QgsAttributeEditorContext",
    "QgsGpsConnectionRegistry",
    "QgsExpressionItemSearchProxy",
    "QgsPanelWidget",
    "QgsSQLStatement::NodeLiteral",
    "Qgs25DRenderer",
    "QgsGeometryDangleCheck",
    "QgsSQLStatement::NodeColumnRef",
    "QgsVirtualLayerDefinitionUtils",
    "QgsOgcUtilsSQLStatementToFilter",
    "QgsCptCityDataItem",
    "QgsHiddenWidgetFactory",
    "QgsRasterNuller",
    "QgsAuthImportCertDialog",
    "QgsLayerItem",
    "QgsProjectBadLayerHandler",
    "QgsCacheIndexFeatureId",
    "QgsPointLocator_VisitorEdgesInRect",
    "QgsCptCityColorRampItem",
    "QgsTextDiagram",
    "QgsSublayersDialog",
    "QgsCharacterSelectorDialog",
    "QgsDxfExport",
    "QgisVisitor",
    "QgsSQLStatement::NodeSelectedColumn",
    "QgsNetworkAccessManager",
    "QgsExpressionNodeUnaryOperator",
    "QgsAuthSslConfigWidget",
    "QgsGpsConnection",
]

ACCEPTABLE_MISSING_BRIEF = [
    'QgsDial',
    'QgsPluginManagerInterface',
    'QgsRangeWidgetFactory',
    'QgsLinearlyInterpolatedDiagramRenderer',
    'QgsTextDiagram',
    'QgsShapeburstFillSymbolLayer',
    'QgsCptCityArchive',
    'QgsValueRelationConfigDlg',
    'QgsGeometryMultipartCheck',
    'QgsArrowSymbolLayerWidget',
    'QgsCheckboxWidgetFactory',
    'QgsLabelCandidate',
    'QgsGeometrySliverPolygonCheck',
    'QgsMarkerLineSymbolLayerWidget',
    'QgsRelationReferenceFactory',
    'QgsGradientFillSymbolLayer',
    'QgsPointPatternFillSymbolLayer',
    'QgsSymbolLayer',
    'QgsLUDialog',
    'QgsFeatureModel',
    'QgsSimpleMarkerSymbolLayerWidget',
    'QgsMimeDataUtils',
    'QgsRuleBasedLabelProvider',
    'QgsRuntimeProfiler',
    'QgsRelation',
    'QgsGeometryPointCoveredByLineCheck',
    'QgsFontMarkerSymbolLayerWidget',
    'QgsDataDefinedWidthDialog',
    'QgsHistogramDiagram',
    'QgsSymbolLayerWidget',
    'QgsSpatialIndexCopyVisitor',
    'pal::CostCalculator',
    'QgsRendererRangeLabelFormat',
    'QgsGeometrySelfContactCheck',
    'QgsExpressionHighlighter',
    'QgsFillSymbolLayer',
    'QgsRendererRange',
    'QgsVectorFileWriter::HiddenOption',
    'QgsDrawSourceWidget',
    'QgsSvgSelectorDialog',
    'QgsFontMarkerSymbolLayer',
    'QgsStyleGroupSelectionDialog',
    'QgsGeometryLineLayerIntersectionCheck',
    'QgsFeatureRenderer',
    'QgsGeometryDangleCheck',
    'QgsRelationEditorWidget',
    'QgsGeometryPointInPolygonCheck',
    'QgsSymbolLayerUtils',
    'QgsCategorizedSymbolRenderer',
    'QgsRasterRendererWidget',
    'QgsValueMapConfigDlg',
    'QgsSublayersDialog',
    'QgsLabelPosition',
    'QgsSimpleLineSymbolLayerWidget',
    'QgsGeometrySelfIntersectionCheckError',
    'QgsRelationReferenceConfigDlg',
    'QgsFeatureListModel',
    'QgsMessageBarItem',
    'QgsCptCityBrowserModel',
    'QgsQtLocationConnection',
    'HalfEdge',
    'QgsBrushStyleComboBox',
    'QgsDartMeasurement',
    'QgsDateTimeEditFactory',
    'QgsPieDiagram',
    'QgsVectorLayerFeatureIterator',
    'QgsGeometryValidator',
    'QgsGeometrySelfIntersectionCheck',
    'QgsRangeConfigDlg',
    'QgsSymbolsListWidget',
    'QgsDummyConfigDlg',
    'QgsEnumerationWidgetFactory',
    'QgsGeometryDuplicateNodesCheck',
    'QgsVectorLayerEditPassthrough',
    'QgsGeometryTypeCheck',
    'QgsSVGFillSymbolLayerWidget',
    'QgsSingleSymbolRenderer',
    'QgsGeometryAreaCheck',
    'QgsHillshadeFilter',
    'QgsColorWidgetFactory',
    'QgsRendererPropertiesDialog',
    'QgsBrowserWatcher',
    'QgsDxfExport',
    'QgsTransactionGroup',
    'QgsStyle',
    'QgsSingleSymbolRendererWidget',
    'QgsGeometryDuplicateCheckError',
    'QgsSvgMarkerSymbolLayer',
    'QgsGeometry::Error',
    'QgsLayerPropertiesWidget',
    'QgsSymbolSelectorDialog',
    'QgsConstWkbPtr',
    'QgsErrorDialog',
    'QgsPalLayerSettings',
    'QgsRendererRulePropsWidget',
    'QgsTextEditConfigDlg',
    'QgsDateTimeEditConfig',
    'QgsGroupBoxCollapseButton',
    'QgsGeometryFollowBoundariesCheck',
    'QgsLongLongValidator',
    'QgsTextEditWidgetFactory',
    'QgsCentroidFillSymbolLayerWidget',
    'QgsGmlSchema',
    'QgsSingleBandGrayRendererWidget',
    'Qgs25DRenderer',
    'QgsVectorFileWriter::BoolOption',
    'QgsSimpleFillSymbolLayer',
    'QgsDxfPaintEngine',
    'QgsGlowWidget',
    'QgsGroupWmsDataDialog',
    'QgsMapToolCapture',
    'QgsRendererRasterPropertiesWidget',
    'QgsCptCityColorRamp',
    'QgsVectorLayerEditUtils',
    'QgsVectorLayerSelectionManager',
    'QgsTrackedVectorLayerTools',
    'QgsSmartGroupCondition',
    'pal::Sol',
    'QgsAttributeTypeLoadDialog',
    'QgsCentroidFillSymbolLayer',
    'QgsWkbPtr',
    'QgsFeatureSelectionModel',
    'QgsDataDefinedRotationDialog',
    'QgsGraduatedSymbolRendererWidget',
    'QgsTransformWidget',
    'QgsShapeburstFillSymbolLayerWidget',
    'QgsUniqueValuesConfigDlg',
    'QgsHeatmapRendererWidget',
    'QgsScaleUtils',
    'pal::PointSet',
    'QgsEllipseSymbolLayerWidget',
    'QgsFontUtils',
    'QgsRuleBasedLabeling',
    'QgsRasterCalcNode',
    'QgsPointPatternFillSymbolLayerWidget',
    'QgsVectorFileWriter::StringOption',
    'QgsUuidWidgetFactory',
    'QgsHiddenWidgetFactory',
    'QgsGeometryGeneratorSymbolLayer',
    'QgsGeometryAngleCheck',
    'QgsAttributeTableAction',
    'QgsAttributeForm',
    'QgsDatumTransformDialog',
    'pal::PriorityQueue',
    'Qgs25DRendererWidget',
    'QgsShadowEffectWidget',
    'QgsGeometryHoleCheck',
    'QgsVectorFileWriter::Option',
    'QgsRuleBasedRendererWidget',
    'QgsPenCapStyleComboBox',
    'QgsScopeLogger',
    'QgsGeometrySegmentLengthCheck',
    'QgsGeometryContainedCheckError',
    'QgsClassificationWidgetWrapper',
    'QgsMultiBandColorRendererWidget',
    'QgsFeatureListViewDelegate',
    'QgsManageConnectionsDialog',
    'QgsFieldValidator',
    'QgsPalLabeling',
    'QgsLocaleNumC',
    'QgsColorBrewerPalette',
    'pal::Util',
    'QgsVectorFileWriter::IntOption',
    'QgsGeometryLineIntersectionCheck',
    'QgsSymbolRenderContext',
    'QgsCategorizedSymbolRendererWidget',
    'pal::GeomFunction',
    'QgsRendererRulePropsDialog',
    'QgsSvgMarkerSymbolLayerWidget',
    'QgsExternalResourceConfigDlg',
    'QgsClassificationWidgetWrapperFactory',
    'QgsGeometryTypeCheckError',
    'QgsNewVectorLayerDialog',
    'QgsRuleBasedLabeling::Rule',
    'QgsVectorFieldSymbolLayerWidget',
    'QgsSmartGroupEditorDialog',
    'QgsSlider',
    'QgsAttributeDialog',
    'QgsVectorFileWriter::SetOption',
    'QgsNewMemoryLayerDialog',
    'QgsCheckBoxConfigDlg',
    'QgsEnumerationWidgetWrapper',
    'QgsRelationReferenceWidget',
    'QgsRasterLayerSaveAsDialog',
    'QgsValueRelationWidgetFactory',
    'QgsGraduatedSymbolRenderer',
    'QgsGeometryGeneratorSymbolLayerWidget',
    'QgsBlurWidget',
    'QgsLineSymbolLayer',
    'QgsRelationWidgetWrapper',
    'QgsOfflineEditing',
    'QgsValueMapWidgetFactory',
    'QgsGeometryDegeneratePolygonCheck',
    'QgsExternalResourceWidgetFactory',
    'QgsEditFormConfig',
    'QgsAttributeFormInterface',
    'QgsProjectFileTransform',
    'QgsColorEffectWidget',
    'QgsAttributeTableMapLayerAction',
    'QgsGeometryDuplicateCheck',
    'QgsPalettedRendererWidget',
    'QgsSimpleFillSymbolLayerWidget',
    'QgsSurface',
    'QgsAttributeTableFilterModel',
    'QgsLinePatternFillSymbolLayerWidget',
    'QgsCacheIndexFeatureId',
    'QgsGeometryContainedCheck',
    'QgsPenJoinStyleComboBox',
    'QgsDataDefinedSizeDialog',
    'QgsUniqueValueWidgetFactory',
    'QgsStyleExportImportDialog',
    'QgsRasterMatrix',
    'QgsPointDisplacementRendererWidget',
    'QgsVectorLayerEditBuffer',
    'QgsGradientFillSymbolLayerWidget',
    'QgsRasterFillSymbolLayerWidget',
    'QgsRasterMinMaxWidget',
    'QgsSymbolLevelItem',
    'QgsSvgSelectorWidget',
    'QgsPenStyleComboBox',
    'QgsFeatureSelectionDlg',
    'QgsAttributeActionDialog',
    'QgsDiagramProperties',
    'QgsSourceFieldsProperties',
    'QgsJoinDialog',
    'QgsAttributesFormProperties::DnDTreeItemData',
    'QgsMeshDatasetGroupListModel',
    'QgsMeshDatasetGroupSaveMenu',
    'QgsMeshDatasetGroupProxyModel',
    'QgsAttributeActionPropertiesDialog',
    'QgsAttributesFormProperties',
    'QgsMeshAvailableDatasetGroupTreeModel',
    'QgsVectorLayerProperties',
    'QgsSettingsEntryBase',
    'QgsMeshDatasetGroupTreeWidget',
    'QgsAttributesFormInitCode',
    'QgsMeshRendererScalarSettingsWidget',
    'QgsCPLErrorHandler',
    'EditBlockerDelegate'
]

if __name__ == '__main__':
    for k in sorted(list(ACCEPTABLE_MISSING_DOCS.keys())):
        print(f'    "{k}": {sorted(ACCEPTABLE_MISSING_DOCS[k])},')
