
/* C interface to some of the internals of the Q-GGI module, to facilitate
   access for "third-party" extensions like the draw_wave module.
   2003-12-23 AG */

/* This file is part of the Q programming system.

   The Q programming system is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   The Q programming system is distributed in the hope that it will be
   useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */

#ifndef __GGILIB_H__
#define __GGILIB_H__ 1

#include <ggi/ggi.h>

/* NOTE: The v argument of the following operations must point to a valid
   GGIVisual object, as obtained from the object pointer of a GGIVisual
   expression. */

/* the following operations return a negative value on error, zero
   otherwise */

/* clear clip area of alpha buffer */

extern int clear_alpha_buffer(void *v);

/* set alpha values, with clipping */

extern int set_alpha_box(void *v, int x, int y, int w, int h,
			 ggi_color *c);

/* same as above, but use current foreground color */

extern int draw_alpha_box(void *v, int x, int y, int w, int h);

/* the following operations return the number of processed pixels if
   successful, negative otherwise */

/* retrieve a rectangle of pixels from a visual, including alpha values
   (storage pointed to by c is malloc'ed, user must free it)  */

extern int get_box(void *v, int x, int y, int w, int h, ggi_color **c);

/* store a rectangle of pixels in a visual, with alpha blending */

extern int put_box(void *v, int x, int y, int w, int h, ggi_color *c);

/* same, with current foreground pixel */

extern int draw_box(void *v, int x, int y, int w, int h);

/* for this one, you need to link in draw_line.c; returns nonzero iff error */

extern int draw_line(void *v, int x1, int y1, int x2, int y2);

/* convenience inline functions, to process horizontal and vertical lines and
   single pixels */

static inline int set_alpha_hline(void *v, int x, int y, int w,
				  ggi_color *c)
{
  return set_alpha_box(v, x, y, w, 1, c);
}

static inline int set_alpha_vline(void *v, int x, int y, int h,
				  ggi_color *c)
{
  return set_alpha_box(v, x, y, 1, h, c);
}

static inline int set_alpha_pixel(void *v, int x, int y,
				  ggi_color *c)
{
  return set_alpha_box(v, x, y, 1, 1, c);
}

static inline int draw_alpha_hline(void *v, int x, int y, int w)
{
  return draw_alpha_box(v, x, y, w, 1);
}

static inline int draw_alpha_vline(void *v, int x, int y, int h)
{
  return draw_alpha_box(v, x, y, 1, h);
}

static inline int draw_alpha_pixel(void *v, int x, int y)
{
  return draw_alpha_box(v, x, y, 1, 1);
}

static inline int get_hline(void *v, int x, int y, int w,
			    ggi_color **c)
{
  return get_box(v, x, y, w, 1, c);
}

static inline int get_vline(void *v, int x, int y, int h,
			    ggi_color **c)
{
  return get_box(v, x, y, 1, h, c);
}

static inline int get_pixel(void *v, int x, int y,
			    ggi_color **c)
{
  return get_box(v, x, y, 1, 1, c);
}

static inline int put_hline(void *v, int x, int y, int w,
			    ggi_color *c)
{
  return put_box(v, x, y, w, 1, c);
}

static inline int put_vline(void *v, int x, int y, int h,
			    ggi_color *c)
{
  return put_box(v, x, y, 1, h, c);
}

static inline int put_pixel(void *v, int x, int y,
			    ggi_color *c)
{
  return put_box(v, x, y, 1, 1, c);
}

static inline int draw_hline(void *v, int x, int y, int w)
{
  return draw_box(v, x, y, w, 1);
}

static inline int draw_vline(void *v, int x, int y, int h)
{
  return draw_box(v, x, y, 1, h);
}

static inline int draw_pixel(void *v, int x, int y)
{
  return draw_box(v, x, y, 1, 1);
}

#endif
