
/* grid.q: graphics example 01-13-1994 AG, revised 01-26-1994, 03-02-2002 AG
   derived from a PostScript program written by Andre Weiland */

include graphics;

/*

First, set up a graphics device, e.g.:

==> def GRAPHICS = gsdev

Then, to draw a grid in color COLOR, invoke `grid COLOR', e.g.:

==> grid black
==> showpage
==> grid red
==> showpage

See `graphics.q' for a list of defined color values.

*/

grid COLOR	=
	/* set up graphics parameters: */
		  gsave ||
		  setcolor COLOR ||
		  setlinewidth 0 ||
		  scale cm cm ||
	/* draw 1 cm grid */
		  newpath ||
		  do (vline (-.1) 30.1) [0..20] ||
		  do (hline (-.1) 20.1) [0..30] ||
		  stroke ||
	/* draw 1/2 cm grid */
		  newpath ||
		  do (vline 0 30) [0.5..19.5] ||
		  do (hline 0 20) [0.5..29.5] ||
		  stroke ||
	/* draw 1 mm grid */
		  setdash [0.1, 0.9] 0 ||
		  newpath ||
		  do (vline (-.05) 30.05) [0.1,0.2..20] ||
		  do (hline (-.05) 20.05) [0.1,0.2..30] ||
		  stroke ||
	/* reset graphics parameters */
		  grestore;

/* unit length (centimeters) */

cm		= 28.346456;

/* vline: draw a vertical line */

vline Y1 Y2 X	= moveto X Y1 || lineto X Y2;

/* hline: draw a horizontal line */

hline X1 X2 Y	= moveto X1 Y || lineto X2 Y;
