from _typeshed import Incomplete
from collections.abc import Iterator
from http.client import HTTPResponse
from json import JSONEncoder

class FluxStructure: ...

class FluxStructureEncoder(JSONEncoder):
    def default(self, obj): ...

class FluxTable(FluxStructure):
    columns: Incomplete
    records: Incomplete
    def __init__(self) -> None: ...
    def get_group_key(self): ...
    def __iter__(self): ...

class FluxColumn(FluxStructure):
    default_value: Incomplete
    group: Incomplete
    data_type: Incomplete
    label: Incomplete
    index: Incomplete
    def __init__(
        self,
        index: Incomplete | None = None,
        label: Incomplete | None = None,
        data_type: Incomplete | None = None,
        group: Incomplete | None = None,
        default_value: Incomplete | None = None,
    ) -> None: ...

class FluxRecord(FluxStructure):
    table: Incomplete
    values: Incomplete
    row: Incomplete
    def __init__(self, table, values: Incomplete | None = None) -> None: ...
    def get_start(self): ...
    def get_stop(self): ...
    def get_time(self): ...
    def get_value(self): ...
    def get_field(self): ...
    def get_measurement(self): ...
    def __getitem__(self, key): ...
    def __setitem__(self, key, value): ...

class TableList(list[FluxTable]):
    def to_values(self, columns: list[str] | None = None) -> list[list[object]]: ...
    def to_json(self, columns: list[str] | None = None, **kwargs) -> str: ...

class CSVIterator(Iterator[list[str]]):
    delegate: Incomplete
    def __init__(self, response: HTTPResponse) -> None: ...
    def __iter__(self): ...
    def __next__(self): ...
    def to_values(self) -> list[list[str]]: ...
