#!/usr/local/bin/python
#
# Copyright (c) 2003 Neil Blakey-Milner
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

try:
    import gdchart
except ImportError:
    gdchart = None
    print "Graphing functionality is not available"
    pass
import os

# sibling imports
import config
import util

def enforceMaxKeyLength(keys):
    """Ensure each key is less than a specific length"""
    return [util.concat(k, config.MAXGRAPHNAMELENGTH) for k in keys]

def pie(keys, values, title, distance, filename):
    """Create a pie graph, with the given title, distance from the
    graph, and the filename"""

    keys = enforceMaxKeyLength(keys)

    gdchart.option(**config.GDCHART_OPTIONS)
    gdchart.option(
        label_dist=distance,
        title="%s\n" % (title)
    )
    size = (config.PIEWIDTH, config.PIEHEIGHT)
    gdchart.chart(gdchart.GDC_3DPIE, size, filename, keys, values)

def getPercentageThreshold(data, threshold = 5):
    """Show entries that are over a specific percentage threshold,
    otherwise group them together."""
    newdata = []
    total = reduce(lambda x, y: x + y, [v for k, v in data.items()])
    print total
    under_threshold = 0
    for k, v in data.items():
        if v * 100 / total < threshold:
            under_threshold = under_threshold + v
        else:
            newdata.append((k, v))
    if under_threshold:
        newdata.append(("Under threshold", under_threshold))
    return newdata

def getTop(data, top = 10):
    """Show the specified number of entries, otherwise group the
    remainer together."""
    newdata = []
    sorted = [(v, k) for k, v in data.items()]
    sorted.sort()
    sorted.reverse()
    for k, v in sorted[:top]:
        newdata.append((v, k))

    theRest = 0

    for k, v in sorted[top:]:
        theRest = theRest + k

    if theRest:
        newdata.append(("The Rest", theRest))

    return newdata

def makeGraph(data, filename, title = '', path=config.STATSOUTPUTDIR, distance = 15):
    """Create a pie chart based on an dictionary data"""
    keys = [k for k, v in data]
    values = [v for k, v in data]
    pie(keys,
        values,
        title,
        distance,
        os.path.join(path, filename)
    )

def makegraphs(data, path=config.STATSOUTPUTDIR):
    """Determine which graphs to make from the reports, and how to
    construct them."""
    for report in config.REPORTS:
        if not report["image"]:
            continue
        if report["method"] == "Percentage":
            func = getPercentageThreshold
            parameter = report["threshold"]
        if report["method"] == "Top":
            func = getTop
            parameter = report["top"]
        makeGraph(func(data[report["variable"]], parameter),
            report["image"],
            "",
            path)

def charting():
    """Return whether charting capability is available."""
    return gdchart is not None
