#!/usr/local/bin/python
#
# Copyright (c) 2003 Neil Blakey-Milner
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in the
#    documentation and/or other materials provided with the distribution.
#
# THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
# FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
# OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
# HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
# OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
# SUCH DAMAGE.
#

import config

def agentMatch(agentString, includes, excludes):
    if not excludes:
        excludes = []

    for exclude in excludes:
        if agentString.count(exclude):
            return 0

    for include in includes:
        if agentString.count(include):
            return 1

    return 0

def findMatchFromAgentString(agentString, agentMatches):
    if agentString == "-":
        return "None"

    for browser in agentMatches:
        if agentMatch(agentString, browser[1], browser[2]):
            return browser[0]

    return "Unknown"
                
def buildDictionary(agentStrings, agentMatches):
    ret = {}
    extra = {}
    extra["unknown"] = {}
    extra["mozbrowsers"] = {}
    for agentString in agentStrings:
        browser = findMatchFromAgentString(agentString, agentMatches)
        #print "%s -> %s" % (agentString, browser)
        ret.setdefault(browser, 0)
        ret[browser] = ret[browser] + 1
        if browser == "Unknown":
            extra["unknown"].setdefault(agentString, 0)
            extra["unknown"][agentString] = extra["unknown"][agentString] + 1
        if browser == "Mozilla":
            extra["mozbrowsers"].setdefault(agentString, 0)
            extra["mozbrowsers"][agentString] = extra["mozbrowsers"][agentString] + 1
    return ret, extra

def isBot(agentString):
    return agentMatch(agentString, config.BOTS.keys(), None)

def getBotName(agentString):
    for k, v in config.BOTS.items():
        if agentString.count(k):
            return v
    return "Unknown"
