# Tutorials

Welcome to our tutorials designed for those eager to dive into the world of Panel! If you're still undecided, we suggest starting with the [Getting Started Guide](../getting_started/index.md) to get a taste of what Panel has to offer.

Throughout this series, we'll delve into wind turbine data and craft some impressive wind turbine data apps using Panel by HoloViz. We firmly believe that the skills you'll acquire are not only valuable but also easily applicable across various domains, including yours.

Before we begin, remember to put on your safety helmet – we're about to venture into the world of wind turbine data apps!

## Select Tutorials

Choose the tutorials that best match your skill level.

::::{grid} 1 2 2 3
:gutter: 1 1 1 2

:::{grid-item-card} {octicon}`rocket;2.5em;sd-mr-1` Basic
:link: basic/index
:link-type: doc

These tutorials are perfect for those just starting their journey with Panel.

Together, we'll explore the wind turbine dataset and create exciting projects like a chatbot, a static report, a todo app, an image classifier app, a dashboard, and even a streaming application.

By the end, you'll have the skills to develop polished, single-page apps efficiently using a *function-based approach*.

Prepare to become a Panel *Hero*!
:::

:::{grid-item-card} {octicon}`mortar-board;2.5em;sd-mr-1` Intermediate
:link: intermediate/index
:link-type: doc

Ready to dive deeper into the world of Python and Panel?

These tutorials are tailored for those eager to explore more advanced features.

We'll enhance our applications from the basic tutorial, focusing on performance, scalability, reusability, and maintainability.

Upon completion, you'll be equipped to build large, complex multi-page apps using a *class-based approach*.

You're on your way to becoming a Panel *Expert*!
:::

:::{grid-item-card} {octicon}`star;2.5em;sd-mr-1` Expert
:link: expert/index
:link-type: doc

Ready to push the boundaries of Panel and become a pioneer in your field?

These tutorials are for the daring souls who want to extend Panel's capabilities to suit their specialized domains and use cases.

Once you've completed these tutorials, you'll truly earn the title of Panel *Rock Star*.
:::

::::

```{toctree}
:titlesonly:
:hidden:
:maxdepth: 2

basic/index
intermediate/index
expert/index
```

Let the wind turbine adventure begin! 🌬️🌀
