# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class HostScanTargetErrorSummary(object):
    """
    One of the error during scanning on instances associated with a host scan target (application of a host scan recipe to a compartment or list of hosts).
    """

    #: A constant which can be used with the vendor property of a HostScanTargetErrorSummary.
    #: This constant has a value of "OCI"
    VENDOR_OCI = "OCI"

    #: A constant which can be used with the vendor property of a HostScanTargetErrorSummary.
    #: This constant has a value of "QUALYS"
    VENDOR_QUALYS = "QUALYS"

    #: A constant which can be used with the lifecycle_state property of a HostScanTargetErrorSummary.
    #: This constant has a value of "CREATING"
    LIFECYCLE_STATE_CREATING = "CREATING"

    #: A constant which can be used with the lifecycle_state property of a HostScanTargetErrorSummary.
    #: This constant has a value of "UPDATING"
    LIFECYCLE_STATE_UPDATING = "UPDATING"

    #: A constant which can be used with the lifecycle_state property of a HostScanTargetErrorSummary.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a HostScanTargetErrorSummary.
    #: This constant has a value of "DELETING"
    LIFECYCLE_STATE_DELETING = "DELETING"

    #: A constant which can be used with the lifecycle_state property of a HostScanTargetErrorSummary.
    #: This constant has a value of "DELETED"
    LIFECYCLE_STATE_DELETED = "DELETED"

    #: A constant which can be used with the lifecycle_state property of a HostScanTargetErrorSummary.
    #: This constant has a value of "FAILED"
    LIFECYCLE_STATE_FAILED = "FAILED"

    def __init__(self, **kwargs):
        """
        Initializes a new HostScanTargetErrorSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param vendor:
            The value to assign to the vendor property of this HostScanTargetErrorSummary.
            Allowed values for this property are: "OCI", "QUALYS", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type vendor: str

        :param task:
            The value to assign to the task property of this HostScanTargetErrorSummary.
        :type task: str

        :param message:
            The value to assign to the message property of this HostScanTargetErrorSummary.
        :type message: str

        :param error_code:
            The value to assign to the error_code property of this HostScanTargetErrorSummary.
        :type error_code: str

        :param instance_id:
            The value to assign to the instance_id property of this HostScanTargetErrorSummary.
        :type instance_id: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this HostScanTargetErrorSummary.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type lifecycle_state: str

        :param time_updated:
            The value to assign to the time_updated property of this HostScanTargetErrorSummary.
        :type time_updated: datetime

        :param freeform_tags:
            The value to assign to the freeform_tags property of this HostScanTargetErrorSummary.
        :type freeform_tags: dict(str, str)

        :param defined_tags:
            The value to assign to the defined_tags property of this HostScanTargetErrorSummary.
        :type defined_tags: dict(str, dict(str, object))

        :param system_tags:
            The value to assign to the system_tags property of this HostScanTargetErrorSummary.
        :type system_tags: dict(str, dict(str, object))

        """
        self.swagger_types = {
            'vendor': 'str',
            'task': 'str',
            'message': 'str',
            'error_code': 'str',
            'instance_id': 'str',
            'lifecycle_state': 'str',
            'time_updated': 'datetime',
            'freeform_tags': 'dict(str, str)',
            'defined_tags': 'dict(str, dict(str, object))',
            'system_tags': 'dict(str, dict(str, object))'
        }

        self.attribute_map = {
            'vendor': 'vendor',
            'task': 'task',
            'message': 'message',
            'error_code': 'errorCode',
            'instance_id': 'instanceId',
            'lifecycle_state': 'lifecycleState',
            'time_updated': 'timeUpdated',
            'freeform_tags': 'freeformTags',
            'defined_tags': 'definedTags',
            'system_tags': 'systemTags'
        }

        self._vendor = None
        self._task = None
        self._message = None
        self._error_code = None
        self._instance_id = None
        self._lifecycle_state = None
        self._time_updated = None
        self._freeform_tags = None
        self._defined_tags = None
        self._system_tags = None

    @property
    def vendor(self):
        """
        **[Required]** Gets the vendor of this HostScanTargetErrorSummary.
        Vendor which was used for the host scan agent.

        Allowed values for this property are: "OCI", "QUALYS", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The vendor of this HostScanTargetErrorSummary.
        :rtype: str
        """
        return self._vendor

    @vendor.setter
    def vendor(self, vendor):
        """
        Sets the vendor of this HostScanTargetErrorSummary.
        Vendor which was used for the host scan agent.


        :param vendor: The vendor of this HostScanTargetErrorSummary.
        :type: str
        """
        allowed_values = ["OCI", "QUALYS"]
        if not value_allowed_none_or_none_sentinel(vendor, allowed_values):
            vendor = 'UNKNOWN_ENUM_VALUE'
        self._vendor = vendor

    @property
    def task(self):
        """
        Gets the task of this HostScanTargetErrorSummary.
        Task during scan which failed.


        :return: The task of this HostScanTargetErrorSummary.
        :rtype: str
        """
        return self._task

    @task.setter
    def task(self, task):
        """
        Sets the task of this HostScanTargetErrorSummary.
        Task during scan which failed.


        :param task: The task of this HostScanTargetErrorSummary.
        :type: str
        """
        self._task = task

    @property
    def message(self):
        """
        **[Required]** Gets the message of this HostScanTargetErrorSummary.
        Error message detailing task failure.


        :return: The message of this HostScanTargetErrorSummary.
        :rtype: str
        """
        return self._message

    @message.setter
    def message(self, message):
        """
        Sets the message of this HostScanTargetErrorSummary.
        Error message detailing task failure.


        :param message: The message of this HostScanTargetErrorSummary.
        :type: str
        """
        self._message = message

    @property
    def error_code(self):
        """
        Gets the error_code of this HostScanTargetErrorSummary.
        Error code of task failure.


        :return: The error_code of this HostScanTargetErrorSummary.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code):
        """
        Sets the error_code of this HostScanTargetErrorSummary.
        Error code of task failure.


        :param error_code: The error_code of this HostScanTargetErrorSummary.
        :type: str
        """
        self._error_code = error_code

    @property
    def instance_id(self):
        """
        **[Required]** Gets the instance_id of this HostScanTargetErrorSummary.
        OCID of the host instance where scan was done.


        :return: The instance_id of this HostScanTargetErrorSummary.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this HostScanTargetErrorSummary.
        OCID of the host instance where scan was done.


        :param instance_id: The instance_id of this HostScanTargetErrorSummary.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this HostScanTargetErrorSummary.
        The current state of the config.

        Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The lifecycle_state of this HostScanTargetErrorSummary.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this HostScanTargetErrorSummary.
        The current state of the config.


        :param lifecycle_state: The lifecycle_state of this HostScanTargetErrorSummary.
        :type: str
        """
        allowed_values = ["CREATING", "UPDATING", "ACTIVE", "DELETING", "DELETED", "FAILED"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            lifecycle_state = 'UNKNOWN_ENUM_VALUE'
        self._lifecycle_state = lifecycle_state

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this HostScanTargetErrorSummary.
        Date and time the error was updated, format as described in `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_updated of this HostScanTargetErrorSummary.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this HostScanTargetErrorSummary.
        Date and time the error was updated, format as described in `RFC 3339`__.

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_updated: The time_updated of this HostScanTargetErrorSummary.
        :type: datetime
        """
        self._time_updated = time_updated

    @property
    def freeform_tags(self):
        """
        Gets the freeform_tags of this HostScanTargetErrorSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :return: The freeform_tags of this HostScanTargetErrorSummary.
        :rtype: dict(str, str)
        """
        return self._freeform_tags

    @freeform_tags.setter
    def freeform_tags(self, freeform_tags):
        """
        Sets the freeform_tags of this HostScanTargetErrorSummary.
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        Example: `{\"bar-key\": \"value\"}`


        :param freeform_tags: The freeform_tags of this HostScanTargetErrorSummary.
        :type: dict(str, str)
        """
        self._freeform_tags = freeform_tags

    @property
    def defined_tags(self):
        """
        Gets the defined_tags of this HostScanTargetErrorSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :return: The defined_tags of this HostScanTargetErrorSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._defined_tags

    @defined_tags.setter
    def defined_tags(self, defined_tags):
        """
        Sets the defined_tags of this HostScanTargetErrorSummary.
        Defined tags for this resource. Each key is predefined and scoped to a namespace.
        Example: `{\"foo-namespace\": {\"bar-key\": \"value\"}}`


        :param defined_tags: The defined_tags of this HostScanTargetErrorSummary.
        :type: dict(str, dict(str, object))
        """
        self._defined_tags = defined_tags

    @property
    def system_tags(self):
        """
        Gets the system_tags of this HostScanTargetErrorSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :return: The system_tags of this HostScanTargetErrorSummary.
        :rtype: dict(str, dict(str, object))
        """
        return self._system_tags

    @system_tags.setter
    def system_tags(self, system_tags):
        """
        Sets the system_tags of this HostScanTargetErrorSummary.
        Usage of system tag keys. These predefined keys are scoped to namespaces.
        Example: `{\"orcl-cloud\": {\"free-tier-retained\": \"true\"}}`


        :param system_tags: The system_tags of this HostScanTargetErrorSummary.
        :type: dict(str, dict(str, object))
        """
        self._system_tags = system_tags

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
