# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210215


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ExportHostAgentScanResultCsvDetails(object):
    """
    Details for a HostAgentScan list export to CSV action
    """

    #: A constant which can be used with the highest_problem_severity property of a ExportHostAgentScanResultCsvDetails.
    #: This constant has a value of "NONE"
    HIGHEST_PROBLEM_SEVERITY_NONE = "NONE"

    #: A constant which can be used with the highest_problem_severity property of a ExportHostAgentScanResultCsvDetails.
    #: This constant has a value of "LOW"
    HIGHEST_PROBLEM_SEVERITY_LOW = "LOW"

    #: A constant which can be used with the highest_problem_severity property of a ExportHostAgentScanResultCsvDetails.
    #: This constant has a value of "MEDIUM"
    HIGHEST_PROBLEM_SEVERITY_MEDIUM = "MEDIUM"

    #: A constant which can be used with the highest_problem_severity property of a ExportHostAgentScanResultCsvDetails.
    #: This constant has a value of "HIGH"
    HIGHEST_PROBLEM_SEVERITY_HIGH = "HIGH"

    #: A constant which can be used with the highest_problem_severity property of a ExportHostAgentScanResultCsvDetails.
    #: This constant has a value of "CRITICAL"
    HIGHEST_PROBLEM_SEVERITY_CRITICAL = "CRITICAL"

    def __init__(self, **kwargs):
        """
        Initializes a new ExportHostAgentScanResultCsvDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compartment_id:
            The value to assign to the compartment_id property of this ExportHostAgentScanResultCsvDetails.
        :type compartment_id: str

        :param time_started_after:
            The value to assign to the time_started_after property of this ExportHostAgentScanResultCsvDetails.
        :type time_started_after: datetime

        :param time_started_before:
            The value to assign to the time_started_before property of this ExportHostAgentScanResultCsvDetails.
        :type time_started_before: datetime

        :param highest_problem_severity:
            The value to assign to the highest_problem_severity property of this ExportHostAgentScanResultCsvDetails.
            Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"
        :type highest_problem_severity: str

        :param instance_id:
            The value to assign to the instance_id property of this ExportHostAgentScanResultCsvDetails.
        :type instance_id: str

        :param operating_system:
            The value to assign to the operating_system property of this ExportHostAgentScanResultCsvDetails.
        :type operating_system: str

        """
        self.swagger_types = {
            'compartment_id': 'str',
            'time_started_after': 'datetime',
            'time_started_before': 'datetime',
            'highest_problem_severity': 'str',
            'instance_id': 'str',
            'operating_system': 'str'
        }

        self.attribute_map = {
            'compartment_id': 'compartmentId',
            'time_started_after': 'timeStartedAfter',
            'time_started_before': 'timeStartedBefore',
            'highest_problem_severity': 'highestProblemSeverity',
            'instance_id': 'instanceId',
            'operating_system': 'operatingSystem'
        }

        self._compartment_id = None
        self._time_started_after = None
        self._time_started_before = None
        self._highest_problem_severity = None
        self._instance_id = None
        self._operating_system = None

    @property
    def compartment_id(self):
        """
        **[Required]** Gets the compartment_id of this ExportHostAgentScanResultCsvDetails.
        The `OCID`__ of the compartment to list scans in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The compartment_id of this ExportHostAgentScanResultCsvDetails.
        :rtype: str
        """
        return self._compartment_id

    @compartment_id.setter
    def compartment_id(self, compartment_id):
        """
        Sets the compartment_id of this ExportHostAgentScanResultCsvDetails.
        The `OCID`__ of the compartment to list scans in.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param compartment_id: The compartment_id of this ExportHostAgentScanResultCsvDetails.
        :type: str
        """
        self._compartment_id = compartment_id

    @property
    def time_started_after(self):
        """
        **[Required]** Gets the time_started_after of this ExportHostAgentScanResultCsvDetails.
        Date and time after which scans were started, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_started_after of this ExportHostAgentScanResultCsvDetails.
        :rtype: datetime
        """
        return self._time_started_after

    @time_started_after.setter
    def time_started_after(self, time_started_after):
        """
        Sets the time_started_after of this ExportHostAgentScanResultCsvDetails.
        Date and time after which scans were started, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_started_after: The time_started_after of this ExportHostAgentScanResultCsvDetails.
        :type: datetime
        """
        self._time_started_after = time_started_after

    @property
    def time_started_before(self):
        """
        **[Required]** Gets the time_started_before of this ExportHostAgentScanResultCsvDetails.
        Date and time before which scans were started, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The time_started_before of this ExportHostAgentScanResultCsvDetails.
        :rtype: datetime
        """
        return self._time_started_before

    @time_started_before.setter
    def time_started_before(self, time_started_before):
        """
        Sets the time_started_before of this ExportHostAgentScanResultCsvDetails.
        Date and time before which scans were started, as described in `RFC 3339`__

        __ https://tools.ietf.org/rfc/rfc3339


        :param time_started_before: The time_started_before of this ExportHostAgentScanResultCsvDetails.
        :type: datetime
        """
        self._time_started_before = time_started_before

    @property
    def highest_problem_severity(self):
        """
        Gets the highest_problem_severity of this ExportHostAgentScanResultCsvDetails.
        Parameter to filter by highestProblemSeverity for scan results

        Allowed values for this property are: "NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"


        :return: The highest_problem_severity of this ExportHostAgentScanResultCsvDetails.
        :rtype: str
        """
        return self._highest_problem_severity

    @highest_problem_severity.setter
    def highest_problem_severity(self, highest_problem_severity):
        """
        Sets the highest_problem_severity of this ExportHostAgentScanResultCsvDetails.
        Parameter to filter by highestProblemSeverity for scan results


        :param highest_problem_severity: The highest_problem_severity of this ExportHostAgentScanResultCsvDetails.
        :type: str
        """
        allowed_values = ["NONE", "LOW", "MEDIUM", "HIGH", "CRITICAL"]
        if not value_allowed_none_or_none_sentinel(highest_problem_severity, allowed_values):
            raise ValueError(
                f"Invalid value for `highest_problem_severity`, must be None or one of {allowed_values}"
            )
        self._highest_problem_severity = highest_problem_severity

    @property
    def instance_id(self):
        """
        Gets the instance_id of this ExportHostAgentScanResultCsvDetails.
        Parameter to filter by a single compute instance ID for scan results


        :return: The instance_id of this ExportHostAgentScanResultCsvDetails.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this ExportHostAgentScanResultCsvDetails.
        Parameter to filter by a single compute instance ID for scan results


        :param instance_id: The instance_id of this ExportHostAgentScanResultCsvDetails.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def operating_system(self):
        """
        Gets the operating_system of this ExportHostAgentScanResultCsvDetails.
        Parameter to filter by operating system for scan results


        :return: The operating_system of this ExportHostAgentScanResultCsvDetails.
        :rtype: str
        """
        return self._operating_system

    @operating_system.setter
    def operating_system(self, operating_system):
        """
        Sets the operating_system of this ExportHostAgentScanResultCsvDetails.
        Parameter to filter by operating system for scan results


        :param operating_system: The operating_system of this ExportHostAgentScanResultCsvDetails.
        :type: str
        """
        self._operating_system = operating_system

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
