# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200107


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AverageCarbonEmission(object):
    """
    Average carbon emission.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AverageCarbonEmission object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param sku_part_number:
            The value to assign to the sku_part_number property of this AverageCarbonEmission.
        :type sku_part_number: str

        :param average_carbon_emission:
            The value to assign to the average_carbon_emission property of this AverageCarbonEmission.
        :type average_carbon_emission: float

        """
        self.swagger_types = {
            'sku_part_number': 'str',
            'average_carbon_emission': 'float'
        }

        self.attribute_map = {
            'sku_part_number': 'skuPartNumber',
            'average_carbon_emission': 'averageCarbonEmission'
        }

        self._sku_part_number = None
        self._average_carbon_emission = None

    @property
    def sku_part_number(self):
        """
        **[Required]** Gets the sku_part_number of this AverageCarbonEmission.
        The sku part number.


        :return: The sku_part_number of this AverageCarbonEmission.
        :rtype: str
        """
        return self._sku_part_number

    @sku_part_number.setter
    def sku_part_number(self, sku_part_number):
        """
        Sets the sku_part_number of this AverageCarbonEmission.
        The sku part number.


        :param sku_part_number: The sku_part_number of this AverageCarbonEmission.
        :type: str
        """
        self._sku_part_number = sku_part_number

    @property
    def average_carbon_emission(self):
        """
        **[Required]** Gets the average_carbon_emission of this AverageCarbonEmission.
        The average carbon emissions by SKU.


        :return: The average_carbon_emission of this AverageCarbonEmission.
        :rtype: float
        """
        return self._average_carbon_emission

    @average_carbon_emission.setter
    def average_carbon_emission(self, average_carbon_emission):
        """
        Sets the average_carbon_emission of this AverageCarbonEmission.
        The average carbon emissions by SKU.


        :param average_carbon_emission: The average_carbon_emission of this AverageCarbonEmission.
        :type: float
        """
        self._average_carbon_emission = average_carbon_emission

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
