# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210201


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PutMessage(object):
    """
    A message that has been published to a queue.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new PutMessage object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param id:
            The value to assign to the id property of this PutMessage.
        :type id: int

        :param expire_after:
            The value to assign to the expire_after property of this PutMessage.
        :type expire_after: datetime

        """
        self.swagger_types = {
            'id': 'int',
            'expire_after': 'datetime'
        }

        self.attribute_map = {
            'id': 'id',
            'expire_after': 'expireAfter'
        }

        self._id = None
        self._expire_after = None

    @property
    def id(self):
        """
        **[Required]** Gets the id of this PutMessage.
        The ID of the message.


        :return: The id of this PutMessage.
        :rtype: int
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this PutMessage.
        The ID of the message.


        :param id: The id of this PutMessage.
        :type: int
        """
        self._id = id

    @property
    def expire_after(self):
        """
        Gets the expire_after of this PutMessage.
        The time after which the message will be automatically deleted, expressed in `RFC 3339`__ timestamp format.

        Example: `2018-04-20T00:00:07.405Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :return: The expire_after of this PutMessage.
        :rtype: datetime
        """
        return self._expire_after

    @expire_after.setter
    def expire_after(self, expire_after):
        """
        Sets the expire_after of this PutMessage.
        The time after which the message will be automatically deleted, expressed in `RFC 3339`__ timestamp format.

        Example: `2018-04-20T00:00:07.405Z`

        __ https://tools.ietf.org/rfc/rfc3339


        :param expire_after: The expire_after of this PutMessage.
        :type: datetime
        """
        self._expire_after = expire_after

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
