# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class AddPackagesToSoftwareSourceDetails(object):
    """
    Provides the list of packages to add to a software source.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new AddPackagesToSoftwareSourceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param packages:
            The value to assign to the packages property of this AddPackagesToSoftwareSourceDetails.
        :type packages: list[str]

        """
        self.swagger_types = {
            'packages': 'list[str]'
        }

        self.attribute_map = {
            'packages': 'packages'
        }

        self._packages = None

    @property
    def packages(self):
        """
        **[Required]** Gets the packages of this AddPackagesToSoftwareSourceDetails.
        List of packages specified by the full package name (NEVRA.rpm).


        :return: The packages of this AddPackagesToSoftwareSourceDetails.
        :rtype: list[str]
        """
        return self._packages

    @packages.setter
    def packages(self, packages):
        """
        Sets the packages of this AddPackagesToSoftwareSourceDetails.
        List of packages specified by the full package name (NEVRA.rpm).


        :param packages: The packages of this AddPackagesToSoftwareSourceDetails.
        :type: list[str]
        """
        self._packages = packages

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
