# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20230501

from .service import Service
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class TcpService(Service):
    """
    TCP Service used on the firewall policy rules.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new TcpService object with values from keyword arguments. The default value of the :py:attr:`~oci.network_firewall.models.TcpService.type` attribute
        of this class is ``TCP_SERVICE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this TcpService.
            Allowed values for this property are: "TCP_SERVICE", "UDP_SERVICE"
        :type type: str

        :param name:
            The value to assign to the name property of this TcpService.
        :type name: str

        :param parent_resource_id:
            The value to assign to the parent_resource_id property of this TcpService.
        :type parent_resource_id: str

        :param port_ranges:
            The value to assign to the port_ranges property of this TcpService.
        :type port_ranges: list[oci.network_firewall.models.PortRange]

        """
        self.swagger_types = {
            'type': 'str',
            'name': 'str',
            'parent_resource_id': 'str',
            'port_ranges': 'list[PortRange]'
        }

        self.attribute_map = {
            'type': 'type',
            'name': 'name',
            'parent_resource_id': 'parentResourceId',
            'port_ranges': 'portRanges'
        }

        self._type = None
        self._name = None
        self._parent_resource_id = None
        self._port_ranges = None
        self._type = 'TCP_SERVICE'

    @property
    def port_ranges(self):
        """
        **[Required]** Gets the port_ranges of this TcpService.
        List of port-ranges used.


        :return: The port_ranges of this TcpService.
        :rtype: list[oci.network_firewall.models.PortRange]
        """
        return self._port_ranges

    @port_ranges.setter
    def port_ranges(self, port_ranges):
        """
        Sets the port_ranges of this TcpService.
        List of port-ranges used.


        :param port_ranges: The port_ranges of this TcpService.
        :type: list[oci.network_firewall.models.PortRange]
        """
        self._port_ranges = port_ranges

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
