# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class VersionDetails(object):
    """
    A listing version provided by the Publisher.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new VersionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param number:
            The value to assign to the number property of this VersionDetails.
        :type number: str

        :param description:
            The value to assign to the description property of this VersionDetails.
        :type description: str

        :param release_date:
            The value to assign to the release_date property of this VersionDetails.
        :type release_date: str

        """
        self.swagger_types = {
            'number': 'str',
            'description': 'str',
            'release_date': 'str'
        }

        self.attribute_map = {
            'number': 'number',
            'description': 'description',
            'release_date': 'releaseDate'
        }

        self._number = None
        self._description = None
        self._release_date = None

    @property
    def number(self):
        """
        **[Required]** Gets the number of this VersionDetails.
        The version number.


        :return: The number of this VersionDetails.
        :rtype: str
        """
        return self._number

    @number.setter
    def number(self, number):
        """
        Sets the number of this VersionDetails.
        The version number.


        :param number: The number of this VersionDetails.
        :type: str
        """
        self._number = number

    @property
    def description(self):
        """
        **[Required]** Gets the description of this VersionDetails.
        The version description.


        :return: The description of this VersionDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this VersionDetails.
        The version description.


        :param description: The description of this VersionDetails.
        :type: str
        """
        self._description = description

    @property
    def release_date(self):
        """
        **[Required]** Gets the release_date of this VersionDetails.
        The version release date.


        :return: The release_date of this VersionDetails.
        :rtype: str
        """
        return self._release_date

    @release_date.setter
    def release_date(self, release_date):
        """
        Sets the release_date of this VersionDetails.
        The version release date.


        :param release_date: The release_date of this VersionDetails.
        :type: str
        """
        self._release_date = release_date

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
