# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220901


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateHelmChartImageDetails(object):
    """
    Helmchart image details required to create an helmchart artifact.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateHelmChartImageDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source_registry_id:
            The value to assign to the source_registry_id property of this CreateHelmChartImageDetails.
        :type source_registry_id: str

        :param source_registry_url:
            The value to assign to the source_registry_url property of this CreateHelmChartImageDetails.
        :type source_registry_url: str

        :param supported_kubernetes_versions:
            The value to assign to the supported_kubernetes_versions property of this CreateHelmChartImageDetails.
        :type supported_kubernetes_versions: list[str]

        """
        self.swagger_types = {
            'source_registry_id': 'str',
            'source_registry_url': 'str',
            'supported_kubernetes_versions': 'list[str]'
        }

        self.attribute_map = {
            'source_registry_id': 'sourceRegistryId',
            'source_registry_url': 'sourceRegistryUrl',
            'supported_kubernetes_versions': 'supportedKubernetesVersions'
        }

        self._source_registry_id = None
        self._source_registry_url = None
        self._supported_kubernetes_versions = None

    @property
    def source_registry_id(self):
        """
        **[Required]** Gets the source_registry_id of this CreateHelmChartImageDetails.
        The source registry OCID of the container image.


        :return: The source_registry_id of this CreateHelmChartImageDetails.
        :rtype: str
        """
        return self._source_registry_id

    @source_registry_id.setter
    def source_registry_id(self, source_registry_id):
        """
        Sets the source_registry_id of this CreateHelmChartImageDetails.
        The source registry OCID of the container image.


        :param source_registry_id: The source_registry_id of this CreateHelmChartImageDetails.
        :type: str
        """
        self._source_registry_id = source_registry_id

    @property
    def source_registry_url(self):
        """
        **[Required]** Gets the source_registry_url of this CreateHelmChartImageDetails.
        The source registry url of the helmchart image.


        :return: The source_registry_url of this CreateHelmChartImageDetails.
        :rtype: str
        """
        return self._source_registry_url

    @source_registry_url.setter
    def source_registry_url(self, source_registry_url):
        """
        Sets the source_registry_url of this CreateHelmChartImageDetails.
        The source registry url of the helmchart image.


        :param source_registry_url: The source_registry_url of this CreateHelmChartImageDetails.
        :type: str
        """
        self._source_registry_url = source_registry_url

    @property
    def supported_kubernetes_versions(self):
        """
        Gets the supported_kubernetes_versions of this CreateHelmChartImageDetails.
        The Supported Versions of Kubernetes


        :return: The supported_kubernetes_versions of this CreateHelmChartImageDetails.
        :rtype: list[str]
        """
        return self._supported_kubernetes_versions

    @supported_kubernetes_versions.setter
    def supported_kubernetes_versions(self, supported_kubernetes_versions):
        """
        Sets the supported_kubernetes_versions of this CreateHelmChartImageDetails.
        The Supported Versions of Kubernetes


        :param supported_kubernetes_versions: The supported_kubernetes_versions of this CreateHelmChartImageDetails.
        :type: list[str]
        """
        self._supported_kubernetes_versions = supported_kubernetes_versions

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
