# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20181001


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class PricingModel(object):
    """
    The model for pricing.
    """

    #: A constant which can be used with the type property of a PricingModel.
    #: This constant has a value of "FREE"
    TYPE_FREE = "FREE"

    #: A constant which can be used with the type property of a PricingModel.
    #: This constant has a value of "BYOL"
    TYPE_BYOL = "BYOL"

    #: A constant which can be used with the type property of a PricingModel.
    #: This constant has a value of "PAYGO"
    TYPE_PAYGO = "PAYGO"

    #: A constant which can be used with the pay_go_strategy property of a PricingModel.
    #: This constant has a value of "PER_OCPU_LINEAR"
    PAY_GO_STRATEGY_PER_OCPU_LINEAR = "PER_OCPU_LINEAR"

    #: A constant which can be used with the pay_go_strategy property of a PricingModel.
    #: This constant has a value of "PER_OCPU_MIN_BILLING"
    PAY_GO_STRATEGY_PER_OCPU_MIN_BILLING = "PER_OCPU_MIN_BILLING"

    #: A constant which can be used with the pay_go_strategy property of a PricingModel.
    #: This constant has a value of "PER_INSTANCE"
    PAY_GO_STRATEGY_PER_INSTANCE = "PER_INSTANCE"

    #: A constant which can be used with the pay_go_strategy property of a PricingModel.
    #: This constant has a value of "PER_INSTANCE_MONTHLY_INCLUSIVE"
    PAY_GO_STRATEGY_PER_INSTANCE_MONTHLY_INCLUSIVE = "PER_INSTANCE_MONTHLY_INCLUSIVE"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "USD"
    CURRENCY_USD = "USD"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "CAD"
    CURRENCY_CAD = "CAD"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "INR"
    CURRENCY_INR = "INR"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "GBP"
    CURRENCY_GBP = "GBP"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "BRL"
    CURRENCY_BRL = "BRL"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "JPY"
    CURRENCY_JPY = "JPY"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "OMR"
    CURRENCY_OMR = "OMR"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "EUR"
    CURRENCY_EUR = "EUR"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "CHF"
    CURRENCY_CHF = "CHF"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "MXN"
    CURRENCY_MXN = "MXN"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "CLP"
    CURRENCY_CLP = "CLP"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "ALL"
    CURRENCY_ALL = "ALL"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "ARS"
    CURRENCY_ARS = "ARS"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "AUD"
    CURRENCY_AUD = "AUD"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "BDT"
    CURRENCY_BDT = "BDT"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "BAM"
    CURRENCY_BAM = "BAM"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "BGN"
    CURRENCY_BGN = "BGN"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "CNY"
    CURRENCY_CNY = "CNY"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "COP"
    CURRENCY_COP = "COP"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "CRC"
    CURRENCY_CRC = "CRC"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "HRK"
    CURRENCY_HRK = "HRK"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "CZK"
    CURRENCY_CZK = "CZK"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "DKK"
    CURRENCY_DKK = "DKK"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "EGP"
    CURRENCY_EGP = "EGP"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "HKD"
    CURRENCY_HKD = "HKD"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "HUF"
    CURRENCY_HUF = "HUF"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "ISK"
    CURRENCY_ISK = "ISK"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "IDR"
    CURRENCY_IDR = "IDR"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "ILS"
    CURRENCY_ILS = "ILS"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "JMD"
    CURRENCY_JMD = "JMD"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "KZT"
    CURRENCY_KZT = "KZT"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "KES"
    CURRENCY_KES = "KES"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "KRW"
    CURRENCY_KRW = "KRW"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "KWD"
    CURRENCY_KWD = "KWD"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "LBP"
    CURRENCY_LBP = "LBP"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "MOP"
    CURRENCY_MOP = "MOP"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "MYR"
    CURRENCY_MYR = "MYR"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "MVR"
    CURRENCY_MVR = "MVR"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "AED"
    CURRENCY_AED = "AED"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "NZD"
    CURRENCY_NZD = "NZD"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "NOK"
    CURRENCY_NOK = "NOK"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "PKR"
    CURRENCY_PKR = "PKR"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "PEN"
    CURRENCY_PEN = "PEN"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "PHP"
    CURRENCY_PHP = "PHP"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "PLN"
    CURRENCY_PLN = "PLN"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "QAR"
    CURRENCY_QAR = "QAR"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "RON"
    CURRENCY_RON = "RON"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "SAR"
    CURRENCY_SAR = "SAR"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "RSD"
    CURRENCY_RSD = "RSD"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "SGD"
    CURRENCY_SGD = "SGD"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "ZAR"
    CURRENCY_ZAR = "ZAR"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "SEK"
    CURRENCY_SEK = "SEK"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "TWD"
    CURRENCY_TWD = "TWD"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "THB"
    CURRENCY_THB = "THB"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "TRY"
    CURRENCY_TRY = "TRY"

    #: A constant which can be used with the currency property of a PricingModel.
    #: This constant has a value of "VND"
    CURRENCY_VND = "VND"

    def __init__(self, **kwargs):
        """
        Initializes a new PricingModel object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param type:
            The value to assign to the type property of this PricingModel.
            Allowed values for this property are: "FREE", "BYOL", "PAYGO", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type type: str

        :param pay_go_strategy:
            The value to assign to the pay_go_strategy property of this PricingModel.
            Allowed values for this property are: "PER_OCPU_LINEAR", "PER_OCPU_MIN_BILLING", "PER_INSTANCE", "PER_INSTANCE_MONTHLY_INCLUSIVE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type pay_go_strategy: str

        :param currency:
            The value to assign to the currency property of this PricingModel.
            Allowed values for this property are: "USD", "CAD", "INR", "GBP", "BRL", "JPY", "OMR", "EUR", "CHF", "MXN", "CLP", "ALL", "ARS", "AUD", "BDT", "BAM", "BGN", "CNY", "COP", "CRC", "HRK", "CZK", "DKK", "EGP", "HKD", "HUF", "ISK", "IDR", "ILS", "JMD", "KZT", "KES", "KRW", "KWD", "LBP", "MOP", "MYR", "MVR", "AED", "NZD", "NOK", "PKR", "PEN", "PHP", "PLN", "QAR", "RON", "SAR", "RSD", "SGD", "ZAR", "SEK", "TWD", "THB", "TRY", "VND", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type currency: str

        :param rate:
            The value to assign to the rate property of this PricingModel.
        :type rate: float

        :param international_market_price:
            The value to assign to the international_market_price property of this PricingModel.
        :type international_market_price: oci.marketplace.models.InternationalMarketPrice

        """
        self.swagger_types = {
            'type': 'str',
            'pay_go_strategy': 'str',
            'currency': 'str',
            'rate': 'float',
            'international_market_price': 'InternationalMarketPrice'
        }

        self.attribute_map = {
            'type': 'type',
            'pay_go_strategy': 'payGoStrategy',
            'currency': 'currency',
            'rate': 'rate',
            'international_market_price': 'internationalMarketPrice'
        }

        self._type = None
        self._pay_go_strategy = None
        self._currency = None
        self._rate = None
        self._international_market_price = None

    @property
    def type(self):
        """
        **[Required]** Gets the type of this PricingModel.
        The type of the pricing model.

        Allowed values for this property are: "FREE", "BYOL", "PAYGO", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The type of this PricingModel.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """
        Sets the type of this PricingModel.
        The type of the pricing model.


        :param type: The type of this PricingModel.
        :type: str
        """
        allowed_values = ["FREE", "BYOL", "PAYGO"]
        if not value_allowed_none_or_none_sentinel(type, allowed_values):
            type = 'UNKNOWN_ENUM_VALUE'
        self._type = type

    @property
    def pay_go_strategy(self):
        """
        Gets the pay_go_strategy of this PricingModel.
        The type of pricing for a PAYGO model, eg PER_OCPU_LINEAR, PER_OCPU_MIN_BILLING, PER_INSTANCE.  Null if type is not PAYGO.

        Allowed values for this property are: "PER_OCPU_LINEAR", "PER_OCPU_MIN_BILLING", "PER_INSTANCE", "PER_INSTANCE_MONTHLY_INCLUSIVE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The pay_go_strategy of this PricingModel.
        :rtype: str
        """
        return self._pay_go_strategy

    @pay_go_strategy.setter
    def pay_go_strategy(self, pay_go_strategy):
        """
        Sets the pay_go_strategy of this PricingModel.
        The type of pricing for a PAYGO model, eg PER_OCPU_LINEAR, PER_OCPU_MIN_BILLING, PER_INSTANCE.  Null if type is not PAYGO.


        :param pay_go_strategy: The pay_go_strategy of this PricingModel.
        :type: str
        """
        allowed_values = ["PER_OCPU_LINEAR", "PER_OCPU_MIN_BILLING", "PER_INSTANCE", "PER_INSTANCE_MONTHLY_INCLUSIVE"]
        if not value_allowed_none_or_none_sentinel(pay_go_strategy, allowed_values):
            pay_go_strategy = 'UNKNOWN_ENUM_VALUE'
        self._pay_go_strategy = pay_go_strategy

    @property
    def currency(self):
        """
        Gets the currency of this PricingModel.
        The currency of the pricing model.

        Allowed values for this property are: "USD", "CAD", "INR", "GBP", "BRL", "JPY", "OMR", "EUR", "CHF", "MXN", "CLP", "ALL", "ARS", "AUD", "BDT", "BAM", "BGN", "CNY", "COP", "CRC", "HRK", "CZK", "DKK", "EGP", "HKD", "HUF", "ISK", "IDR", "ILS", "JMD", "KZT", "KES", "KRW", "KWD", "LBP", "MOP", "MYR", "MVR", "AED", "NZD", "NOK", "PKR", "PEN", "PHP", "PLN", "QAR", "RON", "SAR", "RSD", "SGD", "ZAR", "SEK", "TWD", "THB", "TRY", "VND", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The currency of this PricingModel.
        :rtype: str
        """
        return self._currency

    @currency.setter
    def currency(self, currency):
        """
        Sets the currency of this PricingModel.
        The currency of the pricing model.


        :param currency: The currency of this PricingModel.
        :type: str
        """
        allowed_values = ["USD", "CAD", "INR", "GBP", "BRL", "JPY", "OMR", "EUR", "CHF", "MXN", "CLP", "ALL", "ARS", "AUD", "BDT", "BAM", "BGN", "CNY", "COP", "CRC", "HRK", "CZK", "DKK", "EGP", "HKD", "HUF", "ISK", "IDR", "ILS", "JMD", "KZT", "KES", "KRW", "KWD", "LBP", "MOP", "MYR", "MVR", "AED", "NZD", "NOK", "PKR", "PEN", "PHP", "PLN", "QAR", "RON", "SAR", "RSD", "SGD", "ZAR", "SEK", "TWD", "THB", "TRY", "VND"]
        if not value_allowed_none_or_none_sentinel(currency, allowed_values):
            currency = 'UNKNOWN_ENUM_VALUE'
        self._currency = currency

    @property
    def rate(self):
        """
        Gets the rate of this PricingModel.
        The pricing rate.


        :return: The rate of this PricingModel.
        :rtype: float
        """
        return self._rate

    @rate.setter
    def rate(self, rate):
        """
        Sets the rate of this PricingModel.
        The pricing rate.


        :param rate: The rate of this PricingModel.
        :type: float
        """
        self._rate = rate

    @property
    def international_market_price(self):
        """
        Gets the international_market_price of this PricingModel.

        :return: The international_market_price of this PricingModel.
        :rtype: oci.marketplace.models.InternationalMarketPrice
        """
        return self._international_market_price

    @international_market_price.setter
    def international_market_price(self, international_market_price):
        """
        Sets the international_market_price of this PricingModel.

        :param international_market_price: The international_market_price of this PricingModel.
        :type: oci.marketplace.models.InternationalMarketPrice
        """
        self._international_market_price = international_market_price

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
