# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200202

from .data_source import DataSource
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class KubernetesClusterDataSource(DataSource):
    """
    A Kubernetes cluster data source.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new KubernetesClusterDataSource object with values from keyword arguments. The default value of the :py:attr:`~oci.management_agent.models.KubernetesClusterDataSource.type` attribute
        of this class is ``KUBERNETES_CLUSTER`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param key:
            The value to assign to the key property of this KubernetesClusterDataSource.
        :type key: str

        :param type:
            The value to assign to the type property of this KubernetesClusterDataSource.
            Allowed values for this property are: "KUBERNETES_CLUSTER", "PROMETHEUS_EMITTER"
        :type type: str

        :param name:
            The value to assign to the name property of this KubernetesClusterDataSource.
        :type name: str

        :param compartment_id:
            The value to assign to the compartment_id property of this KubernetesClusterDataSource.
        :type compartment_id: str

        :param state:
            The value to assign to the state property of this KubernetesClusterDataSource.
            Allowed values for this property are: "CREATING", "UPDATING", "ACTIVE", "INACTIVE", "TERMINATED", "DELETING", "DELETED", "FAILED"
        :type state: str

        :param time_created:
            The value to assign to the time_created property of this KubernetesClusterDataSource.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this KubernetesClusterDataSource.
        :type time_updated: datetime

        :param namespace:
            The value to assign to the namespace property of this KubernetesClusterDataSource.
        :type namespace: str

        :param is_daemon_set:
            The value to assign to the is_daemon_set property of this KubernetesClusterDataSource.
        :type is_daemon_set: bool

        """
        self.swagger_types = {
            'key': 'str',
            'type': 'str',
            'name': 'str',
            'compartment_id': 'str',
            'state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime',
            'namespace': 'str',
            'is_daemon_set': 'bool'
        }

        self.attribute_map = {
            'key': 'key',
            'type': 'type',
            'name': 'name',
            'compartment_id': 'compartmentId',
            'state': 'state',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated',
            'namespace': 'namespace',
            'is_daemon_set': 'isDaemonSet'
        }

        self._key = None
        self._type = None
        self._name = None
        self._compartment_id = None
        self._state = None
        self._time_created = None
        self._time_updated = None
        self._namespace = None
        self._is_daemon_set = None
        self._type = 'KUBERNETES_CLUSTER'

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this KubernetesClusterDataSource.
        The Kubernetes namespace


        :return: The namespace of this KubernetesClusterDataSource.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this KubernetesClusterDataSource.
        The Kubernetes namespace


        :param namespace: The namespace of this KubernetesClusterDataSource.
        :type: str
        """
        self._namespace = namespace

    @property
    def is_daemon_set(self):
        """
        Gets the is_daemon_set of this KubernetesClusterDataSource.
        If the Kubernetes cluster type is Daemon set then this will be set to true.


        :return: The is_daemon_set of this KubernetesClusterDataSource.
        :rtype: bool
        """
        return self._is_daemon_set

    @is_daemon_set.setter
    def is_daemon_set(self, is_daemon_set):
        """
        Sets the is_daemon_set of this KubernetesClusterDataSource.
        If the Kubernetes cluster type is Daemon set then this will be set to true.


        :param is_daemon_set: The is_daemon_set of this KubernetesClusterDataSource.
        :type: bool
        """
        self._is_daemon_set = is_daemon_set

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
