# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200531


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class OperationalMetricsConfiguration(object):
    """
    Unified monitoring agent operational metrics configuration object.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new OperationalMetricsConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param source:
            The value to assign to the source property of this OperationalMetricsConfiguration.
        :type source: oci.logging.models.OperationalMetricsSource

        :param destination:
            The value to assign to the destination property of this OperationalMetricsConfiguration.
        :type destination: oci.logging.models.OperationalMetricsDestination

        """
        self.swagger_types = {
            'source': 'OperationalMetricsSource',
            'destination': 'OperationalMetricsDestination'
        }

        self.attribute_map = {
            'source': 'source',
            'destination': 'destination'
        }

        self._source = None
        self._destination = None

    @property
    def source(self):
        """
        **[Required]** Gets the source of this OperationalMetricsConfiguration.

        :return: The source of this OperationalMetricsConfiguration.
        :rtype: oci.logging.models.OperationalMetricsSource
        """
        return self._source

    @source.setter
    def source(self, source):
        """
        Sets the source of this OperationalMetricsConfiguration.

        :param source: The source of this OperationalMetricsConfiguration.
        :type: oci.logging.models.OperationalMetricsSource
        """
        self._source = source

    @property
    def destination(self):
        """
        **[Required]** Gets the destination of this OperationalMetricsConfiguration.

        :return: The destination of this OperationalMetricsConfiguration.
        :rtype: oci.logging.models.OperationalMetricsDestination
        """
        return self._destination

    @destination.setter
    def destination(self, destination):
        """
        Sets the destination of this OperationalMetricsConfiguration.

        :param destination: The destination of this OperationalMetricsConfiguration.
        :type: oci.logging.models.OperationalMetricsDestination
        """
        self._destination = destination

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
