# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210610


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class CreateDrsFileDetails(object):
    """
    Details of the request to create DRS file in a Fleet.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new CreateDrsFileDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param bucket_name:
            The value to assign to the bucket_name property of this CreateDrsFileDetails.
        :type bucket_name: str

        :param namespace:
            The value to assign to the namespace property of this CreateDrsFileDetails.
        :type namespace: str

        :param drs_file_name:
            The value to assign to the drs_file_name property of this CreateDrsFileDetails.
        :type drs_file_name: str

        """
        self.swagger_types = {
            'bucket_name': 'str',
            'namespace': 'str',
            'drs_file_name': 'str'
        }

        self.attribute_map = {
            'bucket_name': 'bucketName',
            'namespace': 'namespace',
            'drs_file_name': 'drsFileName'
        }

        self._bucket_name = None
        self._namespace = None
        self._drs_file_name = None

    @property
    def bucket_name(self):
        """
        **[Required]** Gets the bucket_name of this CreateDrsFileDetails.
        The Object Storage bucket name where the DRS file is located.


        :return: The bucket_name of this CreateDrsFileDetails.
        :rtype: str
        """
        return self._bucket_name

    @bucket_name.setter
    def bucket_name(self, bucket_name):
        """
        Sets the bucket_name of this CreateDrsFileDetails.
        The Object Storage bucket name where the DRS file is located.


        :param bucket_name: The bucket_name of this CreateDrsFileDetails.
        :type: str
        """
        self._bucket_name = bucket_name

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this CreateDrsFileDetails.
        The namespace for Object Storage.


        :return: The namespace of this CreateDrsFileDetails.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this CreateDrsFileDetails.
        The namespace for Object Storage.


        :param namespace: The namespace of this CreateDrsFileDetails.
        :type: str
        """
        self._namespace = namespace

    @property
    def drs_file_name(self):
        """
        **[Required]** Gets the drs_file_name of this CreateDrsFileDetails.
        The name of the DRS file in Object Store.


        :return: The drs_file_name of this CreateDrsFileDetails.
        :rtype: str
        """
        return self._drs_file_name

    @drs_file_name.setter
    def drs_file_name(self, drs_file_name):
        """
        Sets the drs_file_name of this CreateDrsFileDetails.
        The name of the DRS file in Object Store.


        :param drs_file_name: The drs_file_name of this CreateDrsFileDetails.
        :type: str
        """
        self._drs_file_name = drs_file_name

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
