# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210630

from .filter import Filter
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GitlabFilter(Filter):
    """
    The filter for GitLab events.
    """

    #: A constant which can be used with the events property of a GitlabFilter.
    #: This constant has a value of "PUSH"
    EVENTS_PUSH = "PUSH"

    #: A constant which can be used with the events property of a GitlabFilter.
    #: This constant has a value of "PULL_REQUEST_CREATED"
    EVENTS_PULL_REQUEST_CREATED = "PULL_REQUEST_CREATED"

    #: A constant which can be used with the events property of a GitlabFilter.
    #: This constant has a value of "PULL_REQUEST_UPDATED"
    EVENTS_PULL_REQUEST_UPDATED = "PULL_REQUEST_UPDATED"

    #: A constant which can be used with the events property of a GitlabFilter.
    #: This constant has a value of "PULL_REQUEST_REOPENED"
    EVENTS_PULL_REQUEST_REOPENED = "PULL_REQUEST_REOPENED"

    #: A constant which can be used with the events property of a GitlabFilter.
    #: This constant has a value of "PULL_REQUEST_MERGED"
    EVENTS_PULL_REQUEST_MERGED = "PULL_REQUEST_MERGED"

    def __init__(self, **kwargs):
        """
        Initializes a new GitlabFilter object with values from keyword arguments. The default value of the :py:attr:`~oci.devops.models.GitlabFilter.trigger_source` attribute
        of this class is ``GITLAB`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param trigger_source:
            The value to assign to the trigger_source property of this GitlabFilter.
        :type trigger_source: str

        :param events:
            The value to assign to the events property of this GitlabFilter.
            Allowed values for items in this list are: "PUSH", "PULL_REQUEST_CREATED", "PULL_REQUEST_UPDATED", "PULL_REQUEST_REOPENED", "PULL_REQUEST_MERGED", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type events: list[str]

        :param include:
            The value to assign to the include property of this GitlabFilter.
        :type include: oci.devops.models.GitlabFilterAttributes

        :param exclude:
            The value to assign to the exclude property of this GitlabFilter.
        :type exclude: oci.devops.models.GitlabFilterExclusionAttributes

        """
        self.swagger_types = {
            'trigger_source': 'str',
            'events': 'list[str]',
            'include': 'GitlabFilterAttributes',
            'exclude': 'GitlabFilterExclusionAttributes'
        }

        self.attribute_map = {
            'trigger_source': 'triggerSource',
            'events': 'events',
            'include': 'include',
            'exclude': 'exclude'
        }

        self._trigger_source = None
        self._events = None
        self._include = None
        self._exclude = None
        self._trigger_source = 'GITLAB'

    @property
    def events(self):
        """
        Gets the events of this GitlabFilter.
        The events, for example, PUSH, PULL_REQUEST_MERGE.

        Allowed values for items in this list are: "PUSH", "PULL_REQUEST_CREATED", "PULL_REQUEST_UPDATED", "PULL_REQUEST_REOPENED", "PULL_REQUEST_MERGED", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The events of this GitlabFilter.
        :rtype: list[str]
        """
        return self._events

    @events.setter
    def events(self, events):
        """
        Sets the events of this GitlabFilter.
        The events, for example, PUSH, PULL_REQUEST_MERGE.


        :param events: The events of this GitlabFilter.
        :type: list[str]
        """
        allowed_values = ["PUSH", "PULL_REQUEST_CREATED", "PULL_REQUEST_UPDATED", "PULL_REQUEST_REOPENED", "PULL_REQUEST_MERGED"]
        if events:
            events[:] = ['UNKNOWN_ENUM_VALUE' if not value_allowed_none_or_none_sentinel(x, allowed_values) else x for x in events]
        self._events = events

    @property
    def include(self):
        """
        Gets the include of this GitlabFilter.

        :return: The include of this GitlabFilter.
        :rtype: oci.devops.models.GitlabFilterAttributes
        """
        return self._include

    @include.setter
    def include(self, include):
        """
        Sets the include of this GitlabFilter.

        :param include: The include of this GitlabFilter.
        :type: oci.devops.models.GitlabFilterAttributes
        """
        self._include = include

    @property
    def exclude(self):
        """
        Gets the exclude of this GitlabFilter.

        :return: The exclude of this GitlabFilter.
        :rtype: oci.devops.models.GitlabFilterExclusionAttributes
        """
        return self._exclude

    @exclude.setter
    def exclude(self, exclude):
        """
        Sets the exclude of this GitlabFilter.

        :param exclude: The exclude of this GitlabFilter.
        :type: oci.devops.models.GitlabFilterExclusionAttributes
        """
        self._exclude = exclude

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
