# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220618


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DesktopDevicePolicy(object):
    """
    Provides the settings for desktop and client device options, such as audio in and out, client drive mapping, and clipboard access.
    """

    #: A constant which can be used with the clipboard_mode property of a DesktopDevicePolicy.
    #: This constant has a value of "NONE"
    CLIPBOARD_MODE_NONE = "NONE"

    #: A constant which can be used with the clipboard_mode property of a DesktopDevicePolicy.
    #: This constant has a value of "TODESKTOP"
    CLIPBOARD_MODE_TODESKTOP = "TODESKTOP"

    #: A constant which can be used with the clipboard_mode property of a DesktopDevicePolicy.
    #: This constant has a value of "FROMDESKTOP"
    CLIPBOARD_MODE_FROMDESKTOP = "FROMDESKTOP"

    #: A constant which can be used with the clipboard_mode property of a DesktopDevicePolicy.
    #: This constant has a value of "FULL"
    CLIPBOARD_MODE_FULL = "FULL"

    #: A constant which can be used with the audio_mode property of a DesktopDevicePolicy.
    #: This constant has a value of "NONE"
    AUDIO_MODE_NONE = "NONE"

    #: A constant which can be used with the audio_mode property of a DesktopDevicePolicy.
    #: This constant has a value of "TODESKTOP"
    AUDIO_MODE_TODESKTOP = "TODESKTOP"

    #: A constant which can be used with the audio_mode property of a DesktopDevicePolicy.
    #: This constant has a value of "FROMDESKTOP"
    AUDIO_MODE_FROMDESKTOP = "FROMDESKTOP"

    #: A constant which can be used with the audio_mode property of a DesktopDevicePolicy.
    #: This constant has a value of "FULL"
    AUDIO_MODE_FULL = "FULL"

    #: A constant which can be used with the cdm_mode property of a DesktopDevicePolicy.
    #: This constant has a value of "NONE"
    CDM_MODE_NONE = "NONE"

    #: A constant which can be used with the cdm_mode property of a DesktopDevicePolicy.
    #: This constant has a value of "READONLY"
    CDM_MODE_READONLY = "READONLY"

    #: A constant which can be used with the cdm_mode property of a DesktopDevicePolicy.
    #: This constant has a value of "FULL"
    CDM_MODE_FULL = "FULL"

    def __init__(self, **kwargs):
        """
        Initializes a new DesktopDevicePolicy object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param clipboard_mode:
            The value to assign to the clipboard_mode property of this DesktopDevicePolicy.
            Allowed values for this property are: "NONE", "TODESKTOP", "FROMDESKTOP", "FULL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type clipboard_mode: str

        :param audio_mode:
            The value to assign to the audio_mode property of this DesktopDevicePolicy.
            Allowed values for this property are: "NONE", "TODESKTOP", "FROMDESKTOP", "FULL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type audio_mode: str

        :param cdm_mode:
            The value to assign to the cdm_mode property of this DesktopDevicePolicy.
            Allowed values for this property are: "NONE", "READONLY", "FULL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type cdm_mode: str

        :param is_printing_enabled:
            The value to assign to the is_printing_enabled property of this DesktopDevicePolicy.
        :type is_printing_enabled: bool

        :param is_pointer_enabled:
            The value to assign to the is_pointer_enabled property of this DesktopDevicePolicy.
        :type is_pointer_enabled: bool

        :param is_keyboard_enabled:
            The value to assign to the is_keyboard_enabled property of this DesktopDevicePolicy.
        :type is_keyboard_enabled: bool

        :param is_display_enabled:
            The value to assign to the is_display_enabled property of this DesktopDevicePolicy.
        :type is_display_enabled: bool

        """
        self.swagger_types = {
            'clipboard_mode': 'str',
            'audio_mode': 'str',
            'cdm_mode': 'str',
            'is_printing_enabled': 'bool',
            'is_pointer_enabled': 'bool',
            'is_keyboard_enabled': 'bool',
            'is_display_enabled': 'bool'
        }

        self.attribute_map = {
            'clipboard_mode': 'clipboardMode',
            'audio_mode': 'audioMode',
            'cdm_mode': 'cdmMode',
            'is_printing_enabled': 'isPrintingEnabled',
            'is_pointer_enabled': 'isPointerEnabled',
            'is_keyboard_enabled': 'isKeyboardEnabled',
            'is_display_enabled': 'isDisplayEnabled'
        }

        self._clipboard_mode = None
        self._audio_mode = None
        self._cdm_mode = None
        self._is_printing_enabled = None
        self._is_pointer_enabled = None
        self._is_keyboard_enabled = None
        self._is_display_enabled = None

    @property
    def clipboard_mode(self):
        """
        **[Required]** Gets the clipboard_mode of this DesktopDevicePolicy.
        The clipboard mode.
        NONE: No access to the local clipboard is permitted.
        TODESKTOP: The clipboard can be used to transfer data to the desktop only.
        FROMDESKTOP: The clipboard can be used to transfer data from the desktop only.
        FULL: The clipboard can be used to transfer data to and from the desktop.

        Allowed values for this property are: "NONE", "TODESKTOP", "FROMDESKTOP", "FULL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The clipboard_mode of this DesktopDevicePolicy.
        :rtype: str
        """
        return self._clipboard_mode

    @clipboard_mode.setter
    def clipboard_mode(self, clipboard_mode):
        """
        Sets the clipboard_mode of this DesktopDevicePolicy.
        The clipboard mode.
        NONE: No access to the local clipboard is permitted.
        TODESKTOP: The clipboard can be used to transfer data to the desktop only.
        FROMDESKTOP: The clipboard can be used to transfer data from the desktop only.
        FULL: The clipboard can be used to transfer data to and from the desktop.


        :param clipboard_mode: The clipboard_mode of this DesktopDevicePolicy.
        :type: str
        """
        allowed_values = ["NONE", "TODESKTOP", "FROMDESKTOP", "FULL"]
        if not value_allowed_none_or_none_sentinel(clipboard_mode, allowed_values):
            clipboard_mode = 'UNKNOWN_ENUM_VALUE'
        self._clipboard_mode = clipboard_mode

    @property
    def audio_mode(self):
        """
        **[Required]** Gets the audio_mode of this DesktopDevicePolicy.
        The audio mode.
        NONE: No access to the local audio devices is permitted.
        TODESKTOP: The user may record audio on their desktop.
        FROMDESKTOP: The user may play audio on their desktop.
        FULL: The user may play and record audio on their desktop.

        Allowed values for this property are: "NONE", "TODESKTOP", "FROMDESKTOP", "FULL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The audio_mode of this DesktopDevicePolicy.
        :rtype: str
        """
        return self._audio_mode

    @audio_mode.setter
    def audio_mode(self, audio_mode):
        """
        Sets the audio_mode of this DesktopDevicePolicy.
        The audio mode.
        NONE: No access to the local audio devices is permitted.
        TODESKTOP: The user may record audio on their desktop.
        FROMDESKTOP: The user may play audio on their desktop.
        FULL: The user may play and record audio on their desktop.


        :param audio_mode: The audio_mode of this DesktopDevicePolicy.
        :type: str
        """
        allowed_values = ["NONE", "TODESKTOP", "FROMDESKTOP", "FULL"]
        if not value_allowed_none_or_none_sentinel(audio_mode, allowed_values):
            audio_mode = 'UNKNOWN_ENUM_VALUE'
        self._audio_mode = audio_mode

    @property
    def cdm_mode(self):
        """
        **[Required]** Gets the cdm_mode of this DesktopDevicePolicy.
        The client local drive access mode.
        NONE: No access to local drives permitted.
        READONLY: The user may read from local drives on their desktop.
        FULL: The user may read from and write to their local drives on their desktop.

        Allowed values for this property are: "NONE", "READONLY", "FULL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The cdm_mode of this DesktopDevicePolicy.
        :rtype: str
        """
        return self._cdm_mode

    @cdm_mode.setter
    def cdm_mode(self, cdm_mode):
        """
        Sets the cdm_mode of this DesktopDevicePolicy.
        The client local drive access mode.
        NONE: No access to local drives permitted.
        READONLY: The user may read from local drives on their desktop.
        FULL: The user may read from and write to their local drives on their desktop.


        :param cdm_mode: The cdm_mode of this DesktopDevicePolicy.
        :type: str
        """
        allowed_values = ["NONE", "READONLY", "FULL"]
        if not value_allowed_none_or_none_sentinel(cdm_mode, allowed_values):
            cdm_mode = 'UNKNOWN_ENUM_VALUE'
        self._cdm_mode = cdm_mode

    @property
    def is_printing_enabled(self):
        """
        **[Required]** Gets the is_printing_enabled of this DesktopDevicePolicy.
        Indicates whether printing is enabled.


        :return: The is_printing_enabled of this DesktopDevicePolicy.
        :rtype: bool
        """
        return self._is_printing_enabled

    @is_printing_enabled.setter
    def is_printing_enabled(self, is_printing_enabled):
        """
        Sets the is_printing_enabled of this DesktopDevicePolicy.
        Indicates whether printing is enabled.


        :param is_printing_enabled: The is_printing_enabled of this DesktopDevicePolicy.
        :type: bool
        """
        self._is_printing_enabled = is_printing_enabled

    @property
    def is_pointer_enabled(self):
        """
        **[Required]** Gets the is_pointer_enabled of this DesktopDevicePolicy.
        Indicates whether the pointer is enabled.


        :return: The is_pointer_enabled of this DesktopDevicePolicy.
        :rtype: bool
        """
        return self._is_pointer_enabled

    @is_pointer_enabled.setter
    def is_pointer_enabled(self, is_pointer_enabled):
        """
        Sets the is_pointer_enabled of this DesktopDevicePolicy.
        Indicates whether the pointer is enabled.


        :param is_pointer_enabled: The is_pointer_enabled of this DesktopDevicePolicy.
        :type: bool
        """
        self._is_pointer_enabled = is_pointer_enabled

    @property
    def is_keyboard_enabled(self):
        """
        **[Required]** Gets the is_keyboard_enabled of this DesktopDevicePolicy.
        Indicates whether the keyboard is enabled.


        :return: The is_keyboard_enabled of this DesktopDevicePolicy.
        :rtype: bool
        """
        return self._is_keyboard_enabled

    @is_keyboard_enabled.setter
    def is_keyboard_enabled(self, is_keyboard_enabled):
        """
        Sets the is_keyboard_enabled of this DesktopDevicePolicy.
        Indicates whether the keyboard is enabled.


        :param is_keyboard_enabled: The is_keyboard_enabled of this DesktopDevicePolicy.
        :type: bool
        """
        self._is_keyboard_enabled = is_keyboard_enabled

    @property
    def is_display_enabled(self):
        """
        **[Required]** Gets the is_display_enabled of this DesktopDevicePolicy.
        Indicates whether the display is enabled.


        :return: The is_display_enabled of this DesktopDevicePolicy.
        :rtype: bool
        """
        return self._is_display_enabled

    @is_display_enabled.setter
    def is_display_enabled(self, is_display_enabled):
        """
        Sets the is_display_enabled of this DesktopDevicePolicy.
        Indicates whether the display is enabled.


        :param is_display_enabled: The is_display_enabled of this DesktopDevicePolicy.
        :type: bool
        """
        self._is_display_enabled = is_display_enabled

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
