# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20210929


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class GoldenGateServiceDetails(object):
    """
    Details about Oracle GoldenGate GGS Deployment.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new GoldenGateServiceDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param ggs_deployment:
            The value to assign to the ggs_deployment property of this GoldenGateServiceDetails.
        :type ggs_deployment: oci.database_migration.models.GgsDeployment

        :param settings:
            The value to assign to the settings property of this GoldenGateServiceDetails.
        :type settings: oci.database_migration.models.GoldenGateSettings

        """
        self.swagger_types = {
            'ggs_deployment': 'GgsDeployment',
            'settings': 'GoldenGateSettings'
        }

        self.attribute_map = {
            'ggs_deployment': 'ggsDeployment',
            'settings': 'settings'
        }

        self._ggs_deployment = None
        self._settings = None

    @property
    def ggs_deployment(self):
        """
        Gets the ggs_deployment of this GoldenGateServiceDetails.

        :return: The ggs_deployment of this GoldenGateServiceDetails.
        :rtype: oci.database_migration.models.GgsDeployment
        """
        return self._ggs_deployment

    @ggs_deployment.setter
    def ggs_deployment(self, ggs_deployment):
        """
        Sets the ggs_deployment of this GoldenGateServiceDetails.

        :param ggs_deployment: The ggs_deployment of this GoldenGateServiceDetails.
        :type: oci.database_migration.models.GgsDeployment
        """
        self._ggs_deployment = ggs_deployment

    @property
    def settings(self):
        """
        Gets the settings of this GoldenGateServiceDetails.

        :return: The settings of this GoldenGateServiceDetails.
        :rtype: oci.database_migration.models.GoldenGateSettings
        """
        return self._settings

    @settings.setter
    def settings(self, settings):
        """
        Sets the settings of this GoldenGateServiceDetails.

        :param settings: The settings of this GoldenGateServiceDetails.
        :type: oci.database_migration.models.GoldenGateSettings
        """
        self._settings = settings

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
