# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DropSqlTuningTaskDetails(object):
    """
    The request to drop a SQL tuning task.
    It takes either credentialDetails or databaseCredential. It's recommended to provide databaseCredential
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DropSqlTuningTaskDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param task_id:
            The value to assign to the task_id property of this DropSqlTuningTaskDetails.
        :type task_id: int

        :param credential_details:
            The value to assign to the credential_details property of this DropSqlTuningTaskDetails.
        :type credential_details: oci.database_management.models.SqlTuningTaskCredentialDetails

        :param database_credential:
            The value to assign to the database_credential property of this DropSqlTuningTaskDetails.
        :type database_credential: oci.database_management.models.DatabaseCredentialDetails

        """
        self.swagger_types = {
            'task_id': 'int',
            'credential_details': 'SqlTuningTaskCredentialDetails',
            'database_credential': 'DatabaseCredentialDetails'
        }

        self.attribute_map = {
            'task_id': 'taskId',
            'credential_details': 'credentialDetails',
            'database_credential': 'databaseCredential'
        }

        self._task_id = None
        self._credential_details = None
        self._database_credential = None

    @property
    def task_id(self):
        """
        **[Required]** Gets the task_id of this DropSqlTuningTaskDetails.
        The identifier of the SQL tuning task being dropped. This is not the `OCID`__.
        It can be retrieved from the following endpoint
        :func:`list_sql_tuning_advisor_tasks`.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :return: The task_id of this DropSqlTuningTaskDetails.
        :rtype: int
        """
        return self._task_id

    @task_id.setter
    def task_id(self, task_id):
        """
        Sets the task_id of this DropSqlTuningTaskDetails.
        The identifier of the SQL tuning task being dropped. This is not the `OCID`__.
        It can be retrieved from the following endpoint
        :func:`list_sql_tuning_advisor_tasks`.

        __ https://docs.cloud.oracle.com/Content/General/Concepts/identifiers.htm


        :param task_id: The task_id of this DropSqlTuningTaskDetails.
        :type: int
        """
        self._task_id = task_id

    @property
    def credential_details(self):
        """
        Gets the credential_details of this DropSqlTuningTaskDetails.

        :return: The credential_details of this DropSqlTuningTaskDetails.
        :rtype: oci.database_management.models.SqlTuningTaskCredentialDetails
        """
        return self._credential_details

    @credential_details.setter
    def credential_details(self, credential_details):
        """
        Sets the credential_details of this DropSqlTuningTaskDetails.

        :param credential_details: The credential_details of this DropSqlTuningTaskDetails.
        :type: oci.database_management.models.SqlTuningTaskCredentialDetails
        """
        self._credential_details = credential_details

    @property
    def database_credential(self):
        """
        Gets the database_credential of this DropSqlTuningTaskDetails.

        :return: The database_credential of this DropSqlTuningTaskDetails.
        :rtype: oci.database_management.models.DatabaseCredentialDetails
        """
        return self._database_credential

    @database_credential.setter
    def database_credential(self, database_credential):
        """
        Sets the database_credential of this DropSqlTuningTaskDetails.

        :param database_credential: The database_credential of this DropSqlTuningTaskDetails.
        :type: oci.database_management.models.DatabaseCredentialDetails
        """
        self._database_credential = database_credential

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
