# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseCredentialDetails(object):
    """
    The credential to connect to the database to perform tablespace administration tasks.
    """

    #: A constant which can be used with the credential_type property of a DatabaseCredentialDetails.
    #: This constant has a value of "SECRET"
    CREDENTIAL_TYPE_SECRET = "SECRET"

    #: A constant which can be used with the credential_type property of a DatabaseCredentialDetails.
    #: This constant has a value of "PASSWORD"
    CREDENTIAL_TYPE_PASSWORD = "PASSWORD"

    #: A constant which can be used with the credential_type property of a DatabaseCredentialDetails.
    #: This constant has a value of "NAMED_CREDENTIAL"
    CREDENTIAL_TYPE_NAMED_CREDENTIAL = "NAMED_CREDENTIAL"

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseCredentialDetails object with values from keyword arguments. This class has the following subclasses and if you are using this class as input
        to a service operations then you should favor using a subclass over the base class:

        * :class:`~oci.database_management.models.DatabaseSecretCredentialDetails`
        * :class:`~oci.database_management.models.DatabaseNamedCredentialDetails`
        * :class:`~oci.database_management.models.DatabasePasswordCredentialDetails`

        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param credential_type:
            The value to assign to the credential_type property of this DatabaseCredentialDetails.
            Allowed values for this property are: "SECRET", "PASSWORD", "NAMED_CREDENTIAL", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type credential_type: str

        """
        self.swagger_types = {
            'credential_type': 'str'
        }

        self.attribute_map = {
            'credential_type': 'credentialType'
        }

        self._credential_type = None

    @staticmethod
    def get_subtype(object_dictionary):
        """
        Given the hash representation of a subtype of this class,
        use the info in the hash to return the class of the subtype.
        """
        type = object_dictionary['credentialType']

        if type == 'SECRET':
            return 'DatabaseSecretCredentialDetails'

        if type == 'NAMED_CREDENTIAL':
            return 'DatabaseNamedCredentialDetails'

        if type == 'PASSWORD':
            return 'DatabasePasswordCredentialDetails'
        else:
            return 'DatabaseCredentialDetails'

    @property
    def credential_type(self):
        """
        **[Required]** Gets the credential_type of this DatabaseCredentialDetails.
        The type of the credential for tablespace administration tasks.

        Allowed values for this property are: "SECRET", "PASSWORD", "NAMED_CREDENTIAL", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The credential_type of this DatabaseCredentialDetails.
        :rtype: str
        """
        return self._credential_type

    @credential_type.setter
    def credential_type(self, credential_type):
        """
        Sets the credential_type of this DatabaseCredentialDetails.
        The type of the credential for tablespace administration tasks.


        :param credential_type: The credential_type of this DatabaseCredentialDetails.
        :type: str
        """
        allowed_values = ["SECRET", "PASSWORD", "NAMED_CREDENTIAL"]
        if not value_allowed_none_or_none_sentinel(credential_type, allowed_values):
            credential_type = 'UNKNOWN_ENUM_VALUE'
        self._credential_type = credential_type

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
