# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20201101


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DatabaseConnectionDetails(object):
    """
    The connection details required to connect to the database.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DatabaseConnectionDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param connection_string:
            The value to assign to the connection_string property of this DatabaseConnectionDetails.
        :type connection_string: oci.database_management.models.DatabaseConnectionStringDetails

        :param connection_credentials:
            The value to assign to the connection_credentials property of this DatabaseConnectionDetails.
        :type connection_credentials: oci.database_management.models.DatabaseConnectionCredentials

        """
        self.swagger_types = {
            'connection_string': 'DatabaseConnectionStringDetails',
            'connection_credentials': 'DatabaseConnectionCredentials'
        }

        self.attribute_map = {
            'connection_string': 'connectionString',
            'connection_credentials': 'connectionCredentials'
        }

        self._connection_string = None
        self._connection_credentials = None

    @property
    def connection_string(self):
        """
        **[Required]** Gets the connection_string of this DatabaseConnectionDetails.

        :return: The connection_string of this DatabaseConnectionDetails.
        :rtype: oci.database_management.models.DatabaseConnectionStringDetails
        """
        return self._connection_string

    @connection_string.setter
    def connection_string(self, connection_string):
        """
        Sets the connection_string of this DatabaseConnectionDetails.

        :param connection_string: The connection_string of this DatabaseConnectionDetails.
        :type: oci.database_management.models.DatabaseConnectionStringDetails
        """
        self._connection_string = connection_string

    @property
    def connection_credentials(self):
        """
        **[Required]** Gets the connection_credentials of this DatabaseConnectionDetails.

        :return: The connection_credentials of this DatabaseConnectionDetails.
        :rtype: oci.database_management.models.DatabaseConnectionCredentials
        """
        return self._connection_credentials

    @connection_credentials.setter
    def connection_credentials(self, connection_credentials):
        """
        Sets the connection_credentials of this DatabaseConnectionDetails.

        :param connection_credentials: The connection_credentials of this DatabaseConnectionDetails.
        :type: oci.database_management.models.DatabaseConnectionCredentials
        """
        self._connection_credentials = connection_credentials

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
