# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20190101

from .storage_mount_configuration_details import StorageMountConfigurationDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ObjectStorageMountConfigurationDetails(StorageMountConfigurationDetails):
    """
    The Object Storage Configuration Details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ObjectStorageMountConfigurationDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.data_science.models.ObjectStorageMountConfigurationDetails.storage_type` attribute
        of this class is ``OBJECT_STORAGE`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param storage_type:
            The value to assign to the storage_type property of this ObjectStorageMountConfigurationDetails.
            Allowed values for this property are: "FILE_STORAGE", "OBJECT_STORAGE"
        :type storage_type: str

        :param destination_directory_name:
            The value to assign to the destination_directory_name property of this ObjectStorageMountConfigurationDetails.
        :type destination_directory_name: str

        :param destination_path:
            The value to assign to the destination_path property of this ObjectStorageMountConfigurationDetails.
        :type destination_path: str

        :param namespace:
            The value to assign to the namespace property of this ObjectStorageMountConfigurationDetails.
        :type namespace: str

        :param bucket:
            The value to assign to the bucket property of this ObjectStorageMountConfigurationDetails.
        :type bucket: str

        :param prefix:
            The value to assign to the prefix property of this ObjectStorageMountConfigurationDetails.
        :type prefix: str

        """
        self.swagger_types = {
            'storage_type': 'str',
            'destination_directory_name': 'str',
            'destination_path': 'str',
            'namespace': 'str',
            'bucket': 'str',
            'prefix': 'str'
        }

        self.attribute_map = {
            'storage_type': 'storageType',
            'destination_directory_name': 'destinationDirectoryName',
            'destination_path': 'destinationPath',
            'namespace': 'namespace',
            'bucket': 'bucket',
            'prefix': 'prefix'
        }

        self._storage_type = None
        self._destination_directory_name = None
        self._destination_path = None
        self._namespace = None
        self._bucket = None
        self._prefix = None
        self._storage_type = 'OBJECT_STORAGE'

    @property
    def namespace(self):
        """
        **[Required]** Gets the namespace of this ObjectStorageMountConfigurationDetails.
        The object storage namespace


        :return: The namespace of this ObjectStorageMountConfigurationDetails.
        :rtype: str
        """
        return self._namespace

    @namespace.setter
    def namespace(self, namespace):
        """
        Sets the namespace of this ObjectStorageMountConfigurationDetails.
        The object storage namespace


        :param namespace: The namespace of this ObjectStorageMountConfigurationDetails.
        :type: str
        """
        self._namespace = namespace

    @property
    def bucket(self):
        """
        **[Required]** Gets the bucket of this ObjectStorageMountConfigurationDetails.
        The object storage bucket


        :return: The bucket of this ObjectStorageMountConfigurationDetails.
        :rtype: str
        """
        return self._bucket

    @bucket.setter
    def bucket(self, bucket):
        """
        Sets the bucket of this ObjectStorageMountConfigurationDetails.
        The object storage bucket


        :param bucket: The bucket of this ObjectStorageMountConfigurationDetails.
        :type: str
        """
        self._bucket = bucket

    @property
    def prefix(self):
        """
        Gets the prefix of this ObjectStorageMountConfigurationDetails.
        Prefix in the bucket to mount


        :return: The prefix of this ObjectStorageMountConfigurationDetails.
        :rtype: str
        """
        return self._prefix

    @prefix.setter
    def prefix(self, prefix):
        """
        Sets the prefix of this ObjectStorageMountConfigurationDetails.
        Prefix in the bucket to mount


        :param prefix: The prefix of this ObjectStorageMountConfigurationDetails.
        :type: str
        """
        self._prefix = prefix

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
