# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class IpInventoryVcnOverlapSummary(object):
    """
    Provides the VCN overlap details.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new IpInventoryVcnOverlapSummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param overlapping_vcn_id:
            The value to assign to the overlapping_vcn_id property of this IpInventoryVcnOverlapSummary.
        :type overlapping_vcn_id: str

        :param overlapping_vcn_name:
            The value to assign to the overlapping_vcn_name property of this IpInventoryVcnOverlapSummary.
        :type overlapping_vcn_name: str

        :param overlapping_cidr:
            The value to assign to the overlapping_cidr property of this IpInventoryVcnOverlapSummary.
        :type overlapping_cidr: str

        :param cidr:
            The value to assign to the cidr property of this IpInventoryVcnOverlapSummary.
        :type cidr: str

        """
        self.swagger_types = {
            'overlapping_vcn_id': 'str',
            'overlapping_vcn_name': 'str',
            'overlapping_cidr': 'str',
            'cidr': 'str'
        }

        self.attribute_map = {
            'overlapping_vcn_id': 'overlappingVcnId',
            'overlapping_vcn_name': 'overlappingVcnName',
            'overlapping_cidr': 'overlappingCidr',
            'cidr': 'cidr'
        }

        self._overlapping_vcn_id = None
        self._overlapping_vcn_name = None
        self._overlapping_cidr = None
        self._cidr = None

    @property
    def overlapping_vcn_id(self):
        """
        Gets the overlapping_vcn_id of this IpInventoryVcnOverlapSummary.
        The `OCID`__ of the VCN .

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The overlapping_vcn_id of this IpInventoryVcnOverlapSummary.
        :rtype: str
        """
        return self._overlapping_vcn_id

    @overlapping_vcn_id.setter
    def overlapping_vcn_id(self, overlapping_vcn_id):
        """
        Sets the overlapping_vcn_id of this IpInventoryVcnOverlapSummary.
        The `OCID`__ of the VCN .

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param overlapping_vcn_id: The overlapping_vcn_id of this IpInventoryVcnOverlapSummary.
        :type: str
        """
        self._overlapping_vcn_id = overlapping_vcn_id

    @property
    def overlapping_vcn_name(self):
        """
        Gets the overlapping_vcn_name of this IpInventoryVcnOverlapSummary.
        Name of the overlapping VCN.


        :return: The overlapping_vcn_name of this IpInventoryVcnOverlapSummary.
        :rtype: str
        """
        return self._overlapping_vcn_name

    @overlapping_vcn_name.setter
    def overlapping_vcn_name(self, overlapping_vcn_name):
        """
        Sets the overlapping_vcn_name of this IpInventoryVcnOverlapSummary.
        Name of the overlapping VCN.


        :param overlapping_vcn_name: The overlapping_vcn_name of this IpInventoryVcnOverlapSummary.
        :type: str
        """
        self._overlapping_vcn_name = overlapping_vcn_name

    @property
    def overlapping_cidr(self):
        """
        Gets the overlapping_cidr of this IpInventoryVcnOverlapSummary.
        The overlapping CIDR prefix.


        :return: The overlapping_cidr of this IpInventoryVcnOverlapSummary.
        :rtype: str
        """
        return self._overlapping_cidr

    @overlapping_cidr.setter
    def overlapping_cidr(self, overlapping_cidr):
        """
        Sets the overlapping_cidr of this IpInventoryVcnOverlapSummary.
        The overlapping CIDR prefix.


        :param overlapping_cidr: The overlapping_cidr of this IpInventoryVcnOverlapSummary.
        :type: str
        """
        self._overlapping_cidr = overlapping_cidr

    @property
    def cidr(self):
        """
        Gets the cidr of this IpInventoryVcnOverlapSummary.
        CIDR prefix of the VCN.


        :return: The cidr of this IpInventoryVcnOverlapSummary.
        :rtype: str
        """
        return self._cidr

    @cidr.setter
    def cidr(self, cidr):
        """
        Sets the cidr of this IpInventoryVcnOverlapSummary.
        CIDR prefix of the VCN.


        :param cidr: The cidr of this IpInventoryVcnOverlapSummary.
        :type: str
        """
        self._cidr = cidr

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
