# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class FlowLogCaptureFilterRuleDetails(object):
    """
    The set of rules governing what traffic the VCN flow log collects.
    """

    #: A constant which can be used with the flow_log_type property of a FlowLogCaptureFilterRuleDetails.
    #: This constant has a value of "ALL"
    FLOW_LOG_TYPE_ALL = "ALL"

    #: A constant which can be used with the flow_log_type property of a FlowLogCaptureFilterRuleDetails.
    #: This constant has a value of "REJECT"
    FLOW_LOG_TYPE_REJECT = "REJECT"

    #: A constant which can be used with the flow_log_type property of a FlowLogCaptureFilterRuleDetails.
    #: This constant has a value of "ACCEPT"
    FLOW_LOG_TYPE_ACCEPT = "ACCEPT"

    #: A constant which can be used with the rule_action property of a FlowLogCaptureFilterRuleDetails.
    #: This constant has a value of "INCLUDE"
    RULE_ACTION_INCLUDE = "INCLUDE"

    #: A constant which can be used with the rule_action property of a FlowLogCaptureFilterRuleDetails.
    #: This constant has a value of "EXCLUDE"
    RULE_ACTION_EXCLUDE = "EXCLUDE"

    def __init__(self, **kwargs):
        """
        Initializes a new FlowLogCaptureFilterRuleDetails object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param is_enabled:
            The value to assign to the is_enabled property of this FlowLogCaptureFilterRuleDetails.
        :type is_enabled: bool

        :param priority:
            The value to assign to the priority property of this FlowLogCaptureFilterRuleDetails.
        :type priority: int

        :param sampling_rate:
            The value to assign to the sampling_rate property of this FlowLogCaptureFilterRuleDetails.
        :type sampling_rate: int

        :param source_cidr:
            The value to assign to the source_cidr property of this FlowLogCaptureFilterRuleDetails.
        :type source_cidr: str

        :param destination_cidr:
            The value to assign to the destination_cidr property of this FlowLogCaptureFilterRuleDetails.
        :type destination_cidr: str

        :param protocol:
            The value to assign to the protocol property of this FlowLogCaptureFilterRuleDetails.
        :type protocol: str

        :param icmp_options:
            The value to assign to the icmp_options property of this FlowLogCaptureFilterRuleDetails.
        :type icmp_options: oci.core.models.IcmpOptions

        :param tcp_options:
            The value to assign to the tcp_options property of this FlowLogCaptureFilterRuleDetails.
        :type tcp_options: oci.core.models.TcpOptions

        :param udp_options:
            The value to assign to the udp_options property of this FlowLogCaptureFilterRuleDetails.
        :type udp_options: oci.core.models.UdpOptions

        :param flow_log_type:
            The value to assign to the flow_log_type property of this FlowLogCaptureFilterRuleDetails.
            Allowed values for this property are: "ALL", "REJECT", "ACCEPT", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type flow_log_type: str

        :param rule_action:
            The value to assign to the rule_action property of this FlowLogCaptureFilterRuleDetails.
            Allowed values for this property are: "INCLUDE", "EXCLUDE", 'UNKNOWN_ENUM_VALUE'.
            Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.
        :type rule_action: str

        """
        self.swagger_types = {
            'is_enabled': 'bool',
            'priority': 'int',
            'sampling_rate': 'int',
            'source_cidr': 'str',
            'destination_cidr': 'str',
            'protocol': 'str',
            'icmp_options': 'IcmpOptions',
            'tcp_options': 'TcpOptions',
            'udp_options': 'UdpOptions',
            'flow_log_type': 'str',
            'rule_action': 'str'
        }

        self.attribute_map = {
            'is_enabled': 'isEnabled',
            'priority': 'priority',
            'sampling_rate': 'samplingRate',
            'source_cidr': 'sourceCidr',
            'destination_cidr': 'destinationCidr',
            'protocol': 'protocol',
            'icmp_options': 'icmpOptions',
            'tcp_options': 'tcpOptions',
            'udp_options': 'udpOptions',
            'flow_log_type': 'flowLogType',
            'rule_action': 'ruleAction'
        }

        self._is_enabled = None
        self._priority = None
        self._sampling_rate = None
        self._source_cidr = None
        self._destination_cidr = None
        self._protocol = None
        self._icmp_options = None
        self._tcp_options = None
        self._udp_options = None
        self._flow_log_type = None
        self._rule_action = None

    @property
    def is_enabled(self):
        """
        Gets the is_enabled of this FlowLogCaptureFilterRuleDetails.
        Indicates whether a VCN flow log capture filter rule is enabled.


        :return: The is_enabled of this FlowLogCaptureFilterRuleDetails.
        :rtype: bool
        """
        return self._is_enabled

    @is_enabled.setter
    def is_enabled(self, is_enabled):
        """
        Sets the is_enabled of this FlowLogCaptureFilterRuleDetails.
        Indicates whether a VCN flow log capture filter rule is enabled.


        :param is_enabled: The is_enabled of this FlowLogCaptureFilterRuleDetails.
        :type: bool
        """
        self._is_enabled = is_enabled

    @property
    def priority(self):
        """
        Gets the priority of this FlowLogCaptureFilterRuleDetails.
        A lower number indicates a higher priority, range 0-9. Each rule must have a distinct priority.


        :return: The priority of this FlowLogCaptureFilterRuleDetails.
        :rtype: int
        """
        return self._priority

    @priority.setter
    def priority(self, priority):
        """
        Sets the priority of this FlowLogCaptureFilterRuleDetails.
        A lower number indicates a higher priority, range 0-9. Each rule must have a distinct priority.


        :param priority: The priority of this FlowLogCaptureFilterRuleDetails.
        :type: int
        """
        self._priority = priority

    @property
    def sampling_rate(self):
        """
        Gets the sampling_rate of this FlowLogCaptureFilterRuleDetails.
        Sampling interval as `1` of `X`, where `X` is an integer not greater than `100000`.


        :return: The sampling_rate of this FlowLogCaptureFilterRuleDetails.
        :rtype: int
        """
        return self._sampling_rate

    @sampling_rate.setter
    def sampling_rate(self, sampling_rate):
        """
        Sets the sampling_rate of this FlowLogCaptureFilterRuleDetails.
        Sampling interval as `1` of `X`, where `X` is an integer not greater than `100000`.


        :param sampling_rate: The sampling_rate of this FlowLogCaptureFilterRuleDetails.
        :type: int
        """
        self._sampling_rate = sampling_rate

    @property
    def source_cidr(self):
        """
        Gets the source_cidr of this FlowLogCaptureFilterRuleDetails.
        Traffic from this CIDR will be captured in the VCN flow log.


        :return: The source_cidr of this FlowLogCaptureFilterRuleDetails.
        :rtype: str
        """
        return self._source_cidr

    @source_cidr.setter
    def source_cidr(self, source_cidr):
        """
        Sets the source_cidr of this FlowLogCaptureFilterRuleDetails.
        Traffic from this CIDR will be captured in the VCN flow log.


        :param source_cidr: The source_cidr of this FlowLogCaptureFilterRuleDetails.
        :type: str
        """
        self._source_cidr = source_cidr

    @property
    def destination_cidr(self):
        """
        Gets the destination_cidr of this FlowLogCaptureFilterRuleDetails.
        Traffic to this CIDR will be captured in the VCN flow log.


        :return: The destination_cidr of this FlowLogCaptureFilterRuleDetails.
        :rtype: str
        """
        return self._destination_cidr

    @destination_cidr.setter
    def destination_cidr(self, destination_cidr):
        """
        Sets the destination_cidr of this FlowLogCaptureFilterRuleDetails.
        Traffic to this CIDR will be captured in the VCN flow log.


        :param destination_cidr: The destination_cidr of this FlowLogCaptureFilterRuleDetails.
        :type: str
        """
        self._destination_cidr = destination_cidr

    @property
    def protocol(self):
        """
        Gets the protocol of this FlowLogCaptureFilterRuleDetails.
        The transport protocol the filter uses.


        :return: The protocol of this FlowLogCaptureFilterRuleDetails.
        :rtype: str
        """
        return self._protocol

    @protocol.setter
    def protocol(self, protocol):
        """
        Sets the protocol of this FlowLogCaptureFilterRuleDetails.
        The transport protocol the filter uses.


        :param protocol: The protocol of this FlowLogCaptureFilterRuleDetails.
        :type: str
        """
        self._protocol = protocol

    @property
    def icmp_options(self):
        """
        Gets the icmp_options of this FlowLogCaptureFilterRuleDetails.

        :return: The icmp_options of this FlowLogCaptureFilterRuleDetails.
        :rtype: oci.core.models.IcmpOptions
        """
        return self._icmp_options

    @icmp_options.setter
    def icmp_options(self, icmp_options):
        """
        Sets the icmp_options of this FlowLogCaptureFilterRuleDetails.

        :param icmp_options: The icmp_options of this FlowLogCaptureFilterRuleDetails.
        :type: oci.core.models.IcmpOptions
        """
        self._icmp_options = icmp_options

    @property
    def tcp_options(self):
        """
        Gets the tcp_options of this FlowLogCaptureFilterRuleDetails.

        :return: The tcp_options of this FlowLogCaptureFilterRuleDetails.
        :rtype: oci.core.models.TcpOptions
        """
        return self._tcp_options

    @tcp_options.setter
    def tcp_options(self, tcp_options):
        """
        Sets the tcp_options of this FlowLogCaptureFilterRuleDetails.

        :param tcp_options: The tcp_options of this FlowLogCaptureFilterRuleDetails.
        :type: oci.core.models.TcpOptions
        """
        self._tcp_options = tcp_options

    @property
    def udp_options(self):
        """
        Gets the udp_options of this FlowLogCaptureFilterRuleDetails.

        :return: The udp_options of this FlowLogCaptureFilterRuleDetails.
        :rtype: oci.core.models.UdpOptions
        """
        return self._udp_options

    @udp_options.setter
    def udp_options(self, udp_options):
        """
        Sets the udp_options of this FlowLogCaptureFilterRuleDetails.

        :param udp_options: The udp_options of this FlowLogCaptureFilterRuleDetails.
        :type: oci.core.models.UdpOptions
        """
        self._udp_options = udp_options

    @property
    def flow_log_type(self):
        """
        Gets the flow_log_type of this FlowLogCaptureFilterRuleDetails.
        Type or types of VCN flow logs to store. `ALL` includes records for both accepted traffic and
        rejected traffic.

        Allowed values for this property are: "ALL", "REJECT", "ACCEPT", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The flow_log_type of this FlowLogCaptureFilterRuleDetails.
        :rtype: str
        """
        return self._flow_log_type

    @flow_log_type.setter
    def flow_log_type(self, flow_log_type):
        """
        Sets the flow_log_type of this FlowLogCaptureFilterRuleDetails.
        Type or types of VCN flow logs to store. `ALL` includes records for both accepted traffic and
        rejected traffic.


        :param flow_log_type: The flow_log_type of this FlowLogCaptureFilterRuleDetails.
        :type: str
        """
        allowed_values = ["ALL", "REJECT", "ACCEPT"]
        if not value_allowed_none_or_none_sentinel(flow_log_type, allowed_values):
            flow_log_type = 'UNKNOWN_ENUM_VALUE'
        self._flow_log_type = flow_log_type

    @property
    def rule_action(self):
        """
        Gets the rule_action of this FlowLogCaptureFilterRuleDetails.
        Include or exclude a `ruleAction` object.

        Allowed values for this property are: "INCLUDE", "EXCLUDE", 'UNKNOWN_ENUM_VALUE'.
        Any unrecognized values returned by a service will be mapped to 'UNKNOWN_ENUM_VALUE'.


        :return: The rule_action of this FlowLogCaptureFilterRuleDetails.
        :rtype: str
        """
        return self._rule_action

    @rule_action.setter
    def rule_action(self, rule_action):
        """
        Sets the rule_action of this FlowLogCaptureFilterRuleDetails.
        Include or exclude a `ruleAction` object.


        :param rule_action: The rule_action of this FlowLogCaptureFilterRuleDetails.
        :type: str
        """
        allowed_values = ["INCLUDE", "EXCLUDE"]
        if not value_allowed_none_or_none_sentinel(rule_action, allowed_values):
            rule_action = 'UNKNOWN_ENUM_VALUE'
        self._rule_action = rule_action

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
