# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20160918


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ComputeBareMetalHost(object):
    """
    A compute bare metal host.
    """

    #: A constant which can be used with the lifecycle_details property of a ComputeBareMetalHost.
    #: This constant has a value of "AVAILABLE"
    LIFECYCLE_DETAILS_AVAILABLE = "AVAILABLE"

    #: A constant which can be used with the lifecycle_details property of a ComputeBareMetalHost.
    #: This constant has a value of "DEGRADED"
    LIFECYCLE_DETAILS_DEGRADED = "DEGRADED"

    #: A constant which can be used with the lifecycle_details property of a ComputeBareMetalHost.
    #: This constant has a value of "UNAVAILABLE"
    LIFECYCLE_DETAILS_UNAVAILABLE = "UNAVAILABLE"

    #: A constant which can be used with the lifecycle_state property of a ComputeBareMetalHost.
    #: This constant has a value of "ACTIVE"
    LIFECYCLE_STATE_ACTIVE = "ACTIVE"

    #: A constant which can be used with the lifecycle_state property of a ComputeBareMetalHost.
    #: This constant has a value of "INACTIVE"
    LIFECYCLE_STATE_INACTIVE = "INACTIVE"

    def __init__(self, **kwargs):
        """
        Initializes a new ComputeBareMetalHost object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param compute_capacity_topology_id:
            The value to assign to the compute_capacity_topology_id property of this ComputeBareMetalHost.
        :type compute_capacity_topology_id: str

        :param compute_hpc_island_id:
            The value to assign to the compute_hpc_island_id property of this ComputeBareMetalHost.
        :type compute_hpc_island_id: str

        :param compute_local_block_id:
            The value to assign to the compute_local_block_id property of this ComputeBareMetalHost.
        :type compute_local_block_id: str

        :param compute_network_block_id:
            The value to assign to the compute_network_block_id property of this ComputeBareMetalHost.
        :type compute_network_block_id: str

        :param id:
            The value to assign to the id property of this ComputeBareMetalHost.
        :type id: str

        :param instance_id:
            The value to assign to the instance_id property of this ComputeBareMetalHost.
        :type instance_id: str

        :param instance_shape:
            The value to assign to the instance_shape property of this ComputeBareMetalHost.
        :type instance_shape: str

        :param lifecycle_details:
            The value to assign to the lifecycle_details property of this ComputeBareMetalHost.
            Allowed values for this property are: "AVAILABLE", "DEGRADED", "UNAVAILABLE"
        :type lifecycle_details: str

        :param lifecycle_state:
            The value to assign to the lifecycle_state property of this ComputeBareMetalHost.
            Allowed values for this property are: "ACTIVE", "INACTIVE"
        :type lifecycle_state: str

        :param time_created:
            The value to assign to the time_created property of this ComputeBareMetalHost.
        :type time_created: datetime

        :param time_updated:
            The value to assign to the time_updated property of this ComputeBareMetalHost.
        :type time_updated: datetime

        """
        self.swagger_types = {
            'compute_capacity_topology_id': 'str',
            'compute_hpc_island_id': 'str',
            'compute_local_block_id': 'str',
            'compute_network_block_id': 'str',
            'id': 'str',
            'instance_id': 'str',
            'instance_shape': 'str',
            'lifecycle_details': 'str',
            'lifecycle_state': 'str',
            'time_created': 'datetime',
            'time_updated': 'datetime'
        }

        self.attribute_map = {
            'compute_capacity_topology_id': 'computeCapacityTopologyId',
            'compute_hpc_island_id': 'computeHpcIslandId',
            'compute_local_block_id': 'computeLocalBlockId',
            'compute_network_block_id': 'computeNetworkBlockId',
            'id': 'id',
            'instance_id': 'instanceId',
            'instance_shape': 'instanceShape',
            'lifecycle_details': 'lifecycleDetails',
            'lifecycle_state': 'lifecycleState',
            'time_created': 'timeCreated',
            'time_updated': 'timeUpdated'
        }

        self._compute_capacity_topology_id = None
        self._compute_hpc_island_id = None
        self._compute_local_block_id = None
        self._compute_network_block_id = None
        self._id = None
        self._instance_id = None
        self._instance_shape = None
        self._lifecycle_details = None
        self._lifecycle_state = None
        self._time_created = None
        self._time_updated = None

    @property
    def compute_capacity_topology_id(self):
        """
        **[Required]** Gets the compute_capacity_topology_id of this ComputeBareMetalHost.
        The `OCID`__ of the compute capacity topology.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compute_capacity_topology_id of this ComputeBareMetalHost.
        :rtype: str
        """
        return self._compute_capacity_topology_id

    @compute_capacity_topology_id.setter
    def compute_capacity_topology_id(self, compute_capacity_topology_id):
        """
        Sets the compute_capacity_topology_id of this ComputeBareMetalHost.
        The `OCID`__ of the compute capacity topology.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compute_capacity_topology_id: The compute_capacity_topology_id of this ComputeBareMetalHost.
        :type: str
        """
        self._compute_capacity_topology_id = compute_capacity_topology_id

    @property
    def compute_hpc_island_id(self):
        """
        Gets the compute_hpc_island_id of this ComputeBareMetalHost.
        The `OCID`__ of the compute HPC island.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compute_hpc_island_id of this ComputeBareMetalHost.
        :rtype: str
        """
        return self._compute_hpc_island_id

    @compute_hpc_island_id.setter
    def compute_hpc_island_id(self, compute_hpc_island_id):
        """
        Sets the compute_hpc_island_id of this ComputeBareMetalHost.
        The `OCID`__ of the compute HPC island.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compute_hpc_island_id: The compute_hpc_island_id of this ComputeBareMetalHost.
        :type: str
        """
        self._compute_hpc_island_id = compute_hpc_island_id

    @property
    def compute_local_block_id(self):
        """
        Gets the compute_local_block_id of this ComputeBareMetalHost.
        The `OCID`__ of the compute local block.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compute_local_block_id of this ComputeBareMetalHost.
        :rtype: str
        """
        return self._compute_local_block_id

    @compute_local_block_id.setter
    def compute_local_block_id(self, compute_local_block_id):
        """
        Sets the compute_local_block_id of this ComputeBareMetalHost.
        The `OCID`__ of the compute local block.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compute_local_block_id: The compute_local_block_id of this ComputeBareMetalHost.
        :type: str
        """
        self._compute_local_block_id = compute_local_block_id

    @property
    def compute_network_block_id(self):
        """
        Gets the compute_network_block_id of this ComputeBareMetalHost.
        The `OCID`__ of the compute network block.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The compute_network_block_id of this ComputeBareMetalHost.
        :rtype: str
        """
        return self._compute_network_block_id

    @compute_network_block_id.setter
    def compute_network_block_id(self, compute_network_block_id):
        """
        Sets the compute_network_block_id of this ComputeBareMetalHost.
        The `OCID`__ of the compute network block.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param compute_network_block_id: The compute_network_block_id of this ComputeBareMetalHost.
        :type: str
        """
        self._compute_network_block_id = compute_network_block_id

    @property
    def id(self):
        """
        **[Required]** Gets the id of this ComputeBareMetalHost.
        The `OCID`__ of the compute bare metal host.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The id of this ComputeBareMetalHost.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """
        Sets the id of this ComputeBareMetalHost.
        The `OCID`__ of the compute bare metal host.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param id: The id of this ComputeBareMetalHost.
        :type: str
        """
        self._id = id

    @property
    def instance_id(self):
        """
        Gets the instance_id of this ComputeBareMetalHost.
        The `OCID`__ of the compute instance that runs on the compute bare metal host.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :return: The instance_id of this ComputeBareMetalHost.
        :rtype: str
        """
        return self._instance_id

    @instance_id.setter
    def instance_id(self, instance_id):
        """
        Sets the instance_id of this ComputeBareMetalHost.
        The `OCID`__ of the compute instance that runs on the compute bare metal host.

        __ https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm


        :param instance_id: The instance_id of this ComputeBareMetalHost.
        :type: str
        """
        self._instance_id = instance_id

    @property
    def instance_shape(self):
        """
        **[Required]** Gets the instance_shape of this ComputeBareMetalHost.
        The shape of the compute instance that runs on the compute bare metal host.


        :return: The instance_shape of this ComputeBareMetalHost.
        :rtype: str
        """
        return self._instance_shape

    @instance_shape.setter
    def instance_shape(self, instance_shape):
        """
        Sets the instance_shape of this ComputeBareMetalHost.
        The shape of the compute instance that runs on the compute bare metal host.


        :param instance_shape: The instance_shape of this ComputeBareMetalHost.
        :type: str
        """
        self._instance_shape = instance_shape

    @property
    def lifecycle_details(self):
        """
        Gets the lifecycle_details of this ComputeBareMetalHost.
        The lifecycle state details of the compute bare metal host.

        Allowed values for this property are: "AVAILABLE", "DEGRADED", "UNAVAILABLE"


        :return: The lifecycle_details of this ComputeBareMetalHost.
        :rtype: str
        """
        return self._lifecycle_details

    @lifecycle_details.setter
    def lifecycle_details(self, lifecycle_details):
        """
        Sets the lifecycle_details of this ComputeBareMetalHost.
        The lifecycle state details of the compute bare metal host.


        :param lifecycle_details: The lifecycle_details of this ComputeBareMetalHost.
        :type: str
        """
        allowed_values = ["AVAILABLE", "DEGRADED", "UNAVAILABLE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_details, allowed_values):
            raise ValueError(
                f"Invalid value for `lifecycle_details`, must be None or one of {allowed_values}"
            )
        self._lifecycle_details = lifecycle_details

    @property
    def lifecycle_state(self):
        """
        **[Required]** Gets the lifecycle_state of this ComputeBareMetalHost.
        The current state of the compute bare metal host.

        Allowed values for this property are: "ACTIVE", "INACTIVE"


        :return: The lifecycle_state of this ComputeBareMetalHost.
        :rtype: str
        """
        return self._lifecycle_state

    @lifecycle_state.setter
    def lifecycle_state(self, lifecycle_state):
        """
        Sets the lifecycle_state of this ComputeBareMetalHost.
        The current state of the compute bare metal host.


        :param lifecycle_state: The lifecycle_state of this ComputeBareMetalHost.
        :type: str
        """
        allowed_values = ["ACTIVE", "INACTIVE"]
        if not value_allowed_none_or_none_sentinel(lifecycle_state, allowed_values):
            raise ValueError(
                f"Invalid value for `lifecycle_state`, must be None or one of {allowed_values}"
            )
        self._lifecycle_state = lifecycle_state

    @property
    def time_created(self):
        """
        **[Required]** Gets the time_created of this ComputeBareMetalHost.
        The date and time that the compute bare metal host was created, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_created of this ComputeBareMetalHost.
        :rtype: datetime
        """
        return self._time_created

    @time_created.setter
    def time_created(self, time_created):
        """
        Sets the time_created of this ComputeBareMetalHost.
        The date and time that the compute bare metal host was created, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_created: The time_created of this ComputeBareMetalHost.
        :type: datetime
        """
        self._time_created = time_created

    @property
    def time_updated(self):
        """
        **[Required]** Gets the time_updated of this ComputeBareMetalHost.
        The date and time that the compute bare metal host was updated, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :return: The time_updated of this ComputeBareMetalHost.
        :rtype: datetime
        """
        return self._time_updated

    @time_updated.setter
    def time_updated(self, time_updated):
        """
        Sets the time_updated of this ComputeBareMetalHost.
        The date and time that the compute bare metal host was updated, in the format defined by `RFC3339`__.

        Example: `2016-08-25T21:10:29.600Z`

        __ https://tools.ietf.org/html/rfc3339


        :param time_updated: The time_updated of this ComputeBareMetalHost.
        :type: datetime
        """
        self._time_updated = time_updated

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
