# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200131

from .data_source_details import DataSourceDetails
from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ScheduledQueryDataSourceObjDetails(DataSourceDetails):
    """
    The information about new schedule Query of type DataSource.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ScheduledQueryDataSourceObjDetails object with values from keyword arguments. The default value of the :py:attr:`~oci.cloud_guard.models.ScheduledQueryDataSourceObjDetails.data_source_feed_provider` attribute
        of this class is ``SCHEDULEDQUERY`` and it should not be changed.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param data_source_feed_provider:
            The value to assign to the data_source_feed_provider property of this ScheduledQueryDataSourceObjDetails.
            Allowed values for this property are: "LOGGINGQUERY", "SCHEDULEDQUERY"
        :type data_source_feed_provider: str

        :param query:
            The value to assign to the query property of this ScheduledQueryDataSourceObjDetails.
        :type query: str

        :param description:
            The value to assign to the description property of this ScheduledQueryDataSourceObjDetails.
        :type description: str

        :param interval_in_seconds:
            The value to assign to the interval_in_seconds property of this ScheduledQueryDataSourceObjDetails.
        :type interval_in_seconds: int

        :param scheduled_query_scope_details:
            The value to assign to the scheduled_query_scope_details property of this ScheduledQueryDataSourceObjDetails.
        :type scheduled_query_scope_details: list[oci.cloud_guard.models.ScheduledQueryScopeDetail]

        """
        self.swagger_types = {
            'data_source_feed_provider': 'str',
            'query': 'str',
            'description': 'str',
            'interval_in_seconds': 'int',
            'scheduled_query_scope_details': 'list[ScheduledQueryScopeDetail]'
        }

        self.attribute_map = {
            'data_source_feed_provider': 'dataSourceFeedProvider',
            'query': 'query',
            'description': 'description',
            'interval_in_seconds': 'intervalInSeconds',
            'scheduled_query_scope_details': 'scheduledQueryScopeDetails'
        }

        self._data_source_feed_provider = None
        self._query = None
        self._description = None
        self._interval_in_seconds = None
        self._scheduled_query_scope_details = None
        self._data_source_feed_provider = 'SCHEDULEDQUERY'

    @property
    def query(self):
        """
        Gets the query of this ScheduledQueryDataSourceObjDetails.
        The continuous query expression that is run periodically.


        :return: The query of this ScheduledQueryDataSourceObjDetails.
        :rtype: str
        """
        return self._query

    @query.setter
    def query(self, query):
        """
        Sets the query of this ScheduledQueryDataSourceObjDetails.
        The continuous query expression that is run periodically.


        :param query: The query of this ScheduledQueryDataSourceObjDetails.
        :type: str
        """
        self._query = query

    @property
    def description(self):
        """
        Gets the description of this ScheduledQueryDataSourceObjDetails.
        Description text for the query


        :return: The description of this ScheduledQueryDataSourceObjDetails.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description):
        """
        Sets the description of this ScheduledQueryDataSourceObjDetails.
        Description text for the query


        :param description: The description of this ScheduledQueryDataSourceObjDetails.
        :type: str
        """
        self._description = description

    @property
    def interval_in_seconds(self):
        """
        Gets the interval_in_seconds of this ScheduledQueryDataSourceObjDetails.
        Interval in minutes which query is run periodically.


        :return: The interval_in_seconds of this ScheduledQueryDataSourceObjDetails.
        :rtype: int
        """
        return self._interval_in_seconds

    @interval_in_seconds.setter
    def interval_in_seconds(self, interval_in_seconds):
        """
        Sets the interval_in_seconds of this ScheduledQueryDataSourceObjDetails.
        Interval in minutes which query is run periodically.


        :param interval_in_seconds: The interval_in_seconds of this ScheduledQueryDataSourceObjDetails.
        :type: int
        """
        self._interval_in_seconds = interval_in_seconds

    @property
    def scheduled_query_scope_details(self):
        """
        Gets the scheduled_query_scope_details of this ScheduledQueryDataSourceObjDetails.
        Target information in which scheduled query will be run


        :return: The scheduled_query_scope_details of this ScheduledQueryDataSourceObjDetails.
        :rtype: list[oci.cloud_guard.models.ScheduledQueryScopeDetail]
        """
        return self._scheduled_query_scope_details

    @scheduled_query_scope_details.setter
    def scheduled_query_scope_details(self, scheduled_query_scope_details):
        """
        Sets the scheduled_query_scope_details of this ScheduledQueryDataSourceObjDetails.
        Target information in which scheduled query will be run


        :param scheduled_query_scope_details: The scheduled_query_scope_details of this ScheduledQueryDataSourceObjDetails.
        :type: list[oci.cloud_guard.models.ScheduledQueryScopeDetail]
        """
        self._scheduled_query_scope_details = scheduled_query_scope_details

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
