# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20200131


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class DetectorConfiguration(object):
    """
    Configuration details for a detector.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new DetectorConfiguration object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param config_key:
            The value to assign to the config_key property of this DetectorConfiguration.
        :type config_key: str

        :param name:
            The value to assign to the name property of this DetectorConfiguration.
        :type name: str

        :param value:
            The value to assign to the value property of this DetectorConfiguration.
        :type value: str

        :param data_type:
            The value to assign to the data_type property of this DetectorConfiguration.
        :type data_type: str

        :param values:
            The value to assign to the values property of this DetectorConfiguration.
        :type values: list[oci.cloud_guard.models.ConfigValue]

        :param allowed_values_data_type:
            The value to assign to the allowed_values_data_type property of this DetectorConfiguration.
        :type allowed_values_data_type: str

        :param allowed_values:
            The value to assign to the allowed_values property of this DetectorConfiguration.
        :type allowed_values: list[oci.cloud_guard.models.PropertyTuple]

        """
        self.swagger_types = {
            'config_key': 'str',
            'name': 'str',
            'value': 'str',
            'data_type': 'str',
            'values': 'list[ConfigValue]',
            'allowed_values_data_type': 'str',
            'allowed_values': 'list[PropertyTuple]'
        }

        self.attribute_map = {
            'config_key': 'configKey',
            'name': 'name',
            'value': 'value',
            'data_type': 'dataType',
            'values': 'values',
            'allowed_values_data_type': 'allowedValuesDataType',
            'allowed_values': 'allowedValues'
        }

        self._config_key = None
        self._name = None
        self._value = None
        self._data_type = None
        self._values = None
        self._allowed_values_data_type = None
        self._allowed_values = None

    @property
    def config_key(self):
        """
        **[Required]** Gets the config_key of this DetectorConfiguration.
        Unique identifier of the configuration


        :return: The config_key of this DetectorConfiguration.
        :rtype: str
        """
        return self._config_key

    @config_key.setter
    def config_key(self, config_key):
        """
        Sets the config_key of this DetectorConfiguration.
        Unique identifier of the configuration


        :param config_key: The config_key of this DetectorConfiguration.
        :type: str
        """
        self._config_key = config_key

    @property
    def name(self):
        """
        **[Required]** Gets the name of this DetectorConfiguration.
        Configuration name


        :return: The name of this DetectorConfiguration.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """
        Sets the name of this DetectorConfiguration.
        Configuration name


        :param name: The name of this DetectorConfiguration.
        :type: str
        """
        self._name = name

    @property
    def value(self):
        """
        Gets the value of this DetectorConfiguration.
        Configuration value


        :return: The value of this DetectorConfiguration.
        :rtype: str
        """
        return self._value

    @value.setter
    def value(self, value):
        """
        Sets the value of this DetectorConfiguration.
        Configuration value


        :param value: The value of this DetectorConfiguration.
        :type: str
        """
        self._value = value

    @property
    def data_type(self):
        """
        Gets the data_type of this DetectorConfiguration.
        Configuration data type


        :return: The data_type of this DetectorConfiguration.
        :rtype: str
        """
        return self._data_type

    @data_type.setter
    def data_type(self, data_type):
        """
        Sets the data_type of this DetectorConfiguration.
        Configuration data type


        :param data_type: The data_type of this DetectorConfiguration.
        :type: str
        """
        self._data_type = data_type

    @property
    def values(self):
        """
        Gets the values of this DetectorConfiguration.
        List of configuration values


        :return: The values of this DetectorConfiguration.
        :rtype: list[oci.cloud_guard.models.ConfigValue]
        """
        return self._values

    @values.setter
    def values(self, values):
        """
        Sets the values of this DetectorConfiguration.
        List of configuration values


        :param values: The values of this DetectorConfiguration.
        :type: list[oci.cloud_guard.models.ConfigValue]
        """
        self._values = values

    @property
    def allowed_values_data_type(self):
        """
        Gets the allowed_values_data_type of this DetectorConfiguration.
        Map property Value data type


        :return: The allowed_values_data_type of this DetectorConfiguration.
        :rtype: str
        """
        return self._allowed_values_data_type

    @allowed_values_data_type.setter
    def allowed_values_data_type(self, allowed_values_data_type):
        """
        Sets the allowed_values_data_type of this DetectorConfiguration.
        Map property Value data type


        :param allowed_values_data_type: The allowed_values_data_type of this DetectorConfiguration.
        :type: str
        """
        self._allowed_values_data_type = allowed_values_data_type

    @property
    def allowed_values(self):
        """
        Gets the allowed_values of this DetectorConfiguration.
        Map of possible values for configuration


        :return: The allowed_values of this DetectorConfiguration.
        :rtype: list[oci.cloud_guard.models.PropertyTuple]
        """
        return self._allowed_values

    @allowed_values.setter
    def allowed_values(self, allowed_values):
        """
        Sets the allowed_values of this DetectorConfiguration.
        Map of possible values for configuration


        :param allowed_values: The allowed_values of this DetectorConfiguration.
        :type: list[oci.cloud_guard.models.PropertyTuple]
        """
        self._allowed_values = allowed_values

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
