# coding: utf-8
# Copyright (c) 2016, 2024, Oracle and/or its affiliates.  All rights reserved.
# This software is dual-licensed to you under the Universal Permissive License (UPL) 1.0 as shown at https://oss.oracle.com/licenses/upl or Apache License 2.0 as shown at http://www.apache.org/licenses/LICENSE-2.0. You may choose either license.

# NOTE: This class is auto generated by OracleSDKGenerator. DO NOT EDIT. API Version: 20220421


from oci.util import formatted_flat_dict, NONE_SENTINEL, value_allowed_none_or_none_sentinel  # noqa: F401
from oci.decorators import init_model_state_from_kwargs


@init_model_state_from_kwargs
class ApplicationDependencyVulnerabilitySummary(object):
    """
    An application dependency Vulnerability represents a single dependency in the application.
    An application dependency Vulnerability can be associated with eventual Vulnerabilities.
    Each application dependency is uniquely defined by a nodeId and lists eventual dependencies on which it depends.
    """

    def __init__(self, **kwargs):
        """
        Initializes a new ApplicationDependencyVulnerabilitySummary object with values from keyword arguments.
        The following keyword arguments are supported (corresponding to the getters/setters of this class):

        :param gav:
            The value to assign to the gav property of this ApplicationDependencyVulnerabilitySummary.
        :type gav: str

        :param purl:
            The value to assign to the purl property of this ApplicationDependencyVulnerabilitySummary.
        :type purl: str

        :param node_id:
            The value to assign to the node_id property of this ApplicationDependencyVulnerabilitySummary.
        :type node_id: str

        :param application_dependency_node_ids:
            The value to assign to the application_dependency_node_ids property of this ApplicationDependencyVulnerabilitySummary.
        :type application_dependency_node_ids: list[str]

        :param vulnerabilities:
            The value to assign to the vulnerabilities property of this ApplicationDependencyVulnerabilitySummary.
        :type vulnerabilities: list[oci.adm.models.Vulnerability]

        :param is_found_in_knowledge_base:
            The value to assign to the is_found_in_knowledge_base property of this ApplicationDependencyVulnerabilitySummary.
        :type is_found_in_knowledge_base: bool

        """
        self.swagger_types = {
            'gav': 'str',
            'purl': 'str',
            'node_id': 'str',
            'application_dependency_node_ids': 'list[str]',
            'vulnerabilities': 'list[Vulnerability]',
            'is_found_in_knowledge_base': 'bool'
        }

        self.attribute_map = {
            'gav': 'gav',
            'purl': 'purl',
            'node_id': 'nodeId',
            'application_dependency_node_ids': 'applicationDependencyNodeIds',
            'vulnerabilities': 'vulnerabilities',
            'is_found_in_knowledge_base': 'isFoundInKnowledgeBase'
        }

        self._gav = None
        self._purl = None
        self._node_id = None
        self._application_dependency_node_ids = None
        self._vulnerabilities = None
        self._is_found_in_knowledge_base = None

    @property
    def gav(self):
        """
        **[Required]** Gets the gav of this ApplicationDependencyVulnerabilitySummary.
        Group Artifact Version (GAV) identifier (Group:Artifact:Version). Example: org.graalvm.nativeimage:svm:21.1.0.
        \"N/A\" for non-maven artifacts.


        :return: The gav of this ApplicationDependencyVulnerabilitySummary.
        :rtype: str
        """
        return self._gav

    @gav.setter
    def gav(self, gav):
        """
        Sets the gav of this ApplicationDependencyVulnerabilitySummary.
        Group Artifact Version (GAV) identifier (Group:Artifact:Version). Example: org.graalvm.nativeimage:svm:21.1.0.
        \"N/A\" for non-maven artifacts.


        :param gav: The gav of this ApplicationDependencyVulnerabilitySummary.
        :type: str
        """
        self._gav = gav

    @property
    def purl(self):
        """
        Gets the purl of this ApplicationDependencyVulnerabilitySummary.
        Package URL defined in https://github.com/package-url/purl-spec, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.1.0


        :return: The purl of this ApplicationDependencyVulnerabilitySummary.
        :rtype: str
        """
        return self._purl

    @purl.setter
    def purl(self, purl):
        """
        Sets the purl of this ApplicationDependencyVulnerabilitySummary.
        Package URL defined in https://github.com/package-url/purl-spec, e.g. pkg:maven/org.graalvm.nativeimage/svm@21.1.0


        :param purl: The purl of this ApplicationDependencyVulnerabilitySummary.
        :type: str
        """
        self._purl = purl

    @property
    def node_id(self):
        """
        **[Required]** Gets the node_id of this ApplicationDependencyVulnerabilitySummary.
        Unique identifier of an application dependency, for example nodeId1.


        :return: The node_id of this ApplicationDependencyVulnerabilitySummary.
        :rtype: str
        """
        return self._node_id

    @node_id.setter
    def node_id(self, node_id):
        """
        Sets the node_id of this ApplicationDependencyVulnerabilitySummary.
        Unique identifier of an application dependency, for example nodeId1.


        :param node_id: The node_id of this ApplicationDependencyVulnerabilitySummary.
        :type: str
        """
        self._node_id = node_id

    @property
    def application_dependency_node_ids(self):
        """
        **[Required]** Gets the application_dependency_node_ids of this ApplicationDependencyVulnerabilitySummary.
        List of application dependencies on which this application dependency depends, each identified by its nodeId.


        :return: The application_dependency_node_ids of this ApplicationDependencyVulnerabilitySummary.
        :rtype: list[str]
        """
        return self._application_dependency_node_ids

    @application_dependency_node_ids.setter
    def application_dependency_node_ids(self, application_dependency_node_ids):
        """
        Sets the application_dependency_node_ids of this ApplicationDependencyVulnerabilitySummary.
        List of application dependencies on which this application dependency depends, each identified by its nodeId.


        :param application_dependency_node_ids: The application_dependency_node_ids of this ApplicationDependencyVulnerabilitySummary.
        :type: list[str]
        """
        self._application_dependency_node_ids = application_dependency_node_ids

    @property
    def vulnerabilities(self):
        """
        **[Required]** Gets the vulnerabilities of this ApplicationDependencyVulnerabilitySummary.
        List of vulnerabilities for the application dependency.


        :return: The vulnerabilities of this ApplicationDependencyVulnerabilitySummary.
        :rtype: list[oci.adm.models.Vulnerability]
        """
        return self._vulnerabilities

    @vulnerabilities.setter
    def vulnerabilities(self, vulnerabilities):
        """
        Sets the vulnerabilities of this ApplicationDependencyVulnerabilitySummary.
        List of vulnerabilities for the application dependency.


        :param vulnerabilities: The vulnerabilities of this ApplicationDependencyVulnerabilitySummary.
        :type: list[oci.adm.models.Vulnerability]
        """
        self._vulnerabilities = vulnerabilities

    @property
    def is_found_in_knowledge_base(self):
        """
        **[Required]** Gets the is_found_in_knowledge_base of this ApplicationDependencyVulnerabilitySummary.
        Indicates if the artifact is found in the knowledge base.


        :return: The is_found_in_knowledge_base of this ApplicationDependencyVulnerabilitySummary.
        :rtype: bool
        """
        return self._is_found_in_knowledge_base

    @is_found_in_knowledge_base.setter
    def is_found_in_knowledge_base(self, is_found_in_knowledge_base):
        """
        Sets the is_found_in_knowledge_base of this ApplicationDependencyVulnerabilitySummary.
        Indicates if the artifact is found in the knowledge base.


        :param is_found_in_knowledge_base: The is_found_in_knowledge_base of this ApplicationDependencyVulnerabilitySummary.
        :type: bool
        """
        self._is_found_in_knowledge_base = is_found_in_knowledge_base

    def __repr__(self):
        return formatted_flat_dict(self)

    def __eq__(self, other):
        if other is None:
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        return not self == other
