import { CodeEditor } from '@jupyterlab/codeeditor';
import type * as lsp from 'vscode-languageserver-protocol';
/**
 * CM5 position interface.
 *
 * TODO: Migrate to offset-only mode once `CodeEditor.IPosition`
 * is migrated.
 */
export interface IPosition {
    /**
     * Line number
     */
    line: number;
    /**
     * Position of character in line
     */
    ch: number;
}
/**
 * is_* attributes are there only to enforce strict interface type checking
 */
export interface ISourcePosition extends IPosition {
    isSource: true;
}
export interface IEditorPosition extends IPosition {
    isEditor: true;
}
export interface IVirtualPosition extends IPosition {
    isVirtual: true;
}
export interface IRootPosition extends ISourcePosition {
    isRoot: true;
}
/**
 * Compare two `IPosition` variable.
 *
 */
export declare function isEqual(self: IPosition, other: IPosition): boolean;
/**
 * Given a list of line and an offset from the start, compute the corresponding
 * position in form of line and column number
 *
 * @param offset - number of spaces counted from the start of first line
 * @param  lines - list of lines to compute the position
 * @return  - the position of cursor
 */
export declare function positionAtOffset(offset: number, lines: string[]): CodeEditor.IPosition;
/**
 * Given a list of line and position in form of line and column number,
 * compute the offset from the start of first line.
 * @param position - postion of cursor
 * @param  lines - list of lines to compute the position
 * @param linesIncludeBreaks - should count the line break as space?
 * return - offset number
 */
export declare function offsetAtPosition(position: CodeEditor.IPosition, lines: string[], linesIncludeBreaks?: boolean): number;
export declare namespace ProtocolCoordinates {
    /**
     * Check if the position is in the input range
     *
     * @param position - position in form of line and character number.
     * @param  range - range in from of start and end position.
     */
    function isWithinRange(position: lsp.Position, range: lsp.Range): boolean;
}
