import { ServerConnection } from '../serverconnection';
import { Session } from '.';
type DeepPartial<T> = {
    [P in keyof T]?: DeepPartial<T[P]>;
};
/**
 * The url for the session service.
 */
export declare const SESSION_SERVICE_URL = "api/sessions";
/**
 * List the running sessions.
 */
export declare function listRunning(settings?: ServerConnection.ISettings): Promise<Session.IModel[]>;
/**
 * Get a session url.
 */
export declare function getSessionUrl(baseUrl: string, id: string): string;
/**
 * Shut down a session by id.
 */
export declare function shutdownSession(id: string, settings?: ServerConnection.ISettings): Promise<void>;
/**
 * Get a full session model from the server by session id string.
 */
export declare function getSessionModel(id: string, settings?: ServerConnection.ISettings): Promise<Session.IModel>;
/**
 * Create a new session, or return an existing session if the session path
 * already exists.
 */
export declare function startSession(options: Session.ISessionOptions, settings?: ServerConnection.ISettings): Promise<Session.IModel>;
/**
 * Send a PATCH to the server, updating the session path or the kernel.
 */
export declare function updateSession(model: Pick<Session.IModel, 'id'> & DeepPartial<Omit<Session.IModel, 'id'>>, settings?: ServerConnection.ISettings): Promise<Session.IModel>;
export {};
