import { CodeEditorWrapper } from '@jupyterlab/codeeditor';
import { CodeCellModel } from './model';
import { Cell } from './widget';
/**
 * The default notebook content.
 */
export declare namespace NBTestUtils {
    const editorFactory: any;
    const mimeTypeService: import("@jupyterlab/codeeditor").IEditorMimeTypeService;
    /**
     * Create a base cell content factory.
     */
    function createBaseCellFactory(): Cell.IContentFactory;
    /**
     * Create a new code cell content factory.
     */
    function createCodeCellFactory(): Cell.IContentFactory;
    /**
     * Create a cell editor widget.
     */
    function createCellEditor(model?: CodeCellModel): CodeEditorWrapper;
}
