import { ReactWidget } from '@jupyterlab/ui-components';
import * as React from 'react';
/**
 * Abstract collapser base class.
 *
 * ### Notes
 * A collapser is a visible div to the left of a cell's
 * input/output that a user can click on to collapse the
 * input/output.
 */
export declare abstract class Collapser extends ReactWidget {
    /**
     * Construct a new collapser.
     */
    constructor();
    /**
     * Is the input/output of the parent collapsed.
     */
    get collapsed(): boolean;
    /**
     * Render the collapser with the virtual DOM.
     */
    protected render(): React.ReactElement<any>;
    /**
     * Handle the click event.
     */
    protected abstract handleClick(e: React.MouseEvent<HTMLDivElement>): void;
}
/**
 * A collapser subclass to collapse a cell's input area.
 */
export declare class InputCollapser extends Collapser {
    /**
     * Construct a new input collapser.
     */
    constructor();
    /**
     * Is the cell's input collapsed?
     */
    get collapsed(): boolean;
    /**
     * Handle a click event for the user to collapse the cell's input.
     */
    protected handleClick(e: React.MouseEvent<HTMLDivElement>): void;
}
/**
 * A collapser subclass to collapse a cell's output area.
 */
export declare class OutputCollapser extends Collapser {
    /**
     * Construct a new output collapser.
     */
    constructor();
    /**
     * Is the cell's output collapsed?
     */
    get collapsed(): boolean;
    /**
     * Handle a click event for the user to collapse the cell's output.
     */
    protected handleClick(e: React.MouseEvent<HTMLDivElement>): void;
}
