// Copyright (c) Jupyter Development Team.
// Distributed under the terms of the Modified BSD License.
import { nullTranslator } from '@jupyterlab/translation';
import { EditorExtensionRegistry } from './extension';
import { CodeMirrorEditor } from './editor';
import { EditorLanguageRegistry } from './language';
import { keymap } from '@codemirror/view';
import { searchKeymap } from '@codemirror/search';
/**
 * CodeMirror editor factory.
 */
export class CodeMirrorEditorFactory {
    /**
     * Construct an IEditorFactoryService for CodeMirrorEditors.
     */
    constructor(options = {}) {
        var _a, _b, _c;
        /**
         * Create a new editor for inline code.
         */
        this.newInlineEditor = (options) => {
            var _a;
            options.host.dataset.type = 'inline';
            return this.newEditor({
                ...options,
                config: { ...this.inlineCodeMirrorConfig, ...(options.config || {}) },
                inline: true,
                // FIXME the search keymap should be added in the search plugin
                extensions: [keymap.of(searchKeymap)].concat((_a = options.extensions) !== null && _a !== void 0 ? _a : [])
            });
        };
        /**
         * Create a new editor for a full document.
         */
        this.newDocumentEditor = (options) => {
            var _a, _b;
            options.host.dataset.type = 'document';
            return this.newEditor({
                ...options,
                config: { ...this.documentCodeMirrorConfig, ...((_a = options.config) !== null && _a !== void 0 ? _a : {}) },
                inline: false,
                extensions: [
                    keymap.of([
                        {
                            key: 'Shift-Enter',
                            run: (target) => {
                                return true;
                            }
                        }
                    ])
                ].concat((_b = options.extensions) !== null && _b !== void 0 ? _b : [])
            });
        };
        this.languages = (_a = options.languages) !== null && _a !== void 0 ? _a : new EditorLanguageRegistry();
        this.extensions = (_b = options.extensions) !== null && _b !== void 0 ? _b : new EditorExtensionRegistry();
        this.translator = (_c = options.translator) !== null && _c !== void 0 ? _c : nullTranslator;
        this.inlineCodeMirrorConfig = {};
        this.documentCodeMirrorConfig = {
            lineNumbers: true,
            scrollPastEnd: true
        };
    }
    /**
     * Create a new editor
     *
     * @param options Editor options
     * @returns The editor
     */
    newEditor(options) {
        const editor = new CodeMirrorEditor({
            extensionsRegistry: this.extensions,
            languages: this.languages,
            translator: this.translator,
            ...options
        });
        return editor;
    }
}
//# sourceMappingURL=factory.js.map