import { jsx as _jsx, jsxs as _jsxs } from "react/jsx-runtime";
import { useCallback } from 'react';
import { ariaDescribedByIds, descriptionId, getTemplate, labelValue, schemaRequiresTrueValue, } from '@rjsf/utils';
/** The `CheckBoxWidget` is a widget for rendering boolean properties.
 *  It is typically used to represent a boolean.
 *
 * @param props - The `WidgetProps` for this component
 */
function CheckboxWidget({ schema, uiSchema, options, id, value, disabled, readonly, label, hideLabel, autofocus = false, onBlur, onFocus, onChange, registry, }) {
    var _a;
    const DescriptionFieldTemplate = getTemplate('DescriptionFieldTemplate', registry, options);
    // Because an unchecked checkbox will cause html5 validation to fail, only add
    // the "required" attribute if the field value must be "true", due to the
    // "const" or "enum" keywords
    const required = schemaRequiresTrueValue(schema);
    const handleChange = useCallback((event) => onChange(event.target.checked), [onChange]);
    const handleBlur = useCallback((event) => onBlur(id, event.target.checked), [onBlur, id]);
    const handleFocus = useCallback((event) => onFocus(id, event.target.checked), [onFocus, id]);
    const description = (_a = options.description) !== null && _a !== void 0 ? _a : schema.description;
    return (_jsxs("div", { className: `checkbox ${disabled || readonly ? 'disabled' : ''}`, children: [!hideLabel && !!description && (_jsx(DescriptionFieldTemplate, { id: descriptionId(id), description: description, schema: schema, uiSchema: uiSchema, registry: registry })), _jsxs("label", { children: [_jsx("input", { type: 'checkbox', id: id, name: id, checked: typeof value === 'undefined' ? false : value, required: required, disabled: disabled || readonly, autoFocus: autofocus, onChange: handleChange, onBlur: handleBlur, onFocus: handleFocus, "aria-describedby": ariaDescribedByIds(id) }), labelValue(_jsx("span", { children: label }), hideLabel)] })] }));
}
export default CheckboxWidget;
//# sourceMappingURL=CheckboxWidget.js.map