try:
    from setuptools import setup, Extensions
except ImportError:
    from distutils.core import setup, Extension

setup(
    name='fbhgext',
    version='0.1.2',
    author='Durham Goode',
    maintainer='Durham Goode',
    maintainer_email='durham@fb.com',
    url='',
    description='Facebook specific mercurial extensions',
    long_description="",
    keywords='fb hg mercurial',
    license='',
    packages=['phabricator'],
    py_modules=[
        'arcdiff',
        'backups',
        'bundle2hooks',
        'catnotate',
        'chistedit',
        'commitextras',
        'dirsync',
        'errorredirect',
        'extutil',
        'fastmanifest',
        'fbamend',
        'fbconduit',
        'fbhistedit',
        'githelp',
        'gitlookup',
        'gitrevset',
        'inhibitwarn',
        'manifestdiskcache',
        'mergedriver',
        'morestatus',
        'perftweaks',
        'phabdiff',
        'phrevset',
        'phabstatus',
        'pullcreatemarkers',
        'pushrebase',
        'pushvars',
        'rage',
        'reflog',
        'reset',
        'show',
        'simplecache',
        'smartlog',
        'sparse',
        'statprof',
        'tweakdefaults',
        'upgradegeneraldelta',
    ],
    ext_modules = [
        Extension('fastmanifest_wrapper',
                  sources=['fastmanifest_wrapper.c',
                           'fastmanifest/bsearch.c',
                           'fastmanifest/buffer.c',
                           'fastmanifest/checksum.c',
                           'fastmanifest/node.c',
                           'fastmanifest/tree.c',
                           'fastmanifest/tree_arena.c',
                           'fastmanifest/tree_convert.c',
                           'fastmanifest/tree_copy.c',
                           'fastmanifest/tree_diff.c',
                           'fastmanifest/tree_iterator.c',
                           'fastmanifest/tree_path.c',
                  ],
                  include_dirs=['fastmanifest',
                                '/usr/local/include',
                                '/opt/local/include',
                  ],
                  library_dirs=[
                      '/usr/local/lib',
                      '/opt/local/lib',
                  ],
                  libraries=['crypto',
                  ],
                  extra_compile_args=["-std=c99", "-Wall", "-Werror"],
        )
    ],
)
