import numpy as np
import emcee

def lnprob(x, ivar):
    return -0.5*np.sum(ivar * x**2)

ndim, nwalkers = 10, 100
ivar = 1./np.random.rand(ndim)
p0 = [np.random.rand(ndim) for i in xrange(nwalkers)]

sampler = emcee.EnsembleSampler(nwalkers, ndim, lnprob, args=[ivar])
sampler.run_mcmc(p0, 1000)

