/*!
 * Copyright (c) 2012 - 2018, Anaconda, Inc., and Bokeh Contributors
 * All rights reserved.
 * 
 * Redistribution and use in source and binary forms, with or without modification,
 * are permitted provided that the following conditions are met:
 * 
 * Redistributions of source code must retain the above copyright notice,
 * this list of conditions and the following disclaimer.
 * 
 * Redistributions in binary form must reproduce the above copyright notice,
 * this list of conditions and the following disclaimer in the documentation
 * and/or other materials provided with the distribution.
 * 
 * Neither the name of Anaconda nor the names of any contributors
 * may be used to endorse or promote products derived from this software
 * without specific prior written permission.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
 * THE POSSIBILITY OF SUCH DAMAGE.
 */
(function(root, factory) {
//  if(typeof exports === 'object' && typeof module === 'object')
//    module.exports = factory();
//  else if(typeof define === 'function' && define.amd)
//    define("Bokeh", [], factory);
//  else if(typeof exports === 'object')
//    exports["Bokeh"] = factory();
//  else
    root["Bokeh"] = factory();
})(this, function() {
  var define;
  return (function(modules, aliases, entry, parent_require) {
    var cache = {};

    var require = function(name) {
      var id = aliases[name] != null ? aliases[name] : name;

      if (!cache[id]) {
        if (!modules[id]) {
          if (parent_require)
            return parent_require(id)

          var err = new Error("Cannot find module '" + name + "'");
          err.code = 'MODULE_NOT_FOUND';
          throw err;
        }

        var module = cache[id] = {exports: {}};
        modules[id].call(module.exports, require, module, module.exports);
      }

      return cache[id].exports;
    }

    var main = require(entry);
    main.require = require;

    main.register_plugin = function(plugin_modules, plugin_aliases, plugin_entry) {
      for (var name in plugin_modules) {
        modules[name] = plugin_modules[name];
      }

      for (var name in plugin_aliases) {
        aliases[name] = plugin_aliases[name];
      }

      var plugin = require(plugin_entry);

      for (var name in plugin) {
        main[name] = plugin[name];
      }

      return plugin;
    }

    return main;
  })
([
/* compile */ function _(require, module, exports) {
    const fs = require("fs");
    const path = require("path");
    const ts = require(367) /* typescript */;
    const coffee = require(77) /* coffeescript */;
    const less = require(164) /* less */;
    const yargs_1 = require(379) /* yargs */;
    const dependencies_1 = require(1) /* ./dependencies */;
    const mkCoffeescriptError = (error, file) => {
        const message = error.message;
        if (error.location == null) {
            const text = [file || "<string>", message].join(":");
            return { message, text };
        }
        else {
            const location = error.location;
            const line = location.first_line + 1;
            const column = location.first_column + 1;
            const text = [file || "<string>", line, column, message].join(":");
            let markerLen = 2;
            if (location.first_line === location.last_line)
                markerLen += location.last_column - location.first_column;
            const extract = error.code.split('\n')[line - 1];
            const annotated = [
                text,
                "  " + extract,
                "  " + Array(column).join(' ') + Array(markerLen).join('^'),
            ].join('\n');
            return { message, line, column, text, extract, annotated };
        }
    };
    const mkLessError = (error, file) => {
        const message = error.message;
        const line = error.line;
        const column = error.column + 1;
        const text = [file || "<string>", line, column, message].join(":");
        const extract = error.extract[line];
        const annotated = [text, "  " + extract].join("\n");
        return { message, line, column, text, extract, annotated };
    };
    const mkTypeScriptError = (diagnostic) => {
        let { line, character: column } = diagnostic.file.getLineAndCharacterOfPosition(diagnostic.start);
        line += 1;
        column += 1;
        const message = ts.flattenDiagnosticMessageText(diagnostic.messageText, '\n');
        const text = [diagnostic.file.fileName, line, column, message].join(":");
        return { message, line, column, text };
    };
    const reply = (data) => {
        process.stdout.write(JSON.stringify(data));
        process.stdout.write("\n");
    };
    const compile_and_resolve_deps = (input) => {
        let code;
        switch (input.lang) {
            case "coffeescript":
                try {
                    code = coffee.compile(input.code, { bare: true, shiftLine: true });
                }
                catch (error) {
                    return reply({ error: mkCoffeescriptError(error, input.file) });
                }
                break;
            case "javascript":
            case "typescript":
                code = input.code;
                break;
            case "less":
                const options = {
                    paths: [path.dirname(input.file)],
                    compress: true,
                    ieCompat: false,
                };
                less.render(input.code, options, (error, output) => {
                    if (error != null)
                        reply({ error: mkLessError(error, input.file) });
                    else
                        reply({ code: output.css });
                });
                return;
            default:
                throw new Error(`unsupported input type: ${input.lang}`);
        }
        const result = ts.transpileModule(code, {
            fileName: input.file,
            reportDiagnostics: true,
            compilerOptions: {
                noEmitOnError: false,
                noImplicitAny: false,
                target: ts.ScriptTarget.ES5,
                module: ts.ModuleKind.CommonJS,
            },
        });
        if (result.diagnostics != null && result.diagnostics.length > 0) {
            const diagnostic = result.diagnostics[0];
            return reply({ error: mkTypeScriptError(diagnostic) });
        }
        code = result.outputText;
        const source = ts.createSourceFile(input.file, code, ts.ScriptTarget.ES5, true, ts.ScriptKind.JS);
        const deps = dependencies_1.collect_deps(source);
        return reply({ code, deps });
    };
    if (yargs_1.argv.file != null) {
        const input = {
            code: fs.readFileSync(yargs_1.argv.file, "utf-8"),
            lang: yargs_1.argv.lang || "coffeescript",
            file: yargs_1.argv.file,
        };
        compile_and_resolve_deps(input);
    }
    else {
        const stdin = process.stdin;
        stdin.resume();
        stdin.setEncoding("utf-8");
        let data = "";
        stdin.on("data", (chunk) => data += chunk);
        stdin.on("end", () => compile_and_resolve_deps(JSON.parse(data)));
    }
}
,
/* dependencies */ function _(require, module, exports) {
    const ts = require(367) /* typescript */;
    function kind_of(node, kind) {
        return node.kind === kind;
    }
    function is_CallExpression(node) {
        return kind_of(node, ts.SyntaxKind.CallExpression);
    }
    function is_Identifier(node) {
        return kind_of(node, ts.SyntaxKind.Identifier);
    }
    function is_StringLiteral(node) {
        return kind_of(node, ts.SyntaxKind.StringLiteral);
    }
    function is_require(node) {
        return is_CallExpression(node) &&
            is_Identifier(node.expression) &&
            node.expression.text === "require" &&
            node.arguments.length === 1;
    }
    function collect_deps(source) {
        function traverse(node) {
            if (is_require(node)) {
                const [arg] = node.arguments;
                if (is_StringLiteral(arg) && arg.text.length > 0)
                    deps.push(arg.text);
            }
            ts.forEachChild(node, traverse);
        }
        const deps = [];
        traverse(source);
        return deps;
    }
    exports.collect_deps = collect_deps;
}
,
/* ajv/lib/$data */ function _(require, module, exports) {
    var KEYWORDS = [
        'multipleOf',
        'maximum',
        'exclusiveMaximum',
        'minimum',
        'exclusiveMinimum',
        'maxLength',
        'minLength',
        'pattern',
        'additionalItems',
        'maxItems',
        'minItems',
        'uniqueItems',
        'maxProperties',
        'minProperties',
        'required',
        'additionalProperties',
        'enum',
        'format',
        'const'
    ];
    module.exports = function (metaSchema, keywordsJsonPointers) {
        for (var i = 0; i < keywordsJsonPointers.length; i++) {
            metaSchema = JSON.parse(JSON.stringify(metaSchema));
            var segments = keywordsJsonPointers[i].split('/');
            var keywords = metaSchema;
            var j;
            for (j = 1; j < segments.length; j++)
                keywords = keywords[segments[j]];
            for (j = 0; j < KEYWORDS.length; j++) {
                var key = KEYWORDS[j];
                var schema = keywords[key];
                if (schema) {
                    keywords[key] = {
                        anyOf: [
                            schema,
                            { $ref: 'https://raw.githubusercontent.com/epoberezkin/ajv/master/lib/refs/$data.json#' }
                        ]
                    };
                }
            }
        }
        return metaSchema;
    };
}
,
/* ajv/lib/ajv */ function _(require, module, exports) {
    var compileSchema = require(9) /* ./compile */, resolve = require(10) /* ./compile/resolve */, Cache = require(4) /* ./cache */, SchemaObject = require(12) /* ./compile/schema_obj */, stableStringify = require(109) /* fast-json-stable-stringify */, formats = require(8) /* ./compile/formats */, rules = require(11) /* ./compile/rules */, $dataMetaSchema = require(2) /* ./$data */, patternGroups = require(39) /* ./patternGroups */, util = require(14) /* ./compile/util */, co = require(74) /* co */;
    module.exports = Ajv;
    Ajv.prototype.validate = validate;
    Ajv.prototype.compile = compile;
    Ajv.prototype.addSchema = addSchema;
    Ajv.prototype.addMetaSchema = addMetaSchema;
    Ajv.prototype.validateSchema = validateSchema;
    Ajv.prototype.getSchema = getSchema;
    Ajv.prototype.removeSchema = removeSchema;
    Ajv.prototype.addFormat = addFormat;
    Ajv.prototype.errorsText = errorsText;
    Ajv.prototype._addSchema = _addSchema;
    Ajv.prototype._compile = _compile;
    Ajv.prototype.compileAsync = require(6) /* ./compile/async */;
    var customKeyword = require(38) /* ./keyword */;
    Ajv.prototype.addKeyword = customKeyword.add;
    Ajv.prototype.getKeyword = customKeyword.get;
    Ajv.prototype.removeKeyword = customKeyword.remove;
    var errorClasses = require(7) /* ./compile/error_classes */;
    Ajv.ValidationError = errorClasses.Validation;
    Ajv.MissingRefError = errorClasses.MissingRef;
    Ajv.$dataMetaSchema = $dataMetaSchema;
    var META_SCHEMA_ID = 'http://json-schema.org/draft-06/schema';
    var META_IGNORE_OPTIONS = ['removeAdditional', 'useDefaults', 'coerceTypes'];
    var META_SUPPORT_DATA = ['/properties'];
    /**
     * Creates validator instance.
     * Usage: `Ajv(opts)`
     * @param {Object} opts optional options
     * @return {Object} ajv instance
     */
    function Ajv(opts) {
        if (!(this instanceof Ajv))
            return new Ajv(opts);
        opts = this._opts = util.copy(opts) || {};
        setLogger(this);
        this._schemas = {};
        this._refs = {};
        this._fragments = {};
        this._formats = formats(opts.format);
        var schemaUriFormat = this._schemaUriFormat = this._formats['uri-reference'];
        this._schemaUriFormatFunc = function (str) { return schemaUriFormat.test(str); };
        this._cache = opts.cache || new Cache;
        this._loadingSchemas = {};
        this._compilations = [];
        this.RULES = rules();
        this._getId = chooseGetId(opts);
        opts.loopRequired = opts.loopRequired || Infinity;
        if (opts.errorDataPath == 'property')
            opts._errorDataPathProperty = true;
        if (opts.serialize === undefined)
            opts.serialize = stableStringify;
        this._metaOpts = getMetaSchemaOptions(this);
        if (opts.formats)
            addInitialFormats(this);
        addDraft6MetaSchema(this);
        if (typeof opts.meta == 'object')
            this.addMetaSchema(opts.meta);
        addInitialSchemas(this);
        if (opts.patternGroups)
            patternGroups(this);
    }
    /**
     * Validate data using schema
     * Schema will be compiled and cached (using serialized JSON as key. [fast-json-stable-stringify](https://github.com/epoberezkin/fast-json-stable-stringify) is used to serialize.
     * @this   Ajv
     * @param  {String|Object} schemaKeyRef key, ref or schema object
     * @param  {Any} data to be validated
     * @return {Boolean} validation result. Errors from the last validation will be available in `ajv.errors` (and also in compiled schema: `schema.errors`).
     */
    function validate(schemaKeyRef, data) {
        var v;
        if (typeof schemaKeyRef == 'string') {
            v = this.getSchema(schemaKeyRef);
            if (!v)
                throw new Error('no schema with key or ref "' + schemaKeyRef + '"');
        }
        else {
            var schemaObj = this._addSchema(schemaKeyRef);
            v = schemaObj.validate || this._compile(schemaObj);
        }
        var valid = v(data);
        if (v.$async === true)
            return this._opts.async == '*' ? co(valid) : valid;
        this.errors = v.errors;
        return valid;
    }
    /**
     * Create validating function for passed schema.
     * @this   Ajv
     * @param  {Object} schema schema object
     * @param  {Boolean} _meta true if schema is a meta-schema. Used internally to compile meta schemas of custom keywords.
     * @return {Function} validating function
     */
    function compile(schema, _meta) {
        var schemaObj = this._addSchema(schema, undefined, _meta);
        return schemaObj.validate || this._compile(schemaObj);
    }
    /**
     * Adds schema to the instance.
     * @this   Ajv
     * @param {Object|Array} schema schema or array of schemas. If array is passed, `key` and other parameters will be ignored.
     * @param {String} key Optional schema key. Can be passed to `validate` method instead of schema object or id/ref. One schema per instance can have empty `id` and `key`.
     * @param {Boolean} _skipValidation true to skip schema validation. Used internally, option validateSchema should be used instead.
     * @param {Boolean} _meta true if schema is a meta-schema. Used internally, addMetaSchema should be used instead.
     * @return {Ajv} this for method chaining
     */
    function addSchema(schema, key, _skipValidation, _meta) {
        if (Array.isArray(schema)) {
            for (var i = 0; i < schema.length; i++)
                this.addSchema(schema[i], undefined, _skipValidation, _meta);
            return this;
        }
        var id = this._getId(schema);
        if (id !== undefined && typeof id != 'string')
            throw new Error('schema id must be string');
        key = resolve.normalizeId(key || id);
        checkUnique(this, key);
        this._schemas[key] = this._addSchema(schema, _skipValidation, _meta, true);
        return this;
    }
    /**
     * Add schema that will be used to validate other schemas
     * options in META_IGNORE_OPTIONS are alway set to false
     * @this   Ajv
     * @param {Object} schema schema object
     * @param {String} key optional schema key
     * @param {Boolean} skipValidation true to skip schema validation, can be used to override validateSchema option for meta-schema
     * @return {Ajv} this for method chaining
     */
    function addMetaSchema(schema, key, skipValidation) {
        this.addSchema(schema, key, skipValidation, true);
        return this;
    }
    /**
     * Validate schema
     * @this   Ajv
     * @param {Object} schema schema to validate
     * @param {Boolean} throwOrLogError pass true to throw (or log) an error if invalid
     * @return {Boolean} true if schema is valid
     */
    function validateSchema(schema, throwOrLogError) {
        var $schema = schema.$schema;
        if ($schema !== undefined && typeof $schema != 'string')
            throw new Error('$schema must be a string');
        $schema = $schema || this._opts.defaultMeta || defaultMeta(this);
        if (!$schema) {
            this.logger.warn('meta-schema not available');
            this.errors = null;
            return true;
        }
        var currentUriFormat = this._formats.uri;
        this._formats.uri = typeof currentUriFormat == 'function'
            ? this._schemaUriFormatFunc
            : this._schemaUriFormat;
        var valid;
        try {
            valid = this.validate($schema, schema);
        }
        finally {
            this._formats.uri = currentUriFormat;
        }
        if (!valid && throwOrLogError) {
            var message = 'schema is invalid: ' + this.errorsText();
            if (this._opts.validateSchema == 'log')
                this.logger.error(message);
            else
                throw new Error(message);
        }
        return valid;
    }
    function defaultMeta(self) {
        var meta = self._opts.meta;
        self._opts.defaultMeta = typeof meta == 'object'
            ? self._getId(meta) || meta
            : self.getSchema(META_SCHEMA_ID)
                ? META_SCHEMA_ID
                : undefined;
        return self._opts.defaultMeta;
    }
    /**
     * Get compiled schema from the instance by `key` or `ref`.
     * @this   Ajv
     * @param  {String} keyRef `key` that was passed to `addSchema` or full schema reference (`schema.id` or resolved id).
     * @return {Function} schema validating function (with property `schema`).
     */
    function getSchema(keyRef) {
        var schemaObj = _getSchemaObj(this, keyRef);
        switch (typeof schemaObj) {
            case 'object': return schemaObj.validate || this._compile(schemaObj);
            case 'string': return this.getSchema(schemaObj);
            case 'undefined': return _getSchemaFragment(this, keyRef);
        }
    }
    function _getSchemaFragment(self, ref) {
        var res = resolve.schema.call(self, { schema: {} }, ref);
        if (res) {
            var schema = res.schema, root = res.root, baseId = res.baseId;
            var v = compileSchema.call(self, schema, root, undefined, baseId);
            self._fragments[ref] = new SchemaObject({
                ref: ref,
                fragment: true,
                schema: schema,
                root: root,
                baseId: baseId,
                validate: v
            });
            return v;
        }
    }
    function _getSchemaObj(self, keyRef) {
        keyRef = resolve.normalizeId(keyRef);
        return self._schemas[keyRef] || self._refs[keyRef] || self._fragments[keyRef];
    }
    /**
     * Remove cached schema(s).
     * If no parameter is passed all schemas but meta-schemas are removed.
     * If RegExp is passed all schemas with key/id matching pattern but meta-schemas are removed.
     * Even if schema is referenced by other schemas it still can be removed as other schemas have local references.
     * @this   Ajv
     * @param  {String|Object|RegExp} schemaKeyRef key, ref, pattern to match key/ref or schema object
     * @return {Ajv} this for method chaining
     */
    function removeSchema(schemaKeyRef) {
        if (schemaKeyRef instanceof RegExp) {
            _removeAllSchemas(this, this._schemas, schemaKeyRef);
            _removeAllSchemas(this, this._refs, schemaKeyRef);
            return this;
        }
        switch (typeof schemaKeyRef) {
            case 'undefined':
                _removeAllSchemas(this, this._schemas);
                _removeAllSchemas(this, this._refs);
                this._cache.clear();
                return this;
            case 'string':
                var schemaObj = _getSchemaObj(this, schemaKeyRef);
                if (schemaObj)
                    this._cache.del(schemaObj.cacheKey);
                delete this._schemas[schemaKeyRef];
                delete this._refs[schemaKeyRef];
                return this;
            case 'object':
                var serialize = this._opts.serialize;
                var cacheKey = serialize ? serialize(schemaKeyRef) : schemaKeyRef;
                this._cache.del(cacheKey);
                var id = this._getId(schemaKeyRef);
                if (id) {
                    id = resolve.normalizeId(id);
                    delete this._schemas[id];
                    delete this._refs[id];
                }
        }
        return this;
    }
    function _removeAllSchemas(self, schemas, regex) {
        for (var keyRef in schemas) {
            var schemaObj = schemas[keyRef];
            if (!schemaObj.meta && (!regex || regex.test(keyRef))) {
                self._cache.del(schemaObj.cacheKey);
                delete schemas[keyRef];
            }
        }
    }
    /* @this   Ajv */
    function _addSchema(schema, skipValidation, meta, shouldAddSchema) {
        if (typeof schema != 'object' && typeof schema != 'boolean')
            throw new Error('schema should be object or boolean');
        var serialize = this._opts.serialize;
        var cacheKey = serialize ? serialize(schema) : schema;
        var cached = this._cache.get(cacheKey);
        if (cached)
            return cached;
        shouldAddSchema = shouldAddSchema || this._opts.addUsedSchema !== false;
        var id = resolve.normalizeId(this._getId(schema));
        if (id && shouldAddSchema)
            checkUnique(this, id);
        var willValidate = this._opts.validateSchema !== false && !skipValidation;
        var recursiveMeta;
        if (willValidate && !(recursiveMeta = id && id == resolve.normalizeId(schema.$schema)))
            this.validateSchema(schema, true);
        var localRefs = resolve.ids.call(this, schema);
        var schemaObj = new SchemaObject({
            id: id,
            schema: schema,
            localRefs: localRefs,
            cacheKey: cacheKey,
            meta: meta
        });
        if (id[0] != '#' && shouldAddSchema)
            this._refs[id] = schemaObj;
        this._cache.put(cacheKey, schemaObj);
        if (willValidate && recursiveMeta)
            this.validateSchema(schema, true);
        return schemaObj;
    }
    /* @this   Ajv */
    function _compile(schemaObj, root) {
        if (schemaObj.compiling) {
            schemaObj.validate = callValidate;
            callValidate.schema = schemaObj.schema;
            callValidate.errors = null;
            callValidate.root = root ? root : callValidate;
            if (schemaObj.schema.$async === true)
                callValidate.$async = true;
            return callValidate;
        }
        schemaObj.compiling = true;
        var currentOpts;
        if (schemaObj.meta) {
            currentOpts = this._opts;
            this._opts = this._metaOpts;
        }
        var v;
        try {
            v = compileSchema.call(this, schemaObj.schema, root, schemaObj.localRefs);
        }
        finally {
            schemaObj.compiling = false;
            if (schemaObj.meta)
                this._opts = currentOpts;
        }
        schemaObj.validate = v;
        schemaObj.refs = v.refs;
        schemaObj.refVal = v.refVal;
        schemaObj.root = v.root;
        return v;
        function callValidate() {
            var _validate = schemaObj.validate;
            var result = _validate.apply(null, arguments);
            callValidate.errors = _validate.errors;
            return result;
        }
    }
    function chooseGetId(opts) {
        switch (opts.schemaId) {
            case '$id': return _get$Id;
            case 'id': return _getId;
            default: return _get$IdOrId;
        }
    }
    /* @this   Ajv */
    function _getId(schema) {
        if (schema.$id)
            this.logger.warn('schema $id ignored', schema.$id);
        return schema.id;
    }
    /* @this   Ajv */
    function _get$Id(schema) {
        if (schema.id)
            this.logger.warn('schema id ignored', schema.id);
        return schema.$id;
    }
    function _get$IdOrId(schema) {
        if (schema.$id && schema.id && schema.$id != schema.id)
            throw new Error('schema $id is different from id');
        return schema.$id || schema.id;
    }
    /**
     * Convert array of error message objects to string
     * @this   Ajv
     * @param  {Array<Object>} errors optional array of validation errors, if not passed errors from the instance are used.
     * @param  {Object} options optional options with properties `separator` and `dataVar`.
     * @return {String} human readable string with all errors descriptions
     */
    function errorsText(errors, options) {
        errors = errors || this.errors;
        if (!errors)
            return 'No errors';
        options = options || {};
        var separator = options.separator === undefined ? ', ' : options.separator;
        var dataVar = options.dataVar === undefined ? 'data' : options.dataVar;
        var text = '';
        for (var i = 0; i < errors.length; i++) {
            var e = errors[i];
            if (e)
                text += dataVar + e.dataPath + ' ' + e.message + separator;
        }
        return text.slice(0, -separator.length);
    }
    /**
     * Add custom format
     * @this   Ajv
     * @param {String} name format name
     * @param {String|RegExp|Function} format string is converted to RegExp; function should return boolean (true when valid)
     * @return {Ajv} this for method chaining
     */
    function addFormat(name, format) {
        if (typeof format == 'string')
            format = new RegExp(format);
        this._formats[name] = format;
        return this;
    }
    function addDraft6MetaSchema(self) {
        var $dataSchema;
        if (self._opts.$data) {
            $dataSchema = require(40) /* ./refs/$data.json */;
            self.addMetaSchema($dataSchema, $dataSchema.$id, true);
        }
        if (self._opts.meta === false)
            return;
        var metaSchema = require(41) /* ./refs/json-schema-draft-06.json */;
        if (self._opts.$data)
            metaSchema = $dataMetaSchema(metaSchema, META_SUPPORT_DATA);
        self.addMetaSchema(metaSchema, META_SCHEMA_ID, true);
        self._refs['http://json-schema.org/schema'] = META_SCHEMA_ID;
    }
    function addInitialSchemas(self) {
        var optsSchemas = self._opts.schemas;
        if (!optsSchemas)
            return;
        if (Array.isArray(optsSchemas))
            self.addSchema(optsSchemas);
        else
            for (var key in optsSchemas)
                self.addSchema(optsSchemas[key], key);
    }
    function addInitialFormats(self) {
        for (var name in self._opts.formats) {
            var format = self._opts.formats[name];
            self.addFormat(name, format);
        }
    }
    function checkUnique(self, id) {
        if (self._schemas[id] || self._refs[id])
            throw new Error('schema with key or id "' + id + '" already exists');
    }
    function getMetaSchemaOptions(self) {
        var metaOpts = util.copy(self._opts);
        for (var i = 0; i < META_IGNORE_OPTIONS.length; i++)
            delete metaOpts[META_IGNORE_OPTIONS[i]];
        return metaOpts;
    }
    function setLogger(self) {
        var logger = self._opts.logger;
        if (logger === false) {
            self.logger = { log: noop, warn: noop, error: noop };
        }
        else {
            if (logger === undefined)
                logger = console;
            if (!(typeof logger == 'object' && logger.log && logger.warn && logger.error))
                throw new Error('logger must implement log, warn and error methods');
            self.logger = logger;
        }
    }
    function noop() { }
}
,
/* ajv/lib/cache */ function _(require, module, exports) {
    var Cache = module.exports = function Cache() {
        this._cache = {};
    };
    Cache.prototype.put = function Cache_put(key, value) {
        this._cache[key] = value;
    };
    Cache.prototype.get = function Cache_get(key) {
        return this._cache[key];
    };
    Cache.prototype.del = function Cache_del(key) {
        delete this._cache[key];
    };
    Cache.prototype.clear = function Cache_clear() {
        this._cache = {};
    };
}
,
/* ajv/lib/compile/_rules */ function _(require, module, exports) {
    //all requires must be explicit because browserify won't work with dynamic requires
    module.exports = {
        '$ref': require(34) /* ../dotjs/ref */,
        allOf: require(19) /* ../dotjs/allOf */,
        anyOf: require(20) /* ../dotjs/anyOf */,
        const: require(21) /* ../dotjs/const */,
        contains: require(22) /* ../dotjs/contains */,
        dependencies: require(24) /* ../dotjs/dependencies */,
        'enum': require(25) /* ../dotjs/enum */,
        format: require(26) /* ../dotjs/format */,
        items: require(27) /* ../dotjs/items */,
        maximum: require(15) /* ../dotjs/_limit */,
        minimum: require(15) /* ../dotjs/_limit */,
        maxItems: require(16) /* ../dotjs/_limitItems */,
        minItems: require(16) /* ../dotjs/_limitItems */,
        maxLength: require(17) /* ../dotjs/_limitLength */,
        minLength: require(17) /* ../dotjs/_limitLength */,
        maxProperties: require(18) /* ../dotjs/_limitProperties */,
        minProperties: require(18) /* ../dotjs/_limitProperties */,
        multipleOf: require(28) /* ../dotjs/multipleOf */,
        not: require(29) /* ../dotjs/not */,
        oneOf: require(30) /* ../dotjs/oneOf */,
        pattern: require(31) /* ../dotjs/pattern */,
        properties: require(32) /* ../dotjs/properties */,
        propertyNames: require(33) /* ../dotjs/propertyNames */,
        required: require(35) /* ../dotjs/required */,
        uniqueItems: require(36) /* ../dotjs/uniqueItems */,
        validate: require(37) /* ../dotjs/validate */
    };
}
,
/* ajv/lib/compile/async */ function _(require, module, exports) {
    var MissingRefError = require(7) /* ./error_classes */.MissingRef;
    module.exports = compileAsync;
    /**
     * Creates validating function for passed schema with asynchronous loading of missing schemas.
     * `loadSchema` option should be a function that accepts schema uri and returns promise that resolves with the schema.
     * @this  Ajv
     * @param {Object}   schema schema object
     * @param {Boolean}  meta optional true to compile meta-schema; this parameter can be skipped
     * @param {Function} callback an optional node-style callback, it is called with 2 parameters: error (or null) and validating function.
     * @return {Promise} promise that resolves with a validating function.
     */
    function compileAsync(schema, meta, callback) {
        /* eslint no-shadow: 0 */
        /* global Promise */
        /* jshint validthis: true */
        var self = this;
        if (typeof this._opts.loadSchema != 'function')
            throw new Error('options.loadSchema should be a function');
        if (typeof meta == 'function') {
            callback = meta;
            meta = undefined;
        }
        var p = loadMetaSchemaOf(schema).then(function () {
            var schemaObj = self._addSchema(schema, undefined, meta);
            return schemaObj.validate || _compileAsync(schemaObj);
        });
        if (callback) {
            p.then(function (v) { callback(null, v); }, callback);
        }
        return p;
        function loadMetaSchemaOf(sch) {
            var $schema = sch.$schema;
            return $schema && !self.getSchema($schema)
                ? compileAsync.call(self, { $ref: $schema }, true)
                : Promise.resolve();
        }
        function _compileAsync(schemaObj) {
            try {
                return self._compile(schemaObj);
            }
            catch (e) {
                if (e instanceof MissingRefError)
                    return loadMissingSchema(e);
                throw e;
            }
            function loadMissingSchema(e) {
                var ref = e.missingSchema;
                if (added(ref))
                    throw new Error('Schema ' + ref + ' is loaded but ' + e.missingRef + ' cannot be resolved');
                var schemaPromise = self._loadingSchemas[ref];
                if (!schemaPromise) {
                    schemaPromise = self._loadingSchemas[ref] = self._opts.loadSchema(ref);
                    schemaPromise.then(removePromise, removePromise);
                }
                return schemaPromise.then(function (sch) {
                    if (!added(ref)) {
                        return loadMetaSchemaOf(sch).then(function () {
                            if (!added(ref))
                                self.addSchema(sch, ref, undefined, meta);
                        });
                    }
                }).then(function () {
                    return _compileAsync(schemaObj);
                });
                function removePromise() {
                    delete self._loadingSchemas[ref];
                }
                function added(ref) {
                    return self._refs[ref] || self._schemas[ref];
                }
            }
        }
    }
}
,
/* ajv/lib/compile/error_classes */ function _(require, module, exports) {
    var resolve = require(10) /* ./resolve */;
    module.exports = {
        Validation: errorSubclass(ValidationError),
        MissingRef: errorSubclass(MissingRefError)
    };
    function ValidationError(errors) {
        this.message = 'validation failed';
        this.errors = errors;
        this.ajv = this.validation = true;
    }
    MissingRefError.message = function (baseId, ref) {
        return 'can\'t resolve reference ' + ref + ' from id ' + baseId;
    };
    function MissingRefError(baseId, ref, message) {
        this.message = message || MissingRefError.message(baseId, ref);
        this.missingRef = resolve.url(baseId, ref);
        this.missingSchema = resolve.normalizeId(resolve.fullPath(this.missingRef));
    }
    function errorSubclass(Subclass) {
        Subclass.prototype = Object.create(Error.prototype);
        Subclass.prototype.constructor = Subclass;
        return Subclass;
    }
}
,
/* ajv/lib/compile/formats */ function _(require, module, exports) {
    var util = require(14) /* ./util */;
    var DATE = /^\d\d\d\d-(\d\d)-(\d\d)$/;
    var DAYS = [0, 31, 29, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31];
    var TIME = /^(\d\d):(\d\d):(\d\d)(\.\d+)?(z|[+-]\d\d:\d\d)?$/i;
    var HOSTNAME = /^[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[-0-9a-z]{0,61}[0-9a-z])?)*$/i;
    var URI = /^(?:[a-z][a-z0-9+\-.]*:)(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'()*+,;=:@]|%[0-9a-f]{2})*)*)(?:\?(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
    var URIREF = /^(?:[a-z][a-z0-9+\-.]*:)?(?:\/?\/(?:(?:[a-z0-9\-._~!$&'()*+,;=:]|%[0-9a-f]{2})*@)?(?:\[(?:(?:(?:(?:[0-9a-f]{1,4}:){6}|::(?:[0-9a-f]{1,4}:){5}|(?:[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){4}|(?:(?:[0-9a-f]{1,4}:){0,1}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){3}|(?:(?:[0-9a-f]{1,4}:){0,2}[0-9a-f]{1,4})?::(?:[0-9a-f]{1,4}:){2}|(?:(?:[0-9a-f]{1,4}:){0,3}[0-9a-f]{1,4})?::[0-9a-f]{1,4}:|(?:(?:[0-9a-f]{1,4}:){0,4}[0-9a-f]{1,4})?::)(?:[0-9a-f]{1,4}:[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?))|(?:(?:[0-9a-f]{1,4}:){0,5}[0-9a-f]{1,4})?::[0-9a-f]{1,4}|(?:(?:[0-9a-f]{1,4}:){0,6}[0-9a-f]{1,4})?::)|[Vv][0-9a-f]+\.[a-z0-9\-._~!$&'()*+,;=:]+)\]|(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)|(?:[a-z0-9\-._~!$&'"()*+,;=]|%[0-9a-f]{2})*)(?::\d*)?(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*|\/(?:(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?|(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})+(?:\/(?:[a-z0-9\-._~!$&'"()*+,;=:@]|%[0-9a-f]{2})*)*)?(?:\?(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?(?:#(?:[a-z0-9\-._~!$&'"()*+,;=:@/?]|%[0-9a-f]{2})*)?$/i;
    // uri-template: https://tools.ietf.org/html/rfc6570
    var URITEMPLATE = /^(?:(?:[^\x00-\x20"'<>%\\^`{|}]|%[0-9a-f]{2})|\{[+#./;?&=,!@|]?(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?(?:,(?:[a-z0-9_]|%[0-9a-f]{2})+(?::[1-9][0-9]{0,3}|\*)?)*\})*$/i;
    // For the source: https://gist.github.com/dperini/729294
    // For test cases: https://mathiasbynens.be/demo/url-regex
    // @todo Delete current URL in favour of the commented out URL rule when this issue is fixed https://github.com/eslint/eslint/issues/7983.
    // var URL = /^(?:(?:https?|ftp):\/\/)(?:\S+(?::\S*)?@)?(?:(?!10(?:\.\d{1,3}){3})(?!127(?:\.\d{1,3}){3})(?!169\.254(?:\.\d{1,3}){2})(?!192\.168(?:\.\d{1,3}){2})(?!172\.(?:1[6-9]|2\d|3[0-1])(?:\.\d{1,3}){2})(?:[1-9]\d?|1\d\d|2[01]\d|22[0-3])(?:\.(?:1?\d{1,2}|2[0-4]\d|25[0-5])){2}(?:\.(?:[1-9]\d?|1\d\d|2[0-4]\d|25[0-4]))|(?:(?:[a-z\u{00a1}-\u{ffff}0-9]+-?)*[a-z\u{00a1}-\u{ffff}0-9]+)(?:\.(?:[a-z\u{00a1}-\u{ffff}0-9]+-?)*[a-z\u{00a1}-\u{ffff}0-9]+)*(?:\.(?:[a-z\u{00a1}-\u{ffff}]{2,})))(?::\d{2,5})?(?:\/[^\s]*)?$/iu;
    var URL = /^(?:(?:http[s\u017F]?|ftp):\/\/)(?:(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+(?::(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?@)?(?:(?!10(?:\.[0-9]{1,3}){3})(?!127(?:\.[0-9]{1,3}){3})(?!169\.254(?:\.[0-9]{1,3}){2})(?!192\.168(?:\.[0-9]{1,3}){2})(?!172\.(?:1[6-9]|2[0-9]|3[01])(?:\.[0-9]{1,3}){2})(?:[1-9][0-9]?|1[0-9][0-9]|2[01][0-9]|22[0-3])(?:\.(?:1?[0-9]{1,2}|2[0-4][0-9]|25[0-5])){2}(?:\.(?:[1-9][0-9]?|1[0-9][0-9]|2[0-4][0-9]|25[0-4]))|(?:(?:(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-?)*(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)(?:\.(?:(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+-?)*(?:[0-9KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])+)*(?:\.(?:(?:[KSa-z\xA1-\uD7FF\uE000-\uFFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF]){2,})))(?::[0-9]{2,5})?(?:\/(?:[\0-\x08\x0E-\x1F!-\x9F\xA1-\u167F\u1681-\u1FFF\u200B-\u2027\u202A-\u202E\u2030-\u205E\u2060-\u2FFF\u3001-\uD7FF\uE000-\uFEFE\uFF00-\uFFFF]|[\uD800-\uDBFF][\uDC00-\uDFFF]|[\uD800-\uDBFF](?![\uDC00-\uDFFF])|(?:[^\uD800-\uDBFF]|^)[\uDC00-\uDFFF])*)?$/i;
    var UUID = /^(?:urn:uuid:)?[0-9a-f]{8}-(?:[0-9a-f]{4}-){3}[0-9a-f]{12}$/i;
    var JSON_POINTER = /^(?:\/(?:[^~/]|~0|~1)*)*$|^#(?:\/(?:[a-z0-9_\-.!$&'()*+,;:=@]|%[0-9a-f]{2}|~0|~1)*)*$/i;
    var RELATIVE_JSON_POINTER = /^(?:0|[1-9][0-9]*)(?:#|(?:\/(?:[^~/]|~0|~1)*)*)$/;
    module.exports = formats;
    function formats(mode) {
        mode = mode == 'full' ? 'full' : 'fast';
        return util.copy(formats[mode]);
    }
    formats.fast = {
        // date: http://tools.ietf.org/html/rfc3339#section-5.6
        date: /^\d\d\d\d-[0-1]\d-[0-3]\d$/,
        // date-time: http://tools.ietf.org/html/rfc3339#section-5.6
        time: /^[0-2]\d:[0-5]\d:[0-5]\d(?:\.\d+)?(?:z|[+-]\d\d:\d\d)?$/i,
        'date-time': /^\d\d\d\d-[0-1]\d-[0-3]\d[t\s][0-2]\d:[0-5]\d:[0-5]\d(?:\.\d+)?(?:z|[+-]\d\d:\d\d)$/i,
        // uri: https://github.com/mafintosh/is-my-json-valid/blob/master/formats.js
        uri: /^(?:[a-z][a-z0-9+-.]*)(?::|\/)\/?[^\s]*$/i,
        'uri-reference': /^(?:(?:[a-z][a-z0-9+-.]*:)?\/\/)?[^\s]*$/i,
        'uri-template': URITEMPLATE,
        url: URL,
        // email (sources from jsen validator):
        // http://stackoverflow.com/questions/201323/using-a-regular-expression-to-validate-an-email-address#answer-8829363
        // http://www.w3.org/TR/html5/forms.html#valid-e-mail-address (search for 'willful violation')
        email: /^[a-z0-9.!#$%&'*+/=?^_`{|}~-]+@[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?(?:\.[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?)*$/i,
        hostname: HOSTNAME,
        // optimized https://www.safaribooksonline.com/library/view/regular-expressions-cookbook/9780596802837/ch07s16.html
        ipv4: /^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,
        // optimized http://stackoverflow.com/questions/53497/regular-expression-that-matches-valid-ipv6-addresses
        ipv6: /^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
        regex: regex,
        // uuid: http://tools.ietf.org/html/rfc4122
        uuid: UUID,
        // JSON-pointer: https://tools.ietf.org/html/rfc6901
        // uri fragment: https://tools.ietf.org/html/rfc3986#appendix-A
        'json-pointer': JSON_POINTER,
        // relative JSON-pointer: http://tools.ietf.org/html/draft-luff-relative-json-pointer-00
        'relative-json-pointer': RELATIVE_JSON_POINTER
    };
    formats.full = {
        date: date,
        time: time,
        'date-time': date_time,
        uri: uri,
        'uri-reference': URIREF,
        'uri-template': URITEMPLATE,
        url: URL,
        email: /^[a-z0-9!#$%&'*+/=?^_`{|}~-]+(?:\.[a-z0-9!#$%&''*+/=?^_`{|}~-]+)*@(?:[a-z0-9](?:[a-z0-9-]*[a-z0-9])?\.)+[a-z0-9](?:[a-z0-9-]*[a-z0-9])?$/i,
        hostname: hostname,
        ipv4: /^(?:(?:25[0-5]|2[0-4]\d|[01]?\d\d?)\.){3}(?:25[0-5]|2[0-4]\d|[01]?\d\d?)$/,
        ipv6: /^\s*(?:(?:(?:[0-9a-f]{1,4}:){7}(?:[0-9a-f]{1,4}|:))|(?:(?:[0-9a-f]{1,4}:){6}(?::[0-9a-f]{1,4}|(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){5}(?:(?:(?::[0-9a-f]{1,4}){1,2})|:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3})|:))|(?:(?:[0-9a-f]{1,4}:){4}(?:(?:(?::[0-9a-f]{1,4}){1,3})|(?:(?::[0-9a-f]{1,4})?:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){3}(?:(?:(?::[0-9a-f]{1,4}){1,4})|(?:(?::[0-9a-f]{1,4}){0,2}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){2}(?:(?:(?::[0-9a-f]{1,4}){1,5})|(?:(?::[0-9a-f]{1,4}){0,3}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?:(?:[0-9a-f]{1,4}:){1}(?:(?:(?::[0-9a-f]{1,4}){1,6})|(?:(?::[0-9a-f]{1,4}){0,4}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:))|(?::(?:(?:(?::[0-9a-f]{1,4}){1,7})|(?:(?::[0-9a-f]{1,4}){0,5}:(?:(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)(?:\.(?:25[0-5]|2[0-4]\d|1\d\d|[1-9]?\d)){3}))|:)))(?:%.+)?\s*$/i,
        regex: regex,
        uuid: UUID,
        'json-pointer': JSON_POINTER,
        'relative-json-pointer': RELATIVE_JSON_POINTER
    };
    function date(str) {
        // full-date from http://tools.ietf.org/html/rfc3339#section-5.6
        var matches = str.match(DATE);
        if (!matches)
            return false;
        var month = +matches[1];
        var day = +matches[2];
        return month >= 1 && month <= 12 && day >= 1 && day <= DAYS[month];
    }
    function time(str, full) {
        var matches = str.match(TIME);
        if (!matches)
            return false;
        var hour = matches[1];
        var minute = matches[2];
        var second = matches[3];
        var timeZone = matches[5];
        return hour <= 23 && minute <= 59 && second <= 59 && (!full || timeZone);
    }
    var DATE_TIME_SEPARATOR = /t|\s/i;
    function date_time(str) {
        // http://tools.ietf.org/html/rfc3339#section-5.6
        var dateTime = str.split(DATE_TIME_SEPARATOR);
        return dateTime.length == 2 && date(dateTime[0]) && time(dateTime[1], true);
    }
    function hostname(str) {
        // https://tools.ietf.org/html/rfc1034#section-3.5
        // https://tools.ietf.org/html/rfc1123#section-2
        return str.length <= 255 && HOSTNAME.test(str);
    }
    var NOT_URI_FRAGMENT = /\/|:/;
    function uri(str) {
        // http://jmrware.com/articles/2009/uri_regexp/URI_regex.html + optional protocol + required "."
        return NOT_URI_FRAGMENT.test(str) && URI.test(str);
    }
    var Z_ANCHOR = /[^\\]\\Z/;
    function regex(str) {
        if (Z_ANCHOR.test(str))
            return false;
        try {
            new RegExp(str);
            return true;
        }
        catch (e) {
            return false;
        }
    }
}
,
/* ajv/lib/compile/index */ function _(require, module, exports) {
    var resolve = require(10) /* ./resolve */, util = require(14) /* ./util */, errorClasses = require(7) /* ./error_classes */, stableStringify = require(109) /* fast-json-stable-stringify */;
    var validateGenerator = require(37) /* ../dotjs/validate */;
    /**
     * Functions below are used inside compiled validations function
     */
    var co = require(74) /* co */;
    var ucs2length = util.ucs2length;
    var equal = require(108) /* fast-deep-equal */;
    // this error is thrown by async schemas to return validation errors via exception
    var ValidationError = errorClasses.Validation;
    module.exports = compile;
    /**
     * Compiles schema to validation function
     * @this   Ajv
     * @param  {Object} schema schema object
     * @param  {Object} root object with information about the root schema for this schema
     * @param  {Object} localRefs the hash of local references inside the schema (created by resolve.id), used for inline resolution
     * @param  {String} baseId base ID for IDs in the schema
     * @return {Function} validation function
     */
    function compile(schema, root, localRefs, baseId) {
        /* jshint validthis: true, evil: true */
        /* eslint no-shadow: 0 */
        var self = this, opts = this._opts, refVal = [undefined], refs = {}, patterns = [], patternsHash = {}, defaults = [], defaultsHash = {}, customRules = [];
        root = root || { schema: schema, refVal: refVal, refs: refs };
        var c = checkCompiling.call(this, schema, root, baseId);
        var compilation = this._compilations[c.index];
        if (c.compiling)
            return (compilation.callValidate = callValidate);
        var formats = this._formats;
        var RULES = this.RULES;
        try {
            var v = localCompile(schema, root, localRefs, baseId);
            compilation.validate = v;
            var cv = compilation.callValidate;
            if (cv) {
                cv.schema = v.schema;
                cv.errors = null;
                cv.refs = v.refs;
                cv.refVal = v.refVal;
                cv.root = v.root;
                cv.$async = v.$async;
                if (opts.sourceCode)
                    cv.source = v.source;
            }
            return v;
        }
        finally {
            endCompiling.call(this, schema, root, baseId);
        }
        function callValidate() {
            var validate = compilation.validate;
            var result = validate.apply(null, arguments);
            callValidate.errors = validate.errors;
            return result;
        }
        function localCompile(_schema, _root, localRefs, baseId) {
            var isRoot = !_root || (_root && _root.schema == _schema);
            if (_root.schema != root.schema)
                return compile.call(self, _schema, _root, localRefs, baseId);
            var $async = _schema.$async === true;
            var sourceCode = validateGenerator({
                isTop: true,
                schema: _schema,
                isRoot: isRoot,
                baseId: baseId,
                root: _root,
                schemaPath: '',
                errSchemaPath: '#',
                errorPath: '""',
                MissingRefError: errorClasses.MissingRef,
                RULES: RULES,
                validate: validateGenerator,
                util: util,
                resolve: resolve,
                resolveRef: resolveRef,
                usePattern: usePattern,
                useDefault: useDefault,
                useCustomRule: useCustomRule,
                opts: opts,
                formats: formats,
                logger: self.logger,
                self: self
            });
            sourceCode = vars(refVal, refValCode) + vars(patterns, patternCode)
                + vars(defaults, defaultCode) + vars(customRules, customRuleCode)
                + sourceCode;
            if (opts.processCode)
                sourceCode = opts.processCode(sourceCode);
            // console.log('\n\n\n *** \n', JSON.stringify(sourceCode));
            var validate;
            try {
                var makeValidate = new Function('self', 'RULES', 'formats', 'root', 'refVal', 'defaults', 'customRules', 'co', 'equal', 'ucs2length', 'ValidationError', sourceCode);
                validate = makeValidate(self, RULES, formats, root, refVal, defaults, customRules, co, equal, ucs2length, ValidationError);
                refVal[0] = validate;
            }
            catch (e) {
                self.logger.error('Error compiling schema, function code:', sourceCode);
                throw e;
            }
            validate.schema = _schema;
            validate.errors = null;
            validate.refs = refs;
            validate.refVal = refVal;
            validate.root = isRoot ? validate : _root;
            if ($async)
                validate.$async = true;
            if (opts.sourceCode === true) {
                validate.source = {
                    code: sourceCode,
                    patterns: patterns,
                    defaults: defaults
                };
            }
            return validate;
        }
        function resolveRef(baseId, ref, isRoot) {
            ref = resolve.url(baseId, ref);
            var refIndex = refs[ref];
            var _refVal, refCode;
            if (refIndex !== undefined) {
                _refVal = refVal[refIndex];
                refCode = 'refVal[' + refIndex + ']';
                return resolvedRef(_refVal, refCode);
            }
            if (!isRoot && root.refs) {
                var rootRefId = root.refs[ref];
                if (rootRefId !== undefined) {
                    _refVal = root.refVal[rootRefId];
                    refCode = addLocalRef(ref, _refVal);
                    return resolvedRef(_refVal, refCode);
                }
            }
            refCode = addLocalRef(ref);
            var v = resolve.call(self, localCompile, root, ref);
            if (v === undefined) {
                var localSchema = localRefs && localRefs[ref];
                if (localSchema) {
                    v = resolve.inlineRef(localSchema, opts.inlineRefs)
                        ? localSchema
                        : compile.call(self, localSchema, root, localRefs, baseId);
                }
            }
            if (v === undefined) {
                removeLocalRef(ref);
            }
            else {
                replaceLocalRef(ref, v);
                return resolvedRef(v, refCode);
            }
        }
        function addLocalRef(ref, v) {
            var refId = refVal.length;
            refVal[refId] = v;
            refs[ref] = refId;
            return 'refVal' + refId;
        }
        function removeLocalRef(ref) {
            delete refs[ref];
        }
        function replaceLocalRef(ref, v) {
            var refId = refs[ref];
            refVal[refId] = v;
        }
        function resolvedRef(refVal, code) {
            return typeof refVal == 'object' || typeof refVal == 'boolean'
                ? { code: code, schema: refVal, inline: true }
                : { code: code, $async: refVal && refVal.$async };
        }
        function usePattern(regexStr) {
            var index = patternsHash[regexStr];
            if (index === undefined) {
                index = patternsHash[regexStr] = patterns.length;
                patterns[index] = regexStr;
            }
            return 'pattern' + index;
        }
        function useDefault(value) {
            switch (typeof value) {
                case 'boolean':
                case 'number':
                    return '' + value;
                case 'string':
                    return util.toQuotedString(value);
                case 'object':
                    if (value === null)
                        return 'null';
                    var valueStr = stableStringify(value);
                    var index = defaultsHash[valueStr];
                    if (index === undefined) {
                        index = defaultsHash[valueStr] = defaults.length;
                        defaults[index] = value;
                    }
                    return 'default' + index;
            }
        }
        function useCustomRule(rule, schema, parentSchema, it) {
            var validateSchema = rule.definition.validateSchema;
            if (validateSchema && self._opts.validateSchema !== false) {
                var valid = validateSchema(schema);
                if (!valid) {
                    var message = 'keyword schema is invalid: ' + self.errorsText(validateSchema.errors);
                    if (self._opts.validateSchema == 'log')
                        self.logger.error(message);
                    else
                        throw new Error(message);
                }
            }
            var compile = rule.definition.compile, inline = rule.definition.inline, macro = rule.definition.macro;
            var validate;
            if (compile) {
                validate = compile.call(self, schema, parentSchema, it);
            }
            else if (macro) {
                validate = macro.call(self, schema, parentSchema, it);
                if (opts.validateSchema !== false)
                    self.validateSchema(validate, true);
            }
            else if (inline) {
                validate = inline.call(self, it, rule.keyword, schema, parentSchema);
            }
            else {
                validate = rule.definition.validate;
                if (!validate)
                    return;
            }
            if (validate === undefined)
                throw new Error('custom keyword "' + rule.keyword + '"failed to compile');
            var index = customRules.length;
            customRules[index] = validate;
            return {
                code: 'customRule' + index,
                validate: validate
            };
        }
    }
    /**
     * Checks if the schema is currently compiled
     * @this   Ajv
     * @param  {Object} schema schema to compile
     * @param  {Object} root root object
     * @param  {String} baseId base schema ID
     * @return {Object} object with properties "index" (compilation index) and "compiling" (boolean)
     */
    function checkCompiling(schema, root, baseId) {
        /* jshint validthis: true */
        var index = compIndex.call(this, schema, root, baseId);
        if (index >= 0)
            return { index: index, compiling: true };
        index = this._compilations.length;
        this._compilations[index] = {
            schema: schema,
            root: root,
            baseId: baseId
        };
        return { index: index, compiling: false };
    }
    /**
     * Removes the schema from the currently compiled list
     * @this   Ajv
     * @param  {Object} schema schema to compile
     * @param  {Object} root root object
     * @param  {String} baseId base schema ID
     */
    function endCompiling(schema, root, baseId) {
        /* jshint validthis: true */
        var i = compIndex.call(this, schema, root, baseId);
        if (i >= 0)
            this._compilations.splice(i, 1);
    }
    /**
     * Index of schema compilation in the currently compiled list
     * @this   Ajv
     * @param  {Object} schema schema to compile
     * @param  {Object} root root object
     * @param  {String} baseId base schema ID
     * @return {Integer} compilation index
     */
    function compIndex(schema, root, baseId) {
        /* jshint validthis: true */
        for (var i = 0; i < this._compilations.length; i++) {
            var c = this._compilations[i];
            if (c.schema == schema && c.root == root && c.baseId == baseId)
                return i;
        }
        return -1;
    }
    function patternCode(i, patterns) {
        return 'var pattern' + i + ' = new RegExp(' + util.toQuotedString(patterns[i]) + ');';
    }
    function defaultCode(i) {
        return 'var default' + i + ' = defaults[' + i + '];';
    }
    function refValCode(i, refVal) {
        return refVal[i] === undefined ? '' : 'var refVal' + i + ' = refVal[' + i + '];';
    }
    function customRuleCode(i) {
        return 'var customRule' + i + ' = customRules[' + i + '];';
    }
    function vars(arr, statement) {
        if (!arr.length)
            return '';
        var code = '';
        for (var i = 0; i < arr.length; i++)
            code += statement(i, arr);
        return code;
    }
}
,
/* ajv/lib/compile/resolve */ function _(require, module, exports) {
    var url = require('url'), equal = require(108) /* fast-deep-equal */, util = require(14) /* ./util */, SchemaObject = require(12) /* ./schema_obj */, traverse = require(156) /* json-schema-traverse */;
    module.exports = resolve;
    resolve.normalizeId = normalizeId;
    resolve.fullPath = getFullPath;
    resolve.url = resolveUrl;
    resolve.ids = resolveIds;
    resolve.inlineRef = inlineRef;
    resolve.schema = resolveSchema;
    /**
     * [resolve and compile the references ($ref)]
     * @this   Ajv
     * @param  {Function} compile reference to schema compilation funciton (localCompile)
     * @param  {Object} root object with information about the root schema for the current schema
     * @param  {String} ref reference to resolve
     * @return {Object|Function} schema object (if the schema can be inlined) or validation function
     */
    function resolve(compile, root, ref) {
        /* jshint validthis: true */
        var refVal = this._refs[ref];
        if (typeof refVal == 'string') {
            if (this._refs[refVal])
                refVal = this._refs[refVal];
            else
                return resolve.call(this, compile, root, refVal);
        }
        refVal = refVal || this._schemas[ref];
        if (refVal instanceof SchemaObject) {
            return inlineRef(refVal.schema, this._opts.inlineRefs)
                ? refVal.schema
                : refVal.validate || this._compile(refVal);
        }
        var res = resolveSchema.call(this, root, ref);
        var schema, v, baseId;
        if (res) {
            schema = res.schema;
            root = res.root;
            baseId = res.baseId;
        }
        if (schema instanceof SchemaObject) {
            v = schema.validate || compile.call(this, schema.schema, root, undefined, baseId);
        }
        else if (schema !== undefined) {
            v = inlineRef(schema, this._opts.inlineRefs)
                ? schema
                : compile.call(this, schema, root, undefined, baseId);
        }
        return v;
    }
    /**
     * Resolve schema, its root and baseId
     * @this Ajv
     * @param  {Object} root root object with properties schema, refVal, refs
     * @param  {String} ref  reference to resolve
     * @return {Object} object with properties schema, root, baseId
     */
    function resolveSchema(root, ref) {
        /* jshint validthis: true */
        var p = url.parse(ref, false, true), refPath = _getFullPath(p), baseId = getFullPath(this._getId(root.schema));
        if (refPath !== baseId) {
            var id = normalizeId(refPath);
            var refVal = this._refs[id];
            if (typeof refVal == 'string') {
                return resolveRecursive.call(this, root, refVal, p);
            }
            else if (refVal instanceof SchemaObject) {
                if (!refVal.validate)
                    this._compile(refVal);
                root = refVal;
            }
            else {
                refVal = this._schemas[id];
                if (refVal instanceof SchemaObject) {
                    if (!refVal.validate)
                        this._compile(refVal);
                    if (id == normalizeId(ref))
                        return { schema: refVal, root: root, baseId: baseId };
                    root = refVal;
                }
                else {
                    return;
                }
            }
            if (!root.schema)
                return;
            baseId = getFullPath(this._getId(root.schema));
        }
        return getJsonPointer.call(this, p, baseId, root.schema, root);
    }
    /* @this Ajv */
    function resolveRecursive(root, ref, parsedRef) {
        /* jshint validthis: true */
        var res = resolveSchema.call(this, root, ref);
        if (res) {
            var schema = res.schema;
            var baseId = res.baseId;
            root = res.root;
            var id = this._getId(schema);
            if (id)
                baseId = resolveUrl(baseId, id);
            return getJsonPointer.call(this, parsedRef, baseId, schema, root);
        }
    }
    var PREVENT_SCOPE_CHANGE = util.toHash(['properties', 'patternProperties', 'enum', 'dependencies', 'definitions']);
    /* @this Ajv */
    function getJsonPointer(parsedRef, baseId, schema, root) {
        /* jshint validthis: true */
        parsedRef.hash = parsedRef.hash || '';
        if (parsedRef.hash.slice(0, 2) != '#/')
            return;
        var parts = parsedRef.hash.split('/');
        for (var i = 1; i < parts.length; i++) {
            var part = parts[i];
            if (part) {
                part = util.unescapeFragment(part);
                schema = schema[part];
                if (schema === undefined)
                    break;
                var id;
                if (!PREVENT_SCOPE_CHANGE[part]) {
                    id = this._getId(schema);
                    if (id)
                        baseId = resolveUrl(baseId, id);
                    if (schema.$ref) {
                        var $ref = resolveUrl(baseId, schema.$ref);
                        var res = resolveSchema.call(this, root, $ref);
                        if (res) {
                            schema = res.schema;
                            root = res.root;
                            baseId = res.baseId;
                        }
                    }
                }
            }
        }
        if (schema !== undefined && schema !== root.schema)
            return { schema: schema, root: root, baseId: baseId };
    }
    var SIMPLE_INLINED = util.toHash([
        'type', 'format', 'pattern',
        'maxLength', 'minLength',
        'maxProperties', 'minProperties',
        'maxItems', 'minItems',
        'maximum', 'minimum',
        'uniqueItems', 'multipleOf',
        'required', 'enum'
    ]);
    function inlineRef(schema, limit) {
        if (limit === false)
            return false;
        if (limit === undefined || limit === true)
            return checkNoRef(schema);
        else if (limit)
            return countKeys(schema) <= limit;
    }
    function checkNoRef(schema) {
        var item;
        if (Array.isArray(schema)) {
            for (var i = 0; i < schema.length; i++) {
                item = schema[i];
                if (typeof item == 'object' && !checkNoRef(item))
                    return false;
            }
        }
        else {
            for (var key in schema) {
                if (key == '$ref')
                    return false;
                item = schema[key];
                if (typeof item == 'object' && !checkNoRef(item))
                    return false;
            }
        }
        return true;
    }
    function countKeys(schema) {
        var count = 0, item;
        if (Array.isArray(schema)) {
            for (var i = 0; i < schema.length; i++) {
                item = schema[i];
                if (typeof item == 'object')
                    count += countKeys(item);
                if (count == Infinity)
                    return Infinity;
            }
        }
        else {
            for (var key in schema) {
                if (key == '$ref')
                    return Infinity;
                if (SIMPLE_INLINED[key]) {
                    count++;
                }
                else {
                    item = schema[key];
                    if (typeof item == 'object')
                        count += countKeys(item) + 1;
                    if (count == Infinity)
                        return Infinity;
                }
            }
        }
        return count;
    }
    function getFullPath(id, normalize) {
        if (normalize !== false)
            id = normalizeId(id);
        var p = url.parse(id, false, true);
        return _getFullPath(p);
    }
    function _getFullPath(p) {
        var protocolSeparator = p.protocol || p.href.slice(0, 2) == '//' ? '//' : '';
        return (p.protocol || '') + protocolSeparator + (p.host || '') + (p.path || '') + '#';
    }
    var TRAILING_SLASH_HASH = /#\/?$/;
    function normalizeId(id) {
        return id ? id.replace(TRAILING_SLASH_HASH, '') : '';
    }
    function resolveUrl(baseId, id) {
        id = normalizeId(id);
        return url.resolve(baseId, id);
    }
    /* @this Ajv */
    function resolveIds(schema) {
        var schemaId = normalizeId(this._getId(schema));
        var baseIds = { '': schemaId };
        var fullPaths = { '': getFullPath(schemaId, false) };
        var localRefs = {};
        var self = this;
        traverse(schema, { allKeys: true }, function (sch, jsonPtr, rootSchema, parentJsonPtr, parentKeyword, parentSchema, keyIndex) {
            if (jsonPtr === '')
                return;
            var id = self._getId(sch);
            var baseId = baseIds[parentJsonPtr];
            var fullPath = fullPaths[parentJsonPtr] + '/' + parentKeyword;
            if (keyIndex !== undefined)
                fullPath += '/' + (typeof keyIndex == 'number' ? keyIndex : util.escapeFragment(keyIndex));
            if (typeof id == 'string') {
                id = baseId = normalizeId(baseId ? url.resolve(baseId, id) : id);
                var refVal = self._refs[id];
                if (typeof refVal == 'string')
                    refVal = self._refs[refVal];
                if (refVal && refVal.schema) {
                    if (!equal(sch, refVal.schema))
                        throw new Error('id "' + id + '" resolves to more than one schema');
                }
                else if (id != normalizeId(fullPath)) {
                    if (id[0] == '#') {
                        if (localRefs[id] && !equal(sch, localRefs[id]))
                            throw new Error('id "' + id + '" resolves to more than one schema');
                        localRefs[id] = sch;
                    }
                    else {
                        self._refs[id] = fullPath;
                    }
                }
            }
            baseIds[jsonPtr] = baseId;
            fullPaths[jsonPtr] = fullPath;
        });
        return localRefs;
    }
}
,
/* ajv/lib/compile/rules */ function _(require, module, exports) {
    var ruleModules = require(5) /* ./_rules */, toHash = require(14) /* ./util */.toHash;
    module.exports = function rules() {
        var RULES = [
            { type: 'number',
                rules: [{ 'maximum': ['exclusiveMaximum'] },
                    { 'minimum': ['exclusiveMinimum'] }, 'multipleOf', 'format'] },
            { type: 'string',
                rules: ['maxLength', 'minLength', 'pattern', 'format'] },
            { type: 'array',
                rules: ['maxItems', 'minItems', 'uniqueItems', 'contains', 'items'] },
            { type: 'object',
                rules: ['maxProperties', 'minProperties', 'required', 'dependencies', 'propertyNames',
                    { 'properties': ['additionalProperties', 'patternProperties'] }] },
            { rules: ['$ref', 'const', 'enum', 'not', 'anyOf', 'oneOf', 'allOf'] }
        ];
        var ALL = ['type'];
        var KEYWORDS = [
            'additionalItems', '$schema', '$id', 'id', 'title',
            'description', 'default', 'definitions'
        ];
        var TYPES = ['number', 'integer', 'string', 'array', 'object', 'boolean', 'null'];
        RULES.all = toHash(ALL);
        RULES.types = toHash(TYPES);
        RULES.forEach(function (group) {
            group.rules = group.rules.map(function (keyword) {
                var implKeywords;
                if (typeof keyword == 'object') {
                    var key = Object.keys(keyword)[0];
                    implKeywords = keyword[key];
                    keyword = key;
                    implKeywords.forEach(function (k) {
                        ALL.push(k);
                        RULES.all[k] = true;
                    });
                }
                ALL.push(keyword);
                var rule = RULES.all[keyword] = {
                    keyword: keyword,
                    code: ruleModules[keyword],
                    implements: implKeywords
                };
                return rule;
            });
            if (group.type)
                RULES.types[group.type] = group;
        });
        RULES.keywords = toHash(ALL.concat(KEYWORDS));
        RULES.custom = {};
        return RULES;
    };
}
,
/* ajv/lib/compile/schema_obj */ function _(require, module, exports) {
    var util = require(14) /* ./util */;
    module.exports = SchemaObject;
    function SchemaObject(obj) {
        util.copy(obj, this);
    }
}
,
/* ajv/lib/compile/ucs2length */ function _(require, module, exports) {
    // https://mathiasbynens.be/notes/javascript-encoding
    // https://github.com/bestiejs/punycode.js - punycode.ucs2.decode
    module.exports = function ucs2length(str) {
        var length = 0, len = str.length, pos = 0, value;
        while (pos < len) {
            length++;
            value = str.charCodeAt(pos++);
            if (value >= 0xD800 && value <= 0xDBFF && pos < len) {
                // high surrogate, and there is a next character
                value = str.charCodeAt(pos);
                if ((value & 0xFC00) == 0xDC00)
                    pos++; // low surrogate
            }
        }
        return length;
    };
}
,
/* ajv/lib/compile/util */ function _(require, module, exports) {
    module.exports = {
        copy: copy,
        checkDataType: checkDataType,
        checkDataTypes: checkDataTypes,
        coerceToTypes: coerceToTypes,
        toHash: toHash,
        getProperty: getProperty,
        escapeQuotes: escapeQuotes,
        equal: require(108) /* fast-deep-equal */,
        ucs2length: require(13) /* ./ucs2length */,
        varOccurences: varOccurences,
        varReplace: varReplace,
        cleanUpCode: cleanUpCode,
        finalCleanUpCode: finalCleanUpCode,
        schemaHasRules: schemaHasRules,
        schemaHasRulesExcept: schemaHasRulesExcept,
        toQuotedString: toQuotedString,
        getPathExpr: getPathExpr,
        getPath: getPath,
        getData: getData,
        unescapeFragment: unescapeFragment,
        unescapeJsonPointer: unescapeJsonPointer,
        escapeFragment: escapeFragment,
        escapeJsonPointer: escapeJsonPointer
    };
    function copy(o, to) {
        to = to || {};
        for (var key in o)
            to[key] = o[key];
        return to;
    }
    function checkDataType(dataType, data, negate) {
        var EQUAL = negate ? ' !== ' : ' === ', AND = negate ? ' || ' : ' && ', OK = negate ? '!' : '', NOT = negate ? '' : '!';
        switch (dataType) {
            case 'null': return data + EQUAL + 'null';
            case 'array': return OK + 'Array.isArray(' + data + ')';
            case 'object': return '(' + OK + data + AND +
                'typeof ' + data + EQUAL + '"object"' + AND +
                NOT + 'Array.isArray(' + data + '))';
            case 'integer': return '(typeof ' + data + EQUAL + '"number"' + AND +
                NOT + '(' + data + ' % 1)' +
                AND + data + EQUAL + data + ')';
            default: return 'typeof ' + data + EQUAL + '"' + dataType + '"';
        }
    }
    function checkDataTypes(dataTypes, data) {
        switch (dataTypes.length) {
            case 1: return checkDataType(dataTypes[0], data, true);
            default:
                var code = '';
                var types = toHash(dataTypes);
                if (types.array && types.object) {
                    code = types.null ? '(' : '(!' + data + ' || ';
                    code += 'typeof ' + data + ' !== "object")';
                    delete types.null;
                    delete types.array;
                    delete types.object;
                }
                if (types.number)
                    delete types.integer;
                for (var t in types)
                    code += (code ? ' && ' : '') + checkDataType(t, data, true);
                return code;
        }
    }
    var COERCE_TO_TYPES = toHash(['string', 'number', 'integer', 'boolean', 'null']);
    function coerceToTypes(optionCoerceTypes, dataTypes) {
        if (Array.isArray(dataTypes)) {
            var types = [];
            for (var i = 0; i < dataTypes.length; i++) {
                var t = dataTypes[i];
                if (COERCE_TO_TYPES[t])
                    types[types.length] = t;
                else if (optionCoerceTypes === 'array' && t === 'array')
                    types[types.length] = t;
            }
            if (types.length)
                return types;
        }
        else if (COERCE_TO_TYPES[dataTypes]) {
            return [dataTypes];
        }
        else if (optionCoerceTypes === 'array' && dataTypes === 'array') {
            return ['array'];
        }
    }
    function toHash(arr) {
        var hash = {};
        for (var i = 0; i < arr.length; i++)
            hash[arr[i]] = true;
        return hash;
    }
    var IDENTIFIER = /^[a-z$_][a-z$_0-9]*$/i;
    var SINGLE_QUOTE = /'|\\/g;
    function getProperty(key) {
        return typeof key == 'number'
            ? '[' + key + ']'
            : IDENTIFIER.test(key)
                ? '.' + key
                : "['" + escapeQuotes(key) + "']";
    }
    function escapeQuotes(str) {
        return str.replace(SINGLE_QUOTE, '\\$&')
            .replace(/\n/g, '\\n')
            .replace(/\r/g, '\\r')
            .replace(/\f/g, '\\f')
            .replace(/\t/g, '\\t');
    }
    function varOccurences(str, dataVar) {
        dataVar += '[^0-9]';
        var matches = str.match(new RegExp(dataVar, 'g'));
        return matches ? matches.length : 0;
    }
    function varReplace(str, dataVar, expr) {
        dataVar += '([^0-9])';
        expr = expr.replace(/\$/g, '$$$$');
        return str.replace(new RegExp(dataVar, 'g'), expr + '$1');
    }
    var EMPTY_ELSE = /else\s*{\s*}/g, EMPTY_IF_NO_ELSE = /if\s*\([^)]+\)\s*\{\s*\}(?!\s*else)/g, EMPTY_IF_WITH_ELSE = /if\s*\(([^)]+)\)\s*\{\s*\}\s*else(?!\s*if)/g;
    function cleanUpCode(out) {
        return out.replace(EMPTY_ELSE, '')
            .replace(EMPTY_IF_NO_ELSE, '')
            .replace(EMPTY_IF_WITH_ELSE, 'if (!($1))');
    }
    var ERRORS_REGEXP = /[^v.]errors/g, REMOVE_ERRORS = /var errors = 0;|var vErrors = null;|validate.errors = vErrors;/g, REMOVE_ERRORS_ASYNC = /var errors = 0;|var vErrors = null;/g, RETURN_VALID = 'return errors === 0;', RETURN_TRUE = 'validate.errors = null; return true;', RETURN_ASYNC = /if \(errors === 0\) return data;\s*else throw new ValidationError\(vErrors\);/, RETURN_DATA_ASYNC = 'return data;', ROOTDATA_REGEXP = /[^A-Za-z_$]rootData[^A-Za-z0-9_$]/g, REMOVE_ROOTDATA = /if \(rootData === undefined\) rootData = data;/;
    function finalCleanUpCode(out, async) {
        var matches = out.match(ERRORS_REGEXP);
        if (matches && matches.length == 2) {
            out = async
                ? out.replace(REMOVE_ERRORS_ASYNC, '')
                    .replace(RETURN_ASYNC, RETURN_DATA_ASYNC)
                : out.replace(REMOVE_ERRORS, '')
                    .replace(RETURN_VALID, RETURN_TRUE);
        }
        matches = out.match(ROOTDATA_REGEXP);
        if (!matches || matches.length !== 3)
            return out;
        return out.replace(REMOVE_ROOTDATA, '');
    }
    function schemaHasRules(schema, rules) {
        if (typeof schema == 'boolean')
            return !schema;
        for (var key in schema)
            if (rules[key])
                return true;
    }
    function schemaHasRulesExcept(schema, rules, exceptKeyword) {
        if (typeof schema == 'boolean')
            return !schema && exceptKeyword != 'not';
        for (var key in schema)
            if (key != exceptKeyword && rules[key])
                return true;
    }
    function toQuotedString(str) {
        return '\'' + escapeQuotes(str) + '\'';
    }
    function getPathExpr(currentPath, expr, jsonPointers, isNumber) {
        var path = jsonPointers // false by default
            ? '\'/\' + ' + expr + (isNumber ? '' : '.replace(/~/g, \'~0\').replace(/\\//g, \'~1\')')
            : (isNumber ? '\'[\' + ' + expr + ' + \']\'' : '\'[\\\'\' + ' + expr + ' + \'\\\']\'');
        return joinPaths(currentPath, path);
    }
    function getPath(currentPath, prop, jsonPointers) {
        var path = jsonPointers // false by default
            ? toQuotedString('/' + escapeJsonPointer(prop))
            : toQuotedString(getProperty(prop));
        return joinPaths(currentPath, path);
    }
    var JSON_POINTER = /^\/(?:[^~]|~0|~1)*$/;
    var RELATIVE_JSON_POINTER = /^([0-9]+)(#|\/(?:[^~]|~0|~1)*)?$/;
    function getData($data, lvl, paths) {
        var up, jsonPointer, data, matches;
        if ($data === '')
            return 'rootData';
        if ($data[0] == '/') {
            if (!JSON_POINTER.test($data))
                throw new Error('Invalid JSON-pointer: ' + $data);
            jsonPointer = $data;
            data = 'rootData';
        }
        else {
            matches = $data.match(RELATIVE_JSON_POINTER);
            if (!matches)
                throw new Error('Invalid JSON-pointer: ' + $data);
            up = +matches[1];
            jsonPointer = matches[2];
            if (jsonPointer == '#') {
                if (up >= lvl)
                    throw new Error('Cannot access property/index ' + up + ' levels up, current level is ' + lvl);
                return paths[lvl - up];
            }
            if (up > lvl)
                throw new Error('Cannot access data ' + up + ' levels up, current level is ' + lvl);
            data = 'data' + ((lvl - up) || '');
            if (!jsonPointer)
                return data;
        }
        var expr = data;
        var segments = jsonPointer.split('/');
        for (var i = 0; i < segments.length; i++) {
            var segment = segments[i];
            if (segment) {
                data += getProperty(unescapeJsonPointer(segment));
                expr += ' && ' + data;
            }
        }
        return expr;
    }
    function joinPaths(a, b) {
        if (a == '""')
            return b;
        return (a + ' + ' + b).replace(/' \+ '/g, '');
    }
    function unescapeFragment(str) {
        return unescapeJsonPointer(decodeURIComponent(str));
    }
    function escapeFragment(str) {
        return encodeURIComponent(escapeJsonPointer(str));
    }
    function escapeJsonPointer(str) {
        return str.replace(/~/g, '~0').replace(/\//g, '~1');
    }
    function unescapeJsonPointer(str) {
        return str.replace(/~1/g, '/').replace(/~0/g, '~');
    }
}
,
/* ajv/lib/dotjs/_limit */ function _(require, module, exports) {
    module.exports = function generate__limit(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $errorKeyword;
        var $data = 'data' + ($dataLvl || '');
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
            out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
            $schemaValue = 'schema' + $lvl;
        }
        else {
            $schemaValue = $schema;
        }
        var $isMax = $keyword == 'maximum', $exclusiveKeyword = $isMax ? 'exclusiveMaximum' : 'exclusiveMinimum', $schemaExcl = it.schema[$exclusiveKeyword], $isDataExcl = it.opts.$data && $schemaExcl && $schemaExcl.$data, $op = $isMax ? '<' : '>', $notOp = $isMax ? '>' : '<', $errorKeyword = undefined;
        if ($isDataExcl) {
            var $schemaValueExcl = it.util.getData($schemaExcl.$data, $dataLvl, it.dataPathArr), $exclusive = 'exclusive' + $lvl, $exclType = 'exclType' + $lvl, $exclIsNumber = 'exclIsNumber' + $lvl, $opExpr = 'op' + $lvl, $opStr = '\' + ' + $opExpr + ' + \'';
            out += ' var schemaExcl' + ($lvl) + ' = ' + ($schemaValueExcl) + '; ';
            $schemaValueExcl = 'schemaExcl' + $lvl;
            out += ' var ' + ($exclusive) + '; var ' + ($exclType) + ' = typeof ' + ($schemaValueExcl) + '; if (' + ($exclType) + ' != \'boolean\' && ' + ($exclType) + ' != \'undefined\' && ' + ($exclType) + ' != \'number\') { ';
            var $errorKeyword = $exclusiveKeyword;
            var $$outStack = $$outStack || [];
            $$outStack.push(out);
            out = ''; /* istanbul ignore else */
            if (it.createErrors !== false) {
                out += ' { keyword: \'' + ($errorKeyword || '_exclusiveLimit') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
                if (it.opts.messages !== false) {
                    out += ' , message: \'' + ($exclusiveKeyword) + ' should be boolean\' ';
                }
                if (it.opts.verbose) {
                    out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                }
                out += ' } ';
            }
            else {
                out += ' {} ';
            }
            var __err = out;
            out = $$outStack.pop();
            if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                if (it.async) {
                    out += ' throw new ValidationError([' + (__err) + ']); ';
                }
                else {
                    out += ' validate.errors = [' + (__err) + ']; return false; ';
                }
            }
            else {
                out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
            }
            out += ' } else if ( ';
            if ($isData) {
                out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
            }
            out += ' ' + ($exclType) + ' == \'number\' ? ( (' + ($exclusive) + ' = ' + ($schemaValue) + ' === undefined || ' + ($schemaValueExcl) + ' ' + ($op) + '= ' + ($schemaValue) + ') ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaValueExcl) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) : ( (' + ($exclusive) + ' = ' + ($schemaValueExcl) + ' === true) ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaValue) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) || ' + ($data) + ' !== ' + ($data) + ') { var op' + ($lvl) + ' = ' + ($exclusive) + ' ? \'' + ($op) + '\' : \'' + ($op) + '=\';';
        }
        else {
            var $exclIsNumber = typeof $schemaExcl == 'number', $opStr = $op;
            if ($exclIsNumber && $isData) {
                var $opExpr = '\'' + $opStr + '\'';
                out += ' if ( ';
                if ($isData) {
                    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
                }
                out += ' ( ' + ($schemaValue) + ' === undefined || ' + ($schemaExcl) + ' ' + ($op) + '= ' + ($schemaValue) + ' ? ' + ($data) + ' ' + ($notOp) + '= ' + ($schemaExcl) + ' : ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' ) || ' + ($data) + ' !== ' + ($data) + ') { ';
            }
            else {
                if ($exclIsNumber && $schema === undefined) {
                    $exclusive = true;
                    $errorKeyword = $exclusiveKeyword;
                    $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
                    $schemaValue = $schemaExcl;
                    $notOp += '=';
                }
                else {
                    if ($exclIsNumber)
                        $schemaValue = Math[$isMax ? 'min' : 'max']($schemaExcl, $schema);
                    if ($schemaExcl === ($exclIsNumber ? $schemaValue : true)) {
                        $exclusive = true;
                        $errorKeyword = $exclusiveKeyword;
                        $errSchemaPath = it.errSchemaPath + '/' + $exclusiveKeyword;
                        $notOp += '=';
                    }
                    else {
                        $exclusive = false;
                        $opStr += '=';
                    }
                }
                var $opExpr = '\'' + $opStr + '\'';
                out += ' if ( ';
                if ($isData) {
                    out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
                }
                out += ' ' + ($data) + ' ' + ($notOp) + ' ' + ($schemaValue) + ' || ' + ($data) + ' !== ' + ($data) + ') { ';
            }
        }
        $errorKeyword = $errorKeyword || $keyword;
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
            out += ' { keyword: \'' + ($errorKeyword || '_limit') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { comparison: ' + ($opExpr) + ', limit: ' + ($schemaValue) + ', exclusive: ' + ($exclusive) + ' } ';
            if (it.opts.messages !== false) {
                out += ' , message: \'should be ' + ($opStr) + ' ';
                if ($isData) {
                    out += '\' + ' + ($schemaValue);
                }
                else {
                    out += '' + ($schemaValue) + '\'';
                }
            }
            if (it.opts.verbose) {
                out += ' , schema:  ';
                if ($isData) {
                    out += 'validate.schema' + ($schemaPath);
                }
                else {
                    out += '' + ($schema);
                }
                out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
        }
        else {
            out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
            if (it.async) {
                out += ' throw new ValidationError([' + (__err) + ']); ';
            }
            else {
                out += ' validate.errors = [' + (__err) + ']; return false; ';
            }
        }
        else {
            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += ' } ';
        if ($breakOnError) {
            out += ' else { ';
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/_limitItems */ function _(require, module, exports) {
    module.exports = function generate__limitItems(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $errorKeyword;
        var $data = 'data' + ($dataLvl || '');
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
            out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
            $schemaValue = 'schema' + $lvl;
        }
        else {
            $schemaValue = $schema;
        }
        var $op = $keyword == 'maxItems' ? '>' : '<';
        out += 'if ( ';
        if ($isData) {
            out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
        }
        out += ' ' + ($data) + '.length ' + ($op) + ' ' + ($schemaValue) + ') { ';
        var $errorKeyword = $keyword;
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
            out += ' { keyword: \'' + ($errorKeyword || '_limitItems') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
            if (it.opts.messages !== false) {
                out += ' , message: \'should NOT have ';
                if ($keyword == 'maxItems') {
                    out += 'more';
                }
                else {
                    out += 'less';
                }
                out += ' than ';
                if ($isData) {
                    out += '\' + ' + ($schemaValue) + ' + \'';
                }
                else {
                    out += '' + ($schema);
                }
                out += ' items\' ';
            }
            if (it.opts.verbose) {
                out += ' , schema:  ';
                if ($isData) {
                    out += 'validate.schema' + ($schemaPath);
                }
                else {
                    out += '' + ($schema);
                }
                out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
        }
        else {
            out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
            if (it.async) {
                out += ' throw new ValidationError([' + (__err) + ']); ';
            }
            else {
                out += ' validate.errors = [' + (__err) + ']; return false; ';
            }
        }
        else {
            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += '} ';
        if ($breakOnError) {
            out += ' else { ';
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/_limitLength */ function _(require, module, exports) {
    module.exports = function generate__limitLength(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $errorKeyword;
        var $data = 'data' + ($dataLvl || '');
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
            out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
            $schemaValue = 'schema' + $lvl;
        }
        else {
            $schemaValue = $schema;
        }
        var $op = $keyword == 'maxLength' ? '>' : '<';
        out += 'if ( ';
        if ($isData) {
            out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
        }
        if (it.opts.unicode === false) {
            out += ' ' + ($data) + '.length ';
        }
        else {
            out += ' ucs2length(' + ($data) + ') ';
        }
        out += ' ' + ($op) + ' ' + ($schemaValue) + ') { ';
        var $errorKeyword = $keyword;
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
            out += ' { keyword: \'' + ($errorKeyword || '_limitLength') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
            if (it.opts.messages !== false) {
                out += ' , message: \'should NOT be ';
                if ($keyword == 'maxLength') {
                    out += 'longer';
                }
                else {
                    out += 'shorter';
                }
                out += ' than ';
                if ($isData) {
                    out += '\' + ' + ($schemaValue) + ' + \'';
                }
                else {
                    out += '' + ($schema);
                }
                out += ' characters\' ';
            }
            if (it.opts.verbose) {
                out += ' , schema:  ';
                if ($isData) {
                    out += 'validate.schema' + ($schemaPath);
                }
                else {
                    out += '' + ($schema);
                }
                out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
        }
        else {
            out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
            if (it.async) {
                out += ' throw new ValidationError([' + (__err) + ']); ';
            }
            else {
                out += ' validate.errors = [' + (__err) + ']; return false; ';
            }
        }
        else {
            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += '} ';
        if ($breakOnError) {
            out += ' else { ';
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/_limitProperties */ function _(require, module, exports) {
    module.exports = function generate__limitProperties(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $errorKeyword;
        var $data = 'data' + ($dataLvl || '');
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
            out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
            $schemaValue = 'schema' + $lvl;
        }
        else {
            $schemaValue = $schema;
        }
        var $op = $keyword == 'maxProperties' ? '>' : '<';
        out += 'if ( ';
        if ($isData) {
            out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'number\') || ';
        }
        out += ' Object.keys(' + ($data) + ').length ' + ($op) + ' ' + ($schemaValue) + ') { ';
        var $errorKeyword = $keyword;
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
            out += ' { keyword: \'' + ($errorKeyword || '_limitProperties') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schemaValue) + ' } ';
            if (it.opts.messages !== false) {
                out += ' , message: \'should NOT have ';
                if ($keyword == 'maxProperties') {
                    out += 'more';
                }
                else {
                    out += 'less';
                }
                out += ' than ';
                if ($isData) {
                    out += '\' + ' + ($schemaValue) + ' + \'';
                }
                else {
                    out += '' + ($schema);
                }
                out += ' properties\' ';
            }
            if (it.opts.verbose) {
                out += ' , schema:  ';
                if ($isData) {
                    out += 'validate.schema' + ($schemaPath);
                }
                else {
                    out += '' + ($schema);
                }
                out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
        }
        else {
            out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
            if (it.async) {
                out += ' throw new ValidationError([' + (__err) + ']); ';
            }
            else {
                out += ' validate.errors = [' + (__err) + ']; return false; ';
            }
        }
        else {
            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += '} ';
        if ($breakOnError) {
            out += ' else { ';
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/allOf */ function _(require, module, exports) {
    module.exports = function generate_allOf(it, $keyword, $ruleType) {
        var out = ' ';
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $it = it.util.copy(it);
        var $closingBraces = '';
        $it.level++;
        var $nextValid = 'valid' + $it.level;
        var $currentBaseId = $it.baseId, $allSchemasEmpty = true;
        var arr1 = $schema;
        if (arr1) {
            var $sch, $i = -1, l1 = arr1.length - 1;
            while ($i < l1) {
                $sch = arr1[$i += 1];
                if (it.util.schemaHasRules($sch, it.RULES.all)) {
                    $allSchemasEmpty = false;
                    $it.schema = $sch;
                    $it.schemaPath = $schemaPath + '[' + $i + ']';
                    $it.errSchemaPath = $errSchemaPath + '/' + $i;
                    out += '  ' + (it.validate($it)) + ' ';
                    $it.baseId = $currentBaseId;
                    if ($breakOnError) {
                        out += ' if (' + ($nextValid) + ') { ';
                        $closingBraces += '}';
                    }
                }
            }
        }
        if ($breakOnError) {
            if ($allSchemasEmpty) {
                out += ' if (true) { ';
            }
            else {
                out += ' ' + ($closingBraces.slice(0, -1)) + ' ';
            }
        }
        out = it.util.cleanUpCode(out);
        return out;
    };
}
,
/* ajv/lib/dotjs/anyOf */ function _(require, module, exports) {
    module.exports = function generate_anyOf(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $valid = 'valid' + $lvl;
        var $errs = 'errs__' + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = '';
        $it.level++;
        var $nextValid = 'valid' + $it.level;
        var $noEmptySchema = $schema.every(function ($sch) {
            return it.util.schemaHasRules($sch, it.RULES.all);
        });
        if ($noEmptySchema) {
            var $currentBaseId = $it.baseId;
            out += ' var ' + ($errs) + ' = errors; var ' + ($valid) + ' = false;  ';
            var $wasComposite = it.compositeRule;
            it.compositeRule = $it.compositeRule = true;
            var arr1 = $schema;
            if (arr1) {
                var $sch, $i = -1, l1 = arr1.length - 1;
                while ($i < l1) {
                    $sch = arr1[$i += 1];
                    $it.schema = $sch;
                    $it.schemaPath = $schemaPath + '[' + $i + ']';
                    $it.errSchemaPath = $errSchemaPath + '/' + $i;
                    out += '  ' + (it.validate($it)) + ' ';
                    $it.baseId = $currentBaseId;
                    out += ' ' + ($valid) + ' = ' + ($valid) + ' || ' + ($nextValid) + '; if (!' + ($valid) + ') { ';
                    $closingBraces += '}';
                }
            }
            it.compositeRule = $it.compositeRule = $wasComposite;
            out += ' ' + ($closingBraces) + ' if (!' + ($valid) + ') {   var err =   '; /* istanbul ignore else */
            if (it.createErrors !== false) {
                out += ' { keyword: \'' + ('anyOf') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
                if (it.opts.messages !== false) {
                    out += ' , message: \'should match some schema in anyOf\' ';
                }
                if (it.opts.verbose) {
                    out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                }
                out += ' } ';
            }
            else {
                out += ' {} ';
            }
            out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
            if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                if (it.async) {
                    out += ' throw new ValidationError(vErrors); ';
                }
                else {
                    out += ' validate.errors = vErrors; return false; ';
                }
            }
            out += ' } else {  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; } ';
            if (it.opts.allErrors) {
                out += ' } ';
            }
            out = it.util.cleanUpCode(out);
        }
        else {
            if ($breakOnError) {
                out += ' if (true) { ';
            }
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/const */ function _(require, module, exports) {
    module.exports = function generate_const(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $valid = 'valid' + $lvl;
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
            out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
            $schemaValue = 'schema' + $lvl;
        }
        else {
            $schemaValue = $schema;
        }
        if (!$isData) {
            out += ' var schema' + ($lvl) + ' = validate.schema' + ($schemaPath) + ';';
        }
        out += 'var ' + ($valid) + ' = equal(' + ($data) + ', schema' + ($lvl) + '); if (!' + ($valid) + ') {   ';
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
            out += ' { keyword: \'' + ('const') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
            if (it.opts.messages !== false) {
                out += ' , message: \'should be equal to constant\' ';
            }
            if (it.opts.verbose) {
                out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
        }
        else {
            out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
            if (it.async) {
                out += ' throw new ValidationError([' + (__err) + ']); ';
            }
            else {
                out += ' validate.errors = [' + (__err) + ']; return false; ';
            }
        }
        else {
            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += ' }';
        if ($breakOnError) {
            out += ' else { ';
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/contains */ function _(require, module, exports) {
    module.exports = function generate_contains(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $valid = 'valid' + $lvl;
        var $errs = 'errs__' + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = '';
        $it.level++;
        var $nextValid = 'valid' + $it.level;
        var $idx = 'i' + $lvl, $dataNxt = $it.dataLevel = it.dataLevel + 1, $nextData = 'data' + $dataNxt, $currentBaseId = it.baseId, $nonEmptySchema = it.util.schemaHasRules($schema, it.RULES.all);
        out += 'var ' + ($errs) + ' = errors;var ' + ($valid) + ';';
        if ($nonEmptySchema) {
            var $wasComposite = it.compositeRule;
            it.compositeRule = $it.compositeRule = true;
            $it.schema = $schema;
            $it.schemaPath = $schemaPath;
            $it.errSchemaPath = $errSchemaPath;
            out += ' var ' + ($nextValid) + ' = false; for (var ' + ($idx) + ' = 0; ' + ($idx) + ' < ' + ($data) + '.length; ' + ($idx) + '++) { ';
            $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
            var $passData = $data + '[' + $idx + ']';
            $it.dataPathArr[$dataNxt] = $idx;
            var $code = it.validate($it);
            $it.baseId = $currentBaseId;
            if (it.util.varOccurences($code, $nextData) < 2) {
                out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
            }
            else {
                out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
            }
            out += ' if (' + ($nextValid) + ') break; }  ';
            it.compositeRule = $it.compositeRule = $wasComposite;
            out += ' ' + ($closingBraces) + ' if (!' + ($nextValid) + ') {';
        }
        else {
            out += ' if (' + ($data) + '.length == 0) {';
        }
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
            out += ' { keyword: \'' + ('contains') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
            if (it.opts.messages !== false) {
                out += ' , message: \'should contain a valid item\' ';
            }
            if (it.opts.verbose) {
                out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
        }
        else {
            out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
            if (it.async) {
                out += ' throw new ValidationError([' + (__err) + ']); ';
            }
            else {
                out += ' validate.errors = [' + (__err) + ']; return false; ';
            }
        }
        else {
            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += ' } else { ';
        if ($nonEmptySchema) {
            out += '  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; } ';
        }
        if (it.opts.allErrors) {
            out += ' } ';
        }
        out = it.util.cleanUpCode(out);
        return out;
    };
}
,
/* ajv/lib/dotjs/custom */ function _(require, module, exports) {
    module.exports = function generate_custom(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $errorKeyword;
        var $data = 'data' + ($dataLvl || '');
        var $valid = 'valid' + $lvl;
        var $errs = 'errs__' + $lvl;
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
            out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
            $schemaValue = 'schema' + $lvl;
        }
        else {
            $schemaValue = $schema;
        }
        var $rule = this, $definition = 'definition' + $lvl, $rDef = $rule.definition, $closingBraces = '';
        var $compile, $inline, $macro, $ruleValidate, $validateCode;
        if ($isData && $rDef.$data) {
            $validateCode = 'keywordValidate' + $lvl;
            var $validateSchema = $rDef.validateSchema;
            out += ' var ' + ($definition) + ' = RULES.custom[\'' + ($keyword) + '\'].definition; var ' + ($validateCode) + ' = ' + ($definition) + '.validate;';
        }
        else {
            $ruleValidate = it.useCustomRule($rule, $schema, it.schema, it);
            if (!$ruleValidate)
                return;
            $schemaValue = 'validate.schema' + $schemaPath;
            $validateCode = $ruleValidate.code;
            $compile = $rDef.compile;
            $inline = $rDef.inline;
            $macro = $rDef.macro;
        }
        var $ruleErrs = $validateCode + '.errors', $i = 'i' + $lvl, $ruleErr = 'ruleErr' + $lvl, $asyncKeyword = $rDef.async;
        if ($asyncKeyword && !it.async)
            throw new Error('async keyword in sync schema');
        if (!($inline || $macro)) {
            out += '' + ($ruleErrs) + ' = null;';
        }
        out += 'var ' + ($errs) + ' = errors;var ' + ($valid) + ';';
        if ($isData && $rDef.$data) {
            $closingBraces += '}';
            out += ' if (' + ($schemaValue) + ' === undefined) { ' + ($valid) + ' = true; } else { ';
            if ($validateSchema) {
                $closingBraces += '}';
                out += ' ' + ($valid) + ' = ' + ($definition) + '.validateSchema(' + ($schemaValue) + '); if (' + ($valid) + ') { ';
            }
        }
        if ($inline) {
            if ($rDef.statements) {
                out += ' ' + ($ruleValidate.validate) + ' ';
            }
            else {
                out += ' ' + ($valid) + ' = ' + ($ruleValidate.validate) + '; ';
            }
        }
        else if ($macro) {
            var $it = it.util.copy(it);
            var $closingBraces = '';
            $it.level++;
            var $nextValid = 'valid' + $it.level;
            $it.schema = $ruleValidate.validate;
            $it.schemaPath = '';
            var $wasComposite = it.compositeRule;
            it.compositeRule = $it.compositeRule = true;
            var $code = it.validate($it).replace(/validate\.schema/g, $validateCode);
            it.compositeRule = $it.compositeRule = $wasComposite;
            out += ' ' + ($code);
        }
        else {
            var $$outStack = $$outStack || [];
            $$outStack.push(out);
            out = '';
            out += '  ' + ($validateCode) + '.call( ';
            if (it.opts.passContext) {
                out += 'this';
            }
            else {
                out += 'self';
            }
            if ($compile || $rDef.schema === false) {
                out += ' , ' + ($data) + ' ';
            }
            else {
                out += ' , ' + ($schemaValue) + ' , ' + ($data) + ' , validate.schema' + (it.schemaPath) + ' ';
            }
            out += ' , (dataPath || \'\')';
            if (it.errorPath != '""') {
                out += ' + ' + (it.errorPath);
            }
            var $parentData = $dataLvl ? 'data' + (($dataLvl - 1) || '') : 'parentData', $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : 'parentDataProperty';
            out += ' , ' + ($parentData) + ' , ' + ($parentDataProperty) + ' , rootData )  ';
            var def_callRuleValidate = out;
            out = $$outStack.pop();
            if ($rDef.errors === false) {
                out += ' ' + ($valid) + ' = ';
                if ($asyncKeyword) {
                    out += '' + (it.yieldAwait);
                }
                out += '' + (def_callRuleValidate) + '; ';
            }
            else {
                if ($asyncKeyword) {
                    $ruleErrs = 'customErrors' + $lvl;
                    out += ' var ' + ($ruleErrs) + ' = null; try { ' + ($valid) + ' = ' + (it.yieldAwait) + (def_callRuleValidate) + '; } catch (e) { ' + ($valid) + ' = false; if (e instanceof ValidationError) ' + ($ruleErrs) + ' = e.errors; else throw e; } ';
                }
                else {
                    out += ' ' + ($ruleErrs) + ' = null; ' + ($valid) + ' = ' + (def_callRuleValidate) + '; ';
                }
            }
        }
        if ($rDef.modifying) {
            out += ' if (' + ($parentData) + ') ' + ($data) + ' = ' + ($parentData) + '[' + ($parentDataProperty) + '];';
        }
        out += '' + ($closingBraces);
        if ($rDef.valid) {
            if ($breakOnError) {
                out += ' if (true) { ';
            }
        }
        else {
            out += ' if ( ';
            if ($rDef.valid === undefined) {
                out += ' !';
                if ($macro) {
                    out += '' + ($nextValid);
                }
                else {
                    out += '' + ($valid);
                }
            }
            else {
                out += ' ' + (!$rDef.valid) + ' ';
            }
            out += ') { ';
            $errorKeyword = $rule.keyword;
            var $$outStack = $$outStack || [];
            $$outStack.push(out);
            out = '';
            var $$outStack = $$outStack || [];
            $$outStack.push(out);
            out = ''; /* istanbul ignore else */
            if (it.createErrors !== false) {
                out += ' { keyword: \'' + ($errorKeyword || 'custom') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { keyword: \'' + ($rule.keyword) + '\' } ';
                if (it.opts.messages !== false) {
                    out += ' , message: \'should pass "' + ($rule.keyword) + '" keyword validation\' ';
                }
                if (it.opts.verbose) {
                    out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                }
                out += ' } ';
            }
            else {
                out += ' {} ';
            }
            var __err = out;
            out = $$outStack.pop();
            if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                if (it.async) {
                    out += ' throw new ValidationError([' + (__err) + ']); ';
                }
                else {
                    out += ' validate.errors = [' + (__err) + ']; return false; ';
                }
            }
            else {
                out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
            }
            var def_customError = out;
            out = $$outStack.pop();
            if ($inline) {
                if ($rDef.errors) {
                    if ($rDef.errors != 'full') {
                        out += '  for (var ' + ($i) + '=' + ($errs) + '; ' + ($i) + '<errors; ' + ($i) + '++) { var ' + ($ruleErr) + ' = vErrors[' + ($i) + ']; if (' + ($ruleErr) + '.dataPath === undefined) ' + ($ruleErr) + '.dataPath = (dataPath || \'\') + ' + (it.errorPath) + '; if (' + ($ruleErr) + '.schemaPath === undefined) { ' + ($ruleErr) + '.schemaPath = "' + ($errSchemaPath) + '"; } ';
                        if (it.opts.verbose) {
                            out += ' ' + ($ruleErr) + '.schema = ' + ($schemaValue) + '; ' + ($ruleErr) + '.data = ' + ($data) + '; ';
                        }
                        out += ' } ';
                    }
                }
                else {
                    if ($rDef.errors === false) {
                        out += ' ' + (def_customError) + ' ';
                    }
                    else {
                        out += ' if (' + ($errs) + ' == errors) { ' + (def_customError) + ' } else {  for (var ' + ($i) + '=' + ($errs) + '; ' + ($i) + '<errors; ' + ($i) + '++) { var ' + ($ruleErr) + ' = vErrors[' + ($i) + ']; if (' + ($ruleErr) + '.dataPath === undefined) ' + ($ruleErr) + '.dataPath = (dataPath || \'\') + ' + (it.errorPath) + '; if (' + ($ruleErr) + '.schemaPath === undefined) { ' + ($ruleErr) + '.schemaPath = "' + ($errSchemaPath) + '"; } ';
                        if (it.opts.verbose) {
                            out += ' ' + ($ruleErr) + '.schema = ' + ($schemaValue) + '; ' + ($ruleErr) + '.data = ' + ($data) + '; ';
                        }
                        out += ' } } ';
                    }
                }
            }
            else if ($macro) {
                out += '   var err =   '; /* istanbul ignore else */
                if (it.createErrors !== false) {
                    out += ' { keyword: \'' + ($errorKeyword || 'custom') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { keyword: \'' + ($rule.keyword) + '\' } ';
                    if (it.opts.messages !== false) {
                        out += ' , message: \'should pass "' + ($rule.keyword) + '" keyword validation\' ';
                    }
                    if (it.opts.verbose) {
                        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                    }
                    out += ' } ';
                }
                else {
                    out += ' {} ';
                }
                out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                    if (it.async) {
                        out += ' throw new ValidationError(vErrors); ';
                    }
                    else {
                        out += ' validate.errors = vErrors; return false; ';
                    }
                }
            }
            else {
                if ($rDef.errors === false) {
                    out += ' ' + (def_customError) + ' ';
                }
                else {
                    out += ' if (Array.isArray(' + ($ruleErrs) + ')) { if (vErrors === null) vErrors = ' + ($ruleErrs) + '; else vErrors = vErrors.concat(' + ($ruleErrs) + '); errors = vErrors.length;  for (var ' + ($i) + '=' + ($errs) + '; ' + ($i) + '<errors; ' + ($i) + '++) { var ' + ($ruleErr) + ' = vErrors[' + ($i) + ']; if (' + ($ruleErr) + '.dataPath === undefined) ' + ($ruleErr) + '.dataPath = (dataPath || \'\') + ' + (it.errorPath) + ';  ' + ($ruleErr) + '.schemaPath = "' + ($errSchemaPath) + '";  ';
                    if (it.opts.verbose) {
                        out += ' ' + ($ruleErr) + '.schema = ' + ($schemaValue) + '; ' + ($ruleErr) + '.data = ' + ($data) + '; ';
                    }
                    out += ' } } else { ' + (def_customError) + ' } ';
                }
            }
            out += ' } ';
            if ($breakOnError) {
                out += ' else { ';
            }
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/dependencies */ function _(require, module, exports) {
    module.exports = function generate_dependencies(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $errs = 'errs__' + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = '';
        $it.level++;
        var $nextValid = 'valid' + $it.level;
        var $schemaDeps = {}, $propertyDeps = {}, $ownProperties = it.opts.ownProperties;
        for ($property in $schema) {
            var $sch = $schema[$property];
            var $deps = Array.isArray($sch) ? $propertyDeps : $schemaDeps;
            $deps[$property] = $sch;
        }
        out += 'var ' + ($errs) + ' = errors;';
        var $currentErrorPath = it.errorPath;
        out += 'var missing' + ($lvl) + ';';
        for (var $property in $propertyDeps) {
            $deps = $propertyDeps[$property];
            if ($deps.length) {
                out += ' if ( ' + ($data) + (it.util.getProperty($property)) + ' !== undefined ';
                if ($ownProperties) {
                    out += ' && Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($property)) + '\') ';
                }
                if ($breakOnError) {
                    out += ' && ( ';
                    var arr1 = $deps;
                    if (arr1) {
                        var $propertyKey, $i = -1, l1 = arr1.length - 1;
                        while ($i < l1) {
                            $propertyKey = arr1[$i += 1];
                            if ($i) {
                                out += ' || ';
                            }
                            var $prop = it.util.getProperty($propertyKey), $useData = $data + $prop;
                            out += ' ( ( ' + ($useData) + ' === undefined ';
                            if ($ownProperties) {
                                out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
                            }
                            out += ') && (missing' + ($lvl) + ' = ' + (it.util.toQuotedString(it.opts.jsonPointers ? $propertyKey : $prop)) + ') ) ';
                        }
                    }
                    out += ')) {  ';
                    var $propertyPath = 'missing' + $lvl, $missingProperty = '\' + ' + $propertyPath + ' + \'';
                    if (it.opts._errorDataPathProperty) {
                        it.errorPath = it.opts.jsonPointers ? it.util.getPathExpr($currentErrorPath, $propertyPath, true) : $currentErrorPath + ' + ' + $propertyPath;
                    }
                    var $$outStack = $$outStack || [];
                    $$outStack.push(out);
                    out = ''; /* istanbul ignore else */
                    if (it.createErrors !== false) {
                        out += ' { keyword: \'' + ('dependencies') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { property: \'' + (it.util.escapeQuotes($property)) + '\', missingProperty: \'' + ($missingProperty) + '\', depsCount: ' + ($deps.length) + ', deps: \'' + (it.util.escapeQuotes($deps.length == 1 ? $deps[0] : $deps.join(", "))) + '\' } ';
                        if (it.opts.messages !== false) {
                            out += ' , message: \'should have ';
                            if ($deps.length == 1) {
                                out += 'property ' + (it.util.escapeQuotes($deps[0]));
                            }
                            else {
                                out += 'properties ' + (it.util.escapeQuotes($deps.join(", ")));
                            }
                            out += ' when property ' + (it.util.escapeQuotes($property)) + ' is present\' ';
                        }
                        if (it.opts.verbose) {
                            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                        }
                        out += ' } ';
                    }
                    else {
                        out += ' {} ';
                    }
                    var __err = out;
                    out = $$outStack.pop();
                    if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                        if (it.async) {
                            out += ' throw new ValidationError([' + (__err) + ']); ';
                        }
                        else {
                            out += ' validate.errors = [' + (__err) + ']; return false; ';
                        }
                    }
                    else {
                        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                    }
                }
                else {
                    out += ' ) { ';
                    var arr2 = $deps;
                    if (arr2) {
                        var $propertyKey, i2 = -1, l2 = arr2.length - 1;
                        while (i2 < l2) {
                            $propertyKey = arr2[i2 += 1];
                            var $prop = it.util.getProperty($propertyKey), $missingProperty = it.util.escapeQuotes($propertyKey), $useData = $data + $prop;
                            if (it.opts._errorDataPathProperty) {
                                it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
                            }
                            out += ' if ( ' + ($useData) + ' === undefined ';
                            if ($ownProperties) {
                                out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
                            }
                            out += ') {  var err =   '; /* istanbul ignore else */
                            if (it.createErrors !== false) {
                                out += ' { keyword: \'' + ('dependencies') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { property: \'' + (it.util.escapeQuotes($property)) + '\', missingProperty: \'' + ($missingProperty) + '\', depsCount: ' + ($deps.length) + ', deps: \'' + (it.util.escapeQuotes($deps.length == 1 ? $deps[0] : $deps.join(", "))) + '\' } ';
                                if (it.opts.messages !== false) {
                                    out += ' , message: \'should have ';
                                    if ($deps.length == 1) {
                                        out += 'property ' + (it.util.escapeQuotes($deps[0]));
                                    }
                                    else {
                                        out += 'properties ' + (it.util.escapeQuotes($deps.join(", ")));
                                    }
                                    out += ' when property ' + (it.util.escapeQuotes($property)) + ' is present\' ';
                                }
                                if (it.opts.verbose) {
                                    out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                                }
                                out += ' } ';
                            }
                            else {
                                out += ' {} ';
                            }
                            out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } ';
                        }
                    }
                }
                out += ' }   ';
                if ($breakOnError) {
                    $closingBraces += '}';
                    out += ' else { ';
                }
            }
        }
        it.errorPath = $currentErrorPath;
        var $currentBaseId = $it.baseId;
        for (var $property in $schemaDeps) {
            var $sch = $schemaDeps[$property];
            if (it.util.schemaHasRules($sch, it.RULES.all)) {
                out += ' ' + ($nextValid) + ' = true; if ( ' + ($data) + (it.util.getProperty($property)) + ' !== undefined ';
                if ($ownProperties) {
                    out += ' && Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($property)) + '\') ';
                }
                out += ') { ';
                $it.schema = $sch;
                $it.schemaPath = $schemaPath + it.util.getProperty($property);
                $it.errSchemaPath = $errSchemaPath + '/' + it.util.escapeFragment($property);
                out += '  ' + (it.validate($it)) + ' ';
                $it.baseId = $currentBaseId;
                out += ' }  ';
                if ($breakOnError) {
                    out += ' if (' + ($nextValid) + ') { ';
                    $closingBraces += '}';
                }
            }
        }
        if ($breakOnError) {
            out += '   ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
        }
        out = it.util.cleanUpCode(out);
        return out;
    };
}
,
/* ajv/lib/dotjs/enum */ function _(require, module, exports) {
    module.exports = function generate_enum(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $valid = 'valid' + $lvl;
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
            out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
            $schemaValue = 'schema' + $lvl;
        }
        else {
            $schemaValue = $schema;
        }
        var $i = 'i' + $lvl, $vSchema = 'schema' + $lvl;
        if (!$isData) {
            out += ' var ' + ($vSchema) + ' = validate.schema' + ($schemaPath) + ';';
        }
        out += 'var ' + ($valid) + ';';
        if ($isData) {
            out += ' if (schema' + ($lvl) + ' === undefined) ' + ($valid) + ' = true; else if (!Array.isArray(schema' + ($lvl) + ')) ' + ($valid) + ' = false; else {';
        }
        out += '' + ($valid) + ' = false;for (var ' + ($i) + '=0; ' + ($i) + '<' + ($vSchema) + '.length; ' + ($i) + '++) if (equal(' + ($data) + ', ' + ($vSchema) + '[' + ($i) + '])) { ' + ($valid) + ' = true; break; }';
        if ($isData) {
            out += '  }  ';
        }
        out += ' if (!' + ($valid) + ') {   ';
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
            out += ' { keyword: \'' + ('enum') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { allowedValues: schema' + ($lvl) + ' } ';
            if (it.opts.messages !== false) {
                out += ' , message: \'should be equal to one of the allowed values\' ';
            }
            if (it.opts.verbose) {
                out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
        }
        else {
            out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
            if (it.async) {
                out += ' throw new ValidationError([' + (__err) + ']); ';
            }
            else {
                out += ' validate.errors = [' + (__err) + ']; return false; ';
            }
        }
        else {
            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += ' }';
        if ($breakOnError) {
            out += ' else { ';
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/format */ function _(require, module, exports) {
    module.exports = function generate_format(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        if (it.opts.format === false) {
            if ($breakOnError) {
                out += ' if (true) { ';
            }
            return out;
        }
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
            out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
            $schemaValue = 'schema' + $lvl;
        }
        else {
            $schemaValue = $schema;
        }
        var $unknownFormats = it.opts.unknownFormats, $allowUnknown = Array.isArray($unknownFormats);
        if ($isData) {
            var $format = 'format' + $lvl, $isObject = 'isObject' + $lvl, $formatType = 'formatType' + $lvl;
            out += ' var ' + ($format) + ' = formats[' + ($schemaValue) + ']; var ' + ($isObject) + ' = typeof ' + ($format) + ' == \'object\' && !(' + ($format) + ' instanceof RegExp) && ' + ($format) + '.validate; var ' + ($formatType) + ' = ' + ($isObject) + ' && ' + ($format) + '.type || \'string\'; if (' + ($isObject) + ') { ';
            if (it.async) {
                out += ' var async' + ($lvl) + ' = ' + ($format) + '.async; ';
            }
            out += ' ' + ($format) + ' = ' + ($format) + '.validate; } if (  ';
            if ($isData) {
                out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'string\') || ';
            }
            out += ' (';
            if ($unknownFormats != 'ignore') {
                out += ' (' + ($schemaValue) + ' && !' + ($format) + ' ';
                if ($allowUnknown) {
                    out += ' && self._opts.unknownFormats.indexOf(' + ($schemaValue) + ') == -1 ';
                }
                out += ') || ';
            }
            out += ' (' + ($format) + ' && ' + ($formatType) + ' == \'' + ($ruleType) + '\' && !(typeof ' + ($format) + ' == \'function\' ? ';
            if (it.async) {
                out += ' (async' + ($lvl) + ' ? ' + (it.yieldAwait) + ' ' + ($format) + '(' + ($data) + ') : ' + ($format) + '(' + ($data) + ')) ';
            }
            else {
                out += ' ' + ($format) + '(' + ($data) + ') ';
            }
            out += ' : ' + ($format) + '.test(' + ($data) + '))))) {';
        }
        else {
            var $format = it.formats[$schema];
            if (!$format) {
                if ($unknownFormats == 'ignore') {
                    it.logger.warn('unknown format "' + $schema + '" ignored in schema at path "' + it.errSchemaPath + '"');
                    if ($breakOnError) {
                        out += ' if (true) { ';
                    }
                    return out;
                }
                else if ($allowUnknown && $unknownFormats.indexOf($schema) >= 0) {
                    if ($breakOnError) {
                        out += ' if (true) { ';
                    }
                    return out;
                }
                else {
                    throw new Error('unknown format "' + $schema + '" is used in schema at path "' + it.errSchemaPath + '"');
                }
            }
            var $isObject = typeof $format == 'object' && !($format instanceof RegExp) && $format.validate;
            var $formatType = $isObject && $format.type || 'string';
            if ($isObject) {
                var $async = $format.async === true;
                $format = $format.validate;
            }
            if ($formatType != $ruleType) {
                if ($breakOnError) {
                    out += ' if (true) { ';
                }
                return out;
            }
            if ($async) {
                if (!it.async)
                    throw new Error('async format in sync schema');
                var $formatRef = 'formats' + it.util.getProperty($schema) + '.validate';
                out += ' if (!(' + (it.yieldAwait) + ' ' + ($formatRef) + '(' + ($data) + '))) { ';
            }
            else {
                out += ' if (! ';
                var $formatRef = 'formats' + it.util.getProperty($schema);
                if ($isObject)
                    $formatRef += '.validate';
                if (typeof $format == 'function') {
                    out += ' ' + ($formatRef) + '(' + ($data) + ') ';
                }
                else {
                    out += ' ' + ($formatRef) + '.test(' + ($data) + ') ';
                }
                out += ') { ';
            }
        }
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
            out += ' { keyword: \'' + ('format') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { format:  ';
            if ($isData) {
                out += '' + ($schemaValue);
            }
            else {
                out += '' + (it.util.toQuotedString($schema));
            }
            out += '  } ';
            if (it.opts.messages !== false) {
                out += ' , message: \'should match format "';
                if ($isData) {
                    out += '\' + ' + ($schemaValue) + ' + \'';
                }
                else {
                    out += '' + (it.util.escapeQuotes($schema));
                }
                out += '"\' ';
            }
            if (it.opts.verbose) {
                out += ' , schema:  ';
                if ($isData) {
                    out += 'validate.schema' + ($schemaPath);
                }
                else {
                    out += '' + (it.util.toQuotedString($schema));
                }
                out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
        }
        else {
            out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
            if (it.async) {
                out += ' throw new ValidationError([' + (__err) + ']); ';
            }
            else {
                out += ' validate.errors = [' + (__err) + ']; return false; ';
            }
        }
        else {
            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += ' } ';
        if ($breakOnError) {
            out += ' else { ';
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/items */ function _(require, module, exports) {
    module.exports = function generate_items(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $valid = 'valid' + $lvl;
        var $errs = 'errs__' + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = '';
        $it.level++;
        var $nextValid = 'valid' + $it.level;
        var $idx = 'i' + $lvl, $dataNxt = $it.dataLevel = it.dataLevel + 1, $nextData = 'data' + $dataNxt, $currentBaseId = it.baseId;
        out += 'var ' + ($errs) + ' = errors;var ' + ($valid) + ';';
        if (Array.isArray($schema)) {
            var $additionalItems = it.schema.additionalItems;
            if ($additionalItems === false) {
                out += ' ' + ($valid) + ' = ' + ($data) + '.length <= ' + ($schema.length) + '; ';
                var $currErrSchemaPath = $errSchemaPath;
                $errSchemaPath = it.errSchemaPath + '/additionalItems';
                out += '  if (!' + ($valid) + ') {   ';
                var $$outStack = $$outStack || [];
                $$outStack.push(out);
                out = ''; /* istanbul ignore else */
                if (it.createErrors !== false) {
                    out += ' { keyword: \'' + ('additionalItems') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { limit: ' + ($schema.length) + ' } ';
                    if (it.opts.messages !== false) {
                        out += ' , message: \'should NOT have more than ' + ($schema.length) + ' items\' ';
                    }
                    if (it.opts.verbose) {
                        out += ' , schema: false , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                    }
                    out += ' } ';
                }
                else {
                    out += ' {} ';
                }
                var __err = out;
                out = $$outStack.pop();
                if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                    if (it.async) {
                        out += ' throw new ValidationError([' + (__err) + ']); ';
                    }
                    else {
                        out += ' validate.errors = [' + (__err) + ']; return false; ';
                    }
                }
                else {
                    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                }
                out += ' } ';
                $errSchemaPath = $currErrSchemaPath;
                if ($breakOnError) {
                    $closingBraces += '}';
                    out += ' else { ';
                }
            }
            var arr1 = $schema;
            if (arr1) {
                var $sch, $i = -1, l1 = arr1.length - 1;
                while ($i < l1) {
                    $sch = arr1[$i += 1];
                    if (it.util.schemaHasRules($sch, it.RULES.all)) {
                        out += ' ' + ($nextValid) + ' = true; if (' + ($data) + '.length > ' + ($i) + ') { ';
                        var $passData = $data + '[' + $i + ']';
                        $it.schema = $sch;
                        $it.schemaPath = $schemaPath + '[' + $i + ']';
                        $it.errSchemaPath = $errSchemaPath + '/' + $i;
                        $it.errorPath = it.util.getPathExpr(it.errorPath, $i, it.opts.jsonPointers, true);
                        $it.dataPathArr[$dataNxt] = $i;
                        var $code = it.validate($it);
                        $it.baseId = $currentBaseId;
                        if (it.util.varOccurences($code, $nextData) < 2) {
                            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
                        }
                        else {
                            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
                        }
                        out += ' }  ';
                        if ($breakOnError) {
                            out += ' if (' + ($nextValid) + ') { ';
                            $closingBraces += '}';
                        }
                    }
                }
            }
            if (typeof $additionalItems == 'object' && it.util.schemaHasRules($additionalItems, it.RULES.all)) {
                $it.schema = $additionalItems;
                $it.schemaPath = it.schemaPath + '.additionalItems';
                $it.errSchemaPath = it.errSchemaPath + '/additionalItems';
                out += ' ' + ($nextValid) + ' = true; if (' + ($data) + '.length > ' + ($schema.length) + ') {  for (var ' + ($idx) + ' = ' + ($schema.length) + '; ' + ($idx) + ' < ' + ($data) + '.length; ' + ($idx) + '++) { ';
                $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
                var $passData = $data + '[' + $idx + ']';
                $it.dataPathArr[$dataNxt] = $idx;
                var $code = it.validate($it);
                $it.baseId = $currentBaseId;
                if (it.util.varOccurences($code, $nextData) < 2) {
                    out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
                }
                else {
                    out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
                }
                if ($breakOnError) {
                    out += ' if (!' + ($nextValid) + ') break; ';
                }
                out += ' } }  ';
                if ($breakOnError) {
                    out += ' if (' + ($nextValid) + ') { ';
                    $closingBraces += '}';
                }
            }
        }
        else if (it.util.schemaHasRules($schema, it.RULES.all)) {
            $it.schema = $schema;
            $it.schemaPath = $schemaPath;
            $it.errSchemaPath = $errSchemaPath;
            out += '  for (var ' + ($idx) + ' = ' + (0) + '; ' + ($idx) + ' < ' + ($data) + '.length; ' + ($idx) + '++) { ';
            $it.errorPath = it.util.getPathExpr(it.errorPath, $idx, it.opts.jsonPointers, true);
            var $passData = $data + '[' + $idx + ']';
            $it.dataPathArr[$dataNxt] = $idx;
            var $code = it.validate($it);
            $it.baseId = $currentBaseId;
            if (it.util.varOccurences($code, $nextData) < 2) {
                out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
            }
            else {
                out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
            }
            if ($breakOnError) {
                out += ' if (!' + ($nextValid) + ') break; ';
            }
            out += ' }';
        }
        if ($breakOnError) {
            out += ' ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
        }
        out = it.util.cleanUpCode(out);
        return out;
    };
}
,
/* ajv/lib/dotjs/multipleOf */ function _(require, module, exports) {
    module.exports = function generate_multipleOf(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
            out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
            $schemaValue = 'schema' + $lvl;
        }
        else {
            $schemaValue = $schema;
        }
        out += 'var division' + ($lvl) + ';if (';
        if ($isData) {
            out += ' ' + ($schemaValue) + ' !== undefined && ( typeof ' + ($schemaValue) + ' != \'number\' || ';
        }
        out += ' (division' + ($lvl) + ' = ' + ($data) + ' / ' + ($schemaValue) + ', ';
        if (it.opts.multipleOfPrecision) {
            out += ' Math.abs(Math.round(division' + ($lvl) + ') - division' + ($lvl) + ') > 1e-' + (it.opts.multipleOfPrecision) + ' ';
        }
        else {
            out += ' division' + ($lvl) + ' !== parseInt(division' + ($lvl) + ') ';
        }
        out += ' ) ';
        if ($isData) {
            out += '  )  ';
        }
        out += ' ) {   ';
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
            out += ' { keyword: \'' + ('multipleOf') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { multipleOf: ' + ($schemaValue) + ' } ';
            if (it.opts.messages !== false) {
                out += ' , message: \'should be multiple of ';
                if ($isData) {
                    out += '\' + ' + ($schemaValue);
                }
                else {
                    out += '' + ($schemaValue) + '\'';
                }
            }
            if (it.opts.verbose) {
                out += ' , schema:  ';
                if ($isData) {
                    out += 'validate.schema' + ($schemaPath);
                }
                else {
                    out += '' + ($schema);
                }
                out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
        }
        else {
            out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
            if (it.async) {
                out += ' throw new ValidationError([' + (__err) + ']); ';
            }
            else {
                out += ' validate.errors = [' + (__err) + ']; return false; ';
            }
        }
        else {
            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += '} ';
        if ($breakOnError) {
            out += ' else { ';
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/not */ function _(require, module, exports) {
    module.exports = function generate_not(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $errs = 'errs__' + $lvl;
        var $it = it.util.copy(it);
        $it.level++;
        var $nextValid = 'valid' + $it.level;
        if (it.util.schemaHasRules($schema, it.RULES.all)) {
            $it.schema = $schema;
            $it.schemaPath = $schemaPath;
            $it.errSchemaPath = $errSchemaPath;
            out += ' var ' + ($errs) + ' = errors;  ';
            var $wasComposite = it.compositeRule;
            it.compositeRule = $it.compositeRule = true;
            $it.createErrors = false;
            var $allErrorsOption;
            if ($it.opts.allErrors) {
                $allErrorsOption = $it.opts.allErrors;
                $it.opts.allErrors = false;
            }
            out += ' ' + (it.validate($it)) + ' ';
            $it.createErrors = true;
            if ($allErrorsOption)
                $it.opts.allErrors = $allErrorsOption;
            it.compositeRule = $it.compositeRule = $wasComposite;
            out += ' if (' + ($nextValid) + ') {   ';
            var $$outStack = $$outStack || [];
            $$outStack.push(out);
            out = ''; /* istanbul ignore else */
            if (it.createErrors !== false) {
                out += ' { keyword: \'' + ('not') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
                if (it.opts.messages !== false) {
                    out += ' , message: \'should NOT be valid\' ';
                }
                if (it.opts.verbose) {
                    out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                }
                out += ' } ';
            }
            else {
                out += ' {} ';
            }
            var __err = out;
            out = $$outStack.pop();
            if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                if (it.async) {
                    out += ' throw new ValidationError([' + (__err) + ']); ';
                }
                else {
                    out += ' validate.errors = [' + (__err) + ']; return false; ';
                }
            }
            else {
                out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
            }
            out += ' } else {  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; } ';
            if (it.opts.allErrors) {
                out += ' } ';
            }
        }
        else {
            out += '  var err =   '; /* istanbul ignore else */
            if (it.createErrors !== false) {
                out += ' { keyword: \'' + ('not') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
                if (it.opts.messages !== false) {
                    out += ' , message: \'should NOT be valid\' ';
                }
                if (it.opts.verbose) {
                    out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                }
                out += ' } ';
            }
            else {
                out += ' {} ';
            }
            out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
            if ($breakOnError) {
                out += ' if (false) { ';
            }
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/oneOf */ function _(require, module, exports) {
    module.exports = function generate_oneOf(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $valid = 'valid' + $lvl;
        var $errs = 'errs__' + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = '';
        $it.level++;
        var $nextValid = 'valid' + $it.level;
        out += 'var ' + ($errs) + ' = errors;var prevValid' + ($lvl) + ' = false;var ' + ($valid) + ' = false;';
        var $currentBaseId = $it.baseId;
        var $wasComposite = it.compositeRule;
        it.compositeRule = $it.compositeRule = true;
        var arr1 = $schema;
        if (arr1) {
            var $sch, $i = -1, l1 = arr1.length - 1;
            while ($i < l1) {
                $sch = arr1[$i += 1];
                if (it.util.schemaHasRules($sch, it.RULES.all)) {
                    $it.schema = $sch;
                    $it.schemaPath = $schemaPath + '[' + $i + ']';
                    $it.errSchemaPath = $errSchemaPath + '/' + $i;
                    out += '  ' + (it.validate($it)) + ' ';
                    $it.baseId = $currentBaseId;
                }
                else {
                    out += ' var ' + ($nextValid) + ' = true; ';
                }
                if ($i) {
                    out += ' if (' + ($nextValid) + ' && prevValid' + ($lvl) + ') ' + ($valid) + ' = false; else { ';
                    $closingBraces += '}';
                }
                out += ' if (' + ($nextValid) + ') ' + ($valid) + ' = prevValid' + ($lvl) + ' = true;';
            }
        }
        it.compositeRule = $it.compositeRule = $wasComposite;
        out += '' + ($closingBraces) + 'if (!' + ($valid) + ') {   var err =   '; /* istanbul ignore else */
        if (it.createErrors !== false) {
            out += ' { keyword: \'' + ('oneOf') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
            if (it.opts.messages !== false) {
                out += ' , message: \'should match exactly one schema in oneOf\' ';
            }
            if (it.opts.verbose) {
                out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
        }
        else {
            out += ' {} ';
        }
        out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
            if (it.async) {
                out += ' throw new ValidationError(vErrors); ';
            }
            else {
                out += ' validate.errors = vErrors; return false; ';
            }
        }
        out += '} else {  errors = ' + ($errs) + '; if (vErrors !== null) { if (' + ($errs) + ') vErrors.length = ' + ($errs) + '; else vErrors = null; }';
        if (it.opts.allErrors) {
            out += ' } ';
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/pattern */ function _(require, module, exports) {
    module.exports = function generate_pattern(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
            out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
            $schemaValue = 'schema' + $lvl;
        }
        else {
            $schemaValue = $schema;
        }
        var $regexp = $isData ? '(new RegExp(' + $schemaValue + '))' : it.usePattern($schema);
        out += 'if ( ';
        if ($isData) {
            out += ' (' + ($schemaValue) + ' !== undefined && typeof ' + ($schemaValue) + ' != \'string\') || ';
        }
        out += ' !' + ($regexp) + '.test(' + ($data) + ') ) {   ';
        var $$outStack = $$outStack || [];
        $$outStack.push(out);
        out = ''; /* istanbul ignore else */
        if (it.createErrors !== false) {
            out += ' { keyword: \'' + ('pattern') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { pattern:  ';
            if ($isData) {
                out += '' + ($schemaValue);
            }
            else {
                out += '' + (it.util.toQuotedString($schema));
            }
            out += '  } ';
            if (it.opts.messages !== false) {
                out += ' , message: \'should match pattern "';
                if ($isData) {
                    out += '\' + ' + ($schemaValue) + ' + \'';
                }
                else {
                    out += '' + (it.util.escapeQuotes($schema));
                }
                out += '"\' ';
            }
            if (it.opts.verbose) {
                out += ' , schema:  ';
                if ($isData) {
                    out += 'validate.schema' + ($schemaPath);
                }
                else {
                    out += '' + (it.util.toQuotedString($schema));
                }
                out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
            }
            out += ' } ';
        }
        else {
            out += ' {} ';
        }
        var __err = out;
        out = $$outStack.pop();
        if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
            if (it.async) {
                out += ' throw new ValidationError([' + (__err) + ']); ';
            }
            else {
                out += ' validate.errors = [' + (__err) + ']; return false; ';
            }
        }
        else {
            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
        }
        out += '} ';
        if ($breakOnError) {
            out += ' else { ';
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/properties */ function _(require, module, exports) {
    module.exports = function generate_properties(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $valid = 'valid' + $lvl;
        var $errs = 'errs__' + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = '';
        $it.level++;
        var $nextValid = 'valid' + $it.level;
        var $key = 'key' + $lvl, $idx = 'idx' + $lvl, $dataNxt = $it.dataLevel = it.dataLevel + 1, $nextData = 'data' + $dataNxt, $dataProperties = 'dataProperties' + $lvl;
        var $schemaKeys = Object.keys($schema || {}), $pProperties = it.schema.patternProperties || {}, $pPropertyKeys = Object.keys($pProperties), $aProperties = it.schema.additionalProperties, $someProperties = $schemaKeys.length || $pPropertyKeys.length, $noAdditional = $aProperties === false, $additionalIsSchema = typeof $aProperties == 'object' && Object.keys($aProperties).length, $removeAdditional = it.opts.removeAdditional, $checkAdditional = $noAdditional || $additionalIsSchema || $removeAdditional, $ownProperties = it.opts.ownProperties, $currentBaseId = it.baseId;
        var $required = it.schema.required;
        if ($required && !(it.opts.v5 && $required.$data) && $required.length < it.opts.loopRequired)
            var $requiredHash = it.util.toHash($required);
        if (it.opts.patternGroups) {
            var $pgProperties = it.schema.patternGroups || {}, $pgPropertyKeys = Object.keys($pgProperties);
        }
        out += 'var ' + ($errs) + ' = errors;var ' + ($nextValid) + ' = true;';
        if ($ownProperties) {
            out += ' var ' + ($dataProperties) + ' = undefined;';
        }
        if ($checkAdditional) {
            if ($ownProperties) {
                out += ' ' + ($dataProperties) + ' = ' + ($dataProperties) + ' || Object.keys(' + ($data) + '); for (var ' + ($idx) + '=0; ' + ($idx) + '<' + ($dataProperties) + '.length; ' + ($idx) + '++) { var ' + ($key) + ' = ' + ($dataProperties) + '[' + ($idx) + ']; ';
            }
            else {
                out += ' for (var ' + ($key) + ' in ' + ($data) + ') { ';
            }
            if ($someProperties) {
                out += ' var isAdditional' + ($lvl) + ' = !(false ';
                if ($schemaKeys.length) {
                    if ($schemaKeys.length > 5) {
                        out += ' || validate.schema' + ($schemaPath) + '[' + ($key) + '] ';
                    }
                    else {
                        var arr1 = $schemaKeys;
                        if (arr1) {
                            var $propertyKey, i1 = -1, l1 = arr1.length - 1;
                            while (i1 < l1) {
                                $propertyKey = arr1[i1 += 1];
                                out += ' || ' + ($key) + ' == ' + (it.util.toQuotedString($propertyKey)) + ' ';
                            }
                        }
                    }
                }
                if ($pPropertyKeys.length) {
                    var arr2 = $pPropertyKeys;
                    if (arr2) {
                        var $pProperty, $i = -1, l2 = arr2.length - 1;
                        while ($i < l2) {
                            $pProperty = arr2[$i += 1];
                            out += ' || ' + (it.usePattern($pProperty)) + '.test(' + ($key) + ') ';
                        }
                    }
                }
                if (it.opts.patternGroups && $pgPropertyKeys.length) {
                    var arr3 = $pgPropertyKeys;
                    if (arr3) {
                        var $pgProperty, $i = -1, l3 = arr3.length - 1;
                        while ($i < l3) {
                            $pgProperty = arr3[$i += 1];
                            out += ' || ' + (it.usePattern($pgProperty)) + '.test(' + ($key) + ') ';
                        }
                    }
                }
                out += ' ); if (isAdditional' + ($lvl) + ') { ';
            }
            if ($removeAdditional == 'all') {
                out += ' delete ' + ($data) + '[' + ($key) + ']; ';
            }
            else {
                var $currentErrorPath = it.errorPath;
                var $additionalProperty = '\' + ' + $key + ' + \'';
                if (it.opts._errorDataPathProperty) {
                    it.errorPath = it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
                }
                if ($noAdditional) {
                    if ($removeAdditional) {
                        out += ' delete ' + ($data) + '[' + ($key) + ']; ';
                    }
                    else {
                        out += ' ' + ($nextValid) + ' = false; ';
                        var $currErrSchemaPath = $errSchemaPath;
                        $errSchemaPath = it.errSchemaPath + '/additionalProperties';
                        var $$outStack = $$outStack || [];
                        $$outStack.push(out);
                        out = ''; /* istanbul ignore else */
                        if (it.createErrors !== false) {
                            out += ' { keyword: \'' + ('additionalProperties') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { additionalProperty: \'' + ($additionalProperty) + '\' } ';
                            if (it.opts.messages !== false) {
                                out += ' , message: \'should NOT have additional properties\' ';
                            }
                            if (it.opts.verbose) {
                                out += ' , schema: false , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                            }
                            out += ' } ';
                        }
                        else {
                            out += ' {} ';
                        }
                        var __err = out;
                        out = $$outStack.pop();
                        if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                            if (it.async) {
                                out += ' throw new ValidationError([' + (__err) + ']); ';
                            }
                            else {
                                out += ' validate.errors = [' + (__err) + ']; return false; ';
                            }
                        }
                        else {
                            out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                        }
                        $errSchemaPath = $currErrSchemaPath;
                        if ($breakOnError) {
                            out += ' break; ';
                        }
                    }
                }
                else if ($additionalIsSchema) {
                    if ($removeAdditional == 'failing') {
                        out += ' var ' + ($errs) + ' = errors;  ';
                        var $wasComposite = it.compositeRule;
                        it.compositeRule = $it.compositeRule = true;
                        $it.schema = $aProperties;
                        $it.schemaPath = it.schemaPath + '.additionalProperties';
                        $it.errSchemaPath = it.errSchemaPath + '/additionalProperties';
                        $it.errorPath = it.opts._errorDataPathProperty ? it.errorPath : it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
                        var $passData = $data + '[' + $key + ']';
                        $it.dataPathArr[$dataNxt] = $key;
                        var $code = it.validate($it);
                        $it.baseId = $currentBaseId;
                        if (it.util.varOccurences($code, $nextData) < 2) {
                            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
                        }
                        else {
                            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
                        }
                        out += ' if (!' + ($nextValid) + ') { errors = ' + ($errs) + '; if (validate.errors !== null) { if (errors) validate.errors.length = errors; else validate.errors = null; } delete ' + ($data) + '[' + ($key) + ']; }  ';
                        it.compositeRule = $it.compositeRule = $wasComposite;
                    }
                    else {
                        $it.schema = $aProperties;
                        $it.schemaPath = it.schemaPath + '.additionalProperties';
                        $it.errSchemaPath = it.errSchemaPath + '/additionalProperties';
                        $it.errorPath = it.opts._errorDataPathProperty ? it.errorPath : it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
                        var $passData = $data + '[' + $key + ']';
                        $it.dataPathArr[$dataNxt] = $key;
                        var $code = it.validate($it);
                        $it.baseId = $currentBaseId;
                        if (it.util.varOccurences($code, $nextData) < 2) {
                            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
                        }
                        else {
                            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
                        }
                        if ($breakOnError) {
                            out += ' if (!' + ($nextValid) + ') break; ';
                        }
                    }
                }
                it.errorPath = $currentErrorPath;
            }
            if ($someProperties) {
                out += ' } ';
            }
            out += ' }  ';
            if ($breakOnError) {
                out += ' if (' + ($nextValid) + ') { ';
                $closingBraces += '}';
            }
        }
        var $useDefaults = it.opts.useDefaults && !it.compositeRule;
        if ($schemaKeys.length) {
            var arr4 = $schemaKeys;
            if (arr4) {
                var $propertyKey, i4 = -1, l4 = arr4.length - 1;
                while (i4 < l4) {
                    $propertyKey = arr4[i4 += 1];
                    var $sch = $schema[$propertyKey];
                    if (it.util.schemaHasRules($sch, it.RULES.all)) {
                        var $prop = it.util.getProperty($propertyKey), $passData = $data + $prop, $hasDefault = $useDefaults && $sch.default !== undefined;
                        $it.schema = $sch;
                        $it.schemaPath = $schemaPath + $prop;
                        $it.errSchemaPath = $errSchemaPath + '/' + it.util.escapeFragment($propertyKey);
                        $it.errorPath = it.util.getPath(it.errorPath, $propertyKey, it.opts.jsonPointers);
                        $it.dataPathArr[$dataNxt] = it.util.toQuotedString($propertyKey);
                        var $code = it.validate($it);
                        $it.baseId = $currentBaseId;
                        if (it.util.varOccurences($code, $nextData) < 2) {
                            $code = it.util.varReplace($code, $nextData, $passData);
                            var $useData = $passData;
                        }
                        else {
                            var $useData = $nextData;
                            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ';
                        }
                        if ($hasDefault) {
                            out += ' ' + ($code) + ' ';
                        }
                        else {
                            if ($requiredHash && $requiredHash[$propertyKey]) {
                                out += ' if ( ' + ($useData) + ' === undefined ';
                                if ($ownProperties) {
                                    out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
                                }
                                out += ') { ' + ($nextValid) + ' = false; ';
                                var $currentErrorPath = it.errorPath, $currErrSchemaPath = $errSchemaPath, $missingProperty = it.util.escapeQuotes($propertyKey);
                                if (it.opts._errorDataPathProperty) {
                                    it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
                                }
                                $errSchemaPath = it.errSchemaPath + '/required';
                                var $$outStack = $$outStack || [];
                                $$outStack.push(out);
                                out = ''; /* istanbul ignore else */
                                if (it.createErrors !== false) {
                                    out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
                                    if (it.opts.messages !== false) {
                                        out += ' , message: \'';
                                        if (it.opts._errorDataPathProperty) {
                                            out += 'is a required property';
                                        }
                                        else {
                                            out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
                                        }
                                        out += '\' ';
                                    }
                                    if (it.opts.verbose) {
                                        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                                    }
                                    out += ' } ';
                                }
                                else {
                                    out += ' {} ';
                                }
                                var __err = out;
                                out = $$outStack.pop();
                                if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                                    if (it.async) {
                                        out += ' throw new ValidationError([' + (__err) + ']); ';
                                    }
                                    else {
                                        out += ' validate.errors = [' + (__err) + ']; return false; ';
                                    }
                                }
                                else {
                                    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                                }
                                $errSchemaPath = $currErrSchemaPath;
                                it.errorPath = $currentErrorPath;
                                out += ' } else { ';
                            }
                            else {
                                if ($breakOnError) {
                                    out += ' if ( ' + ($useData) + ' === undefined ';
                                    if ($ownProperties) {
                                        out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
                                    }
                                    out += ') { ' + ($nextValid) + ' = true; } else { ';
                                }
                                else {
                                    out += ' if (' + ($useData) + ' !== undefined ';
                                    if ($ownProperties) {
                                        out += ' &&   Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
                                    }
                                    out += ' ) { ';
                                }
                            }
                            out += ' ' + ($code) + ' } ';
                        }
                    }
                    if ($breakOnError) {
                        out += ' if (' + ($nextValid) + ') { ';
                        $closingBraces += '}';
                    }
                }
            }
        }
        if ($pPropertyKeys.length) {
            var arr5 = $pPropertyKeys;
            if (arr5) {
                var $pProperty, i5 = -1, l5 = arr5.length - 1;
                while (i5 < l5) {
                    $pProperty = arr5[i5 += 1];
                    var $sch = $pProperties[$pProperty];
                    if (it.util.schemaHasRules($sch, it.RULES.all)) {
                        $it.schema = $sch;
                        $it.schemaPath = it.schemaPath + '.patternProperties' + it.util.getProperty($pProperty);
                        $it.errSchemaPath = it.errSchemaPath + '/patternProperties/' + it.util.escapeFragment($pProperty);
                        if ($ownProperties) {
                            out += ' ' + ($dataProperties) + ' = ' + ($dataProperties) + ' || Object.keys(' + ($data) + '); for (var ' + ($idx) + '=0; ' + ($idx) + '<' + ($dataProperties) + '.length; ' + ($idx) + '++) { var ' + ($key) + ' = ' + ($dataProperties) + '[' + ($idx) + ']; ';
                        }
                        else {
                            out += ' for (var ' + ($key) + ' in ' + ($data) + ') { ';
                        }
                        out += ' if (' + (it.usePattern($pProperty)) + '.test(' + ($key) + ')) { ';
                        $it.errorPath = it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
                        var $passData = $data + '[' + $key + ']';
                        $it.dataPathArr[$dataNxt] = $key;
                        var $code = it.validate($it);
                        $it.baseId = $currentBaseId;
                        if (it.util.varOccurences($code, $nextData) < 2) {
                            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
                        }
                        else {
                            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
                        }
                        if ($breakOnError) {
                            out += ' if (!' + ($nextValid) + ') break; ';
                        }
                        out += ' } ';
                        if ($breakOnError) {
                            out += ' else ' + ($nextValid) + ' = true; ';
                        }
                        out += ' }  ';
                        if ($breakOnError) {
                            out += ' if (' + ($nextValid) + ') { ';
                            $closingBraces += '}';
                        }
                    }
                }
            }
        }
        if (it.opts.patternGroups && $pgPropertyKeys.length) {
            var arr6 = $pgPropertyKeys;
            if (arr6) {
                var $pgProperty, i6 = -1, l6 = arr6.length - 1;
                while (i6 < l6) {
                    $pgProperty = arr6[i6 += 1];
                    var $pgSchema = $pgProperties[$pgProperty], $sch = $pgSchema.schema;
                    if (it.util.schemaHasRules($sch, it.RULES.all)) {
                        $it.schema = $sch;
                        $it.schemaPath = it.schemaPath + '.patternGroups' + it.util.getProperty($pgProperty) + '.schema';
                        $it.errSchemaPath = it.errSchemaPath + '/patternGroups/' + it.util.escapeFragment($pgProperty) + '/schema';
                        out += ' var pgPropCount' + ($lvl) + ' = 0;  ';
                        if ($ownProperties) {
                            out += ' ' + ($dataProperties) + ' = ' + ($dataProperties) + ' || Object.keys(' + ($data) + '); for (var ' + ($idx) + '=0; ' + ($idx) + '<' + ($dataProperties) + '.length; ' + ($idx) + '++) { var ' + ($key) + ' = ' + ($dataProperties) + '[' + ($idx) + ']; ';
                        }
                        else {
                            out += ' for (var ' + ($key) + ' in ' + ($data) + ') { ';
                        }
                        out += ' if (' + (it.usePattern($pgProperty)) + '.test(' + ($key) + ')) { pgPropCount' + ($lvl) + '++; ';
                        $it.errorPath = it.util.getPathExpr(it.errorPath, $key, it.opts.jsonPointers);
                        var $passData = $data + '[' + $key + ']';
                        $it.dataPathArr[$dataNxt] = $key;
                        var $code = it.validate($it);
                        $it.baseId = $currentBaseId;
                        if (it.util.varOccurences($code, $nextData) < 2) {
                            out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
                        }
                        else {
                            out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
                        }
                        if ($breakOnError) {
                            out += ' if (!' + ($nextValid) + ') break; ';
                        }
                        out += ' } ';
                        if ($breakOnError) {
                            out += ' else ' + ($nextValid) + ' = true; ';
                        }
                        out += ' }  ';
                        if ($breakOnError) {
                            out += ' if (' + ($nextValid) + ') { ';
                            $closingBraces += '}';
                        }
                        var $pgMin = $pgSchema.minimum, $pgMax = $pgSchema.maximum;
                        if ($pgMin !== undefined || $pgMax !== undefined) {
                            out += ' var ' + ($valid) + ' = true; ';
                            var $currErrSchemaPath = $errSchemaPath;
                            if ($pgMin !== undefined) {
                                var $limit = $pgMin, $reason = 'minimum', $moreOrLess = 'less';
                                out += ' ' + ($valid) + ' = pgPropCount' + ($lvl) + ' >= ' + ($pgMin) + '; ';
                                $errSchemaPath = it.errSchemaPath + '/patternGroups/minimum';
                                out += '  if (!' + ($valid) + ') {   ';
                                var $$outStack = $$outStack || [];
                                $$outStack.push(out);
                                out = ''; /* istanbul ignore else */
                                if (it.createErrors !== false) {
                                    out += ' { keyword: \'' + ('patternGroups') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { reason: \'' + ($reason) + '\', limit: ' + ($limit) + ', pattern: \'' + (it.util.escapeQuotes($pgProperty)) + '\' } ';
                                    if (it.opts.messages !== false) {
                                        out += ' , message: \'should NOT have ' + ($moreOrLess) + ' than ' + ($limit) + ' properties matching pattern "' + (it.util.escapeQuotes($pgProperty)) + '"\' ';
                                    }
                                    if (it.opts.verbose) {
                                        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                                    }
                                    out += ' } ';
                                }
                                else {
                                    out += ' {} ';
                                }
                                var __err = out;
                                out = $$outStack.pop();
                                if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                                    if (it.async) {
                                        out += ' throw new ValidationError([' + (__err) + ']); ';
                                    }
                                    else {
                                        out += ' validate.errors = [' + (__err) + ']; return false; ';
                                    }
                                }
                                else {
                                    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                                }
                                out += ' } ';
                                if ($pgMax !== undefined) {
                                    out += ' else ';
                                }
                            }
                            if ($pgMax !== undefined) {
                                var $limit = $pgMax, $reason = 'maximum', $moreOrLess = 'more';
                                out += ' ' + ($valid) + ' = pgPropCount' + ($lvl) + ' <= ' + ($pgMax) + '; ';
                                $errSchemaPath = it.errSchemaPath + '/patternGroups/maximum';
                                out += '  if (!' + ($valid) + ') {   ';
                                var $$outStack = $$outStack || [];
                                $$outStack.push(out);
                                out = ''; /* istanbul ignore else */
                                if (it.createErrors !== false) {
                                    out += ' { keyword: \'' + ('patternGroups') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { reason: \'' + ($reason) + '\', limit: ' + ($limit) + ', pattern: \'' + (it.util.escapeQuotes($pgProperty)) + '\' } ';
                                    if (it.opts.messages !== false) {
                                        out += ' , message: \'should NOT have ' + ($moreOrLess) + ' than ' + ($limit) + ' properties matching pattern "' + (it.util.escapeQuotes($pgProperty)) + '"\' ';
                                    }
                                    if (it.opts.verbose) {
                                        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                                    }
                                    out += ' } ';
                                }
                                else {
                                    out += ' {} ';
                                }
                                var __err = out;
                                out = $$outStack.pop();
                                if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                                    if (it.async) {
                                        out += ' throw new ValidationError([' + (__err) + ']); ';
                                    }
                                    else {
                                        out += ' validate.errors = [' + (__err) + ']; return false; ';
                                    }
                                }
                                else {
                                    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                                }
                                out += ' } ';
                            }
                            $errSchemaPath = $currErrSchemaPath;
                            if ($breakOnError) {
                                out += ' if (' + ($valid) + ') { ';
                                $closingBraces += '}';
                            }
                        }
                    }
                }
            }
        }
        if ($breakOnError) {
            out += ' ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
        }
        out = it.util.cleanUpCode(out);
        return out;
    };
}
,
/* ajv/lib/dotjs/propertyNames */ function _(require, module, exports) {
    module.exports = function generate_propertyNames(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $errs = 'errs__' + $lvl;
        var $it = it.util.copy(it);
        var $closingBraces = '';
        $it.level++;
        var $nextValid = 'valid' + $it.level;
        if (it.util.schemaHasRules($schema, it.RULES.all)) {
            $it.schema = $schema;
            $it.schemaPath = $schemaPath;
            $it.errSchemaPath = $errSchemaPath;
            var $key = 'key' + $lvl, $idx = 'idx' + $lvl, $i = 'i' + $lvl, $invalidName = '\' + ' + $key + ' + \'', $dataNxt = $it.dataLevel = it.dataLevel + 1, $nextData = 'data' + $dataNxt, $dataProperties = 'dataProperties' + $lvl, $ownProperties = it.opts.ownProperties, $currentBaseId = it.baseId;
            out += ' var ' + ($errs) + ' = errors; ';
            if ($ownProperties) {
                out += ' var ' + ($dataProperties) + ' = undefined; ';
            }
            if ($ownProperties) {
                out += ' ' + ($dataProperties) + ' = ' + ($dataProperties) + ' || Object.keys(' + ($data) + '); for (var ' + ($idx) + '=0; ' + ($idx) + '<' + ($dataProperties) + '.length; ' + ($idx) + '++) { var ' + ($key) + ' = ' + ($dataProperties) + '[' + ($idx) + ']; ';
            }
            else {
                out += ' for (var ' + ($key) + ' in ' + ($data) + ') { ';
            }
            out += ' var startErrs' + ($lvl) + ' = errors; ';
            var $passData = $key;
            var $wasComposite = it.compositeRule;
            it.compositeRule = $it.compositeRule = true;
            var $code = it.validate($it);
            $it.baseId = $currentBaseId;
            if (it.util.varOccurences($code, $nextData) < 2) {
                out += ' ' + (it.util.varReplace($code, $nextData, $passData)) + ' ';
            }
            else {
                out += ' var ' + ($nextData) + ' = ' + ($passData) + '; ' + ($code) + ' ';
            }
            it.compositeRule = $it.compositeRule = $wasComposite;
            out += ' if (!' + ($nextValid) + ') { for (var ' + ($i) + '=startErrs' + ($lvl) + '; ' + ($i) + '<errors; ' + ($i) + '++) { vErrors[' + ($i) + '].propertyName = ' + ($key) + '; }   var err =   '; /* istanbul ignore else */
            if (it.createErrors !== false) {
                out += ' { keyword: \'' + ('propertyNames') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { propertyName: \'' + ($invalidName) + '\' } ';
                if (it.opts.messages !== false) {
                    out += ' , message: \'property name \\\'' + ($invalidName) + '\\\' is invalid\' ';
                }
                if (it.opts.verbose) {
                    out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                }
                out += ' } ';
            }
            else {
                out += ' {} ';
            }
            out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
            if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                if (it.async) {
                    out += ' throw new ValidationError(vErrors); ';
                }
                else {
                    out += ' validate.errors = vErrors; return false; ';
                }
            }
            if ($breakOnError) {
                out += ' break; ';
            }
            out += ' } }';
        }
        if ($breakOnError) {
            out += ' ' + ($closingBraces) + ' if (' + ($errs) + ' == errors) {';
        }
        out = it.util.cleanUpCode(out);
        return out;
    };
}
,
/* ajv/lib/dotjs/ref */ function _(require, module, exports) {
    module.exports = function generate_ref(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $valid = 'valid' + $lvl;
        var $async, $refCode;
        if ($schema == '#' || $schema == '#/') {
            if (it.isRoot) {
                $async = it.async;
                $refCode = 'validate';
            }
            else {
                $async = it.root.schema.$async === true;
                $refCode = 'root.refVal[0]';
            }
        }
        else {
            var $refVal = it.resolveRef(it.baseId, $schema, it.isRoot);
            if ($refVal === undefined) {
                var $message = it.MissingRefError.message(it.baseId, $schema);
                if (it.opts.missingRefs == 'fail') {
                    it.logger.error($message);
                    var $$outStack = $$outStack || [];
                    $$outStack.push(out);
                    out = ''; /* istanbul ignore else */
                    if (it.createErrors !== false) {
                        out += ' { keyword: \'' + ('$ref') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { ref: \'' + (it.util.escapeQuotes($schema)) + '\' } ';
                        if (it.opts.messages !== false) {
                            out += ' , message: \'can\\\'t resolve reference ' + (it.util.escapeQuotes($schema)) + '\' ';
                        }
                        if (it.opts.verbose) {
                            out += ' , schema: ' + (it.util.toQuotedString($schema)) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                        }
                        out += ' } ';
                    }
                    else {
                        out += ' {} ';
                    }
                    var __err = out;
                    out = $$outStack.pop();
                    if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                        if (it.async) {
                            out += ' throw new ValidationError([' + (__err) + ']); ';
                        }
                        else {
                            out += ' validate.errors = [' + (__err) + ']; return false; ';
                        }
                    }
                    else {
                        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                    }
                    if ($breakOnError) {
                        out += ' if (false) { ';
                    }
                }
                else if (it.opts.missingRefs == 'ignore') {
                    it.logger.warn($message);
                    if ($breakOnError) {
                        out += ' if (true) { ';
                    }
                }
                else {
                    throw new it.MissingRefError(it.baseId, $schema, $message);
                }
            }
            else if ($refVal.inline) {
                var $it = it.util.copy(it);
                $it.level++;
                var $nextValid = 'valid' + $it.level;
                $it.schema = $refVal.schema;
                $it.schemaPath = '';
                $it.errSchemaPath = $schema;
                var $code = it.validate($it).replace(/validate\.schema/g, $refVal.code);
                out += ' ' + ($code) + ' ';
                if ($breakOnError) {
                    out += ' if (' + ($nextValid) + ') { ';
                }
            }
            else {
                $async = $refVal.$async === true;
                $refCode = $refVal.code;
            }
        }
        if ($refCode) {
            var $$outStack = $$outStack || [];
            $$outStack.push(out);
            out = '';
            if (it.opts.passContext) {
                out += ' ' + ($refCode) + '.call(this, ';
            }
            else {
                out += ' ' + ($refCode) + '( ';
            }
            out += ' ' + ($data) + ', (dataPath || \'\')';
            if (it.errorPath != '""') {
                out += ' + ' + (it.errorPath);
            }
            var $parentData = $dataLvl ? 'data' + (($dataLvl - 1) || '') : 'parentData', $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : 'parentDataProperty';
            out += ' , ' + ($parentData) + ' , ' + ($parentDataProperty) + ', rootData)  ';
            var __callValidate = out;
            out = $$outStack.pop();
            if ($async) {
                if (!it.async)
                    throw new Error('async schema referenced by sync schema');
                if ($breakOnError) {
                    out += ' var ' + ($valid) + '; ';
                }
                out += ' try { ' + (it.yieldAwait) + ' ' + (__callValidate) + '; ';
                if ($breakOnError) {
                    out += ' ' + ($valid) + ' = true; ';
                }
                out += ' } catch (e) { if (!(e instanceof ValidationError)) throw e; if (vErrors === null) vErrors = e.errors; else vErrors = vErrors.concat(e.errors); errors = vErrors.length; ';
                if ($breakOnError) {
                    out += ' ' + ($valid) + ' = false; ';
                }
                out += ' } ';
                if ($breakOnError) {
                    out += ' if (' + ($valid) + ') { ';
                }
            }
            else {
                out += ' if (!' + (__callValidate) + ') { if (vErrors === null) vErrors = ' + ($refCode) + '.errors; else vErrors = vErrors.concat(' + ($refCode) + '.errors); errors = vErrors.length; } ';
                if ($breakOnError) {
                    out += ' else { ';
                }
            }
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/required */ function _(require, module, exports) {
    module.exports = function generate_required(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $valid = 'valid' + $lvl;
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
            out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
            $schemaValue = 'schema' + $lvl;
        }
        else {
            $schemaValue = $schema;
        }
        var $vSchema = 'schema' + $lvl;
        if (!$isData) {
            if ($schema.length < it.opts.loopRequired && it.schema.properties && Object.keys(it.schema.properties).length) {
                var $required = [];
                var arr1 = $schema;
                if (arr1) {
                    var $property, i1 = -1, l1 = arr1.length - 1;
                    while (i1 < l1) {
                        $property = arr1[i1 += 1];
                        var $propertySch = it.schema.properties[$property];
                        if (!($propertySch && it.util.schemaHasRules($propertySch, it.RULES.all))) {
                            $required[$required.length] = $property;
                        }
                    }
                }
            }
            else {
                var $required = $schema;
            }
        }
        if ($isData || $required.length) {
            var $currentErrorPath = it.errorPath, $loopRequired = $isData || $required.length >= it.opts.loopRequired, $ownProperties = it.opts.ownProperties;
            if ($breakOnError) {
                out += ' var missing' + ($lvl) + '; ';
                if ($loopRequired) {
                    if (!$isData) {
                        out += ' var ' + ($vSchema) + ' = validate.schema' + ($schemaPath) + '; ';
                    }
                    var $i = 'i' + $lvl, $propertyPath = 'schema' + $lvl + '[' + $i + ']', $missingProperty = '\' + ' + $propertyPath + ' + \'';
                    if (it.opts._errorDataPathProperty) {
                        it.errorPath = it.util.getPathExpr($currentErrorPath, $propertyPath, it.opts.jsonPointers);
                    }
                    out += ' var ' + ($valid) + ' = true; ';
                    if ($isData) {
                        out += ' if (schema' + ($lvl) + ' === undefined) ' + ($valid) + ' = true; else if (!Array.isArray(schema' + ($lvl) + ')) ' + ($valid) + ' = false; else {';
                    }
                    out += ' for (var ' + ($i) + ' = 0; ' + ($i) + ' < ' + ($vSchema) + '.length; ' + ($i) + '++) { ' + ($valid) + ' = ' + ($data) + '[' + ($vSchema) + '[' + ($i) + ']] !== undefined ';
                    if ($ownProperties) {
                        out += ' &&   Object.prototype.hasOwnProperty.call(' + ($data) + ', ' + ($vSchema) + '[' + ($i) + ']) ';
                    }
                    out += '; if (!' + ($valid) + ') break; } ';
                    if ($isData) {
                        out += '  }  ';
                    }
                    out += '  if (!' + ($valid) + ') {   ';
                    var $$outStack = $$outStack || [];
                    $$outStack.push(out);
                    out = ''; /* istanbul ignore else */
                    if (it.createErrors !== false) {
                        out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
                        if (it.opts.messages !== false) {
                            out += ' , message: \'';
                            if (it.opts._errorDataPathProperty) {
                                out += 'is a required property';
                            }
                            else {
                                out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
                            }
                            out += '\' ';
                        }
                        if (it.opts.verbose) {
                            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                        }
                        out += ' } ';
                    }
                    else {
                        out += ' {} ';
                    }
                    var __err = out;
                    out = $$outStack.pop();
                    if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                        if (it.async) {
                            out += ' throw new ValidationError([' + (__err) + ']); ';
                        }
                        else {
                            out += ' validate.errors = [' + (__err) + ']; return false; ';
                        }
                    }
                    else {
                        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                    }
                    out += ' } else { ';
                }
                else {
                    out += ' if ( ';
                    var arr2 = $required;
                    if (arr2) {
                        var $propertyKey, $i = -1, l2 = arr2.length - 1;
                        while ($i < l2) {
                            $propertyKey = arr2[$i += 1];
                            if ($i) {
                                out += ' || ';
                            }
                            var $prop = it.util.getProperty($propertyKey), $useData = $data + $prop;
                            out += ' ( ( ' + ($useData) + ' === undefined ';
                            if ($ownProperties) {
                                out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
                            }
                            out += ') && (missing' + ($lvl) + ' = ' + (it.util.toQuotedString(it.opts.jsonPointers ? $propertyKey : $prop)) + ') ) ';
                        }
                    }
                    out += ') {  ';
                    var $propertyPath = 'missing' + $lvl, $missingProperty = '\' + ' + $propertyPath + ' + \'';
                    if (it.opts._errorDataPathProperty) {
                        it.errorPath = it.opts.jsonPointers ? it.util.getPathExpr($currentErrorPath, $propertyPath, true) : $currentErrorPath + ' + ' + $propertyPath;
                    }
                    var $$outStack = $$outStack || [];
                    $$outStack.push(out);
                    out = ''; /* istanbul ignore else */
                    if (it.createErrors !== false) {
                        out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
                        if (it.opts.messages !== false) {
                            out += ' , message: \'';
                            if (it.opts._errorDataPathProperty) {
                                out += 'is a required property';
                            }
                            else {
                                out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
                            }
                            out += '\' ';
                        }
                        if (it.opts.verbose) {
                            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                        }
                        out += ' } ';
                    }
                    else {
                        out += ' {} ';
                    }
                    var __err = out;
                    out = $$outStack.pop();
                    if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                        if (it.async) {
                            out += ' throw new ValidationError([' + (__err) + ']); ';
                        }
                        else {
                            out += ' validate.errors = [' + (__err) + ']; return false; ';
                        }
                    }
                    else {
                        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                    }
                    out += ' } else { ';
                }
            }
            else {
                if ($loopRequired) {
                    if (!$isData) {
                        out += ' var ' + ($vSchema) + ' = validate.schema' + ($schemaPath) + '; ';
                    }
                    var $i = 'i' + $lvl, $propertyPath = 'schema' + $lvl + '[' + $i + ']', $missingProperty = '\' + ' + $propertyPath + ' + \'';
                    if (it.opts._errorDataPathProperty) {
                        it.errorPath = it.util.getPathExpr($currentErrorPath, $propertyPath, it.opts.jsonPointers);
                    }
                    if ($isData) {
                        out += ' if (' + ($vSchema) + ' && !Array.isArray(' + ($vSchema) + ')) {  var err =   '; /* istanbul ignore else */
                        if (it.createErrors !== false) {
                            out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
                            if (it.opts.messages !== false) {
                                out += ' , message: \'';
                                if (it.opts._errorDataPathProperty) {
                                    out += 'is a required property';
                                }
                                else {
                                    out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
                                }
                                out += '\' ';
                            }
                            if (it.opts.verbose) {
                                out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                            }
                            out += ' } ';
                        }
                        else {
                            out += ' {} ';
                        }
                        out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } else if (' + ($vSchema) + ' !== undefined) { ';
                    }
                    out += ' for (var ' + ($i) + ' = 0; ' + ($i) + ' < ' + ($vSchema) + '.length; ' + ($i) + '++) { if (' + ($data) + '[' + ($vSchema) + '[' + ($i) + ']] === undefined ';
                    if ($ownProperties) {
                        out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', ' + ($vSchema) + '[' + ($i) + ']) ';
                    }
                    out += ') {  var err =   '; /* istanbul ignore else */
                    if (it.createErrors !== false) {
                        out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
                        if (it.opts.messages !== false) {
                            out += ' , message: \'';
                            if (it.opts._errorDataPathProperty) {
                                out += 'is a required property';
                            }
                            else {
                                out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
                            }
                            out += '\' ';
                        }
                        if (it.opts.verbose) {
                            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                        }
                        out += ' } ';
                    }
                    else {
                        out += ' {} ';
                    }
                    out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } } ';
                    if ($isData) {
                        out += '  }  ';
                    }
                }
                else {
                    var arr3 = $required;
                    if (arr3) {
                        var $propertyKey, i3 = -1, l3 = arr3.length - 1;
                        while (i3 < l3) {
                            $propertyKey = arr3[i3 += 1];
                            var $prop = it.util.getProperty($propertyKey), $missingProperty = it.util.escapeQuotes($propertyKey), $useData = $data + $prop;
                            if (it.opts._errorDataPathProperty) {
                                it.errorPath = it.util.getPath($currentErrorPath, $propertyKey, it.opts.jsonPointers);
                            }
                            out += ' if ( ' + ($useData) + ' === undefined ';
                            if ($ownProperties) {
                                out += ' || ! Object.prototype.hasOwnProperty.call(' + ($data) + ', \'' + (it.util.escapeQuotes($propertyKey)) + '\') ';
                            }
                            out += ') {  var err =   '; /* istanbul ignore else */
                            if (it.createErrors !== false) {
                                out += ' { keyword: \'' + ('required') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { missingProperty: \'' + ($missingProperty) + '\' } ';
                                if (it.opts.messages !== false) {
                                    out += ' , message: \'';
                                    if (it.opts._errorDataPathProperty) {
                                        out += 'is a required property';
                                    }
                                    else {
                                        out += 'should have required property \\\'' + ($missingProperty) + '\\\'';
                                    }
                                    out += '\' ';
                                }
                                if (it.opts.verbose) {
                                    out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                                }
                                out += ' } ';
                            }
                            else {
                                out += ' {} ';
                            }
                            out += ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; } ';
                        }
                    }
                }
            }
            it.errorPath = $currentErrorPath;
        }
        else if ($breakOnError) {
            out += ' if (true) {';
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/uniqueItems */ function _(require, module, exports) {
    module.exports = function generate_uniqueItems(it, $keyword, $ruleType) {
        var out = ' ';
        var $lvl = it.level;
        var $dataLvl = it.dataLevel;
        var $schema = it.schema[$keyword];
        var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
        var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
        var $breakOnError = !it.opts.allErrors;
        var $data = 'data' + ($dataLvl || '');
        var $valid = 'valid' + $lvl;
        var $isData = it.opts.$data && $schema && $schema.$data, $schemaValue;
        if ($isData) {
            out += ' var schema' + ($lvl) + ' = ' + (it.util.getData($schema.$data, $dataLvl, it.dataPathArr)) + '; ';
            $schemaValue = 'schema' + $lvl;
        }
        else {
            $schemaValue = $schema;
        }
        if (($schema || $isData) && it.opts.uniqueItems !== false) {
            if ($isData) {
                out += ' var ' + ($valid) + '; if (' + ($schemaValue) + ' === false || ' + ($schemaValue) + ' === undefined) ' + ($valid) + ' = true; else if (typeof ' + ($schemaValue) + ' != \'boolean\') ' + ($valid) + ' = false; else { ';
            }
            out += ' var ' + ($valid) + ' = true; if (' + ($data) + '.length > 1) { var i = ' + ($data) + '.length, j; outer: for (;i--;) { for (j = i; j--;) { if (equal(' + ($data) + '[i], ' + ($data) + '[j])) { ' + ($valid) + ' = false; break outer; } } } } ';
            if ($isData) {
                out += '  }  ';
            }
            out += ' if (!' + ($valid) + ') {   ';
            var $$outStack = $$outStack || [];
            $$outStack.push(out);
            out = ''; /* istanbul ignore else */
            if (it.createErrors !== false) {
                out += ' { keyword: \'' + ('uniqueItems') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { i: i, j: j } ';
                if (it.opts.messages !== false) {
                    out += ' , message: \'should NOT have duplicate items (items ## \' + j + \' and \' + i + \' are identical)\' ';
                }
                if (it.opts.verbose) {
                    out += ' , schema:  ';
                    if ($isData) {
                        out += 'validate.schema' + ($schemaPath);
                    }
                    else {
                        out += '' + ($schema);
                    }
                    out += '         , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                }
                out += ' } ';
            }
            else {
                out += ' {} ';
            }
            var __err = out;
            out = $$outStack.pop();
            if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                if (it.async) {
                    out += ' throw new ValidationError([' + (__err) + ']); ';
                }
                else {
                    out += ' validate.errors = [' + (__err) + ']; return false; ';
                }
            }
            else {
                out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
            }
            out += ' } ';
            if ($breakOnError) {
                out += ' else { ';
            }
        }
        else {
            if ($breakOnError) {
                out += ' if (true) { ';
            }
        }
        return out;
    };
}
,
/* ajv/lib/dotjs/validate */ function _(require, module, exports) {
    module.exports = function generate_validate(it, $keyword, $ruleType) {
        var out = '';
        var $async = it.schema.$async === true, $refKeywords = it.util.schemaHasRulesExcept(it.schema, it.RULES.all, '$ref'), $id = it.self._getId(it.schema);
        if (it.isTop) {
            if ($async) {
                it.async = true;
                var $es7 = it.opts.async == 'es7';
                it.yieldAwait = $es7 ? 'await' : 'yield';
            }
            out += ' var validate = ';
            if ($async) {
                if ($es7) {
                    out += ' (async function ';
                }
                else {
                    if (it.opts.async != '*') {
                        out += 'co.wrap';
                    }
                    out += '(function* ';
                }
            }
            else {
                out += ' (function ';
            }
            out += ' (data, dataPath, parentData, parentDataProperty, rootData) { \'use strict\'; ';
            if ($id && (it.opts.sourceCode || it.opts.processCode)) {
                out += ' ' + ('/\*# sourceURL=' + $id + ' */') + ' ';
            }
        }
        if (typeof it.schema == 'boolean' || !($refKeywords || it.schema.$ref)) {
            var $keyword = 'false schema';
            var $lvl = it.level;
            var $dataLvl = it.dataLevel;
            var $schema = it.schema[$keyword];
            var $schemaPath = it.schemaPath + it.util.getProperty($keyword);
            var $errSchemaPath = it.errSchemaPath + '/' + $keyword;
            var $breakOnError = !it.opts.allErrors;
            var $errorKeyword;
            var $data = 'data' + ($dataLvl || '');
            var $valid = 'valid' + $lvl;
            if (it.schema === false) {
                if (it.isTop) {
                    $breakOnError = true;
                }
                else {
                    out += ' var ' + ($valid) + ' = false; ';
                }
                var $$outStack = $$outStack || [];
                $$outStack.push(out);
                out = ''; /* istanbul ignore else */
                if (it.createErrors !== false) {
                    out += ' { keyword: \'' + ($errorKeyword || 'false schema') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: {} ';
                    if (it.opts.messages !== false) {
                        out += ' , message: \'boolean schema is false\' ';
                    }
                    if (it.opts.verbose) {
                        out += ' , schema: false , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                    }
                    out += ' } ';
                }
                else {
                    out += ' {} ';
                }
                var __err = out;
                out = $$outStack.pop();
                if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                    if (it.async) {
                        out += ' throw new ValidationError([' + (__err) + ']); ';
                    }
                    else {
                        out += ' validate.errors = [' + (__err) + ']; return false; ';
                    }
                }
                else {
                    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                }
            }
            else {
                if (it.isTop) {
                    if ($async) {
                        out += ' return data; ';
                    }
                    else {
                        out += ' validate.errors = null; return true; ';
                    }
                }
                else {
                    out += ' var ' + ($valid) + ' = true; ';
                }
            }
            if (it.isTop) {
                out += ' }); return validate; ';
            }
            return out;
        }
        if (it.isTop) {
            var $top = it.isTop, $lvl = it.level = 0, $dataLvl = it.dataLevel = 0, $data = 'data';
            it.rootId = it.resolve.fullPath(it.self._getId(it.root.schema));
            it.baseId = it.baseId || it.rootId;
            delete it.isTop;
            it.dataPathArr = [undefined];
            out += ' var vErrors = null; ';
            out += ' var errors = 0;     ';
            out += ' if (rootData === undefined) rootData = data; ';
        }
        else {
            var $lvl = it.level, $dataLvl = it.dataLevel, $data = 'data' + ($dataLvl || '');
            if ($id)
                it.baseId = it.resolve.url(it.baseId, $id);
            if ($async && !it.async)
                throw new Error('async schema in sync schema');
            out += ' var errs_' + ($lvl) + ' = errors;';
        }
        var $valid = 'valid' + $lvl, $breakOnError = !it.opts.allErrors, $closingBraces1 = '', $closingBraces2 = '';
        var $errorKeyword;
        var $typeSchema = it.schema.type, $typeIsArray = Array.isArray($typeSchema);
        if ($typeIsArray && $typeSchema.length == 1) {
            $typeSchema = $typeSchema[0];
            $typeIsArray = false;
        }
        if (it.schema.$ref && $refKeywords) {
            if (it.opts.extendRefs == 'fail') {
                throw new Error('$ref: validation keywords used in schema at path "' + it.errSchemaPath + '" (see option extendRefs)');
            }
            else if (it.opts.extendRefs !== true) {
                $refKeywords = false;
                it.logger.warn('$ref: keywords ignored in schema at path "' + it.errSchemaPath + '"');
            }
        }
        if ($typeSchema) {
            if (it.opts.coerceTypes) {
                var $coerceToTypes = it.util.coerceToTypes(it.opts.coerceTypes, $typeSchema);
            }
            var $rulesGroup = it.RULES.types[$typeSchema];
            if ($coerceToTypes || $typeIsArray || $rulesGroup === true || ($rulesGroup && !$shouldUseGroup($rulesGroup))) {
                var $schemaPath = it.schemaPath + '.type', $errSchemaPath = it.errSchemaPath + '/type';
                var $schemaPath = it.schemaPath + '.type', $errSchemaPath = it.errSchemaPath + '/type', $method = $typeIsArray ? 'checkDataTypes' : 'checkDataType';
                out += ' if (' + (it.util[$method]($typeSchema, $data, true)) + ') { ';
                if ($coerceToTypes) {
                    var $dataType = 'dataType' + $lvl, $coerced = 'coerced' + $lvl;
                    out += ' var ' + ($dataType) + ' = typeof ' + ($data) + '; ';
                    if (it.opts.coerceTypes == 'array') {
                        out += ' if (' + ($dataType) + ' == \'object\' && Array.isArray(' + ($data) + ')) ' + ($dataType) + ' = \'array\'; ';
                    }
                    out += ' var ' + ($coerced) + ' = undefined; ';
                    var $bracesCoercion = '';
                    var arr1 = $coerceToTypes;
                    if (arr1) {
                        var $type, $i = -1, l1 = arr1.length - 1;
                        while ($i < l1) {
                            $type = arr1[$i += 1];
                            if ($i) {
                                out += ' if (' + ($coerced) + ' === undefined) { ';
                                $bracesCoercion += '}';
                            }
                            if (it.opts.coerceTypes == 'array' && $type != 'array') {
                                out += ' if (' + ($dataType) + ' == \'array\' && ' + ($data) + '.length == 1) { ' + ($coerced) + ' = ' + ($data) + ' = ' + ($data) + '[0]; ' + ($dataType) + ' = typeof ' + ($data) + ';  } ';
                            }
                            if ($type == 'string') {
                                out += ' if (' + ($dataType) + ' == \'number\' || ' + ($dataType) + ' == \'boolean\') ' + ($coerced) + ' = \'\' + ' + ($data) + '; else if (' + ($data) + ' === null) ' + ($coerced) + ' = \'\'; ';
                            }
                            else if ($type == 'number' || $type == 'integer') {
                                out += ' if (' + ($dataType) + ' == \'boolean\' || ' + ($data) + ' === null || (' + ($dataType) + ' == \'string\' && ' + ($data) + ' && ' + ($data) + ' == +' + ($data) + ' ';
                                if ($type == 'integer') {
                                    out += ' && !(' + ($data) + ' % 1)';
                                }
                                out += ')) ' + ($coerced) + ' = +' + ($data) + '; ';
                            }
                            else if ($type == 'boolean') {
                                out += ' if (' + ($data) + ' === \'false\' || ' + ($data) + ' === 0 || ' + ($data) + ' === null) ' + ($coerced) + ' = false; else if (' + ($data) + ' === \'true\' || ' + ($data) + ' === 1) ' + ($coerced) + ' = true; ';
                            }
                            else if ($type == 'null') {
                                out += ' if (' + ($data) + ' === \'\' || ' + ($data) + ' === 0 || ' + ($data) + ' === false) ' + ($coerced) + ' = null; ';
                            }
                            else if (it.opts.coerceTypes == 'array' && $type == 'array') {
                                out += ' if (' + ($dataType) + ' == \'string\' || ' + ($dataType) + ' == \'number\' || ' + ($dataType) + ' == \'boolean\' || ' + ($data) + ' == null) ' + ($coerced) + ' = [' + ($data) + ']; ';
                            }
                        }
                    }
                    out += ' ' + ($bracesCoercion) + ' if (' + ($coerced) + ' === undefined) {   ';
                    var $$outStack = $$outStack || [];
                    $$outStack.push(out);
                    out = ''; /* istanbul ignore else */
                    if (it.createErrors !== false) {
                        out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
                        if ($typeIsArray) {
                            out += '' + ($typeSchema.join(","));
                        }
                        else {
                            out += '' + ($typeSchema);
                        }
                        out += '\' } ';
                        if (it.opts.messages !== false) {
                            out += ' , message: \'should be ';
                            if ($typeIsArray) {
                                out += '' + ($typeSchema.join(","));
                            }
                            else {
                                out += '' + ($typeSchema);
                            }
                            out += '\' ';
                        }
                        if (it.opts.verbose) {
                            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                        }
                        out += ' } ';
                    }
                    else {
                        out += ' {} ';
                    }
                    var __err = out;
                    out = $$outStack.pop();
                    if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                        if (it.async) {
                            out += ' throw new ValidationError([' + (__err) + ']); ';
                        }
                        else {
                            out += ' validate.errors = [' + (__err) + ']; return false; ';
                        }
                    }
                    else {
                        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                    }
                    out += ' } else {  ';
                    var $parentData = $dataLvl ? 'data' + (($dataLvl - 1) || '') : 'parentData', $parentDataProperty = $dataLvl ? it.dataPathArr[$dataLvl] : 'parentDataProperty';
                    out += ' ' + ($data) + ' = ' + ($coerced) + '; ';
                    if (!$dataLvl) {
                        out += 'if (' + ($parentData) + ' !== undefined)';
                    }
                    out += ' ' + ($parentData) + '[' + ($parentDataProperty) + '] = ' + ($coerced) + '; } ';
                }
                else {
                    var $$outStack = $$outStack || [];
                    $$outStack.push(out);
                    out = ''; /* istanbul ignore else */
                    if (it.createErrors !== false) {
                        out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
                        if ($typeIsArray) {
                            out += '' + ($typeSchema.join(","));
                        }
                        else {
                            out += '' + ($typeSchema);
                        }
                        out += '\' } ';
                        if (it.opts.messages !== false) {
                            out += ' , message: \'should be ';
                            if ($typeIsArray) {
                                out += '' + ($typeSchema.join(","));
                            }
                            else {
                                out += '' + ($typeSchema);
                            }
                            out += '\' ';
                        }
                        if (it.opts.verbose) {
                            out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                        }
                        out += ' } ';
                    }
                    else {
                        out += ' {} ';
                    }
                    var __err = out;
                    out = $$outStack.pop();
                    if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                        if (it.async) {
                            out += ' throw new ValidationError([' + (__err) + ']); ';
                        }
                        else {
                            out += ' validate.errors = [' + (__err) + ']; return false; ';
                        }
                    }
                    else {
                        out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                    }
                }
                out += ' } ';
            }
        }
        if (it.schema.$ref && !$refKeywords) {
            out += ' ' + (it.RULES.all.$ref.code(it, '$ref')) + ' ';
            if ($breakOnError) {
                out += ' } if (errors === ';
                if ($top) {
                    out += '0';
                }
                else {
                    out += 'errs_' + ($lvl);
                }
                out += ') { ';
                $closingBraces2 += '}';
            }
        }
        else {
            if (it.opts.v5 && it.schema.patternGroups) {
                it.logger.warn('keyword "patternGroups" is deprecated and disabled. Use option patternGroups: true to enable.');
            }
            var arr2 = it.RULES;
            if (arr2) {
                var $rulesGroup, i2 = -1, l2 = arr2.length - 1;
                while (i2 < l2) {
                    $rulesGroup = arr2[i2 += 1];
                    if ($shouldUseGroup($rulesGroup)) {
                        if ($rulesGroup.type) {
                            out += ' if (' + (it.util.checkDataType($rulesGroup.type, $data)) + ') { ';
                        }
                        if (it.opts.useDefaults && !it.compositeRule) {
                            if ($rulesGroup.type == 'object' && it.schema.properties) {
                                var $schema = it.schema.properties, $schemaKeys = Object.keys($schema);
                                var arr3 = $schemaKeys;
                                if (arr3) {
                                    var $propertyKey, i3 = -1, l3 = arr3.length - 1;
                                    while (i3 < l3) {
                                        $propertyKey = arr3[i3 += 1];
                                        var $sch = $schema[$propertyKey];
                                        if ($sch.default !== undefined) {
                                            var $passData = $data + it.util.getProperty($propertyKey);
                                            out += '  if (' + ($passData) + ' === undefined) ' + ($passData) + ' = ';
                                            if (it.opts.useDefaults == 'shared') {
                                                out += ' ' + (it.useDefault($sch.default)) + ' ';
                                            }
                                            else {
                                                out += ' ' + (JSON.stringify($sch.default)) + ' ';
                                            }
                                            out += '; ';
                                        }
                                    }
                                }
                            }
                            else if ($rulesGroup.type == 'array' && Array.isArray(it.schema.items)) {
                                var arr4 = it.schema.items;
                                if (arr4) {
                                    var $sch, $i = -1, l4 = arr4.length - 1;
                                    while ($i < l4) {
                                        $sch = arr4[$i += 1];
                                        if ($sch.default !== undefined) {
                                            var $passData = $data + '[' + $i + ']';
                                            out += '  if (' + ($passData) + ' === undefined) ' + ($passData) + ' = ';
                                            if (it.opts.useDefaults == 'shared') {
                                                out += ' ' + (it.useDefault($sch.default)) + ' ';
                                            }
                                            else {
                                                out += ' ' + (JSON.stringify($sch.default)) + ' ';
                                            }
                                            out += '; ';
                                        }
                                    }
                                }
                            }
                        }
                        var arr5 = $rulesGroup.rules;
                        if (arr5) {
                            var $rule, i5 = -1, l5 = arr5.length - 1;
                            while (i5 < l5) {
                                $rule = arr5[i5 += 1];
                                if ($shouldUseRule($rule)) {
                                    var $code = $rule.code(it, $rule.keyword, $rulesGroup.type);
                                    if ($code) {
                                        out += ' ' + ($code) + ' ';
                                        if ($breakOnError) {
                                            $closingBraces1 += '}';
                                        }
                                    }
                                }
                            }
                        }
                        if ($breakOnError) {
                            out += ' ' + ($closingBraces1) + ' ';
                            $closingBraces1 = '';
                        }
                        if ($rulesGroup.type) {
                            out += ' } ';
                            if ($typeSchema && $typeSchema === $rulesGroup.type && !$coerceToTypes) {
                                out += ' else { ';
                                var $schemaPath = it.schemaPath + '.type', $errSchemaPath = it.errSchemaPath + '/type';
                                var $$outStack = $$outStack || [];
                                $$outStack.push(out);
                                out = ''; /* istanbul ignore else */
                                if (it.createErrors !== false) {
                                    out += ' { keyword: \'' + ($errorKeyword || 'type') + '\' , dataPath: (dataPath || \'\') + ' + (it.errorPath) + ' , schemaPath: ' + (it.util.toQuotedString($errSchemaPath)) + ' , params: { type: \'';
                                    if ($typeIsArray) {
                                        out += '' + ($typeSchema.join(","));
                                    }
                                    else {
                                        out += '' + ($typeSchema);
                                    }
                                    out += '\' } ';
                                    if (it.opts.messages !== false) {
                                        out += ' , message: \'should be ';
                                        if ($typeIsArray) {
                                            out += '' + ($typeSchema.join(","));
                                        }
                                        else {
                                            out += '' + ($typeSchema);
                                        }
                                        out += '\' ';
                                    }
                                    if (it.opts.verbose) {
                                        out += ' , schema: validate.schema' + ($schemaPath) + ' , parentSchema: validate.schema' + (it.schemaPath) + ' , data: ' + ($data) + ' ';
                                    }
                                    out += ' } ';
                                }
                                else {
                                    out += ' {} ';
                                }
                                var __err = out;
                                out = $$outStack.pop();
                                if (!it.compositeRule && $breakOnError) { /* istanbul ignore if */
                                    if (it.async) {
                                        out += ' throw new ValidationError([' + (__err) + ']); ';
                                    }
                                    else {
                                        out += ' validate.errors = [' + (__err) + ']; return false; ';
                                    }
                                }
                                else {
                                    out += ' var err = ' + (__err) + ';  if (vErrors === null) vErrors = [err]; else vErrors.push(err); errors++; ';
                                }
                                out += ' } ';
                            }
                        }
                        if ($breakOnError) {
                            out += ' if (errors === ';
                            if ($top) {
                                out += '0';
                            }
                            else {
                                out += 'errs_' + ($lvl);
                            }
                            out += ') { ';
                            $closingBraces2 += '}';
                        }
                    }
                }
            }
        }
        if ($breakOnError) {
            out += ' ' + ($closingBraces2) + ' ';
        }
        if ($top) {
            if ($async) {
                out += ' if (errors === 0) return data;           ';
                out += ' else throw new ValidationError(vErrors); ';
            }
            else {
                out += ' validate.errors = vErrors; ';
                out += ' return errors === 0;       ';
            }
            out += ' }); return validate;';
        }
        else {
            out += ' var ' + ($valid) + ' = errors === errs_' + ($lvl) + ';';
        }
        out = it.util.cleanUpCode(out);
        if ($top) {
            out = it.util.finalCleanUpCode(out, $async);
        }
        function $shouldUseGroup($rulesGroup) {
            var rules = $rulesGroup.rules;
            for (var i = 0; i < rules.length; i++)
                if ($shouldUseRule(rules[i]))
                    return true;
        }
        function $shouldUseRule($rule) {
            return it.schema[$rule.keyword] !== undefined || ($rule.implements && $ruleImplementsSomeKeyword($rule));
        }
        function $ruleImplementsSomeKeyword($rule) {
            var impl = $rule.implements;
            for (var i = 0; i < impl.length; i++)
                if (it.schema[impl[i]] !== undefined)
                    return true;
        }
        return out;
    };
}
,
/* ajv/lib/keyword */ function _(require, module, exports) {
    var IDENTIFIER = /^[a-z_$][a-z0-9_$-]*$/i;
    var customRuleCode = require(23) /* ./dotjs/custom */;
    module.exports = {
        add: addKeyword,
        get: getKeyword,
        remove: removeKeyword
    };
    /**
     * Define custom keyword
     * @this  Ajv
     * @param {String} keyword custom keyword, should be unique (including different from all standard, custom and macro keywords).
     * @param {Object} definition keyword definition object with properties `type` (type(s) which the keyword applies to), `validate` or `compile`.
     * @return {Ajv} this for method chaining
     */
    function addKeyword(keyword, definition) {
        /* jshint validthis: true */
        /* eslint no-shadow: 0 */
        var RULES = this.RULES;
        if (RULES.keywords[keyword])
            throw new Error('Keyword ' + keyword + ' is already defined');
        if (!IDENTIFIER.test(keyword))
            throw new Error('Keyword ' + keyword + ' is not a valid identifier');
        if (definition) {
            if (definition.macro && definition.valid !== undefined)
                throw new Error('"valid" option cannot be used with macro keywords');
            var dataType = definition.type;
            if (Array.isArray(dataType)) {
                var i, len = dataType.length;
                for (i = 0; i < len; i++)
                    checkDataType(dataType[i]);
                for (i = 0; i < len; i++)
                    _addRule(keyword, dataType[i], definition);
            }
            else {
                if (dataType)
                    checkDataType(dataType);
                _addRule(keyword, dataType, definition);
            }
            var $data = definition.$data === true && this._opts.$data;
            if ($data && !definition.validate)
                throw new Error('$data support: "validate" function is not defined');
            var metaSchema = definition.metaSchema;
            if (metaSchema) {
                if ($data) {
                    metaSchema = {
                        anyOf: [
                            metaSchema,
                            { '$ref': 'https://raw.githubusercontent.com/epoberezkin/ajv/master/lib/refs/$data.json#' }
                        ]
                    };
                }
                definition.validateSchema = this.compile(metaSchema, true);
            }
        }
        RULES.keywords[keyword] = RULES.all[keyword] = true;
        function _addRule(keyword, dataType, definition) {
            var ruleGroup;
            for (var i = 0; i < RULES.length; i++) {
                var rg = RULES[i];
                if (rg.type == dataType) {
                    ruleGroup = rg;
                    break;
                }
            }
            if (!ruleGroup) {
                ruleGroup = { type: dataType, rules: [] };
                RULES.push(ruleGroup);
            }
            var rule = {
                keyword: keyword,
                definition: definition,
                custom: true,
                code: customRuleCode,
                implements: definition.implements
            };
            ruleGroup.rules.push(rule);
            RULES.custom[keyword] = rule;
        }
        function checkDataType(dataType) {
            if (!RULES.types[dataType])
                throw new Error('Unknown type ' + dataType);
        }
        return this;
    }
    /**
     * Get keyword
     * @this  Ajv
     * @param {String} keyword pre-defined or custom keyword.
     * @return {Object|Boolean} custom keyword definition, `true` if it is a predefined keyword, `false` otherwise.
     */
    function getKeyword(keyword) {
        /* jshint validthis: true */
        var rule = this.RULES.custom[keyword];
        return rule ? rule.definition : this.RULES.keywords[keyword] || false;
    }
    /**
     * Remove keyword
     * @this  Ajv
     * @param {String} keyword pre-defined or custom keyword.
     * @return {Ajv} this for method chaining
     */
    function removeKeyword(keyword) {
        /* jshint validthis: true */
        var RULES = this.RULES;
        delete RULES.keywords[keyword];
        delete RULES.all[keyword];
        delete RULES.custom[keyword];
        for (var i = 0; i < RULES.length; i++) {
            var rules = RULES[i].rules;
            for (var j = 0; j < rules.length; j++) {
                if (rules[j].keyword == keyword) {
                    rules.splice(j, 1);
                    break;
                }
            }
        }
        return this;
    }
}
,
/* ajv/lib/patternGroups */ function _(require, module, exports) {
    var META_SCHEMA_ID = 'http://json-schema.org/draft-06/schema';
    module.exports = function (ajv) {
        var defaultMeta = ajv._opts.defaultMeta;
        var metaSchemaRef = typeof defaultMeta == 'string'
            ? { $ref: defaultMeta }
            : ajv.getSchema(META_SCHEMA_ID)
                ? { $ref: META_SCHEMA_ID }
                : {};
        ajv.addKeyword('patternGroups', {
            // implemented in properties.jst
            metaSchema: {
                type: 'object',
                additionalProperties: {
                    type: 'object',
                    required: ['schema'],
                    properties: {
                        maximum: {
                            type: 'integer',
                            minimum: 0
                        },
                        minimum: {
                            type: 'integer',
                            minimum: 0
                        },
                        schema: metaSchemaRef
                    },
                    additionalProperties: false
                }
            }
        });
        ajv.RULES.all.properties.implements.push('patternGroups');
    };
}
,
/* ajv/lib/refs/$data.json */ function _(require, module, exports) {
    {
        "$schema";
        "http://json-schema.org/draft-06/schema#",
            "$id";
        "https://raw.githubusercontent.com/epoberezkin/ajv/master/lib/refs/$data.json#",
            "description";
        "Meta-schema for $data reference (JSON-schema extension proposal)",
            "type";
        "object",
            "required";
        ["$data"],
            "properties";
        {
            "$data";
            {
                "type";
                "string",
                    "anyOf";
                [
                    { "format": "relative-json-pointer" },
                    { "format": "json-pointer" }
                ];
            }
        }
        "additionalProperties";
        false;
    }
}
,
/* ajv/lib/refs/json-schema-draft-06.json */ function _(require, module, exports) {
    {
        "$schema";
        "http://json-schema.org/draft-06/schema#",
            "$id";
        "http://json-schema.org/draft-06/schema#",
            "title";
        "Core schema meta-schema",
            "definitions";
        {
            "schemaArray";
            {
                "type";
                "array",
                    "minItems";
                1,
                    "items";
                {
                    "$ref";
                    "#";
                }
            }
            "nonNegativeInteger";
            {
                "type";
                "integer",
                    "minimum";
                0;
            }
            "nonNegativeIntegerDefault0";
            {
                "allOf";
                [
                    { "$ref": "#/definitions/nonNegativeInteger" },
                    { "default": 0 }
                ];
            }
            "simpleTypes";
            {
                "enum";
                [
                    "array",
                    "boolean",
                    "integer",
                    "null",
                    "number",
                    "object",
                    "string"
                ];
            }
            "stringArray";
            {
                "type";
                "array",
                    "items";
                {
                    "type";
                    "string";
                }
                "uniqueItems";
                true,
                    "default";
                [];
            }
        }
        "type";
        ["object", "boolean"],
            "properties";
        {
            "$id";
            {
                "type";
                "string",
                    "format";
                "uri-reference";
            }
            "$schema";
            {
                "type";
                "string",
                    "format";
                "uri";
            }
            "$ref";
            {
                "type";
                "string",
                    "format";
                "uri-reference";
            }
            "title";
            {
                "type";
                "string";
            }
            "description";
            {
                "type";
                "string";
            }
            "default";
            { }
            "examples";
            {
                "type";
                "array",
                    "items";
                { }
            }
            "multipleOf";
            {
                "type";
                "number",
                    "exclusiveMinimum";
                0;
            }
            "maximum";
            {
                "type";
                "number";
            }
            "exclusiveMaximum";
            {
                "type";
                "number";
            }
            "minimum";
            {
                "type";
                "number";
            }
            "exclusiveMinimum";
            {
                "type";
                "number";
            }
            "maxLength";
            {
                "$ref";
                "#/definitions/nonNegativeInteger";
            }
            "minLength";
            {
                "$ref";
                "#/definitions/nonNegativeIntegerDefault0";
            }
            "pattern";
            {
                "type";
                "string",
                    "format";
                "regex";
            }
            "additionalItems";
            {
                "$ref";
                "#";
            }
            "items";
            {
                "anyOf";
                [
                    { "$ref": "#" },
                    { "$ref": "#/definitions/schemaArray" }
                ],
                    "default";
                { }
            }
            "maxItems";
            {
                "$ref";
                "#/definitions/nonNegativeInteger";
            }
            "minItems";
            {
                "$ref";
                "#/definitions/nonNegativeIntegerDefault0";
            }
            "uniqueItems";
            {
                "type";
                "boolean",
                    "default";
                false;
            }
            "contains";
            {
                "$ref";
                "#";
            }
            "maxProperties";
            {
                "$ref";
                "#/definitions/nonNegativeInteger";
            }
            "minProperties";
            {
                "$ref";
                "#/definitions/nonNegativeIntegerDefault0";
            }
            "required";
            {
                "$ref";
                "#/definitions/stringArray";
            }
            "additionalProperties";
            {
                "$ref";
                "#";
            }
            "definitions";
            {
                "type";
                "object",
                    "additionalProperties";
                {
                    "$ref";
                    "#";
                }
                "default";
                { }
            }
            "properties";
            {
                "type";
                "object",
                    "additionalProperties";
                {
                    "$ref";
                    "#";
                }
                "default";
                { }
            }
            "patternProperties";
            {
                "type";
                "object",
                    "additionalProperties";
                {
                    "$ref";
                    "#";
                }
                "default";
                { }
            }
            "dependencies";
            {
                "type";
                "object",
                    "additionalProperties";
                {
                    "anyOf";
                    [
                        { "$ref": "#" },
                        { "$ref": "#/definitions/stringArray" }
                    ];
                }
            }
            "propertyNames";
            {
                "$ref";
                "#";
            }
            "const";
            { }
            "enum";
            {
                "type";
                "array",
                    "minItems";
                1,
                    "uniqueItems";
                true;
            }
            "type";
            {
                "anyOf";
                [
                    { "$ref": "#/definitions/simpleTypes" },
                    {
                        "type": "array",
                        "items": { "$ref": "#/definitions/simpleTypes" },
                        "minItems": 1,
                        "uniqueItems": true
                    }
                ];
            }
            "format";
            {
                "type";
                "string";
            }
            "allOf";
            {
                "$ref";
                "#/definitions/schemaArray";
            }
            "anyOf";
            {
                "$ref";
                "#/definitions/schemaArray";
            }
            "oneOf";
            {
                "$ref";
                "#/definitions/schemaArray";
            }
            "not";
            {
                "$ref";
                "#";
            }
        }
        "default";
        { }
    }
}
,
/* align-text/index */ function _(require, module, exports) {
    var typeOf = require(160) /* kind-of */;
    var repeat = require(294) /* repeat-string */;
    var longest = require(261) /* longest */;
    module.exports = function alignText(val, fn) {
        var lines, type = typeOf(val);
        if (type === 'array') {
            lines = val;
        }
        else if (type === 'string') {
            lines = val.split(/(?:\r\n|\n)/);
        }
        else {
            throw new TypeError('align-text expects a string or array.');
        }
        var fnType = typeOf(fn);
        var len = lines.length;
        var max = longest(lines);
        var res = [], i = 0;
        while (len--) {
            var line = String(lines[i++]);
            var diff;
            if (fnType === 'function') {
                diff = fn(line.length, max.length, line, lines, i);
            }
            else if (fnType === 'number') {
                diff = fn;
            }
            else {
                diff = max.length - line.length;
            }
            if (typeOf(diff) === 'number') {
                res.push(repeat(' ', diff) + line);
            }
            else if (typeOf(diff) === 'object') {
                var result = repeat(diff.character || ' ', diff.indent || 0);
                res.push((diff.prefix || '') + result + line);
            }
        }
        if (type === 'array')
            return res;
        return res.join('\n');
    };
}
,
/* amdefine/amdefine */ function _(require, module, exports) {
    /**
     * Creates a define for node.
     * @param {Object} module the "module" object that is defined by Node for the
     * current module.
     * @param {Function} [requireFn]. Node's require function for the current module.
     * It only needs to be passed in Node versions before 0.5, when module.require
     * did not exist.
     * @returns {Function} a define function that is usable for the current node
     * module.
     */
    function amdefine(module, requireFn) {
        'use strict';
        var defineCache = {}, loaderCache = {}, alreadyCalled = false, path = require('path'), makeRequire, stringRequire;
        /**
         * Trims the . and .. from an array of path segments.
         * It will keep a leading path segment if a .. will become
         * the first path segment, to help with module name lookups,
         * which act like paths, but can be remapped. But the end result,
         * all paths that use this function should look normalized.
         * NOTE: this method MODIFIES the input array.
         * @param {Array} ary the array of path segments.
         */
        function trimDots(ary) {
            var i, part;
            for (i = 0; ary[i]; i += 1) {
                part = ary[i];
                if (part === '.') {
                    ary.splice(i, 1);
                    i -= 1;
                }
                else if (part === '..') {
                    if (i === 1 && (ary[2] === '..' || ary[0] === '..')) {
                        //End of the line. Keep at least one non-dot
                        //path segment at the front so it can be mapped
                        //correctly to disk. Otherwise, there is likely
                        //no path mapping for a path starting with '..'.
                        //This can still fail, but catches the most reasonable
                        //uses of ..
                        break;
                    }
                    else if (i > 0) {
                        ary.splice(i - 1, 2);
                        i -= 2;
                    }
                }
            }
        }
        function normalize(name, baseName) {
            var baseParts;
            //Adjust any relative paths.
            if (name && name.charAt(0) === '.') {
                //If have a base name, try to normalize against it,
                //otherwise, assume it is a top-level require that will
                //be relative to baseUrl in the end.
                if (baseName) {
                    baseParts = baseName.split('/');
                    baseParts = baseParts.slice(0, baseParts.length - 1);
                    baseParts = baseParts.concat(name.split('/'));
                    trimDots(baseParts);
                    name = baseParts.join('/');
                }
            }
            return name;
        }
        /**
         * Create the normalize() function passed to a loader plugin's
         * normalize method.
         */
        function makeNormalize(relName) {
            return function (name) {
                return normalize(name, relName);
            };
        }
        function makeLoad(id) {
            function load(value) {
                loaderCache[id] = value;
            }
            load.fromText = function (id, text) {
                //This one is difficult because the text can/probably uses
                //define, and any relative paths and requires should be relative
                //to that id was it would be found on disk. But this would require
                //bootstrapping a module/require fairly deeply from node core.
                //Not sure how best to go about that yet.
                throw new Error('amdefine does not implement load.fromText');
            };
            return load;
        }
        makeRequire = function (systemRequire, exports, module, relId) {
            function amdRequire(deps, callback) {
                if (typeof deps === 'string') {
                    //Synchronous, single module require('')
                    return stringRequire(systemRequire, exports, module, deps, relId);
                }
                else {
                    //Array of dependencies with a callback.
                    //Convert the dependencies to modules.
                    deps = deps.map(function (depName) {
                        return stringRequire(systemRequire, exports, module, depName, relId);
                    });
                    //Wait for next tick to call back the require call.
                    if (callback) {
                        process.nextTick(function () {
                            callback.apply(null, deps);
                        });
                    }
                }
            }
            amdRequire.toUrl = function (filePath) {
                if (filePath.indexOf('.') === 0) {
                    return normalize(filePath, path.dirname(module.filename));
                }
                else {
                    return filePath;
                }
            };
            return amdRequire;
        };
        //Favor explicit value, passed in if the module wants to support Node 0.4.
        requireFn = requireFn || function req() {
            return module.require.apply(module, arguments);
        };
        function runFactory(id, deps, factory) {
            var r, e, m, result;
            if (id) {
                e = loaderCache[id] = {};
                m = {
                    id: id,
                    uri: __filename,
                    exports: e
                };
                r = makeRequire(requireFn, e, m, id);
            }
            else {
                //Only support one define call per file
                if (alreadyCalled) {
                    throw new Error('amdefine with no module ID cannot be called more than once per file.');
                }
                alreadyCalled = true;
                //Use the real variables from node
                //Use module.exports for exports, since
                //the exports in here is amdefine exports.
                e = module.exports;
                m = module;
                r = makeRequire(requireFn, e, m, module.id);
            }
            //If there are dependencies, they are strings, so need
            //to convert them to dependency values.
            if (deps) {
                deps = deps.map(function (depName) {
                    return r(depName);
                });
            }
            //Call the factory with the right dependencies.
            if (typeof factory === 'function') {
                result = factory.apply(m.exports, deps);
            }
            else {
                result = factory;
            }
            if (result !== undefined) {
                m.exports = result;
                if (id) {
                    loaderCache[id] = m.exports;
                }
            }
        }
        stringRequire = function (systemRequire, exports, module, id, relId) {
            //Split the ID by a ! so that
            var index = id.indexOf('!'), originalId = id, prefix, plugin;
            if (index === -1) {
                id = normalize(id, relId);
                //Straight module lookup. If it is one of the special dependencies,
                //deal with it, otherwise, delegate to node.
                if (id === 'require') {
                    return makeRequire(systemRequire, exports, module, relId);
                }
                else if (id === 'exports') {
                    return exports;
                }
                else if (id === 'module') {
                    return module;
                }
                else if (loaderCache.hasOwnProperty(id)) {
                    return loaderCache[id];
                }
                else if (defineCache[id]) {
                    runFactory.apply(null, defineCache[id]);
                    return loaderCache[id];
                }
                else {
                    if (systemRequire) {
                        return systemRequire(originalId);
                    }
                    else {
                        throw new Error('No module with ID: ' + id);
                    }
                }
            }
            else {
                //There is a plugin in play.
                prefix = id.substring(0, index);
                id = id.substring(index + 1, id.length);
                plugin = stringRequire(systemRequire, exports, module, prefix, relId);
                if (plugin.normalize) {
                    id = plugin.normalize(id, makeNormalize(relId));
                }
                else {
                    //Normalize the ID normally.
                    id = normalize(id, relId);
                }
                if (loaderCache[id]) {
                    return loaderCache[id];
                }
                else {
                    plugin.load(id, makeRequire(systemRequire, exports, module, relId), makeLoad(id), {});
                    return loaderCache[id];
                }
            }
        };
        //Create a define function specific to the module asking for amdefine.
        function define(id, deps, factory) {
            if (Array.isArray(id)) {
                factory = deps;
                deps = id;
                id = undefined;
            }
            else if (typeof id !== 'string') {
                factory = id;
                id = deps = undefined;
            }
            if (deps && !Array.isArray(deps)) {
                factory = deps;
                deps = undefined;
            }
            if (!deps) {
                deps = ['require', 'exports', 'module'];
            }
            //Set up properties for this module. If an ID, then use
            //internal cache. If no ID, then use the external variables
            //for this node module.
            if (id) {
                //Put the module in deep freeze until there is a
                //require call for it.
                defineCache[id] = [id, deps, factory];
            }
            else {
                runFactory(id, deps, factory);
            }
        }
        //define.require, which has access to all the values in the
        //cache. Useful for AMD modules that all have IDs in the file,
        //but need to finally export a value to node based on one of those
        //IDs.
        define.require = function (id) {
            if (loaderCache[id]) {
                return loaderCache[id];
            }
            if (defineCache[id]) {
                runFactory.apply(null, defineCache[id]);
                return loaderCache[id];
            }
        };
        define.amd = {};
        return define;
    }
    module.exports = amdefine;
}
,
/* ansi-regex/index */ function _(require, module, exports) {
    module.exports = function () {
        return /[\u001b\u009b][[()#;?]*(?:[0-9]{1,4}(?:;[0-9]{0,4})*)?[0-9A-PRZcf-nqry=><]/g;
    };
}
,
/* asap/asap */ function _(require, module, exports) {
    var rawAsap = require(46) /* ./raw */;
    var freeTasks = [];
    /**
     * Calls a task as soon as possible after returning, in its own event, with
     * priority over IO events. An exception thrown in a task can be handled by
     * `process.on("uncaughtException") or `domain.on("error")`, but will otherwise
     * crash the process. If the error is handled, all subsequent tasks will
     * resume.
     *
     * @param {{call}} task A callable object, typically a function that takes no
     * arguments.
     */
    module.exports = asap;
    function asap(task) {
        var rawTask;
        if (freeTasks.length) {
            rawTask = freeTasks.pop();
        }
        else {
            rawTask = new RawTask();
        }
        rawTask.task = task;
        rawTask.domain = process.domain;
        rawAsap(rawTask);
    }
    function RawTask() {
        this.task = null;
        this.domain = null;
    }
    RawTask.prototype.call = function () {
        if (this.domain) {
            this.domain.enter();
        }
        var threw = true;
        try {
            this.task.call();
            threw = false;
            // If the task throws an exception (presumably) Node.js restores the
            // domain stack for the next event.
            if (this.domain) {
                this.domain.exit();
            }
        }
        finally {
            // We use try/finally and a threw flag to avoid messing up stack traces
            // when we catch and release errors.
            if (threw) {
                // In Node.js, uncaught exceptions are considered fatal errors.
                // Re-throw them to interrupt flushing!
                // Ensure that flushing continues if an uncaught exception is
                // suppressed listening process.on("uncaughtException") or
                // domain.on("error").
                rawAsap.requestFlush();
            }
            // If the task threw an error, we do not want to exit the domain here.
            // Exiting the domain would prevent the domain from catching the error.
            this.task = null;
            this.domain = null;
            freeTasks.push(this);
        }
    };
}
,
/* asap/raw */ function _(require, module, exports) {
    var domain; // The domain module is executed on demand
    var hasSetImmediate = typeof setImmediate === "function";
    // Use the fastest means possible to execute a task in its own turn, with
    // priority over other events including network IO events in Node.js.
    //
    // An exception thrown by a task will permanently interrupt the processing of
    // subsequent tasks. The higher level `asap` function ensures that if an
    // exception is thrown by a task, that the task queue will continue flushing as
    // soon as possible, but if you use `rawAsap` directly, you are responsible to
    // either ensure that no exceptions are thrown from your task, or to manually
    // call `rawAsap.requestFlush` if an exception is thrown.
    module.exports = rawAsap;
    function rawAsap(task) {
        if (!queue.length) {
            requestFlush();
            flushing = true;
        }
        // Avoids a function call
        queue[queue.length] = task;
    }
    var queue = [];
    // Once a flush has been requested, no further calls to `requestFlush` are
    // necessary until the next `flush` completes.
    var flushing = false;
    // The position of the next task to execute in the task queue. This is
    // preserved between calls to `flush` so that it can be resumed if
    // a task throws an exception.
    var index = 0;
    // If a task schedules additional tasks recursively, the task queue can grow
    // unbounded. To prevent memory excaustion, the task queue will periodically
    // truncate already-completed tasks.
    var capacity = 1024;
    // The flush function processes all tasks that have been scheduled with
    // `rawAsap` unless and until one of those tasks throws an exception.
    // If a task throws an exception, `flush` ensures that its state will remain
    // consistent and will resume where it left off when called again.
    // However, `flush` does not make any arrangements to be called again if an
    // exception is thrown.
    function flush() {
        while (index < queue.length) {
            var currentIndex = index;
            // Advance the index before calling the task. This ensures that we will
            // begin flushing on the next task the task throws an error.
            index = index + 1;
            queue[currentIndex].call();
            // Prevent leaking memory for long chains of recursive calls to `asap`.
            // If we call `asap` within tasks scheduled by `asap`, the queue will
            // grow, but to avoid an O(n) walk for every task we execute, we don't
            // shift tasks off the queue after they have been executed.
            // Instead, we periodically shift 1024 tasks off the queue.
            if (index > capacity) {
                // Manually shift all values starting at the index back to the
                // beginning of the queue.
                for (var scan = 0, newLength = queue.length - index; scan < newLength; scan++) {
                    queue[scan] = queue[scan + index];
                }
                queue.length -= index;
                index = 0;
            }
        }
        queue.length = 0;
        index = 0;
        flushing = false;
    }
    rawAsap.requestFlush = requestFlush;
    function requestFlush() {
        // Ensure flushing is not bound to any domain.
        // It is not sufficient to exit the domain, because domains exist on a stack.
        // To execute code outside of any domain, the following dance is necessary.
        var parentDomain = process.domain;
        if (parentDomain) {
            if (!domain) {
                // Lazy execute the domain module.
                // Only employed if the user elects to use domains.
                domain = require("domain");
            }
            domain.active = process.domain = null;
        }
        // `setImmediate` is slower that `process.nextTick`, but `process.nextTick`
        // cannot handle recursion.
        // `requestFlush` will only be called recursively from `asap.js`, to resume
        // flushing after an error is thrown into a domain.
        // Conveniently, `setImmediate` was introduced in the same version
        // `process.nextTick` started throwing recursion errors.
        if (flushing && hasSetImmediate) {
            setImmediate(flush);
        }
        else {
            process.nextTick(flush);
        }
        if (parentDomain) {
            domain.active = process.domain = parentDomain;
        }
    }
}
,
/* asn1/lib/ber/errors */ function _(require, module, exports) {
    // Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.
    module.exports = {
        newInvalidAsn1Error: function (msg) {
            var e = new Error();
            e.name = 'InvalidAsn1Error';
            e.message = msg || '';
            return e;
        }
    };
}
,
/* asn1/lib/ber/index */ function _(require, module, exports) {
    // Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.
    var errors = require(47) /* ./errors */;
    var types = require(50) /* ./types */;
    var Reader = require(49) /* ./reader */;
    var Writer = require(51) /* ./writer */;
    // --- Exports
    module.exports = {
        Reader: Reader,
        Writer: Writer
    };
    for (var t in types) {
        if (types.hasOwnProperty(t))
            module.exports[t] = types[t];
    }
    for (var e in errors) {
        if (errors.hasOwnProperty(e))
            module.exports[e] = errors[e];
    }
}
,
/* asn1/lib/ber/reader */ function _(require, module, exports) {
    // Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.
    var assert = require('assert');
    var Buffer = require(312) /* safer-buffer */.Buffer;
    var ASN1 = require(50) /* ./types */;
    var errors = require(47) /* ./errors */;
    // --- Globals
    var newInvalidAsn1Error = errors.newInvalidAsn1Error;
    // --- API
    function Reader(data) {
        if (!data || !Buffer.isBuffer(data))
            throw new TypeError('data must be a node Buffer');
        this._buf = data;
        this._size = data.length;
        // These hold the "current" state
        this._len = 0;
        this._offset = 0;
    }
    Object.defineProperty(Reader.prototype, 'length', {
        enumerable: true,
        get: function () { return (this._len); }
    });
    Object.defineProperty(Reader.prototype, 'offset', {
        enumerable: true,
        get: function () { return (this._offset); }
    });
    Object.defineProperty(Reader.prototype, 'remain', {
        get: function () { return (this._size - this._offset); }
    });
    Object.defineProperty(Reader.prototype, 'buffer', {
        get: function () { return (this._buf.slice(this._offset)); }
    });
    /**
     * Reads a single byte and advances offset; you can pass in `true` to make this
     * a "peek" operation (i.e., get the byte, but don't advance the offset).
     *
     * @param {Boolean} peek true means don't move offset.
     * @return {Number} the next byte, null if not enough data.
     */
    Reader.prototype.readByte = function (peek) {
        if (this._size - this._offset < 1)
            return null;
        var b = this._buf[this._offset] & 0xff;
        if (!peek)
            this._offset += 1;
        return b;
    };
    Reader.prototype.peek = function () {
        return this.readByte(true);
    };
    /**
     * Reads a (potentially) variable length off the BER buffer.  This call is
     * not really meant to be called directly, as callers have to manipulate
     * the internal buffer afterwards.
     *
     * As a result of this call, you can call `Reader.length`, until the
     * next thing called that does a readLength.
     *
     * @return {Number} the amount of offset to advance the buffer.
     * @throws {InvalidAsn1Error} on bad ASN.1
     */
    Reader.prototype.readLength = function (offset) {
        if (offset === undefined)
            offset = this._offset;
        if (offset >= this._size)
            return null;
        var lenB = this._buf[offset++] & 0xff;
        if (lenB === null)
            return null;
        if ((lenB & 0x80) === 0x80) {
            lenB &= 0x7f;
            if (lenB === 0)
                throw newInvalidAsn1Error('Indefinite length not supported');
            if (lenB > 4)
                throw newInvalidAsn1Error('encoding too long');
            if (this._size - offset < lenB)
                return null;
            this._len = 0;
            for (var i = 0; i < lenB; i++)
                this._len = (this._len << 8) + (this._buf[offset++] & 0xff);
        }
        else {
            // Wasn't a variable length
            this._len = lenB;
        }
        return offset;
    };
    /**
     * Parses the next sequence in this BER buffer.
     *
     * To get the length of the sequence, call `Reader.length`.
     *
     * @return {Number} the sequence's tag.
     */
    Reader.prototype.readSequence = function (tag) {
        var seq = this.peek();
        if (seq === null)
            return null;
        if (tag !== undefined && tag !== seq)
            throw newInvalidAsn1Error('Expected 0x' + tag.toString(16) +
                ': got 0x' + seq.toString(16));
        var o = this.readLength(this._offset + 1); // stored in `length`
        if (o === null)
            return null;
        this._offset = o;
        return seq;
    };
    Reader.prototype.readInt = function () {
        return this._readTag(ASN1.Integer);
    };
    Reader.prototype.readBoolean = function () {
        return (this._readTag(ASN1.Boolean) === 0 ? false : true);
    };
    Reader.prototype.readEnumeration = function () {
        return this._readTag(ASN1.Enumeration);
    };
    Reader.prototype.readString = function (tag, retbuf) {
        if (!tag)
            tag = ASN1.OctetString;
        var b = this.peek();
        if (b === null)
            return null;
        if (b !== tag)
            throw newInvalidAsn1Error('Expected 0x' + tag.toString(16) +
                ': got 0x' + b.toString(16));
        var o = this.readLength(this._offset + 1); // stored in `length`
        if (o === null)
            return null;
        if (this.length > this._size - o)
            return null;
        this._offset = o;
        if (this.length === 0)
            return retbuf ? Buffer.alloc(0) : '';
        var str = this._buf.slice(this._offset, this._offset + this.length);
        this._offset += this.length;
        return retbuf ? str : str.toString('utf8');
    };
    Reader.prototype.readOID = function (tag) {
        if (!tag)
            tag = ASN1.OID;
        var b = this.readString(tag, true);
        if (b === null)
            return null;
        var values = [];
        var value = 0;
        for (var i = 0; i < b.length; i++) {
            var byte = b[i] & 0xff;
            value <<= 7;
            value += byte & 0x7f;
            if ((byte & 0x80) === 0) {
                values.push(value);
                value = 0;
            }
        }
        value = values.shift();
        values.unshift(value % 40);
        values.unshift((value / 40) >> 0);
        return values.join('.');
    };
    Reader.prototype._readTag = function (tag) {
        assert.ok(tag !== undefined);
        var b = this.peek();
        if (b === null)
            return null;
        if (b !== tag)
            throw newInvalidAsn1Error('Expected 0x' + tag.toString(16) +
                ': got 0x' + b.toString(16));
        var o = this.readLength(this._offset + 1); // stored in `length`
        if (o === null)
            return null;
        if (this.length > 4)
            throw newInvalidAsn1Error('Integer too long: ' + this.length);
        if (this.length > this._size - o)
            return null;
        this._offset = o;
        var fb = this._buf[this._offset];
        var value = 0;
        for (var i = 0; i < this.length; i++) {
            value <<= 8;
            value |= (this._buf[this._offset++] & 0xff);
        }
        if ((fb & 0x80) === 0x80 && i !== 4)
            value -= (1 << (i * 8));
        return value >> 0;
    };
    // --- Exported API
    module.exports = Reader;
}
,
/* asn1/lib/ber/types */ function _(require, module, exports) {
    // Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.
    module.exports = {
        EOC: 0,
        Boolean: 1,
        Integer: 2,
        BitString: 3,
        OctetString: 4,
        Null: 5,
        OID: 6,
        ObjectDescriptor: 7,
        External: 8,
        Real: 9,
        Enumeration: 10,
        PDV: 11,
        Utf8String: 12,
        RelativeOID: 13,
        Sequence: 16,
        Set: 17,
        NumericString: 18,
        PrintableString: 19,
        T61String: 20,
        VideotexString: 21,
        IA5String: 22,
        UTCTime: 23,
        GeneralizedTime: 24,
        GraphicString: 25,
        VisibleString: 26,
        GeneralString: 28,
        UniversalString: 29,
        CharacterString: 30,
        BMPString: 31,
        Constructor: 32,
        Context: 128
    };
}
,
/* asn1/lib/ber/writer */ function _(require, module, exports) {
    // Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.
    var assert = require('assert');
    var Buffer = require(312) /* safer-buffer */.Buffer;
    var ASN1 = require(50) /* ./types */;
    var errors = require(47) /* ./errors */;
    // --- Globals
    var newInvalidAsn1Error = errors.newInvalidAsn1Error;
    var DEFAULT_OPTS = {
        size: 1024,
        growthFactor: 8
    };
    // --- Helpers
    function merge(from, to) {
        assert.ok(from);
        assert.equal(typeof (from), 'object');
        assert.ok(to);
        assert.equal(typeof (to), 'object');
        var keys = Object.getOwnPropertyNames(from);
        keys.forEach(function (key) {
            if (to[key])
                return;
            var value = Object.getOwnPropertyDescriptor(from, key);
            Object.defineProperty(to, key, value);
        });
        return to;
    }
    // --- API
    function Writer(options) {
        options = merge(DEFAULT_OPTS, options || {});
        this._buf = Buffer.alloc(options.size || 1024);
        this._size = this._buf.length;
        this._offset = 0;
        this._options = options;
        // A list of offsets in the buffer where we need to insert
        // sequence tag/len pairs.
        this._seq = [];
    }
    Object.defineProperty(Writer.prototype, 'buffer', {
        get: function () {
            if (this._seq.length)
                throw newInvalidAsn1Error(this._seq.length + ' unended sequence(s)');
            return (this._buf.slice(0, this._offset));
        }
    });
    Writer.prototype.writeByte = function (b) {
        if (typeof (b) !== 'number')
            throw new TypeError('argument must be a Number');
        this._ensure(1);
        this._buf[this._offset++] = b;
    };
    Writer.prototype.writeInt = function (i, tag) {
        if (typeof (i) !== 'number')
            throw new TypeError('argument must be a Number');
        if (typeof (tag) !== 'number')
            tag = ASN1.Integer;
        var sz = 4;
        while ((((i & 0xff800000) === 0) || ((i & 0xff800000) === 0xff800000 >> 0)) &&
            (sz > 1)) {
            sz--;
            i <<= 8;
        }
        if (sz > 4)
            throw newInvalidAsn1Error('BER ints cannot be > 0xffffffff');
        this._ensure(2 + sz);
        this._buf[this._offset++] = tag;
        this._buf[this._offset++] = sz;
        while (sz-- > 0) {
            this._buf[this._offset++] = ((i & 0xff000000) >>> 24);
            i <<= 8;
        }
    };
    Writer.prototype.writeNull = function () {
        this.writeByte(ASN1.Null);
        this.writeByte(0x00);
    };
    Writer.prototype.writeEnumeration = function (i, tag) {
        if (typeof (i) !== 'number')
            throw new TypeError('argument must be a Number');
        if (typeof (tag) !== 'number')
            tag = ASN1.Enumeration;
        return this.writeInt(i, tag);
    };
    Writer.prototype.writeBoolean = function (b, tag) {
        if (typeof (b) !== 'boolean')
            throw new TypeError('argument must be a Boolean');
        if (typeof (tag) !== 'number')
            tag = ASN1.Boolean;
        this._ensure(3);
        this._buf[this._offset++] = tag;
        this._buf[this._offset++] = 0x01;
        this._buf[this._offset++] = b ? 0xff : 0x00;
    };
    Writer.prototype.writeString = function (s, tag) {
        if (typeof (s) !== 'string')
            throw new TypeError('argument must be a string (was: ' + typeof (s) + ')');
        if (typeof (tag) !== 'number')
            tag = ASN1.OctetString;
        var len = Buffer.byteLength(s);
        this.writeByte(tag);
        this.writeLength(len);
        if (len) {
            this._ensure(len);
            this._buf.write(s, this._offset);
            this._offset += len;
        }
    };
    Writer.prototype.writeBuffer = function (buf, tag) {
        if (typeof (tag) !== 'number')
            throw new TypeError('tag must be a number');
        if (!Buffer.isBuffer(buf))
            throw new TypeError('argument must be a buffer');
        this.writeByte(tag);
        this.writeLength(buf.length);
        this._ensure(buf.length);
        buf.copy(this._buf, this._offset, 0, buf.length);
        this._offset += buf.length;
    };
    Writer.prototype.writeStringArray = function (strings) {
        if ((!strings instanceof Array))
            throw new TypeError('argument must be an Array[String]');
        var self = this;
        strings.forEach(function (s) {
            self.writeString(s);
        });
    };
    // This is really to solve DER cases, but whatever for now
    Writer.prototype.writeOID = function (s, tag) {
        if (typeof (s) !== 'string')
            throw new TypeError('argument must be a string');
        if (typeof (tag) !== 'number')
            tag = ASN1.OID;
        if (!/^([0-9]+\.){3,}[0-9]+$/.test(s))
            throw new Error('argument is not a valid OID string');
        function encodeOctet(bytes, octet) {
            if (octet < 128) {
                bytes.push(octet);
            }
            else if (octet < 16384) {
                bytes.push((octet >>> 7) | 0x80);
                bytes.push(octet & 0x7F);
            }
            else if (octet < 2097152) {
                bytes.push((octet >>> 14) | 0x80);
                bytes.push(((octet >>> 7) | 0x80) & 0xFF);
                bytes.push(octet & 0x7F);
            }
            else if (octet < 268435456) {
                bytes.push((octet >>> 21) | 0x80);
                bytes.push(((octet >>> 14) | 0x80) & 0xFF);
                bytes.push(((octet >>> 7) | 0x80) & 0xFF);
                bytes.push(octet & 0x7F);
            }
            else {
                bytes.push(((octet >>> 28) | 0x80) & 0xFF);
                bytes.push(((octet >>> 21) | 0x80) & 0xFF);
                bytes.push(((octet >>> 14) | 0x80) & 0xFF);
                bytes.push(((octet >>> 7) | 0x80) & 0xFF);
                bytes.push(octet & 0x7F);
            }
        }
        var tmp = s.split('.');
        var bytes = [];
        bytes.push(parseInt(tmp[0], 10) * 40 + parseInt(tmp[1], 10));
        tmp.slice(2).forEach(function (b) {
            encodeOctet(bytes, parseInt(b, 10));
        });
        var self = this;
        this._ensure(2 + bytes.length);
        this.writeByte(tag);
        this.writeLength(bytes.length);
        bytes.forEach(function (b) {
            self.writeByte(b);
        });
    };
    Writer.prototype.writeLength = function (len) {
        if (typeof (len) !== 'number')
            throw new TypeError('argument must be a Number');
        this._ensure(4);
        if (len <= 0x7f) {
            this._buf[this._offset++] = len;
        }
        else if (len <= 0xff) {
            this._buf[this._offset++] = 0x81;
            this._buf[this._offset++] = len;
        }
        else if (len <= 0xffff) {
            this._buf[this._offset++] = 0x82;
            this._buf[this._offset++] = len >> 8;
            this._buf[this._offset++] = len;
        }
        else if (len <= 0xffffff) {
            this._buf[this._offset++] = 0x83;
            this._buf[this._offset++] = len >> 16;
            this._buf[this._offset++] = len >> 8;
            this._buf[this._offset++] = len;
        }
        else {
            throw newInvalidAsn1Error('Length too long (> 4 bytes)');
        }
    };
    Writer.prototype.startSequence = function (tag) {
        if (typeof (tag) !== 'number')
            tag = ASN1.Sequence | ASN1.Constructor;
        this.writeByte(tag);
        this._seq.push(this._offset);
        this._ensure(3);
        this._offset += 3;
    };
    Writer.prototype.endSequence = function () {
        var seq = this._seq.pop();
        var start = seq + 3;
        var len = this._offset - start;
        if (len <= 0x7f) {
            this._shift(start, len, -2);
            this._buf[seq] = len;
        }
        else if (len <= 0xff) {
            this._shift(start, len, -1);
            this._buf[seq] = 0x81;
            this._buf[seq + 1] = len;
        }
        else if (len <= 0xffff) {
            this._buf[seq] = 0x82;
            this._buf[seq + 1] = len >> 8;
            this._buf[seq + 2] = len;
        }
        else if (len <= 0xffffff) {
            this._shift(start, len, 1);
            this._buf[seq] = 0x83;
            this._buf[seq + 1] = len >> 16;
            this._buf[seq + 2] = len >> 8;
            this._buf[seq + 3] = len;
        }
        else {
            throw newInvalidAsn1Error('Sequence too long');
        }
    };
    Writer.prototype._shift = function (start, len, shift) {
        assert.ok(start !== undefined);
        assert.ok(len !== undefined);
        assert.ok(shift);
        this._buf.copy(this._buf, start + shift, start, start + len);
        this._offset += shift;
    };
    Writer.prototype._ensure = function (len) {
        assert.ok(len);
        if (this._size - this._offset < len) {
            var sz = this._size * this._options.growthFactor;
            if (sz - this._offset < len)
                sz += len;
            var buf = Buffer.alloc(sz);
            this._buf.copy(buf, 0, 0, this._offset);
            this._buf = buf;
            this._size = sz;
        }
    };
    // --- Exported API
    module.exports = Writer;
}
,
/* asn1/lib/index */ function _(require, module, exports) {
    // Copyright 2011 Mark Cavage <mcavage@gmail.com> All rights reserved.
    // If you have no idea what ASN.1 or BER is, see this:
    // ftp://ftp.rsa.com/pub/pkcs/ascii/layman.asc
    var Ber = require(48) /* ./ber/index */;
    // --- Exported API
    module.exports = {
        Ber: Ber,
        BerReader: Ber.Reader,
        BerWriter: Ber.Writer
    };
}
,
/* assert-plus/assert */ function _(require, module, exports) {
    // Copyright (c) 2012, Mark Cavage. All rights reserved.
    // Copyright 2015 Joyent, Inc.
    var assert = require('assert');
    var Stream = require('stream').Stream;
    var util = require('util');
    ///--- Globals
    /* JSSTYLED */
    var UUID_REGEXP = /^[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}$/;
    ///--- Internal
    function _capitalize(str) {
        return (str.charAt(0).toUpperCase() + str.slice(1));
    }
    function _toss(name, expected, oper, arg, actual) {
        throw new assert.AssertionError({
            message: util.format('%s (%s) is required', name, expected),
            actual: (actual === undefined) ? typeof (arg) : actual(arg),
            expected: expected,
            operator: oper || '===',
            stackStartFunction: _toss.caller
        });
    }
    function _getClass(arg) {
        return (Object.prototype.toString.call(arg).slice(8, -1));
    }
    function noop() {
        // Why even bother with asserts?
    }
    ///--- Exports
    var types = {
        bool: {
            check: function (arg) { return typeof (arg) === 'boolean'; }
        },
        func: {
            check: function (arg) { return typeof (arg) === 'function'; }
        },
        string: {
            check: function (arg) { return typeof (arg) === 'string'; }
        },
        object: {
            check: function (arg) {
                return typeof (arg) === 'object' && arg !== null;
            }
        },
        number: {
            check: function (arg) {
                return typeof (arg) === 'number' && !isNaN(arg);
            }
        },
        finite: {
            check: function (arg) {
                return typeof (arg) === 'number' && !isNaN(arg) && isFinite(arg);
            }
        },
        buffer: {
            check: function (arg) { return Buffer.isBuffer(arg); },
            operator: 'Buffer.isBuffer'
        },
        array: {
            check: function (arg) { return Array.isArray(arg); },
            operator: 'Array.isArray'
        },
        stream: {
            check: function (arg) { return arg instanceof Stream; },
            operator: 'instanceof',
            actual: _getClass
        },
        date: {
            check: function (arg) { return arg instanceof Date; },
            operator: 'instanceof',
            actual: _getClass
        },
        regexp: {
            check: function (arg) { return arg instanceof RegExp; },
            operator: 'instanceof',
            actual: _getClass
        },
        uuid: {
            check: function (arg) {
                return typeof (arg) === 'string' && UUID_REGEXP.test(arg);
            },
            operator: 'isUUID'
        }
    };
    function _setExports(ndebug) {
        var keys = Object.keys(types);
        var out;
        /* re-export standard assert */
        if (process.env.NODE_NDEBUG) {
            out = noop;
        }
        else {
            out = function (arg, msg) {
                if (!arg) {
                    _toss(msg, 'true', arg);
                }
            };
        }
        /* standard checks */
        keys.forEach(function (k) {
            if (ndebug) {
                out[k] = noop;
                return;
            }
            var type = types[k];
            out[k] = function (arg, msg) {
                if (!type.check(arg)) {
                    _toss(msg, k, type.operator, arg, type.actual);
                }
            };
        });
        /* optional checks */
        keys.forEach(function (k) {
            var name = 'optional' + _capitalize(k);
            if (ndebug) {
                out[name] = noop;
                return;
            }
            var type = types[k];
            out[name] = function (arg, msg) {
                if (arg === undefined || arg === null) {
                    return;
                }
                if (!type.check(arg)) {
                    _toss(msg, k, type.operator, arg, type.actual);
                }
            };
        });
        /* arrayOf checks */
        keys.forEach(function (k) {
            var name = 'arrayOf' + _capitalize(k);
            if (ndebug) {
                out[name] = noop;
                return;
            }
            var type = types[k];
            var expected = '[' + k + ']';
            out[name] = function (arg, msg) {
                if (!Array.isArray(arg)) {
                    _toss(msg, expected, type.operator, arg, type.actual);
                }
                var i;
                for (i = 0; i < arg.length; i++) {
                    if (!type.check(arg[i])) {
                        _toss(msg, expected, type.operator, arg, type.actual);
                    }
                }
            };
        });
        /* optionalArrayOf checks */
        keys.forEach(function (k) {
            var name = 'optionalArrayOf' + _capitalize(k);
            if (ndebug) {
                out[name] = noop;
                return;
            }
            var type = types[k];
            var expected = '[' + k + ']';
            out[name] = function (arg, msg) {
                if (arg === undefined || arg === null) {
                    return;
                }
                if (!Array.isArray(arg)) {
                    _toss(msg, expected, type.operator, arg, type.actual);
                }
                var i;
                for (i = 0; i < arg.length; i++) {
                    if (!type.check(arg[i])) {
                        _toss(msg, expected, type.operator, arg, type.actual);
                    }
                }
            };
        });
        /* re-export built-in assertions */
        Object.keys(assert).forEach(function (k) {
            if (k === 'AssertionError') {
                out[k] = assert[k];
                return;
            }
            if (ndebug) {
                out[k] = noop;
                return;
            }
            out[k] = assert[k];
        });
        /* export ourselves (for unit tests _only_) */
        out._setExports = _setExports;
        return out;
    }
    module.exports = _setExports(process.env.NODE_NDEBUG);
}
,
/* asynckit/index */ function _(require, module, exports) {
    module.exports =
        {
            parallel: require(61) /* ./parallel.js */,
            serial: require(62) /* ./serial.js */,
            serialOrdered: require(63) /* ./serialOrdered.js */
        };
}
,
/* asynckit/lib/abort */ function _(require, module, exports) {
    // API
    module.exports = abort;
    /**
     * Aborts leftover active jobs
     *
     * @param {object} state - current state object
     */
    function abort(state) {
        Object.keys(state.jobs).forEach(clean.bind(state));
        // reset leftover jobs
        state.jobs = {};
    }
    /**
     * Cleans up leftover job by invoking abort function for the provided job id
     *
     * @this  state
     * @param {string|number} key - job id to abort
     */
    function clean(key) {
        if (typeof this.jobs[key] == 'function') {
            this.jobs[key]();
        }
    }
}
,
/* asynckit/lib/async */ function _(require, module, exports) {
    var defer = require(57) /* ./defer.js */;
    // API
    module.exports = async;
    /**
     * Runs provided callback asynchronously
     * even if callback itself is not
     *
     * @param   {function} callback - callback to invoke
     * @returns {function} - augmented callback
     */
    function async(callback) {
        var isAsync = false;
        // check if async happened
        defer(function () { isAsync = true; });
        return function async_callback(err, result) {
            if (isAsync) {
                callback(err, result);
            }
            else {
                defer(function nextTick_callback() {
                    callback(err, result);
                });
            }
        };
    }
}
,
/* asynckit/lib/defer */ function _(require, module, exports) {
    module.exports = defer;
    /**
     * Runs provided function on next iteration of the event loop
     *
     * @param {function} fn - function to run
     */
    function defer(fn) {
        var nextTick = typeof setImmediate == 'function'
            ? setImmediate
            : (typeof process == 'object' && typeof process.nextTick == 'function'
                ? process.nextTick
                : null);
        if (nextTick) {
            nextTick(fn);
        }
        else {
            setTimeout(fn, 0);
        }
    }
}
,
/* asynckit/lib/iterate */ function _(require, module, exports) {
    var async = require(56) /* ./async.js */, abort = require(55) /* ./abort.js */;
    // API
    module.exports = iterate;
    /**
     * Iterates over each job object
     *
     * @param {array|object} list - array or object (named list) to iterate over
     * @param {function} iterator - iterator to run
     * @param {object} state - current job status
     * @param {function} callback - invoked when all elements processed
     */
    function iterate(list, iterator, state, callback) {
        // store current index
        var key = state['keyedList'] ? state['keyedList'][state.index] : state.index;
        state.jobs[key] = runJob(iterator, key, list[key], function (error, output) {
            // don't repeat yourself
            // skip secondary callbacks
            if (!(key in state.jobs)) {
                return;
            }
            // clean up jobs
            delete state.jobs[key];
            if (error) {
                // don't process rest of the results
                // stop still active jobs
                // and reset the list
                abort(state);
            }
            else {
                state.results[key] = output;
            }
            // return salvaged results
            callback(error, state.results);
        });
    }
    /**
     * Runs iterator over provided job element
     *
     * @param   {function} iterator - iterator to invoke
     * @param   {string|number} key - key/index of the element in the list of jobs
     * @param   {mixed} item - job description
     * @param   {function} callback - invoked after iterator is done with the job
     * @returns {function|mixed} - job abort function or something else
     */
    function runJob(iterator, key, item, callback) {
        var aborter;
        // allow shortcut if iterator expects only two arguments
        if (iterator.length == 2) {
            aborter = iterator(item, async(callback));
        }
        // otherwise go with full three arguments
        else {
            aborter = iterator(item, key, async(callback));
        }
        return aborter;
    }
}
,
/* asynckit/lib/state */ function _(require, module, exports) {
    // API
    module.exports = state;
    /**
     * Creates initial state object
     * for iteration over list
     *
     * @param   {array|object} list - list to iterate over
     * @param   {function|null} sortMethod - function to use for keys sort,
     *                                     or `null` to keep them as is
     * @returns {object} - initial state object
     */
    function state(list, sortMethod) {
        var isNamedList = !Array.isArray(list), initState = {
            index: 0,
            keyedList: isNamedList || sortMethod ? Object.keys(list) : null,
            jobs: {},
            results: isNamedList ? {} : [],
            size: isNamedList ? Object.keys(list).length : list.length
        };
        if (sortMethod) {
            // sort array keys based on it's values
            // sort object's keys just on own merit
            initState.keyedList.sort(isNamedList ? sortMethod : function (a, b) {
                return sortMethod(list[a], list[b]);
            });
        }
        return initState;
    }
}
,
/* asynckit/lib/terminator */ function _(require, module, exports) {
    var abort = require(55) /* ./abort.js */, async = require(56) /* ./async.js */;
    // API
    module.exports = terminator;
    /**
     * Terminates jobs in the attached state context
     *
     * @this  AsyncKitState#
     * @param {function} callback - final callback to invoke after termination
     */
    function terminator(callback) {
        if (!Object.keys(this.jobs).length) {
            return;
        }
        // fast forward iteration index
        this.index = this.size;
        // abort jobs
        abort(this);
        // send back results we have so far
        async(callback)(null, this.results);
    }
}
,
/* asynckit/parallel */ function _(require, module, exports) {
    var iterate = require(58) /* ./lib/iterate.js */, initState = require(59) /* ./lib/state.js */, terminator = require(60) /* ./lib/terminator.js */;
    // Public API
    module.exports = parallel;
    /**
     * Runs iterator over provided array elements in parallel
     *
     * @param   {array|object} list - array or object (named list) to iterate over
     * @param   {function} iterator - iterator to run
     * @param   {function} callback - invoked when all elements processed
     * @returns {function} - jobs terminator
     */
    function parallel(list, iterator, callback) {
        var state = initState(list);
        while (state.index < (state['keyedList'] || list).length) {
            iterate(list, iterator, state, function (error, result) {
                if (error) {
                    callback(error, result);
                    return;
                }
                // looks like it's the last one
                if (Object.keys(state.jobs).length === 0) {
                    callback(null, state.results);
                    return;
                }
            });
            state.index++;
        }
        return terminator.bind(state, callback);
    }
}
,
/* asynckit/serial */ function _(require, module, exports) {
    var serialOrdered = require(63) /* ./serialOrdered.js */;
    // Public API
    module.exports = serial;
    /**
     * Runs iterator over provided array elements in series
     *
     * @param   {array|object} list - array or object (named list) to iterate over
     * @param   {function} iterator - iterator to run
     * @param   {function} callback - invoked when all elements processed
     * @returns {function} - jobs terminator
     */
    function serial(list, iterator, callback) {
        return serialOrdered(list, iterator, null, callback);
    }
}
,
/* asynckit/serialOrdered */ function _(require, module, exports) {
    var iterate = require(58) /* ./lib/iterate.js */, initState = require(59) /* ./lib/state.js */, terminator = require(60) /* ./lib/terminator.js */;
    // Public API
    module.exports = serialOrdered;
    // sorting helpers
    module.exports.ascending = ascending;
    module.exports.descending = descending;
    /**
     * Runs iterator over provided sorted array elements in series
     *
     * @param   {array|object} list - array or object (named list) to iterate over
     * @param   {function} iterator - iterator to run
     * @param   {function} sortMethod - custom sort function
     * @param   {function} callback - invoked when all elements processed
     * @returns {function} - jobs terminator
     */
    function serialOrdered(list, iterator, sortMethod, callback) {
        var state = initState(list, sortMethod);
        iterate(list, iterator, state, function iteratorHandler(error, result) {
            if (error) {
                callback(error, result);
                return;
            }
            state.index++;
            // are we there yet?
            if (state.index < (state['keyedList'] || list).length) {
                iterate(list, iterator, state, iteratorHandler);
                return;
            }
            // done here
            callback(null, state.results);
        });
        return terminator.bind(state, callback);
    }
    /*
     * -- Sort methods
     */
    /**
     * sort helper to sort array elements in ascending order
     *
     * @param   {mixed} a - an item to compare
     * @param   {mixed} b - an item to compare
     * @returns {number} - comparison result
     */
    function ascending(a, b) {
        return a < b ? -1 : a > b ? 1 : 0;
    }
    /**
     * sort helper to sort array elements in descending order
     *
     * @param   {mixed} a - an item to compare
     * @param   {mixed} b - an item to compare
     * @returns {number} - comparison result
     */
    function descending(a, b) {
        return -1 * ascending(a, b);
    }
}
,
/* aws-sign2/index */ function _(require, module, exports) {
    /*!
     *  Copyright 2010 LearnBoost <dev@learnboost.com>
     *
     * Licensed under the Apache License, Version 2.0 (the "License");
     * you may not use this file except in compliance with the License.
     * You may obtain a copy of the License at
     *
     *     http://www.apache.org/licenses/LICENSE-2.0
     *
     * Unless required by applicable law or agreed to in writing, software
     * distributed under the License is distributed on an "AS IS" BASIS,
     * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
     * See the License for the specific language governing permissions and
     * limitations under the License.
     */
    /**
     * Module dependencies.
     */
    var crypto = require('crypto'), parse = require('url').parse;
    /**
     * Valid keys.
     */
    var keys = ['acl',
        'location',
        'logging',
        'notification',
        'partNumber',
        'policy',
        'requestPayment',
        'torrent',
        'uploadId',
        'uploads',
        'versionId',
        'versioning',
        'versions',
        'website'
    ];
    /**
     * Return an "Authorization" header value with the given `options`
     * in the form of "AWS <key>:<signature>"
     *
     * @param {Object} options
     * @return {String}
     * @api private
     */
    function authorization(options) {
        return 'AWS ' + options.key + ':' + sign(options);
    }
    module.exports = authorization;
    module.exports.authorization = authorization;
    /**
     * Simple HMAC-SHA1 Wrapper
     *
     * @param {Object} options
     * @return {String}
     * @api private
     */
    function hmacSha1(options) {
        return crypto.createHmac('sha1', options.secret).update(options.message).digest('base64');
    }
    module.exports.hmacSha1 = hmacSha1;
    /**
     * Create a base64 sha1 HMAC for `options`.
     *
     * @param {Object} options
     * @return {String}
     * @api private
     */
    function sign(options) {
        options.message = stringToSign(options);
        return hmacSha1(options);
    }
    module.exports.sign = sign;
    /**
     * Create a base64 sha1 HMAC for `options`.
     *
     * Specifically to be used with S3 presigned URLs
     *
     * @param {Object} options
     * @return {String}
     * @api private
     */
    function signQuery(options) {
        options.message = queryStringToSign(options);
        return hmacSha1(options);
    }
    module.exports.signQuery = signQuery;
    /**
     * Return a string for sign() with the given `options`.
     *
     * Spec:
     *
     *    <verb>\n
     *    <md5>\n
     *    <content-type>\n
     *    <date>\n
     *    [headers\n]
     *    <resource>
     *
     * @param {Object} options
     * @return {String}
     * @api private
     */
    function stringToSign(options) {
        var headers = options.amazonHeaders || '';
        if (headers)
            headers += '\n';
        var r = [options.verb,
            options.md5,
            options.contentType,
            options.date ? options.date.toUTCString() : '',
            headers + options.resource
        ];
        return r.join('\n');
    }
    module.exports.stringToSign = stringToSign;
    /**
     * Return a string for sign() with the given `options`, but is meant exclusively
     * for S3 presigned URLs
     *
     * Spec:
     *
     *    <date>\n
     *    <resource>
     *
     * @param {Object} options
     * @return {String}
     * @api private
     */
    function queryStringToSign(options) {
        return 'GET\n\n\n' + options.date + '\n' + options.resource;
    }
    module.exports.queryStringToSign = queryStringToSign;
    /**
     * Perform the following:
     *
     *  - ignore non-amazon headers
     *  - lowercase fields
     *  - sort lexicographically
     *  - trim whitespace between ":"
     *  - join with newline
     *
     * @param {Object} headers
     * @return {String}
     * @api private
     */
    function canonicalizeHeaders(headers) {
        var buf = [], fields = Object.keys(headers);
        for (var i = 0, len = fields.length; i < len; ++i) {
            var field = fields[i], val = headers[field], field = field.toLowerCase();
            if (0 !== field.indexOf('x-amz'))
                continue;
            buf.push(field + ':' + val);
        }
        return buf.sort().join('\n');
    }
    module.exports.canonicalizeHeaders = canonicalizeHeaders;
    /**
     * Perform the following:
     *
     *  - ignore non sub-resources
     *  - sort lexicographically
     *
     * @param {String} resource
     * @return {String}
     * @api private
     */
    function canonicalizeResource(resource) {
        var url = parse(resource, true), path = url.pathname, buf = [];
        Object.keys(url.query).forEach(function (key) {
            if (!~keys.indexOf(key))
                return;
            var val = '' == url.query[key] ? '' : '=' + encodeURIComponent(url.query[key]);
            buf.push(key + val);
        });
        return path + (buf.length ? '?' + buf.sort().join('&') : '');
    }
    module.exports.canonicalizeResource = canonicalizeResource;
}
,
/* aws4/aws4 */ function _(require, module, exports) {
    var aws4 = exports, url = require('url'), querystring = require('querystring'), crypto = require('crypto'), lru = require(66) /* ./lru */, credentialsCache = lru(1000);
    // http://docs.amazonwebservices.com/general/latest/gr/signature-version-4.html
    function hmac(key, string, encoding) {
        return crypto.createHmac('sha256', key).update(string, 'utf8').digest(encoding);
    }
    function hash(string, encoding) {
        return crypto.createHash('sha256').update(string, 'utf8').digest(encoding);
    }
    // This function assumes the string has already been percent encoded
    function encodeRfc3986(urlEncodedString) {
        return urlEncodedString.replace(/[!'()*]/g, function (c) {
            return '%' + c.charCodeAt(0).toString(16).toUpperCase();
        });
    }
    // request: { path | body, [host], [method], [headers], [service], [region] }
    // credentials: { accessKeyId, secretAccessKey, [sessionToken] }
    function RequestSigner(request, credentials) {
        if (typeof request === 'string')
            request = url.parse(request);
        var headers = request.headers = (request.headers || {}), hostParts = this.matchHost(request.hostname || request.host || headers.Host || headers.host);
        this.request = request;
        this.credentials = credentials || this.defaultCredentials();
        this.service = request.service || hostParts[0] || '';
        this.region = request.region || hostParts[1] || 'us-east-1';
        // SES uses a different domain from the service name
        if (this.service === 'email')
            this.service = 'ses';
        if (!request.method && request.body)
            request.method = 'POST';
        if (!headers.Host && !headers.host) {
            headers.Host = request.hostname || request.host || this.createHost();
            // If a port is specified explicitly, use it as is
            if (request.port)
                headers.Host += ':' + request.port;
        }
        if (!request.hostname && !request.host)
            request.hostname = headers.Host || headers.host;
        this.isCodeCommitGit = this.service === 'codecommit' && request.method === 'GIT';
    }
    RequestSigner.prototype.matchHost = function (host) {
        var match = (host || '').match(/([^\.]+)\.(?:([^\.]*)\.)?amazonaws\.com(\.cn)?$/);
        var hostParts = (match || []).slice(1, 3);
        // ES's hostParts are sometimes the other way round, if the value that is expected
        // to be region equals ‘es’ switch them back
        // e.g. search-cluster-name-aaaa00aaaa0aaa0aaaaaaa0aaa.us-east-1.es.amazonaws.com
        if (hostParts[1] === 'es')
            hostParts = hostParts.reverse();
        return hostParts;
    };
    // http://docs.aws.amazon.com/general/latest/gr/rande.html
    RequestSigner.prototype.isSingleRegion = function () {
        // Special case for S3 and SimpleDB in us-east-1
        if (['s3', 'sdb'].indexOf(this.service) >= 0 && this.region === 'us-east-1')
            return true;
        return ['cloudfront', 'ls', 'route53', 'iam', 'importexport', 'sts']
            .indexOf(this.service) >= 0;
    };
    RequestSigner.prototype.createHost = function () {
        var region = this.isSingleRegion() ? '' :
            (this.service === 's3' && this.region !== 'us-east-1' ? '-' : '.') + this.region, service = this.service === 'ses' ? 'email' : this.service;
        return service + region + '.amazonaws.com';
    };
    RequestSigner.prototype.prepareRequest = function () {
        this.parsePath();
        var request = this.request, headers = request.headers, query;
        if (request.signQuery) {
            this.parsedPath.query = query = this.parsedPath.query || {};
            if (this.credentials.sessionToken)
                query['X-Amz-Security-Token'] = this.credentials.sessionToken;
            if (this.service === 's3' && !query['X-Amz-Expires'])
                query['X-Amz-Expires'] = 86400;
            if (query['X-Amz-Date'])
                this.datetime = query['X-Amz-Date'];
            else
                query['X-Amz-Date'] = this.getDateTime();
            query['X-Amz-Algorithm'] = 'AWS4-HMAC-SHA256';
            query['X-Amz-Credential'] = this.credentials.accessKeyId + '/' + this.credentialString();
            query['X-Amz-SignedHeaders'] = this.signedHeaders();
        }
        else {
            if (!request.doNotModifyHeaders && !this.isCodeCommitGit) {
                if (request.body && !headers['Content-Type'] && !headers['content-type'])
                    headers['Content-Type'] = 'application/x-www-form-urlencoded; charset=utf-8';
                if (request.body && !headers['Content-Length'] && !headers['content-length'])
                    headers['Content-Length'] = Buffer.byteLength(request.body);
                if (this.credentials.sessionToken && !headers['X-Amz-Security-Token'] && !headers['x-amz-security-token'])
                    headers['X-Amz-Security-Token'] = this.credentials.sessionToken;
                if (this.service === 's3' && !headers['X-Amz-Content-Sha256'] && !headers['x-amz-content-sha256'])
                    headers['X-Amz-Content-Sha256'] = hash(this.request.body || '', 'hex');
                if (headers['X-Amz-Date'] || headers['x-amz-date'])
                    this.datetime = headers['X-Amz-Date'] || headers['x-amz-date'];
                else
                    headers['X-Amz-Date'] = this.getDateTime();
            }
            delete headers.Authorization;
            delete headers.authorization;
        }
    };
    RequestSigner.prototype.sign = function () {
        if (!this.parsedPath)
            this.prepareRequest();
        if (this.request.signQuery) {
            this.parsedPath.query['X-Amz-Signature'] = this.signature();
        }
        else {
            this.request.headers.Authorization = this.authHeader();
        }
        this.request.path = this.formatPath();
        return this.request;
    };
    RequestSigner.prototype.getDateTime = function () {
        if (!this.datetime) {
            var headers = this.request.headers, date = new Date(headers.Date || headers.date || new Date);
            this.datetime = date.toISOString().replace(/[:\-]|\.\d{3}/g, '');
            // Remove the trailing 'Z' on the timestamp string for CodeCommit git access
            if (this.isCodeCommitGit)
                this.datetime = this.datetime.slice(0, -1);
        }
        return this.datetime;
    };
    RequestSigner.prototype.getDate = function () {
        return this.getDateTime().substr(0, 8);
    };
    RequestSigner.prototype.authHeader = function () {
        return [
            'AWS4-HMAC-SHA256 Credential=' + this.credentials.accessKeyId + '/' + this.credentialString(),
            'SignedHeaders=' + this.signedHeaders(),
            'Signature=' + this.signature(),
        ].join(', ');
    };
    RequestSigner.prototype.signature = function () {
        var date = this.getDate(), cacheKey = [this.credentials.secretAccessKey, date, this.region, this.service].join(), kDate, kRegion, kService, kCredentials = credentialsCache.get(cacheKey);
        if (!kCredentials) {
            kDate = hmac('AWS4' + this.credentials.secretAccessKey, date);
            kRegion = hmac(kDate, this.region);
            kService = hmac(kRegion, this.service);
            kCredentials = hmac(kService, 'aws4_request');
            credentialsCache.set(cacheKey, kCredentials);
        }
        return hmac(kCredentials, this.stringToSign(), 'hex');
    };
    RequestSigner.prototype.stringToSign = function () {
        return [
            'AWS4-HMAC-SHA256',
            this.getDateTime(),
            this.credentialString(),
            hash(this.canonicalString(), 'hex'),
        ].join('\n');
    };
    RequestSigner.prototype.canonicalString = function () {
        if (!this.parsedPath)
            this.prepareRequest();
        var pathStr = this.parsedPath.path, query = this.parsedPath.query, headers = this.request.headers, queryStr = '', normalizePath = this.service !== 's3', decodePath = this.service === 's3' || this.request.doNotEncodePath, decodeSlashesInPath = this.service === 's3', firstValOnly = this.service === 's3', bodyHash;
        if (this.service === 's3' && this.request.signQuery) {
            bodyHash = 'UNSIGNED-PAYLOAD';
        }
        else if (this.isCodeCommitGit) {
            bodyHash = '';
        }
        else {
            bodyHash = headers['X-Amz-Content-Sha256'] || headers['x-amz-content-sha256'] ||
                hash(this.request.body || '', 'hex');
        }
        if (query) {
            queryStr = encodeRfc3986(querystring.stringify(Object.keys(query).sort().reduce(function (obj, key) {
                if (!key)
                    return obj;
                obj[key] = !Array.isArray(query[key]) ? query[key] :
                    (firstValOnly ? query[key][0] : query[key].slice().sort());
                return obj;
            }, {})));
        }
        if (pathStr !== '/') {
            if (normalizePath)
                pathStr = pathStr.replace(/\/{2,}/g, '/');
            pathStr = pathStr.split('/').reduce(function (path, piece) {
                if (normalizePath && piece === '..') {
                    path.pop();
                }
                else if (!normalizePath || piece !== '.') {
                    if (decodePath)
                        piece = decodeURIComponent(piece);
                    path.push(encodeRfc3986(encodeURIComponent(piece)));
                }
                return path;
            }, []).join('/');
            if (pathStr[0] !== '/')
                pathStr = '/' + pathStr;
            if (decodeSlashesInPath)
                pathStr = pathStr.replace(/%2F/g, '/');
        }
        return [
            this.request.method || 'GET',
            pathStr,
            queryStr,
            this.canonicalHeaders() + '\n',
            this.signedHeaders(),
            bodyHash,
        ].join('\n');
    };
    RequestSigner.prototype.canonicalHeaders = function () {
        var headers = this.request.headers;
        function trimAll(header) {
            return header.toString().trim().replace(/\s+/g, ' ');
        }
        return Object.keys(headers)
            .sort(function (a, b) { return a.toLowerCase() < b.toLowerCase() ? -1 : 1; })
            .map(function (key) { return key.toLowerCase() + ':' + trimAll(headers[key]); })
            .join('\n');
    };
    RequestSigner.prototype.signedHeaders = function () {
        return Object.keys(this.request.headers)
            .map(function (key) { return key.toLowerCase(); })
            .sort()
            .join(';');
    };
    RequestSigner.prototype.credentialString = function () {
        return [
            this.getDate(),
            this.region,
            this.service,
            'aws4_request',
        ].join('/');
    };
    RequestSigner.prototype.defaultCredentials = function () {
        var env = process.env;
        return {
            accessKeyId: env.AWS_ACCESS_KEY_ID || env.AWS_ACCESS_KEY,
            secretAccessKey: env.AWS_SECRET_ACCESS_KEY || env.AWS_SECRET_KEY,
            sessionToken: env.AWS_SESSION_TOKEN,
        };
    };
    RequestSigner.prototype.parsePath = function () {
        var path = this.request.path || '/', queryIx = path.indexOf('?'), query = null;
        if (queryIx >= 0) {
            query = querystring.parse(path.slice(queryIx + 1));
            path = path.slice(0, queryIx);
        }
        // S3 doesn't always encode characters > 127 correctly and
        // all services don't encode characters > 255 correctly
        // So if there are non-reserved chars (and it's not already all % encoded), just encode them all
        if (/[^0-9A-Za-z!'()*\-._~%/]/.test(path)) {
            path = path.split('/').map(function (piece) {
                return encodeURIComponent(decodeURIComponent(piece));
            }).join('/');
        }
        this.parsedPath = {
            path: path,
            query: query,
        };
    };
    RequestSigner.prototype.formatPath = function () {
        var path = this.parsedPath.path, query = this.parsedPath.query;
        if (!query)
            return path;
        // Services don't support empty query string keys
        if (query[''] != null)
            delete query[''];
        return path + '?' + encodeRfc3986(querystring.stringify(query));
    };
    aws4.RequestSigner = RequestSigner;
    aws4.sign = function (request, credentials) {
        return new RequestSigner(request, credentials).sign();
    };
}
,
/* aws4/lru */ function _(require, module, exports) {
    module.exports = function (size) {
        return new LruCache(size);
    };
    function LruCache(size) {
        this.capacity = size | 0;
        this.map = Object.create(null);
        this.list = new DoublyLinkedList();
    }
    LruCache.prototype.get = function (key) {
        var node = this.map[key];
        if (node == null)
            return undefined;
        this.used(node);
        return node.val;
    };
    LruCache.prototype.set = function (key, val) {
        var node = this.map[key];
        if (node != null) {
            node.val = val;
        }
        else {
            if (!this.capacity)
                this.prune();
            if (!this.capacity)
                return false;
            node = new DoublyLinkedNode(key, val);
            this.map[key] = node;
            this.capacity--;
        }
        this.used(node);
        return true;
    };
    LruCache.prototype.used = function (node) {
        this.list.moveToFront(node);
    };
    LruCache.prototype.prune = function () {
        var node = this.list.pop();
        if (node != null) {
            delete this.map[node.key];
            this.capacity++;
        }
    };
    function DoublyLinkedList() {
        this.firstNode = null;
        this.lastNode = null;
    }
    DoublyLinkedList.prototype.moveToFront = function (node) {
        if (this.firstNode == node)
            return;
        this.remove(node);
        if (this.firstNode == null) {
            this.firstNode = node;
            this.lastNode = node;
            node.prev = null;
            node.next = null;
        }
        else {
            node.prev = null;
            node.next = this.firstNode;
            node.next.prev = node;
            this.firstNode = node;
        }
    };
    DoublyLinkedList.prototype.pop = function () {
        var lastNode = this.lastNode;
        if (lastNode != null) {
            this.remove(lastNode);
        }
        return lastNode;
    };
    DoublyLinkedList.prototype.remove = function (node) {
        if (this.firstNode == node) {
            this.firstNode = node.next;
        }
        else if (node.prev != null) {
            node.prev.next = node.next;
        }
        if (this.lastNode == node) {
            this.lastNode = node.prev;
        }
        else if (node.next != null) {
            node.next.prev = node.prev;
        }
    };
    function DoublyLinkedNode(key, val) {
        this.key = key;
        this.val = val;
        this.prev = null;
        this.next = null;
    }
}
,
/* bcrypt-pbkdf/index */ function _(require, module, exports) {
    var crypto_hash_sha512 = require(366) /* tweetnacl */.lowlevel.crypto_hash;
    /*
     * This file is a 1:1 port from the OpenBSD blowfish.c and bcrypt_pbkdf.c. As a
     * result, it retains the original copyright and license. The two files are
     * under slightly different (but compatible) licenses, and are here combined in
     * one file.
     *
     * Credit for the actual porting work goes to:
     *  Devi Mandiri <me@devi.web.id>
     */
    /*
     * The Blowfish portions are under the following license:
     *
     * Blowfish block cipher for OpenBSD
     * Copyright 1997 Niels Provos <provos@physnet.uni-hamburg.de>
     * All rights reserved.
     *
     * Implementation advice by David Mazieres <dm@lcs.mit.edu>.
     *
     * Redistribution and use in source and binary forms, with or without
     * modification, are permitted provided that the following conditions
     * are met:
     * 1. Redistributions of source code must retain the above copyright
     *    notice, this list of conditions and the following disclaimer.
     * 2. Redistributions in binary form must reproduce the above copyright
     *    notice, this list of conditions and the following disclaimer in the
     *    documentation and/or other materials provided with the distribution.
     * 3. The name of the author may not be used to endorse or promote products
     *    derived from this software without specific prior written permission.
     *
     * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
     * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
     * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
     * IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
     * INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
     * NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
     * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
     * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
     * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
     * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
     */
    /*
     * The bcrypt_pbkdf portions are under the following license:
     *
     * Copyright (c) 2013 Ted Unangst <tedu@openbsd.org>
     *
     * Permission to use, copy, modify, and distribute this software for any
     * purpose with or without fee is hereby granted, provided that the above
     * copyright notice and this permission notice appear in all copies.
     *
     * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
     * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
     * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
     * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
     * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
     * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
     * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
     */
    /*
     * Performance improvements (Javascript-specific):
     *
     * Copyright 2016, Joyent Inc
     * Author: Alex Wilson <alex.wilson@joyent.com>
     *
     * Permission to use, copy, modify, and distribute this software for any
     * purpose with or without fee is hereby granted, provided that the above
     * copyright notice and this permission notice appear in all copies.
     *
     * THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES
     * WITH REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF
     * MERCHANTABILITY AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
     * ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES
     * WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN
     * ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF
     * OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
     */
    // Ported from OpenBSD bcrypt_pbkdf.c v1.9
    var BLF_J = 0;
    var Blowfish = function () {
        this.S = [
            new Uint32Array([
                0xd1310ba6, 0x98dfb5ac, 0x2ffd72db, 0xd01adfb7,
                0xb8e1afed, 0x6a267e96, 0xba7c9045, 0xf12c7f99,
                0x24a19947, 0xb3916cf7, 0x0801f2e2, 0x858efc16,
                0x636920d8, 0x71574e69, 0xa458fea3, 0xf4933d7e,
                0x0d95748f, 0x728eb658, 0x718bcd58, 0x82154aee,
                0x7b54a41d, 0xc25a59b5, 0x9c30d539, 0x2af26013,
                0xc5d1b023, 0x286085f0, 0xca417918, 0xb8db38ef,
                0x8e79dcb0, 0x603a180e, 0x6c9e0e8b, 0xb01e8a3e,
                0xd71577c1, 0xbd314b27, 0x78af2fda, 0x55605c60,
                0xe65525f3, 0xaa55ab94, 0x57489862, 0x63e81440,
                0x55ca396a, 0x2aab10b6, 0xb4cc5c34, 0x1141e8ce,
                0xa15486af, 0x7c72e993, 0xb3ee1411, 0x636fbc2a,
                0x2ba9c55d, 0x741831f6, 0xce5c3e16, 0x9b87931e,
                0xafd6ba33, 0x6c24cf5c, 0x7a325381, 0x28958677,
                0x3b8f4898, 0x6b4bb9af, 0xc4bfe81b, 0x66282193,
                0x61d809cc, 0xfb21a991, 0x487cac60, 0x5dec8032,
                0xef845d5d, 0xe98575b1, 0xdc262302, 0xeb651b88,
                0x23893e81, 0xd396acc5, 0x0f6d6ff3, 0x83f44239,
                0x2e0b4482, 0xa4842004, 0x69c8f04a, 0x9e1f9b5e,
                0x21c66842, 0xf6e96c9a, 0x670c9c61, 0xabd388f0,
                0x6a51a0d2, 0xd8542f68, 0x960fa728, 0xab5133a3,
                0x6eef0b6c, 0x137a3be4, 0xba3bf050, 0x7efb2a98,
                0xa1f1651d, 0x39af0176, 0x66ca593e, 0x82430e88,
                0x8cee8619, 0x456f9fb4, 0x7d84a5c3, 0x3b8b5ebe,
                0xe06f75d8, 0x85c12073, 0x401a449f, 0x56c16aa6,
                0x4ed3aa62, 0x363f7706, 0x1bfedf72, 0x429b023d,
                0x37d0d724, 0xd00a1248, 0xdb0fead3, 0x49f1c09b,
                0x075372c9, 0x80991b7b, 0x25d479d8, 0xf6e8def7,
                0xe3fe501a, 0xb6794c3b, 0x976ce0bd, 0x04c006ba,
                0xc1a94fb6, 0x409f60c4, 0x5e5c9ec2, 0x196a2463,
                0x68fb6faf, 0x3e6c53b5, 0x1339b2eb, 0x3b52ec6f,
                0x6dfc511f, 0x9b30952c, 0xcc814544, 0xaf5ebd09,
                0xbee3d004, 0xde334afd, 0x660f2807, 0x192e4bb3,
                0xc0cba857, 0x45c8740f, 0xd20b5f39, 0xb9d3fbdb,
                0x5579c0bd, 0x1a60320a, 0xd6a100c6, 0x402c7279,
                0x679f25fe, 0xfb1fa3cc, 0x8ea5e9f8, 0xdb3222f8,
                0x3c7516df, 0xfd616b15, 0x2f501ec8, 0xad0552ab,
                0x323db5fa, 0xfd238760, 0x53317b48, 0x3e00df82,
                0x9e5c57bb, 0xca6f8ca0, 0x1a87562e, 0xdf1769db,
                0xd542a8f6, 0x287effc3, 0xac6732c6, 0x8c4f5573,
                0x695b27b0, 0xbbca58c8, 0xe1ffa35d, 0xb8f011a0,
                0x10fa3d98, 0xfd2183b8, 0x4afcb56c, 0x2dd1d35b,
                0x9a53e479, 0xb6f84565, 0xd28e49bc, 0x4bfb9790,
                0xe1ddf2da, 0xa4cb7e33, 0x62fb1341, 0xcee4c6e8,
                0xef20cada, 0x36774c01, 0xd07e9efe, 0x2bf11fb4,
                0x95dbda4d, 0xae909198, 0xeaad8e71, 0x6b93d5a0,
                0xd08ed1d0, 0xafc725e0, 0x8e3c5b2f, 0x8e7594b7,
                0x8ff6e2fb, 0xf2122b64, 0x8888b812, 0x900df01c,
                0x4fad5ea0, 0x688fc31c, 0xd1cff191, 0xb3a8c1ad,
                0x2f2f2218, 0xbe0e1777, 0xea752dfe, 0x8b021fa1,
                0xe5a0cc0f, 0xb56f74e8, 0x18acf3d6, 0xce89e299,
                0xb4a84fe0, 0xfd13e0b7, 0x7cc43b81, 0xd2ada8d9,
                0x165fa266, 0x80957705, 0x93cc7314, 0x211a1477,
                0xe6ad2065, 0x77b5fa86, 0xc75442f5, 0xfb9d35cf,
                0xebcdaf0c, 0x7b3e89a0, 0xd6411bd3, 0xae1e7e49,
                0x00250e2d, 0x2071b35e, 0x226800bb, 0x57b8e0af,
                0x2464369b, 0xf009b91e, 0x5563911d, 0x59dfa6aa,
                0x78c14389, 0xd95a537f, 0x207d5ba2, 0x02e5b9c5,
                0x83260376, 0x6295cfa9, 0x11c81968, 0x4e734a41,
                0xb3472dca, 0x7b14a94a, 0x1b510052, 0x9a532915,
                0xd60f573f, 0xbc9bc6e4, 0x2b60a476, 0x81e67400,
                0x08ba6fb5, 0x571be91f, 0xf296ec6b, 0x2a0dd915,
                0xb6636521, 0xe7b9f9b6, 0xff34052e, 0xc5855664,
                0x53b02d5d, 0xa99f8fa1, 0x08ba4799, 0x6e85076a
            ]),
            new Uint32Array([
                0x4b7a70e9, 0xb5b32944, 0xdb75092e, 0xc4192623,
                0xad6ea6b0, 0x49a7df7d, 0x9cee60b8, 0x8fedb266,
                0xecaa8c71, 0x699a17ff, 0x5664526c, 0xc2b19ee1,
                0x193602a5, 0x75094c29, 0xa0591340, 0xe4183a3e,
                0x3f54989a, 0x5b429d65, 0x6b8fe4d6, 0x99f73fd6,
                0xa1d29c07, 0xefe830f5, 0x4d2d38e6, 0xf0255dc1,
                0x4cdd2086, 0x8470eb26, 0x6382e9c6, 0x021ecc5e,
                0x09686b3f, 0x3ebaefc9, 0x3c971814, 0x6b6a70a1,
                0x687f3584, 0x52a0e286, 0xb79c5305, 0xaa500737,
                0x3e07841c, 0x7fdeae5c, 0x8e7d44ec, 0x5716f2b8,
                0xb03ada37, 0xf0500c0d, 0xf01c1f04, 0x0200b3ff,
                0xae0cf51a, 0x3cb574b2, 0x25837a58, 0xdc0921bd,
                0xd19113f9, 0x7ca92ff6, 0x94324773, 0x22f54701,
                0x3ae5e581, 0x37c2dadc, 0xc8b57634, 0x9af3dda7,
                0xa9446146, 0x0fd0030e, 0xecc8c73e, 0xa4751e41,
                0xe238cd99, 0x3bea0e2f, 0x3280bba1, 0x183eb331,
                0x4e548b38, 0x4f6db908, 0x6f420d03, 0xf60a04bf,
                0x2cb81290, 0x24977c79, 0x5679b072, 0xbcaf89af,
                0xde9a771f, 0xd9930810, 0xb38bae12, 0xdccf3f2e,
                0x5512721f, 0x2e6b7124, 0x501adde6, 0x9f84cd87,
                0x7a584718, 0x7408da17, 0xbc9f9abc, 0xe94b7d8c,
                0xec7aec3a, 0xdb851dfa, 0x63094366, 0xc464c3d2,
                0xef1c1847, 0x3215d908, 0xdd433b37, 0x24c2ba16,
                0x12a14d43, 0x2a65c451, 0x50940002, 0x133ae4dd,
                0x71dff89e, 0x10314e55, 0x81ac77d6, 0x5f11199b,
                0x043556f1, 0xd7a3c76b, 0x3c11183b, 0x5924a509,
                0xf28fe6ed, 0x97f1fbfa, 0x9ebabf2c, 0x1e153c6e,
                0x86e34570, 0xeae96fb1, 0x860e5e0a, 0x5a3e2ab3,
                0x771fe71c, 0x4e3d06fa, 0x2965dcb9, 0x99e71d0f,
                0x803e89d6, 0x5266c825, 0x2e4cc978, 0x9c10b36a,
                0xc6150eba, 0x94e2ea78, 0xa5fc3c53, 0x1e0a2df4,
                0xf2f74ea7, 0x361d2b3d, 0x1939260f, 0x19c27960,
                0x5223a708, 0xf71312b6, 0xebadfe6e, 0xeac31f66,
                0xe3bc4595, 0xa67bc883, 0xb17f37d1, 0x018cff28,
                0xc332ddef, 0xbe6c5aa5, 0x65582185, 0x68ab9802,
                0xeecea50f, 0xdb2f953b, 0x2aef7dad, 0x5b6e2f84,
                0x1521b628, 0x29076170, 0xecdd4775, 0x619f1510,
                0x13cca830, 0xeb61bd96, 0x0334fe1e, 0xaa0363cf,
                0xb5735c90, 0x4c70a239, 0xd59e9e0b, 0xcbaade14,
                0xeecc86bc, 0x60622ca7, 0x9cab5cab, 0xb2f3846e,
                0x648b1eaf, 0x19bdf0ca, 0xa02369b9, 0x655abb50,
                0x40685a32, 0x3c2ab4b3, 0x319ee9d5, 0xc021b8f7,
                0x9b540b19, 0x875fa099, 0x95f7997e, 0x623d7da8,
                0xf837889a, 0x97e32d77, 0x11ed935f, 0x16681281,
                0x0e358829, 0xc7e61fd6, 0x96dedfa1, 0x7858ba99,
                0x57f584a5, 0x1b227263, 0x9b83c3ff, 0x1ac24696,
                0xcdb30aeb, 0x532e3054, 0x8fd948e4, 0x6dbc3128,
                0x58ebf2ef, 0x34c6ffea, 0xfe28ed61, 0xee7c3c73,
                0x5d4a14d9, 0xe864b7e3, 0x42105d14, 0x203e13e0,
                0x45eee2b6, 0xa3aaabea, 0xdb6c4f15, 0xfacb4fd0,
                0xc742f442, 0xef6abbb5, 0x654f3b1d, 0x41cd2105,
                0xd81e799e, 0x86854dc7, 0xe44b476a, 0x3d816250,
                0xcf62a1f2, 0x5b8d2646, 0xfc8883a0, 0xc1c7b6a3,
                0x7f1524c3, 0x69cb7492, 0x47848a0b, 0x5692b285,
                0x095bbf00, 0xad19489d, 0x1462b174, 0x23820e00,
                0x58428d2a, 0x0c55f5ea, 0x1dadf43e, 0x233f7061,
                0x3372f092, 0x8d937e41, 0xd65fecf1, 0x6c223bdb,
                0x7cde3759, 0xcbee7460, 0x4085f2a7, 0xce77326e,
                0xa6078084, 0x19f8509e, 0xe8efd855, 0x61d99735,
                0xa969a7aa, 0xc50c06c2, 0x5a04abfc, 0x800bcadc,
                0x9e447a2e, 0xc3453484, 0xfdd56705, 0x0e1e9ec9,
                0xdb73dbd3, 0x105588cd, 0x675fda79, 0xe3674340,
                0xc5c43465, 0x713e38d8, 0x3d28f89e, 0xf16dff20,
                0x153e21e7, 0x8fb03d4a, 0xe6e39f2b, 0xdb83adf7
            ]),
            new Uint32Array([
                0xe93d5a68, 0x948140f7, 0xf64c261c, 0x94692934,
                0x411520f7, 0x7602d4f7, 0xbcf46b2e, 0xd4a20068,
                0xd4082471, 0x3320f46a, 0x43b7d4b7, 0x500061af,
                0x1e39f62e, 0x97244546, 0x14214f74, 0xbf8b8840,
                0x4d95fc1d, 0x96b591af, 0x70f4ddd3, 0x66a02f45,
                0xbfbc09ec, 0x03bd9785, 0x7fac6dd0, 0x31cb8504,
                0x96eb27b3, 0x55fd3941, 0xda2547e6, 0xabca0a9a,
                0x28507825, 0x530429f4, 0x0a2c86da, 0xe9b66dfb,
                0x68dc1462, 0xd7486900, 0x680ec0a4, 0x27a18dee,
                0x4f3ffea2, 0xe887ad8c, 0xb58ce006, 0x7af4d6b6,
                0xaace1e7c, 0xd3375fec, 0xce78a399, 0x406b2a42,
                0x20fe9e35, 0xd9f385b9, 0xee39d7ab, 0x3b124e8b,
                0x1dc9faf7, 0x4b6d1856, 0x26a36631, 0xeae397b2,
                0x3a6efa74, 0xdd5b4332, 0x6841e7f7, 0xca7820fb,
                0xfb0af54e, 0xd8feb397, 0x454056ac, 0xba489527,
                0x55533a3a, 0x20838d87, 0xfe6ba9b7, 0xd096954b,
                0x55a867bc, 0xa1159a58, 0xcca92963, 0x99e1db33,
                0xa62a4a56, 0x3f3125f9, 0x5ef47e1c, 0x9029317c,
                0xfdf8e802, 0x04272f70, 0x80bb155c, 0x05282ce3,
                0x95c11548, 0xe4c66d22, 0x48c1133f, 0xc70f86dc,
                0x07f9c9ee, 0x41041f0f, 0x404779a4, 0x5d886e17,
                0x325f51eb, 0xd59bc0d1, 0xf2bcc18f, 0x41113564,
                0x257b7834, 0x602a9c60, 0xdff8e8a3, 0x1f636c1b,
                0x0e12b4c2, 0x02e1329e, 0xaf664fd1, 0xcad18115,
                0x6b2395e0, 0x333e92e1, 0x3b240b62, 0xeebeb922,
                0x85b2a20e, 0xe6ba0d99, 0xde720c8c, 0x2da2f728,
                0xd0127845, 0x95b794fd, 0x647d0862, 0xe7ccf5f0,
                0x5449a36f, 0x877d48fa, 0xc39dfd27, 0xf33e8d1e,
                0x0a476341, 0x992eff74, 0x3a6f6eab, 0xf4f8fd37,
                0xa812dc60, 0xa1ebddf8, 0x991be14c, 0xdb6e6b0d,
                0xc67b5510, 0x6d672c37, 0x2765d43b, 0xdcd0e804,
                0xf1290dc7, 0xcc00ffa3, 0xb5390f92, 0x690fed0b,
                0x667b9ffb, 0xcedb7d9c, 0xa091cf0b, 0xd9155ea3,
                0xbb132f88, 0x515bad24, 0x7b9479bf, 0x763bd6eb,
                0x37392eb3, 0xcc115979, 0x8026e297, 0xf42e312d,
                0x6842ada7, 0xc66a2b3b, 0x12754ccc, 0x782ef11c,
                0x6a124237, 0xb79251e7, 0x06a1bbe6, 0x4bfb6350,
                0x1a6b1018, 0x11caedfa, 0x3d25bdd8, 0xe2e1c3c9,
                0x44421659, 0x0a121386, 0xd90cec6e, 0xd5abea2a,
                0x64af674e, 0xda86a85f, 0xbebfe988, 0x64e4c3fe,
                0x9dbc8057, 0xf0f7c086, 0x60787bf8, 0x6003604d,
                0xd1fd8346, 0xf6381fb0, 0x7745ae04, 0xd736fccc,
                0x83426b33, 0xf01eab71, 0xb0804187, 0x3c005e5f,
                0x77a057be, 0xbde8ae24, 0x55464299, 0xbf582e61,
                0x4e58f48f, 0xf2ddfda2, 0xf474ef38, 0x8789bdc2,
                0x5366f9c3, 0xc8b38e74, 0xb475f255, 0x46fcd9b9,
                0x7aeb2661, 0x8b1ddf84, 0x846a0e79, 0x915f95e2,
                0x466e598e, 0x20b45770, 0x8cd55591, 0xc902de4c,
                0xb90bace1, 0xbb8205d0, 0x11a86248, 0x7574a99e,
                0xb77f19b6, 0xe0a9dc09, 0x662d09a1, 0xc4324633,
                0xe85a1f02, 0x09f0be8c, 0x4a99a025, 0x1d6efe10,
                0x1ab93d1d, 0x0ba5a4df, 0xa186f20f, 0x2868f169,
                0xdcb7da83, 0x573906fe, 0xa1e2ce9b, 0x4fcd7f52,
                0x50115e01, 0xa70683fa, 0xa002b5c4, 0x0de6d027,
                0x9af88c27, 0x773f8641, 0xc3604c06, 0x61a806b5,
                0xf0177a28, 0xc0f586e0, 0x006058aa, 0x30dc7d62,
                0x11e69ed7, 0x2338ea63, 0x53c2dd94, 0xc2c21634,
                0xbbcbee56, 0x90bcb6de, 0xebfc7da1, 0xce591d76,
                0x6f05e409, 0x4b7c0188, 0x39720a3d, 0x7c927c24,
                0x86e3725f, 0x724d9db9, 0x1ac15bb4, 0xd39eb8fc,
                0xed545578, 0x08fca5b5, 0xd83d7cd3, 0x4dad0fc4,
                0x1e50ef5e, 0xb161e6f8, 0xa28514d9, 0x6c51133c,
                0x6fd5c7e7, 0x56e14ec4, 0x362abfce, 0xddc6c837,
                0xd79a3234, 0x92638212, 0x670efa8e, 0x406000e0
            ]),
            new Uint32Array([
                0x3a39ce37, 0xd3faf5cf, 0xabc27737, 0x5ac52d1b,
                0x5cb0679e, 0x4fa33742, 0xd3822740, 0x99bc9bbe,
                0xd5118e9d, 0xbf0f7315, 0xd62d1c7e, 0xc700c47b,
                0xb78c1b6b, 0x21a19045, 0xb26eb1be, 0x6a366eb4,
                0x5748ab2f, 0xbc946e79, 0xc6a376d2, 0x6549c2c8,
                0x530ff8ee, 0x468dde7d, 0xd5730a1d, 0x4cd04dc6,
                0x2939bbdb, 0xa9ba4650, 0xac9526e8, 0xbe5ee304,
                0xa1fad5f0, 0x6a2d519a, 0x63ef8ce2, 0x9a86ee22,
                0xc089c2b8, 0x43242ef6, 0xa51e03aa, 0x9cf2d0a4,
                0x83c061ba, 0x9be96a4d, 0x8fe51550, 0xba645bd6,
                0x2826a2f9, 0xa73a3ae1, 0x4ba99586, 0xef5562e9,
                0xc72fefd3, 0xf752f7da, 0x3f046f69, 0x77fa0a59,
                0x80e4a915, 0x87b08601, 0x9b09e6ad, 0x3b3ee593,
                0xe990fd5a, 0x9e34d797, 0x2cf0b7d9, 0x022b8b51,
                0x96d5ac3a, 0x017da67d, 0xd1cf3ed6, 0x7c7d2d28,
                0x1f9f25cf, 0xadf2b89b, 0x5ad6b472, 0x5a88f54c,
                0xe029ac71, 0xe019a5e6, 0x47b0acfd, 0xed93fa9b,
                0xe8d3c48d, 0x283b57cc, 0xf8d56629, 0x79132e28,
                0x785f0191, 0xed756055, 0xf7960e44, 0xe3d35e8c,
                0x15056dd4, 0x88f46dba, 0x03a16125, 0x0564f0bd,
                0xc3eb9e15, 0x3c9057a2, 0x97271aec, 0xa93a072a,
                0x1b3f6d9b, 0x1e6321f5, 0xf59c66fb, 0x26dcf319,
                0x7533d928, 0xb155fdf5, 0x03563482, 0x8aba3cbb,
                0x28517711, 0xc20ad9f8, 0xabcc5167, 0xccad925f,
                0x4de81751, 0x3830dc8e, 0x379d5862, 0x9320f991,
                0xea7a90c2, 0xfb3e7bce, 0x5121ce64, 0x774fbe32,
                0xa8b6e37e, 0xc3293d46, 0x48de5369, 0x6413e680,
                0xa2ae0810, 0xdd6db224, 0x69852dfd, 0x09072166,
                0xb39a460a, 0x6445c0dd, 0x586cdecf, 0x1c20c8ae,
                0x5bbef7dd, 0x1b588d40, 0xccd2017f, 0x6bb4e3bb,
                0xdda26a7e, 0x3a59ff45, 0x3e350a44, 0xbcb4cdd5,
                0x72eacea8, 0xfa6484bb, 0x8d6612ae, 0xbf3c6f47,
                0xd29be463, 0x542f5d9e, 0xaec2771b, 0xf64e6370,
                0x740e0d8d, 0xe75b1357, 0xf8721671, 0xaf537d5d,
                0x4040cb08, 0x4eb4e2cc, 0x34d2466a, 0x0115af84,
                0xe1b00428, 0x95983a1d, 0x06b89fb4, 0xce6ea048,
                0x6f3f3b82, 0x3520ab82, 0x011a1d4b, 0x277227f8,
                0x611560b1, 0xe7933fdc, 0xbb3a792b, 0x344525bd,
                0xa08839e1, 0x51ce794b, 0x2f32c9b7, 0xa01fbac9,
                0xe01cc87e, 0xbcc7d1f6, 0xcf0111c3, 0xa1e8aac7,
                0x1a908749, 0xd44fbd9a, 0xd0dadecb, 0xd50ada38,
                0x0339c32a, 0xc6913667, 0x8df9317c, 0xe0b12b4f,
                0xf79e59b7, 0x43f5bb3a, 0xf2d519ff, 0x27d9459c,
                0xbf97222c, 0x15e6fc2a, 0x0f91fc71, 0x9b941525,
                0xfae59361, 0xceb69ceb, 0xc2a86459, 0x12baa8d1,
                0xb6c1075e, 0xe3056a0c, 0x10d25065, 0xcb03a442,
                0xe0ec6e0e, 0x1698db3b, 0x4c98a0be, 0x3278e964,
                0x9f1f9532, 0xe0d392df, 0xd3a0342b, 0x8971f21e,
                0x1b0a7441, 0x4ba3348c, 0xc5be7120, 0xc37632d8,
                0xdf359f8d, 0x9b992f2e, 0xe60b6f47, 0x0fe3f11d,
                0xe54cda54, 0x1edad891, 0xce6279cf, 0xcd3e7e6f,
                0x1618b166, 0xfd2c1d05, 0x848fd2c5, 0xf6fb2299,
                0xf523f357, 0xa6327623, 0x93a83531, 0x56cccd02,
                0xacf08162, 0x5a75ebb5, 0x6e163697, 0x88d273cc,
                0xde966292, 0x81b949d0, 0x4c50901b, 0x71c65614,
                0xe6c6c7bd, 0x327a140a, 0x45e1d006, 0xc3f27b9a,
                0xc9aa53fd, 0x62a80f00, 0xbb25bfe2, 0x35bdd2f6,
                0x71126905, 0xb2040222, 0xb6cbcf7c, 0xcd769c2b,
                0x53113ec0, 0x1640e3d3, 0x38abbd60, 0x2547adf0,
                0xba38209c, 0xf746ce76, 0x77afa1c5, 0x20756060,
                0x85cbfe4e, 0x8ae88dd8, 0x7aaaf9b0, 0x4cf9aa7e,
                0x1948c25c, 0x02fb8a8c, 0x01c36ae4, 0xd6ebe1f9,
                0x90d4f869, 0xa65cdea0, 0x3f09252d, 0xc208e69f,
                0xb74e6132, 0xce77e25b, 0x578fdfe3, 0x3ac372e6
            ])
        ];
        this.P = new Uint32Array([
            0x243f6a88, 0x85a308d3, 0x13198a2e, 0x03707344,
            0xa4093822, 0x299f31d0, 0x082efa98, 0xec4e6c89,
            0x452821e6, 0x38d01377, 0xbe5466cf, 0x34e90c6c,
            0xc0ac29b7, 0xc97c50dd, 0x3f84d5b5, 0xb5470917,
            0x9216d5d9, 0x8979fb1b
        ]);
    };
    function F(S, x8, i) {
        return (((S[0][x8[i + 3]] +
            S[1][x8[i + 2]]) ^
            S[2][x8[i + 1]]) +
            S[3][x8[i]]);
    }
    ;
    Blowfish.prototype.encipher = function (x, x8) {
        if (x8 === undefined) {
            x8 = new Uint8Array(x.buffer);
            if (x.byteOffset !== 0)
                x8 = x8.subarray(x.byteOffset);
        }
        x[0] ^= this.P[0];
        for (var i = 1; i < 16; i += 2) {
            x[1] ^= F(this.S, x8, 0) ^ this.P[i];
            x[0] ^= F(this.S, x8, 4) ^ this.P[i + 1];
        }
        var t = x[0];
        x[0] = x[1] ^ this.P[17];
        x[1] = t;
    };
    Blowfish.prototype.decipher = function (x) {
        var x8 = new Uint8Array(x.buffer);
        if (x.byteOffset !== 0)
            x8 = x8.subarray(x.byteOffset);
        x[0] ^= this.P[17];
        for (var i = 16; i > 0; i -= 2) {
            x[1] ^= F(this.S, x8, 0) ^ this.P[i];
            x[0] ^= F(this.S, x8, 4) ^ this.P[i - 1];
        }
        var t = x[0];
        x[0] = x[1] ^ this.P[0];
        x[1] = t;
    };
    function stream2word(data, databytes) {
        var i, temp = 0;
        for (i = 0; i < 4; i++, BLF_J++) {
            if (BLF_J >= databytes)
                BLF_J = 0;
            temp = (temp << 8) | data[BLF_J];
        }
        return temp;
    }
    ;
    Blowfish.prototype.expand0state = function (key, keybytes) {
        var d = new Uint32Array(2), i, k;
        var d8 = new Uint8Array(d.buffer);
        for (i = 0, BLF_J = 0; i < 18; i++) {
            this.P[i] ^= stream2word(key, keybytes);
        }
        BLF_J = 0;
        for (i = 0; i < 18; i += 2) {
            this.encipher(d, d8);
            this.P[i] = d[0];
            this.P[i + 1] = d[1];
        }
        for (i = 0; i < 4; i++) {
            for (k = 0; k < 256; k += 2) {
                this.encipher(d, d8);
                this.S[i][k] = d[0];
                this.S[i][k + 1] = d[1];
            }
        }
    };
    Blowfish.prototype.expandstate = function (data, databytes, key, keybytes) {
        var d = new Uint32Array(2), i, k;
        for (i = 0, BLF_J = 0; i < 18; i++) {
            this.P[i] ^= stream2word(key, keybytes);
        }
        for (i = 0, BLF_J = 0; i < 18; i += 2) {
            d[0] ^= stream2word(data, databytes);
            d[1] ^= stream2word(data, databytes);
            this.encipher(d);
            this.P[i] = d[0];
            this.P[i + 1] = d[1];
        }
        for (i = 0; i < 4; i++) {
            for (k = 0; k < 256; k += 2) {
                d[0] ^= stream2word(data, databytes);
                d[1] ^= stream2word(data, databytes);
                this.encipher(d);
                this.S[i][k] = d[0];
                this.S[i][k + 1] = d[1];
            }
        }
        BLF_J = 0;
    };
    Blowfish.prototype.enc = function (data, blocks) {
        for (var i = 0; i < blocks; i++) {
            this.encipher(data.subarray(i * 2));
        }
    };
    Blowfish.prototype.dec = function (data, blocks) {
        for (var i = 0; i < blocks; i++) {
            this.decipher(data.subarray(i * 2));
        }
    };
    var BCRYPT_BLOCKS = 8, BCRYPT_HASHSIZE = 32;
    function bcrypt_hash(sha2pass, sha2salt, out) {
        var state = new Blowfish(), cdata = new Uint32Array(BCRYPT_BLOCKS), i, ciphertext = new Uint8Array([79, 120, 121, 99, 104, 114, 111, 109, 97, 116, 105,
            99, 66, 108, 111, 119, 102, 105, 115, 104, 83, 119, 97, 116, 68, 121, 110, 97, 109,
            105, 116, 101]); //"OxychromaticBlowfishSwatDynamite"
        state.expandstate(sha2salt, 64, sha2pass, 64);
        for (i = 0; i < 64; i++) {
            state.expand0state(sha2salt, 64);
            state.expand0state(sha2pass, 64);
        }
        for (i = 0; i < BCRYPT_BLOCKS; i++)
            cdata[i] = stream2word(ciphertext, ciphertext.byteLength);
        for (i = 0; i < 64; i++)
            state.enc(cdata, cdata.byteLength / 8);
        for (i = 0; i < BCRYPT_BLOCKS; i++) {
            out[4 * i + 3] = cdata[i] >>> 24;
            out[4 * i + 2] = cdata[i] >>> 16;
            out[4 * i + 1] = cdata[i] >>> 8;
            out[4 * i + 0] = cdata[i];
        }
    }
    ;
    function bcrypt_pbkdf(pass, passlen, salt, saltlen, key, keylen, rounds) {
        var sha2pass = new Uint8Array(64), sha2salt = new Uint8Array(64), out = new Uint8Array(BCRYPT_HASHSIZE), tmpout = new Uint8Array(BCRYPT_HASHSIZE), countsalt = new Uint8Array(saltlen + 4), i, j, amt, stride, dest, count, origkeylen = keylen;
        if (rounds < 1)
            return -1;
        if (passlen === 0 || saltlen === 0 || keylen === 0 ||
            keylen > (out.byteLength * out.byteLength) || saltlen > (1 << 20))
            return -1;
        stride = Math.floor((keylen + out.byteLength - 1) / out.byteLength);
        amt = Math.floor((keylen + stride - 1) / stride);
        for (i = 0; i < saltlen; i++)
            countsalt[i] = salt[i];
        crypto_hash_sha512(sha2pass, pass, passlen);
        for (count = 1; keylen > 0; count++) {
            countsalt[saltlen + 0] = count >>> 24;
            countsalt[saltlen + 1] = count >>> 16;
            countsalt[saltlen + 2] = count >>> 8;
            countsalt[saltlen + 3] = count;
            crypto_hash_sha512(sha2salt, countsalt, saltlen + 4);
            bcrypt_hash(sha2pass, sha2salt, tmpout);
            for (i = out.byteLength; i--;)
                out[i] = tmpout[i];
            for (i = 1; i < rounds; i++) {
                crypto_hash_sha512(sha2salt, tmpout, tmpout.byteLength);
                bcrypt_hash(sha2pass, sha2salt, tmpout);
                for (j = 0; j < out.byteLength; j++)
                    out[j] ^= tmpout[j];
            }
            amt = Math.min(amt, keylen);
            for (i = 0; i < amt; i++) {
                dest = i * stride + (count - 1);
                if (dest >= origkeylen)
                    break;
                key[dest] = out[i];
            }
            keylen -= i;
        }
        return 0;
    }
    ;
    module.exports = {
        BLOCKS: BCRYPT_BLOCKS,
        HASHSIZE: BCRYPT_HASHSIZE,
        hash: bcrypt_hash,
        pbkdf: bcrypt_pbkdf
    };
}
,
/* buffer-from/index */ function _(require, module, exports) {
    var toString = Object.prototype.toString;
    var isModern = (typeof Buffer.alloc === 'function' &&
        typeof Buffer.allocUnsafe === 'function' &&
        typeof Buffer.from === 'function');
    function isArrayBuffer(input) {
        return toString.call(input).slice(8, -1) === 'ArrayBuffer';
    }
    function fromArrayBuffer(obj, byteOffset, length) {
        byteOffset >>>= 0;
        var maxLength = obj.byteLength - byteOffset;
        if (maxLength < 0) {
            throw new RangeError("'offset' is out of bounds");
        }
        if (length === undefined) {
            length = maxLength;
        }
        else {
            length >>>= 0;
            if (length > maxLength) {
                throw new RangeError("'length' is out of bounds");
            }
        }
        return isModern
            ? Buffer.from(obj.slice(byteOffset, byteOffset + length))
            : new Buffer(new Uint8Array(obj.slice(byteOffset, byteOffset + length)));
    }
    function fromString(string, encoding) {
        if (typeof encoding !== 'string' || encoding === '') {
            encoding = 'utf8';
        }
        if (!Buffer.isEncoding(encoding)) {
            throw new TypeError('"encoding" must be a valid string encoding');
        }
        return isModern
            ? Buffer.from(string, encoding)
            : new Buffer(string, encoding);
    }
    function bufferFrom(value, encodingOrOffset, length) {
        if (typeof value === 'number') {
            throw new TypeError('"value" argument must not be a number');
        }
        if (isArrayBuffer(value)) {
            return fromArrayBuffer(value, encodingOrOffset, length);
        }
        if (typeof value === 'string') {
            return fromString(value, encodingOrOffset);
        }
        return isModern
            ? Buffer.from(value)
            : new Buffer(value);
    }
    module.exports = bufferFrom;
}
,
/* camelcase/index */ function _(require, module, exports) {
    module.exports = function () {
        var str = [].map.call(arguments, function (str) {
            return str.trim();
        }).filter(function (str) {
            return str.length;
        }).join('-');
        if (!str.length) {
            return '';
        }
        if (str.length === 1 || !(/[_.\- ]+/).test(str)) {
            if (str[0] === str[0].toLowerCase() && str.slice(1) !== str.slice(1).toLowerCase()) {
                return str;
            }
            return str.toLowerCase();
        }
        return str
            .replace(/^[_.\- ]+/, '')
            .toLowerCase()
            .replace(/[_.\- ]+(\w|$)/g, function (m, p1) {
            return p1.toUpperCase();
        });
    };
}
,
/* caseless/index */ function _(require, module, exports) {
    function Caseless(dict) {
        this.dict = dict || {};
    }
    Caseless.prototype.set = function (name, value, clobber) {
        if (typeof name === 'object') {
            for (var i in name) {
                this.set(i, name[i], value);
            }
        }
        else {
            if (typeof clobber === 'undefined')
                clobber = true;
            var has = this.has(name);
            if (!clobber && has)
                this.dict[has] = this.dict[has] + ',' + value;
            else
                this.dict[has || name] = value;
            return has;
        }
    };
    Caseless.prototype.has = function (name) {
        var keys = Object.keys(this.dict), name = name.toLowerCase();
        for (var i = 0; i < keys.length; i++) {
            if (keys[i].toLowerCase() === name)
                return keys[i];
        }
        return false;
    };
    Caseless.prototype.get = function (name) {
        name = name.toLowerCase();
        var result, _key;
        var headers = this.dict;
        Object.keys(headers).forEach(function (key) {
            _key = key.toLowerCase();
            if (name === _key)
                result = headers[key];
        });
        return result;
    };
    Caseless.prototype.swap = function (name) {
        var has = this.has(name);
        if (has === name)
            return;
        if (!has)
            throw new Error('There is no header than matches "' + name + '"');
        this.dict[name] = this.dict[has];
        delete this.dict[has];
    };
    Caseless.prototype.del = function (name) {
        var has = this.has(name);
        return delete this.dict[has || name];
    };
    module.exports = function (dict) { return new Caseless(dict); };
    module.exports.httpify = function (resp, headers) {
        var c = new Caseless(headers);
        resp.setHeader = function (key, value, clobber) {
            if (typeof value === 'undefined')
                return;
            return c.set(key, value, clobber);
        };
        resp.hasHeader = function (key) {
            return c.has(key);
        };
        resp.getHeader = function (key) {
            return c.get(key);
        };
        resp.removeHeader = function (key) {
            return c.del(key);
        };
        resp.headers = c.dict;
        return c;
    };
}
,
/* center-align/index */ function _(require, module, exports) {
    var utils = require(72) /* ./utils */;
    module.exports = function centerAlign(val) {
        return utils.align(val, function (len, longest) {
            return Math.floor((longest - len) / 2);
        });
    };
}
,
/* center-align/utils */ function _(require, module, exports) {
    /**
     * Lazily-required module dependencies (makes the application
     * faster)
     */
    var utils = require(161) /* lazy-cache */(require);
    /**
     * Temporarily re-assign `require` to trick browserify and
     * webpack into reconizing lazy dependencies.
     *
     * This tiny bit of ugliness has the huge dual advantage of
     * only loading modules that are actually called at some
     * point in the lifecycle of the application, whilst also
     * allowing browserify and webpack to find modules that
     * are depended on but never actually called.
     */
    var fn = require;
    require = utils;
    /**
     * Lazily required module dependencies
     */
    require('align-text', 'align');
    /**
     * Restore `require`
     */
    require = fn;
    /**
     * Expose `utils` modules
     */
    module.exports = utils;
}
,
/* cliui/index */ function _(require, module, exports) {
    var wrap = require(374) /* wordwrap */, align = {
        right: require(310) /* right-align */,
        center: require(71) /* center-align */
    }, top = 0, right = 1, bottom = 2, left = 3;
    function UI(opts) {
        this.width = opts.width;
        this.wrap = opts.wrap;
        this.rows = [];
    }
    UI.prototype.span = function () {
        var cols = this.div.apply(this, arguments);
        cols.span = true;
    };
    UI.prototype.div = function () {
        if (arguments.length === 0)
            this.div('');
        if (this.wrap && this._shouldApplyLayoutDSL.apply(this, arguments)) {
            return this._applyLayoutDSL(arguments[0]);
        }
        var cols = [];
        for (var i = 0, arg; (arg = arguments[i]) !== undefined; i++) {
            if (typeof arg === 'string')
                cols.push(this._colFromString(arg));
            else
                cols.push(arg);
        }
        this.rows.push(cols);
        return cols;
    };
    UI.prototype._shouldApplyLayoutDSL = function () {
        return arguments.length === 1 && typeof arguments[0] === 'string' &&
            /[\t\n]/.test(arguments[0]);
    };
    UI.prototype._applyLayoutDSL = function (str) {
        var _this = this, rows = str.split('\n'), leftColumnWidth = 0;
        // simple heuristic for layout, make sure the
        // second column lines up along the left-hand.
        // don't allow the first column to take up more
        // than 50% of the screen.
        rows.forEach(function (row) {
            var columns = row.split('\t');
            if (columns.length > 1 && columns[0].length > leftColumnWidth) {
                leftColumnWidth = Math.min(Math.floor(_this.width * 0.5), columns[0].length);
            }
        });
        // generate a table:
        //  replacing ' ' with padding calculations.
        //  using the algorithmically generated width.
        rows.forEach(function (row) {
            var columns = row.split('\t');
            _this.div.apply(_this, columns.map(function (r, i) {
                return {
                    text: r.trim(),
                    padding: [0, r.match(/\s*$/)[0].length, 0, r.match(/^\s*/)[0].length],
                    width: (i === 0 && columns.length > 1) ? leftColumnWidth : undefined
                };
            }));
        });
        return this.rows[this.rows.length - 1];
    };
    UI.prototype._colFromString = function (str) {
        return {
            text: str
        };
    };
    UI.prototype.toString = function () {
        var _this = this, lines = [];
        _this.rows.forEach(function (row, i) {
            _this.rowToString(row, lines);
        });
        // don't display any lines with the
        // hidden flag set.
        lines = lines.filter(function (line) {
            return !line.hidden;
        });
        return lines.map(function (line) {
            return line.text;
        }).join('\n');
    };
    UI.prototype.rowToString = function (row, lines) {
        var _this = this, paddingLeft, rrows = this._rasterize(row), str = '', ts, width, wrapWidth;
        rrows.forEach(function (rrow, r) {
            str = '';
            rrow.forEach(function (col, c) {
                ts = ''; // temporary string used during alignment/padding.
                width = row[c].width; // the width with padding.
                wrapWidth = _this._negatePadding(row[c]); // the width without padding.
                for (var i = 0; i < Math.max(wrapWidth, col.length); i++) {
                    ts += col.charAt(i) || ' ';
                }
                // align the string within its column.
                if (row[c].align && row[c].align !== 'left' && _this.wrap) {
                    ts = align[row[c].align](ts.trim() + '\n' + new Array(wrapWidth + 1).join(' '))
                        .split('\n')[0];
                    if (ts.length < wrapWidth)
                        ts += new Array(width - ts.length).join(' ');
                }
                // add left/right padding and print string.
                paddingLeft = (row[c].padding || [0, 0, 0, 0])[left];
                if (paddingLeft)
                    str += new Array(row[c].padding[left] + 1).join(' ');
                str += ts;
                if (row[c].padding && row[c].padding[right])
                    str += new Array(row[c].padding[right] + 1).join(' ');
                // if prior row is span, try to render the
                // current row on the prior line.
                if (r === 0 && lines.length > 0) {
                    str = _this._renderInline(str, lines[lines.length - 1], paddingLeft);
                }
            });
            // remove trailing whitespace.
            lines.push({
                text: str.replace(/ +$/, ''),
                span: row.span
            });
        });
        return lines;
    };
    // if the full 'source' can render in
    // the target line, do so.
    UI.prototype._renderInline = function (source, previousLine, paddingLeft) {
        var target = previousLine.text, str = '';
        if (!previousLine.span)
            return source;
        // if we're not applying wrapping logic,
        // just always append to the span.
        if (!this.wrap) {
            previousLine.hidden = true;
            return target + source;
        }
        for (var i = 0, tc, sc; i < Math.max(source.length, target.length); i++) {
            tc = target.charAt(i) || ' ';
            sc = source.charAt(i) || ' ';
            // we tried to overwrite a character in the other string.
            if (tc !== ' ' && sc !== ' ')
                return source;
            // there is not enough whitespace to maintain padding.
            if (sc !== ' ' && i < paddingLeft + target.length)
                return source;
            // :thumbsup:
            if (tc === ' ')
                str += sc;
            else
                str += tc;
        }
        previousLine.hidden = true;
        return str;
    };
    UI.prototype._rasterize = function (row) {
        var _this = this, i, rrow, rrows = [], widths = this._columnWidths(row), wrapped;
        // word wrap all columns, and create
        // a data-structure that is easy to rasterize.
        row.forEach(function (col, c) {
            // leave room for left and right padding.
            col.width = widths[c];
            if (_this.wrap)
                wrapped = wrap.hard(_this._negatePadding(col))(col.text).split('\n');
            else
                wrapped = col.text.split('\n');
            // add top and bottom padding.
            if (col.padding) {
                for (i = 0; i < (col.padding[top] || 0); i++)
                    wrapped.unshift('');
                for (i = 0; i < (col.padding[bottom] || 0); i++)
                    wrapped.push('');
            }
            wrapped.forEach(function (str, r) {
                if (!rrows[r])
                    rrows.push([]);
                rrow = rrows[r];
                for (var i = 0; i < c; i++) {
                    if (rrow[i] === undefined)
                        rrow.push('');
                }
                rrow.push(str);
            });
        });
        return rrows;
    };
    UI.prototype._negatePadding = function (col) {
        var wrapWidth = col.width;
        if (col.padding)
            wrapWidth -= (col.padding[left] || 0) + (col.padding[right] || 0);
        return wrapWidth;
    };
    UI.prototype._columnWidths = function (row) {
        var _this = this, widths = [], unset = row.length, unsetWidth, remainingWidth = this.width;
        // column widths can be set in config.
        row.forEach(function (col, i) {
            if (col.width) {
                unset--;
                widths[i] = col.width;
                remainingWidth -= col.width;
            }
            else {
                widths[i] = undefined;
            }
        });
        // any unset widths should be calculated.
        if (unset)
            unsetWidth = Math.floor(remainingWidth / unset);
        widths.forEach(function (w, i) {
            if (!_this.wrap)
                widths[i] = row[i].width || row[i].text.length;
            else if (w === undefined)
                widths[i] = Math.max(unsetWidth, _minWidth(row[i]));
        });
        return widths;
    };
    // calculates the minimum width of
    // a column, based on padding preferences.
    function _minWidth(col) {
        var padding = col.padding || [];
        return 1 + (padding[left] || 0) + (padding[right] || 0);
    }
    module.exports = function (opts) {
        opts = opts || {};
        return new UI({
            width: (opts || {}).width || 80,
            wrap: typeof opts.wrap === 'boolean' ? opts.wrap : true
        });
    };
}
,
/* co/index */ function _(require, module, exports) {
    /**
     * slice() reference.
     */
    var slice = Array.prototype.slice;
    /**
     * Expose `co`.
     */
    module.exports = co['default'] = co.co = co;
    /**
     * Wrap the given generator `fn` into a
     * function that returns a promise.
     * This is a separate function so that
     * every `co()` call doesn't create a new,
     * unnecessary closure.
     *
     * @param {GeneratorFunction} fn
     * @return {Function}
     * @api public
     */
    co.wrap = function (fn) {
        createPromise.__generatorFunction__ = fn;
        return createPromise;
        function createPromise() {
            return co.call(this, fn.apply(this, arguments));
        }
    };
    /**
     * Execute the generator function or a generator
     * and return a promise.
     *
     * @param {Function} fn
     * @return {Promise}
     * @api public
     */
    function co(gen) {
        var ctx = this;
        var args = slice.call(arguments, 1);
        // we wrap everything in a promise to avoid promise chaining,
        // which leads to memory leak errors.
        // see https://github.com/tj/co/issues/180
        return new Promise(function (resolve, reject) {
            if (typeof gen === 'function')
                gen = gen.apply(ctx, args);
            if (!gen || typeof gen.next !== 'function')
                return resolve(gen);
            onFulfilled();
            /**
             * @param {Mixed} res
             * @return {Promise}
             * @api private
             */
            function onFulfilled(res) {
                var ret;
                try {
                    ret = gen.next(res);
                }
                catch (e) {
                    return reject(e);
                }
                next(ret);
            }
            /**
             * @param {Error} err
             * @return {Promise}
             * @api private
             */
            function onRejected(err) {
                var ret;
                try {
                    ret = gen.throw(err);
                }
                catch (e) {
                    return reject(e);
                }
                next(ret);
            }
            /**
             * Get the next value in the generator,
             * return a promise.
             *
             * @param {Object} ret
             * @return {Promise}
             * @api private
             */
            function next(ret) {
                if (ret.done)
                    return resolve(ret.value);
                var value = toPromise.call(ctx, ret.value);
                if (value && isPromise(value))
                    return value.then(onFulfilled, onRejected);
                return onRejected(new TypeError('You may only yield a function, promise, generator, array, or object, '
                    + 'but the following object was passed: "' + String(ret.value) + '"'));
            }
        });
    }
    /**
     * Convert a `yield`ed value into a promise.
     *
     * @param {Mixed} obj
     * @return {Promise}
     * @api private
     */
    function toPromise(obj) {
        if (!obj)
            return obj;
        if (isPromise(obj))
            return obj;
        if (isGeneratorFunction(obj) || isGenerator(obj))
            return co.call(this, obj);
        if ('function' == typeof obj)
            return thunkToPromise.call(this, obj);
        if (Array.isArray(obj))
            return arrayToPromise.call(this, obj);
        if (isObject(obj))
            return objectToPromise.call(this, obj);
        return obj;
    }
    /**
     * Convert a thunk to a promise.
     *
     * @param {Function}
     * @return {Promise}
     * @api private
     */
    function thunkToPromise(fn) {
        var ctx = this;
        return new Promise(function (resolve, reject) {
            fn.call(ctx, function (err, res) {
                if (err)
                    return reject(err);
                if (arguments.length > 2)
                    res = slice.call(arguments, 1);
                resolve(res);
            });
        });
    }
    /**
     * Convert an array of "yieldables" to a promise.
     * Uses `Promise.all()` internally.
     *
     * @param {Array} obj
     * @return {Promise}
     * @api private
     */
    function arrayToPromise(obj) {
        return Promise.all(obj.map(toPromise, this));
    }
    /**
     * Convert an object of "yieldables" to a promise.
     * Uses `Promise.all()` internally.
     *
     * @param {Object} obj
     * @return {Promise}
     * @api private
     */
    function objectToPromise(obj) {
        var results = new obj.constructor();
        var keys = Object.keys(obj);
        var promises = [];
        for (var i = 0; i < keys.length; i++) {
            var key = keys[i];
            var promise = toPromise.call(this, obj[key]);
            if (promise && isPromise(promise))
                defer(promise, key);
            else
                results[key] = obj[key];
        }
        return Promise.all(promises).then(function () {
            return results;
        });
        function defer(promise, key) {
            // predefine the key in the result
            results[key] = undefined;
            promises.push(promise.then(function (res) {
                results[key] = res;
            }));
        }
    }
    /**
     * Check if `obj` is a promise.
     *
     * @param {Object} obj
     * @return {Boolean}
     * @api private
     */
    function isPromise(obj) {
        return 'function' == typeof obj.then;
    }
    /**
     * Check if `obj` is a generator.
     *
     * @param {Mixed} obj
     * @return {Boolean}
     * @api private
     */
    function isGenerator(obj) {
        return 'function' == typeof obj.next && 'function' == typeof obj.throw;
    }
    /**
     * Check if `obj` is a generator function.
     *
     * @param {Mixed} obj
     * @return {Boolean}
     * @api private
     */
    function isGeneratorFunction(obj) {
        var constructor = obj.constructor;
        if (!constructor)
            return false;
        if ('GeneratorFunction' === constructor.name || 'GeneratorFunction' === constructor.displayName)
            return true;
        return isGenerator(constructor.prototype);
    }
    /**
     * Check for plain object.
     *
     * @param {Mixed} val
     * @return {Boolean}
     * @api private
     */
    function isObject(val) {
        return Object == val.constructor;
    }
}
,
/* coffeescript/lib/coffeescript/coffeescript */ function _(require, module, exports) {
    // Generated by CoffeeScript 2.3.0
    (function () {
        // CoffeeScript can be used both on the server, as a command-line compiler based
        // on Node.js/V8, or to run CoffeeScript directly in the browser. This module
        // contains the main entry functions for tokenizing, parsing, and compiling
        // source CoffeeScript into JavaScript.
        var FILE_EXTENSIONS, Lexer, SourceMap, base64encode, checkShebangLine, compile, formatSourcePosition, getSourceMap, helpers, lexer, packageJson, parser, sourceMaps, sources, withPrettyErrors, indexOf = [].indexOf;
        ({ Lexer } = require(78) /* ./lexer */);
        ({ parser } = require(80) /* ./parser */);
        helpers = require(76) /* ./helpers */;
        SourceMap = require(84) /* ./sourcemap */;
        // Require `package.json`, which is two levels above this file, as this file is
        // evaluated from `lib/coffeescript`.
        packageJson = require(85) /* ../../package.json */;
        // The current CoffeeScript version number.
        exports.VERSION = packageJson.version;
        exports.FILE_EXTENSIONS = FILE_EXTENSIONS = ['.coffee', '.litcoffee', '.coffee.md'];
        // Expose helpers for testing.
        exports.helpers = helpers;
        // Function that allows for btoa in both nodejs and the browser.
        base64encode = function (src) {
            switch (false) {
                case typeof Buffer !== 'function':
                    return Buffer.from(src).toString('base64');
                case typeof btoa !== 'function':
                    // The contents of a `<script>` block are encoded via UTF-16, so if any extended
                    // characters are used in the block, btoa will fail as it maxes out at UTF-8.
                    // See https://developer.mozilla.org/en-US/docs/Web/API/WindowBase64/Base64_encoding_and_decoding#The_Unicode_Problem
                    // for the gory details, and for the solution implemented here.
                    return btoa(encodeURIComponent(src).replace(/%([0-9A-F]{2})/g, function (match, p1) {
                        return String.fromCharCode('0x' + p1);
                    }));
                default:
                    throw new Error('Unable to base64 encode inline sourcemap.');
            }
        };
        // Function wrapper to add source file information to SyntaxErrors thrown by the
        // lexer/parser/compiler.
        withPrettyErrors = function (fn) {
            return function (code, options = {}) {
                var err;
                try {
                    return fn.call(this, code, options);
                }
                catch (error) {
                    err = error;
                    if (typeof code !== 'string') { // Support `CoffeeScript.nodes(tokens)`.
                        throw err;
                    }
                    throw helpers.updateSyntaxError(err, code, options.filename);
                }
            };
        };
        // For each compiled file, save its source in memory in case we need to
        // recompile it later. We might need to recompile if the first compilation
        // didn’t create a source map (faster) but something went wrong and we need
        // a stack trace. Assuming that most of the time, code isn’t throwing
        // exceptions, it’s probably more efficient to compile twice only when we
        // need a stack trace, rather than always generating a source map even when
        // it’s not likely to be used. Save in form of `filename`: [`(source)`]
        sources = {};
        // Also save source maps if generated, in form of `(source)`: [`(source map)`].
        sourceMaps = {};
        // Compile CoffeeScript code to JavaScript, using the Coffee/Jison compiler.
        // If `options.sourceMap` is specified, then `options.filename` must also be
        // specified. All options that can be passed to `SourceMap#generate` may also
        // be passed here.
        // This returns a javascript string, unless `options.sourceMap` is passed,
        // in which case this returns a `{js, v3SourceMap, sourceMap}`
        // object, where sourceMap is a sourcemap.coffee#SourceMap object, handy for
        // doing programmatic lookups.
        exports.compile = compile = withPrettyErrors(function (code, options = {}) {
            var currentColumn, currentLine, encoded, filename, fragment, fragments, generateSourceMap, header, i, j, js, len, len1, map, newLines, ref, ref1, sourceMapDataURI, sourceURL, token, tokens, transpiler, transpilerOptions, transpilerOutput, v3SourceMap;
            // Clone `options`, to avoid mutating the `options` object passed in.
            options = Object.assign({}, options);
            // Always generate a source map if no filename is passed in, since without a
            // a filename we have no way to retrieve this source later in the event that
            // we need to recompile it to get a source map for `prepareStackTrace`.
            generateSourceMap = options.sourceMap || options.inlineMap || (options.filename == null);
            filename = options.filename || '<anonymous>';
            checkShebangLine(filename, code);
            if (sources[filename] == null) {
                sources[filename] = [];
            }
            sources[filename].push(code);
            if (generateSourceMap) {
                map = new SourceMap;
            }
            tokens = lexer.tokenize(code, options);
            // Pass a list of referenced variables, so that generated variables won’t get
            // the same name.
            options.referencedVars = (function () {
                var i, len, results;
                results = [];
                for (i = 0, len = tokens.length; i < len; i++) {
                    token = tokens[i];
                    if (token[0] === 'IDENTIFIER') {
                        results.push(token[1]);
                    }
                }
                return results;
            })();
            // Check for import or export; if found, force bare mode.
            if (!((options.bare != null) && options.bare === true)) {
                for (i = 0, len = tokens.length; i < len; i++) {
                    token = tokens[i];
                    if ((ref = token[0]) === 'IMPORT' || ref === 'EXPORT') {
                        options.bare = true;
                        break;
                    }
                }
            }
            fragments = parser.parse(tokens).compileToFragments(options);
            currentLine = 0;
            if (options.header) {
                currentLine += 1;
            }
            if (options.shiftLine) {
                currentLine += 1;
            }
            currentColumn = 0;
            js = "";
            for (j = 0, len1 = fragments.length; j < len1; j++) {
                fragment = fragments[j];
                // Update the sourcemap with data from each fragment.
                if (generateSourceMap) {
                    // Do not include empty, whitespace, or semicolon-only fragments.
                    if (fragment.locationData && !/^[;\s]*$/.test(fragment.code)) {
                        map.add([fragment.locationData.first_line, fragment.locationData.first_column], [currentLine, currentColumn], {
                            noReplace: true
                        });
                    }
                    newLines = helpers.count(fragment.code, "\n");
                    currentLine += newLines;
                    if (newLines) {
                        currentColumn = fragment.code.length - (fragment.code.lastIndexOf("\n") + 1);
                    }
                    else {
                        currentColumn += fragment.code.length;
                    }
                }
                // Copy the code from each fragment into the final JavaScript.
                js += fragment.code;
            }
            if (options.header) {
                header = `Generated by CoffeeScript ${this.VERSION}`;
                js = `// ${header}\n${js}`;
            }
            if (generateSourceMap) {
                v3SourceMap = map.generate(options, code);
                if (sourceMaps[filename] == null) {
                    sourceMaps[filename] = [];
                }
                sourceMaps[filename].push(map);
            }
            if (options.transpile) {
                if (typeof options.transpile !== 'object') {
                    // This only happens if run via the Node API and `transpile` is set to
                    // something other than an object.
                    throw new Error('The transpile option must be given an object with options to pass to Babel');
                }
                // Get the reference to Babel that we have been passed if this compiler
                // is run via the CLI or Node API.
                transpiler = options.transpile.transpile;
                delete options.transpile.transpile;
                transpilerOptions = Object.assign({}, options.transpile);
                // See https://github.com/babel/babel/issues/827#issuecomment-77573107:
                // Babel can take a v3 source map object as input in `inputSourceMap`
                // and it will return an *updated* v3 source map object in its output.
                if (v3SourceMap && (transpilerOptions.inputSourceMap == null)) {
                    transpilerOptions.inputSourceMap = v3SourceMap;
                }
                transpilerOutput = transpiler(js, transpilerOptions);
                js = transpilerOutput.code;
                if (v3SourceMap && transpilerOutput.map) {
                    v3SourceMap = transpilerOutput.map;
                }
            }
            if (options.inlineMap) {
                encoded = base64encode(JSON.stringify(v3SourceMap));
                sourceMapDataURI = `
                sourceURL = `//# sourceURL=${(ref1 = options.filename) != null ? ref1 : 'coffeescript'}`;
                js = `${js}\n${sourceMapDataURI}\n${sourceURL}`;
            }
            if (options.sourceMap) {
                return {
                    js,
                    sourceMap: map,
                    v3SourceMap: JSON.stringify(v3SourceMap, null, 2)
                };
            }
            else {
                return js;
            }
        });
        // Tokenize a string of CoffeeScript code, and return the array of tokens.
        exports.tokens = withPrettyErrors(function (code, options) {
            return lexer.tokenize(code, options);
        });
        // Parse a string of CoffeeScript code or an array of lexed tokens, and
        // return the AST. You can then compile it by calling `.compile()` on the root,
        // or traverse it by using `.traverseChildren()` with a callback.
        exports.nodes = withPrettyErrors(function (source, options) {
            if (typeof source === 'string') {
                return parser.parse(lexer.tokenize(source, options));
            }
            else {
                return parser.parse(source);
            }
        });
        // This file used to export these methods; leave stubs that throw warnings
        // instead. These methods have been moved into `index.coffee` to provide
        // separate entrypoints for Node and non-Node environments, so that static
        // analysis tools don’t choke on Node packages when compiling for a non-Node
        // environment.
        exports.run = exports.eval = exports.register = function () {
            throw new Error('require index.coffee, not this file');
        };
        // Instantiate a Lexer for our use here.
        lexer = new Lexer;
        // The real Lexer produces a generic stream of tokens. This object provides a
        // thin wrapper around it, compatible with the Jison API. We can then pass it
        // directly as a "Jison lexer".
        parser.lexer = {
            lex: function () {
                var tag, token;
                token = parser.tokens[this.pos++];
                if (token) {
                    [tag, this.yytext, this.yylloc] = token;
                    parser.errorToken = token.origin || token;
                    this.yylineno = this.yylloc.first_line;
                }
                else {
                    tag = '';
                }
                return tag;
            },
            setInput: function (tokens) {
                parser.tokens = tokens;
                return this.pos = 0;
            },
            upcomingInput: function () {
                return '';
            }
        };
        // Make all the AST nodes visible to the parser.
        parser.yy = require(79) /* ./nodes */;
        // Override Jison's default error handling function.
        parser.yy.parseError = function (message, { token }) {
            var errorLoc, errorTag, errorText, errorToken, tokens;
            // Disregard Jison's message, it contains redundant line number information.
            // Disregard the token, we take its value directly from the lexer in case
            // the error is caused by a generated token which might refer to its origin.
            ({ errorToken, tokens } = parser);
            [errorTag, errorText, errorLoc] = errorToken;
            errorText = (function () {
                switch (false) {
                    case errorToken !== tokens[tokens.length - 1]:
                        return 'end of input';
                    case errorTag !== 'INDENT' && errorTag !== 'OUTDENT':
                        return 'indentation';
                    case errorTag !== 'IDENTIFIER' && errorTag !== 'NUMBER' && errorTag !== 'INFINITY' && errorTag !== 'STRING' && errorTag !== 'STRING_START' && errorTag !== 'REGEX' && errorTag !== 'REGEX_START':
                        return errorTag.replace(/_START$/, '').toLowerCase();
                    default:
                        return helpers.nameWhitespaceCharacter(errorText);
                }
            })();
            // The second argument has a `loc` property, which should have the location
            // data for this token. Unfortunately, Jison seems to send an outdated `loc`
            // (from the previous token), so we take the location information directly
            // from the lexer.
            return helpers.throwSyntaxError(`unexpected ${errorText}`, errorLoc);
        };
        // Based on http://v8.googlecode.com/svn/branches/bleeding_edge/src/messages.js
        // Modified to handle sourceMap
        formatSourcePosition = function (frame, getSourceMapping) {
            var as, column, fileLocation, filename, functionName, isConstructor, isMethodCall, line, methodName, source, tp, typeName;
            filename = void 0;
            fileLocation = '';
            if (frame.isNative()) {
                fileLocation = "native";
            }
            else {
                if (frame.isEval()) {
                    filename = frame.getScriptNameOrSourceURL();
                    if (!filename) {
                        fileLocation = `${frame.getEvalOrigin()}, `;
                    }
                }
                else {
                    filename = frame.getFileName();
                }
                filename || (filename = "<anonymous>");
                line = frame.getLineNumber();
                column = frame.getColumnNumber();
                // Check for a sourceMap position
                source = getSourceMapping(filename, line, column);
                fileLocation = source ? `${filename}:${source[0]}:${source[1]}` : `${filename}:${line}:${column}`;
            }
            functionName = frame.getFunctionName();
            isConstructor = frame.isConstructor();
            isMethodCall = !(frame.isToplevel() || isConstructor);
            if (isMethodCall) {
                methodName = frame.getMethodName();
                typeName = frame.getTypeName();
                if (functionName) {
                    tp = as = '';
                    if (typeName && functionName.indexOf(typeName)) {
                        tp = `${typeName}.`;
                    }
                    if (methodName && functionName.indexOf(`.${methodName}`) !== functionName.length - methodName.length - 1) {
                        as = ` [as ${methodName}]`;
                    }
                    return `${tp}${functionName}${as} (${fileLocation})`;
                }
                else {
                    return `${typeName}.${methodName || '<anonymous>'} (${fileLocation})`;
                }
            }
            else if (isConstructor) {
                return `new ${functionName || '<anonymous>'} (${fileLocation})`;
            }
            else if (functionName) {
                return `${functionName} (${fileLocation})`;
            }
            else {
                return fileLocation;
            }
        };
        getSourceMap = function (filename, line, column) {
            var answer, i, map, ref, ref1, sourceLocation;
            if (!(filename === '<anonymous>' || (ref = filename.slice(filename.lastIndexOf('.')), indexOf.call(FILE_EXTENSIONS, ref) >= 0))) {
                // Skip files that we didn’t compile, like Node system files that appear in
                // the stack trace, as they never have source maps.
                return null;
            }
            if (filename !== '<anonymous>' && (sourceMaps[filename] != null)) {
                return sourceMaps[filename][sourceMaps[filename].length - 1];
                // CoffeeScript compiled in a browser or via `CoffeeScript.compile` or `.run`
                // may get compiled with `options.filename` that’s missing, which becomes
                // `<anonymous>`; but the runtime might request the stack trace with the
                // filename of the script file. See if we have a source map cached under
                // `<anonymous>` that matches the error.
            }
            else if (sourceMaps['<anonymous>'] != null) {
                ref1 = sourceMaps['<anonymous>'];
                // Work backwards from the most recent anonymous source maps, until we find
                // one that works. This isn’t foolproof; there is a chance that multiple
                // source maps will have line/column pairs that match. But we have no other
                // way to match them. `frame.getFunction().toString()` doesn’t always work,
                // and it’s not foolproof either.
                for (i = ref1.length - 1; i >= 0; i += -1) {
                    map = ref1[i];
                    sourceLocation = map.sourceLocation([line - 1, column - 1]);
                    if (((sourceLocation != null ? sourceLocation[0] : void 0) != null) && (sourceLocation[1] != null)) {
                        return map;
                    }
                }
            }
            // If all else fails, recompile this source to get a source map. We need the
            // previous section (for `<anonymous>`) despite this option, because after it
            // gets compiled we will still need to look it up from
            // `sourceMaps['<anonymous>']` in order to find and return it. That’s why we
            // start searching from the end in the previous block, because most of the
            // time the source map we want is the last one.
            if (sources[filename] != null) {
                answer = compile(sources[filename][sources[filename].length - 1], {
                    filename: filename,
                    sourceMap: true,
                    literate: helpers.isLiterate(filename)
                });
                return answer.sourceMap;
            }
            else {
                return null;
            }
        };
        // Based on [michaelficarra/CoffeeScriptRedux](http://goo.gl/ZTx1p)
        // NodeJS / V8 have no support for transforming positions in stack traces using
        // sourceMap, so we must monkey-patch Error to display CoffeeScript source
        // positions.
        Error.prepareStackTrace = function (err, stack) {
            var frame, frames, getSourceMapping;
            getSourceMapping = function (filename, line, column) {
                var answer, sourceMap;
                sourceMap = getSourceMap(filename, line, column);
                if (sourceMap != null) {
                    answer = sourceMap.sourceLocation([line - 1, column - 1]);
                }
                if (answer != null) {
                    return [answer[0] + 1, answer[1] + 1];
                }
                else {
                    return null;
                }
            };
            frames = (function () {
                var i, len, results;
                results = [];
                for (i = 0, len = stack.length; i < len; i++) {
                    frame = stack[i];
                    if (frame.getFunction() === exports.run) {
                        break;
                    }
                    results.push(`    at ${formatSourcePosition(frame, getSourceMapping)}`);
                }
                return results;
            })();
            return `${err.toString()}\n${frames.join('\n')}\n`;
        };
        checkShebangLine = function (file, input) {
            var args, firstLine, ref, rest;
            firstLine = input.split(/$/m)[0];
            rest = firstLine != null ? firstLine.match(/^#!\s*([^\s]+\s*)(.*)/) : void 0;
            args = rest != null ? (ref = rest[2]) != null ? ref.split(/\s/).filter(function (s) {
                return s !== '';
            }) : void 0 : void 0;
            if ((args != null ? args.length : void 0) > 1) {
                console.error('The script to be run begins with a shebang line with more than one\nargument. This script will fail on platforms such as Linux which only\nallow a single argument.');
                console.error(`The shebang line was: '${firstLine}' in file '${file}'`);
                return console.error(`The arguments were: ${JSON.stringify(args)}`);
            }
        };
    }).call(this);
}
,
/* coffeescript/lib/coffeescript/helpers */ function _(require, module, exports) {
    // Generated by CoffeeScript 2.3.0
    (function () {
        // This file contains the common helper functions that we'd like to share among
        // the **Lexer**, **Rewriter**, and the **Nodes**. Merge objects, flatten
        // arrays, count characters, that sort of thing.
        // Peek at the beginning of a given string to see if it matches a sequence.
        var attachCommentsToNode, buildLocationData, buildLocationHash, extend, flatten, ref, repeat, syntaxErrorToString;
        exports.starts = function (string, literal, start) {
            return literal === string.substr(start, literal.length);
        };
        // Peek at the end of a given string to see if it matches a sequence.
        exports.ends = function (string, literal, back) {
            var len;
            len = literal.length;
            return literal === string.substr(string.length - len - (back || 0), len);
        };
        // Repeat a string `n` times.
        exports.repeat = repeat = function (str, n) {
            var res;
            // Use clever algorithm to have O(log(n)) string concatenation operations.
            res = '';
            while (n > 0) {
                if (n & 1) {
                    res += str;
                }
                n >>>= 1;
                str += str;
            }
            return res;
        };
        // Trim out all falsy values from an array.
        exports.compact = function (array) {
            var i, item, len1, results;
            results = [];
            for (i = 0, len1 = array.length; i < len1; i++) {
                item = array[i];
                if (item) {
                    results.push(item);
                }
            }
            return results;
        };
        // Count the number of occurrences of a string in a string.
        exports.count = function (string, substr) {
            var num, pos;
            num = pos = 0;
            if (!substr.length) {
                return 1 / 0;
            }
            while (pos = 1 + string.indexOf(substr, pos)) {
                num++;
            }
            return num;
        };
        // Merge objects, returning a fresh copy with attributes from both sides.
        // Used every time `Base#compile` is called, to allow properties in the
        // options hash to propagate down the tree without polluting other branches.
        exports.merge = function (options, overrides) {
            return extend(extend({}, options), overrides);
        };
        // Extend a source object with the properties of another object (shallow copy).
        extend = exports.extend = function (object, properties) {
            var key, val;
            for (key in properties) {
                val = properties[key];
                object[key] = val;
            }
            return object;
        };
        // Return a flattened version of an array.
        // Handy for getting a list of `children` from the nodes.
        exports.flatten = flatten = function (array) {
            var element, flattened, i, len1;
            flattened = [];
            for (i = 0, len1 = array.length; i < len1; i++) {
                element = array[i];
                if ('[object Array]' === Object.prototype.toString.call(element)) {
                    flattened = flattened.concat(flatten(element));
                }
                else {
                    flattened.push(element);
                }
            }
            return flattened;
        };
        // Delete a key from an object, returning the value. Useful when a node is
        // looking for a particular method in an options hash.
        exports.del = function (obj, key) {
            var val;
            val = obj[key];
            delete obj[key];
            return val;
        };
        // Typical Array::some
        exports.some = (ref = Array.prototype.some) != null ? ref : function (fn) {
            var e, i, len1, ref1;
            ref1 = this;
            for (i = 0, len1 = ref1.length; i < len1; i++) {
                e = ref1[i];
                if (fn(e)) {
                    return true;
                }
            }
            return false;
        };
        // Helper function for extracting code from Literate CoffeeScript by stripping
        // out all non-code blocks, producing a string of CoffeeScript code that can
        // be compiled “normally.”
        exports.invertLiterate = function (code) {
            var blankLine, i, indented, insideComment, len1, line, listItemStart, out, ref1;
            out = [];
            blankLine = /^\s*$/;
            indented = /^[\t ]/;
            listItemStart = /^(?:\t?| {0,3})(?:[\*\-\+]|[0-9]{1,9}\.)[ \t]/; // Up to one tab, or up to three spaces, or neither;
            // followed by `*`, `-` or `+`;
            // or by an integer up to 9 digits long, followed by a period;
            // followed by a space or a tab.
            insideComment = false;
            ref1 = code.split('\n');
            for (i = 0, len1 = ref1.length; i < len1; i++) {
                line = ref1[i];
                if (blankLine.test(line)) {
                    insideComment = false;
                    out.push(line);
                }
                else if (insideComment || listItemStart.test(line)) {
                    insideComment = true;
                    out.push(`# ${line}`);
                }
                else if (!insideComment && indented.test(line)) {
                    out.push(line);
                }
                else {
                    insideComment = true;
                    out.push(`# ${line}`);
                }
            }
            return out.join('\n');
        };
        // Merge two jison-style location data objects together.
        // If `last` is not provided, this will simply return `first`.
        buildLocationData = function (first, last) {
            if (!last) {
                return first;
            }
            else {
                return {
                    first_line: first.first_line,
                    first_column: first.first_column,
                    last_line: last.last_line,
                    last_column: last.last_column
                };
            }
        };
        buildLocationHash = function (loc) {
            return `${loc.first_line}x${loc.first_column}-${loc.last_line}x${loc.last_column}`;
        };
        // This returns a function which takes an object as a parameter, and if that
        // object is an AST node, updates that object's locationData.
        // The object is returned either way.
        exports.addDataToNode = function (parserState, first, last) {
            return function (obj) {
                var i, len1, objHash, ref1, token, tokenHash;
                // Add location data
                if (((obj != null ? obj.updateLocationDataIfMissing : void 0) != null) && (first != null)) {
                    obj.updateLocationDataIfMissing(buildLocationData(first, last));
                }
                // Add comments data
                if (!parserState.tokenComments) {
                    parserState.tokenComments = {};
                    ref1 = parserState.parser.tokens;
                    for (i = 0, len1 = ref1.length; i < len1; i++) {
                        token = ref1[i];
                        if (!token.comments) {
                            continue;
                        }
                        tokenHash = buildLocationHash(token[2]);
                        if (parserState.tokenComments[tokenHash] == null) {
                            parserState.tokenComments[tokenHash] = token.comments;
                        }
                        else {
                            parserState.tokenComments[tokenHash].push(...token.comments);
                        }
                    }
                }
                if (obj.locationData != null) {
                    objHash = buildLocationHash(obj.locationData);
                    if (parserState.tokenComments[objHash] != null) {
                        attachCommentsToNode(parserState.tokenComments[objHash], obj);
                    }
                }
                return obj;
            };
        };
        exports.attachCommentsToNode = attachCommentsToNode = function (comments, node) {
            if ((comments == null) || comments.length === 0) {
                return;
            }
            if (node.comments == null) {
                node.comments = [];
            }
            return node.comments.push(...comments);
        };
        // Convert jison location data to a string.
        // `obj` can be a token, or a locationData.
        exports.locationDataToString = function (obj) {
            var locationData;
            if (("2" in obj) && ("first_line" in obj[2])) {
                locationData = obj[2];
            }
            else if ("first_line" in obj) {
                locationData = obj;
            }
            if (locationData) {
                return `${locationData.first_line + 1}:${locationData.first_column + 1}-` + `${locationData.last_line + 1}:${locationData.last_column + 1}`;
            }
            else {
                return "No location data";
            }
        };
        // A `.coffee.md` compatible version of `basename`, that returns the file sans-extension.
        exports.baseFileName = function (file, stripExt = false, useWinPathSep = false) {
            var parts, pathSep;
            pathSep = useWinPathSep ? /\\|\// : /\//;
            parts = file.split(pathSep);
            file = parts[parts.length - 1];
            if (!(stripExt && file.indexOf('.') >= 0)) {
                return file;
            }
            parts = file.split('.');
            parts.pop();
            if (parts[parts.length - 1] === 'coffee' && parts.length > 1) {
                parts.pop();
            }
            return parts.join('.');
        };
        // Determine if a filename represents a CoffeeScript file.
        exports.isCoffee = function (file) {
            return /\.((lit)?coffee|coffee\.md)$/.test(file);
        };
        // Determine if a filename represents a Literate CoffeeScript file.
        exports.isLiterate = function (file) {
            return /\.(litcoffee|coffee\.md)$/.test(file);
        };
        // Throws a SyntaxError from a given location.
        // The error's `toString` will return an error message following the "standard"
        // format `<filename>:<line>:<col>: <message>` plus the line with the error and a
        // marker showing where the error is.
        exports.throwSyntaxError = function (message, location) {
            var error;
            error = new SyntaxError(message);
            error.location = location;
            error.toString = syntaxErrorToString;
            // Instead of showing the compiler's stacktrace, show our custom error message
            // (this is useful when the error bubbles up in Node.js applications that
            // compile CoffeeScript for example).
            error.stack = error.toString();
            throw error;
        };
        // Update a compiler SyntaxError with source code information if it didn't have
        // it already.
        exports.updateSyntaxError = function (error, code, filename) {
            // Avoid screwing up the `stack` property of other errors (i.e. possible bugs).
            if (error.toString === syntaxErrorToString) {
                error.code || (error.code = code);
                error.filename || (error.filename = filename);
                error.stack = error.toString();
            }
            return error;
        };
        syntaxErrorToString = function () {
            var codeLine, colorize, colorsEnabled, end, filename, first_column, first_line, last_column, last_line, marker, ref1, ref2, ref3, start;
            if (!(this.code && this.location)) {
                return Error.prototype.toString.call(this);
            }
            ({ first_line, first_column, last_line, last_column } = this.location);
            if (last_line == null) {
                last_line = first_line;
            }
            if (last_column == null) {
                last_column = first_column;
            }
            filename = this.filename || '[stdin]';
            codeLine = this.code.split('\n')[first_line];
            start = first_column;
            // Show only the first line on multi-line errors.
            end = first_line === last_line ? last_column + 1 : codeLine.length;
            marker = codeLine.slice(0, start).replace(/[^\s]/g, ' ') + repeat('^', end - start);
            // Check to see if we're running on a color-enabled TTY.
            if (typeof process !== "undefined" && process !== null) {
                colorsEnabled = ((ref1 = process.stdout) != null ? ref1.isTTY : void 0) && !((ref2 = process.env) != null ? ref2.NODE_DISABLE_COLORS : void 0);
            }
            if ((ref3 = this.colorful) != null ? ref3 : colorsEnabled) {
                colorize = function (str) {
                    return `\x1B[1;31m${str}\x1B[0m`;
                };
                codeLine = codeLine.slice(0, start) + colorize(codeLine.slice(start, end)) + codeLine.slice(end);
                marker = colorize(marker);
            }
            return `${filename}:${first_line + 1}:${first_column + 1}: error: ${this.message}\n${codeLine}\n${marker}`;
        };
        exports.nameWhitespaceCharacter = function (string) {
            switch (string) {
                case ' ':
                    return 'space';
                case '\n':
                    return 'newline';
                case '\r':
                    return 'carriage return';
                case '\t':
                    return 'tab';
                default:
                    return string;
            }
        };
    }).call(this);
}
,
/* coffeescript/lib/coffeescript/index */ function _(require, module, exports) {
    // Generated by CoffeeScript 2.3.0
    (function () {
        // Node.js Implementation
        var CoffeeScript, ext, fs, helpers, i, len, path, ref, universalCompile, vm, hasProp = {}.hasOwnProperty;
        CoffeeScript = require(75) /* ./coffeescript */;
        fs = require('fs');
        vm = require('vm');
        path = require('path');
        helpers = CoffeeScript.helpers;
        CoffeeScript.transpile = function (js, options) {
            var babel;
            try {
                babel = require('babel-core');
            }
            catch (error) {
                // This error is only for Node, as CLI users will see a different error
                // earlier if they don’t have Babel installed.
                throw new Error('To use the transpile option, you must have the \'babel-core\' module installed');
            }
            return babel.transform(js, options);
        };
        // The `compile` method shared by the CLI, Node and browser APIs.
        universalCompile = CoffeeScript.compile;
        // The `compile` method particular to the Node API.
        CoffeeScript.compile = function (code, options) {
            // Pass a reference to Babel into the compiler, so that the transpile option
            // is available in the Node API. We need to do this so that tools like Webpack
            // can `require('coffeescript')` and build correctly, without trying to
            // require Babel.
            if (options != null ? options.transpile : void 0) {
                options.transpile.transpile = CoffeeScript.transpile;
            }
            return universalCompile.call(CoffeeScript, code, options);
        };
        // Compile and execute a string of CoffeeScript (on the server), correctly
        // setting `__filename`, `__dirname`, and relative `require()`.
        CoffeeScript.run = function (code, options = {}) {
            var answer, dir, mainModule, ref;
            mainModule = require.main;
            // Set the filename.
            mainModule.filename = process.argv[1] = options.filename ? fs.realpathSync(options.filename) : '<anonymous>';
            // Clear the module cache.
            mainModule.moduleCache && (mainModule.moduleCache = {});
            // Assign paths for node_modules loading
            dir = options.filename != null ? path.dirname(fs.realpathSync(options.filename)) : fs.realpathSync('.');
            mainModule.paths = require('module')._nodeModulePaths(dir);
            // Save the options for compiling child imports.
            mainModule.options = options;
            // Compile.
            if (!helpers.isCoffee(mainModule.filename) || require.extensions) {
                answer = CoffeeScript.compile(code, options);
                code = (ref = answer.js) != null ? ref : answer;
            }
            return mainModule._compile(code, mainModule.filename);
        };
        // Compile and evaluate a string of CoffeeScript (in a Node.js-like environment).
        // The CoffeeScript REPL uses this to run the input.
        CoffeeScript.eval = function (code, options = {}) {
            var Module, _module, _require, createContext, i, isContext, js, k, len, o, r, ref, ref1, ref2, ref3, sandbox, v;
            if (!(code = code.trim())) {
                return;
            }
            createContext = (ref = vm.Script.createContext) != null ? ref : vm.createContext;
            isContext = (ref1 = vm.isContext) != null ? ref1 : function (ctx) {
                return options.sandbox instanceof createContext().constructor;
            };
            if (createContext) {
                if (options.sandbox != null) {
                    if (isContext(options.sandbox)) {
                        sandbox = options.sandbox;
                    }
                    else {
                        sandbox = createContext();
                        ref2 = options.sandbox;
                        for (k in ref2) {
                            if (!hasProp.call(ref2, k))
                                continue;
                            v = ref2[k];
                            sandbox[k] = v;
                        }
                    }
                    sandbox.global = sandbox.root = sandbox.GLOBAL = sandbox;
                }
                else {
                    sandbox = global;
                }
                sandbox.__filename = options.filename || 'eval';
                sandbox.__dirname = path.dirname(sandbox.__filename);
                // define module/require only if they chose not to specify their own
                if (!(sandbox !== global || sandbox.module || sandbox.require)) {
                    Module = require('module');
                    sandbox.module = _module = new Module(options.modulename || 'eval');
                    sandbox.require = _require = function (path) {
                        return Module._load(path, _module, true);
                    };
                    _module.filename = sandbox.__filename;
                    ref3 = Object.getOwnPropertyNames(require);
                    for (i = 0, len = ref3.length; i < len; i++) {
                        r = ref3[i];
                        if (r !== 'paths' && r !== 'arguments' && r !== 'caller') {
                            _require[r] = require[r];
                        }
                    }
                    // use the same hack node currently uses for their own REPL
                    _require.paths = _module.paths = Module._nodeModulePaths(process.cwd());
                    _require.resolve = function (request) {
                        return Module._resolveFilename(request, _module);
                    };
                }
            }
            o = {};
            for (k in options) {
                if (!hasProp.call(options, k))
                    continue;
                v = options[k];
                o[k] = v;
            }
            o.bare = true; // ensure return value
            js = CoffeeScript.compile(code, o);
            if (sandbox === global) {
                return vm.runInThisContext(js);
            }
            else {
                return vm.runInContext(js, sandbox);
            }
        };
        CoffeeScript.register = function () {
            return require(81) /* ./register */;
        };
        // Throw error with deprecation warning when depending upon implicit `require.extensions` registration
        if (require.extensions) {
            ref = CoffeeScript.FILE_EXTENSIONS;
            for (i = 0, len = ref.length; i < len; i++) {
                ext = ref[i];
                (function (ext) {
                    var base;
                    return (base = require.extensions)[ext] != null ? base[ext] : base[ext] = function () {
                        throw new Error(`Use CoffeeScript.register() or require the coffeescript/register module to require ${ext} files.`);
                    };
                })(ext);
            }
        }
        CoffeeScript._compileFile = function (filename, options = {}) {
            var answer, err, raw, stripped;
            raw = fs.readFileSync(filename, 'utf8');
            // Strip the Unicode byte order mark, if this file begins with one.
            stripped = raw.charCodeAt(0) === 0xFEFF ? raw.substring(1) : raw;
            options = Object.assign({}, options, {
                filename: filename,
                literate: helpers.isLiterate(filename),
                sourceFiles: [filename],
                inlineMap: true // Always generate a source map, so that stack traces line up.
            });
            try {
                answer = CoffeeScript.compile(stripped, options);
            }
            catch (error) {
                err = error;
                // As the filename and code of a dynamically loaded file will be different
                // from the original file compiled with CoffeeScript.run, add that
                // information to error so it can be pretty-printed later.
                throw helpers.updateSyntaxError(err, stripped, filename);
            }
            return answer;
        };
        module.exports = CoffeeScript;
    }).call(this);
}
,
/* coffeescript/lib/coffeescript/lexer */ function _(require, module, exports) {
    // Generated by CoffeeScript 2.3.0
    (function () {
        // The CoffeeScript Lexer. Uses a series of token-matching regexes to attempt
        // matches against the beginning of the source code. When a match is found,
        // a token is produced, we consume the match, and start again. Tokens are in the
        // form:
        //     [tag, value, locationData]
        // where locationData is {first_line, first_column, last_line, last_column}, which is a
        // format that can be fed directly into [Jison](https://github.com/zaach/jison).  These
        // are read by jison in the `parser.lexer` function defined in coffeescript.coffee.
        var BOM, BOOL, CALLABLE, CODE, COFFEE_ALIASES, COFFEE_ALIAS_MAP, COFFEE_KEYWORDS, COMMENT, COMPARABLE_LEFT_SIDE, COMPARE, COMPOUND_ASSIGN, CSX_ATTRIBUTE, CSX_FRAGMENT_IDENTIFIER, CSX_IDENTIFIER, CSX_INTERPOLATION, HERECOMMENT_ILLEGAL, HEREDOC_DOUBLE, HEREDOC_INDENT, HEREDOC_SINGLE, HEREGEX, HEREGEX_OMIT, HERE_JSTOKEN, IDENTIFIER, INDENTABLE_CLOSERS, INDEXABLE, INSIDE_CSX, INVERSES, JSTOKEN, JS_KEYWORDS, LEADING_BLANK_LINE, LINE_BREAK, LINE_CONTINUER, Lexer, MATH, MULTI_DENT, NOT_REGEX, NUMBER, OPERATOR, POSSIBLY_DIVISION, REGEX, REGEX_FLAGS, REGEX_ILLEGAL, REGEX_INVALID_ESCAPE, RELATION, RESERVED, Rewriter, SHIFT, SIMPLE_STRING_OMIT, STRICT_PROSCRIBED, STRING_DOUBLE, STRING_INVALID_ESCAPE, STRING_OMIT, STRING_SINGLE, STRING_START, TRAILING_BLANK_LINE, TRAILING_SPACES, UNARY, UNARY_MATH, UNFINISHED, UNICODE_CODE_POINT_ESCAPE, VALID_FLAGS, WHITESPACE, attachCommentsToNode, compact, count, invertLiterate, isForFrom, isUnassignable, key, locationDataToString, merge, repeat, starts, throwSyntaxError, indexOf = [].indexOf, slice = [].slice;
        ({ Rewriter, INVERSES } = require(82) /* ./rewriter */);
        // Import the helpers we need.
        ({ count, starts, compact, repeat, invertLiterate, merge, attachCommentsToNode, locationDataToString, throwSyntaxError } = require(76) /* ./helpers */);
        // The Lexer Class
        // ---------------
        // The Lexer class reads a stream of CoffeeScript and divvies it up into tagged
        // tokens. Some potential ambiguity in the grammar has been avoided by
        // pushing some extra smarts into the Lexer.
        exports.Lexer = Lexer = class Lexer {
            // **tokenize** is the Lexer's main method. Scan by attempting to match tokens
            // one at a time, using a regular expression anchored at the start of the
            // remaining code, or a custom recursive token-matching method
            // (for interpolations). When the next token has been recorded, we move forward
            // within the code past the token, and begin again.
            // Each tokenizing method is responsible for returning the number of characters
            // it has consumed.
            // Before returning the token stream, run it through the [Rewriter](rewriter.html).
            tokenize(code, opts = {}) {
                var consumed, end, i, ref;
                this.literate = opts.literate; // Are we lexing literate CoffeeScript?
                this.indent = 0; // The current indentation level.
                this.baseIndent = 0; // The overall minimum indentation level.
                this.indebt = 0; // The over-indentation at the current level.
                this.outdebt = 0; // The under-outdentation at the current level.
                this.indents = []; // The stack of all current indentation levels.
                this.indentLiteral = ''; // The indentation.
                this.ends = []; // The stack for pairing up tokens.
                this.tokens = []; // Stream of parsed tokens in the form `['TYPE', value, location data]`.
                this.seenFor = false; // Used to recognize `FORIN`, `FOROF` and `FORFROM` tokens.
                this.seenImport = false; // Used to recognize `IMPORT FROM? AS?` tokens.
                this.seenExport = false; // Used to recognize `EXPORT FROM? AS?` tokens.
                this.importSpecifierList = false; // Used to identify when in an `IMPORT {...} FROM? ...`.
                this.exportSpecifierList = false; // Used to identify when in an `EXPORT {...} FROM? ...`.
                this.csxDepth = 0; // Used to optimize CSX checks, how deep in CSX we are.
                this.csxObjAttribute = {}; // Used to detect if CSX attributes is wrapped in {} (<div {props...} />).
                this.chunkLine = opts.line || 0; // The start line for the current @chunk.
                this.chunkColumn = opts.column || 0; // The start column of the current @chunk.
                code = this.clean(code); // The stripped, cleaned original source code.
                // At every position, run through this list of attempted matches,
                // short-circuiting if any of them succeed. Their order determines precedence:
                // `@literalToken` is the fallback catch-all.
                i = 0;
                while (this.chunk = code.slice(i)) {
                    consumed = this.identifierToken() || this.commentToken() || this.whitespaceToken() || this.lineToken() || this.stringToken() || this.numberToken() || this.csxToken() || this.regexToken() || this.jsToken() || this.literalToken();
                    // Update position.
                    [this.chunkLine, this.chunkColumn] = this.getLineAndColumnFromChunk(consumed);
                    i += consumed;
                    if (opts.untilBalanced && this.ends.length === 0) {
                        return {
                            tokens: this.tokens,
                            index: i
                        };
                    }
                }
                this.closeIndentation();
                if (end = this.ends.pop()) {
                    this.error(`missing ${end.tag}`, ((ref = end.origin) != null ? ref : end)[2]);
                }
                if (opts.rewrite === false) {
                    return this.tokens;
                }
                return (new Rewriter).rewrite(this.tokens);
            }
            // Preprocess the code to remove leading and trailing whitespace, carriage
            // returns, etc. If we’re lexing literate CoffeeScript, strip external Markdown
            // by removing all lines that aren’t indented by at least four spaces or a tab.
            clean(code) {
                if (code.charCodeAt(0) === BOM) {
                    code = code.slice(1);
                }
                code = code.replace(/\r/g, '').replace(TRAILING_SPACES, '');
                if (WHITESPACE.test(code)) {
                    code = `\n${code}`;
                    this.chunkLine--;
                }
                if (this.literate) {
                    code = invertLiterate(code);
                }
                return code;
            }
            // Tokenizers
            // ----------
            // Matches identifying literals: variables, keywords, method names, etc.
            // Check to ensure that JavaScript reserved words aren’t being used as
            // identifiers. Because CoffeeScript reserves a handful of keywords that are
            // allowed in JavaScript, we’re careful not to tag them as keywords when
            // referenced as property names here, so you can still do `jQuery.is()` even
            // though `is` means `===` otherwise.
            identifierToken() {
                var alias, colon, colonOffset, colonToken, id, idLength, inCSXTag, input, match, poppedToken, prev, prevprev, ref, ref1, ref10, ref2, ref3, ref4, ref5, ref6, ref7, ref8, ref9, regExSuper, regex, sup, tag, tagToken;
                inCSXTag = this.atCSXTag();
                regex = inCSXTag ? CSX_ATTRIBUTE : IDENTIFIER;
                if (!(match = regex.exec(this.chunk))) {
                    return 0;
                }
                [input, id, colon] = match;
                // Preserve length of id for location data
                idLength = id.length;
                poppedToken = void 0;
                if (id === 'own' && this.tag() === 'FOR') {
                    this.token('OWN', id);
                    return id.length;
                }
                if (id === 'from' && this.tag() === 'YIELD') {
                    this.token('FROM', id);
                    return id.length;
                }
                if (id === 'as' && this.seenImport) {
                    if (this.value() === '*') {
                        this.tokens[this.tokens.length - 1][0] = 'IMPORT_ALL';
                    }
                    else if (ref = this.value(true), indexOf.call(COFFEE_KEYWORDS, ref) >= 0) {
                        prev = this.prev();
                        [prev[0], prev[1]] = ['IDENTIFIER', this.value(true)];
                    }
                    if ((ref1 = this.tag()) === 'DEFAULT' || ref1 === 'IMPORT_ALL' || ref1 === 'IDENTIFIER') {
                        this.token('AS', id);
                        return id.length;
                    }
                }
                if (id === 'as' && this.seenExport) {
                    if ((ref2 = this.tag()) === 'IDENTIFIER' || ref2 === 'DEFAULT') {
                        this.token('AS', id);
                        return id.length;
                    }
                    if (ref3 = this.value(true), indexOf.call(COFFEE_KEYWORDS, ref3) >= 0) {
                        prev = this.prev();
                        [prev[0], prev[1]] = ['IDENTIFIER', this.value(true)];
                        this.token('AS', id);
                        return id.length;
                    }
                }
                if (id === 'default' && this.seenExport && ((ref4 = this.tag()) === 'EXPORT' || ref4 === 'AS')) {
                    this.token('DEFAULT', id);
                    return id.length;
                }
                if (id === 'do' && (regExSuper = /^(\s*super)(?!\(\))/.exec(this.chunk.slice(3)))) {
                    this.token('SUPER', 'super');
                    this.token('CALL_START', '(');
                    this.token('CALL_END', ')');
                    [input, sup] = regExSuper;
                    return sup.length + 3;
                }
                prev = this.prev();
                tag = colon || (prev != null) && (((ref5 = prev[0]) === '.' || ref5 === '?.' || ref5 === '::' || ref5 === '?::') || !prev.spaced && prev[0] === '@') ? 'PROPERTY' : 'IDENTIFIER';
                if (tag === 'IDENTIFIER' && (indexOf.call(JS_KEYWORDS, id) >= 0 || indexOf.call(COFFEE_KEYWORDS, id) >= 0) && !(this.exportSpecifierList && indexOf.call(COFFEE_KEYWORDS, id) >= 0)) {
                    tag = id.toUpperCase();
                    if (tag === 'WHEN' && (ref6 = this.tag(), indexOf.call(LINE_BREAK, ref6) >= 0)) {
                        tag = 'LEADING_WHEN';
                    }
                    else if (tag === 'FOR') {
                        this.seenFor = true;
                    }
                    else if (tag === 'UNLESS') {
                        tag = 'IF';
                    }
                    else if (tag === 'IMPORT') {
                        this.seenImport = true;
                    }
                    else if (tag === 'EXPORT') {
                        this.seenExport = true;
                    }
                    else if (indexOf.call(UNARY, tag) >= 0) {
                        tag = 'UNARY';
                    }
                    else if (indexOf.call(RELATION, tag) >= 0) {
                        if (tag !== 'INSTANCEOF' && this.seenFor) {
                            tag = 'FOR' + tag;
                            this.seenFor = false;
                        }
                        else {
                            tag = 'RELATION';
                            if (this.value() === '!') {
                                poppedToken = this.tokens.pop();
                                id = '!' + id;
                            }
                        }
                    }
                }
                else if (tag === 'IDENTIFIER' && this.seenFor && id === 'from' && isForFrom(prev)) {
                    tag = 'FORFROM';
                    this.seenFor = false;
                    // Throw an error on attempts to use `get` or `set` as keywords, or
                    // what CoffeeScript would normally interpret as calls to functions named
                    // `get` or `set`, i.e. `get({foo: function () {}})`.
                }
                else if (tag === 'PROPERTY' && prev) {
                    if (prev.spaced && (ref7 = prev[0], indexOf.call(CALLABLE, ref7) >= 0) && /^[gs]et$/.test(prev[1]) && this.tokens.length > 1 && ((ref8 = this.tokens[this.tokens.length - 2][0]) !== '.' && ref8 !== '?.' && ref8 !== '@')) {
                        this.error(`'${prev[1]}' cannot be used as a keyword, or as a function call without parentheses`, prev[2]);
                    }
                    else if (this.tokens.length > 2) {
                        prevprev = this.tokens[this.tokens.length - 2];
                        if (((ref9 = prev[0]) === '@' || ref9 === 'THIS') && prevprev && prevprev.spaced && /^[gs]et$/.test(prevprev[1]) && ((ref10 = this.tokens[this.tokens.length - 3][0]) !== '.' && ref10 !== '?.' && ref10 !== '@')) {
                            this.error(`'${prevprev[1]}' cannot be used as a keyword, or as a function call without parentheses`, prevprev[2]);
                        }
                    }
                }
                if (tag === 'IDENTIFIER' && indexOf.call(RESERVED, id) >= 0) {
                    this.error(`reserved word '${id}'`, {
                        length: id.length
                    });
                }
                if (!(tag === 'PROPERTY' || this.exportSpecifierList)) {
                    if (indexOf.call(COFFEE_ALIASES, id) >= 0) {
                        alias = id;
                        id = COFFEE_ALIAS_MAP[id];
                    }
                    tag = (function () {
                        switch (id) {
                            case '!':
                                return 'UNARY';
                            case '==':
                            case '!=':
                                return 'COMPARE';
                            case 'true':
                            case 'false':
                                return 'BOOL';
                            case 'break':
                            case 'continue':
                            case 'debugger':
                                return 'STATEMENT';
                            case '&&':
                            case '||':
                                return id;
                            default:
                                return tag;
                        }
                    })();
                }
                tagToken = this.token(tag, id, 0, idLength);
                if (alias) {
                    tagToken.origin = [tag, alias, tagToken[2]];
                }
                if (poppedToken) {
                    [tagToken[2].first_line, tagToken[2].first_column] = [poppedToken[2].first_line, poppedToken[2].first_column];
                }
                if (colon) {
                    colonOffset = input.lastIndexOf(inCSXTag ? '=' : ':');
                    colonToken = this.token(':', ':', colonOffset, colon.length);
                    if (inCSXTag) { // used by rewriter
                        colonToken.csxColon = true;
                    }
                }
                if (inCSXTag && tag === 'IDENTIFIER' && prev[0] !== ':') {
                    this.token(',', ',', 0, 0, tagToken);
                }
                return input.length;
            }
            // Matches numbers, including decimals, hex, and exponential notation.
            // Be careful not to interfere with ranges in progress.
            numberToken() {
                var base, lexedLength, match, number, numberValue, tag;
                if (!(match = NUMBER.exec(this.chunk))) {
                    return 0;
                }
                number = match[0];
                lexedLength = number.length;
                switch (false) {
                    case !/^0[BOX]/.test(number):
                        this.error(`radix prefix in '${number}' must be lowercase`, {
                            offset: 1
                        });
                        break;
                    case !/^(?!0x).*E/.test(number):
                        this.error(`exponential notation in '${number}' must be indicated with a lowercase 'e'`, {
                            offset: number.indexOf('E')
                        });
                        break;
                    case !/^0\d*[89]/.test(number):
                        this.error(`decimal literal '${number}' must not be prefixed with '0'`, {
                            length: lexedLength
                        });
                        break;
                    case !/^0\d+/.test(number):
                        this.error(`octal literal '${number}' must be prefixed with '0o'`, {
                            length: lexedLength
                        });
                }
                base = (function () {
                    switch (number.charAt(1)) {
                        case 'b':
                            return 2;
                        case 'o':
                            return 8;
                        case 'x':
                            return 16;
                        default:
                            return null;
                    }
                })();
                numberValue = base != null ? parseInt(number.slice(2), base) : parseFloat(number);
                tag = numberValue === 2e308 ? 'INFINITY' : 'NUMBER';
                this.token(tag, number, 0, lexedLength);
                return lexedLength;
            }
            // Matches strings, including multiline strings, as well as heredocs, with or without
            // interpolation.
            stringToken() {
                var $, attempt, delimiter, doc, end, heredoc, i, indent, indentRegex, match, prev, quote, ref, regex, token, tokens;
                [quote] = STRING_START.exec(this.chunk) || [];
                if (!quote) {
                    return 0;
                }
                // If the preceding token is `from` and this is an import or export statement,
                // properly tag the `from`.
                prev = this.prev();
                if (prev && this.value() === 'from' && (this.seenImport || this.seenExport)) {
                    prev[0] = 'FROM';
                }
                regex = (function () {
                    switch (quote) {
                        case "'":
                            return STRING_SINGLE;
                        case '"':
                            return STRING_DOUBLE;
                        case "'''":
                            return HEREDOC_SINGLE;
                        case '"""':
                            return HEREDOC_DOUBLE;
                    }
                })();
                heredoc = quote.length === 3;
                ({
                    tokens,
                    index: end
                } = this.matchWithInterpolations(regex, quote));
                $ = tokens.length - 1;
                delimiter = quote.charAt(0);
                if (heredoc) {
                    // Find the smallest indentation. It will be removed from all lines later.
                    indent = null;
                    doc = ((function () {
                        var j, len, results;
                        results = [];
                        for (i = j = 0, len = tokens.length; j < len; i = ++j) {
                            token = tokens[i];
                            if (token[0] === 'NEOSTRING') {
                                results.push(token[1]);
                            }
                        }
                        return results;
                    })()).join('#{}');
                    while (match = HEREDOC_INDENT.exec(doc)) {
                        attempt = match[1];
                        if (indent === null || (0 < (ref = attempt.length) && ref < indent.length)) {
                            indent = attempt;
                        }
                    }
                    if (indent) {
                        indentRegex = RegExp(`\\n${indent}`, "g");
                    }
                    this.mergeInterpolationTokens(tokens, { delimiter }, (value, i) => {
                        value = this.formatString(value, {
                            delimiter: quote
                        });
                        if (indentRegex) {
                            value = value.replace(indentRegex, '\n');
                        }
                        if (i === 0) {
                            value = value.replace(LEADING_BLANK_LINE, '');
                        }
                        if (i === $) {
                            value = value.replace(TRAILING_BLANK_LINE, '');
                        }
                        return value;
                    });
                }
                else {
                    this.mergeInterpolationTokens(tokens, { delimiter }, (value, i) => {
                        value = this.formatString(value, {
                            delimiter: quote
                        });
                        value = value.replace(SIMPLE_STRING_OMIT, function (match, offset) {
                            if ((i === 0 && offset === 0) || (i === $ && offset + match.length === value.length)) {
                                return '';
                            }
                            else {
                                return ' ';
                            }
                        });
                        return value;
                    });
                }
                if (this.atCSXTag()) {
                    this.token(',', ',', 0, 0, this.prev);
                }
                return end;
            }
            // Matches and consumes comments. The comments are taken out of the token
            // stream and saved for later, to be reinserted into the output after
            // everything has been parsed and the JavaScript code generated.
            commentToken(chunk = this.chunk) {
                var comment, commentAttachments, content, contents, here, i, match, matchIllegal, newLine, placeholderToken, prev;
                if (!(match = chunk.match(COMMENT))) {
                    return 0;
                }
                [comment, here] = match;
                contents = null;
                // Does this comment follow code on the same line?
                newLine = /^\s*\n+\s*#/.test(comment);
                if (here) {
                    matchIllegal = HERECOMMENT_ILLEGAL.exec(comment);
                    if (matchIllegal) {
                        this.error(`block comments cannot contain ${matchIllegal[0]}`, {
                            offset: matchIllegal.index,
                            length: matchIllegal[0].length
                        });
                    }
                    // Parse indentation or outdentation as if this block comment didn’t exist.
                    chunk = chunk.replace(`###${here}###`, '');
                    // Remove leading newlines, like `Rewriter::removeLeadingNewlines`, to
                    // avoid the creation of unwanted `TERMINATOR` tokens.
                    chunk = chunk.replace(/^\n+/, '');
                    this.lineToken(chunk);
                    // Pull out the ###-style comment’s content, and format it.
                    content = here;
                    if (indexOf.call(content, '\n') >= 0) {
                        content = content.replace(RegExp(`\\n${repeat(' ', this.indent)}`, "g"), '\n');
                    }
                    contents = [content];
                }
                else {
                    // The `COMMENT` regex captures successive line comments as one token.
                    // Remove any leading newlines before the first comment, but preserve
                    // blank lines between line comments.
                    content = comment.replace(/^(\n*)/, '');
                    content = content.replace(/^([ |\t]*)#/gm, '');
                    contents = content.split('\n');
                }
                commentAttachments = (function () {
                    var j, len, results;
                    results = [];
                    for (i = j = 0, len = contents.length; j < len; i = ++j) {
                        content = contents[i];
                        results.push({
                            content: content,
                            here: here != null,
                            newLine: newLine || i !== 0 // Line comments after the first one start new lines, by definition.
                        });
                    }
                    return results;
                })();
                prev = this.prev();
                if (!prev) {
                    // If there’s no previous token, create a placeholder token to attach
                    // this comment to; and follow with a newline.
                    commentAttachments[0].newLine = true;
                    this.lineToken(this.chunk.slice(comment.length));
                    placeholderToken = this.makeToken('JS', '');
                    placeholderToken.generated = true;
                    placeholderToken.comments = commentAttachments;
                    this.tokens.push(placeholderToken);
                    this.newlineToken(0);
                }
                else {
                    attachCommentsToNode(commentAttachments, prev);
                }
                return comment.length;
            }
            // Matches JavaScript interpolated directly into the source via backticks.
            jsToken() {
                var match, script;
                if (!(this.chunk.charAt(0) === '`' && (match = HERE_JSTOKEN.exec(this.chunk) || JSTOKEN.exec(this.chunk)))) {
                    return 0;
                }
                // Convert escaped backticks to backticks, and escaped backslashes
                // just before escaped backticks to backslashes
                script = match[1].replace(/\\+(`|$)/g, function (string) {
                    // `string` is always a value like '\`', '\\\`', '\\\\\`', etc.
                    // By reducing it to its latter half, we turn '\`' to '`', '\\\`' to '\`', etc.
                    return string.slice(-Math.ceil(string.length / 2));
                });
                this.token('JS', script, 0, match[0].length);
                return match[0].length;
            }
            // Matches regular expression literals, as well as multiline extended ones.
            // Lexing regular expressions is difficult to distinguish from division, so we
            // borrow some basic heuristics from JavaScript and Ruby.
            regexToken() {
                var body, closed, comment, comments, end, flags, index, j, len, match, origin, prev, ref, ref1, regex, tokens;
                switch (false) {
                    case !(match = REGEX_ILLEGAL.exec(this.chunk)):
                        this.error(`regular expressions cannot begin with ${match[2]}`, {
                            offset: match.index + match[1].length
                        });
                        break;
                    case !(match = this.matchWithInterpolations(HEREGEX, '///')):
                        ({ tokens, index } = match);
                        comments = this.chunk.slice(0, index).match(/\s+(#(?!{).*)/g);
                        if (comments) {
                            for (j = 0, len = comments.length; j < len; j++) {
                                comment = comments[j];
                                this.commentToken(comment);
                            }
                        }
                        break;
                    case !(match = REGEX.exec(this.chunk)):
                        [regex, body, closed] = match;
                        this.validateEscapes(body, {
                            isRegex: true,
                            offsetInChunk: 1
                        });
                        index = regex.length;
                        prev = this.prev();
                        if (prev) {
                            if (prev.spaced && (ref = prev[0], indexOf.call(CALLABLE, ref) >= 0)) {
                                if (!closed || POSSIBLY_DIVISION.test(regex)) {
                                    return 0;
                                }
                            }
                            else if (ref1 = prev[0], indexOf.call(NOT_REGEX, ref1) >= 0) {
                                return 0;
                            }
                        }
                        if (!closed) {
                            this.error('missing / (unclosed regex)');
                        }
                        break;
                    default:
                        return 0;
                }
                [flags] = REGEX_FLAGS.exec(this.chunk.slice(index));
                end = index + flags.length;
                origin = this.makeToken('REGEX', null, 0, end);
                switch (false) {
                    case !!VALID_FLAGS.test(flags):
                        this.error(`invalid regular expression flags ${flags}`, {
                            offset: index,
                            length: flags.length
                        });
                        break;
                    case !(regex || tokens.length === 1):
                        if (body) {
                            body = this.formatRegex(body, {
                                flags,
                                delimiter: '/'
                            });
                        }
                        else {
                            body = this.formatHeregex(tokens[0][1], { flags });
                        }
                        this.token('REGEX', `${this.makeDelimitedLiteral(body, {
                            delimiter: '/'
                        })}${flags}`, 0, end, origin);
                        break;
                    default:
                        this.token('REGEX_START', '(', 0, 0, origin);
                        this.token('IDENTIFIER', 'RegExp', 0, 0);
                        this.token('CALL_START', '(', 0, 0);
                        this.mergeInterpolationTokens(tokens, {
                            delimiter: '"',
                            double: true
                        }, (str) => {
                            return this.formatHeregex(str, { flags });
                        });
                        if (flags) {
                            this.token(',', ',', index - 1, 0);
                            this.token('STRING', '"' + flags + '"', index - 1, flags.length);
                        }
                        this.token(')', ')', end - 1, 0);
                        this.token('REGEX_END', ')', end - 1, 0);
                }
                return end;
            }
            // Matches newlines, indents, and outdents, and determines which is which.
            // If we can detect that the current line is continued onto the next line,
            // then the newline is suppressed:
            //     elements
            //       .each( ... )
            //       .map( ... )
            // Keeps track of the level of indentation, because a single outdent token
            // can close multiple indents, so we need to know how far in we happen to be.
            lineToken(chunk = this.chunk) {
                var backslash, diff, indent, match, minLiteralLength, newIndentLiteral, noNewlines, prev, size;
                if (!(match = MULTI_DENT.exec(chunk))) {
                    return 0;
                }
                indent = match[0];
                prev = this.prev();
                backslash = (prev != null ? prev[0] : void 0) === '\\';
                if (!(backslash && this.seenFor)) {
                    this.seenFor = false;
                }
                if (!((backslash && this.seenImport) || this.importSpecifierList)) {
                    this.seenImport = false;
                }
                if (!((backslash && this.seenExport) || this.exportSpecifierList)) {
                    this.seenExport = false;
                }
                size = indent.length - 1 - indent.lastIndexOf('\n');
                noNewlines = this.unfinished();
                newIndentLiteral = size > 0 ? indent.slice(-size) : '';
                if (!/^(.?)\1*$/.exec(newIndentLiteral)) {
                    this.error('mixed indentation', {
                        offset: indent.length
                    });
                    return indent.length;
                }
                minLiteralLength = Math.min(newIndentLiteral.length, this.indentLiteral.length);
                if (newIndentLiteral.slice(0, minLiteralLength) !== this.indentLiteral.slice(0, minLiteralLength)) {
                    this.error('indentation mismatch', {
                        offset: indent.length
                    });
                    return indent.length;
                }
                if (size - this.indebt === this.indent) {
                    if (noNewlines) {
                        this.suppressNewlines();
                    }
                    else {
                        this.newlineToken(0);
                    }
                    return indent.length;
                }
                if (size > this.indent) {
                    if (noNewlines) {
                        if (!backslash) {
                            this.indebt = size - this.indent;
                        }
                        this.suppressNewlines();
                        return indent.length;
                    }
                    if (!this.tokens.length) {
                        this.baseIndent = this.indent = size;
                        this.indentLiteral = newIndentLiteral;
                        return indent.length;
                    }
                    diff = size - this.indent + this.outdebt;
                    this.token('INDENT', diff, indent.length - size, size);
                    this.indents.push(diff);
                    this.ends.push({
                        tag: 'OUTDENT'
                    });
                    this.outdebt = this.indebt = 0;
                    this.indent = size;
                    this.indentLiteral = newIndentLiteral;
                }
                else if (size < this.baseIndent) {
                    this.error('missing indentation', {
                        offset: indent.length
                    });
                }
                else {
                    this.indebt = 0;
                    this.outdentToken(this.indent - size, noNewlines, indent.length);
                }
                return indent.length;
            }
            // Record an outdent token or multiple tokens, if we happen to be moving back
            // inwards past several recorded indents. Sets new @indent value.
            outdentToken(moveOut, noNewlines, outdentLength) {
                var decreasedIndent, dent, lastIndent, ref;
                decreasedIndent = this.indent - moveOut;
                while (moveOut > 0) {
                    lastIndent = this.indents[this.indents.length - 1];
                    if (!lastIndent) {
                        this.outdebt = moveOut = 0;
                    }
                    else if (this.outdebt && moveOut <= this.outdebt) {
                        this.outdebt -= moveOut;
                        moveOut = 0;
                    }
                    else {
                        dent = this.indents.pop() + this.outdebt;
                        if (outdentLength && (ref = this.chunk[outdentLength], indexOf.call(INDENTABLE_CLOSERS, ref) >= 0)) {
                            decreasedIndent -= dent - moveOut;
                            moveOut = dent;
                        }
                        this.outdebt = 0;
                        // pair might call outdentToken, so preserve decreasedIndent
                        this.pair('OUTDENT');
                        this.token('OUTDENT', moveOut, 0, outdentLength);
                        moveOut -= dent;
                    }
                }
                if (dent) {
                    this.outdebt -= moveOut;
                }
                this.suppressSemicolons();
                if (!(this.tag() === 'TERMINATOR' || noNewlines)) {
                    this.token('TERMINATOR', '\n', outdentLength, 0);
                }
                this.indent = decreasedIndent;
                this.indentLiteral = this.indentLiteral.slice(0, decreasedIndent);
                return this;
            }
            // Matches and consumes non-meaningful whitespace. Tag the previous token
            // as being “spaced”, because there are some cases where it makes a difference.
            whitespaceToken() {
                var match, nline, prev;
                if (!((match = WHITESPACE.exec(this.chunk)) || (nline = this.chunk.charAt(0) === '\n'))) {
                    return 0;
                }
                prev = this.prev();
                if (prev) {
                    prev[match ? 'spaced' : 'newLine'] = true;
                }
                if (match) {
                    return match[0].length;
                }
                else {
                    return 0;
                }
            }
            // Generate a newline token. Consecutive newlines get merged together.
            newlineToken(offset) {
                this.suppressSemicolons();
                if (this.tag() !== 'TERMINATOR') {
                    this.token('TERMINATOR', '\n', offset, 0);
                }
                return this;
            }
            // Use a `\` at a line-ending to suppress the newline.
            // The slash is removed here once its job is done.
            suppressNewlines() {
                var prev;
                prev = this.prev();
                if (prev[1] === '\\') {
                    if (prev.comments && this.tokens.length > 1) {
                        // `@tokens.length` should be at least 2 (some code, then `\`).
                        // If something puts a `\` after nothing, they deserve to lose any
                        // comments that trail it.
                        attachCommentsToNode(prev.comments, this.tokens[this.tokens.length - 2]);
                    }
                    this.tokens.pop();
                }
                return this;
            }
            // CSX is like JSX but for CoffeeScript.
            csxToken() {
                var afterTag, colon, csxTag, end, firstChar, id, input, match, origin, prev, prevChar, ref, token, tokens;
                firstChar = this.chunk[0];
                // Check the previous token to detect if attribute is spread.
                prevChar = this.tokens.length > 0 ? this.tokens[this.tokens.length - 1][0] : '';
                if (firstChar === '<') {
                    match = CSX_IDENTIFIER.exec(this.chunk.slice(1)) || CSX_FRAGMENT_IDENTIFIER.exec(this.chunk.slice(1));
                    // Not the right hand side of an unspaced comparison (i.e. `a<b`).
                    if (!(match && (this.csxDepth > 0 || !(prev = this.prev()) || prev.spaced || (ref = prev[0], indexOf.call(COMPARABLE_LEFT_SIDE, ref) < 0)))) {
                        return 0;
                    }
                    [input, id, colon] = match;
                    origin = this.token('CSX_TAG', id, 1, id.length);
                    this.token('CALL_START', '(');
                    this.token('[', '[');
                    this.ends.push({
                        tag: '/>',
                        origin: origin,
                        name: id
                    });
                    this.csxDepth++;
                    return id.length + 1;
                }
                else if (csxTag = this.atCSXTag()) {
                    if (this.chunk.slice(0, 2) === '/>') {
                        this.pair('/>');
                        this.token(']', ']', 0, 2);
                        this.token('CALL_END', ')', 0, 2);
                        this.csxDepth--;
                        return 2;
                    }
                    else if (firstChar === '{') {
                        if (prevChar === ':') {
                            token = this.token('(', '(');
                            this.csxObjAttribute[this.csxDepth] = false;
                        }
                        else {
                            token = this.token('{', '{');
                            this.csxObjAttribute[this.csxDepth] = true;
                        }
                        this.ends.push({
                            tag: '}',
                            origin: token
                        });
                        return 1;
                    }
                    else if (firstChar === '>') {
                        // Ignore terminators inside a tag.
                        this.pair('/>'); // As if the current tag was self-closing.
                        origin = this.token(']', ']');
                        this.token(',', ',');
                        ({
                            tokens,
                            index: end
                        } = this.matchWithInterpolations(INSIDE_CSX, '>', '</', CSX_INTERPOLATION));
                        this.mergeInterpolationTokens(tokens, {
                            delimiter: '"'
                        }, (value, i) => {
                            return this.formatString(value, {
                                delimiter: '>'
                            });
                        });
                        match = CSX_IDENTIFIER.exec(this.chunk.slice(end)) || CSX_FRAGMENT_IDENTIFIER.exec(this.chunk.slice(end));
                        if (!match || match[1] !== csxTag.name) {
                            this.error(`expected corresponding CSX closing tag for ${csxTag.name}`, csxTag.origin[2]);
                        }
                        afterTag = end + csxTag.name.length;
                        if (this.chunk[afterTag] !== '>') {
                            this.error("missing closing > after tag name", {
                                offset: afterTag,
                                length: 1
                            });
                        }
                        // +1 for the closing `>`.
                        this.token('CALL_END', ')', end, csxTag.name.length + 1);
                        this.csxDepth--;
                        return afterTag + 1;
                    }
                    else {
                        return 0;
                    }
                }
                else if (this.atCSXTag(1)) {
                    if (firstChar === '}') {
                        this.pair(firstChar);
                        if (this.csxObjAttribute[this.csxDepth]) {
                            this.token('}', '}');
                            this.csxObjAttribute[this.csxDepth] = false;
                        }
                        else {
                            this.token(')', ')');
                        }
                        this.token(',', ',');
                        return 1;
                    }
                    else {
                        return 0;
                    }
                }
                else {
                    return 0;
                }
            }
            atCSXTag(depth = 0) {
                var i, last, ref;
                if (this.csxDepth === 0) {
                    return false;
                }
                i = this.ends.length - 1;
                while (((ref = this.ends[i]) != null ? ref.tag : void 0) === 'OUTDENT' || depth-- > 0) { // Ignore indents.
                    i--;
                }
                last = this.ends[i];
                return (last != null ? last.tag : void 0) === '/>' && last;
            }
            // We treat all other single characters as a token. E.g.: `( ) , . !`
            // Multi-character operators are also literal tokens, so that Jison can assign
            // the proper order of operations. There are some symbols that we tag specially
            // here. `;` and newlines are both treated as a `TERMINATOR`, we distinguish
            // parentheses that indicate a method call from regular parentheses, and so on.
            literalToken() {
                var match, message, origin, prev, ref, ref1, ref2, ref3, ref4, skipToken, tag, token, value;
                if (match = OPERATOR.exec(this.chunk)) {
                    [value] = match;
                    if (CODE.test(value)) {
                        this.tagParameters();
                    }
                }
                else {
                    value = this.chunk.charAt(0);
                }
                tag = value;
                prev = this.prev();
                if (prev && indexOf.call(['=', ...COMPOUND_ASSIGN], value) >= 0) {
                    skipToken = false;
                    if (value === '=' && ((ref = prev[1]) === '||' || ref === '&&') && !prev.spaced) {
                        prev[0] = 'COMPOUND_ASSIGN';
                        prev[1] += '=';
                        prev = this.tokens[this.tokens.length - 2];
                        skipToken = true;
                    }
                    if (prev && prev[0] !== 'PROPERTY') {
                        origin = (ref1 = prev.origin) != null ? ref1 : prev;
                        message = isUnassignable(prev[1], origin[1]);
                        if (message) {
                            this.error(message, origin[2]);
                        }
                    }
                    if (skipToken) {
                        return value.length;
                    }
                }
                if (value === '{' && this.seenImport) {
                    this.importSpecifierList = true;
                }
                else if (this.importSpecifierList && value === '}') {
                    this.importSpecifierList = false;
                }
                else if (value === '{' && (prev != null ? prev[0] : void 0) === 'EXPORT') {
                    this.exportSpecifierList = true;
                }
                else if (this.exportSpecifierList && value === '}') {
                    this.exportSpecifierList = false;
                }
                if (value === ';') {
                    if (ref2 = prev != null ? prev[0] : void 0, indexOf.call(['=', ...UNFINISHED], ref2) >= 0) {
                        this.error('unexpected ;');
                    }
                    this.seenFor = this.seenImport = this.seenExport = false;
                    tag = 'TERMINATOR';
                }
                else if (value === '*' && (prev != null ? prev[0] : void 0) === 'EXPORT') {
                    tag = 'EXPORT_ALL';
                }
                else if (indexOf.call(MATH, value) >= 0) {
                    tag = 'MATH';
                }
                else if (indexOf.call(COMPARE, value) >= 0) {
                    tag = 'COMPARE';
                }
                else if (indexOf.call(COMPOUND_ASSIGN, value) >= 0) {
                    tag = 'COMPOUND_ASSIGN';
                }
                else if (indexOf.call(UNARY, value) >= 0) {
                    tag = 'UNARY';
                }
                else if (indexOf.call(UNARY_MATH, value) >= 0) {
                    tag = 'UNARY_MATH';
                }
                else if (indexOf.call(SHIFT, value) >= 0) {
                    tag = 'SHIFT';
                }
                else if (value === '?' && (prev != null ? prev.spaced : void 0)) {
                    tag = 'BIN?';
                }
                else if (prev) {
                    if (value === '(' && !prev.spaced && (ref3 = prev[0], indexOf.call(CALLABLE, ref3) >= 0)) {
                        if (prev[0] === '?') {
                            prev[0] = 'FUNC_EXIST';
                        }
                        tag = 'CALL_START';
                    }
                    else if (value === '[' && (((ref4 = prev[0], indexOf.call(INDEXABLE, ref4) >= 0) && !prev.spaced) || (prev[0] === '::'))) { // `.prototype` can’t be a method you can call.
                        tag = 'INDEX_START';
                        switch (prev[0]) {
                            case '?':
                                prev[0] = 'INDEX_SOAK';
                        }
                    }
                }
                token = this.makeToken(tag, value);
                switch (value) {
                    case '(':
                    case '{':
                    case '[':
                        this.ends.push({
                            tag: INVERSES[value],
                            origin: token
                        });
                        break;
                    case ')':
                    case '}':
                    case ']':
                        this.pair(value);
                }
                this.tokens.push(this.makeToken(tag, value));
                return value.length;
            }
            // Token Manipulators
            // ------------------
            // A source of ambiguity in our grammar used to be parameter lists in function
            // definitions versus argument lists in function calls. Walk backwards, tagging
            // parameters specially in order to make things easier for the parser.
            tagParameters() {
                var i, paramEndToken, stack, tok, tokens;
                if (this.tag() !== ')') {
                    return this;
                }
                stack = [];
                ({ tokens } = this);
                i = tokens.length;
                paramEndToken = tokens[--i];
                paramEndToken[0] = 'PARAM_END';
                while (tok = tokens[--i]) {
                    switch (tok[0]) {
                        case ')':
                            stack.push(tok);
                            break;
                        case '(':
                        case 'CALL_START':
                            if (stack.length) {
                                stack.pop();
                            }
                            else if (tok[0] === '(') {
                                tok[0] = 'PARAM_START';
                                return this;
                            }
                            else {
                                paramEndToken[0] = 'CALL_END';
                                return this;
                            }
                    }
                }
                return this;
            }
            // Close up all remaining open blocks at the end of the file.
            closeIndentation() {
                return this.outdentToken(this.indent);
            }
            // Match the contents of a delimited token and expand variables and expressions
            // inside it using Ruby-like notation for substitution of arbitrary
            // expressions.
            //     "Hello #{name.capitalize()}."
            // If it encounters an interpolation, this method will recursively create a new
            // Lexer and tokenize until the `{` of `#{` is balanced with a `}`.
            //  - `regex` matches the contents of a token (but not `delimiter`, and not
            //    `#{` if interpolations are desired).
            //  - `delimiter` is the delimiter of the token. Examples are `'`, `"`, `'''`,
            //    `"""` and `///`.
            //  - `closingDelimiter` is different from `delimiter` only in CSX
            //  - `interpolators` matches the start of an interpolation, for CSX it's both
            //    `{` and `<` (i.e. nested CSX tag)
            // This method allows us to have strings within interpolations within strings,
            // ad infinitum.
            matchWithInterpolations(regex, delimiter, closingDelimiter, interpolators) {
                var braceInterpolator, close, column, firstToken, index, interpolationOffset, interpolator, lastToken, line, match, nested, offsetInChunk, open, ref, rest, str, strPart, tokens;
                if (closingDelimiter == null) {
                    closingDelimiter = delimiter;
                }
                if (interpolators == null) {
                    interpolators = /^#\{/;
                }
                tokens = [];
                offsetInChunk = delimiter.length;
                if (this.chunk.slice(0, offsetInChunk) !== delimiter) {
                    return null;
                }
                str = this.chunk.slice(offsetInChunk);
                while (true) {
                    [strPart] = regex.exec(str);
                    this.validateEscapes(strPart, {
                        isRegex: delimiter.charAt(0) === '/',
                        offsetInChunk
                    });
                    // Push a fake `'NEOSTRING'` token, which will get turned into a real string later.
                    tokens.push(this.makeToken('NEOSTRING', strPart, offsetInChunk));
                    str = str.slice(strPart.length);
                    offsetInChunk += strPart.length;
                    if (!(match = interpolators.exec(str))) {
                        break;
                    }
                    [interpolator] = match;
                    // To remove the `#` in `#{`.
                    interpolationOffset = interpolator.length - 1;
                    [line, column] = this.getLineAndColumnFromChunk(offsetInChunk + interpolationOffset);
                    rest = str.slice(interpolationOffset);
                    ({
                        tokens: nested,
                        index
                    } = new Lexer().tokenize(rest, {
                        line: line,
                        column: column,
                        untilBalanced: true
                    }));
                    // Account for the `#` in `#{`
                    index += interpolationOffset;
                    braceInterpolator = str[index - 1] === '}';
                    if (braceInterpolator) {
                        // Turn the leading and trailing `{` and `}` into parentheses. Unnecessary
                        // parentheses will be removed later.
                        [open] = nested, [close] = slice.call(nested, -1);
                        open[0] = open[1] = '(';
                        close[0] = close[1] = ')';
                        close.origin = ['', 'end of interpolation', close[2]];
                    }
                    if (((ref = nested[1]) != null ? ref[0] : void 0) === 'TERMINATOR') {
                        // Remove leading `'TERMINATOR'` (if any).
                        nested.splice(1, 1);
                    }
                    if (!braceInterpolator) {
                        // We are not using `{` and `}`, so wrap the interpolated tokens instead.
                        open = this.makeToken('(', '(', offsetInChunk, 0);
                        close = this.makeToken(')', ')', offsetInChunk + index, 0);
                        nested = [open, ...nested, close];
                    }
                    // Push a fake `'TOKENS'` token, which will get turned into real tokens later.
                    tokens.push(['TOKENS', nested]);
                    str = str.slice(index);
                    offsetInChunk += index;
                }
                if (str.slice(0, closingDelimiter.length) !== closingDelimiter) {
                    this.error(`missing ${closingDelimiter}`, {
                        length: delimiter.length
                    });
                }
                [firstToken] = tokens, [lastToken] = slice.call(tokens, -1);
                firstToken[2].first_column -= delimiter.length;
                if (lastToken[1].substr(-1) === '\n') {
                    lastToken[2].last_line += 1;
                    lastToken[2].last_column = closingDelimiter.length - 1;
                }
                else {
                    lastToken[2].last_column += closingDelimiter.length;
                }
                if (lastToken[1].length === 0) {
                    lastToken[2].last_column -= 1;
                }
                return {
                    tokens,
                    index: offsetInChunk + closingDelimiter.length
                };
            }
            // Merge the array `tokens` of the fake token types `'TOKENS'` and `'NEOSTRING'`
            // (as returned by `matchWithInterpolations`) into the token stream. The value
            // of `'NEOSTRING'`s are converted using `fn` and turned into strings using
            // `options` first.
            mergeInterpolationTokens(tokens, options, fn) {
                var converted, firstEmptyStringIndex, firstIndex, i, j, k, lastToken, len, len1, locationToken, lparen, placeholderToken, plusToken, rparen, tag, token, tokensToPush, val, value;
                if (tokens.length > 1) {
                    lparen = this.token('STRING_START', '(', 0, 0);
                }
                firstIndex = this.tokens.length;
                for (i = j = 0, len = tokens.length; j < len; i = ++j) {
                    token = tokens[i];
                    [tag, value] = token;
                    switch (tag) {
                        case 'TOKENS':
                            if (value.length === 2) {
                                if (!(value[0].comments || value[1].comments)) {
                                    // Optimize out empty interpolations (an empty pair of parentheses).
                                    continue;
                                }
                                // There are comments (and nothing else) in this interpolation.
                                if (this.csxDepth === 0) {
                                    // This is an interpolated string, not a CSX tag; and for whatever
                                    // reason `` `a${/*test*/}b` `` is invalid JS. So compile to
                                    // `` `a${/*test*/''}b` `` instead.
                                    placeholderToken = this.makeToken('STRING', "''");
                                }
                                else {
                                    placeholderToken = this.makeToken('JS', '');
                                }
                                // Use the same location data as the first parenthesis.
                                placeholderToken[2] = value[0][2];
                                for (k = 0, len1 = value.length; k < len1; k++) {
                                    val = value[k];
                                    if (!val.comments) {
                                        continue;
                                    }
                                    if (placeholderToken.comments == null) {
                                        placeholderToken.comments = [];
                                    }
                                    placeholderToken.comments.push(...val.comments);
                                }
                                value.splice(1, 0, placeholderToken);
                            }
                            // Push all the tokens in the fake `'TOKENS'` token. These already have
                            // sane location data.
                            locationToken = value[0];
                            tokensToPush = value;
                            break;
                        case 'NEOSTRING':
                            // Convert `'NEOSTRING'` into `'STRING'`.
                            converted = fn.call(this, token[1], i);
                            // Optimize out empty strings. We ensure that the tokens stream always
                            // starts with a string token, though, to make sure that the result
                            // really is a string.
                            if (converted.length === 0) {
                                if (i === 0) {
                                    firstEmptyStringIndex = this.tokens.length;
                                }
                                else {
                                    continue;
                                }
                            }
                            // However, there is one case where we can optimize away a starting
                            // empty string.
                            if (i === 2 && (firstEmptyStringIndex != null)) {
                                this.tokens.splice(firstEmptyStringIndex, 2); // Remove empty string and the plus.
                            }
                            token[0] = 'STRING';
                            token[1] = this.makeDelimitedLiteral(converted, options);
                            locationToken = token;
                            tokensToPush = [token];
                    }
                    if (this.tokens.length > firstIndex) {
                        // Create a 0-length "+" token.
                        plusToken = this.token('+', '+');
                        plusToken[2] = {
                            first_line: locationToken[2].first_line,
                            first_column: locationToken[2].first_column,
                            last_line: locationToken[2].first_line,
                            last_column: locationToken[2].first_column
                        };
                    }
                    this.tokens.push(...tokensToPush);
                }
                if (lparen) {
                    [lastToken] = slice.call(tokens, -1);
                    lparen.origin = [
                        'STRING',
                        null,
                        {
                            first_line: lparen[2].first_line,
                            first_column: lparen[2].first_column,
                            last_line: lastToken[2].last_line,
                            last_column: lastToken[2].last_column
                        }
                    ];
                    lparen[2] = lparen.origin[2];
                    rparen = this.token('STRING_END', ')');
                    return rparen[2] = {
                        first_line: lastToken[2].last_line,
                        first_column: lastToken[2].last_column,
                        last_line: lastToken[2].last_line,
                        last_column: lastToken[2].last_column
                    };
                }
            }
            // Pairs up a closing token, ensuring that all listed pairs of tokens are
            // correctly balanced throughout the course of the token stream.
            pair(tag) {
                var lastIndent, prev, ref, ref1, wanted;
                ref = this.ends, [prev] = slice.call(ref, -1);
                if (tag !== (wanted = prev != null ? prev.tag : void 0)) {
                    if ('OUTDENT' !== wanted) {
                        this.error(`unmatched ${tag}`);
                    }
                    // Auto-close `INDENT` to support syntax like this:
                    //     el.click((event) ->
                    //       el.hide())
                    ref1 = this.indents, [lastIndent] = slice.call(ref1, -1);
                    this.outdentToken(lastIndent, true);
                    return this.pair(tag);
                }
                return this.ends.pop();
            }
            // Helpers
            // -------
            // Returns the line and column number from an offset into the current chunk.
            // `offset` is a number of characters into `@chunk`.
            getLineAndColumnFromChunk(offset) {
                var column, lastLine, lineCount, ref, string;
                if (offset === 0) {
                    return [this.chunkLine, this.chunkColumn];
                }
                if (offset >= this.chunk.length) {
                    string = this.chunk;
                }
                else {
                    string = this.chunk.slice(0, +(offset - 1) + 1 || 9e9);
                }
                lineCount = count(string, '\n');
                column = this.chunkColumn;
                if (lineCount > 0) {
                    ref = string.split('\n'), [lastLine] = slice.call(ref, -1);
                    column = lastLine.length;
                }
                else {
                    column += string.length;
                }
                return [this.chunkLine + lineCount, column];
            }
            // Same as `token`, except this just returns the token without adding it
            // to the results.
            makeToken(tag, value, offsetInChunk = 0, length = value.length) {
                var lastCharacter, locationData, token;
                locationData = {};
                [locationData.first_line, locationData.first_column] = this.getLineAndColumnFromChunk(offsetInChunk);
                // Use length - 1 for the final offset - we're supplying the last_line and the last_column,
                // so if last_column == first_column, then we're looking at a character of length 1.
                lastCharacter = length > 0 ? length - 1 : 0;
                [locationData.last_line, locationData.last_column] = this.getLineAndColumnFromChunk(offsetInChunk + lastCharacter);
                token = [tag, value, locationData];
                return token;
            }
            // Add a token to the results.
            // `offset` is the offset into the current `@chunk` where the token starts.
            // `length` is the length of the token in the `@chunk`, after the offset.  If
            // not specified, the length of `value` will be used.
            // Returns the new token.
            token(tag, value, offsetInChunk, length, origin) {
                var token;
                token = this.makeToken(tag, value, offsetInChunk, length);
                if (origin) {
                    token.origin = origin;
                }
                this.tokens.push(token);
                return token;
            }
            // Peek at the last tag in the token stream.
            tag() {
                var ref, token;
                ref = this.tokens, [token] = slice.call(ref, -1);
                return token != null ? token[0] : void 0;
            }
            // Peek at the last value in the token stream.
            value(useOrigin = false) {
                var ref, ref1, token;
                ref = this.tokens, [token] = slice.call(ref, -1);
                if (useOrigin && ((token != null ? token.origin : void 0) != null)) {
                    return (ref1 = token.origin) != null ? ref1[1] : void 0;
                }
                else {
                    return token != null ? token[1] : void 0;
                }
            }
            // Get the previous token in the token stream.
            prev() {
                return this.tokens[this.tokens.length - 1];
            }
            // Are we in the midst of an unfinished expression?
            unfinished() {
                var ref;
                return LINE_CONTINUER.test(this.chunk) || (ref = this.tag(), indexOf.call(UNFINISHED, ref) >= 0);
            }
            formatString(str, options) {
                return this.replaceUnicodeCodePointEscapes(str.replace(STRING_OMIT, '$1'), options);
            }
            formatHeregex(str, options) {
                return this.formatRegex(str.replace(HEREGEX_OMIT, '$1$2'), merge(options, {
                    delimiter: '///'
                }));
            }
            formatRegex(str, options) {
                return this.replaceUnicodeCodePointEscapes(str, options);
            }
            unicodeCodePointToUnicodeEscapes(codePoint) {
                var high, low, toUnicodeEscape;
                toUnicodeEscape = function (val) {
                    var str;
                    str = val.toString(16);
                    return `\\u${repeat('0', 4 - str.length)}${str}`;
                };
                if (codePoint < 0x10000) {
                    return toUnicodeEscape(codePoint);
                }
                // surrogate pair
                high = Math.floor((codePoint - 0x10000) / 0x400) + 0xD800;
                low = (codePoint - 0x10000) % 0x400 + 0xDC00;
                return `${toUnicodeEscape(high)}${toUnicodeEscape(low)}`;
            }
            // Replace `\u{...}` with `\uxxxx[\uxxxx]` in regexes without `u` flag
            replaceUnicodeCodePointEscapes(str, options) {
                var shouldReplace;
                shouldReplace = (options.flags != null) && indexOf.call(options.flags, 'u') < 0;
                return str.replace(UNICODE_CODE_POINT_ESCAPE, (match, escapedBackslash, codePointHex, offset) => {
                    var codePointDecimal;
                    if (escapedBackslash) {
                        return escapedBackslash;
                    }
                    codePointDecimal = parseInt(codePointHex, 16);
                    if (codePointDecimal > 0x10ffff) {
                        this.error("unicode code point escapes greater than \\u{10ffff} are not allowed", {
                            offset: offset + options.delimiter.length,
                            length: codePointHex.length + 4
                        });
                    }
                    if (!shouldReplace) {
                        return match;
                    }
                    return this.unicodeCodePointToUnicodeEscapes(codePointDecimal);
                });
            }
            // Validates escapes in strings and regexes.
            validateEscapes(str, options = {}) {
                var before, hex, invalidEscape, invalidEscapeRegex, match, message, octal, ref, unicode, unicodeCodePoint;
                invalidEscapeRegex = options.isRegex ? REGEX_INVALID_ESCAPE : STRING_INVALID_ESCAPE;
                match = invalidEscapeRegex.exec(str);
                if (!match) {
                    return;
                }
                match[0], before = match[1], octal = match[2], hex = match[3], unicodeCodePoint = match[4], unicode = match[5];
                message = octal ? "octal escape sequences are not allowed" : "invalid escape sequence";
                invalidEscape = `\\${octal || hex || unicodeCodePoint || unicode}`;
                return this.error(`${message} ${invalidEscape}`, {
                    offset: ((ref = options.offsetInChunk) != null ? ref : 0) + match.index + before.length,
                    length: invalidEscape.length
                });
            }
            // Constructs a string or regex by escaping certain characters.
            makeDelimitedLiteral(body, options = {}) {
                var regex;
                if (body === '' && options.delimiter === '/') {
                    body = '(?:)';
                }
                regex = RegExp(`(\\\\\\\\)|(\\\\0(?=[1-7]))|\\\\?(${options.delimiter // Escaped backslash.
                // Null character mistaken as octal escape.
                // (Possibly escaped) delimiter.
                // (Possibly escaped) newlines.
                // Other escapes.
                })|\\\\?(?:(\\n)|(\\r)|(\\u2028)|(\\u2029))|(\\\\.)`, "g");
                body = body.replace(regex, function (match, backslash, nul, delimiter, lf, cr, ls, ps, other) {
                    switch (false) {
                        // Ignore escaped backslashes.
                        case !backslash:
                            if (options.double) {
                                return backslash + backslash;
                            }
                            else {
                                return backslash;
                            }
                        case !nul:
                            return '\\x00';
                        case !delimiter:
                            return `\\${delimiter}`;
                        case !lf:
                            return '\\n';
                        case !cr:
                            return '\\r';
                        case !ls:
                            return '\\u2028';
                        case !ps:
                            return '\\u2029';
                        case !other:
                            if (options.double) {
                                return `\\${other}`;
                            }
                            else {
                                return other;
                            }
                    }
                });
                return `${options.delimiter}${body}${options.delimiter}`;
            }
            suppressSemicolons() {
                var ref, ref1, results;
                results = [];
                while (this.value() === ';') {
                    this.tokens.pop();
                    if (ref = (ref1 = this.prev()) != null ? ref1[0] : void 0, indexOf.call(['=', ...UNFINISHED], ref) >= 0) {
                        results.push(this.error('unexpected ;'));
                    }
                    else {
                        results.push(void 0);
                    }
                }
                return results;
            }
            // Throws an error at either a given offset from the current chunk or at the
            // location of a token (`token[2]`).
            error(message, options = {}) {
                var first_column, first_line, location, ref, ref1;
                location = 'first_line' in options ? options : ([first_line, first_column] = this.getLineAndColumnFromChunk((ref = options.offset) != null ? ref : 0), {
                    first_line,
                    first_column,
                    last_column: first_column + ((ref1 = options.length) != null ? ref1 : 1) - 1
                });
                return throwSyntaxError(message, location);
            }
        };
        // Helper functions
        // ----------------
        isUnassignable = function (name, displayName = name) {
            switch (false) {
                case indexOf.call([...JS_KEYWORDS, ...COFFEE_KEYWORDS], name) < 0:
                    return `keyword '${displayName}' can't be assigned`;
                case indexOf.call(STRICT_PROSCRIBED, name) < 0:
                    return `'${displayName}' can't be assigned`;
                case indexOf.call(RESERVED, name) < 0:
                    return `reserved word '${displayName}' can't be assigned`;
                default:
                    return false;
            }
        };
        exports.isUnassignable = isUnassignable;
        // `from` isn’t a CoffeeScript keyword, but it behaves like one in `import` and
        // `export` statements (handled above) and in the declaration line of a `for`
        // loop. Try to detect when `from` is a variable identifier and when it is this
        // “sometimes” keyword.
        isForFrom = function (prev) {
            var ref;
            if (prev[0] === 'IDENTIFIER') {
                // `for i from from`, `for from from iterable`
                if (prev[1] === 'from') {
                    prev[1][0] = 'IDENTIFIER';
                    true;
                }
                // `for i from iterable`
                return true;
                // `for from…`
            }
            else if (prev[0] === 'FOR') {
                return false;
                // `for {from}…`, `for [from]…`, `for {a, from}…`, `for {a: from}…`
            }
            else if ((ref = prev[1]) === '{' || ref === '[' || ref === ',' || ref === ':') {
                return false;
            }
            else {
                return true;
            }
        };
        // Constants
        // ---------
        // Keywords that CoffeeScript shares in common with JavaScript.
        JS_KEYWORDS = ['true', 'false', 'null', 'this', 'new', 'delete', 'typeof', 'in', 'instanceof', 'return', 'throw', 'break', 'continue', 'debugger', 'yield', 'await', 'if', 'else', 'switch', 'for', 'while', 'do', 'try', 'catch', 'finally', 'class', 'extends', 'super', 'import', 'export', 'default'];
        // CoffeeScript-only keywords.
        COFFEE_KEYWORDS = ['undefined', 'Infinity', 'NaN', 'then', 'unless', 'until', 'loop', 'of', 'by', 'when'];
        COFFEE_ALIAS_MAP = {
            and: '&&',
            or: '||',
            is: '==',
            isnt: '!=',
            not: '!',
            yes: 'true',
            no: 'false',
            on: 'true',
            off: 'false'
        };
        COFFEE_ALIASES = (function () {
            var results;
            results = [];
            for (key in COFFEE_ALIAS_MAP) {
                results.push(key);
            }
            return results;
        })();
        COFFEE_KEYWORDS = COFFEE_KEYWORDS.concat(COFFEE_ALIASES);
        // The list of keywords that are reserved by JavaScript, but not used, or are
        // used by CoffeeScript internally. We throw an error when these are encountered,
        // to avoid having a JavaScript error at runtime.
        RESERVED = ['case', 'function', 'var', 'void', 'with', 'const', 'let', 'enum', 'native', 'implements', 'interface', 'package', 'private', 'protected', 'public', 'static'];
        STRICT_PROSCRIBED = ['arguments', 'eval'];
        // The superset of both JavaScript keywords and reserved words, none of which may
        // be used as identifiers or properties.
        exports.JS_FORBIDDEN = JS_KEYWORDS.concat(RESERVED).concat(STRICT_PROSCRIBED);
        // The character code of the nasty Microsoft madness otherwise known as the BOM.
        BOM = 65279;
        // Token matching regexes.
        IDENTIFIER = /^(?!\d)((?:(?!\s)[$\w\x7f-\uffff])+)([^\n\S]*:(?!:))?/; // Is this a property name?
        CSX_IDENTIFIER = /^(?![\d<])((?:(?!\s)[\.\-$\w\x7f-\uffff])+)/; // Must not start with `<`.
        // Like `IDENTIFIER`, but includes `-`s and `.`s.
        // Fragment: <></>
        CSX_FRAGMENT_IDENTIFIER = /^()>/; // Ends immediately with `>`.
        CSX_ATTRIBUTE = /^(?!\d)((?:(?!\s)[\-$\w\x7f-\uffff])+)([^\S]*=(?!=))?/; // Like `IDENTIFIER`, but includes `-`s.
        // Is this an attribute with a value?
        NUMBER = /^0b[01]+|^0o[0-7]+|^0x[\da-f]+|^\d*\.?\d+(?:e[+-]?\d+)?/i; // binary
        // octal
        // hex
        // decimal
        OPERATOR = /^(?:[-=]>|[-+*\/%<>&|^!?=]=|>>>=?|([-+:])\1|([&|<>*\/%])\2=?|\?(\.|::)|\.{2,3})/; // function
        // compound assign / compare
        // zero-fill right shift
        // doubles
        // logic / shift / power / floor division / modulo
        // soak access
        // range or splat
        WHITESPACE = /^[^\n\S]+/;
        COMMENT = /^\s*###([^#][\s\S]*?)(?:###[^\n\S]*|###$)|^(?:\s*#(?!##[^#]).*)+/;
        CODE = /^[-=]>/;
        MULTI_DENT = /^(?:\n[^\n\S]*)+/;
        JSTOKEN = /^`(?!``)((?:[^`\\]|\\[\s\S])*)`/;
        HERE_JSTOKEN = /^```((?:[^`\\]|\\[\s\S]|`(?!``))*)```/;
        // String-matching-regexes.
        STRING_START = /^(?:'''|"""|'|")/;
        STRING_SINGLE = /^(?:[^\\']|\\[\s\S])*/;
        STRING_DOUBLE = /^(?:[^\\"#]|\\[\s\S]|\#(?!\{))*/;
        HEREDOC_SINGLE = /^(?:[^\\']|\\[\s\S]|'(?!''))*/;
        HEREDOC_DOUBLE = /^(?:[^\\"#]|\\[\s\S]|"(?!"")|\#(?!\{))*/;
        INSIDE_CSX = /^(?:[^\{<])*/; // Start of CoffeeScript interpolation. // Similar to `HEREDOC_DOUBLE` but there is no escaping.
        // Maybe CSX tag (`<` not allowed even if bare).
        CSX_INTERPOLATION = /^(?:\{|<(?!\/))/; // CoffeeScript interpolation.
        // CSX opening tag.
        STRING_OMIT = /((?:\\\\)+)|\\[^\S\n]*\n\s*/g; // Consume (and preserve) an even number of backslashes.
        // Remove escaped newlines.
        SIMPLE_STRING_OMIT = /\s*\n\s*/g;
        HEREDOC_INDENT = /\n+([^\n\S]*)(?=\S)/g;
        // Regex-matching-regexes.
        REGEX = /^\/(?!\/)((?:[^[\/\n\\]|\\[^\n]|\[(?:\\[^\n]|[^\]\n\\])*\])*)(\/)?/; // Every other thing.
        // Anything but newlines escaped.
        // Character class.
        REGEX_FLAGS = /^\w*/;
        VALID_FLAGS = /^(?!.*(.).*\1)[gimsuy]*$/;
        // Match any character, except those that need special handling below.
        // Match `\` followed by any character.
        // Match any `/` except `///`.
        // Match `#` which is not part of interpolation, e.g. `#{}`.
        // Comments consume everything until the end of the line, including `///`.
        HEREGEX = /^(?:[^\\\/#\s]|\\[\s\S]|\/(?!\/\/)|\#(?!\{)|\s+(?:#(?!\{).*)?)*/;
        HEREGEX_OMIT = /((?:\\\\)+)|\\(\s)|\s+(?:#.*)?/g; // Consume (and preserve) an even number of backslashes.
        // Preserve escaped whitespace.
        // Remove whitespace and comments.
        REGEX_ILLEGAL = /^(\/|\/{3}\s*)(\*)/;
        POSSIBLY_DIVISION = /^\/=?\s/;
        // Other regexes.
        HERECOMMENT_ILLEGAL = /\*\//;
        LINE_CONTINUER = /^\s*(?:,|\??\.(?![.\d])|::)/;
        STRING_INVALID_ESCAPE = /((?:^|[^\\])(?:\\\\)*)\\(?:(0[0-7]|[1-7])|(x(?![\da-fA-F]{2}).{0,2})|(u\{(?![\da-fA-F]{1,}\})[^}]*\}?)|(u(?!\{|[\da-fA-F]{4}).{0,4}))/; // Make sure the escape isn’t escaped.
        // octal escape
        // hex escape
        // unicode code point escape
        // unicode escape
        REGEX_INVALID_ESCAPE = /((?:^|[^\\])(?:\\\\)*)\\(?:(0[0-7])|(x(?![\da-fA-F]{2}).{0,2})|(u\{(?![\da-fA-F]{1,}\})[^}]*\}?)|(u(?!\{|[\da-fA-F]{4}).{0,4}))/; // Make sure the escape isn’t escaped.
        // octal escape
        // hex escape
        // unicode code point escape
        // unicode escape
        UNICODE_CODE_POINT_ESCAPE = /(\\\\)|\\u\{([\da-fA-F]+)\}/g; // Make sure the escape isn’t escaped.
        LEADING_BLANK_LINE = /^[^\n\S]*\n/;
        TRAILING_BLANK_LINE = /\n[^\n\S]*$/;
        TRAILING_SPACES = /\s+$/;
        // Compound assignment tokens.
        COMPOUND_ASSIGN = ['-=', '+=', '/=', '*=', '%=', '||=', '&&=', '?=', '<<=', '>>=', '>>>=', '&=', '^=', '|=', '**=', '//=', '%%='];
        // Unary tokens.
        UNARY = ['NEW', 'TYPEOF', 'DELETE', 'DO'];
        UNARY_MATH = ['!', '~'];
        // Bit-shifting tokens.
        SHIFT = ['<<', '>>', '>>>'];
        // Comparison tokens.
        COMPARE = ['==', '!=', '<', '>', '<=', '>='];
        // Mathematical tokens.
        MATH = ['*', '/', '%', '//', '%%'];
        // Relational tokens that are negatable with `not` prefix.
        RELATION = ['IN', 'OF', 'INSTANCEOF'];
        // Boolean tokens.
        BOOL = ['TRUE', 'FALSE'];
        // Tokens which could legitimately be invoked or indexed. An opening
        // parentheses or bracket following these tokens will be recorded as the start
        // of a function invocation or indexing operation.
        CALLABLE = ['IDENTIFIER', 'PROPERTY', ')', ']', '?', '@', 'THIS', 'SUPER'];
        INDEXABLE = CALLABLE.concat(['NUMBER', 'INFINITY', 'NAN', 'STRING', 'STRING_END', 'REGEX', 'REGEX_END', 'BOOL', 'NULL', 'UNDEFINED', '}', '::']);
        // Tokens which can be the left-hand side of a less-than comparison, i.e. `a<b`.
        COMPARABLE_LEFT_SIDE = ['IDENTIFIER', ')', ']', 'NUMBER'];
        // Tokens which a regular expression will never immediately follow (except spaced
        // CALLABLEs in some cases), but which a division operator can.
        // See: http://www-archive.mozilla.org/js/language/js20-2002-04/rationale/syntax.html#regular-expressions
        NOT_REGEX = INDEXABLE.concat(['++', '--']);
        // Tokens that, when immediately preceding a `WHEN`, indicate that the `WHEN`
        // occurs at the start of a line. We disambiguate these from trailing whens to
        // avoid an ambiguity in the grammar.
        LINE_BREAK = ['INDENT', 'OUTDENT', 'TERMINATOR'];
        // Additional indent in front of these is ignored.
        INDENTABLE_CLOSERS = [')', '}', ']'];
        // Tokens that, when appearing at the end of a line, suppress a following TERMINATOR/INDENT token
        UNFINISHED = ['\\', '.', '?.', '?::', 'UNARY', 'MATH', 'UNARY_MATH', '+', '-', '**', 'SHIFT', 'RELATION', 'COMPARE', '&', '^', '|', '&&', '||', 'BIN?', 'EXTENDS'];
    }).call(this);
}
,
/* coffeescript/lib/coffeescript/nodes */ function _(require, module, exports) {
    // Generated by CoffeeScript 2.3.0
    (function () {
        // `nodes.coffee` contains all of the node classes for the syntax tree. Most
        // nodes are created as the result of actions in the [grammar](grammar.html),
        // but some are created by other nodes as a method of code generation. To convert
        // the syntax tree into a string of JavaScript code, call `compile()` on the root.
        var Access, Arr, Assign, AwaitReturn, Base, Block, BooleanLiteral, CSXTag, Call, Class, Code, CodeFragment, ComputedPropertyName, Elision, ExecutableClassBody, Existence, Expansion, ExportAllDeclaration, ExportDeclaration, ExportDefaultDeclaration, ExportNamedDeclaration, ExportSpecifier, ExportSpecifierList, Extends, For, FuncGlyph, HereComment, HoistTarget, IdentifierLiteral, If, ImportClause, ImportDeclaration, ImportDefaultSpecifier, ImportNamespaceSpecifier, ImportSpecifier, ImportSpecifierList, In, Index, InfinityLiteral, JS_FORBIDDEN, LEVEL_ACCESS, LEVEL_COND, LEVEL_LIST, LEVEL_OP, LEVEL_PAREN, LEVEL_TOP, LineComment, Literal, ModuleDeclaration, ModuleSpecifier, ModuleSpecifierList, NEGATE, NO, NaNLiteral, NullLiteral, NumberLiteral, Obj, Op, Param, Parens, PassthroughLiteral, PropertyName, Range, RegexLiteral, RegexWithInterpolations, Return, SIMPLENUM, Scope, Slice, Splat, StatementLiteral, StringLiteral, StringWithInterpolations, Super, SuperCall, Switch, TAB, THIS, TaggedTemplateCall, ThisLiteral, Throw, Try, UTILITIES, UndefinedLiteral, Value, While, YES, YieldReturn, addDataToNode, attachCommentsToNode, compact, del, ends, extend, flatten, fragmentsToText, hasLineComments, indentInitial, isLiteralArguments, isLiteralThis, isUnassignable, locationDataToString, merge, moveComments, multident, shouldCacheOrIsAssignable, some, starts, throwSyntaxError, unfoldSoak, unshiftAfterComments, utility, indexOf = [].indexOf, splice = [].splice, slice1 = [].slice;
        Error.stackTraceLimit = 2e308;
        ({ Scope } = require(83) /* ./scope */);
        ({ isUnassignable, JS_FORBIDDEN } = require(78) /* ./lexer */);
        // Import the helpers we plan to use.
        ({ compact, flatten, extend, merge, del, starts, ends, some, addDataToNode, attachCommentsToNode, locationDataToString, throwSyntaxError } = require(76) /* ./helpers */);
        // Functions required by parser.
        exports.extend = extend;
        exports.addDataToNode = addDataToNode;
        // Constant functions for nodes that don’t need customization.
        YES = function () {
            return true;
        };
        NO = function () {
            return false;
        };
        THIS = function () {
            return this;
        };
        NEGATE = function () {
            this.negated = !this.negated;
            return this;
        };
        //### CodeFragment
        // The various nodes defined below all compile to a collection of **CodeFragment** objects.
        // A CodeFragments is a block of generated code, and the location in the source file where the code
        // came from. CodeFragments can be assembled together into working code just by catting together
        // all the CodeFragments' `code` snippets, in order.
        exports.CodeFragment = CodeFragment = class CodeFragment {
            constructor(parent, code) {
                var ref1;
                this.code = `${code}`;
                this.type = (parent != null ? (ref1 = parent.constructor) != null ? ref1.name : void 0 : void 0) || 'unknown';
                this.locationData = parent != null ? parent.locationData : void 0;
                this.comments = parent != null ? parent.comments : void 0;
            }
            toString() {
                // This is only intended for debugging.
                return `${this.code}${(this.locationData ? ": " + locationDataToString(this.locationData) : '')}`;
            }
        };
        // Convert an array of CodeFragments into a string.
        fragmentsToText = function (fragments) {
            var fragment;
            return ((function () {
                var j, len1, results;
                results = [];
                for (j = 0, len1 = fragments.length; j < len1; j++) {
                    fragment = fragments[j];
                    results.push(fragment.code);
                }
                return results;
            })()).join('');
        };
        //### Base
        // The **Base** is the abstract base class for all nodes in the syntax tree.
        // Each subclass implements the `compileNode` method, which performs the
        // code generation for that node. To compile a node to JavaScript,
        // call `compile` on it, which wraps `compileNode` in some generic extra smarts,
        // to know when the generated code needs to be wrapped up in a closure.
        // An options hash is passed and cloned throughout, containing information about
        // the environment from higher in the tree (such as if a returned value is
        // being requested by the surrounding function), information about the current
        // scope, and indentation level.
        exports.Base = Base = (function () {
            class Base {
                compile(o, lvl) {
                    return fragmentsToText(this.compileToFragments(o, lvl));
                }
                // Occasionally a node is compiled multiple times, for example to get the name
                // of a variable to add to scope tracking. When we know that a “premature”
                // compilation won’t result in comments being output, set those comments aside
                // so that they’re preserved for a later `compile` call that will result in
                // the comments being included in the output.
                compileWithoutComments(o, lvl, method = 'compile') {
                    var fragments, unwrapped;
                    if (this.comments) {
                        this.ignoreTheseCommentsTemporarily = this.comments;
                        delete this.comments;
                    }
                    unwrapped = this.unwrapAll();
                    if (unwrapped.comments) {
                        unwrapped.ignoreTheseCommentsTemporarily = unwrapped.comments;
                        delete unwrapped.comments;
                    }
                    fragments = this[method](o, lvl);
                    if (this.ignoreTheseCommentsTemporarily) {
                        this.comments = this.ignoreTheseCommentsTemporarily;
                        delete this.ignoreTheseCommentsTemporarily;
                    }
                    if (unwrapped.ignoreTheseCommentsTemporarily) {
                        unwrapped.comments = unwrapped.ignoreTheseCommentsTemporarily;
                        delete unwrapped.ignoreTheseCommentsTemporarily;
                    }
                    return fragments;
                }
                compileNodeWithoutComments(o, lvl) {
                    return this.compileWithoutComments(o, lvl, 'compileNode');
                }
                // Common logic for determining whether to wrap this node in a closure before
                // compiling it, or to compile directly. We need to wrap if this node is a
                // *statement*, and it's not a *pureStatement*, and we're not at
                // the top level of a block (which would be unnecessary), and we haven't
                // already been asked to return the result (because statements know how to
                // return results).
                compileToFragments(o, lvl) {
                    var fragments, node;
                    o = extend({}, o);
                    if (lvl) {
                        o.level = lvl;
                    }
                    node = this.unfoldSoak(o) || this;
                    node.tab = o.indent;
                    fragments = o.level === LEVEL_TOP || !node.isStatement(o) ? node.compileNode(o) : node.compileClosure(o);
                    this.compileCommentFragments(o, node, fragments);
                    return fragments;
                }
                compileToFragmentsWithoutComments(o, lvl) {
                    return this.compileWithoutComments(o, lvl, 'compileToFragments');
                }
                // Statements converted into expressions via closure-wrapping share a scope
                // object with their parent closure, to preserve the expected lexical scope.
                compileClosure(o) {
                    var args, argumentsNode, func, jumpNode, meth, parts, ref1, ref2;
                    if (jumpNode = this.jumps()) {
                        jumpNode.error('cannot use a pure statement in an expression');
                    }
                    o.sharedScope = true;
                    func = new Code([], Block.wrap([this]));
                    args = [];
                    if (this.contains((function (node) {
                        return node instanceof SuperCall;
                    }))) {
                        func.bound = true;
                    }
                    else if ((argumentsNode = this.contains(isLiteralArguments)) || this.contains(isLiteralThis)) {
                        args = [new ThisLiteral];
                        if (argumentsNode) {
                            meth = 'apply';
                            args.push(new IdentifierLiteral('arguments'));
                        }
                        else {
                            meth = 'call';
                        }
                        func = new Value(func, [new Access(new PropertyName(meth))]);
                    }
                    parts = (new Call(func, args)).compileNode(o);
                    switch (false) {
                        case !(func.isGenerator || ((ref1 = func.base) != null ? ref1.isGenerator : void 0)):
                            parts.unshift(this.makeCode("(yield* "));
                            parts.push(this.makeCode(")"));
                            break;
                        case !(func.isAsync || ((ref2 = func.base) != null ? ref2.isAsync : void 0)):
                            parts.unshift(this.makeCode("(await "));
                            parts.push(this.makeCode(")"));
                    }
                    return parts;
                }
                compileCommentFragments(o, node, fragments) {
                    var base1, base2, comment, commentFragment, j, len1, ref1, unshiftCommentFragment;
                    if (!node.comments) {
                        return fragments;
                    }
                    // This is where comments, that are attached to nodes as a `comments`
                    // property, become `CodeFragment`s. “Inline block comments,” e.g.
                    // `/* */`-delimited comments that are interspersed within code on a line,
                    // are added to the current `fragments` stream. All other fragments are
                    // attached as properties to the nearest preceding or following fragment,
                    // to remain stowaways until they get properly output in `compileComments`
                    // later on.
                    unshiftCommentFragment = function (commentFragment) {
                        var precedingFragment;
                        if (commentFragment.unshift) {
                            // Find the first non-comment fragment and insert `commentFragment`
                            // before it.
                            return unshiftAfterComments(fragments, commentFragment);
                        }
                        else {
                            if (fragments.length !== 0) {
                                precedingFragment = fragments[fragments.length - 1];
                                if (commentFragment.newLine && precedingFragment.code !== '' && !/\n\s*$/.test(precedingFragment.code)) {
                                    commentFragment.code = `\n${commentFragment.code}`;
                                }
                            }
                            return fragments.push(commentFragment);
                        }
                    };
                    ref1 = node.comments;
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        comment = ref1[j];
                        if (!(indexOf.call(this.compiledComments, comment) < 0)) {
                            continue;
                        }
                        this.compiledComments.push(comment); // Don’t output this comment twice.
                        // For block/here comments, denoted by `###`, that are inline comments
                        // like `1 + ### comment ### 2`, create fragments and insert them into
                        // the fragments array.
                        // Otherwise attach comment fragments to their closest fragment for now,
                        // so they can be inserted into the output later after all the newlines
                        // have been added.
                        if (comment.here) { // Block comment, delimited by `###`.
                            commentFragment = new HereComment(comment).compileNode(o); // Line comment, delimited by `#`.
                        }
                        else {
                            commentFragment = new LineComment(comment).compileNode(o);
                        }
                        if ((commentFragment.isHereComment && !commentFragment.newLine) || node.includeCommentFragments()) {
                            // Inline block comments, like `1 + /* comment */ 2`, or a node whose
                            // `compileToFragments` method has logic for outputting comments.
                            unshiftCommentFragment(commentFragment);
                        }
                        else {
                            if (fragments.length === 0) {
                                fragments.push(this.makeCode(''));
                            }
                            if (commentFragment.unshift) {
                                if ((base1 = fragments[0]).precedingComments == null) {
                                    base1.precedingComments = [];
                                }
                                fragments[0].precedingComments.push(commentFragment);
                            }
                            else {
                                if ((base2 = fragments[fragments.length - 1]).followingComments == null) {
                                    base2.followingComments = [];
                                }
                                fragments[fragments.length - 1].followingComments.push(commentFragment);
                            }
                        }
                    }
                    return fragments;
                }
                // If the code generation wishes to use the result of a complex expression
                // in multiple places, ensure that the expression is only ever evaluated once,
                // by assigning it to a temporary variable. Pass a level to precompile.
                // If `level` is passed, then returns `[val, ref]`, where `val` is the compiled value, and `ref`
                // is the compiled reference. If `level` is not passed, this returns `[val, ref]` where
                // the two values are raw nodes which have not been compiled.
                cache(o, level, shouldCache) {
                    var complex, ref, sub;
                    complex = shouldCache != null ? shouldCache(this) : this.shouldCache();
                    if (complex) {
                        ref = new IdentifierLiteral(o.scope.freeVariable('ref'));
                        sub = new Assign(ref, this);
                        if (level) {
                            return [sub.compileToFragments(o, level), [this.makeCode(ref.value)]];
                        }
                        else {
                            return [sub, ref];
                        }
                    }
                    else {
                        ref = level ? this.compileToFragments(o, level) : this;
                        return [ref, ref];
                    }
                }
                // Occasionally it may be useful to make an expression behave as if it was 'hoisted', whereby the
                // result of the expression is available before its location in the source, but the expression's
                // variable scope corresponds the source position. This is used extensively to deal with executable
                // class bodies in classes.
                // Calling this method mutates the node, proxying the `compileNode` and `compileToFragments`
                // methods to store their result for later replacing the `target` node, which is returned by the
                // call.
                hoist() {
                    var compileNode, compileToFragments, target;
                    this.hoisted = true;
                    target = new HoistTarget(this);
                    compileNode = this.compileNode;
                    compileToFragments = this.compileToFragments;
                    this.compileNode = function (o) {
                        return target.update(compileNode, o);
                    };
                    this.compileToFragments = function (o) {
                        return target.update(compileToFragments, o);
                    };
                    return target;
                }
                cacheToCodeFragments(cacheValues) {
                    return [fragmentsToText(cacheValues[0]), fragmentsToText(cacheValues[1])];
                }
                // Construct a node that returns the current node's result.
                // Note that this is overridden for smarter behavior for
                // many statement nodes (e.g. If, For)...
                makeReturn(res) {
                    var me;
                    me = this.unwrapAll();
                    if (res) {
                        return new Call(new Literal(`${res}.push`), [me]);
                    }
                    else {
                        return new Return(me);
                    }
                }
                // Does this node, or any of its children, contain a node of a certain kind?
                // Recursively traverses down the *children* nodes and returns the first one
                // that verifies `pred`. Otherwise return undefined. `contains` does not cross
                // scope boundaries.
                contains(pred) {
                    var node;
                    node = void 0;
                    this.traverseChildren(false, function (n) {
                        if (pred(n)) {
                            node = n;
                            return false;
                        }
                    });
                    return node;
                }
                // Pull out the last node of a node list.
                lastNode(list) {
                    if (list.length === 0) {
                        return null;
                    }
                    else {
                        return list[list.length - 1];
                    }
                }
                // `toString` representation of the node, for inspecting the parse tree.
                // This is what `coffee --nodes` prints out.
                toString(idt = '', name = this.constructor.name) {
                    var tree;
                    tree = '\n' + idt + name;
                    if (this.soak) {
                        tree += '?';
                    }
                    this.eachChild(function (node) {
                        return tree += node.toString(idt + TAB);
                    });
                    return tree;
                }
                // Passes each child to a function, breaking when the function returns `false`.
                eachChild(func) {
                    var attr, child, j, k, len1, len2, ref1, ref2;
                    if (!this.children) {
                        return this;
                    }
                    ref1 = this.children;
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        attr = ref1[j];
                        if (this[attr]) {
                            ref2 = flatten([this[attr]]);
                            for (k = 0, len2 = ref2.length; k < len2; k++) {
                                child = ref2[k];
                                if (func(child) === false) {
                                    return this;
                                }
                            }
                        }
                    }
                    return this;
                }
                traverseChildren(crossScope, func) {
                    return this.eachChild(function (child) {
                        var recur;
                        recur = func(child);
                        if (recur !== false) {
                            return child.traverseChildren(crossScope, func);
                        }
                    });
                }
                // `replaceInContext` will traverse children looking for a node for which `match` returns
                // true. Once found, the matching node will be replaced by the result of calling `replacement`.
                replaceInContext(match, replacement) {
                    var attr, child, children, i, j, k, len1, len2, ref1, ref2;
                    if (!this.children) {
                        return false;
                    }
                    ref1 = this.children;
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        attr = ref1[j];
                        if (children = this[attr]) {
                            if (Array.isArray(children)) {
                                for (i = k = 0, len2 = children.length; k < len2; i = ++k) {
                                    child = children[i];
                                    if (match(child)) {
                                        splice.apply(children, [i, i - i + 1].concat(ref2 = replacement(child, this))), ref2;
                                        return true;
                                    }
                                    else {
                                        if (child.replaceInContext(match, replacement)) {
                                            return true;
                                        }
                                    }
                                }
                            }
                            else if (match(children)) {
                                this[attr] = replacement(children, this);
                                return true;
                            }
                            else {
                                if (children.replaceInContext(match, replacement)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
                invert() {
                    return new Op('!', this);
                }
                unwrapAll() {
                    var node;
                    node = this;
                    while (node !== (node = node.unwrap())) {
                        continue;
                    }
                    return node;
                }
                // For this node and all descendents, set the location data to `locationData`
                // if the location data is not already set.
                updateLocationDataIfMissing(locationData) {
                    if (this.locationData && !this.forceUpdateLocation) {
                        return this;
                    }
                    delete this.forceUpdateLocation;
                    this.locationData = locationData;
                    return this.eachChild(function (child) {
                        return child.updateLocationDataIfMissing(locationData);
                    });
                }
                // Throw a SyntaxError associated with this node’s location.
                error(message) {
                    return throwSyntaxError(message, this.locationData);
                }
                makeCode(code) {
                    return new CodeFragment(this, code);
                }
                wrapInParentheses(fragments) {
                    return [this.makeCode('('), ...fragments, this.makeCode(')')];
                }
                wrapInBraces(fragments) {
                    return [this.makeCode('{'), ...fragments, this.makeCode('}')];
                }
                // `fragmentsList` is an array of arrays of fragments. Each array in fragmentsList will be
                // concatenated together, with `joinStr` added in between each, to produce a final flat array
                // of fragments.
                joinFragmentArrays(fragmentsList, joinStr) {
                    var answer, fragments, i, j, len1;
                    answer = [];
                    for (i = j = 0, len1 = fragmentsList.length; j < len1; i = ++j) {
                        fragments = fragmentsList[i];
                        if (i) {
                            answer.push(this.makeCode(joinStr));
                        }
                        answer = answer.concat(fragments);
                    }
                    return answer;
                }
            }
            ;
            // Default implementations of the common node properties and methods. Nodes
            // will override these with custom logic, if needed.
            // `children` are the properties to recurse into when tree walking. The
            // `children` list *is* the structure of the AST. The `parent` pointer, and
            // the pointer to the `children` are how you can traverse the tree.
            Base.prototype.children = [];
            // `isStatement` has to do with “everything is an expression”. A few things
            // can’t be expressions, such as `break`. Things that `isStatement` returns
            // `true` for are things that can’t be used as expressions. There are some
            // error messages that come from `nodes.coffee` due to statements ending up
            // in expression position.
            Base.prototype.isStatement = NO;
            // Track comments that have been compiled into fragments, to avoid outputting
            // them twice.
            Base.prototype.compiledComments = [];
            // `includeCommentFragments` lets `compileCommentFragments` know whether this node
            // has special awareness of how to handle comments within its output.
            Base.prototype.includeCommentFragments = NO;
            // `jumps` tells you if an expression, or an internal part of an expression
            // has a flow control construct (like `break`, or `continue`, or `return`,
            // or `throw`) that jumps out of the normal flow of control and can’t be
            // used as a value. This is important because things like this make no sense;
            // we have to disallow them.
            Base.prototype.jumps = NO;
            // If `node.shouldCache() is false`, it is safe to use `node` more than once.
            // Otherwise you need to store the value of `node` in a variable and output
            // that variable several times instead. Kind of like this: `5` need not be
            // cached. `returnFive()`, however, could have side effects as a result of
            // evaluating it more than once, and therefore we need to cache it. The
            // parameter is named `shouldCache` rather than `mustCache` because there are
            // also cases where we might not need to cache but where we want to, for
            // example a long expression that may well be idempotent but we want to cache
            // for brevity.
            Base.prototype.shouldCache = YES;
            Base.prototype.isChainable = NO;
            Base.prototype.isAssignable = NO;
            Base.prototype.isNumber = NO;
            Base.prototype.unwrap = THIS;
            Base.prototype.unfoldSoak = NO;
            // Is this node used to assign a certain variable?
            Base.prototype.assigns = NO;
            return Base;
        }).call(this);
        //### HoistTarget
        // A **HoistTargetNode** represents the output location in the node tree for a hoisted node.
        // See Base#hoist.
        exports.HoistTarget = HoistTarget = class HoistTarget extends Base {
            // Expands hoisted fragments in the given array
            static expand(fragments) {
                var fragment, i, j, ref1;
                for (i = j = fragments.length - 1; j >= 0; i = j += -1) {
                    fragment = fragments[i];
                    if (fragment.fragments) {
                        splice.apply(fragments, [i, i - i + 1].concat(ref1 = this.expand(fragment.fragments))), ref1;
                    }
                }
                return fragments;
            }
            constructor(source1) {
                super();
                this.source = source1;
                // Holds presentational options to apply when the source node is compiled.
                this.options = {};
                // Placeholder fragments to be replaced by the source node’s compilation.
                this.targetFragments = {
                    fragments: []
                };
            }
            isStatement(o) {
                return this.source.isStatement(o);
            }
            // Update the target fragments with the result of compiling the source.
            // Calls the given compile function with the node and options (overriden with the target
            // presentational options).
            update(compile, o) {
                return this.targetFragments.fragments = compile.call(this.source, merge(o, this.options));
            }
            // Copies the target indent and level, and returns the placeholder fragments
            compileToFragments(o, level) {
                this.options.indent = o.indent;
                this.options.level = level != null ? level : o.level;
                return [this.targetFragments];
            }
            compileNode(o) {
                return this.compileToFragments(o);
            }
            compileClosure(o) {
                return this.compileToFragments(o);
            }
        };
        //### Block
        // The block is the list of expressions that forms the body of an
        // indented block of code -- the implementation of a function, a clause in an
        // `if`, `switch`, or `try`, and so on...
        exports.Block = Block = (function () {
            class Block extends Base {
                constructor(nodes) {
                    super();
                    this.expressions = compact(flatten(nodes || []));
                }
                // Tack an expression on to the end of this expression list.
                push(node) {
                    this.expressions.push(node);
                    return this;
                }
                // Remove and return the last expression of this expression list.
                pop() {
                    return this.expressions.pop();
                }
                // Add an expression at the beginning of this expression list.
                unshift(node) {
                    this.expressions.unshift(node);
                    return this;
                }
                // If this Block consists of just a single node, unwrap it by pulling
                // it back out.
                unwrap() {
                    if (this.expressions.length === 1) {
                        return this.expressions[0];
                    }
                    else {
                        return this;
                    }
                }
                // Is this an empty block of code?
                isEmpty() {
                    return !this.expressions.length;
                }
                isStatement(o) {
                    var exp, j, len1, ref1;
                    ref1 = this.expressions;
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        exp = ref1[j];
                        if (exp.isStatement(o)) {
                            return true;
                        }
                    }
                    return false;
                }
                jumps(o) {
                    var exp, j, jumpNode, len1, ref1;
                    ref1 = this.expressions;
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        exp = ref1[j];
                        if (jumpNode = exp.jumps(o)) {
                            return jumpNode;
                        }
                    }
                }
                // A Block node does not return its entire body, rather it
                // ensures that the final expression is returned.
                makeReturn(res) {
                    var expr, len;
                    len = this.expressions.length;
                    while (len--) {
                        expr = this.expressions[len];
                        this.expressions[len] = expr.makeReturn(res);
                        if (expr instanceof Return && !expr.expression) {
                            this.expressions.splice(len, 1);
                        }
                        break;
                    }
                    return this;
                }
                // A **Block** is the only node that can serve as the root.
                compileToFragments(o = {}, level) {
                    if (o.scope) {
                        return super.compileToFragments(o, level);
                    }
                    else {
                        return this.compileRoot(o);
                    }
                }
                // Compile all expressions within the **Block** body. If we need to return
                // the result, and it’s an expression, simply return it. If it’s a statement,
                // ask the statement to do so.
                compileNode(o) {
                    var answer, compiledNodes, fragments, index, j, lastFragment, len1, node, ref1, top;
                    this.tab = o.indent;
                    top = o.level === LEVEL_TOP;
                    compiledNodes = [];
                    ref1 = this.expressions;
                    for (index = j = 0, len1 = ref1.length; j < len1; index = ++j) {
                        node = ref1[index];
                        if (node.hoisted) {
                            // This is a hoisted expression.
                            // We want to compile this and ignore the result.
                            node.compileToFragments(o);
                            continue;
                        }
                        node = node.unfoldSoak(o) || node;
                        if (node instanceof Block) {
                            // This is a nested block. We don’t do anything special here like
                            // enclose it in a new scope; we just compile the statements in this
                            // block along with our own.
                            compiledNodes.push(node.compileNode(o));
                        }
                        else if (top) {
                            node.front = true;
                            fragments = node.compileToFragments(o);
                            if (!node.isStatement(o)) {
                                fragments = indentInitial(fragments, this);
                                [lastFragment] = slice1.call(fragments, -1);
                                if (!(lastFragment.code === '' || lastFragment.isComment)) {
                                    fragments.push(this.makeCode(';'));
                                }
                            }
                            compiledNodes.push(fragments);
                        }
                        else {
                            compiledNodes.push(node.compileToFragments(o, LEVEL_LIST));
                        }
                    }
                    if (top) {
                        if (this.spaced) {
                            return [].concat(this.joinFragmentArrays(compiledNodes, '\n\n'), this.makeCode('\n'));
                        }
                        else {
                            return this.joinFragmentArrays(compiledNodes, '\n');
                        }
                    }
                    if (compiledNodes.length) {
                        answer = this.joinFragmentArrays(compiledNodes, ', ');
                    }
                    else {
                        answer = [this.makeCode('void 0')];
                    }
                    if (compiledNodes.length > 1 && o.level >= LEVEL_LIST) {
                        return this.wrapInParentheses(answer);
                    }
                    else {
                        return answer;
                    }
                }
                // If we happen to be the top-level **Block**, wrap everything in a safety
                // closure, unless requested not to. It would be better not to generate them
                // in the first place, but for now, clean up obvious double-parentheses.
                compileRoot(o) {
                    var fragments, j, len1, name, ref1, ref2;
                    o.indent = o.bare ? '' : TAB;
                    o.level = LEVEL_TOP;
                    this.spaced = true;
                    o.scope = new Scope(null, this, null, (ref1 = o.referencedVars) != null ? ref1 : []);
                    ref2 = o.locals || [];
                    for (j = 0, len1 = ref2.length; j < len1; j++) {
                        name = ref2[j];
                        // Mark given local variables in the root scope as parameters so they don’t
                        // end up being declared on this block.
                        o.scope.parameter(name);
                    }
                    fragments = this.compileWithDeclarations(o);
                    HoistTarget.expand(fragments);
                    fragments = this.compileComments(fragments);
                    if (o.bare) {
                        return fragments;
                    }
                    return [].concat(this.makeCode("(function() {\n"), fragments, this.makeCode("\n}).call(this);\n"));
                }
                // Compile the expressions body for the contents of a function, with
                // declarations of all inner variables pushed up to the top.
                compileWithDeclarations(o) {
                    var assigns, declaredVariable, declaredVariables, declaredVariablesIndex, declars, exp, fragments, i, j, k, len1, len2, post, ref1, rest, scope, spaced;
                    fragments = [];
                    post = [];
                    ref1 = this.expressions;
                    for (i = j = 0, len1 = ref1.length; j < len1; i = ++j) {
                        exp = ref1[i];
                        exp = exp.unwrap();
                        if (!(exp instanceof Literal)) {
                            break;
                        }
                    }
                    o = merge(o, {
                        level: LEVEL_TOP
                    });
                    if (i) {
                        rest = this.expressions.splice(i, 9e9);
                        [spaced, this.spaced] = [this.spaced, false];
                        [fragments, this.spaced] = [this.compileNode(o), spaced];
                        this.expressions = rest;
                    }
                    post = this.compileNode(o);
                    ({ scope } = o);
                    if (scope.expressions === this) {
                        declars = o.scope.hasDeclarations();
                        assigns = scope.hasAssignments;
                        if (declars || assigns) {
                            if (i) {
                                fragments.push(this.makeCode('\n'));
                            }
                            fragments.push(this.makeCode(`${this.tab}var `));
                            if (declars) {
                                declaredVariables = scope.declaredVariables();
                                for (declaredVariablesIndex = k = 0, len2 = declaredVariables.length; k < len2; declaredVariablesIndex = ++k) {
                                    declaredVariable = declaredVariables[declaredVariablesIndex];
                                    fragments.push(this.makeCode(declaredVariable));
                                    if (Object.prototype.hasOwnProperty.call(o.scope.comments, declaredVariable)) {
                                        fragments.push(...o.scope.comments[declaredVariable]);
                                    }
                                    if (declaredVariablesIndex !== declaredVariables.length - 1) {
                                        fragments.push(this.makeCode(', '));
                                    }
                                }
                            }
                            if (assigns) {
                                if (declars) {
                                    fragments.push(this.makeCode(`,\n${this.tab + TAB}`));
                                }
                                fragments.push(this.makeCode(scope.assignedVariables().join(`,\n${this.tab + TAB}`)));
                            }
                            fragments.push(this.makeCode(`;\n${(this.spaced ? '\n' : '')}`));
                        }
                        else if (fragments.length && post.length) {
                            fragments.push(this.makeCode("\n"));
                        }
                    }
                    return fragments.concat(post);
                }
                compileComments(fragments) {
                    var code, commentFragment, fragment, fragmentIndent, fragmentIndex, indent, j, k, l, len1, len2, len3, newLineIndex, onNextLine, p, pastFragment, pastFragmentIndex, q, ref1, ref2, ref3, ref4, trail, upcomingFragment, upcomingFragmentIndex;
                    for (fragmentIndex = j = 0, len1 = fragments.length; j < len1; fragmentIndex = ++j) {
                        fragment = fragments[fragmentIndex];
                        // Insert comments into the output at the next or previous newline.
                        // If there are no newlines at which to place comments, create them.
                        if (fragment.precedingComments) {
                            // Determine the indentation level of the fragment that we are about
                            // to insert comments before, and use that indentation level for our
                            // inserted comments. At this point, the fragments’ `code` property
                            // is the generated output JavaScript, and CoffeeScript always
                            // generates output indented by two spaces; so all we need to do is
                            // search for a `code` property that begins with at least two spaces.
                            fragmentIndent = '';
                            ref1 = fragments.slice(0, (fragmentIndex + 1));
                            for (k = ref1.length - 1; k >= 0; k += -1) {
                                pastFragment = ref1[k];
                                indent = /^ {2,}/m.exec(pastFragment.code);
                                if (indent) {
                                    fragmentIndent = indent[0];
                                    break;
                                }
                                else if (indexOf.call(pastFragment.code, '\n') >= 0) {
                                    break;
                                }
                            }
                            code = `\n${fragmentIndent}` + ((function () {
                                var l, len2, ref2, results;
                                ref2 = fragment.precedingComments;
                                results = [];
                                for (l = 0, len2 = ref2.length; l < len2; l++) {
                                    commentFragment = ref2[l];
                                    if (commentFragment.isHereComment && commentFragment.multiline) {
                                        results.push(multident(commentFragment.code, fragmentIndent, false));
                                    }
                                    else {
                                        results.push(commentFragment.code);
                                    }
                                }
                                return results;
                            })()).join(`\n${fragmentIndent}`).replace(/^(\s*)$/gm, '');
                            ref2 = fragments.slice(0, (fragmentIndex + 1));
                            for (pastFragmentIndex = l = ref2.length - 1; l >= 0; pastFragmentIndex = l += -1) {
                                pastFragment = ref2[pastFragmentIndex];
                                newLineIndex = pastFragment.code.lastIndexOf('\n');
                                if (newLineIndex === -1) {
                                    // Keep searching previous fragments until we can’t go back any
                                    // further, either because there are no fragments left or we’ve
                                    // discovered that we’re in a code block that is interpolated
                                    // inside a string.
                                    if (pastFragmentIndex === 0) {
                                        pastFragment.code = '\n' + pastFragment.code;
                                        newLineIndex = 0;
                                    }
                                    else if (pastFragment.isStringWithInterpolations && pastFragment.code === '{') {
                                        code = code.slice(1) + '\n'; // Move newline to end.
                                        newLineIndex = 1;
                                    }
                                    else {
                                        continue;
                                    }
                                }
                                delete fragment.precedingComments;
                                pastFragment.code = pastFragment.code.slice(0, newLineIndex) + code + pastFragment.code.slice(newLineIndex);
                                break;
                            }
                        }
                        // Yes, this is awfully similar to the previous `if` block, but if you
                        // look closely you’ll find lots of tiny differences that make this
                        // confusing if it were abstracted into a function that both blocks share.
                        if (fragment.followingComments) {
                            // Does the first trailing comment follow at the end of a line of code,
                            // like `; // Comment`, or does it start a new line after a line of code?
                            trail = fragment.followingComments[0].trail;
                            fragmentIndent = '';
                            // Find the indent of the next line of code, if we have any non-trailing
                            // comments to output. We need to first find the next newline, as these
                            // comments will be output after that; and then the indent of the line
                            // that follows the next newline.
                            if (!(trail && fragment.followingComments.length === 1)) {
                                onNextLine = false;
                                ref3 = fragments.slice(fragmentIndex);
                                for (p = 0, len2 = ref3.length; p < len2; p++) {
                                    upcomingFragment = ref3[p];
                                    if (!onNextLine) {
                                        if (indexOf.call(upcomingFragment.code, '\n') >= 0) {
                                            onNextLine = true;
                                        }
                                        else {
                                            continue;
                                        }
                                    }
                                    else {
                                        indent = /^ {2,}/m.exec(upcomingFragment.code);
                                        if (indent) {
                                            fragmentIndent = indent[0];
                                            break;
                                        }
                                        else if (indexOf.call(upcomingFragment.code, '\n') >= 0) {
                                            break;
                                        }
                                    }
                                }
                            }
                            // Is this comment following the indent inserted by bare mode?
                            // If so, there’s no need to indent this further.
                            code = fragmentIndex === 1 && /^\s+$/.test(fragments[0].code) ? '' : trail ? ' ' : `\n${fragmentIndent}`;
                            // Assemble properly indented comments.
                            code += ((function () {
                                var len3, q, ref4, results;
                                ref4 = fragment.followingComments;
                                results = [];
                                for (q = 0, len3 = ref4.length; q < len3; q++) {
                                    commentFragment = ref4[q];
                                    if (commentFragment.isHereComment && commentFragment.multiline) {
                                        results.push(multident(commentFragment.code, fragmentIndent, false));
                                    }
                                    else {
                                        results.push(commentFragment.code);
                                    }
                                }
                                return results;
                            })()).join(`\n${fragmentIndent}`).replace(/^(\s*)$/gm, '');
                            ref4 = fragments.slice(fragmentIndex);
                            for (upcomingFragmentIndex = q = 0, len3 = ref4.length; q < len3; upcomingFragmentIndex = ++q) {
                                upcomingFragment = ref4[upcomingFragmentIndex];
                                newLineIndex = upcomingFragment.code.indexOf('\n');
                                if (newLineIndex === -1) {
                                    // Keep searching upcoming fragments until we can’t go any
                                    // further, either because there are no fragments left or we’ve
                                    // discovered that we’re in a code block that is interpolated
                                    // inside a string.
                                    if (upcomingFragmentIndex === fragments.length - 1) {
                                        upcomingFragment.code = upcomingFragment.code + '\n';
                                        newLineIndex = upcomingFragment.code.length;
                                    }
                                    else if (upcomingFragment.isStringWithInterpolations && upcomingFragment.code === '}') {
                                        code = `${code}\n`;
                                        newLineIndex = 0;
                                    }
                                    else {
                                        continue;
                                    }
                                }
                                delete fragment.followingComments;
                                if (upcomingFragment.code === '\n') {
                                    // Avoid inserting extra blank lines.
                                    code = code.replace(/^\n/, '');
                                }
                                upcomingFragment.code = upcomingFragment.code.slice(0, newLineIndex) + code + upcomingFragment.code.slice(newLineIndex);
                                break;
                            }
                        }
                    }
                    return fragments;
                }
                // Wrap up the given nodes as a **Block**, unless it already happens
                // to be one.
                static wrap(nodes) {
                    if (nodes.length === 1 && nodes[0] instanceof Block) {
                        return nodes[0];
                    }
                    return new Block(nodes);
                }
            }
            ;
            Block.prototype.children = ['expressions'];
            return Block;
        }).call(this);
        //### Literal
        // `Literal` is a base class for static values that can be passed through
        // directly into JavaScript without translation, such as: strings, numbers,
        // `true`, `false`, `null`...
        exports.Literal = Literal = (function () {
            class Literal extends Base {
                constructor(value1) {
                    super();
                    this.value = value1;
                }
                assigns(name) {
                    return name === this.value;
                }
                compileNode(o) {
                    return [this.makeCode(this.value)];
                }
                toString() {
                    // This is only intended for debugging.
                    return ` ${(this.isStatement() ? super.toString() : this.constructor.name)}: ${this.value}`;
                }
            }
            ;
            Literal.prototype.shouldCache = NO;
            return Literal;
        }).call(this);
        exports.NumberLiteral = NumberLiteral = class NumberLiteral extends Literal {
        };
        exports.InfinityLiteral = InfinityLiteral = class InfinityLiteral extends NumberLiteral {
            compileNode() {
                return [this.makeCode('2e308')];
            }
        };
        exports.NaNLiteral = NaNLiteral = class NaNLiteral extends NumberLiteral {
            constructor() {
                super('NaN');
            }
            compileNode(o) {
                var code;
                code = [this.makeCode('0/0')];
                if (o.level >= LEVEL_OP) {
                    return this.wrapInParentheses(code);
                }
                else {
                    return code;
                }
            }
        };
        exports.StringLiteral = StringLiteral = class StringLiteral extends Literal {
            compileNode(o) {
                var res;
                return res = this.csx ? [this.makeCode(this.unquote(true, true))] : super.compileNode();
            }
            unquote(doubleQuote = false, newLine = false) {
                var unquoted;
                unquoted = this.value.slice(1, -1);
                if (doubleQuote) {
                    unquoted = unquoted.replace(/\\"/g, '"');
                }
                if (newLine) {
                    unquoted = unquoted.replace(/\\n/g, '\n');
                }
                return unquoted;
            }
        };
        exports.RegexLiteral = RegexLiteral = class RegexLiteral extends Literal {
        };
        exports.PassthroughLiteral = PassthroughLiteral = class PassthroughLiteral extends Literal {
        };
        exports.IdentifierLiteral = IdentifierLiteral = (function () {
            class IdentifierLiteral extends Literal {
                eachName(iterator) {
                    return iterator(this);
                }
            }
            ;
            IdentifierLiteral.prototype.isAssignable = YES;
            return IdentifierLiteral;
        }).call(this);
        exports.CSXTag = CSXTag = class CSXTag extends IdentifierLiteral {
        };
        exports.PropertyName = PropertyName = (function () {
            class PropertyName extends Literal {
            }
            ;
            PropertyName.prototype.isAssignable = YES;
            return PropertyName;
        }).call(this);
        exports.ComputedPropertyName = ComputedPropertyName = class ComputedPropertyName extends PropertyName {
            compileNode(o) {
                return [this.makeCode('['), ...this.value.compileToFragments(o, LEVEL_LIST), this.makeCode(']')];
            }
        };
        exports.StatementLiteral = StatementLiteral = (function () {
            class StatementLiteral extends Literal {
                jumps(o) {
                    if (this.value === 'break' && !((o != null ? o.loop : void 0) || (o != null ? o.block : void 0))) {
                        return this;
                    }
                    if (this.value === 'continue' && !(o != null ? o.loop : void 0)) {
                        return this;
                    }
                }
                compileNode(o) {
                    return [this.makeCode(`${this.tab}${this.value};`)];
                }
            }
            ;
            StatementLiteral.prototype.isStatement = YES;
            StatementLiteral.prototype.makeReturn = THIS;
            return StatementLiteral;
        }).call(this);
        exports.ThisLiteral = ThisLiteral = class ThisLiteral extends Literal {
            constructor() {
                super('this');
            }
            compileNode(o) {
                var code, ref1;
                code = ((ref1 = o.scope.method) != null ? ref1.bound : void 0) ? o.scope.method.context : this.value;
                return [this.makeCode(code)];
            }
        };
        exports.UndefinedLiteral = UndefinedLiteral = class UndefinedLiteral extends Literal {
            constructor() {
                super('undefined');
            }
            compileNode(o) {
                return [this.makeCode(o.level >= LEVEL_ACCESS ? '(void 0)' : 'void 0')];
            }
        };
        exports.NullLiteral = NullLiteral = class NullLiteral extends Literal {
            constructor() {
                super('null');
            }
        };
        exports.BooleanLiteral = BooleanLiteral = class BooleanLiteral extends Literal {
        };
        //### Return
        // A `return` is a *pureStatement*—wrapping it in a closure wouldn’t make sense.
        exports.Return = Return = (function () {
            class Return extends Base {
                constructor(expression1) {
                    super();
                    this.expression = expression1;
                }
                compileToFragments(o, level) {
                    var expr, ref1;
                    expr = (ref1 = this.expression) != null ? ref1.makeReturn() : void 0;
                    if (expr && !(expr instanceof Return)) {
                        return expr.compileToFragments(o, level);
                    }
                    else {
                        return super.compileToFragments(o, level);
                    }
                }
                compileNode(o) {
                    var answer, fragment, j, len1;
                    answer = [];
                    // TODO: If we call `expression.compile()` here twice, we’ll sometimes
                    // get back different results!
                    if (this.expression) {
                        answer = this.expression.compileToFragments(o, LEVEL_PAREN);
                        unshiftAfterComments(answer, this.makeCode(`${this.tab}return `));
                        // Since the `return` got indented by `@tab`, preceding comments that are
                        // multiline need to be indented.
                        for (j = 0, len1 = answer.length; j < len1; j++) {
                            fragment = answer[j];
                            if (fragment.isHereComment && indexOf.call(fragment.code, '\n') >= 0) {
                                fragment.code = multident(fragment.code, this.tab);
                            }
                            else if (fragment.isLineComment) {
                                fragment.code = `${this.tab}${fragment.code}`;
                            }
                            else {
                                break;
                            }
                        }
                    }
                    else {
                        answer.push(this.makeCode(`${this.tab}return`));
                    }
                    answer.push(this.makeCode(';'));
                    return answer;
                }
            }
            ;
            Return.prototype.children = ['expression'];
            Return.prototype.isStatement = YES;
            Return.prototype.makeReturn = THIS;
            Return.prototype.jumps = THIS;
            return Return;
        }).call(this);
        // `yield return` works exactly like `return`, except that it turns the function
        // into a generator.
        exports.YieldReturn = YieldReturn = class YieldReturn extends Return {
            compileNode(o) {
                if (o.scope.parent == null) {
                    this.error('yield can only occur inside functions');
                }
                return super.compileNode(o);
            }
        };
        exports.AwaitReturn = AwaitReturn = class AwaitReturn extends Return {
            compileNode(o) {
                if (o.scope.parent == null) {
                    this.error('await can only occur inside functions');
                }
                return super.compileNode(o);
            }
        };
        //### Value
        // A value, variable or literal or parenthesized, indexed or dotted into,
        // or vanilla.
        exports.Value = Value = (function () {
            class Value extends Base {
                constructor(base, props, tag, isDefaultValue = false) {
                    var ref1, ref2;
                    super();
                    if (!props && base instanceof Value) {
                        return base;
                    }
                    this.base = base;
                    this.properties = props || [];
                    if (tag) {
                        this[tag] = true;
                    }
                    this.isDefaultValue = isDefaultValue;
                    // If this is a `@foo =` assignment, if there are comments on `@` move them
                    // to be on `foo`.
                    if (((ref1 = this.base) != null ? ref1.comments : void 0) && this.base instanceof ThisLiteral && (((ref2 = this.properties[0]) != null ? ref2.name : void 0) != null)) {
                        moveComments(this.base, this.properties[0].name);
                    }
                }
                // Add a property (or *properties* ) `Access` to the list.
                add(props) {
                    this.properties = this.properties.concat(props);
                    this.forceUpdateLocation = true;
                    return this;
                }
                hasProperties() {
                    return this.properties.length !== 0;
                }
                bareLiteral(type) {
                    return !this.properties.length && this.base instanceof type;
                }
                // Some boolean checks for the benefit of other nodes.
                isArray() {
                    return this.bareLiteral(Arr);
                }
                isRange() {
                    return this.bareLiteral(Range);
                }
                shouldCache() {
                    return this.hasProperties() || this.base.shouldCache();
                }
                isAssignable() {
                    return this.hasProperties() || this.base.isAssignable();
                }
                isNumber() {
                    return this.bareLiteral(NumberLiteral);
                }
                isString() {
                    return this.bareLiteral(StringLiteral);
                }
                isRegex() {
                    return this.bareLiteral(RegexLiteral);
                }
                isUndefined() {
                    return this.bareLiteral(UndefinedLiteral);
                }
                isNull() {
                    return this.bareLiteral(NullLiteral);
                }
                isBoolean() {
                    return this.bareLiteral(BooleanLiteral);
                }
                isAtomic() {
                    var j, len1, node, ref1;
                    ref1 = this.properties.concat(this.base);
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        node = ref1[j];
                        if (node.soak || node instanceof Call) {
                            return false;
                        }
                    }
                    return true;
                }
                isNotCallable() {
                    return this.isNumber() || this.isString() || this.isRegex() || this.isArray() || this.isRange() || this.isSplice() || this.isObject() || this.isUndefined() || this.isNull() || this.isBoolean();
                }
                isStatement(o) {
                    return !this.properties.length && this.base.isStatement(o);
                }
                assigns(name) {
                    return !this.properties.length && this.base.assigns(name);
                }
                jumps(o) {
                    return !this.properties.length && this.base.jumps(o);
                }
                isObject(onlyGenerated) {
                    if (this.properties.length) {
                        return false;
                    }
                    return (this.base instanceof Obj) && (!onlyGenerated || this.base.generated);
                }
                isElision() {
                    if (!(this.base instanceof Arr)) {
                        return false;
                    }
                    return this.base.hasElision();
                }
                isSplice() {
                    var lastProp, ref1;
                    ref1 = this.properties, [lastProp] = slice1.call(ref1, -1);
                    return lastProp instanceof Slice;
                }
                looksStatic(className) {
                    var ref1;
                    return (this.this || this.base instanceof ThisLiteral || this.base.value === className) && this.properties.length === 1 && ((ref1 = this.properties[0].name) != null ? ref1.value : void 0) !== 'prototype';
                }
                // The value can be unwrapped as its inner node, if there are no attached
                // properties.
                unwrap() {
                    if (this.properties.length) {
                        return this;
                    }
                    else {
                        return this.base;
                    }
                }
                // A reference has base part (`this` value) and name part.
                // We cache them separately for compiling complex expressions.
                // `a()[b()] ?= c` -> `(_base = a())[_name = b()] ? _base[_name] = c`
                cacheReference(o) {
                    var base, bref, name, nref, ref1;
                    ref1 = this.properties, [name] = slice1.call(ref1, -1);
                    if (this.properties.length < 2 && !this.base.shouldCache() && !(name != null ? name.shouldCache() : void 0)) {
                        return [this, this]; // `a` `a.b`
                    }
                    base = new Value(this.base, this.properties.slice(0, -1));
                    if (base.shouldCache()) { // `a().b`
                        bref = new IdentifierLiteral(o.scope.freeVariable('base'));
                        base = new Value(new Parens(new Assign(bref, base)));
                    }
                    if (!name) { // `a()`
                        return [base, bref];
                    }
                    if (name.shouldCache()) { // `a[b()]`
                        nref = new IdentifierLiteral(o.scope.freeVariable('name'));
                        name = new Index(new Assign(nref, name.index));
                        nref = new Index(nref);
                    }
                    return [base.add(name), new Value(bref || base.base, [nref || name])];
                }
                // We compile a value to JavaScript by compiling and joining each property.
                // Things get much more interesting if the chain of properties has *soak*
                // operators `?.` interspersed. Then we have to take care not to accidentally
                // evaluate anything twice when building the soak chain.
                compileNode(o) {
                    var fragments, j, len1, prop, props;
                    this.base.front = this.front;
                    props = this.properties;
                    if (props.length && (this.base.cached != null)) {
                        // Cached fragments enable correct order of the compilation,
                        // and reuse of variables in the scope.
                        // Example:
                        // `a(x = 5).b(-> x = 6)` should compile in the same order as
                        // `a(x = 5); b(-> x = 6)`
                        // (see issue #4437, https://github.com/jashkenas/coffeescript/issues/4437)
                        fragments = this.base.cached;
                    }
                    else {
                        fragments = this.base.compileToFragments(o, (props.length ? LEVEL_ACCESS : null));
                    }
                    if (props.length && SIMPLENUM.test(fragmentsToText(fragments))) {
                        fragments.push(this.makeCode('.'));
                    }
                    for (j = 0, len1 = props.length; j < len1; j++) {
                        prop = props[j];
                        fragments.push(...(prop.compileToFragments(o)));
                    }
                    return fragments;
                }
                // Unfold a soak into an `If`: `a?.b` -> `a.b if a?`
                unfoldSoak(o) {
                    return this.unfoldedSoak != null ? this.unfoldedSoak : this.unfoldedSoak = (() => {
                        var fst, i, ifn, j, len1, prop, ref, ref1, snd;
                        ifn = this.base.unfoldSoak(o);
                        if (ifn) {
                            ifn.body.properties.push(...this.properties);
                            return ifn;
                        }
                        ref1 = this.properties;
                        for (i = j = 0, len1 = ref1.length; j < len1; i = ++j) {
                            prop = ref1[i];
                            if (!prop.soak) {
                                continue;
                            }
                            prop.soak = false;
                            fst = new Value(this.base, this.properties.slice(0, i));
                            snd = new Value(this.base, this.properties.slice(i));
                            if (fst.shouldCache()) {
                                ref = new IdentifierLiteral(o.scope.freeVariable('ref'));
                                fst = new Parens(new Assign(ref, fst));
                                snd.base = ref;
                            }
                            return new If(new Existence(fst), snd, {
                                soak: true
                            });
                        }
                        return false;
                    })();
                }
                eachName(iterator) {
                    if (this.hasProperties()) {
                        return iterator(this);
                    }
                    else if (this.base.isAssignable()) {
                        return this.base.eachName(iterator);
                    }
                    else {
                        return this.error('tried to assign to unassignable value');
                    }
                }
            }
            ;
            Value.prototype.children = ['base', 'properties'];
            return Value;
        }).call(this);
        //### HereComment
        // Comment delimited by `###` (becoming `/* */`).
        exports.HereComment = HereComment = class HereComment extends Base {
            constructor({ content: content1, newLine: newLine1, unshift }) {
                super();
                this.content = content1;
                this.newLine = newLine1;
                this.unshift = unshift;
            }
            compileNode(o) {
                var fragment, hasLeadingMarks, j, largestIndent, leadingWhitespace, len1, line, multiline, ref1;
                multiline = indexOf.call(this.content, '\n') >= 0;
                hasLeadingMarks = /\n\s*[#|\*]/.test(this.content);
                if (hasLeadingMarks) {
                    this.content = this.content.replace(/^([ \t]*)#(?=\s)/gm, ' *');
                }
                // Unindent multiline comments. They will be reindented later.
                if (multiline) {
                    largestIndent = '';
                    ref1 = this.content.split('\n');
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        line = ref1[j];
                        leadingWhitespace = /^\s*/.exec(line)[0];
                        if (leadingWhitespace.length > largestIndent.length) {
                            largestIndent = leadingWhitespace;
                        }
                    }
                    this.content = this.content.replace(RegExp(`^(${leadingWhitespace})`, "gm"), '');
                }
                this.content = `/*${this.content}${(hasLeadingMarks ? ' ' : '')}*/`;
                fragment = this.makeCode(this.content);
                fragment.newLine = this.newLine;
                fragment.unshift = this.unshift;
                fragment.multiline = multiline;
                // Don’t rely on `fragment.type`, which can break when the compiler is minified.
                fragment.isComment = fragment.isHereComment = true;
                return fragment;
            }
        };
        //### LineComment
        // Comment running from `#` to the end of a line (becoming `//`).
        exports.LineComment = LineComment = class LineComment extends Base {
            constructor({ content: content1, newLine: newLine1, unshift }) {
                super();
                this.content = content1;
                this.newLine = newLine1;
                this.unshift = unshift;
            }
            compileNode(o) {
                var fragment;
                fragment = this.makeCode(/^\s*$/.test(this.content) ? '' : `//${this.content}`);
                fragment.newLine = this.newLine;
                fragment.unshift = this.unshift;
                fragment.trail = !this.newLine && !this.unshift;
                // Don’t rely on `fragment.type`, which can break when the compiler is minified.
                fragment.isComment = fragment.isLineComment = true;
                return fragment;
            }
        };
        //### Call
        // Node for a function invocation.
        exports.Call = Call = (function () {
            class Call extends Base {
                constructor(variable1, args1 = [], soak1, token1) {
                    var ref1;
                    super();
                    this.variable = variable1;
                    this.args = args1;
                    this.soak = soak1;
                    this.token = token1;
                    this.isNew = false;
                    if (this.variable instanceof Value && this.variable.isNotCallable()) {
                        this.variable.error("literal is not a function");
                    }
                    this.csx = this.variable.base instanceof CSXTag;
                    // `@variable` never gets output as a result of this node getting created as
                    // part of `RegexWithInterpolations`, so for that case move any comments to
                    // the `args` property that gets passed into `RegexWithInterpolations` via
                    // the grammar.
                    if (((ref1 = this.variable.base) != null ? ref1.value : void 0) === 'RegExp' && this.args.length !== 0) {
                        moveComments(this.variable, this.args[0]);
                    }
                }
                // When setting the location, we sometimes need to update the start location to
                // account for a newly-discovered `new` operator to the left of us. This
                // expands the range on the left, but not the right.
                updateLocationDataIfMissing(locationData) {
                    var base, ref1;
                    if (this.locationData && this.needsUpdatedStartLocation) {
                        this.locationData.first_line = locationData.first_line;
                        this.locationData.first_column = locationData.first_column;
                        base = ((ref1 = this.variable) != null ? ref1.base : void 0) || this.variable;
                        if (base.needsUpdatedStartLocation) {
                            this.variable.locationData.first_line = locationData.first_line;
                            this.variable.locationData.first_column = locationData.first_column;
                            base.updateLocationDataIfMissing(locationData);
                        }
                        delete this.needsUpdatedStartLocation;
                    }
                    return super.updateLocationDataIfMissing(locationData);
                }
                // Tag this invocation as creating a new instance.
                newInstance() {
                    var base, ref1;
                    base = ((ref1 = this.variable) != null ? ref1.base : void 0) || this.variable;
                    if (base instanceof Call && !base.isNew) {
                        base.newInstance();
                    }
                    else {
                        this.isNew = true;
                    }
                    this.needsUpdatedStartLocation = true;
                    return this;
                }
                // Soaked chained invocations unfold into if/else ternary structures.
                unfoldSoak(o) {
                    var call, ifn, j, left, len1, list, ref1, rite;
                    if (this.soak) {
                        if (this.variable instanceof Super) {
                            left = new Literal(this.variable.compile(o));
                            rite = new Value(left);
                            if (this.variable.accessor == null) {
                                this.variable.error("Unsupported reference to 'super'");
                            }
                        }
                        else {
                            if (ifn = unfoldSoak(o, this, 'variable')) {
                                return ifn;
                            }
                            [left, rite] = new Value(this.variable).cacheReference(o);
                        }
                        rite = new Call(rite, this.args);
                        rite.isNew = this.isNew;
                        left = new Literal(`typeof ${left.compile(o)} === "function"`);
                        return new If(left, new Value(rite), {
                            soak: true
                        });
                    }
                    call = this;
                    list = [];
                    while (true) {
                        if (call.variable instanceof Call) {
                            list.push(call);
                            call = call.variable;
                            continue;
                        }
                        if (!(call.variable instanceof Value)) {
                            break;
                        }
                        list.push(call);
                        if (!((call = call.variable.base) instanceof Call)) {
                            break;
                        }
                    }
                    ref1 = list.reverse();
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        call = ref1[j];
                        if (ifn) {
                            if (call.variable instanceof Call) {
                                call.variable = ifn;
                            }
                            else {
                                call.variable.base = ifn;
                            }
                        }
                        ifn = unfoldSoak(o, call, 'variable');
                    }
                    return ifn;
                }
                // Compile a vanilla function call.
                compileNode(o) {
                    var arg, argCode, argIndex, cache, compiledArgs, fragments, j, len1, ref1, ref2, ref3, ref4, varAccess;
                    if (this.csx) {
                        return this.compileCSX(o);
                    }
                    if ((ref1 = this.variable) != null) {
                        ref1.front = this.front;
                    }
                    compiledArgs = [];
                    // If variable is `Accessor` fragments are cached and used later
                    // in `Value::compileNode` to ensure correct order of the compilation,
                    // and reuse of variables in the scope.
                    // Example:
                    // `a(x = 5).b(-> x = 6)` should compile in the same order as
                    // `a(x = 5); b(-> x = 6)`
                    // (see issue #4437, https://github.com/jashkenas/coffeescript/issues/4437)
                    varAccess = ((ref2 = this.variable) != null ? (ref3 = ref2.properties) != null ? ref3[0] : void 0 : void 0) instanceof Access;
                    argCode = (function () {
                        var j, len1, ref4, results;
                        ref4 = this.args || [];
                        results = [];
                        for (j = 0, len1 = ref4.length; j < len1; j++) {
                            arg = ref4[j];
                            if (arg instanceof Code) {
                                results.push(arg);
                            }
                        }
                        return results;
                    }).call(this);
                    if (argCode.length > 0 && varAccess && !this.variable.base.cached) {
                        [cache] = this.variable.base.cache(o, LEVEL_ACCESS, function () {
                            return false;
                        });
                        this.variable.base.cached = cache;
                    }
                    ref4 = this.args;
                    for (argIndex = j = 0, len1 = ref4.length; j < len1; argIndex = ++j) {
                        arg = ref4[argIndex];
                        if (argIndex) {
                            compiledArgs.push(this.makeCode(", "));
                        }
                        compiledArgs.push(...(arg.compileToFragments(o, LEVEL_LIST)));
                    }
                    fragments = [];
                    if (this.isNew) {
                        if (this.variable instanceof Super) {
                            this.variable.error("Unsupported reference to 'super'");
                        }
                        fragments.push(this.makeCode('new '));
                    }
                    fragments.push(...this.variable.compileToFragments(o, LEVEL_ACCESS));
                    fragments.push(this.makeCode('('), ...compiledArgs, this.makeCode(')'));
                    return fragments;
                }
                compileCSX(o) {
                    var attr, attrProps, attributes, content, fragments, j, len1, obj, ref1, tag;
                    [attributes, content] = this.args;
                    attributes.base.csx = true;
                    if (content != null) {
                        content.base.csx = true;
                    }
                    fragments = [this.makeCode('<')];
                    fragments.push(...(tag = this.variable.compileToFragments(o, LEVEL_ACCESS)));
                    if (attributes.base instanceof Arr) {
                        ref1 = attributes.base.objects;
                        for (j = 0, len1 = ref1.length; j < len1; j++) {
                            obj = ref1[j];
                            attr = obj.base;
                            attrProps = (attr != null ? attr.properties : void 0) || [];
                            // Catch invalid CSX attributes: <div {a:"b", props} {props} "value" />
                            if (!(attr instanceof Obj || attr instanceof IdentifierLiteral) || (attr instanceof Obj && !attr.generated && (attrProps.length > 1 || !(attrProps[0] instanceof Splat)))) {
                                obj.error("Unexpected token. Allowed CSX attributes are: id=\"val\", src={source}, {props...} or attribute.");
                            }
                            if (obj.base instanceof Obj) {
                                obj.base.csx = true;
                            }
                            fragments.push(this.makeCode(' '));
                            fragments.push(...obj.compileToFragments(o, LEVEL_PAREN));
                        }
                    }
                    if (content) {
                        fragments.push(this.makeCode('>'));
                        fragments.push(...content.compileNode(o, LEVEL_LIST));
                        fragments.push(...[this.makeCode('</'), ...tag, this.makeCode('>')]);
                    }
                    else {
                        fragments.push(this.makeCode(' />'));
                    }
                    return fragments;
                }
            }
            ;
            Call.prototype.children = ['variable', 'args'];
            return Call;
        }).call(this);
        //### Super
        // Takes care of converting `super()` calls into calls against the prototype's
        // function of the same name.
        // When `expressions` are set the call will be compiled in such a way that the
        // expressions are evaluated without altering the return value of the `SuperCall`
        // expression.
        exports.SuperCall = SuperCall = (function () {
            class SuperCall extends Call {
                isStatement(o) {
                    var ref1;
                    return ((ref1 = this.expressions) != null ? ref1.length : void 0) && o.level === LEVEL_TOP;
                }
                compileNode(o) {
                    var ref, ref1, replacement, superCall;
                    if (!((ref1 = this.expressions) != null ? ref1.length : void 0)) {
                        return super.compileNode(o);
                    }
                    superCall = new Literal(fragmentsToText(super.compileNode(o)));
                    replacement = new Block(this.expressions.slice());
                    if (o.level > LEVEL_TOP) {
                        // If we might be in an expression we need to cache and return the result
                        [superCall, ref] = superCall.cache(o, null, YES);
                        replacement.push(ref);
                    }
                    replacement.unshift(superCall);
                    return replacement.compileToFragments(o, o.level === LEVEL_TOP ? o.level : LEVEL_LIST);
                }
            }
            ;
            SuperCall.prototype.children = Call.prototype.children.concat(['expressions']);
            return SuperCall;
        }).call(this);
        exports.Super = Super = (function () {
            class Super extends Base {
                constructor(accessor) {
                    super();
                    this.accessor = accessor;
                }
                compileNode(o) {
                    var fragments, method, name, nref, ref1, ref2, salvagedComments, variable;
                    method = o.scope.namedMethod();
                    if (!(method != null ? method.isMethod : void 0)) {
                        this.error('cannot use super outside of an instance method');
                    }
                    if (!((method.ctor != null) || (this.accessor != null))) {
                        ({ name, variable } = method);
                        if (name.shouldCache() || (name instanceof Index && name.index.isAssignable())) {
                            nref = new IdentifierLiteral(o.scope.parent.freeVariable('name'));
                            name.index = new Assign(nref, name.index);
                        }
                        this.accessor = nref != null ? new Index(nref) : name;
                    }
                    if ((ref1 = this.accessor) != null ? (ref2 = ref1.name) != null ? ref2.comments : void 0 : void 0) {
                        // A `super()` call gets compiled to e.g. `super.method()`, which means
                        // the `method` property name gets compiled for the first time here, and
                        // again when the `method:` property of the class gets compiled. Since
                        // this compilation happens first, comments attached to `method:` would
                        // get incorrectly output near `super.method()`, when we want them to
                        // get output on the second pass when `method:` is output. So set them
                        // aside during this compilation pass, and put them back on the object so
                        // that they’re there for the later compilation.
                        salvagedComments = this.accessor.name.comments;
                        delete this.accessor.name.comments;
                    }
                    fragments = (new Value(new Literal('super'), this.accessor ? [this.accessor] : [])).compileToFragments(o);
                    if (salvagedComments) {
                        attachCommentsToNode(salvagedComments, this.accessor.name);
                    }
                    return fragments;
                }
            }
            ;
            Super.prototype.children = ['accessor'];
            return Super;
        }).call(this);
        //### RegexWithInterpolations
        // Regexes with interpolations are in fact just a variation of a `Call` (a
        // `RegExp()` call to be precise) with a `StringWithInterpolations` inside.
        exports.RegexWithInterpolations = RegexWithInterpolations = class RegexWithInterpolations extends Call {
            constructor(args = []) {
                super(new Value(new IdentifierLiteral('RegExp')), args, false);
            }
        };
        //### TaggedTemplateCall
        exports.TaggedTemplateCall = TaggedTemplateCall = class TaggedTemplateCall extends Call {
            constructor(variable, arg, soak) {
                if (arg instanceof StringLiteral) {
                    arg = new StringWithInterpolations(Block.wrap([new Value(arg)]));
                }
                super(variable, [arg], soak);
            }
            compileNode(o) {
                return this.variable.compileToFragments(o, LEVEL_ACCESS).concat(this.args[0].compileToFragments(o, LEVEL_LIST));
            }
        };
        //### Extends
        // Node to extend an object's prototype with an ancestor object.
        // After `goog.inherits` from the
        // [Closure Library](https://github.com/google/closure-library/blob/master/closure/goog/base.js).
        exports.Extends = Extends = (function () {
            class Extends extends Base {
                constructor(child1, parent1) {
                    super();
                    this.child = child1;
                    this.parent = parent1;
                }
                // Hooks one constructor into another's prototype chain.
                compileToFragments(o) {
                    return new Call(new Value(new Literal(utility('extend', o))), [this.child, this.parent]).compileToFragments(o);
                }
            }
            ;
            Extends.prototype.children = ['child', 'parent'];
            return Extends;
        }).call(this);
        //### Access
        // A `.` access into a property of a value, or the `::` shorthand for
        // an access into the object's prototype.
        exports.Access = Access = (function () {
            class Access extends Base {
                constructor(name1, tag) {
                    super();
                    this.name = name1;
                    this.soak = tag === 'soak';
                }
                compileToFragments(o) {
                    var name, node;
                    name = this.name.compileToFragments(o);
                    node = this.name.unwrap();
                    if (node instanceof PropertyName) {
                        return [this.makeCode('.'), ...name];
                    }
                    else {
                        return [this.makeCode('['), ...name, this.makeCode(']')];
                    }
                }
            }
            ;
            Access.prototype.children = ['name'];
            Access.prototype.shouldCache = NO;
            return Access;
        }).call(this);
        //### Index
        // A `[ ... ]` indexed access into an array or object.
        exports.Index = Index = (function () {
            class Index extends Base {
                constructor(index1) {
                    super();
                    this.index = index1;
                }
                compileToFragments(o) {
                    return [].concat(this.makeCode("["), this.index.compileToFragments(o, LEVEL_PAREN), this.makeCode("]"));
                }
                shouldCache() {
                    return this.index.shouldCache();
                }
            }
            ;
            Index.prototype.children = ['index'];
            return Index;
        }).call(this);
        //### Range
        // A range literal. Ranges can be used to extract portions (slices) of arrays,
        // to specify a range for comprehensions, or as a value, to be expanded into the
        // corresponding array of integers at runtime.
        exports.Range = Range = (function () {
            class Range extends Base {
                constructor(from1, to1, tag) {
                    super();
                    this.from = from1;
                    this.to = to1;
                    this.exclusive = tag === 'exclusive';
                    this.equals = this.exclusive ? '' : '=';
                }
                // Compiles the range's source variables -- where it starts and where it ends.
                // But only if they need to be cached to avoid double evaluation.
                compileVariables(o) {
                    var shouldCache, step;
                    o = merge(o, {
                        top: true
                    });
                    shouldCache = del(o, 'shouldCache');
                    [this.fromC, this.fromVar] = this.cacheToCodeFragments(this.from.cache(o, LEVEL_LIST, shouldCache));
                    [this.toC, this.toVar] = this.cacheToCodeFragments(this.to.cache(o, LEVEL_LIST, shouldCache));
                    if (step = del(o, 'step')) {
                        [this.step, this.stepVar] = this.cacheToCodeFragments(step.cache(o, LEVEL_LIST, shouldCache));
                    }
                    this.fromNum = this.from.isNumber() ? Number(this.fromVar) : null;
                    this.toNum = this.to.isNumber() ? Number(this.toVar) : null;
                    return this.stepNum = (step != null ? step.isNumber() : void 0) ? Number(this.stepVar) : null;
                }
                // When compiled normally, the range returns the contents of the *for loop*
                // needed to iterate over the values in the range. Used by comprehensions.
                compileNode(o) {
                    var cond, condPart, from, gt, idx, idxName, known, lowerBound, lt, namedIndex, ref1, ref2, stepCond, stepNotZero, stepPart, to, upperBound, varPart;
                    if (!this.fromVar) {
                        this.compileVariables(o);
                    }
                    if (!o.index) {
                        return this.compileArray(o);
                    }
                    // Set up endpoints.
                    known = (this.fromNum != null) && (this.toNum != null);
                    idx = del(o, 'index');
                    idxName = del(o, 'name');
                    namedIndex = idxName && idxName !== idx;
                    varPart = known && !namedIndex ? `var ${idx} = ${this.fromC}` : `${idx} = ${this.fromC}`;
                    if (this.toC !== this.toVar) {
                        varPart += `, ${this.toC}`;
                    }
                    if (this.step !== this.stepVar) {
                        varPart += `, ${this.step}`;
                    }
                    [lt, gt] = [`${idx} <${this.equals}`, `${idx} >${this.equals}`];
                    // Generate the condition.
                    [from, to] = [this.fromNum, this.toNum];
                    // Always check if the `step` isn't zero to avoid the infinite loop.
                    stepNotZero = `${(ref1 = this.stepNum) != null ? ref1 : this.stepVar} !== 0`;
                    stepCond = `${(ref2 = this.stepNum) != null ? ref2 : this.stepVar} > 0`;
                    lowerBound = `${lt} ${(known ? to : this.toVar)}`;
                    upperBound = `${gt} ${(known ? to : this.toVar)}`;
                    condPart = this.step != null ? (this.stepNum != null) && this.stepNum !== 0 ? this.stepNum > 0 ? `${lowerBound}` : `${upperBound}` : `${stepNotZero} && (${stepCond} ? ${lowerBound} : ${upperBound})` : known ? `${(from <= to ? lt : gt)} ${to}` : `(${this.fromVar} <= ${this.toVar} ? ${lowerBound} : ${upperBound})`;
                    cond = this.stepVar ? `${this.stepVar} > 0` : `${this.fromVar} <= ${this.toVar}`;
                    // Generate the step.
                    stepPart = this.stepVar ? `${idx} += ${this.stepVar}` : known ? namedIndex ? from <= to ? `++${idx}` : `--${idx}` : from <= to ? `${idx}++` : `${idx}--` : namedIndex ? `${cond} ? ++${idx} : --${idx}` : `${cond} ? ${idx}++ : ${idx}--`;
                    if (namedIndex) {
                        varPart = `${idxName} = ${varPart}`;
                    }
                    if (namedIndex) {
                        stepPart = `${idxName} = ${stepPart}`;
                    }
                    // The final loop body.
                    return [this.makeCode(`${varPart}; ${condPart}; ${stepPart}`)];
                }
                // When used as a value, expand the range into the equivalent array.
                compileArray(o) {
                    var args, body, cond, hasArgs, i, idt, known, post, pre, range, ref1, ref2, result, vars;
                    known = (this.fromNum != null) && (this.toNum != null);
                    if (known && Math.abs(this.fromNum - this.toNum) <= 20) {
                        range = (function () {
                            var results = [];
                            for (var j = ref1 = this.fromNum, ref2 = this.toNum; ref1 <= ref2 ? j <= ref2 : j >= ref2; ref1 <= ref2 ? j++ : j--) {
                                results.push(j);
                            }
                            return results;
                        }).apply(this);
                        if (this.exclusive) {
                            range.pop();
                        }
                        return [this.makeCode(`[${range.join(', ')}]`)];
                    }
                    idt = this.tab + TAB;
                    i = o.scope.freeVariable('i', {
                        single: true,
                        reserve: false
                    });
                    result = o.scope.freeVariable('results', {
                        reserve: false
                    });
                    pre = `\n${idt}var ${result} = [];`;
                    if (known) {
                        o.index = i;
                        body = fragmentsToText(this.compileNode(o));
                    }
                    else {
                        vars = `${i} = ${this.fromC}` + (this.toC !== this.toVar ? `, ${this.toC}` : '');
                        cond = `${this.fromVar} <= ${this.toVar}`;
                        body = `var ${vars}; ${cond} ? ${i} <${this.equals} ${this.toVar} : ${i} >${this.equals} ${this.toVar}; ${cond} ? ${i}++ : ${i}--`;
                    }
                    post = `{ ${result}.push(${i}); }\n${idt}return ${result};\n${o.indent}`;
                    hasArgs = function (node) {
                        return node != null ? node.contains(isLiteralArguments) : void 0;
                    };
                    if (hasArgs(this.from) || hasArgs(this.to)) {
                        args = ', arguments';
                    }
                    return [this.makeCode(`(function() {${pre}\n${idt}for (${body})${post}}).apply(this${args != null ? args : ''})`)];
                }
            }
            ;
            Range.prototype.children = ['from', 'to'];
            return Range;
        }).call(this);
        //### Slice
        // An array slice literal. Unlike JavaScript's `Array#slice`, the second parameter
        // specifies the index of the end of the slice, just as the first parameter
        // is the index of the beginning.
        exports.Slice = Slice = (function () {
            class Slice extends Base {
                constructor(range1) {
                    super();
                    this.range = range1;
                }
                // We have to be careful when trying to slice through the end of the array,
                // `9e9` is used because not all implementations respect `undefined` or `1/0`.
                // `9e9` should be safe because `9e9` > `2**32`, the max array length.
                compileNode(o) {
                    var compiled, compiledText, from, fromCompiled, to, toStr;
                    ({ to, from } = this.range);
                    // Handle an expression in the property access, e.g. `a[!b in c..]`.
                    if (from != null ? from.shouldCache() : void 0) {
                        from = new Value(new Parens(from));
                    }
                    if (to != null ? to.shouldCache() : void 0) {
                        to = new Value(new Parens(to));
                    }
                    fromCompiled = (from != null ? from.compileToFragments(o, LEVEL_PAREN) : void 0) || [this.makeCode('0')];
                    if (to) {
                        compiled = to.compileToFragments(o, LEVEL_PAREN);
                        compiledText = fragmentsToText(compiled);
                        if (!(!this.range.exclusive && +compiledText === -1)) {
                            toStr = ', ' + (this.range.exclusive ? compiledText : to.isNumber() ? `${+compiledText + 1}` : (compiled = to.compileToFragments(o, LEVEL_ACCESS), `+${fragmentsToText(compiled)} + 1 || 9e9`));
                        }
                    }
                    return [this.makeCode(`.slice(${fragmentsToText(fromCompiled)}${toStr || ''})`)];
                }
            }
            ;
            Slice.prototype.children = ['range'];
            return Slice;
        }).call(this);
        //### Obj
        // An object literal, nothing fancy.
        exports.Obj = Obj = (function () {
            class Obj extends Base {
                constructor(props, generated = false, lhs1 = false) {
                    super();
                    this.generated = generated;
                    this.lhs = lhs1;
                    this.objects = this.properties = props || [];
                }
                isAssignable() {
                    var j, len1, message, prop, ref1, ref2;
                    ref1 = this.properties;
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        prop = ref1[j];
                        // Check for reserved words.
                        message = isUnassignable(prop.unwrapAll().value);
                        if (message) {
                            prop.error(message);
                        }
                        if (prop instanceof Assign && prop.context === 'object' && !(((ref2 = prop.value) != null ? ref2.base : void 0) instanceof Arr)) {
                            prop = prop.value;
                        }
                        if (!prop.isAssignable()) {
                            return false;
                        }
                    }
                    return true;
                }
                shouldCache() {
                    return !this.isAssignable();
                }
                // Check if object contains splat.
                hasSplat() {
                    var j, len1, prop, ref1;
                    ref1 = this.properties;
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        prop = ref1[j];
                        if (prop instanceof Splat) {
                            return true;
                        }
                    }
                    return false;
                }
                // Move rest property to the end of the list.
                // `{a, rest..., b} = obj` -> `{a, b, rest...} = obj`
                // `foo = ({a, rest..., b}) ->` -> `foo = {a, b, rest...}) ->`
                reorderProperties() {
                    var i, prop, props, splatProp, splatProps;
                    props = this.properties;
                    splatProps = (function () {
                        var j, len1, results;
                        results = [];
                        for (i = j = 0, len1 = props.length; j < len1; i = ++j) {
                            prop = props[i];
                            if (prop instanceof Splat) {
                                results.push(i);
                            }
                        }
                        return results;
                    })();
                    if ((splatProps != null ? splatProps.length : void 0) > 1) {
                        props[splatProps[1]].error("multiple spread elements are disallowed");
                    }
                    splatProp = props.splice(splatProps[0], 1);
                    return this.objects = this.properties = [].concat(props, splatProp);
                }
                compileNode(o) {
                    var answer, i, idt, indent, isCompact, j, join, k, key, l, lastNode, len1, len2, len3, len4, node, p, prop, props, ref1, unwrappedVal, value;
                    if (this.hasSplat() && this.lhs) {
                        this.reorderProperties();
                    }
                    props = this.properties;
                    if (this.generated) {
                        for (j = 0, len1 = props.length; j < len1; j++) {
                            node = props[j];
                            if (node instanceof Value) {
                                node.error('cannot have an implicit value in an implicit object');
                            }
                        }
                    }
                    idt = o.indent += TAB;
                    lastNode = this.lastNode(this.properties);
                    if (this.csx) {
                        // CSX attributes <div id="val" attr={aaa} {props...} />
                        return this.compileCSXAttributes(o);
                    }
                    // If this object is the left-hand side of an assignment, all its children
                    // are too.
                    if (this.lhs) {
                        for (k = 0, len2 = props.length; k < len2; k++) {
                            prop = props[k];
                            if (!(prop instanceof Assign)) {
                                continue;
                            }
                            ({ value } = prop);
                            unwrappedVal = value.unwrapAll();
                            if (unwrappedVal instanceof Arr || unwrappedVal instanceof Obj) {
                                unwrappedVal.lhs = true;
                            }
                            else if (unwrappedVal instanceof Assign) {
                                unwrappedVal.nestedLhs = true;
                            }
                        }
                    }
                    isCompact = true;
                    ref1 = this.properties;
                    for (l = 0, len3 = ref1.length; l < len3; l++) {
                        prop = ref1[l];
                        if (prop instanceof Assign && prop.context === 'object') {
                            isCompact = false;
                        }
                    }
                    answer = [];
                    answer.push(this.makeCode(isCompact ? '' : '\n'));
                    for (i = p = 0, len4 = props.length; p < len4; i = ++p) {
                        prop = props[i];
                        join = i === props.length - 1 ? '' : isCompact ? ', ' : prop === lastNode ? '\n' : ',\n';
                        indent = isCompact ? '' : idt;
                        key = prop instanceof Assign && prop.context === 'object' ? prop.variable : prop instanceof Assign ? (!this.lhs ? prop.operatorToken.error(`unexpected ${prop.operatorToken.value}`) : void 0, prop.variable) : prop;
                        if (key instanceof Value && key.hasProperties()) {
                            if (prop.context === 'object' || !key.this) {
                                key.error('invalid object key');
                            }
                            key = key.properties[0].name;
                            prop = new Assign(key, prop, 'object');
                        }
                        if (key === prop) {
                            if (prop.shouldCache()) {
                                [key, value] = prop.base.cache(o);
                                if (key instanceof IdentifierLiteral) {
                                    key = new PropertyName(key.value);
                                }
                                prop = new Assign(key, value, 'object');
                            }
                            else if (key instanceof Value && key.base instanceof ComputedPropertyName) {
                                // `{ [foo()] }` output as `{ [ref = foo()]: ref }`.
                                if (prop.base.value.shouldCache()) {
                                    [key, value] = prop.base.value.cache(o);
                                    if (key instanceof IdentifierLiteral) {
                                        key = new ComputedPropertyName(key.value);
                                    }
                                    prop = new Assign(key, value, 'object');
                                }
                                else {
                                    // `{ [expression] }` output as `{ [expression]: expression }`.
                                    prop = new Assign(key, prop.base.value, 'object');
                                }
                            }
                            else if (!(typeof prop.bareLiteral === "function" ? prop.bareLiteral(IdentifierLiteral) : void 0) && !(prop instanceof Splat)) {
                                prop = new Assign(prop, prop, 'object');
                            }
                        }
                        if (indent) {
                            answer.push(this.makeCode(indent));
                        }
                        answer.push(...prop.compileToFragments(o, LEVEL_TOP));
                        if (join) {
                            answer.push(this.makeCode(join));
                        }
                    }
                    answer.push(this.makeCode(isCompact ? '' : `\n${this.tab}`));
                    answer = this.wrapInBraces(answer);
                    if (this.front) {
                        return this.wrapInParentheses(answer);
                    }
                    else {
                        return answer;
                    }
                }
                assigns(name) {
                    var j, len1, prop, ref1;
                    ref1 = this.properties;
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        prop = ref1[j];
                        if (prop.assigns(name)) {
                            return true;
                        }
                    }
                    return false;
                }
                eachName(iterator) {
                    var j, len1, prop, ref1, results;
                    ref1 = this.properties;
                    results = [];
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        prop = ref1[j];
                        if (prop instanceof Assign && prop.context === 'object') {
                            prop = prop.value;
                        }
                        prop = prop.unwrapAll();
                        if (prop.eachName != null) {
                            results.push(prop.eachName(iterator));
                        }
                        else {
                            results.push(void 0);
                        }
                    }
                    return results;
                }
                compileCSXAttributes(o) {
                    var answer, i, j, join, len1, prop, props;
                    props = this.properties;
                    answer = [];
                    for (i = j = 0, len1 = props.length; j < len1; i = ++j) {
                        prop = props[i];
                        prop.csx = true;
                        join = i === props.length - 1 ? '' : ' ';
                        if (prop instanceof Splat) {
                            prop = new Literal(`{${prop.compile(o)}}`);
                        }
                        answer.push(...prop.compileToFragments(o, LEVEL_TOP));
                        answer.push(this.makeCode(join));
                    }
                    if (this.front) {
                        return this.wrapInParentheses(answer);
                    }
                    else {
                        return answer;
                    }
                }
            }
            ;
            Obj.prototype.children = ['properties'];
            return Obj;
        }).call(this);
        //### Arr
        // An array literal.
        exports.Arr = Arr = (function () {
            class Arr extends Base {
                constructor(objs, lhs1 = false) {
                    super();
                    this.lhs = lhs1;
                    this.objects = objs || [];
                }
                hasElision() {
                    var j, len1, obj, ref1;
                    ref1 = this.objects;
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        obj = ref1[j];
                        if (obj instanceof Elision) {
                            return true;
                        }
                    }
                    return false;
                }
                isAssignable() {
                    var i, j, len1, obj, ref1;
                    if (!this.objects.length) {
                        return false;
                    }
                    ref1 = this.objects;
                    for (i = j = 0, len1 = ref1.length; j < len1; i = ++j) {
                        obj = ref1[i];
                        if (obj instanceof Splat && i + 1 !== this.objects.length) {
                            return false;
                        }
                        if (!(obj.isAssignable() && (!obj.isAtomic || obj.isAtomic()))) {
                            return false;
                        }
                    }
                    return true;
                }
                shouldCache() {
                    return !this.isAssignable();
                }
                compileNode(o) {
                    var answer, compiledObjs, fragment, fragmentIndex, fragmentIsElision, fragments, includesLineCommentsOnNonFirstElement, index, j, k, l, len1, len2, len3, len4, len5, obj, objIndex, olen, p, passedElision, q, ref1, unwrappedObj;
                    if (!this.objects.length) {
                        return [this.makeCode('[]')];
                    }
                    o.indent += TAB;
                    fragmentIsElision = function (fragment) {
                        return fragmentsToText(fragment).trim() === ',';
                    };
                    // Detect if `Elisions` at the beginning of the array are processed (e.g. [, , , a]).
                    passedElision = false;
                    answer = [];
                    ref1 = this.objects;
                    for (objIndex = j = 0, len1 = ref1.length; j < len1; objIndex = ++j) {
                        obj = ref1[objIndex];
                        unwrappedObj = obj.unwrapAll();
                        // Let `compileCommentFragments` know to intersperse block comments
                        // into the fragments created when compiling this array.
                        if (unwrappedObj.comments && unwrappedObj.comments.filter(function (comment) {
                            return !comment.here;
                        }).length === 0) {
                            unwrappedObj.includeCommentFragments = YES;
                        }
                        // If this array is the left-hand side of an assignment, all its children
                        // are too.
                        if (this.lhs) {
                            if (unwrappedObj instanceof Arr || unwrappedObj instanceof Obj) {
                                unwrappedObj.lhs = true;
                            }
                        }
                    }
                    compiledObjs = (function () {
                        var k, len2, ref2, results;
                        ref2 = this.objects;
                        results = [];
                        for (k = 0, len2 = ref2.length; k < len2; k++) {
                            obj = ref2[k];
                            results.push(obj.compileToFragments(o, LEVEL_LIST));
                        }
                        return results;
                    }).call(this);
                    olen = compiledObjs.length;
                    // If `compiledObjs` includes newlines, we will output this as a multiline
                    // array (i.e. with a newline and indentation after the `[`). If an element
                    // contains line comments, that should also trigger multiline output since
                    // by definition line comments will introduce newlines into our output.
                    // The exception is if only the first element has line comments; in that
                    // case, output as the compact form if we otherwise would have, so that the
                    // first element’s line comments get output before or after the array.
                    includesLineCommentsOnNonFirstElement = false;
                    for (index = k = 0, len2 = compiledObjs.length; k < len2; index = ++k) {
                        fragments = compiledObjs[index];
                        for (l = 0, len3 = fragments.length; l < len3; l++) {
                            fragment = fragments[l];
                            if (fragment.isHereComment) {
                                fragment.code = fragment.code.trim();
                            }
                            else if (index !== 0 && includesLineCommentsOnNonFirstElement === false && hasLineComments(fragment)) {
                                includesLineCommentsOnNonFirstElement = true;
                            }
                        }
                        // Add ', ' if all `Elisions` from the beginning of the array are processed (e.g. [, , , a]) and
                        // element isn't `Elision` or last element is `Elision` (e.g. [a,,b,,])
                        if (index !== 0 && passedElision && (!fragmentIsElision(fragments) || index === olen - 1)) {
                            answer.push(this.makeCode(', '));
                        }
                        passedElision = passedElision || !fragmentIsElision(fragments);
                        answer.push(...fragments);
                    }
                    if (includesLineCommentsOnNonFirstElement || indexOf.call(fragmentsToText(answer), '\n') >= 0) {
                        for (fragmentIndex = p = 0, len4 = answer.length; p < len4; fragmentIndex = ++p) {
                            fragment = answer[fragmentIndex];
                            if (fragment.isHereComment) {
                                fragment.code = `${multident(fragment.code, o.indent, false)}\n${o.indent}`;
                            }
                            else if (fragment.code === ', ' && !(fragment != null ? fragment.isElision : void 0)) {
                                fragment.code = `,\n${o.indent}`;
                            }
                        }
                        answer.unshift(this.makeCode(`[\n${o.indent}`));
                        answer.push(this.makeCode(`\n${this.tab}]`));
                    }
                    else {
                        for (q = 0, len5 = answer.length; q < len5; q++) {
                            fragment = answer[q];
                            if (fragment.isHereComment) {
                                fragment.code = `${fragment.code} `;
                            }
                        }
                        answer.unshift(this.makeCode('['));
                        answer.push(this.makeCode(']'));
                    }
                    return answer;
                }
                assigns(name) {
                    var j, len1, obj, ref1;
                    ref1 = this.objects;
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        obj = ref1[j];
                        if (obj.assigns(name)) {
                            return true;
                        }
                    }
                    return false;
                }
                eachName(iterator) {
                    var j, len1, obj, ref1, results;
                    ref1 = this.objects;
                    results = [];
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        obj = ref1[j];
                        obj = obj.unwrapAll();
                        results.push(obj.eachName(iterator));
                    }
                    return results;
                }
            }
            ;
            Arr.prototype.children = ['objects'];
            return Arr;
        }).call(this);
        //### Class
        // The CoffeeScript class definition.
        // Initialize a **Class** with its name, an optional superclass, and a body.
        exports.Class = Class = (function () {
            class Class extends Base {
                constructor(variable1, parent1, body1 = new Block) {
                    super();
                    this.variable = variable1;
                    this.parent = parent1;
                    this.body = body1;
                }
                compileNode(o) {
                    var executableBody, node, parentName;
                    this.name = this.determineName();
                    executableBody = this.walkBody();
                    if (this.parent instanceof Value && !this.parent.hasProperties()) {
                        // Special handling to allow `class expr.A extends A` declarations
                        parentName = this.parent.base.value;
                    }
                    this.hasNameClash = (this.name != null) && this.name === parentName;
                    node = this;
                    if (executableBody || this.hasNameClash) {
                        node = new ExecutableClassBody(node, executableBody);
                    }
                    else if ((this.name == null) && o.level === LEVEL_TOP) {
                        // Anonymous classes are only valid in expressions
                        node = new Parens(node);
                    }
                    if (this.boundMethods.length && this.parent) {
                        if (this.variable == null) {
                            this.variable = new IdentifierLiteral(o.scope.freeVariable('_class'));
                        }
                        if (this.variableRef == null) {
                            [this.variable, this.variableRef] = this.variable.cache(o);
                        }
                    }
                    if (this.variable) {
                        node = new Assign(this.variable, node, null, { moduleDeclaration: this.moduleDeclaration });
                    }
                    this.compileNode = this.compileClassDeclaration;
                    try {
                        return node.compileToFragments(o);
                    }
                    finally {
                        delete this.compileNode;
                    }
                }
                compileClassDeclaration(o) {
                    var ref1, ref2, result;
                    if (this.externalCtor || this.boundMethods.length) {
                        if (this.ctor == null) {
                            this.ctor = this.makeDefaultConstructor();
                        }
                    }
                    if ((ref1 = this.ctor) != null) {
                        ref1.noReturn = true;
                    }
                    if (this.boundMethods.length) {
                        this.proxyBoundMethods();
                    }
                    o.indent += TAB;
                    result = [];
                    result.push(this.makeCode("class "));
                    if (this.name) {
                        result.push(this.makeCode(this.name));
                    }
                    if (((ref2 = this.variable) != null ? ref2.comments : void 0) != null) {
                        this.compileCommentFragments(o, this.variable, result);
                    }
                    if (this.name) {
                        result.push(this.makeCode(' '));
                    }
                    if (this.parent) {
                        result.push(this.makeCode('extends '), ...this.parent.compileToFragments(o), this.makeCode(' '));
                    }
                    result.push(this.makeCode('{'));
                    if (!this.body.isEmpty()) {
                        this.body.spaced = true;
                        result.push(this.makeCode('\n'));
                        result.push(...this.body.compileToFragments(o, LEVEL_TOP));
                        result.push(this.makeCode(`\n${this.tab}`));
                    }
                    result.push(this.makeCode('}'));
                    return result;
                }
                // Figure out the appropriate name for this class
                determineName() {
                    var message, name, node, ref1, tail;
                    if (!this.variable) {
                        return null;
                    }
                    ref1 = this.variable.properties, [tail] = slice1.call(ref1, -1);
                    node = tail ? tail instanceof Access && tail.name : this.variable.base;
                    if (!(node instanceof IdentifierLiteral || node instanceof PropertyName)) {
                        return null;
                    }
                    name = node.value;
                    if (!tail) {
                        message = isUnassignable(name);
                        if (message) {
                            this.variable.error(message);
                        }
                    }
                    if (indexOf.call(JS_FORBIDDEN, name) >= 0) {
                        return `_${name}`;
                    }
                    else {
                        return name;
                    }
                }
                walkBody() {
                    var assign, end, executableBody, expression, expressions, exprs, i, initializer, initializerExpression, j, k, len1, len2, method, properties, pushSlice, ref1, start;
                    this.ctor = null;
                    this.boundMethods = [];
                    executableBody = null;
                    initializer = [];
                    ({ expressions } = this.body);
                    i = 0;
                    ref1 = expressions.slice();
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        expression = ref1[j];
                        if (expression instanceof Value && expression.isObject(true)) {
                            ({ properties } = expression.base);
                            exprs = [];
                            end = 0;
                            start = 0;
                            pushSlice = function () {
                                if (end > start) {
                                    return exprs.push(new Value(new Obj(properties.slice(start, end), true)));
                                }
                            };
                            while (assign = properties[end]) {
                                if (initializerExpression = this.addInitializerExpression(assign)) {
                                    pushSlice();
                                    exprs.push(initializerExpression);
                                    initializer.push(initializerExpression);
                                    start = end + 1;
                                }
                                end++;
                            }
                            pushSlice();
                            splice.apply(expressions, [i, i - i + 1].concat(exprs)), exprs;
                            i += exprs.length;
                        }
                        else {
                            if (initializerExpression = this.addInitializerExpression(expression)) {
                                initializer.push(initializerExpression);
                                expressions[i] = initializerExpression;
                            }
                            i += 1;
                        }
                    }
                    for (k = 0, len2 = initializer.length; k < len2; k++) {
                        method = initializer[k];
                        if (method instanceof Code) {
                            if (method.ctor) {
                                if (this.ctor) {
                                    method.error('Cannot define more than one constructor in a class');
                                }
                                this.ctor = method;
                            }
                            else if (method.isStatic && method.bound) {
                                method.context = this.name;
                            }
                            else if (method.bound) {
                                this.boundMethods.push(method);
                            }
                        }
                    }
                    if (initializer.length !== expressions.length) {
                        this.body.expressions = (function () {
                            var l, len3, results;
                            results = [];
                            for (l = 0, len3 = initializer.length; l < len3; l++) {
                                expression = initializer[l];
                                results.push(expression.hoist());
                            }
                            return results;
                        })();
                        return new Block(expressions);
                    }
                }
                // Add an expression to the class initializer
                // This is the key method for determining whether an expression in a class
                // body should appear in the initializer or the executable body. If the given
                // `node` is valid in a class body the method will return a (new, modified,
                // or identical) node for inclusion in the class initializer, otherwise
                // nothing will be returned and the node will appear in the executable body.
                // At time of writing, only methods (instance and static) are valid in ES
                // class initializers. As new ES class features (such as class fields) reach
                // Stage 4, this method will need to be updated to support them. We
                // additionally allow `PassthroughLiteral`s (backticked expressions) in the
                // initializer as an escape hatch for ES features that are not implemented
                // (e.g. getters and setters defined via the `get` and `set` keywords as
                // opposed to the `Object.defineProperty` method).
                addInitializerExpression(node) {
                    if (node.unwrapAll() instanceof PassthroughLiteral) {
                        return node;
                    }
                    else if (this.validInitializerMethod(node)) {
                        return this.addInitializerMethod(node);
                    }
                    else {
                        return null;
                    }
                }
                // Checks if the given node is a valid ES class initializer method.
                validInitializerMethod(node) {
                    if (!(node instanceof Assign && node.value instanceof Code)) {
                        return false;
                    }
                    if (node.context === 'object' && !node.variable.hasProperties()) {
                        return true;
                    }
                    return node.variable.looksStatic(this.name) && (this.name || !node.value.bound);
                }
                // Returns a configured class initializer method
                addInitializerMethod(assign) {
                    var method, methodName, variable;
                    ({
                        variable,
                        value: method
                    } = assign);
                    method.isMethod = true;
                    method.isStatic = variable.looksStatic(this.name);
                    if (method.isStatic) {
                        method.name = variable.properties[0];
                    }
                    else {
                        methodName = variable.base;
                        method.name = new (methodName.shouldCache() ? Index : Access)(methodName);
                        method.name.updateLocationDataIfMissing(methodName.locationData);
                        if (methodName.value === 'constructor') {
                            method.ctor = (this.parent ? 'derived' : 'base');
                        }
                        if (method.bound && method.ctor) {
                            method.error('Cannot define a constructor as a bound (fat arrow) function');
                        }
                    }
                    return method;
                }
                makeDefaultConstructor() {
                    var applyArgs, applyCtor, ctor;
                    ctor = this.addInitializerMethod(new Assign(new Value(new PropertyName('constructor')), new Code));
                    this.body.unshift(ctor);
                    if (this.parent) {
                        ctor.body.push(new SuperCall(new Super, [new Splat(new IdentifierLiteral('arguments'))]));
                    }
                    if (this.externalCtor) {
                        applyCtor = new Value(this.externalCtor, [new Access(new PropertyName('apply'))]);
                        applyArgs = [new ThisLiteral, new IdentifierLiteral('arguments')];
                        ctor.body.push(new Call(applyCtor, applyArgs));
                        ctor.body.makeReturn();
                    }
                    return ctor;
                }
                proxyBoundMethods() {
                    var method, name;
                    this.ctor.thisAssignments = (function () {
                        var j, len1, ref1, results;
                        ref1 = this.boundMethods;
                        results = [];
                        for (j = 0, len1 = ref1.length; j < len1; j++) {
                            method = ref1[j];
                            if (this.parent) {
                                method.classVariable = this.variableRef;
                            }
                            name = new Value(new ThisLiteral, [method.name]);
                            results.push(new Assign(name, new Call(new Value(name, [new Access(new PropertyName('bind'))]), [new ThisLiteral])));
                        }
                        return results;
                    }).call(this);
                    return null;
                }
            }
            ;
            Class.prototype.children = ['variable', 'parent', 'body'];
            return Class;
        }).call(this);
        exports.ExecutableClassBody = ExecutableClassBody = (function () {
            class ExecutableClassBody extends Base {
                constructor(_class, body1 = new Block) {
                    super();
                    this.class = _class;
                    this.body = body1;
                }
                compileNode(o) {
                    var args, argumentsNode, directives, externalCtor, ident, jumpNode, klass, params, parent, ref1, wrapper;
                    if (jumpNode = this.body.jumps()) {
                        jumpNode.error('Class bodies cannot contain pure statements');
                    }
                    if (argumentsNode = this.body.contains(isLiteralArguments)) {
                        argumentsNode.error("Class bodies shouldn't reference arguments");
                    }
                    params = [];
                    args = [new ThisLiteral];
                    wrapper = new Code(params, this.body);
                    klass = new Parens(new Call(new Value(wrapper, [new Access(new PropertyName('call'))]), args));
                    this.body.spaced = true;
                    o.classScope = wrapper.makeScope(o.scope);
                    this.name = (ref1 = this.class.name) != null ? ref1 : o.classScope.freeVariable(this.defaultClassVariableName);
                    ident = new IdentifierLiteral(this.name);
                    directives = this.walkBody();
                    this.setContext();
                    if (this.class.hasNameClash) {
                        parent = new IdentifierLiteral(o.classScope.freeVariable('superClass'));
                        wrapper.params.push(new Param(parent));
                        args.push(this.class.parent);
                        this.class.parent = parent;
                    }
                    if (this.externalCtor) {
                        externalCtor = new IdentifierLiteral(o.classScope.freeVariable('ctor', {
                            reserve: false
                        }));
                        this.class.externalCtor = externalCtor;
                        this.externalCtor.variable.base = externalCtor;
                    }
                    if (this.name !== this.class.name) {
                        this.body.expressions.unshift(new Assign(new IdentifierLiteral(this.name), this.class));
                    }
                    else {
                        this.body.expressions.unshift(this.class);
                    }
                    this.body.expressions.unshift(...directives);
                    this.body.push(ident);
                    return klass.compileToFragments(o);
                }
                // Traverse the class's children and:
                // - Hoist valid ES properties into `@properties`
                // - Hoist static assignments into `@properties`
                // - Convert invalid ES properties into class or prototype assignments
                walkBody() {
                    var directives, expr, index;
                    directives = [];
                    index = 0;
                    while (expr = this.body.expressions[index]) {
                        if (!(expr instanceof Value && expr.isString())) {
                            break;
                        }
                        if (expr.hoisted) {
                            index++;
                        }
                        else {
                            directives.push(...this.body.expressions.splice(index, 1));
                        }
                    }
                    this.traverseChildren(false, (child) => {
                        var cont, i, j, len1, node, ref1;
                        if (child instanceof Class || child instanceof HoistTarget) {
                            return false;
                        }
                        cont = true;
                        if (child instanceof Block) {
                            ref1 = child.expressions;
                            for (i = j = 0, len1 = ref1.length; j < len1; i = ++j) {
                                node = ref1[i];
                                if (node instanceof Value && node.isObject(true)) {
                                    cont = false;
                                    child.expressions[i] = this.addProperties(node.base.properties);
                                }
                                else if (node instanceof Assign && node.variable.looksStatic(this.name)) {
                                    node.value.isStatic = true;
                                }
                            }
                            child.expressions = flatten(child.expressions);
                        }
                        return cont;
                    });
                    return directives;
                }
                setContext() {
                    return this.body.traverseChildren(false, (node) => {
                        if (node instanceof ThisLiteral) {
                            return node.value = this.name;
                        }
                        else if (node instanceof Code && node.bound && node.isStatic) {
                            return node.context = this.name;
                        }
                    });
                }
                // Make class/prototype assignments for invalid ES properties
                addProperties(assigns) {
                    var assign, base, name, prototype, result, value, variable;
                    result = (function () {
                        var j, len1, results;
                        results = [];
                        for (j = 0, len1 = assigns.length; j < len1; j++) {
                            assign = assigns[j];
                            variable = assign.variable;
                            base = variable != null ? variable.base : void 0;
                            value = assign.value;
                            delete assign.context;
                            if (base.value === 'constructor') {
                                if (value instanceof Code) {
                                    base.error('constructors must be defined at the top level of a class body');
                                }
                                // The class scope is not available yet, so return the assignment to update later
                                assign = this.externalCtor = new Assign(new Value, value);
                            }
                            else if (!assign.variable.this) {
                                name = new (base.shouldCache() ? Index : Access)(base);
                                prototype = new Access(new PropertyName('prototype'));
                                variable = new Value(new ThisLiteral(), [prototype, name]);
                                assign.variable = variable;
                            }
                            else if (assign.value instanceof Code) {
                                assign.value.isStatic = true;
                            }
                            results.push(assign);
                        }
                        return results;
                    }).call(this);
                    return compact(result);
                }
            }
            ;
            ExecutableClassBody.prototype.children = ['class', 'body'];
            ExecutableClassBody.prototype.defaultClassVariableName = '_Class';
            return ExecutableClassBody;
        }).call(this);
        //### Import and Export
        exports.ModuleDeclaration = ModuleDeclaration = (function () {
            class ModuleDeclaration extends Base {
                constructor(clause, source1) {
                    super();
                    this.clause = clause;
                    this.source = source1;
                    this.checkSource();
                }
                checkSource() {
                    if ((this.source != null) && this.source instanceof StringWithInterpolations) {
                        return this.source.error('the name of the module to be imported from must be an uninterpolated string');
                    }
                }
                checkScope(o, moduleDeclarationType) {
                    if (o.indent.length !== 0) {
                        return this.error(`${moduleDeclarationType} statements must be at top-level scope`);
                    }
                }
            }
            ;
            ModuleDeclaration.prototype.children = ['clause', 'source'];
            ModuleDeclaration.prototype.isStatement = YES;
            ModuleDeclaration.prototype.jumps = THIS;
            ModuleDeclaration.prototype.makeReturn = THIS;
            return ModuleDeclaration;
        }).call(this);
        exports.ImportDeclaration = ImportDeclaration = class ImportDeclaration extends ModuleDeclaration {
            compileNode(o) {
                var code, ref1;
                this.checkScope(o, 'import');
                o.importedSymbols = [];
                code = [];
                code.push(this.makeCode(`${this.tab}import `));
                if (this.clause != null) {
                    code.push(...this.clause.compileNode(o));
                }
                if (((ref1 = this.source) != null ? ref1.value : void 0) != null) {
                    if (this.clause !== null) {
                        code.push(this.makeCode(' from '));
                    }
                    code.push(this.makeCode(this.source.value));
                }
                code.push(this.makeCode(';'));
                return code;
            }
        };
        exports.ImportClause = ImportClause = (function () {
            class ImportClause extends Base {
                constructor(defaultBinding, namedImports) {
                    super();
                    this.defaultBinding = defaultBinding;
                    this.namedImports = namedImports;
                }
                compileNode(o) {
                    var code;
                    code = [];
                    if (this.defaultBinding != null) {
                        code.push(...this.defaultBinding.compileNode(o));
                        if (this.namedImports != null) {
                            code.push(this.makeCode(', '));
                        }
                    }
                    if (this.namedImports != null) {
                        code.push(...this.namedImports.compileNode(o));
                    }
                    return code;
                }
            }
            ;
            ImportClause.prototype.children = ['defaultBinding', 'namedImports'];
            return ImportClause;
        }).call(this);
        exports.ExportDeclaration = ExportDeclaration = class ExportDeclaration extends ModuleDeclaration {
            compileNode(o) {
                var code, ref1;
                this.checkScope(o, 'export');
                code = [];
                code.push(this.makeCode(`${this.tab}export `));
                if (this instanceof ExportDefaultDeclaration) {
                    code.push(this.makeCode('default '));
                }
                if (!(this instanceof ExportDefaultDeclaration) && (this.clause instanceof Assign || this.clause instanceof Class)) {
                    // Prevent exporting an anonymous class; all exported members must be named
                    if (this.clause instanceof Class && !this.clause.variable) {
                        this.clause.error('anonymous classes cannot be exported');
                    }
                    code.push(this.makeCode('var '));
                    this.clause.moduleDeclaration = 'export';
                }
                if ((this.clause.body != null) && this.clause.body instanceof Block) {
                    code = code.concat(this.clause.compileToFragments(o, LEVEL_TOP));
                }
                else {
                    code = code.concat(this.clause.compileNode(o));
                }
                if (((ref1 = this.source) != null ? ref1.value : void 0) != null) {
                    code.push(this.makeCode(` from ${this.source.value}`));
                }
                code.push(this.makeCode(';'));
                return code;
            }
        };
        exports.ExportNamedDeclaration = ExportNamedDeclaration = class ExportNamedDeclaration extends ExportDeclaration {
        };
        exports.ExportDefaultDeclaration = ExportDefaultDeclaration = class ExportDefaultDeclaration extends ExportDeclaration {
        };
        exports.ExportAllDeclaration = ExportAllDeclaration = class ExportAllDeclaration extends ExportDeclaration {
        };
        exports.ModuleSpecifierList = ModuleSpecifierList = (function () {
            class ModuleSpecifierList extends Base {
                constructor(specifiers) {
                    super();
                    this.specifiers = specifiers;
                }
                compileNode(o) {
                    var code, compiledList, fragments, index, j, len1, specifier;
                    code = [];
                    o.indent += TAB;
                    compiledList = (function () {
                        var j, len1, ref1, results;
                        ref1 = this.specifiers;
                        results = [];
                        for (j = 0, len1 = ref1.length; j < len1; j++) {
                            specifier = ref1[j];
                            results.push(specifier.compileToFragments(o, LEVEL_LIST));
                        }
                        return results;
                    }).call(this);
                    if (this.specifiers.length !== 0) {
                        code.push(this.makeCode(`{\n${o.indent}`));
                        for (index = j = 0, len1 = compiledList.length; j < len1; index = ++j) {
                            fragments = compiledList[index];
                            if (index) {
                                code.push(this.makeCode(`,\n${o.indent}`));
                            }
                            code.push(...fragments);
                        }
                        code.push(this.makeCode("\n}"));
                    }
                    else {
                        code.push(this.makeCode('{}'));
                    }
                    return code;
                }
            }
            ;
            ModuleSpecifierList.prototype.children = ['specifiers'];
            return ModuleSpecifierList;
        }).call(this);
        exports.ImportSpecifierList = ImportSpecifierList = class ImportSpecifierList extends ModuleSpecifierList {
        };
        exports.ExportSpecifierList = ExportSpecifierList = class ExportSpecifierList extends ModuleSpecifierList {
        };
        exports.ModuleSpecifier = ModuleSpecifier = (function () {
            class ModuleSpecifier extends Base {
                constructor(original, alias, moduleDeclarationType1) {
                    var ref1, ref2;
                    super();
                    this.original = original;
                    this.alias = alias;
                    this.moduleDeclarationType = moduleDeclarationType1;
                    if (this.original.comments || ((ref1 = this.alias) != null ? ref1.comments : void 0)) {
                        this.comments = [];
                        if (this.original.comments) {
                            this.comments.push(...this.original.comments);
                        }
                        if ((ref2 = this.alias) != null ? ref2.comments : void 0) {
                            this.comments.push(...this.alias.comments);
                        }
                    }
                    // The name of the variable entering the local scope
                    this.identifier = this.alias != null ? this.alias.value : this.original.value;
                }
                compileNode(o) {
                    var code;
                    o.scope.find(this.identifier, this.moduleDeclarationType);
                    code = [];
                    code.push(this.makeCode(this.original.value));
                    if (this.alias != null) {
                        code.push(this.makeCode(` as ${this.alias.value}`));
                    }
                    return code;
                }
            }
            ;
            ModuleSpecifier.prototype.children = ['original', 'alias'];
            return ModuleSpecifier;
        }).call(this);
        exports.ImportSpecifier = ImportSpecifier = class ImportSpecifier extends ModuleSpecifier {
            constructor(imported, local) {
                super(imported, local, 'import');
            }
            compileNode(o) {
                var ref1;
                // Per the spec, symbols can’t be imported multiple times
                // (e.g. `import { foo, foo } from 'lib'` is invalid)
                if ((ref1 = this.identifier, indexOf.call(o.importedSymbols, ref1) >= 0) || o.scope.check(this.identifier)) {
                    this.error(`'${this.identifier}' has already been declared`);
                }
                else {
                    o.importedSymbols.push(this.identifier);
                }
                return super.compileNode(o);
            }
        };
        exports.ImportDefaultSpecifier = ImportDefaultSpecifier = class ImportDefaultSpecifier extends ImportSpecifier {
        };
        exports.ImportNamespaceSpecifier = ImportNamespaceSpecifier = class ImportNamespaceSpecifier extends ImportSpecifier {
        };
        exports.ExportSpecifier = ExportSpecifier = class ExportSpecifier extends ModuleSpecifier {
            constructor(local, exported) {
                super(local, exported, 'export');
            }
        };
        //### Assign
        // The **Assign** is used to assign a local variable to value, or to set the
        // property of an object -- including within object literals.
        exports.Assign = Assign = (function () {
            class Assign extends Base {
                constructor(variable1, value1, context1, options = {}) {
                    super();
                    this.variable = variable1;
                    this.value = value1;
                    this.context = context1;
                    ({ param: this.param, subpattern: this.subpattern, operatorToken: this.operatorToken, moduleDeclaration: this.moduleDeclaration } = options);
                }
                isStatement(o) {
                    return (o != null ? o.level : void 0) === LEVEL_TOP && (this.context != null) && (this.moduleDeclaration || indexOf.call(this.context, "?") >= 0);
                }
                checkAssignability(o, varBase) {
                    if (Object.prototype.hasOwnProperty.call(o.scope.positions, varBase.value) && o.scope.variables[o.scope.positions[varBase.value]].type === 'import') {
                        return varBase.error(`'${varBase.value}' is read-only`);
                    }
                }
                assigns(name) {
                    return this[this.context === 'object' ? 'value' : 'variable'].assigns(name);
                }
                unfoldSoak(o) {
                    return unfoldSoak(o, this, 'variable');
                }
                // Compile an assignment, delegating to `compileDestructuring` or
                // `compileSplice` if appropriate. Keep track of the name of the base object
                // we've been assigned to, for correct internal references. If the variable
                // has not been seen yet within the current scope, declare it.
                compileNode(o) {
                    var answer, compiledName, isValue, name, properties, prototype, ref1, ref2, ref3, ref4, ref5, val, varBase;
                    isValue = this.variable instanceof Value;
                    if (isValue) {
                        // When compiling `@variable`, remember if it is part of a function parameter.
                        this.variable.param = this.param;
                        // If `@variable` is an array or an object, we’re destructuring;
                        // if it’s also `isAssignable()`, the destructuring syntax is supported
                        // in ES and we can output it as is; otherwise we `@compileDestructuring`
                        // and convert this ES-unsupported destructuring into acceptable output.
                        if (this.variable.isArray() || this.variable.isObject()) {
                            // This is the left-hand side of an assignment; let `Arr` and `Obj`
                            // know that, so that those nodes know that they’re assignable as
                            // destructured variables.
                            this.variable.base.lhs = true;
                            if (!this.variable.isAssignable()) {
                                if (this.variable.isObject() && this.variable.base.hasSplat()) {
                                    return this.compileObjectDestruct(o);
                                }
                                else {
                                    return this.compileDestructuring(o);
                                }
                            }
                        }
                        if (this.variable.isSplice()) {
                            return this.compileSplice(o);
                        }
                        if ((ref1 = this.context) === '||=' || ref1 === '&&=' || ref1 === '?=') {
                            return this.compileConditional(o);
                        }
                        if ((ref2 = this.context) === '//=' || ref2 === '%%=') {
                            return this.compileSpecialMath(o);
                        }
                    }
                    if (!this.context || this.context === '**=') {
                        varBase = this.variable.unwrapAll();
                        if (!varBase.isAssignable()) {
                            this.variable.error(`'${this.variable.compile(o)}' can't be assigned`);
                        }
                        varBase.eachName((name) => {
                            var commentFragments, commentsNode, message;
                            if (typeof name.hasProperties === "function" ? name.hasProperties() : void 0) {
                                return;
                            }
                            message = isUnassignable(name.value);
                            if (message) {
                                name.error(message);
                            }
                            // `moduleDeclaration` can be `'import'` or `'export'`.
                            this.checkAssignability(o, name);
                            if (this.moduleDeclaration) {
                                return o.scope.add(name.value, this.moduleDeclaration);
                            }
                            else if (this.param) {
                                return o.scope.add(name.value, this.param === 'alwaysDeclare' ? 'var' : 'param');
                            }
                            else {
                                o.scope.find(name.value);
                                // If this assignment identifier has one or more herecomments
                                // attached, output them as part of the declarations line (unless
                                // other herecomments are already staged there) for compatibility
                                // with Flow typing. Don’t do this if this assignment is for a
                                // class, e.g. `ClassName = class ClassName {`, as Flow requires
                                // the comment to be between the class name and the `{`.
                                if (name.comments && !o.scope.comments[name.value] && !(this.value instanceof Class) && name.comments.every(function (comment) {
                                    return comment.here && !comment.multiline;
                                })) {
                                    commentsNode = new IdentifierLiteral(name.value);
                                    commentsNode.comments = name.comments;
                                    commentFragments = [];
                                    this.compileCommentFragments(o, commentsNode, commentFragments);
                                    return o.scope.comments[name.value] = commentFragments;
                                }
                            }
                        });
                    }
                    if (this.value instanceof Code) {
                        if (this.value.isStatic) {
                            this.value.name = this.variable.properties[0];
                        }
                        else if (((ref3 = this.variable.properties) != null ? ref3.length : void 0) >= 2) {
                            ref4 = this.variable.properties, [...properties] = ref4, [prototype, name] = splice.call(properties, -2);
                            if (((ref5 = prototype.name) != null ? ref5.value : void 0) === 'prototype') {
                                this.value.name = name;
                            }
                        }
                    }
                    if (this.csx) {
                        this.value.base.csxAttribute = true;
                    }
                    val = this.value.compileToFragments(o, LEVEL_LIST);
                    compiledName = this.variable.compileToFragments(o, LEVEL_LIST);
                    if (this.context === 'object') {
                        if (this.variable.shouldCache()) {
                            compiledName.unshift(this.makeCode('['));
                            compiledName.push(this.makeCode(']'));
                        }
                        return compiledName.concat(this.makeCode(this.csx ? '=' : ': '), val);
                    }
                    answer = compiledName.concat(this.makeCode(` ${this.context || '='} `), val);
                    // Per https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Operators/Destructuring_assignment#Assignment_without_declaration,
                    // if we’re destructuring without declaring, the destructuring assignment must be wrapped in parentheses.
                    // The assignment is wrapped in parentheses if 'o.level' has lower precedence than LEVEL_LIST (3)
                    // (i.e. LEVEL_COND (4), LEVEL_OP (5) or LEVEL_ACCESS (6)), or if we're destructuring object, e.g. {a,b} = obj.
                    if (o.level > LEVEL_LIST || isValue && this.variable.base instanceof Obj && !this.nestedLhs && !(this.param === true)) {
                        return this.wrapInParentheses(answer);
                    }
                    else {
                        return answer;
                    }
                }
                // Object rest property is not assignable: `{{a}...}`
                compileObjectDestruct(o) {
                    var assigns, props, refVal, splat, splatProp;
                    this.variable.base.reorderProperties();
                    ({
                        properties: props
                    } = this.variable.base);
                    [splat] = slice1.call(props, -1);
                    splatProp = splat.name;
                    assigns = [];
                    refVal = new Value(new IdentifierLiteral(o.scope.freeVariable('ref')));
                    props.splice(-1, 1, new Splat(refVal));
                    assigns.push(new Assign(new Value(new Obj(props)), this.value).compileToFragments(o, LEVEL_LIST));
                    assigns.push(new Assign(new Value(splatProp), refVal).compileToFragments(o, LEVEL_LIST));
                    return this.joinFragmentArrays(assigns, ', ');
                }
                // Brief implementation of recursive pattern matching, when assigning array or
                // object literals to a value. Peeks at their properties to assign inner names.
                compileDestructuring(o) {
                    var assignObjects, assigns, code, compSlice, compSplice, complexObjects, expIdx, expans, fragments, hasObjAssigns, i, isExpans, isSplat, leftObjs, loopObjects, obj, objIsUnassignable, objects, olen, processObjects, pushAssign, ref, refExp, restVar, rightObjs, slicer, splatVar, splatVarAssign, splatVarRef, splats, splatsAndExpans, top, value, vvar, vvarText;
                    top = o.level === LEVEL_TOP;
                    ({ value } = this);
                    ({ objects } = this.variable.base);
                    olen = objects.length;
                    // Special-case for `{} = a` and `[] = a` (empty patterns).
                    // Compile to simply `a`.
                    if (olen === 0) {
                        code = value.compileToFragments(o);
                        if (o.level >= LEVEL_OP) {
                            return this.wrapInParentheses(code);
                        }
                        else {
                            return code;
                        }
                    }
                    [obj] = objects;
                    // Disallow `[...] = a` for some reason. (Could be equivalent to `[] = a`?)
                    if (olen === 1 && obj instanceof Expansion) {
                        obj.error('Destructuring assignment has no target');
                    }
                    // Count all `Splats`: [a, b, c..., d, e]
                    splats = (function () {
                        var j, len1, results;
                        results = [];
                        for (i = j = 0, len1 = objects.length; j < len1; i = ++j) {
                            obj = objects[i];
                            if (obj instanceof Splat) {
                                results.push(i);
                            }
                        }
                        return results;
                    })();
                    // Count all `Expansions`: [a, b, ..., c, d]
                    expans = (function () {
                        var j, len1, results;
                        results = [];
                        for (i = j = 0, len1 = objects.length; j < len1; i = ++j) {
                            obj = objects[i];
                            if (obj instanceof Expansion) {
                                results.push(i);
                            }
                        }
                        return results;
                    })();
                    // Combine splats and expansions.
                    splatsAndExpans = [...splats, ...expans];
                    // Show error if there is more than one `Splat`, or `Expansion`.
                    // Examples: [a, b, c..., d, e, f...], [a, b, ..., c, d, ...], [a, b, ..., c, d, e...]
                    if (splatsAndExpans.length > 1) {
                        // Sort 'splatsAndExpans' so we can show error at first disallowed token.
                        objects[splatsAndExpans.sort()[1]].error("multiple splats/expansions are disallowed in an assignment");
                    }
                    isSplat = (splats != null ? splats.length : void 0) > 0;
                    isExpans = (expans != null ? expans.length : void 0) > 0;
                    vvar = value.compileToFragments(o, LEVEL_LIST);
                    vvarText = fragmentsToText(vvar);
                    assigns = [];
                    pushAssign = (variable, val) => {
                        return assigns.push(new Assign(variable, val, null, {
                            param: this.param,
                            subpattern: true
                        }).compileToFragments(o, LEVEL_LIST));
                    };
                    if (isSplat) {
                        splatVar = objects[splats[0]].name.unwrap();
                        if (splatVar instanceof Arr || splatVar instanceof Obj) {
                            splatVarRef = new IdentifierLiteral(o.scope.freeVariable('ref'));
                            objects[splats[0]].name = splatVarRef;
                            splatVarAssign = function () {
                                return pushAssign(new Value(splatVar), splatVarRef);
                            };
                        }
                    }
                    // At this point, there are several things to destructure. So the `fn()` in
                    // `{a, b} = fn()` must be cached, for example. Make vvar into a simple
                    // variable if it isn’t already.
                    if (!(value.unwrap() instanceof IdentifierLiteral) || this.variable.assigns(vvarText)) {
                        ref = o.scope.freeVariable('ref');
                        assigns.push([this.makeCode(ref + ' = '), ...vvar]);
                        vvar = [this.makeCode(ref)];
                        vvarText = ref;
                    }
                    slicer = function (type) {
                        return function (vvar, start, end = false) {
                            var args, slice;
                            if (!(vvar instanceof Value)) {
                                vvar = new IdentifierLiteral(vvar);
                            }
                            args = [vvar, new NumberLiteral(start)];
                            if (end) {
                                args.push(new NumberLiteral(end));
                            }
                            slice = new Value(new IdentifierLiteral(utility(type, o)), [new Access(new PropertyName('call'))]);
                            return new Value(new Call(slice, args));
                        };
                    };
                    // Helper which outputs `[].slice` code.
                    compSlice = slicer("slice");
                    // Helper which outputs `[].splice` code.
                    compSplice = slicer("splice");
                    // Check if `objects` array contains any instance of `Assign`, e.g. {a:1}.
                    hasObjAssigns = function (objs) {
                        var j, len1, results;
                        results = [];
                        for (i = j = 0, len1 = objs.length; j < len1; i = ++j) {
                            obj = objs[i];
                            if (obj instanceof Assign && obj.context === 'object') {
                                results.push(i);
                            }
                        }
                        return results;
                    };
                    // Check if `objects` array contains any unassignable object.
                    objIsUnassignable = function (objs) {
                        var j, len1;
                        for (j = 0, len1 = objs.length; j < len1; j++) {
                            obj = objs[j];
                            if (!obj.isAssignable()) {
                                return true;
                            }
                        }
                        return false;
                    };
                    // `objects` are complex when there is object assign ({a:1}),
                    // unassignable object, or just a single node.
                    complexObjects = function (objs) {
                        return hasObjAssigns(objs).length || objIsUnassignable(objs) || olen === 1;
                    };
                    // "Complex" `objects` are processed in a loop.
                    // Examples: [a, b, {c, r...}, d], [a, ..., {b, r...}, c, d]
                    loopObjects = (objs, vvar, vvarTxt) => {
                        var acc, idx, j, len1, message, results, vval;
                        results = [];
                        for (i = j = 0, len1 = objs.length; j < len1; i = ++j) {
                            obj = objs[i];
                            if (obj instanceof Elision) {
                                // `Elision` can be skipped.
                                continue;
                            }
                            // If `obj` is {a: 1}
                            if (obj instanceof Assign && obj.context === 'object') {
                                ({
                                    variable: {
                                        base: idx
                                    },
                                    value: vvar
                                } = obj);
                                if (vvar instanceof Assign) {
                                    ({
                                        variable: vvar
                                    } = vvar);
                                }
                                idx = vvar.this ? vvar.properties[0].name : new PropertyName(vvar.unwrap().value);
                                acc = idx.unwrap() instanceof PropertyName;
                                vval = new Value(value, [new (acc ? Access : Index)(idx)]);
                            }
                            else {
                                // `obj` is [a...], {a...} or a
                                vvar = (function () {
                                    switch (false) {
                                        case !(obj instanceof Splat):
                                            return new Value(obj.name);
                                        default:
                                            return obj;
                                    }
                                })();
                                vval = (function () {
                                    switch (false) {
                                        case !(obj instanceof Splat):
                                            return compSlice(vvarTxt, i);
                                        default:
                                            return new Value(new Literal(vvarTxt), [new Index(new NumberLiteral(i))]);
                                    }
                                })();
                            }
                            message = isUnassignable(vvar.unwrap().value);
                            if (message) {
                                vvar.error(message);
                            }
                            results.push(pushAssign(vvar, vval));
                        }
                        return results;
                    };
                    // "Simple" `objects` can be split and compiled to arrays, [a, b, c] = arr, [a, b, c...] = arr
                    assignObjects = (objs, vvar, vvarTxt) => {
                        var vval;
                        vvar = new Value(new Arr(objs, true));
                        vval = vvarTxt instanceof Value ? vvarTxt : new Value(new Literal(vvarTxt));
                        return pushAssign(vvar, vval);
                    };
                    processObjects = function (objs, vvar, vvarTxt) {
                        if (complexObjects(objs)) {
                            return loopObjects(objs, vvar, vvarTxt);
                        }
                        else {
                            return assignObjects(objs, vvar, vvarTxt);
                        }
                    };
                    // In case there is `Splat` or `Expansion` in `objects`,
                    // we can split array in two simple subarrays.
                    // `Splat` [a, b, c..., d, e] can be split into  [a, b, c...] and [d, e].
                    // `Expansion` [a, b, ..., c, d] can be split into [a, b] and [c, d].
                    // Examples:
                    // a) `Splat`
                    //   CS: [a, b, c..., d, e] = arr
                    //   JS: [a, b, ...c] = arr, [d, e] = splice.call(c, -2)
                    // b) `Expansion`
                    //   CS: [a, b, ..., d, e] = arr
                    //   JS: [a, b] = arr, [d, e] = slice.call(arr, -2)
                    if (splatsAndExpans.length) {
                        expIdx = splatsAndExpans[0];
                        leftObjs = objects.slice(0, expIdx + (isSplat ? 1 : 0));
                        rightObjs = objects.slice(expIdx + 1);
                        if (leftObjs.length !== 0) {
                            processObjects(leftObjs, vvar, vvarText);
                        }
                        if (rightObjs.length !== 0) {
                            // Slice or splice `objects`.
                            refExp = (function () {
                                switch (false) {
                                    case !isSplat:
                                        return compSplice(new Value(objects[expIdx].name), rightObjs.length * -1);
                                    case !isExpans:
                                        return compSlice(vvarText, rightObjs.length * -1);
                                }
                            })();
                            if (complexObjects(rightObjs)) {
                                restVar = refExp;
                                refExp = o.scope.freeVariable('ref');
                                assigns.push([this.makeCode(refExp + ' = '), ...restVar.compileToFragments(o, LEVEL_LIST)]);
                            }
                            processObjects(rightObjs, vvar, refExp);
                        }
                    }
                    else {
                        // There is no `Splat` or `Expansion` in `objects`.
                        processObjects(objects, vvar, vvarText);
                    }
                    if (typeof splatVarAssign === "function") {
                        splatVarAssign();
                    }
                    if (!(top || this.subpattern)) {
                        assigns.push(vvar);
                    }
                    fragments = this.joinFragmentArrays(assigns, ', ');
                    if (o.level < LEVEL_LIST) {
                        return fragments;
                    }
                    else {
                        return this.wrapInParentheses(fragments);
                    }
                }
                // When compiling a conditional assignment, take care to ensure that the
                // operands are only evaluated once, even though we have to reference them
                // more than once.
                compileConditional(o) {
                    var fragments, left, right;
                    [left, right] = this.variable.cacheReference(o);
                    // Disallow conditional assignment of undefined variables.
                    if (!left.properties.length && left.base instanceof Literal && !(left.base instanceof ThisLiteral) && !o.scope.check(left.base.value)) {
                        this.variable.error(`the variable "${left.base.value}" can't be assigned with ${this.context} because it has not been declared before`);
                    }
                    if (indexOf.call(this.context, "?") >= 0) {
                        o.isExistentialEquals = true;
                        return new If(new Existence(left), right, {
                            type: 'if'
                        }).addElse(new Assign(right, this.value, '=')).compileToFragments(o);
                    }
                    else {
                        fragments = new Op(this.context.slice(0, -1), left, new Assign(right, this.value, '=')).compileToFragments(o);
                        if (o.level <= LEVEL_LIST) {
                            return fragments;
                        }
                        else {
                            return this.wrapInParentheses(fragments);
                        }
                    }
                }
                // Convert special math assignment operators like `a //= b` to the equivalent
                // extended form `a = a ** b` and then compiles that.
                compileSpecialMath(o) {
                    var left, right;
                    [left, right] = this.variable.cacheReference(o);
                    return new Assign(left, new Op(this.context.slice(0, -1), right, this.value)).compileToFragments(o);
                }
                // Compile the assignment from an array splice literal, using JavaScript's
                // `Array#splice` method.
                compileSplice(o) {
                    var answer, exclusive, from, fromDecl, fromRef, name, to, unwrappedVar, valDef, valRef;
                    ({
                        range: { from, to, exclusive }
                    } = this.variable.properties.pop());
                    unwrappedVar = this.variable.unwrapAll();
                    if (unwrappedVar.comments) {
                        moveComments(unwrappedVar, this);
                        delete this.variable.comments;
                    }
                    name = this.variable.compile(o);
                    if (from) {
                        [fromDecl, fromRef] = this.cacheToCodeFragments(from.cache(o, LEVEL_OP));
                    }
                    else {
                        fromDecl = fromRef = '0';
                    }
                    if (to) {
                        if ((from != null ? from.isNumber() : void 0) && to.isNumber()) {
                            to = to.compile(o) - fromRef;
                            if (!exclusive) {
                                to += 1;
                            }
                        }
                        else {
                            to = to.compile(o, LEVEL_ACCESS) + ' - ' + fromRef;
                            if (!exclusive) {
                                to += ' + 1';
                            }
                        }
                    }
                    else {
                        to = "9e9";
                    }
                    [valDef, valRef] = this.value.cache(o, LEVEL_LIST);
                    answer = [].concat(this.makeCode(`${utility('splice', o)}.apply(${name}, [${fromDecl}, ${to}].concat(`), valDef, this.makeCode(")), "), valRef);
                    if (o.level > LEVEL_TOP) {
                        return this.wrapInParentheses(answer);
                    }
                    else {
                        return answer;
                    }
                }
                eachName(iterator) {
                    return this.variable.unwrapAll().eachName(iterator);
                }
            }
            ;
            Assign.prototype.children = ['variable', 'value'];
            Assign.prototype.isAssignable = YES;
            return Assign;
        }).call(this);
        //### FuncGlyph
        exports.FuncGlyph = FuncGlyph = class FuncGlyph extends Base {
            constructor(glyph) {
                super();
                this.glyph = glyph;
            }
        };
        //### Code
        // A function definition. This is the only node that creates a new Scope.
        // When for the purposes of walking the contents of a function body, the Code
        // has no *children* -- they're within the inner scope.
        exports.Code = Code = (function () {
            class Code extends Base {
                constructor(params, body, funcGlyph, paramStart) {
                    var ref1;
                    super();
                    this.funcGlyph = funcGlyph;
                    this.paramStart = paramStart;
                    this.params = params || [];
                    this.body = body || new Block;
                    this.bound = ((ref1 = this.funcGlyph) != null ? ref1.glyph : void 0) === '=>';
                    this.isGenerator = false;
                    this.isAsync = false;
                    this.isMethod = false;
                    this.body.traverseChildren(false, (node) => {
                        if ((node instanceof Op && node.isYield()) || node instanceof YieldReturn) {
                            this.isGenerator = true;
                        }
                        if ((node instanceof Op && node.isAwait()) || node instanceof AwaitReturn) {
                            this.isAsync = true;
                        }
                        if (node instanceof For && node.isAwait()) {
                            return this.isAsync = true;
                        }
                    });
                }
                isStatement() {
                    return this.isMethod;
                }
                makeScope(parentScope) {
                    return new Scope(parentScope, this.body, this);
                }
                // Compilation creates a new scope unless explicitly asked to share with the
                // outer scope. Handles splat parameters in the parameter list by setting
                // such parameters to be the final parameter in the function definition, as
                // required per the ES2015 spec. If the CoffeeScript function definition had
                // parameters after the splat, they are declared via expressions in the
                // function body.
                compileNode(o) {
                    var answer, body, boundMethodCheck, comment, condition, exprs, generatedVariables, haveBodyParam, haveSplatParam, i, ifTrue, j, k, l, len1, len2, len3, m, methodScope, modifiers, name, param, paramNames, paramToAddToScope, params, paramsAfterSplat, ref, ref1, ref2, ref3, ref4, ref5, ref6, ref7, ref8, scopeVariablesCount, signature, splatParamName, thisAssignments, wasEmpty, yieldNode;
                    if (this.ctor) {
                        if (this.isAsync) {
                            this.name.error('Class constructor may not be async');
                        }
                        if (this.isGenerator) {
                            this.name.error('Class constructor may not be a generator');
                        }
                    }
                    if (this.bound) {
                        if ((ref1 = o.scope.method) != null ? ref1.bound : void 0) {
                            this.context = o.scope.method.context;
                        }
                        if (!this.context) {
                            this.context = 'this';
                        }
                    }
                    o.scope = del(o, 'classScope') || this.makeScope(o.scope);
                    o.scope.shared = del(o, 'sharedScope');
                    o.indent += TAB;
                    delete o.bare;
                    delete o.isExistentialEquals;
                    params = [];
                    exprs = [];
                    thisAssignments = (ref2 = (ref3 = this.thisAssignments) != null ? ref3.slice() : void 0) != null ? ref2 : [];
                    paramsAfterSplat = [];
                    haveSplatParam = false;
                    haveBodyParam = false;
                    // Check for duplicate parameters and separate `this` assignments.
                    paramNames = [];
                    this.eachParamName(function (name, node, param, obj) {
                        var replacement, target;
                        if (indexOf.call(paramNames, name) >= 0) {
                            node.error(`multiple parameters named '${name}'`);
                        }
                        paramNames.push(name);
                        if (node.this) {
                            name = node.properties[0].name.value;
                            if (indexOf.call(JS_FORBIDDEN, name) >= 0) {
                                name = `_${name}`;
                            }
                            target = new IdentifierLiteral(o.scope.freeVariable(name, {
                                reserve: false
                            }));
                            // `Param` is object destructuring with a default value: ({@prop = 1}) ->
                            // In a case when the variable name is already reserved, we have to assign
                            // a new variable name to the destructured variable: ({prop:prop1 = 1}) ->
                            replacement = param.name instanceof Obj && obj instanceof Assign && obj.operatorToken.value === '=' ? new Assign(new IdentifierLiteral(name), target, 'object') : target; //, operatorToken: new Literal ':'
                            param.renameParam(node, replacement);
                            return thisAssignments.push(new Assign(node, target));
                        }
                    });
                    ref4 = this.params;
                    // Parse the parameters, adding them to the list of parameters to put in the
                    // function definition; and dealing with splats or expansions, including
                    // adding expressions to the function body to declare all parameter
                    // variables that would have been after the splat/expansion parameter.
                    // If we encounter a parameter that needs to be declared in the function
                    // body for any reason, for example it’s destructured with `this`, also
                    // declare and assign all subsequent parameters in the function body so that
                    // any non-idempotent parameters are evaluated in the correct order.
                    for (i = j = 0, len1 = ref4.length; j < len1; i = ++j) {
                        param = ref4[i];
                        // Was `...` used with this parameter? (Only one such parameter is allowed
                        // per function.) Splat/expansion parameters cannot have default values,
                        // so we need not worry about that.
                        if (param.splat || param instanceof Expansion) {
                            if (haveSplatParam) {
                                param.error('only one splat or expansion parameter is allowed per function definition');
                            }
                            else if (param instanceof Expansion && this.params.length === 1) {
                                param.error('an expansion parameter cannot be the only parameter in a function definition');
                            }
                            haveSplatParam = true;
                            if (param.splat) {
                                if (param.name instanceof Arr || param.name instanceof Obj) {
                                    // Splat arrays are treated oddly by ES; deal with them the legacy
                                    // way in the function body. TODO: Should this be handled in the
                                    // function parameter list, and if so, how?
                                    splatParamName = o.scope.freeVariable('arg');
                                    params.push(ref = new Value(new IdentifierLiteral(splatParamName)));
                                    exprs.push(new Assign(new Value(param.name), ref));
                                }
                                else {
                                    params.push(ref = param.asReference(o));
                                    splatParamName = fragmentsToText(ref.compileNodeWithoutComments(o));
                                }
                                if (param.shouldCache()) {
                                    exprs.push(new Assign(new Value(param.name), ref)); // `param` is an Expansion
                                }
                            }
                            else {
                                splatParamName = o.scope.freeVariable('args');
                                params.push(new Value(new IdentifierLiteral(splatParamName)));
                            }
                            o.scope.parameter(splatParamName);
                        }
                        else {
                            // Parse all other parameters; if a splat paramater has not yet been
                            // encountered, add these other parameters to the list to be output in
                            // the function definition.
                            if (param.shouldCache() || haveBodyParam) {
                                param.assignedInBody = true;
                                haveBodyParam = true;
                                // This parameter cannot be declared or assigned in the parameter
                                // list. So put a reference in the parameter list and add a statement
                                // to the function body assigning it, e.g.
                                // `(arg) => { var a = arg.a; }`, with a default value if it has one.
                                if (param.value != null) {
                                    condition = new Op('===', param, new UndefinedLiteral);
                                    ifTrue = new Assign(new Value(param.name), param.value);
                                    exprs.push(new If(condition, ifTrue));
                                }
                                else {
                                    exprs.push(new Assign(new Value(param.name), param.asReference(o), null, {
                                        param: 'alwaysDeclare'
                                    }));
                                }
                            }
                            // If this parameter comes before the splat or expansion, it will go
                            // in the function definition parameter list.
                            if (!haveSplatParam) {
                                // If this parameter has a default value, and it hasn’t already been
                                // set by the `shouldCache()` block above, define it as a statement in
                                // the function body. This parameter comes after the splat parameter,
                                // so we can’t define its default value in the parameter list.
                                if (param.shouldCache()) {
                                    ref = param.asReference(o);
                                }
                                else {
                                    if ((param.value != null) && !param.assignedInBody) {
                                        ref = new Assign(new Value(param.name), param.value, null, {
                                            param: true
                                        });
                                    }
                                    else {
                                        ref = param;
                                    }
                                }
                                // Add this parameter’s reference(s) to the function scope.
                                if (param.name instanceof Arr || param.name instanceof Obj) {
                                    // This parameter is destructured.
                                    param.name.lhs = true;
                                    if (!param.shouldCache()) {
                                        param.name.eachName(function (prop) {
                                            return o.scope.parameter(prop.value);
                                        });
                                    }
                                }
                                else {
                                    // This compilation of the parameter is only to get its name to add
                                    // to the scope name tracking; since the compilation output here
                                    // isn’t kept for eventual output, don’t include comments in this
                                    // compilation, so that they get output the “real” time this param
                                    // is compiled.
                                    paramToAddToScope = param.value != null ? param : ref;
                                    o.scope.parameter(fragmentsToText(paramToAddToScope.compileToFragmentsWithoutComments(o)));
                                }
                                params.push(ref);
                            }
                            else {
                                paramsAfterSplat.push(param);
                                // If this parameter had a default value, since it’s no longer in the
                                // function parameter list we need to assign its default value
                                // (if necessary) as an expression in the body.
                                if ((param.value != null) && !param.shouldCache()) {
                                    condition = new Op('===', param, new UndefinedLiteral);
                                    ifTrue = new Assign(new Value(param.name), param.value);
                                    exprs.push(new If(condition, ifTrue));
                                }
                                if (((ref5 = param.name) != null ? ref5.value : void 0) != null) {
                                    // Add this parameter to the scope, since it wouldn’t have been added
                                    // yet since it was skipped earlier.
                                    o.scope.add(param.name.value, 'var', true);
                                }
                            }
                        }
                    }
                    // If there were parameters after the splat or expansion parameter, those
                    // parameters need to be assigned in the body of the function.
                    if (paramsAfterSplat.length !== 0) {
                        // Create a destructured assignment, e.g. `[a, b, c] = [args..., b, c]`
                        exprs.unshift(new Assign(new Value(new Arr([
                            new Splat(new IdentifierLiteral(splatParamName)),
                            ...((function () {
                                var k, len2, results;
                                results = [];
                                for (k = 0, len2 = paramsAfterSplat.length; k < len2; k++) {
                                    param = paramsAfterSplat[k];
                                    results.push(param.asReference(o));
                                }
                                return results;
                            })())
                        ])), new Value(new IdentifierLiteral(splatParamName))));
                    }
                    // Add new expressions to the function body
                    wasEmpty = this.body.isEmpty();
                    if (!this.expandCtorSuper(thisAssignments)) {
                        this.body.expressions.unshift(...thisAssignments);
                    }
                    this.body.expressions.unshift(...exprs);
                    if (this.isMethod && this.bound && !this.isStatic && this.classVariable) {
                        boundMethodCheck = new Value(new Literal(utility('boundMethodCheck', o)));
                        this.body.expressions.unshift(new Call(boundMethodCheck, [new Value(new ThisLiteral), this.classVariable]));
                    }
                    if (!(wasEmpty || this.noReturn)) {
                        this.body.makeReturn();
                    }
                    // JavaScript doesn’t allow bound (`=>`) functions to also be generators.
                    // This is usually caught via `Op::compileContinuation`, but double-check:
                    if (this.bound && this.isGenerator) {
                        yieldNode = this.body.contains(function (node) {
                            return node instanceof Op && node.operator === 'yield';
                        });
                        (yieldNode || this).error('yield cannot occur inside bound (fat arrow) functions');
                    }
                    // Assemble the output
                    modifiers = [];
                    if (this.isMethod && this.isStatic) {
                        modifiers.push('static');
                    }
                    if (this.isAsync) {
                        modifiers.push('async');
                    }
                    if (!(this.isMethod || this.bound)) {
                        modifiers.push(`function${(this.isGenerator ? '*' : '')}`);
                    }
                    else if (this.isGenerator) {
                        modifiers.push('*');
                    }
                    signature = [this.makeCode('(')];
                    // Block comments between a function name and `(` get output between
                    // `function` and `(`.
                    if (((ref6 = this.paramStart) != null ? ref6.comments : void 0) != null) {
                        this.compileCommentFragments(o, this.paramStart, signature);
                    }
                    for (i = k = 0, len2 = params.length; k < len2; i = ++k) {
                        param = params[i];
                        if (i !== 0) {
                            signature.push(this.makeCode(', '));
                        }
                        if (haveSplatParam && i === params.length - 1) {
                            signature.push(this.makeCode('...'));
                        }
                        // Compile this parameter, but if any generated variables get created
                        // (e.g. `ref`), shift those into the parent scope since we can’t put a
                        // `var` line inside a function parameter list.
                        scopeVariablesCount = o.scope.variables.length;
                        signature.push(...param.compileToFragments(o));
                        if (scopeVariablesCount !== o.scope.variables.length) {
                            generatedVariables = o.scope.variables.splice(scopeVariablesCount);
                            o.scope.parent.variables.push(...generatedVariables);
                        }
                    }
                    signature.push(this.makeCode(')'));
                    // Block comments between `)` and `->`/`=>` get output between `)` and `{`.
                    if (((ref7 = this.funcGlyph) != null ? ref7.comments : void 0) != null) {
                        ref8 = this.funcGlyph.comments;
                        for (l = 0, len3 = ref8.length; l < len3; l++) {
                            comment = ref8[l];
                            comment.unshift = false;
                        }
                        this.compileCommentFragments(o, this.funcGlyph, signature);
                    }
                    if (!this.body.isEmpty()) {
                        body = this.body.compileWithDeclarations(o);
                    }
                    // We need to compile the body before method names to ensure `super`
                    // references are handled.
                    if (this.isMethod) {
                        [methodScope, o.scope] = [o.scope, o.scope.parent];
                        name = this.name.compileToFragments(o);
                        if (name[0].code === '.') {
                            name.shift();
                        }
                        o.scope = methodScope;
                    }
                    answer = this.joinFragmentArrays((function () {
                        var len4, p, results;
                        results = [];
                        for (p = 0, len4 = modifiers.length; p < len4; p++) {
                            m = modifiers[p];
                            results.push(this.makeCode(m));
                        }
                        return results;
                    }).call(this), ' ');
                    if (modifiers.length && name) {
                        answer.push(this.makeCode(' '));
                    }
                    if (name) {
                        answer.push(...name);
                    }
                    answer.push(...signature);
                    if (this.bound && !this.isMethod) {
                        answer.push(this.makeCode(' =>'));
                    }
                    answer.push(this.makeCode(' {'));
                    if (body != null ? body.length : void 0) {
                        answer.push(this.makeCode('\n'), ...body, this.makeCode(`\n${this.tab}`));
                    }
                    answer.push(this.makeCode('}'));
                    if (this.isMethod) {
                        return indentInitial(answer, this);
                    }
                    if (this.front || (o.level >= LEVEL_ACCESS)) {
                        return this.wrapInParentheses(answer);
                    }
                    else {
                        return answer;
                    }
                }
                eachParamName(iterator) {
                    var j, len1, param, ref1, results;
                    ref1 = this.params;
                    results = [];
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        param = ref1[j];
                        results.push(param.eachName(iterator));
                    }
                    return results;
                }
                // Short-circuit `traverseChildren` method to prevent it from crossing scope
                // boundaries unless `crossScope` is `true`.
                traverseChildren(crossScope, func) {
                    if (crossScope) {
                        return super.traverseChildren(crossScope, func);
                    }
                }
                // Short-circuit `replaceInContext` method to prevent it from crossing context boundaries. Bound
                // functions have the same context.
                replaceInContext(child, replacement) {
                    if (this.bound) {
                        return super.replaceInContext(child, replacement);
                    }
                    else {
                        return false;
                    }
                }
                expandCtorSuper(thisAssignments) {
                    var haveThisParam, param, ref1, seenSuper;
                    if (!this.ctor) {
                        return false;
                    }
                    this.eachSuperCall(Block.wrap(this.params), function (superCall) {
                        return superCall.error("'super' is not allowed in constructor parameter defaults");
                    });
                    seenSuper = this.eachSuperCall(this.body, (superCall) => {
                        if (this.ctor === 'base') {
                            superCall.error("'super' is only allowed in derived class constructors");
                        }
                        return superCall.expressions = thisAssignments;
                    });
                    haveThisParam = thisAssignments.length && thisAssignments.length !== ((ref1 = this.thisAssignments) != null ? ref1.length : void 0);
                    if (this.ctor === 'derived' && !seenSuper && haveThisParam) {
                        param = thisAssignments[0].variable;
                        param.error("Can't use @params in derived class constructors without calling super");
                    }
                    return seenSuper;
                }
                // Find all super calls in the given context node;
                // returns `true` if `iterator` is called.
                eachSuperCall(context, iterator) {
                    var seenSuper;
                    seenSuper = false;
                    context.traverseChildren(true, (child) => {
                        var childArgs;
                        if (child instanceof SuperCall) {
                            // `super` in a constructor (the only `super` without an accessor)
                            // cannot be given an argument with a reference to `this`, as that would
                            // be referencing `this` before calling `super`.
                            if (!child.variable.accessor) {
                                childArgs = child.args.filter(function (arg) {
                                    return !(arg instanceof Class) && (!(arg instanceof Code) || arg.bound);
                                });
                                Block.wrap(childArgs).traverseChildren(true, (node) => {
                                    if (node.this) {
                                        return node.error("Can't call super with @params in derived class constructors");
                                    }
                                });
                            }
                            seenSuper = true;
                            iterator(child);
                        }
                        else if (child instanceof ThisLiteral && this.ctor === 'derived' && !seenSuper) {
                            child.error("Can't reference 'this' before calling super in derived class constructors");
                        }
                        // `super` has the same target in bound (arrow) functions, so check them too
                        return !(child instanceof SuperCall) && (!(child instanceof Code) || child.bound);
                    });
                    return seenSuper;
                }
            }
            ;
            Code.prototype.children = ['params', 'body'];
            Code.prototype.jumps = NO;
            return Code;
        }).call(this);
        //### Param
        // A parameter in a function definition. Beyond a typical JavaScript parameter,
        // these parameters can also attach themselves to the context of the function,
        // as well as be a splat, gathering up a group of parameters into an array.
        exports.Param = Param = (function () {
            class Param extends Base {
                constructor(name1, value1, splat1) {
                    var message, token;
                    super();
                    this.name = name1;
                    this.value = value1;
                    this.splat = splat1;
                    message = isUnassignable(this.name.unwrapAll().value);
                    if (message) {
                        this.name.error(message);
                    }
                    if (this.name instanceof Obj && this.name.generated) {
                        token = this.name.objects[0].operatorToken;
                        token.error(`unexpected ${token.value}`);
                    }
                }
                compileToFragments(o) {
                    return this.name.compileToFragments(o, LEVEL_LIST);
                }
                compileToFragmentsWithoutComments(o) {
                    return this.name.compileToFragmentsWithoutComments(o, LEVEL_LIST);
                }
                asReference(o) {
                    var name, node;
                    if (this.reference) {
                        return this.reference;
                    }
                    node = this.name;
                    if (node.this) {
                        name = node.properties[0].name.value;
                        if (indexOf.call(JS_FORBIDDEN, name) >= 0) {
                            name = `_${name}`;
                        }
                        node = new IdentifierLiteral(o.scope.freeVariable(name));
                    }
                    else if (node.shouldCache()) {
                        node = new IdentifierLiteral(o.scope.freeVariable('arg'));
                    }
                    node = new Value(node);
                    node.updateLocationDataIfMissing(this.locationData);
                    return this.reference = node;
                }
                shouldCache() {
                    return this.name.shouldCache();
                }
                // Iterates the name or names of a `Param`.
                // In a sense, a destructured parameter represents multiple JS parameters. This
                // method allows to iterate them all.
                // The `iterator` function will be called as `iterator(name, node)` where
                // `name` is the name of the parameter and `node` is the AST node corresponding
                // to that name.
                eachName(iterator, name = this.name) {
                    var atParam, j, len1, nObj, node, obj, ref1, ref2;
                    atParam = (obj, originalObj = null) => {
                        return iterator(`@${obj.properties[0].name.value}`, obj, this, originalObj);
                    };
                    if (name instanceof Literal) {
                        // * simple literals `foo`
                        return iterator(name.value, name, this);
                    }
                    if (name instanceof Value) {
                        // * at-params `@foo`
                        return atParam(name);
                    }
                    ref2 = (ref1 = name.objects) != null ? ref1 : [];
                    for (j = 0, len1 = ref2.length; j < len1; j++) {
                        obj = ref2[j];
                        // Save original obj.
                        nObj = obj;
                        // * destructured parameter with default value
                        if (obj instanceof Assign && (obj.context == null)) {
                            obj = obj.variable;
                        }
                        // * assignments within destructured parameters `{foo:bar}`
                        if (obj instanceof Assign) {
                            // ... possibly with a default value
                            if (obj.value instanceof Assign) {
                                obj = obj.value.variable;
                            }
                            else {
                                obj = obj.value;
                            }
                            this.eachName(iterator, obj.unwrap());
                            // * splats within destructured parameters `[xs...]`
                        }
                        else if (obj instanceof Splat) {
                            node = obj.name.unwrap();
                            iterator(node.value, node, this);
                        }
                        else if (obj instanceof Value) {
                            // * destructured parameters within destructured parameters `[{a}]`
                            if (obj.isArray() || obj.isObject()) {
                                this.eachName(iterator, obj.base);
                                // * at-params within destructured parameters `{@foo}`
                            }
                            else if (obj.this) {
                                atParam(obj, nObj);
                            }
                            else {
                                // * simple destructured parameters {foo}
                                iterator(obj.base.value, obj.base, this);
                            }
                        }
                        else if (obj instanceof Elision) {
                            obj;
                        }
                        else if (!(obj instanceof Expansion)) {
                            obj.error(`illegal parameter ${obj.compile()}`);
                        }
                    }
                }
                // Rename a param by replacing the given AST node for a name with a new node.
                // This needs to ensure that the the source for object destructuring does not change.
                renameParam(node, newNode) {
                    var isNode, replacement;
                    isNode = function (candidate) {
                        return candidate === node;
                    };
                    replacement = (node, parent) => {
                        var key;
                        if (parent instanceof Obj) {
                            key = node;
                            if (node.this) {
                                key = node.properties[0].name;
                            }
                            // No need to assign a new variable for the destructured variable if the variable isn't reserved.
                            // Examples:
                            // `({@foo}) ->`  should compile to `({foo}) { this.foo = foo}`
                            // `foo = 1; ({@foo}) ->` should compile to `foo = 1; ({foo:foo1}) { this.foo = foo1 }`
                            if (node.this && key.value === newNode.value) {
                                return new Value(newNode);
                            }
                            else {
                                return new Assign(new Value(key), newNode, 'object');
                            }
                        }
                        else {
                            return newNode;
                        }
                    };
                    return this.replaceInContext(isNode, replacement);
                }
            }
            ;
            Param.prototype.children = ['name', 'value'];
            return Param;
        }).call(this);
        //### Splat
        // A splat, either as a parameter to a function, an argument to a call,
        // or as part of a destructuring assignment.
        exports.Splat = Splat = (function () {
            class Splat extends Base {
                constructor(name) {
                    super();
                    this.name = name.compile ? name : new Literal(name);
                }
                shouldCache() {
                    return false;
                }
                isAssignable() {
                    if (this.name instanceof Obj || this.name instanceof Parens) {
                        return false;
                    }
                    return this.name.isAssignable() && (!this.name.isAtomic || this.name.isAtomic());
                }
                assigns(name) {
                    return this.name.assigns(name);
                }
                compileNode(o) {
                    return [this.makeCode('...'), ...this.name.compileToFragments(o, LEVEL_OP)];
                }
                unwrap() {
                    return this.name;
                }
            }
            ;
            Splat.prototype.children = ['name'];
            return Splat;
        }).call(this);
        //### Expansion
        // Used to skip values inside an array destructuring (pattern matching) or
        // parameter list.
        exports.Expansion = Expansion = (function () {
            class Expansion extends Base {
                compileNode(o) {
                    return this.error('Expansion must be used inside a destructuring assignment or parameter list');
                }
                asReference(o) {
                    return this;
                }
                eachName(iterator) { }
            }
            ;
            Expansion.prototype.shouldCache = NO;
            return Expansion;
        }).call(this);
        //### Elision
        // Array elision element (for example, [,a, , , b, , c, ,]).
        exports.Elision = Elision = (function () {
            class Elision extends Base {
                compileToFragments(o, level) {
                    var fragment;
                    fragment = super.compileToFragments(o, level);
                    fragment.isElision = true;
                    return fragment;
                }
                compileNode(o) {
                    return [this.makeCode(', ')];
                }
                asReference(o) {
                    return this;
                }
                eachName(iterator) { }
            }
            ;
            Elision.prototype.isAssignable = YES;
            Elision.prototype.shouldCache = NO;
            return Elision;
        }).call(this);
        //### While
        // A while loop, the only sort of low-level loop exposed by CoffeeScript. From
        // it, all other loops can be manufactured. Useful in cases where you need more
        // flexibility or more speed than a comprehension can provide.
        exports.While = While = (function () {
            class While extends Base {
                constructor(condition, options) {
                    super();
                    this.condition = (options != null ? options.invert : void 0) ? condition.invert() : condition;
                    this.guard = options != null ? options.guard : void 0;
                }
                makeReturn(res) {
                    if (res) {
                        return super.makeReturn(res);
                    }
                    else {
                        this.returns = !this.jumps();
                        return this;
                    }
                }
                addBody(body1) {
                    this.body = body1;
                    return this;
                }
                jumps() {
                    var expressions, j, jumpNode, len1, node;
                    ({ expressions } = this.body);
                    if (!expressions.length) {
                        return false;
                    }
                    for (j = 0, len1 = expressions.length; j < len1; j++) {
                        node = expressions[j];
                        if (jumpNode = node.jumps({
                            loop: true
                        })) {
                            return jumpNode;
                        }
                    }
                    return false;
                }
                // The main difference from a JavaScript *while* is that the CoffeeScript
                // *while* can be used as a part of a larger expression -- while loops may
                // return an array containing the computed result of each iteration.
                compileNode(o) {
                    var answer, body, rvar, set;
                    o.indent += TAB;
                    set = '';
                    ({ body } = this);
                    if (body.isEmpty()) {
                        body = this.makeCode('');
                    }
                    else {
                        if (this.returns) {
                            body.makeReturn(rvar = o.scope.freeVariable('results'));
                            set = `${this.tab}${rvar} = [];\n`;
                        }
                        if (this.guard) {
                            if (body.expressions.length > 1) {
                                body.expressions.unshift(new If((new Parens(this.guard)).invert(), new StatementLiteral("continue")));
                            }
                            else {
                                if (this.guard) {
                                    body = Block.wrap([new If(this.guard, body)]);
                                }
                            }
                        }
                        body = [].concat(this.makeCode("\n"), body.compileToFragments(o, LEVEL_TOP), this.makeCode(`\n${this.tab}`));
                    }
                    answer = [].concat(this.makeCode(set + this.tab + "while ("), this.condition.compileToFragments(o, LEVEL_PAREN), this.makeCode(") {"), body, this.makeCode("}"));
                    if (this.returns) {
                        answer.push(this.makeCode(`\n${this.tab}return ${rvar};`));
                    }
                    return answer;
                }
            }
            ;
            While.prototype.children = ['condition', 'guard', 'body'];
            While.prototype.isStatement = YES;
            return While;
        }).call(this);
        //### Op
        // Simple Arithmetic and logical operations. Performs some conversion from
        // CoffeeScript operations into their JavaScript equivalents.
        exports.Op = Op = (function () {
            var CONVERSIONS, INVERSIONS;
            class Op extends Base {
                constructor(op, first, second, flip) {
                    var firstCall;
                    super();
                    if (op === 'in') {
                        return new In(first, second);
                    }
                    if (op === 'do') {
                        return Op.prototype.generateDo(first);
                    }
                    if (op === 'new') {
                        if ((firstCall = first.unwrap()) instanceof Call && !firstCall.do && !firstCall.isNew) {
                            return firstCall.newInstance();
                        }
                        if (first instanceof Code && first.bound || first.do) {
                            first = new Parens(first);
                        }
                    }
                    this.operator = CONVERSIONS[op] || op;
                    this.first = first;
                    this.second = second;
                    this.flip = !!flip;
                    return this;
                }
                isNumber() {
                    var ref1;
                    return this.isUnary() && ((ref1 = this.operator) === '+' || ref1 === '-') && this.first instanceof Value && this.first.isNumber();
                }
                isAwait() {
                    return this.operator === 'await';
                }
                isYield() {
                    var ref1;
                    return (ref1 = this.operator) === 'yield' || ref1 === 'yield*';
                }
                isUnary() {
                    return !this.second;
                }
                shouldCache() {
                    return !this.isNumber();
                }
                // Am I capable of
                // [Python-style comparison chaining](https://docs.python.org/3/reference/expressions.html#not-in)?
                isChainable() {
                    var ref1;
                    return (ref1 = this.operator) === '<' || ref1 === '>' || ref1 === '>=' || ref1 === '<=' || ref1 === '===' || ref1 === '!==';
                }
                invert() {
                    var allInvertable, curr, fst, op, ref1;
                    if (this.isChainable() && this.first.isChainable()) {
                        allInvertable = true;
                        curr = this;
                        while (curr && curr.operator) {
                            allInvertable && (allInvertable = curr.operator in INVERSIONS);
                            curr = curr.first;
                        }
                        if (!allInvertable) {
                            return new Parens(this).invert();
                        }
                        curr = this;
                        while (curr && curr.operator) {
                            curr.invert = !curr.invert;
                            curr.operator = INVERSIONS[curr.operator];
                            curr = curr.first;
                        }
                        return this;
                    }
                    else if (op = INVERSIONS[this.operator]) {
                        this.operator = op;
                        if (this.first.unwrap() instanceof Op) {
                            this.first.invert();
                        }
                        return this;
                    }
                    else if (this.second) {
                        return new Parens(this).invert();
                    }
                    else if (this.operator === '!' && (fst = this.first.unwrap()) instanceof Op && ((ref1 = fst.operator) === '!' || ref1 === 'in' || ref1 === 'instanceof')) {
                        return fst;
                    }
                    else {
                        return new Op('!', this);
                    }
                }
                unfoldSoak(o) {
                    var ref1;
                    return ((ref1 = this.operator) === '++' || ref1 === '--' || ref1 === 'delete') && unfoldSoak(o, this, 'first');
                }
                generateDo(exp) {
                    var call, func, j, len1, param, passedParams, ref, ref1;
                    passedParams = [];
                    func = exp instanceof Assign && (ref = exp.value.unwrap()) instanceof Code ? ref : exp;
                    ref1 = func.params || [];
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        param = ref1[j];
                        if (param.value) {
                            passedParams.push(param.value);
                            delete param.value;
                        }
                        else {
                            passedParams.push(param);
                        }
                    }
                    call = new Call(exp, passedParams);
                    call.do = true;
                    return call;
                }
                compileNode(o) {
                    var answer, isChain, lhs, message, ref1, rhs;
                    isChain = this.isChainable() && this.first.isChainable();
                    if (!isChain) {
                        // In chains, there's no need to wrap bare obj literals in parens,
                        // as the chained expression is wrapped.
                        this.first.front = this.front;
                    }
                    if (this.operator === 'delete' && o.scope.check(this.first.unwrapAll().value)) {
                        this.error('delete operand may not be argument or var');
                    }
                    if ((ref1 = this.operator) === '--' || ref1 === '++') {
                        message = isUnassignable(this.first.unwrapAll().value);
                        if (message) {
                            this.first.error(message);
                        }
                    }
                    if (this.isYield() || this.isAwait()) {
                        return this.compileContinuation(o);
                    }
                    if (this.isUnary()) {
                        return this.compileUnary(o);
                    }
                    if (isChain) {
                        return this.compileChain(o);
                    }
                    switch (this.operator) {
                        case '?':
                            return this.compileExistence(o, this.second.isDefaultValue);
                        case '//':
                            return this.compileFloorDivision(o);
                        case '%%':
                            return this.compileModulo(o);
                        default:
                            lhs = this.first.compileToFragments(o, LEVEL_OP);
                            rhs = this.second.compileToFragments(o, LEVEL_OP);
                            answer = [].concat(lhs, this.makeCode(` ${this.operator} `), rhs);
                            if (o.level <= LEVEL_OP) {
                                return answer;
                            }
                            else {
                                return this.wrapInParentheses(answer);
                            }
                    }
                }
                // Mimic Python's chained comparisons when multiple comparison operators are
                // used sequentially. For example:
                //     bin/coffee -e 'console.log 50 < 65 > 10'
                //     true
                compileChain(o) {
                    var fragments, fst, shared;
                    [this.first.second, shared] = this.first.second.cache(o);
                    fst = this.first.compileToFragments(o, LEVEL_OP);
                    fragments = fst.concat(this.makeCode(` ${(this.invert ? '&&' : '||')} `), shared.compileToFragments(o), this.makeCode(` ${this.operator} `), this.second.compileToFragments(o, LEVEL_OP));
                    return this.wrapInParentheses(fragments);
                }
                // Keep reference to the left expression, unless this an existential assignment
                compileExistence(o, checkOnlyUndefined) {
                    var fst, ref;
                    if (this.first.shouldCache()) {
                        ref = new IdentifierLiteral(o.scope.freeVariable('ref'));
                        fst = new Parens(new Assign(ref, this.first));
                    }
                    else {
                        fst = this.first;
                        ref = fst;
                    }
                    return new If(new Existence(fst, checkOnlyUndefined), ref, {
                        type: 'if'
                    }).addElse(this.second).compileToFragments(o);
                }
                // Compile a unary **Op**.
                compileUnary(o) {
                    var op, parts, plusMinus;
                    parts = [];
                    op = this.operator;
                    parts.push([this.makeCode(op)]);
                    if (op === '!' && this.first instanceof Existence) {
                        this.first.negated = !this.first.negated;
                        return this.first.compileToFragments(o);
                    }
                    if (o.level >= LEVEL_ACCESS) {
                        return (new Parens(this)).compileToFragments(o);
                    }
                    plusMinus = op === '+' || op === '-';
                    if ((op === 'new' || op === 'typeof' || op === 'delete') || plusMinus && this.first instanceof Op && this.first.operator === op) {
                        parts.push([this.makeCode(' ')]);
                    }
                    if ((plusMinus && this.first instanceof Op) || (op === 'new' && this.first.isStatement(o))) {
                        this.first = new Parens(this.first);
                    }
                    parts.push(this.first.compileToFragments(o, LEVEL_OP));
                    if (this.flip) {
                        parts.reverse();
                    }
                    return this.joinFragmentArrays(parts, '');
                }
                compileContinuation(o) {
                    var op, parts, ref1, ref2;
                    parts = [];
                    op = this.operator;
                    if (o.scope.parent == null) {
                        this.error(`${this.operator} can only occur inside functions`);
                    }
                    if (((ref1 = o.scope.method) != null ? ref1.bound : void 0) && o.scope.method.isGenerator) {
                        this.error('yield cannot occur inside bound (fat arrow) functions');
                    }
                    if (indexOf.call(Object.keys(this.first), 'expression') >= 0 && !(this.first instanceof Throw)) {
                        if (this.first.expression != null) {
                            parts.push(this.first.expression.compileToFragments(o, LEVEL_OP));
                        }
                    }
                    else {
                        if (o.level >= LEVEL_PAREN) {
                            parts.push([this.makeCode("(")]);
                        }
                        parts.push([this.makeCode(op)]);
                        if (((ref2 = this.first.base) != null ? ref2.value : void 0) !== '') {
                            parts.push([this.makeCode(" ")]);
                        }
                        parts.push(this.first.compileToFragments(o, LEVEL_OP));
                        if (o.level >= LEVEL_PAREN) {
                            parts.push([this.makeCode(")")]);
                        }
                    }
                    return this.joinFragmentArrays(parts, '');
                }
                compileFloorDivision(o) {
                    var div, floor, second;
                    floor = new Value(new IdentifierLiteral('Math'), [new Access(new PropertyName('floor'))]);
                    second = this.second.shouldCache() ? new Parens(this.second) : this.second;
                    div = new Op('/', this.first, second);
                    return new Call(floor, [div]).compileToFragments(o);
                }
                compileModulo(o) {
                    var mod;
                    mod = new Value(new Literal(utility('modulo', o)));
                    return new Call(mod, [this.first, this.second]).compileToFragments(o);
                }
                toString(idt) {
                    return super.toString(idt, this.constructor.name + ' ' + this.operator);
                }
            }
            ;
            // The map of conversions from CoffeeScript to JavaScript symbols.
            CONVERSIONS = {
                '==': '===',
                '!=': '!==',
                'of': 'in',
                'yieldfrom': 'yield*'
            };
            // The map of invertible operators.
            INVERSIONS = {
                '!==': '===',
                '===': '!=='
            };
            Op.prototype.children = ['first', 'second'];
            return Op;
        }).call(this);
        //### In
        exports.In = In = (function () {
            class In extends Base {
                constructor(object, array) {
                    super();
                    this.object = object;
                    this.array = array;
                }
                compileNode(o) {
                    var hasSplat, j, len1, obj, ref1;
                    if (this.array instanceof Value && this.array.isArray() && this.array.base.objects.length) {
                        ref1 = this.array.base.objects;
                        for (j = 0, len1 = ref1.length; j < len1; j++) {
                            obj = ref1[j];
                            if (!(obj instanceof Splat)) {
                                continue;
                            }
                            hasSplat = true;
                            break;
                        }
                        if (!hasSplat) {
                            // `compileOrTest` only if we have an array literal with no splats
                            return this.compileOrTest(o);
                        }
                    }
                    return this.compileLoopTest(o);
                }
                compileOrTest(o) {
                    var cmp, cnj, i, item, j, len1, ref, ref1, sub, tests;
                    [sub, ref] = this.object.cache(o, LEVEL_OP);
                    [cmp, cnj] = this.negated ? [' !== ', ' && '] : [' === ', ' || '];
                    tests = [];
                    ref1 = this.array.base.objects;
                    for (i = j = 0, len1 = ref1.length; j < len1; i = ++j) {
                        item = ref1[i];
                        if (i) {
                            tests.push(this.makeCode(cnj));
                        }
                        tests = tests.concat((i ? ref : sub), this.makeCode(cmp), item.compileToFragments(o, LEVEL_ACCESS));
                    }
                    if (o.level < LEVEL_OP) {
                        return tests;
                    }
                    else {
                        return this.wrapInParentheses(tests);
                    }
                }
                compileLoopTest(o) {
                    var fragments, ref, sub;
                    [sub, ref] = this.object.cache(o, LEVEL_LIST);
                    fragments = [].concat(this.makeCode(utility('indexOf', o) + ".call("), this.array.compileToFragments(o, LEVEL_LIST), this.makeCode(", "), ref, this.makeCode(") " + (this.negated ? '< 0' : '>= 0')));
                    if (fragmentsToText(sub) === fragmentsToText(ref)) {
                        return fragments;
                    }
                    fragments = sub.concat(this.makeCode(', '), fragments);
                    if (o.level < LEVEL_LIST) {
                        return fragments;
                    }
                    else {
                        return this.wrapInParentheses(fragments);
                    }
                }
                toString(idt) {
                    return super.toString(idt, this.constructor.name + (this.negated ? '!' : ''));
                }
            }
            ;
            In.prototype.children = ['object', 'array'];
            In.prototype.invert = NEGATE;
            return In;
        }).call(this);
        //### Try
        // A classic *try/catch/finally* block.
        exports.Try = Try = (function () {
            class Try extends Base {
                constructor(attempt, errorVariable, recovery, ensure) {
                    super();
                    this.attempt = attempt;
                    this.errorVariable = errorVariable;
                    this.recovery = recovery;
                    this.ensure = ensure;
                }
                jumps(o) {
                    var ref1;
                    return this.attempt.jumps(o) || ((ref1 = this.recovery) != null ? ref1.jumps(o) : void 0);
                }
                makeReturn(res) {
                    if (this.attempt) {
                        this.attempt = this.attempt.makeReturn(res);
                    }
                    if (this.recovery) {
                        this.recovery = this.recovery.makeReturn(res);
                    }
                    return this;
                }
                // Compilation is more or less as you would expect -- the *finally* clause
                // is optional, the *catch* is not.
                compileNode(o) {
                    var catchPart, ensurePart, generatedErrorVariableName, message, placeholder, tryPart;
                    o.indent += TAB;
                    tryPart = this.attempt.compileToFragments(o, LEVEL_TOP);
                    catchPart = this.recovery ? (generatedErrorVariableName = o.scope.freeVariable('error', {
                        reserve: false
                    }), placeholder = new IdentifierLiteral(generatedErrorVariableName), this.errorVariable ? (message = isUnassignable(this.errorVariable.unwrapAll().value), message ? this.errorVariable.error(message) : void 0, this.recovery.unshift(new Assign(this.errorVariable, placeholder))) : void 0, [].concat(this.makeCode(" catch ("), placeholder.compileToFragments(o), this.makeCode(") {\n"), this.recovery.compileToFragments(o, LEVEL_TOP), this.makeCode(`\n${this.tab}}`))) : !(this.ensure || this.recovery) ? (generatedErrorVariableName = o.scope.freeVariable('error', {
                        reserve: false
                    }), [this.makeCode(` catch (${generatedErrorVariableName}) {}`)]) : [];
                    ensurePart = this.ensure ? [].concat(this.makeCode(" finally {\n"), this.ensure.compileToFragments(o, LEVEL_TOP), this.makeCode(`\n${this.tab}}`)) : [];
                    return [].concat(this.makeCode(`${this.tab}try {\n`), tryPart, this.makeCode(`\n${this.tab}}`), catchPart, ensurePart);
                }
            }
            ;
            Try.prototype.children = ['attempt', 'recovery', 'ensure'];
            Try.prototype.isStatement = YES;
            return Try;
        }).call(this);
        //### Throw
        // Simple node to throw an exception.
        exports.Throw = Throw = (function () {
            class Throw extends Base {
                constructor(expression1) {
                    super();
                    this.expression = expression1;
                }
                compileNode(o) {
                    var fragments;
                    fragments = this.expression.compileToFragments(o, LEVEL_LIST);
                    unshiftAfterComments(fragments, this.makeCode('throw '));
                    fragments.unshift(this.makeCode(this.tab));
                    fragments.push(this.makeCode(';'));
                    return fragments;
                }
            }
            ;
            Throw.prototype.children = ['expression'];
            Throw.prototype.isStatement = YES;
            Throw.prototype.jumps = NO;
            // A **Throw** is already a return, of sorts...
            Throw.prototype.makeReturn = THIS;
            return Throw;
        }).call(this);
        //### Existence
        // Checks a variable for existence -- not `null` and not `undefined`. This is
        // similar to `.nil?` in Ruby, and avoids having to consult a JavaScript truth
        // table. Optionally only check if a variable is not `undefined`.
        exports.Existence = Existence = (function () {
            class Existence extends Base {
                constructor(expression1, onlyNotUndefined = false) {
                    var salvagedComments;
                    super();
                    this.expression = expression1;
                    this.comparisonTarget = onlyNotUndefined ? 'undefined' : 'null';
                    salvagedComments = [];
                    this.expression.traverseChildren(true, function (child) {
                        var comment, j, len1, ref1;
                        if (child.comments) {
                            ref1 = child.comments;
                            for (j = 0, len1 = ref1.length; j < len1; j++) {
                                comment = ref1[j];
                                if (indexOf.call(salvagedComments, comment) < 0) {
                                    salvagedComments.push(comment);
                                }
                            }
                            return delete child.comments;
                        }
                    });
                    attachCommentsToNode(salvagedComments, this);
                    moveComments(this.expression, this);
                }
                compileNode(o) {
                    var cmp, cnj, code;
                    this.expression.front = this.front;
                    code = this.expression.compile(o, LEVEL_OP);
                    if (this.expression.unwrap() instanceof IdentifierLiteral && !o.scope.check(code)) {
                        [cmp, cnj] = this.negated ? ['===', '||'] : ['!==', '&&'];
                        code = `typeof ${code} ${cmp} "undefined"` + (this.comparisonTarget !== 'undefined' ? ` ${cnj} ${code} ${cmp} ${this.comparisonTarget}` : '');
                    }
                    else {
                        // We explicity want to use loose equality (`==`) when comparing against `null`,
                        // so that an existence check roughly corresponds to a check for truthiness.
                        // Do *not* change this to `===` for `null`, as this will break mountains of
                        // existing code. When comparing only against `undefined`, however, we want to
                        // use `===` because this use case is for parity with ES2015+ default values,
                        // which only get assigned when the variable is `undefined` (but not `null`).
                        cmp = this.comparisonTarget === 'null' ? this.negated ? '==' : '!=' : this.negated ? '===' : '!=='; // `undefined`
                        code = `${code} ${cmp} ${this.comparisonTarget}`;
                    }
                    return [this.makeCode(o.level <= LEVEL_COND ? code : `(${code})`)];
                }
            }
            ;
            Existence.prototype.children = ['expression'];
            Existence.prototype.invert = NEGATE;
            return Existence;
        }).call(this);
        //### Parens
        // An extra set of parentheses, specified explicitly in the source. At one time
        // we tried to clean up the results by detecting and removing redundant
        // parentheses, but no longer -- you can put in as many as you please.
        // Parentheses are a good way to force any statement to become an expression.
        exports.Parens = Parens = (function () {
            class Parens extends Base {
                constructor(body1) {
                    super();
                    this.body = body1;
                }
                unwrap() {
                    return this.body;
                }
                shouldCache() {
                    return this.body.shouldCache();
                }
                compileNode(o) {
                    var bare, expr, fragments, ref1, shouldWrapComment;
                    expr = this.body.unwrap();
                    // If these parentheses are wrapping an `IdentifierLiteral` followed by a
                    // block comment, output the parentheses (or put another way, don’t optimize
                    // away these redundant parentheses). This is because Flow requires
                    // parentheses in certain circumstances to distinguish identifiers followed
                    // by comment-based type annotations from JavaScript labels.
                    shouldWrapComment = (ref1 = expr.comments) != null ? ref1.some(function (comment) {
                        return comment.here && !comment.unshift && !comment.newLine;
                    }) : void 0;
                    if (expr instanceof Value && expr.isAtomic() && !this.csxAttribute && !shouldWrapComment) {
                        expr.front = this.front;
                        return expr.compileToFragments(o);
                    }
                    fragments = expr.compileToFragments(o, LEVEL_PAREN);
                    bare = o.level < LEVEL_OP && !shouldWrapComment && (expr instanceof Op || expr.unwrap() instanceof Call || (expr instanceof For && expr.returns)) && (o.level < LEVEL_COND || fragments.length <= 3);
                    if (this.csxAttribute) {
                        return this.wrapInBraces(fragments);
                    }
                    if (bare) {
                        return fragments;
                    }
                    else {
                        return this.wrapInParentheses(fragments);
                    }
                }
            }
            ;
            Parens.prototype.children = ['body'];
            return Parens;
        }).call(this);
        //### StringWithInterpolations
        exports.StringWithInterpolations = StringWithInterpolations = (function () {
            class StringWithInterpolations extends Base {
                constructor(body1) {
                    super();
                    this.body = body1;
                }
                // `unwrap` returns `this` to stop ancestor nodes reaching in to grab @body,
                // and using @body.compileNode. `StringWithInterpolations.compileNode` is
                // _the_ custom logic to output interpolated strings as code.
                unwrap() {
                    return this;
                }
                shouldCache() {
                    return this.body.shouldCache();
                }
                compileNode(o) {
                    var code, element, elements, expr, fragments, j, len1, salvagedComments, wrapped;
                    if (this.csxAttribute) {
                        wrapped = new Parens(new StringWithInterpolations(this.body));
                        wrapped.csxAttribute = true;
                        return wrapped.compileNode(o);
                    }
                    // Assumes that `expr` is `Value` » `StringLiteral` or `Op`
                    expr = this.body.unwrap();
                    elements = [];
                    salvagedComments = [];
                    expr.traverseChildren(false, function (node) {
                        var comment, j, k, len1, len2, ref1;
                        if (node instanceof StringLiteral) {
                            if (node.comments) {
                                salvagedComments.push(...node.comments);
                                delete node.comments;
                            }
                            elements.push(node);
                            return true;
                        }
                        else if (node instanceof Parens) {
                            if (salvagedComments.length !== 0) {
                                for (j = 0, len1 = salvagedComments.length; j < len1; j++) {
                                    comment = salvagedComments[j];
                                    comment.unshift = true;
                                    comment.newLine = true;
                                }
                                attachCommentsToNode(salvagedComments, node);
                            }
                            elements.push(node);
                            return false;
                        }
                        else if (node.comments) {
                            // This node is getting discarded, but salvage its comments.
                            if (elements.length !== 0 && !(elements[elements.length - 1] instanceof StringLiteral)) {
                                ref1 = node.comments;
                                for (k = 0, len2 = ref1.length; k < len2; k++) {
                                    comment = ref1[k];
                                    comment.unshift = false;
                                    comment.newLine = true;
                                }
                                attachCommentsToNode(node.comments, elements[elements.length - 1]);
                            }
                            else {
                                salvagedComments.push(...node.comments);
                            }
                            delete node.comments;
                        }
                        return true;
                    });
                    fragments = [];
                    if (!this.csx) {
                        fragments.push(this.makeCode('`'));
                    }
                    for (j = 0, len1 = elements.length; j < len1; j++) {
                        element = elements[j];
                        if (element instanceof StringLiteral) {
                            element.value = element.unquote(true, this.csx);
                            if (!this.csx) {
                                // Backticks and `${` inside template literals must be escaped.
                                element.value = element.value.replace(/(\\*)(`|\$\{)/g, function (match, backslashes, toBeEscaped) {
                                    if (backslashes.length % 2 === 0) {
                                        return `${backslashes}\\${toBeEscaped}`;
                                    }
                                    else {
                                        return match;
                                    }
                                });
                            }
                            fragments.push(...element.compileToFragments(o));
                        }
                        else {
                            if (!this.csx) {
                                fragments.push(this.makeCode('$'));
                            }
                            code = element.compileToFragments(o, LEVEL_PAREN);
                            if (!this.isNestedTag(element) || code.some(function (fragment) {
                                return fragment.comments != null;
                            })) {
                                code = this.wrapInBraces(code);
                                // Flag the `{` and `}` fragments as having been generated by this
                                // `StringWithInterpolations` node, so that `compileComments` knows
                                // to treat them as bounds. Don’t trust `fragment.type`, which can
                                // report minified variable names when this compiler is minified.
                                code[0].isStringWithInterpolations = true;
                                code[code.length - 1].isStringWithInterpolations = true;
                            }
                            fragments.push(...code);
                        }
                    }
                    if (!this.csx) {
                        fragments.push(this.makeCode('`'));
                    }
                    return fragments;
                }
                isNestedTag(element) {
                    var call, exprs, ref1;
                    exprs = (ref1 = element.body) != null ? ref1.expressions : void 0;
                    call = exprs != null ? exprs[0].unwrap() : void 0;
                    return this.csx && exprs && exprs.length === 1 && call instanceof Call && call.csx;
                }
            }
            ;
            StringWithInterpolations.prototype.children = ['body'];
            return StringWithInterpolations;
        }).call(this);
        //### For
        // CoffeeScript's replacement for the *for* loop is our array and object
        // comprehensions, that compile into *for* loops here. They also act as an
        // expression, able to return the result of each filtered iteration.
        // Unlike Python array comprehensions, they can be multi-line, and you can pass
        // the current index of the loop as a second parameter. Unlike Ruby blocks,
        // you can map and filter in a single pass.
        exports.For = For = (function () {
            class For extends While {
                constructor(body, source) {
                    super();
                    this.addBody(body);
                    this.addSource(source);
                }
                isAwait() {
                    var ref1;
                    return (ref1 = this.await) != null ? ref1 : false;
                }
                addBody(body) {
                    this.body = Block.wrap([body]);
                    return this;
                }
                addSource(source) {
                    var attr, attribs, attribute, j, k, len1, len2, ref1, ref2, ref3, ref4;
                    ({ source: this.source = false } = source);
                    attribs = ["name", "index", "guard", "step", "own", "ownTag", "await", "awaitTag", "object", "from"];
                    for (j = 0, len1 = attribs.length; j < len1; j++) {
                        attr = attribs[j];
                        this[attr] = (ref1 = source[attr]) != null ? ref1 : this[attr];
                    }
                    if (!this.source) {
                        return this;
                    }
                    if (this.from && this.index) {
                        this.index.error('cannot use index with for-from');
                    }
                    if (this.own && !this.object) {
                        this.ownTag.error(`cannot use own with for-${(this.from ? 'from' : 'in')}`);
                    }
                    if (this.object) {
                        [this.name, this.index] = [this.index, this.name];
                    }
                    if (((ref2 = this.index) != null ? typeof ref2.isArray === "function" ? ref2.isArray() : void 0 : void 0) || ((ref3 = this.index) != null ? typeof ref3.isObject === "function" ? ref3.isObject() : void 0 : void 0)) {
                        this.index.error('index cannot be a pattern matching expression');
                    }
                    if (this.await && !this.from) {
                        this.awaitTag.error('await must be used with for-from');
                    }
                    this.range = this.source instanceof Value && this.source.base instanceof Range && !this.source.properties.length && !this.from;
                    this.pattern = this.name instanceof Value;
                    if (this.range && this.index) {
                        this.index.error('indexes do not apply to range loops');
                    }
                    if (this.range && this.pattern) {
                        this.name.error('cannot pattern match over range loops');
                    }
                    this.returns = false;
                    ref4 = ['source', 'guard', 'step', 'name', 'index'];
                    // Move up any comments in the “`for` line”, i.e. the line of code with `for`,
                    // from any child nodes of that line up to the `for` node itself so that these
                    // comments get output, and get output above the `for` loop.
                    for (k = 0, len2 = ref4.length; k < len2; k++) {
                        attribute = ref4[k];
                        if (!this[attribute]) {
                            continue;
                        }
                        this[attribute].traverseChildren(true, (node) => {
                            var comment, l, len3, ref5;
                            if (node.comments) {
                                ref5 = node.comments;
                                for (l = 0, len3 = ref5.length; l < len3; l++) {
                                    comment = ref5[l];
                                    // These comments are buried pretty deeply, so if they happen to be
                                    // trailing comments the line they trail will be unrecognizable when
                                    // we’re done compiling this `for` loop; so just shift them up to
                                    // output above the `for` line.
                                    comment.newLine = comment.unshift = true;
                                }
                                return moveComments(node, this[attribute]);
                            }
                        });
                        moveComments(this[attribute], this);
                    }
                    return this;
                }
                // Welcome to the hairiest method in all of CoffeeScript. Handles the inner
                // loop, filtering, stepping, and result saving for array, object, and range
                // comprehensions. Some of the generated code can be shared in common, and
                // some cannot.
                compileNode(o) {
                    var body, bodyFragments, compare, compareDown, declare, declareDown, defPart, down, forClose, forCode, forPartFragments, fragments, guardPart, idt1, increment, index, ivar, kvar, kvarAssign, last, lvar, name, namePart, ref, ref1, resultPart, returnResult, rvar, scope, source, step, stepNum, stepVar, svar, varPart;
                    body = Block.wrap([this.body]);
                    ref1 = body.expressions, [last] = slice1.call(ref1, -1);
                    if ((last != null ? last.jumps() : void 0) instanceof Return) {
                        this.returns = false;
                    }
                    source = this.range ? this.source.base : this.source;
                    scope = o.scope;
                    if (!this.pattern) {
                        name = this.name && (this.name.compile(o, LEVEL_LIST));
                    }
                    index = this.index && (this.index.compile(o, LEVEL_LIST));
                    if (name && !this.pattern) {
                        scope.find(name);
                    }
                    if (index && !(this.index instanceof Value)) {
                        scope.find(index);
                    }
                    if (this.returns) {
                        rvar = scope.freeVariable('results');
                    }
                    if (this.from) {
                        if (this.pattern) {
                            ivar = scope.freeVariable('x', {
                                single: true
                            });
                        }
                    }
                    else {
                        ivar = (this.object && index) || scope.freeVariable('i', {
                            single: true
                        });
                    }
                    kvar = ((this.range || this.from) && name) || index || ivar;
                    kvarAssign = kvar !== ivar ? `${kvar} = ` : "";
                    if (this.step && !this.range) {
                        [step, stepVar] = this.cacheToCodeFragments(this.step.cache(o, LEVEL_LIST, shouldCacheOrIsAssignable));
                        if (this.step.isNumber()) {
                            stepNum = Number(stepVar);
                        }
                    }
                    if (this.pattern) {
                        name = ivar;
                    }
                    varPart = '';
                    guardPart = '';
                    defPart = '';
                    idt1 = this.tab + TAB;
                    if (this.range) {
                        forPartFragments = source.compileToFragments(merge(o, {
                            index: ivar,
                            name,
                            step: this.step,
                            shouldCache: shouldCacheOrIsAssignable
                        }));
                    }
                    else {
                        svar = this.source.compile(o, LEVEL_LIST);
                        if ((name || this.own) && !(this.source.unwrap() instanceof IdentifierLiteral)) {
                            defPart += `${this.tab}${(ref = scope.freeVariable('ref'))} = ${svar};\n`;
                            svar = ref;
                        }
                        if (name && !this.pattern && !this.from) {
                            namePart = `${name} = ${svar}[${kvar}]`;
                        }
                        if (!this.object && !this.from) {
                            if (step !== stepVar) {
                                defPart += `${this.tab}${step};\n`;
                            }
                            down = stepNum < 0;
                            if (!(this.step && (stepNum != null) && down)) {
                                lvar = scope.freeVariable('len');
                            }
                            declare = `${kvarAssign}${ivar} = 0, ${lvar} = ${svar}.length`;
                            declareDown = `${kvarAssign}${ivar} = ${svar}.length - 1`;
                            compare = `${ivar} < ${lvar}`;
                            compareDown = `${ivar} >= 0`;
                            if (this.step) {
                                if (stepNum != null) {
                                    if (down) {
                                        compare = compareDown;
                                        declare = declareDown;
                                    }
                                }
                                else {
                                    compare = `${stepVar} > 0 ? ${compare} : ${compareDown}`;
                                    declare = `(${stepVar} > 0 ? (${declare}) : ${declareDown})`;
                                }
                                increment = `${ivar} += ${stepVar}`;
                            }
                            else {
                                increment = `${(kvar !== ivar ? `++${ivar}` : `${ivar}++`)}`;
                            }
                            forPartFragments = [this.makeCode(`${declare}; ${compare}; ${kvarAssign}${increment}`)];
                        }
                    }
                    if (this.returns) {
                        resultPart = `${this.tab}${rvar} = [];\n`;
                        returnResult = `\n${this.tab}return ${rvar};`;
                        body.makeReturn(rvar);
                    }
                    if (this.guard) {
                        if (body.expressions.length > 1) {
                            body.expressions.unshift(new If((new Parens(this.guard)).invert(), new StatementLiteral("continue")));
                        }
                        else {
                            if (this.guard) {
                                body = Block.wrap([new If(this.guard, body)]);
                            }
                        }
                    }
                    if (this.pattern) {
                        body.expressions.unshift(new Assign(this.name, this.from ? new IdentifierLiteral(kvar) : new Literal(`${svar}[${kvar}]`)));
                    }
                    if (namePart) {
                        varPart = `\n${idt1}${namePart};`;
                    }
                    if (this.object) {
                        forPartFragments = [this.makeCode(`${kvar} in ${svar}`)];
                        if (this.own) {
                            guardPart = `\n${idt1}if (!${utility('hasProp', o)}.call(${svar}, ${kvar})) continue;`;
                        }
                    }
                    else if (this.from) {
                        if (this.await) {
                            forPartFragments = new Op('await', new Parens(new Literal(`${kvar} of ${svar}`)));
                            forPartFragments = forPartFragments.compileToFragments(o, LEVEL_TOP);
                        }
                        else {
                            forPartFragments = [this.makeCode(`${kvar} of ${svar}`)];
                        }
                    }
                    bodyFragments = body.compileToFragments(merge(o, {
                        indent: idt1
                    }), LEVEL_TOP);
                    if (bodyFragments && bodyFragments.length > 0) {
                        bodyFragments = [].concat(this.makeCode('\n'), bodyFragments, this.makeCode('\n'));
                    }
                    fragments = [this.makeCode(defPart)];
                    if (resultPart) {
                        fragments.push(this.makeCode(resultPart));
                    }
                    forCode = this.await ? 'for ' : 'for (';
                    forClose = this.await ? '' : ')';
                    fragments = fragments.concat(this.makeCode(this.tab), this.makeCode(forCode), forPartFragments, this.makeCode(`${forClose} {${guardPart}${varPart}`), bodyFragments, this.makeCode(this.tab), this.makeCode('}'));
                    if (returnResult) {
                        fragments.push(this.makeCode(returnResult));
                    }
                    return fragments;
                }
            }
            ;
            For.prototype.children = ['body', 'source', 'guard', 'step'];
            return For;
        }).call(this);
        //### Switch
        // A JavaScript *switch* statement. Converts into a returnable expression on-demand.
        exports.Switch = Switch = (function () {
            class Switch extends Base {
                constructor(subject, cases, otherwise) {
                    super();
                    this.subject = subject;
                    this.cases = cases;
                    this.otherwise = otherwise;
                }
                jumps(o = {
                    block: true
                }) {
                    var block, conds, j, jumpNode, len1, ref1, ref2;
                    ref1 = this.cases;
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        [conds, block] = ref1[j];
                        if (jumpNode = block.jumps(o)) {
                            return jumpNode;
                        }
                    }
                    return (ref2 = this.otherwise) != null ? ref2.jumps(o) : void 0;
                }
                makeReturn(res) {
                    var j, len1, pair, ref1, ref2;
                    ref1 = this.cases;
                    for (j = 0, len1 = ref1.length; j < len1; j++) {
                        pair = ref1[j];
                        pair[1].makeReturn(res);
                    }
                    if (res) {
                        this.otherwise || (this.otherwise = new Block([new Literal('void 0')]));
                    }
                    if ((ref2 = this.otherwise) != null) {
                        ref2.makeReturn(res);
                    }
                    return this;
                }
                compileNode(o) {
                    var block, body, cond, conditions, expr, fragments, i, idt1, idt2, j, k, len1, len2, ref1, ref2;
                    idt1 = o.indent + TAB;
                    idt2 = o.indent = idt1 + TAB;
                    fragments = [].concat(this.makeCode(this.tab + "switch ("), (this.subject ? this.subject.compileToFragments(o, LEVEL_PAREN) : this.makeCode("false")), this.makeCode(") {\n"));
                    ref1 = this.cases;
                    for (i = j = 0, len1 = ref1.length; j < len1; i = ++j) {
                        [conditions, block] = ref1[i];
                        ref2 = flatten([conditions]);
                        for (k = 0, len2 = ref2.length; k < len2; k++) {
                            cond = ref2[k];
                            if (!this.subject) {
                                cond = cond.invert();
                            }
                            fragments = fragments.concat(this.makeCode(idt1 + "case "), cond.compileToFragments(o, LEVEL_PAREN), this.makeCode(":\n"));
                        }
                        if ((body = block.compileToFragments(o, LEVEL_TOP)).length > 0) {
                            fragments = fragments.concat(body, this.makeCode('\n'));
                        }
                        if (i === this.cases.length - 1 && !this.otherwise) {
                            break;
                        }
                        expr = this.lastNode(block.expressions);
                        if (expr instanceof Return || expr instanceof Throw || (expr instanceof Literal && expr.jumps() && expr.value !== 'debugger')) {
                            continue;
                        }
                        fragments.push(cond.makeCode(idt2 + 'break;\n'));
                    }
                    if (this.otherwise && this.otherwise.expressions.length) {
                        fragments.push(this.makeCode(idt1 + "default:\n"), ...(this.otherwise.compileToFragments(o, LEVEL_TOP)), this.makeCode("\n"));
                    }
                    fragments.push(this.makeCode(this.tab + '}'));
                    return fragments;
                }
            }
            ;
            Switch.prototype.children = ['subject', 'cases', 'otherwise'];
            Switch.prototype.isStatement = YES;
            return Switch;
        }).call(this);
        //### If
        // *If/else* statements. Acts as an expression by pushing down requested returns
        // to the last line of each clause.
        // Single-expression **Ifs** are compiled into conditional operators if possible,
        // because ternaries are already proper expressions, and don’t need conversion.
        exports.If = If = (function () {
            class If extends Base {
                constructor(condition, body1, options = {}) {
                    super();
                    this.body = body1;
                    this.condition = options.type === 'unless' ? condition.invert() : condition;
                    this.elseBody = null;
                    this.isChain = false;
                    ({ soak: this.soak } = options);
                    if (this.condition.comments) {
                        moveComments(this.condition, this);
                    }
                }
                bodyNode() {
                    var ref1;
                    return (ref1 = this.body) != null ? ref1.unwrap() : void 0;
                }
                elseBodyNode() {
                    var ref1;
                    return (ref1 = this.elseBody) != null ? ref1.unwrap() : void 0;
                }
                // Rewrite a chain of **Ifs** to add a default case as the final *else*.
                addElse(elseBody) {
                    if (this.isChain) {
                        this.elseBodyNode().addElse(elseBody);
                    }
                    else {
                        this.isChain = elseBody instanceof If;
                        this.elseBody = this.ensureBlock(elseBody);
                        this.elseBody.updateLocationDataIfMissing(elseBody.locationData);
                    }
                    return this;
                }
                // The **If** only compiles into a statement if either of its bodies needs
                // to be a statement. Otherwise a conditional operator is safe.
                isStatement(o) {
                    var ref1;
                    return (o != null ? o.level : void 0) === LEVEL_TOP || this.bodyNode().isStatement(o) || ((ref1 = this.elseBodyNode()) != null ? ref1.isStatement(o) : void 0);
                }
                jumps(o) {
                    var ref1;
                    return this.body.jumps(o) || ((ref1 = this.elseBody) != null ? ref1.jumps(o) : void 0);
                }
                compileNode(o) {
                    if (this.isStatement(o)) {
                        return this.compileStatement(o);
                    }
                    else {
                        return this.compileExpression(o);
                    }
                }
                makeReturn(res) {
                    if (res) {
                        this.elseBody || (this.elseBody = new Block([new Literal('void 0')]));
                    }
                    this.body && (this.body = new Block([this.body.makeReturn(res)]));
                    this.elseBody && (this.elseBody = new Block([this.elseBody.makeReturn(res)]));
                    return this;
                }
                ensureBlock(node) {
                    if (node instanceof Block) {
                        return node;
                    }
                    else {
                        return new Block([node]);
                    }
                }
                // Compile the `If` as a regular *if-else* statement. Flattened chains
                // force inner *else* bodies into statement form.
                compileStatement(o) {
                    var answer, body, child, cond, exeq, ifPart, indent;
                    child = del(o, 'chainChild');
                    exeq = del(o, 'isExistentialEquals');
                    if (exeq) {
                        return new If(this.condition.invert(), this.elseBodyNode(), {
                            type: 'if'
                        }).compileToFragments(o);
                    }
                    indent = o.indent + TAB;
                    cond = this.condition.compileToFragments(o, LEVEL_PAREN);
                    body = this.ensureBlock(this.body).compileToFragments(merge(o, { indent }));
                    ifPart = [].concat(this.makeCode("if ("), cond, this.makeCode(") {\n"), body, this.makeCode(`\n${this.tab}}`));
                    if (!child) {
                        ifPart.unshift(this.makeCode(this.tab));
                    }
                    if (!this.elseBody) {
                        return ifPart;
                    }
                    answer = ifPart.concat(this.makeCode(' else '));
                    if (this.isChain) {
                        o.chainChild = true;
                        answer = answer.concat(this.elseBody.unwrap().compileToFragments(o, LEVEL_TOP));
                    }
                    else {
                        answer = answer.concat(this.makeCode("{\n"), this.elseBody.compileToFragments(merge(o, { indent }), LEVEL_TOP), this.makeCode(`\n${this.tab}}`));
                    }
                    return answer;
                }
                // Compile the `If` as a conditional operator.
                compileExpression(o) {
                    var alt, body, cond, fragments;
                    cond = this.condition.compileToFragments(o, LEVEL_COND);
                    body = this.bodyNode().compileToFragments(o, LEVEL_LIST);
                    alt = this.elseBodyNode() ? this.elseBodyNode().compileToFragments(o, LEVEL_LIST) : [this.makeCode('void 0')];
                    fragments = cond.concat(this.makeCode(" ? "), body, this.makeCode(" : "), alt);
                    if (o.level >= LEVEL_COND) {
                        return this.wrapInParentheses(fragments);
                    }
                    else {
                        return fragments;
                    }
                }
                unfoldSoak() {
                    return this.soak && this;
                }
            }
            ;
            If.prototype.children = ['condition', 'body', 'elseBody'];
            return If;
        }).call(this);
        // Constants
        // ---------
        UTILITIES = {
            modulo: function () {
                return 'function(a, b) { return (+a % (b = +b) + b) % b; }';
            },
            boundMethodCheck: function () {
                return "function(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new Error('Bound instance method accessed before binding'); } }";
            },
            // Shortcuts to speed up the lookup time for native functions.
            hasProp: function () {
                return '{}.hasOwnProperty';
            },
            indexOf: function () {
                return '[].indexOf';
            },
            slice: function () {
                return '[].slice';
            },
            splice: function () {
                return '[].splice';
            }
        };
        // Levels indicate a node's position in the AST. Useful for knowing if
        // parens are necessary or superfluous.
        LEVEL_TOP = 1; // ...;
        LEVEL_PAREN = 2; // (...)
        LEVEL_LIST = 3; // [...]
        LEVEL_COND = 4; // ... ? x : y
        LEVEL_OP = 5; // !...
        LEVEL_ACCESS = 6; // ...[0]
        // Tabs are two spaces for pretty printing.
        TAB = '  ';
        SIMPLENUM = /^[+-]?\d+$/;
        // Helper Functions
        // ----------------
        // Helper for ensuring that utility functions are assigned at the top level.
        utility = function (name, o) {
            var ref, root;
            ({ root } = o.scope);
            if (name in root.utilities) {
                return root.utilities[name];
            }
            else {
                ref = root.freeVariable(name);
                root.assign(ref, UTILITIES[name](o));
                return root.utilities[name] = ref;
            }
        };
        multident = function (code, tab, includingFirstLine = true) {
            var endsWithNewLine;
            endsWithNewLine = code[code.length - 1] === '\n';
            code = (includingFirstLine ? tab : '') + code.replace(/\n/g, `$&${tab}`);
            code = code.replace(/\s+$/, '');
            if (endsWithNewLine) {
                code = code + '\n';
            }
            return code;
        };
        // Wherever in CoffeeScript 1 we might’ve inserted a `makeCode "#{@tab}"` to
        // indent a line of code, now we must account for the possibility of comments
        // preceding that line of code. If there are such comments, indent each line of
        // such comments, and _then_ indent the first following line of code.
        indentInitial = function (fragments, node) {
            var fragment, fragmentIndex, j, len1;
            for (fragmentIndex = j = 0, len1 = fragments.length; j < len1; fragmentIndex = ++j) {
                fragment = fragments[fragmentIndex];
                if (fragment.isHereComment) {
                    fragment.code = multident(fragment.code, node.tab);
                }
                else {
                    fragments.splice(fragmentIndex, 0, node.makeCode(`${node.tab}`));
                    break;
                }
            }
            return fragments;
        };
        hasLineComments = function (node) {
            var comment, j, len1, ref1;
            if (!node.comments) {
                return false;
            }
            ref1 = node.comments;
            for (j = 0, len1 = ref1.length; j < len1; j++) {
                comment = ref1[j];
                if (comment.here === false) {
                    return true;
                }
            }
            return false;
        };
        // Move the `comments` property from one object to another, deleting it from
        // the first object.
        moveComments = function (from, to) {
            if (!(from != null ? from.comments : void 0)) {
                return;
            }
            attachCommentsToNode(from.comments, to);
            return delete from.comments;
        };
        // Sometimes when compiling a node, we want to insert a fragment at the start
        // of an array of fragments; but if the start has one or more comment fragments,
        // we want to insert this fragment after those but before any non-comments.
        unshiftAfterComments = function (fragments, fragmentToInsert) {
            var fragment, fragmentIndex, inserted, j, len1;
            inserted = false;
            for (fragmentIndex = j = 0, len1 = fragments.length; j < len1; fragmentIndex = ++j) {
                fragment = fragments[fragmentIndex];
                if (!(!fragment.isComment)) {
                    continue;
                }
                fragments.splice(fragmentIndex, 0, fragmentToInsert);
                inserted = true;
                break;
            }
            if (!inserted) {
                fragments.push(fragmentToInsert);
            }
            return fragments;
        };
        isLiteralArguments = function (node) {
            return node instanceof IdentifierLiteral && node.value === 'arguments';
        };
        isLiteralThis = function (node) {
            return node instanceof ThisLiteral || (node instanceof Code && node.bound);
        };
        shouldCacheOrIsAssignable = function (node) {
            return node.shouldCache() || (typeof node.isAssignable === "function" ? node.isAssignable() : void 0);
        };
        // Unfold a node's child if soak, then tuck the node under created `If`
        unfoldSoak = function (o, parent, name) {
            var ifn;
            if (!(ifn = parent[name].unfoldSoak(o))) {
                return;
            }
            parent[name] = ifn.body;
            ifn.body = new Value(parent);
            return ifn;
        };
    }).call(this);
}
,
/* coffeescript/lib/coffeescript/parser */ function _(require, module, exports) {
    /* parser generated by jison 0.4.18 */
    /*
      Returns a Parser object of the following structure:
    
      Parser: {
        yy: {}
      }
    
      Parser.prototype: {
        yy: {},
        trace: function(),
        symbols_: {associative list: name ==> number},
        terminals_: {associative list: number ==> name},
        productions_: [...],
        performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate, $$, _$),
        table: [...],
        defaultActions: {...},
        parseError: function(str, hash),
        parse: function(input),
    
        lexer: {
            EOF: 1,
            parseError: function(str, hash),
            setInput: function(input),
            input: function(),
            unput: function(str),
            more: function(),
            less: function(n),
            pastInput: function(),
            upcomingInput: function(),
            showPosition: function(),
            test_match: function(regex_match_array, rule_index),
            next: function(),
            lex: function(),
            begin: function(condition),
            popState: function(),
            _currentRules: function(),
            topState: function(),
            pushState: function(condition),
    
            options: {
                ranges: boolean           (optional: true ==> token location info will include a .range[] member)
                flex: boolean             (optional: true ==> flex-like lexing behaviour where the rules are tested exhaustively to find the longest match)
                backtrack_lexer: boolean  (optional: true ==> lexer regexes are tested in order and for each matching regex the action code is invoked; the lexer terminates the scan when a token is returned by the action code)
            },
    
            performAction: function(yy, yy_, $avoiding_name_collisions, YY_START),
            rules: [...],
            conditions: {associative list: name ==> set},
        }
      }
    
    
      token location info (@$, _$, etc.): {
        first_line: n,
        last_line: n,
        first_column: n,
        last_column: n,
        range: [start_number, end_number]       (where the numbers are indexes into the input string, regular zero-based)
      }
    
    
      the parseError function receives a 'hash' object with these members for lexer and parser errors: {
        text:        (matched text)
        token:       (the produced terminal token, if any)
        line:        (yylineno)
      }
      while parser (grammar) errors will also provide these members, i.e. parser errors deliver a superset of attributes: {
        loc:         (yylloc)
        expected:    (string describing the set of expected tokens)
        recoverable: (boolean: TRUE when the parser has a error recovery rule available for this particular error)
      }
    */
    var parser = (function () {
        var o = function (k, v, o, l) { for (o = o || {}, l = k.length; l--; o[k[l]] = v)
            ; return o; }, $V0 = [1, 24], $V1 = [1, 56], $V2 = [1, 91], $V3 = [1, 92], $V4 = [1, 87], $V5 = [1, 93], $V6 = [1, 94], $V7 = [1, 89], $V8 = [1, 90], $V9 = [1, 64], $Va = [1, 66], $Vb = [1, 67], $Vc = [1, 68], $Vd = [1, 69], $Ve = [1, 70], $Vf = [1, 72], $Vg = [1, 73], $Vh = [1, 58], $Vi = [1, 42], $Vj = [1, 36], $Vk = [1, 76], $Vl = [1, 77], $Vm = [1, 86], $Vn = [1, 54], $Vo = [1, 59], $Vp = [1, 60], $Vq = [1, 74], $Vr = [1, 75], $Vs = [1, 47], $Vt = [1, 55], $Vu = [1, 71], $Vv = [1, 81], $Vw = [1, 82], $Vx = [1, 83], $Vy = [1, 84], $Vz = [1, 53], $VA = [1, 80], $VB = [1, 38], $VC = [1, 39], $VD = [1, 40], $VE = [1, 41], $VF = [1, 43], $VG = [1, 44], $VH = [1, 95], $VI = [1, 6, 36, 47, 146], $VJ = [1, 6, 35, 36, 47, 69, 70, 93, 127, 135, 146, 149, 157], $VK = [1, 113], $VL = [1, 114], $VM = [1, 115], $VN = [1, 110], $VO = [1, 98], $VP = [1, 97], $VQ = [1, 96], $VR = [1, 99], $VS = [1, 100], $VT = [1, 101], $VU = [1, 102], $VV = [1, 103], $VW = [1, 104], $VX = [1, 105], $VY = [1, 106], $VZ = [1, 107], $V_ = [1, 108], $V$ = [1, 109], $V01 = [1, 117], $V11 = [1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 178, 179, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $V21 = [2, 196], $V31 = [1, 123], $V41 = [1, 128], $V51 = [1, 124], $V61 = [1, 125], $V71 = [1, 126], $V81 = [1, 129], $V91 = [1, 122], $Va1 = [1, 6, 35, 36, 47, 69, 70, 93, 127, 135, 146, 148, 149, 150, 156, 157, 174], $Vb1 = [1, 6, 35, 36, 45, 46, 47, 69, 70, 80, 81, 83, 88, 93, 101, 102, 103, 105, 109, 125, 126, 127, 135, 146, 148, 149, 150, 156, 157, 174, 178, 179, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $Vc1 = [2, 122], $Vd1 = [2, 126], $Ve1 = [6, 35, 88, 93], $Vf1 = [2, 99], $Vg1 = [1, 141], $Vh1 = [1, 135], $Vi1 = [1, 140], $Vj1 = [1, 144], $Vk1 = [1, 149], $Vl1 = [1, 147], $Vm1 = [1, 151], $Vn1 = [1, 155], $Vo1 = [1, 153], $Vp1 = [1, 6, 35, 36, 45, 46, 47, 61, 69, 70, 80, 81, 83, 88, 93, 101, 102, 103, 105, 109, 125, 126, 127, 135, 146, 148, 149, 150, 156, 157, 174, 178, 179, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $Vq1 = [2, 119], $Vr1 = [1, 6, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 178, 179, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $Vs1 = [2, 31], $Vt1 = [1, 183], $Vu1 = [2, 86], $Vv1 = [1, 187], $Vw1 = [1, 193], $Vx1 = [1, 208], $Vy1 = [1, 203], $Vz1 = [1, 212], $VA1 = [1, 209], $VB1 = [1, 214], $VC1 = [1, 215], $VD1 = [1, 217], $VE1 = [14, 32, 35, 38, 39, 43, 45, 46, 49, 50, 54, 55, 56, 57, 58, 59, 68, 77, 84, 85, 86, 90, 91, 107, 110, 112, 120, 129, 130, 140, 144, 145, 148, 150, 153, 156, 167, 173, 176, 177, 178, 179, 180, 181], $VF1 = [1, 6, 35, 36, 45, 46, 47, 61, 69, 70, 80, 81, 83, 88, 93, 101, 102, 103, 105, 109, 111, 125, 126, 127, 135, 146, 148, 149, 150, 156, 157, 174, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194], $VG1 = [1, 228], $VH1 = [1, 229], $VI1 = [2, 142], $VJ1 = [1, 245], $VK1 = [1, 247], $VL1 = [1, 257], $VM1 = [1, 6, 35, 36, 45, 46, 47, 65, 69, 70, 80, 81, 83, 88, 93, 101, 102, 103, 105, 109, 125, 126, 127, 135, 146, 148, 149, 150, 156, 157, 174, 178, 179, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $VN1 = [1, 6, 33, 35, 36, 45, 46, 47, 61, 65, 69, 70, 80, 81, 83, 88, 93, 101, 102, 103, 105, 109, 111, 117, 125, 126, 127, 135, 146, 148, 149, 150, 156, 157, 164, 165, 166, 174, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194], $VO1 = [1, 6, 35, 36, 45, 46, 47, 52, 65, 69, 70, 80, 81, 83, 88, 93, 101, 102, 103, 105, 109, 125, 126, 127, 135, 146, 148, 149, 150, 156, 157, 174, 178, 179, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $VP1 = [1, 287], $VQ1 = [45, 46, 126], $VR1 = [1, 298], $VS1 = [1, 297], $VT1 = [6, 35], $VU1 = [2, 97], $VV1 = [1, 304], $VW1 = [6, 35, 36, 88, 93], $VX1 = [6, 35, 36, 61, 70, 88, 93], $VY1 = [1, 6, 35, 36, 47, 69, 70, 80, 81, 83, 88, 93, 101, 102, 103, 105, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 178, 179, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $VZ1 = [1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 178, 179, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $V_1 = [2, 348], $V$1 = [1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 178, 179, 183, 185, 186, 187, 188, 189, 190, 191, 192, 193], $V02 = [45, 46, 80, 81, 101, 102, 103, 105, 125, 126], $V12 = [1, 331], $V22 = [1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174], $V32 = [2, 84], $V42 = [1, 347], $V52 = [1, 349], $V62 = [1, 354], $V72 = [1, 356], $V82 = [6, 35, 69, 93], $V92 = [2, 221], $Va2 = [2, 222], $Vb2 = [1, 6, 35, 36, 45, 46, 47, 61, 69, 70, 80, 81, 83, 88, 93, 101, 102, 103, 105, 109, 125, 126, 127, 135, 146, 148, 149, 150, 156, 157, 164, 165, 166, 174, 178, 179, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $Vc2 = [1, 370], $Vd2 = [6, 14, 32, 35, 36, 38, 39, 43, 45, 46, 49, 50, 54, 55, 56, 57, 58, 59, 68, 69, 70, 77, 84, 85, 86, 90, 91, 93, 107, 110, 112, 120, 129, 130, 140, 144, 145, 148, 150, 153, 156, 167, 173, 176, 177, 178, 179, 180, 181], $Ve2 = [6, 35, 36, 69, 93], $Vf2 = [6, 35, 36, 69, 93, 127], $Vg2 = [1, 6, 35, 36, 45, 46, 47, 61, 65, 69, 70, 80, 81, 83, 88, 93, 101, 102, 103, 105, 109, 111, 125, 126, 127, 135, 146, 148, 149, 150, 156, 157, 164, 165, 166, 174, 178, 179, 180, 181, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193, 194], $Vh2 = [1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 157, 174], $Vi2 = [1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 149, 157, 174], $Vj2 = [2, 273], $Vk2 = [164, 165, 166], $Vl2 = [93, 164, 165, 166], $Vm2 = [6, 35, 109], $Vn2 = [1, 395], $Vo2 = [6, 35, 36, 93, 109], $Vp2 = [6, 35, 36, 65, 93, 109], $Vq2 = [1, 401], $Vr2 = [1, 402], $Vs2 = [6, 35, 36, 61, 65, 70, 80, 81, 93, 109, 126], $Vt2 = [6, 35, 36, 70, 80, 81, 93, 109, 126], $Vu2 = [1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 178, 179, 185, 186, 187, 188, 189, 190, 191, 192, 193], $Vv2 = [2, 340], $Vw2 = [2, 339], $Vx2 = [1, 6, 35, 36, 45, 46, 47, 52, 69, 70, 80, 81, 83, 88, 93, 101, 102, 103, 105, 109, 125, 126, 127, 135, 146, 148, 149, 150, 156, 157, 174, 178, 179, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $Vy2 = [1, 424], $Vz2 = [14, 32, 38, 39, 43, 45, 46, 49, 50, 54, 55, 56, 57, 58, 59, 68, 77, 83, 84, 85, 86, 90, 91, 107, 110, 112, 120, 129, 130, 140, 144, 145, 148, 150, 153, 156, 167, 173, 176, 177, 178, 179, 180, 181], $VA2 = [2, 207], $VB2 = [6, 35, 36], $VC2 = [2, 98], $VD2 = [1, 433], $VE2 = [1, 434], $VF2 = [1, 6, 35, 36, 47, 69, 70, 80, 81, 83, 88, 93, 101, 102, 103, 105, 109, 127, 135, 142, 143, 146, 148, 149, 150, 156, 157, 169, 171, 174, 178, 179, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $VG2 = [1, 313], $VH2 = [36, 169, 171], $VI2 = [1, 6, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 149, 157, 174], $VJ2 = [1, 469], $VK2 = [1, 475], $VL2 = [1, 6, 35, 36, 47, 69, 70, 93, 127, 135, 146, 149, 157, 174], $VM2 = [2, 113], $VN2 = [1, 488], $VO2 = [1, 489], $VP2 = [6, 35, 36, 69], $VQ2 = [1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 169, 174, 178, 179, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $VR2 = [1, 6, 35, 36, 47, 69, 70, 93, 127, 135, 146, 149, 157, 169], $VS2 = [2, 287], $VT2 = [2, 288], $VU2 = [2, 303], $VV2 = [1, 512], $VW2 = [1, 513], $VX2 = [6, 35, 36, 109], $VY2 = [1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 150, 156, 157, 174], $VZ2 = [1, 534], $V_2 = [6, 35, 36, 93, 127], $V$2 = [6, 35, 36, 93], $V03 = [1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 142, 146, 148, 149, 150, 156, 157, 174, 178, 179, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $V13 = [35, 93], $V23 = [1, 562], $V33 = [1, 563], $V43 = [1, 569], $V53 = [1, 570], $V63 = [2, 258], $V73 = [2, 261], $V83 = [2, 274], $V93 = [1, 619], $Va3 = [1, 620], $Vb3 = [2, 289], $Vc3 = [2, 293], $Vd3 = [2, 290], $Ve3 = [2, 294], $Vf3 = [2, 291], $Vg3 = [2, 292], $Vh3 = [2, 304], $Vi3 = [2, 305], $Vj3 = [1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 174], $Vk3 = [2, 295], $Vl3 = [2, 297], $Vm3 = [2, 299], $Vn3 = [2, 301], $Vo3 = [2, 296], $Vp3 = [2, 298], $Vq3 = [2, 300], $Vr3 = [2, 302];
        var parser = { trace: function trace() { },
            yy: {},
            symbols_: { "error": 2, "Root": 3, "Body": 4, "Line": 5, "TERMINATOR": 6, "Expression": 7, "ExpressionLine": 8, "Statement": 9, "FuncDirective": 10, "YieldReturn": 11, "AwaitReturn": 12, "Return": 13, "STATEMENT": 14, "Import": 15, "Export": 16, "Value": 17, "Code": 18, "Operation": 19, "Assign": 20, "If": 21, "Try": 22, "While": 23, "For": 24, "Switch": 25, "Class": 26, "Throw": 27, "Yield": 28, "CodeLine": 29, "IfLine": 30, "OperationLine": 31, "YIELD": 32, "FROM": 33, "Block": 34, "INDENT": 35, "OUTDENT": 36, "Identifier": 37, "IDENTIFIER": 38, "CSX_TAG": 39, "Property": 40, "PROPERTY": 41, "AlphaNumeric": 42, "NUMBER": 43, "String": 44, "STRING": 45, "STRING_START": 46, "STRING_END": 47, "Regex": 48, "REGEX": 49, "REGEX_START": 50, "Invocation": 51, "REGEX_END": 52, "Literal": 53, "JS": 54, "UNDEFINED": 55, "NULL": 56, "BOOL": 57, "INFINITY": 58, "NAN": 59, "Assignable": 60, "=": 61, "AssignObj": 62, "ObjAssignable": 63, "ObjRestValue": 64, ":": 65, "SimpleObjAssignable": 66, "ThisProperty": 67, "[": 68, "]": 69, "...": 70, "ObjSpreadExpr": 71, "ObjSpreadIdentifier": 72, "Object": 73, "Parenthetical": 74, "Super": 75, "This": 76, "SUPER": 77, "Arguments": 78, "ObjSpreadAccessor": 79, ".": 80, "INDEX_START": 81, "IndexValue": 82, "INDEX_END": 83, "RETURN": 84, "AWAIT": 85, "PARAM_START": 86, "ParamList": 87, "PARAM_END": 88, "FuncGlyph": 89, "->": 90, "=>": 91, "OptComma": 92, ",": 93, "Param": 94, "ParamVar": 95, "Array": 96, "Splat": 97, "SimpleAssignable": 98, "Accessor": 99, "Range": 100, "?.": 101, "::": 102, "?::": 103, "Index": 104, "INDEX_SOAK": 105, "Slice": 106, "{": 107, "AssignList": 108, "}": 109, "CLASS": 110, "EXTENDS": 111, "IMPORT": 112, "ImportDefaultSpecifier": 113, "ImportNamespaceSpecifier": 114, "ImportSpecifierList": 115, "ImportSpecifier": 116, "AS": 117, "DEFAULT": 118, "IMPORT_ALL": 119, "EXPORT": 120, "ExportSpecifierList": 121, "EXPORT_ALL": 122, "ExportSpecifier": 123, "OptFuncExist": 124, "FUNC_EXIST": 125, "CALL_START": 126, "CALL_END": 127, "ArgList": 128, "THIS": 129, "@": 130, "Elisions": 131, "ArgElisionList": 132, "OptElisions": 133, "RangeDots": 134, "..": 135, "Arg": 136, "ArgElision": 137, "Elision": 138, "SimpleArgs": 139, "TRY": 140, "Catch": 141, "FINALLY": 142, "CATCH": 143, "THROW": 144, "(": 145, ")": 146, "WhileLineSource": 147, "WHILE": 148, "WHEN": 149, "UNTIL": 150, "WhileSource": 151, "Loop": 152, "LOOP": 153, "ForBody": 154, "ForLineBody": 155, "FOR": 156, "BY": 157, "ForStart": 158, "ForSource": 159, "ForLineSource": 160, "ForVariables": 161, "OWN": 162, "ForValue": 163, "FORIN": 164, "FOROF": 165, "FORFROM": 166, "SWITCH": 167, "Whens": 168, "ELSE": 169, "When": 170, "LEADING_WHEN": 171, "IfBlock": 172, "IF": 173, "POST_IF": 174, "IfBlockLine": 175, "UNARY": 176, "UNARY_MATH": 177, "-": 178, "+": 179, "--": 180, "++": 181, "?": 182, "MATH": 183, "**": 184, "SHIFT": 185, "COMPARE": 186, "&": 187, "^": 188, "|": 189, "&&": 190, "||": 191, "BIN?": 192, "RELATION": 193, "COMPOUND_ASSIGN": 194, "$accept": 0, "$end": 1 },
            terminals_: { 2: "error", 6: "TERMINATOR", 14: "STATEMENT", 32: "YIELD", 33: "FROM", 35: "INDENT", 36: "OUTDENT", 38: "IDENTIFIER", 39: "CSX_TAG", 41: "PROPERTY", 43: "NUMBER", 45: "STRING", 46: "STRING_START", 47: "STRING_END", 49: "REGEX", 50: "REGEX_START", 52: "REGEX_END", 54: "JS", 55: "UNDEFINED", 56: "NULL", 57: "BOOL", 58: "INFINITY", 59: "NAN", 61: "=", 65: ":", 68: "[", 69: "]", 70: "...", 77: "SUPER", 80: ".", 81: "INDEX_START", 83: "INDEX_END", 84: "RETURN", 85: "AWAIT", 86: "PARAM_START", 88: "PARAM_END", 90: "->", 91: "=>", 93: ",", 101: "?.", 102: "::", 103: "?::", 105: "INDEX_SOAK", 107: "{", 109: "}", 110: "CLASS", 111: "EXTENDS", 112: "IMPORT", 117: "AS", 118: "DEFAULT", 119: "IMPORT_ALL", 120: "EXPORT", 122: "EXPORT_ALL", 125: "FUNC_EXIST", 126: "CALL_START", 127: "CALL_END", 129: "THIS", 130: "@", 135: "..", 140: "TRY", 142: "FINALLY", 143: "CATCH", 144: "THROW", 145: "(", 146: ")", 148: "WHILE", 149: "WHEN", 150: "UNTIL", 153: "LOOP", 156: "FOR", 157: "BY", 162: "OWN", 164: "FORIN", 165: "FOROF", 166: "FORFROM", 167: "SWITCH", 169: "ELSE", 171: "LEADING_WHEN", 173: "IF", 174: "POST_IF", 176: "UNARY", 177: "UNARY_MATH", 178: "-", 179: "+", 180: "--", 181: "++", 182: "?", 183: "MATH", 184: "**", 185: "SHIFT", 186: "COMPARE", 187: "&", 188: "^", 189: "|", 190: "&&", 191: "||", 192: "BIN?", 193: "RELATION", 194: "COMPOUND_ASSIGN" },
            productions_: [0, [3, 0], [3, 1], [4, 1], [4, 3], [4, 2], [5, 1], [5, 1], [5, 1], [5, 1], [10, 1], [10, 1], [9, 1], [9, 1], [9, 1], [9, 1], [7, 1], [7, 1], [7, 1], [7, 1], [7, 1], [7, 1], [7, 1], [7, 1], [7, 1], [7, 1], [7, 1], [7, 1], [8, 1], [8, 1], [8, 1], [28, 1], [28, 2], [28, 3], [34, 2], [34, 3], [37, 1], [37, 1], [40, 1], [42, 1], [42, 1], [44, 1], [44, 3], [48, 1], [48, 3], [53, 1], [53, 1], [53, 1], [53, 1], [53, 1], [53, 1], [53, 1], [53, 1], [20, 3], [20, 4], [20, 5], [62, 1], [62, 1], [62, 3], [62, 5], [62, 3], [62, 5], [66, 1], [66, 1], [66, 1], [63, 1], [63, 3], [63, 1], [64, 2], [64, 2], [64, 2], [64, 2], [71, 1], [71, 1], [71, 1], [71, 1], [71, 1], [71, 2], [71, 2], [71, 2], [72, 2], [72, 2], [79, 2], [79, 3], [13, 2], [13, 4], [13, 1], [11, 3], [11, 2], [12, 3], [12, 2], [18, 5], [18, 2], [29, 5], [29, 2], [89, 1], [89, 1], [92, 0], [92, 1], [87, 0], [87, 1], [87, 3], [87, 4], [87, 6], [94, 1], [94, 2], [94, 2], [94, 3], [94, 1], [95, 1], [95, 1], [95, 1], [95, 1], [97, 2], [97, 2], [98, 1], [98, 2], [98, 2], [98, 1], [60, 1], [60, 1], [60, 1], [17, 1], [17, 1], [17, 1], [17, 1], [17, 1], [17, 1], [17, 1], [75, 3], [75, 4], [99, 2], [99, 2], [99, 2], [99, 2], [99, 1], [99, 1], [104, 3], [104, 2], [82, 1], [82, 1], [73, 4], [108, 0], [108, 1], [108, 3], [108, 4], [108, 6], [26, 1], [26, 2], [26, 3], [26, 4], [26, 2], [26, 3], [26, 4], [26, 5], [15, 2], [15, 4], [15, 4], [15, 5], [15, 7], [15, 6], [15, 9], [115, 1], [115, 3], [115, 4], [115, 4], [115, 6], [116, 1], [116, 3], [116, 1], [116, 3], [113, 1], [114, 3], [16, 3], [16, 5], [16, 2], [16, 4], [16, 5], [16, 6], [16, 3], [16, 5], [16, 4], [16, 7], [121, 1], [121, 3], [121, 4], [121, 4], [121, 6], [123, 1], [123, 3], [123, 3], [123, 1], [123, 3], [51, 3], [51, 3], [51, 3], [124, 0], [124, 1], [78, 2], [78, 4], [76, 1], [76, 1], [67, 2], [96, 2], [96, 3], [96, 4], [134, 1], [134, 1], [100, 5], [100, 5], [106, 3], [106, 2], [106, 3], [106, 2], [106, 2], [106, 1], [128, 1], [128, 3], [128, 4], [128, 4], [128, 6], [136, 1], [136, 1], [136, 1], [136, 1], [132, 1], [132, 3], [132, 4], [132, 4], [132, 6], [137, 1], [137, 2], [133, 1], [133, 2], [131, 1], [131, 2], [138, 1], [139, 1], [139, 1], [139, 3], [139, 3], [22, 2], [22, 3], [22, 4], [22, 5], [141, 3], [141, 3], [141, 2], [27, 2], [27, 4], [74, 3], [74, 5], [147, 2], [147, 4], [147, 2], [147, 4], [151, 2], [151, 4], [151, 4], [151, 2], [151, 4], [151, 4], [23, 2], [23, 2], [23, 2], [23, 2], [23, 1], [152, 2], [152, 2], [24, 2], [24, 2], [24, 2], [24, 2], [154, 2], [154, 4], [154, 2], [155, 4], [155, 2], [158, 2], [158, 3], [158, 3], [163, 1], [163, 1], [163, 1], [163, 1], [161, 1], [161, 3], [159, 2], [159, 2], [159, 4], [159, 4], [159, 4], [159, 4], [159, 4], [159, 4], [159, 6], [159, 6], [159, 6], [159, 6], [159, 6], [159, 6], [159, 6], [159, 6], [159, 2], [159, 4], [159, 4], [160, 2], [160, 2], [160, 4], [160, 4], [160, 4], [160, 4], [160, 4], [160, 4], [160, 6], [160, 6], [160, 6], [160, 6], [160, 6], [160, 6], [160, 6], [160, 6], [160, 2], [160, 4], [160, 4], [25, 5], [25, 5], [25, 7], [25, 7], [25, 4], [25, 6], [168, 1], [168, 2], [170, 3], [170, 4], [172, 3], [172, 5], [21, 1], [21, 3], [21, 3], [21, 3], [175, 3], [175, 5], [30, 1], [30, 3], [30, 3], [30, 3], [31, 2], [19, 2], [19, 2], [19, 2], [19, 2], [19, 2], [19, 2], [19, 2], [19, 2], [19, 2], [19, 2], [19, 3], [19, 3], [19, 3], [19, 3], [19, 3], [19, 3], [19, 3], [19, 3], [19, 3], [19, 3], [19, 3], [19, 3], [19, 3], [19, 3], [19, 5], [19, 4]],
            performAction: function anonymous(yytext, yyleng, yylineno, yy, yystate /* action[1] */, $$ /* vstack */, _$ /* lstack */) {
                /* this == yyval */
                var $0 = $$.length - 1;
                switch (yystate) {
                    case 1:
                        return this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.Block);
                        break;
                    case 2:
                        return this.$ = $$[$0];
                        break;
                    case 3:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(yy.Block.wrap([$$[$0]]));
                        break;
                    case 4:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])($$[$0 - 2].push($$[$0]));
                        break;
                    case 5:
                        this.$ = $$[$0 - 1];
                        break;
                    case 6:
                    case 7:
                    case 8:
                    case 9:
                    case 10:
                    case 11:
                    case 12:
                    case 14:
                    case 15:
                    case 16:
                    case 17:
                    case 18:
                    case 19:
                    case 20:
                    case 21:
                    case 22:
                    case 23:
                    case 24:
                    case 25:
                    case 26:
                    case 27:
                    case 28:
                    case 29:
                    case 30:
                    case 40:
                    case 45:
                    case 47:
                    case 57:
                    case 62:
                    case 63:
                    case 64:
                    case 65:
                    case 67:
                    case 72:
                    case 73:
                    case 74:
                    case 75:
                    case 76:
                    case 97:
                    case 98:
                    case 109:
                    case 110:
                    case 111:
                    case 112:
                    case 118:
                    case 119:
                    case 122:
                    case 127:
                    case 136:
                    case 221:
                    case 222:
                    case 223:
                    case 225:
                    case 237:
                    case 238:
                    case 281:
                    case 282:
                    case 331:
                    case 337:
                    case 343:
                        this.$ = $$[$0];
                        break;
                    case 13:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.StatementLiteral($$[$0]));
                        break;
                    case 31:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.Op($$[$0], new yy.Value(new yy.Literal(''))));
                        break;
                    case 32:
                    case 347:
                    case 348:
                    case 349:
                    case 352:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Op($$[$0 - 1], $$[$0]));
                        break;
                    case 33:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Op($$[$0 - 2].concat($$[$0 - 1]), $$[$0]));
                        break;
                    case 34:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Block);
                        break;
                    case 35:
                    case 83:
                    case 137:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])($$[$0 - 1]);
                        break;
                    case 36:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.IdentifierLiteral($$[$0]));
                        break;
                    case 37:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.CSXTag($$[$0]));
                        break;
                    case 38:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.PropertyName($$[$0]));
                        break;
                    case 39:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.NumberLiteral($$[$0]));
                        break;
                    case 41:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.StringLiteral($$[$0]));
                        break;
                    case 42:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.StringWithInterpolations($$[$0 - 1]));
                        break;
                    case 43:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.RegexLiteral($$[$0]));
                        break;
                    case 44:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.RegexWithInterpolations($$[$0 - 1].args));
                        break;
                    case 46:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.PassthroughLiteral($$[$0]));
                        break;
                    case 48:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.UndefinedLiteral($$[$0]));
                        break;
                    case 49:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.NullLiteral($$[$0]));
                        break;
                    case 50:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.BooleanLiteral($$[$0]));
                        break;
                    case 51:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.InfinityLiteral($$[$0]));
                        break;
                    case 52:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.NaNLiteral($$[$0]));
                        break;
                    case 53:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Assign($$[$0 - 2], $$[$0]));
                        break;
                    case 54:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.Assign($$[$0 - 3], $$[$0]));
                        break;
                    case 55:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.Assign($$[$0 - 4], $$[$0 - 1]));
                        break;
                    case 56:
                    case 115:
                    case 120:
                    case 121:
                    case 123:
                    case 124:
                    case 125:
                    case 126:
                    case 128:
                    case 283:
                    case 284:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.Value($$[$0]));
                        break;
                    case 58:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Assign(yy.addDataToNode(yy, _$[$0 - 2])(new yy.Value($$[$0 - 2])), $$[$0], 'object', {
                            operatorToken: yy.addDataToNode(yy, _$[$0 - 1])(new yy.Literal($$[$0 - 1]))
                        }));
                        break;
                    case 59:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.Assign(yy.addDataToNode(yy, _$[$0 - 4])(new yy.Value($$[$0 - 4])), $$[$0 - 1], 'object', {
                            operatorToken: yy.addDataToNode(yy, _$[$0 - 3])(new yy.Literal($$[$0 - 3]))
                        }));
                        break;
                    case 60:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Assign(yy.addDataToNode(yy, _$[$0 - 2])(new yy.Value($$[$0 - 2])), $$[$0], null, {
                            operatorToken: yy.addDataToNode(yy, _$[$0 - 1])(new yy.Literal($$[$0 - 1]))
                        }));
                        break;
                    case 61:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.Assign(yy.addDataToNode(yy, _$[$0 - 4])(new yy.Value($$[$0 - 4])), $$[$0 - 1], null, {
                            operatorToken: yy.addDataToNode(yy, _$[$0 - 3])(new yy.Literal($$[$0 - 3]))
                        }));
                        break;
                    case 66:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Value(new yy.ComputedPropertyName($$[$0 - 1])));
                        break;
                    case 68:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Splat(new yy.Value($$[$0 - 1])));
                        break;
                    case 69:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Splat(new yy.Value($$[$0])));
                        break;
                    case 70:
                    case 113:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Splat($$[$0 - 1]));
                        break;
                    case 71:
                    case 114:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Splat($$[$0]));
                        break;
                    case 77:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.SuperCall(yy.addDataToNode(yy, _$[$0 - 1])(new yy.Super), $$[$0], false, $$[$0 - 1]));
                        break;
                    case 78:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Call(new yy.Value($$[$0 - 1]), $$[$0]));
                        break;
                    case 79:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Call($$[$0 - 1], $$[$0]));
                        break;
                    case 80:
                    case 81:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])((new yy.Value($$[$0 - 1])).add($$[$0]));
                        break;
                    case 82:
                    case 131:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Access($$[$0]));
                        break;
                    case 84:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Return($$[$0]));
                        break;
                    case 85:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.Return(new yy.Value($$[$0 - 1])));
                        break;
                    case 86:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.Return);
                        break;
                    case 87:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.YieldReturn($$[$0]));
                        break;
                    case 88:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.YieldReturn);
                        break;
                    case 89:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.AwaitReturn($$[$0]));
                        break;
                    case 90:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.AwaitReturn);
                        break;
                    case 91:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.Code($$[$0 - 3], $$[$0], $$[$0 - 1], yy.addDataToNode(yy, _$[$0 - 4])(new yy.Literal($$[$0 - 4]))));
                        break;
                    case 92:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Code([], $$[$0], $$[$0 - 1]));
                        break;
                    case 93:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.Code($$[$0 - 3], yy.addDataToNode(yy, _$[$0])(yy.Block.wrap([$$[$0]])), $$[$0 - 1], yy.addDataToNode(yy, _$[$0 - 4])(new yy.Literal($$[$0 - 4]))));
                        break;
                    case 94:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Code([], yy.addDataToNode(yy, _$[$0])(yy.Block.wrap([$$[$0]])), $$[$0 - 1]));
                        break;
                    case 95:
                    case 96:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.FuncGlyph($$[$0]));
                        break;
                    case 99:
                    case 142:
                    case 232:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])([]);
                        break;
                    case 100:
                    case 143:
                    case 162:
                    case 183:
                    case 216:
                    case 230:
                    case 234:
                    case 285:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])([$$[$0]]);
                        break;
                    case 101:
                    case 144:
                    case 163:
                    case 184:
                    case 217:
                    case 226:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])($$[$0 - 2].concat($$[$0]));
                        break;
                    case 102:
                    case 145:
                    case 164:
                    case 185:
                    case 218:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])($$[$0 - 3].concat($$[$0]));
                        break;
                    case 103:
                    case 146:
                    case 166:
                    case 187:
                    case 220:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 5], _$[$0])($$[$0 - 5].concat($$[$0 - 2]));
                        break;
                    case 104:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.Param($$[$0]));
                        break;
                    case 105:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Param($$[$0 - 1], null, true));
                        break;
                    case 106:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Param($$[$0], null, true));
                        break;
                    case 107:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Param($$[$0 - 2], $$[$0]));
                        break;
                    case 108:
                    case 224:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.Expansion);
                        break;
                    case 116:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])($$[$0 - 1].add($$[$0]));
                        break;
                    case 117:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Value($$[$0 - 1]).add($$[$0]));
                        break;
                    case 129:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Super(yy.addDataToNode(yy, _$[$0])(new yy.Access($$[$0])), [], false, $$[$0 - 2]));
                        break;
                    case 130:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.Super(yy.addDataToNode(yy, _$[$0 - 1])(new yy.Index($$[$0 - 1])), [], false, $$[$0 - 3]));
                        break;
                    case 132:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Access($$[$0], 'soak'));
                        break;
                    case 133:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])([yy.addDataToNode(yy, _$[$0 - 1])(new yy.Access(new yy.PropertyName('prototype'))),
                            yy.addDataToNode(yy, _$[$0])(new yy.Access($$[$0]))]);
                        break;
                    case 134:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])([yy.addDataToNode(yy, _$[$0 - 1])(new yy.Access(new yy.PropertyName('prototype'), 'soak')),
                            yy.addDataToNode(yy, _$[$0])(new yy.Access($$[$0]))]);
                        break;
                    case 135:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.Access(new yy.PropertyName('prototype')));
                        break;
                    case 138:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(yy.extend($$[$0], {
                            soak: true
                        }));
                        break;
                    case 139:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.Index($$[$0]));
                        break;
                    case 140:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.Slice($$[$0]));
                        break;
                    case 141:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.Obj($$[$0 - 2], $$[$0 - 3].generated));
                        break;
                    case 147:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.Class);
                        break;
                    case 148:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Class(null, null, $$[$0]));
                        break;
                    case 149:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Class(null, $$[$0]));
                        break;
                    case 150:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.Class(null, $$[$0 - 1], $$[$0]));
                        break;
                    case 151:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Class($$[$0]));
                        break;
                    case 152:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Class($$[$0 - 1], null, $$[$0]));
                        break;
                    case 153:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.Class($$[$0 - 2], $$[$0]));
                        break;
                    case 154:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.Class($$[$0 - 3], $$[$0 - 1], $$[$0]));
                        break;
                    case 155:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.ImportDeclaration(null, $$[$0]));
                        break;
                    case 156:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.ImportDeclaration(new yy.ImportClause($$[$0 - 2], null), $$[$0]));
                        break;
                    case 157:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.ImportDeclaration(new yy.ImportClause(null, $$[$0 - 2]), $$[$0]));
                        break;
                    case 158:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.ImportDeclaration(new yy.ImportClause(null, new yy.ImportSpecifierList([])), $$[$0]));
                        break;
                    case 159:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 6], _$[$0])(new yy.ImportDeclaration(new yy.ImportClause(null, new yy.ImportSpecifierList($$[$0 - 4])), $$[$0]));
                        break;
                    case 160:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 5], _$[$0])(new yy.ImportDeclaration(new yy.ImportClause($$[$0 - 4], $$[$0 - 2]), $$[$0]));
                        break;
                    case 161:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 8], _$[$0])(new yy.ImportDeclaration(new yy.ImportClause($$[$0 - 7], new yy.ImportSpecifierList($$[$0 - 4])), $$[$0]));
                        break;
                    case 165:
                    case 186:
                    case 199:
                    case 219:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])($$[$0 - 2]);
                        break;
                    case 167:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.ImportSpecifier($$[$0]));
                        break;
                    case 168:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.ImportSpecifier($$[$0 - 2], $$[$0]));
                        break;
                    case 169:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.ImportSpecifier(new yy.Literal($$[$0])));
                        break;
                    case 170:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.ImportSpecifier(new yy.Literal($$[$0 - 2]), $$[$0]));
                        break;
                    case 171:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.ImportDefaultSpecifier($$[$0]));
                        break;
                    case 172:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.ImportNamespaceSpecifier(new yy.Literal($$[$0 - 2]), $$[$0]));
                        break;
                    case 173:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.ExportNamedDeclaration(new yy.ExportSpecifierList([])));
                        break;
                    case 174:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.ExportNamedDeclaration(new yy.ExportSpecifierList($$[$0 - 2])));
                        break;
                    case 175:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.ExportNamedDeclaration($$[$0]));
                        break;
                    case 176:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.ExportNamedDeclaration(new yy.Assign($$[$0 - 2], $$[$0], null, {
                            moduleDeclaration: 'export'
                        })));
                        break;
                    case 177:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.ExportNamedDeclaration(new yy.Assign($$[$0 - 3], $$[$0], null, {
                            moduleDeclaration: 'export'
                        })));
                        break;
                    case 178:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 5], _$[$0])(new yy.ExportNamedDeclaration(new yy.Assign($$[$0 - 4], $$[$0 - 1], null, {
                            moduleDeclaration: 'export'
                        })));
                        break;
                    case 179:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.ExportDefaultDeclaration($$[$0]));
                        break;
                    case 180:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.ExportDefaultDeclaration(new yy.Value($$[$0 - 1])));
                        break;
                    case 181:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.ExportAllDeclaration(new yy.Literal($$[$0 - 2]), $$[$0]));
                        break;
                    case 182:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 6], _$[$0])(new yy.ExportNamedDeclaration(new yy.ExportSpecifierList($$[$0 - 4]), $$[$0]));
                        break;
                    case 188:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.ExportSpecifier($$[$0]));
                        break;
                    case 189:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.ExportSpecifier($$[$0 - 2], $$[$0]));
                        break;
                    case 190:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.ExportSpecifier($$[$0 - 2], new yy.Literal($$[$0])));
                        break;
                    case 191:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.ExportSpecifier(new yy.Literal($$[$0])));
                        break;
                    case 192:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.ExportSpecifier(new yy.Literal($$[$0 - 2]), $$[$0]));
                        break;
                    case 193:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.TaggedTemplateCall($$[$0 - 2], $$[$0], $$[$0 - 1]));
                        break;
                    case 194:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Call($$[$0 - 2], $$[$0], $$[$0 - 1]));
                        break;
                    case 195:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.SuperCall(yy.addDataToNode(yy, _$[$0 - 2])(new yy.Super), $$[$0], $$[$0 - 1], $$[$0 - 2]));
                        break;
                    case 196:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(false);
                        break;
                    case 197:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(true);
                        break;
                    case 198:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])([]);
                        break;
                    case 200:
                    case 201:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.Value(new yy.ThisLiteral($$[$0])));
                        break;
                    case 202:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Value(yy.addDataToNode(yy, _$[$0 - 1])(new yy.ThisLiteral($$[$0 - 1])), [yy.addDataToNode(yy, _$[$0])(new yy.Access($$[$0]))], 'this'));
                        break;
                    case 203:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Arr([]));
                        break;
                    case 204:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Arr($$[$0 - 1]));
                        break;
                    case 205:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.Arr([].concat($$[$0 - 2], $$[$0 - 1])));
                        break;
                    case 206:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])('inclusive');
                        break;
                    case 207:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])('exclusive');
                        break;
                    case 208:
                    case 209:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.Range($$[$0 - 3], $$[$0 - 1], $$[$0 - 2]));
                        break;
                    case 210:
                    case 212:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Range($$[$0 - 2], $$[$0], $$[$0 - 1]));
                        break;
                    case 211:
                    case 213:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Range($$[$0 - 1], null, $$[$0]));
                        break;
                    case 214:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Range(null, $$[$0], $$[$0 - 1]));
                        break;
                    case 215:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.Range(null, null, $$[$0]));
                        break;
                    case 227:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])($$[$0 - 3].concat($$[$0 - 2], $$[$0]));
                        break;
                    case 228:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])($$[$0 - 2].concat($$[$0 - 1]));
                        break;
                    case 229:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 5], _$[$0])($$[$0 - 5].concat($$[$0 - 4], $$[$0 - 2], $$[$0 - 1]));
                        break;
                    case 231:
                    case 235:
                    case 332:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])($$[$0 - 1].concat($$[$0]));
                        break;
                    case 233:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])([].concat($$[$0]));
                        break;
                    case 236:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])(new yy.Elision);
                        break;
                    case 239:
                    case 240:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])([].concat($$[$0 - 2], $$[$0]));
                        break;
                    case 241:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Try($$[$0]));
                        break;
                    case 242:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Try($$[$0 - 1], $$[$0][0], $$[$0][1]));
                        break;
                    case 243:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.Try($$[$0 - 2], null, null, $$[$0]));
                        break;
                    case 244:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.Try($$[$0 - 3], $$[$0 - 2][0], $$[$0 - 2][1], $$[$0]));
                        break;
                    case 245:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])([$$[$0 - 1],
                            $$[$0]]);
                        break;
                    case 246:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])([yy.addDataToNode(yy, _$[$0 - 1])(new yy.Value($$[$0 - 1])),
                            $$[$0]]);
                        break;
                    case 247:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])([null,
                            $$[$0]]);
                        break;
                    case 248:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Throw($$[$0]));
                        break;
                    case 249:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.Throw(new yy.Value($$[$0 - 1])));
                        break;
                    case 250:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Parens($$[$0 - 1]));
                        break;
                    case 251:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.Parens($$[$0 - 2]));
                        break;
                    case 252:
                    case 256:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.While($$[$0]));
                        break;
                    case 253:
                    case 257:
                    case 258:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.While($$[$0 - 2], {
                            guard: $$[$0]
                        }));
                        break;
                    case 254:
                    case 259:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.While($$[$0], {
                            invert: true
                        }));
                        break;
                    case 255:
                    case 260:
                    case 261:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.While($$[$0 - 2], {
                            invert: true,
                            guard: $$[$0]
                        }));
                        break;
                    case 262:
                    case 263:
                    case 271:
                    case 272:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])($$[$0 - 1].addBody($$[$0]));
                        break;
                    case 264:
                    case 265:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])($$[$0].addBody(yy.addDataToNode(yy, _$[$0 - 1])(yy.Block.wrap([$$[$0 - 1]]))));
                        break;
                    case 266:
                        this.$ = yy.addDataToNode(yy, _$[$0], _$[$0])($$[$0]);
                        break;
                    case 267:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.While(yy.addDataToNode(yy, _$[$0 - 1])(new yy.BooleanLiteral('true'))).addBody($$[$0]));
                        break;
                    case 268:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.While(yy.addDataToNode(yy, _$[$0 - 1])(new yy.BooleanLiteral('true'))).addBody(yy.addDataToNode(yy, _$[$0])(yy.Block.wrap([$$[$0]]))));
                        break;
                    case 269:
                    case 270:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])($$[$0].addBody($$[$0 - 1]));
                        break;
                    case 273:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.For([], {
                            source: yy.addDataToNode(yy, _$[$0])(new yy.Value($$[$0]))
                        }));
                        break;
                    case 274:
                    case 276:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.For([], {
                            source: yy.addDataToNode(yy, _$[$0 - 2])(new yy.Value($$[$0 - 2])),
                            step: $$[$0]
                        }));
                        break;
                    case 275:
                    case 277:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])($$[$0 - 1].addSource($$[$0]));
                        break;
                    case 278:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.For([], {
                            name: $$[$0][0],
                            index: $$[$0][1]
                        }));
                        break;
                    case 279:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])((function () {
                            var index, name;
                            [name,
                                index] = $$[$0];
                            return new yy.For([], {
                                name,
                                index,
                                await: true,
                                awaitTag: yy.addDataToNode(yy, _$[$0 - 1])(new yy.Literal($$[$0 - 1]))
                            });
                        }()));
                        break;
                    case 280:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])((function () {
                            var index, name;
                            [name,
                                index] = $$[$0];
                            return new yy.For([], {
                                name,
                                index,
                                own: true,
                                ownTag: yy.addDataToNode(yy, _$[$0 - 1])(new yy.Literal($$[$0 - 1]))
                            });
                        }()));
                        break;
                    case 286:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])([$$[$0 - 2],
                            $$[$0]]);
                        break;
                    case 287:
                    case 306:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])({
                            source: $$[$0]
                        });
                        break;
                    case 288:
                    case 307:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])({
                            source: $$[$0],
                            object: true
                        });
                        break;
                    case 289:
                    case 290:
                    case 308:
                    case 309:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])({
                            source: $$[$0 - 2],
                            guard: $$[$0]
                        });
                        break;
                    case 291:
                    case 292:
                    case 310:
                    case 311:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])({
                            source: $$[$0 - 2],
                            guard: $$[$0],
                            object: true
                        });
                        break;
                    case 293:
                    case 294:
                    case 312:
                    case 313:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])({
                            source: $$[$0 - 2],
                            step: $$[$0]
                        });
                        break;
                    case 295:
                    case 296:
                    case 297:
                    case 298:
                    case 314:
                    case 315:
                    case 316:
                    case 317:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 5], _$[$0])({
                            source: $$[$0 - 4],
                            guard: $$[$0 - 2],
                            step: $$[$0]
                        });
                        break;
                    case 299:
                    case 300:
                    case 301:
                    case 302:
                    case 318:
                    case 319:
                    case 320:
                    case 321:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 5], _$[$0])({
                            source: $$[$0 - 4],
                            step: $$[$0 - 2],
                            guard: $$[$0]
                        });
                        break;
                    case 303:
                    case 322:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])({
                            source: $$[$0],
                            from: true
                        });
                        break;
                    case 304:
                    case 305:
                    case 323:
                    case 324:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])({
                            source: $$[$0 - 2],
                            guard: $$[$0],
                            from: true
                        });
                        break;
                    case 325:
                    case 326:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.Switch($$[$0 - 3], $$[$0 - 1]));
                        break;
                    case 327:
                    case 328:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 6], _$[$0])(new yy.Switch($$[$0 - 5], $$[$0 - 3], $$[$0 - 1]));
                        break;
                    case 329:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.Switch(null, $$[$0 - 1]));
                        break;
                    case 330:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 5], _$[$0])(new yy.Switch(null, $$[$0 - 3], $$[$0 - 1]));
                        break;
                    case 333:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])([[$$[$0 - 1],
                                $$[$0]]]);
                        break;
                    case 334:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])([[$$[$0 - 2],
                                $$[$0 - 1]]]);
                        break;
                    case 335:
                    case 341:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.If($$[$0 - 1], $$[$0], {
                            type: $$[$0 - 2]
                        }));
                        break;
                    case 336:
                    case 342:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])($$[$0 - 4].addElse(yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.If($$[$0 - 1], $$[$0], {
                            type: $$[$0 - 2]
                        }))));
                        break;
                    case 338:
                    case 344:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])($$[$0 - 2].addElse($$[$0]));
                        break;
                    case 339:
                    case 340:
                    case 345:
                    case 346:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.If($$[$0], yy.addDataToNode(yy, _$[$0 - 2])(yy.Block.wrap([$$[$0 - 2]])), {
                            type: $$[$0 - 1],
                            statement: true
                        }));
                        break;
                    case 350:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Op('-', $$[$0]));
                        break;
                    case 351:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Op('+', $$[$0]));
                        break;
                    case 353:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Op('--', $$[$0]));
                        break;
                    case 354:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Op('++', $$[$0]));
                        break;
                    case 355:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Op('--', $$[$0 - 1], null, true));
                        break;
                    case 356:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Op('++', $$[$0 - 1], null, true));
                        break;
                    case 357:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 1], _$[$0])(new yy.Existence($$[$0 - 1]));
                        break;
                    case 358:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Op('+', $$[$0 - 2], $$[$0]));
                        break;
                    case 359:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Op('-', $$[$0 - 2], $$[$0]));
                        break;
                    case 360:
                    case 361:
                    case 362:
                    case 363:
                    case 364:
                    case 365:
                    case 366:
                    case 367:
                    case 368:
                    case 369:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Op($$[$0 - 1], $$[$0 - 2], $$[$0]));
                        break;
                    case 370:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])((function () {
                            if ($$[$0 - 1].charAt(0) === '!') {
                                return new yy.Op($$[$0 - 1].slice(1), $$[$0 - 2], $$[$0]).invert();
                            }
                            else {
                                return new yy.Op($$[$0 - 1], $$[$0 - 2], $$[$0]);
                            }
                        }()));
                        break;
                    case 371:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 2], _$[$0])(new yy.Assign($$[$0 - 2], $$[$0], $$[$0 - 1]));
                        break;
                    case 372:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 4], _$[$0])(new yy.Assign($$[$0 - 4], $$[$0 - 1], $$[$0 - 3]));
                        break;
                    case 373:
                        this.$ = yy.addDataToNode(yy, _$[$0 - 3], _$[$0])(new yy.Assign($$[$0 - 3], $$[$0], $$[$0 - 2]));
                        break;
                }
            },
            table: [{ 1: [2, 1], 3: 1, 4: 2, 5: 3, 7: 4, 8: 5, 9: 6, 10: 7, 11: 27, 12: 28, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $V1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vi, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 1: [3] }, { 1: [2, 2], 6: $VH }, o($VI, [2, 3]), o($VJ, [2, 6], { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($VJ, [2, 7]), o($VJ, [2, 8], { 158: 116, 151: 118, 154: 119, 148: $VK, 150: $VL, 156: $VM, 174: $V01 }), o($VJ, [2, 9]), o($V11, [2, 16], { 124: 120, 99: 121, 104: 127, 45: $V21, 46: $V21, 126: $V21, 80: $V31, 81: $V41, 101: $V51, 102: $V61, 103: $V71, 105: $V81, 125: $V91 }), o($V11, [2, 17], { 104: 127, 99: 130, 80: $V31, 81: $V41, 101: $V51, 102: $V61, 103: $V71, 105: $V81 }), o($V11, [2, 18]), o($V11, [2, 19]), o($V11, [2, 20]), o($V11, [2, 21]), o($V11, [2, 22]), o($V11, [2, 23]), o($V11, [2, 24]), o($V11, [2, 25]), o($V11, [2, 26]), o($V11, [2, 27]), o($VJ, [2, 28]), o($VJ, [2, 29]), o($VJ, [2, 30]), o($Va1, [2, 12]), o($Va1, [2, 13]), o($Va1, [2, 14]), o($Va1, [2, 15]), o($VJ, [2, 10]), o($VJ, [2, 11]), o($Vb1, $Vc1, { 61: [1, 131] }), o($Vb1, [2, 123]), o($Vb1, [2, 124]), o($Vb1, [2, 125]), o($Vb1, $Vd1), o($Vb1, [2, 127]), o($Vb1, [2, 128]), o($Ve1, $Vf1, { 87: 132, 94: 133, 95: 134, 37: 136, 67: 137, 96: 138, 73: 139, 38: $V2, 39: $V3, 68: $Vg1, 70: $Vh1, 107: $Vm, 130: $Vi1 }), { 5: 143, 7: 4, 8: 5, 9: 6, 10: 7, 11: 27, 12: 28, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $V1, 34: 142, 35: $Vj1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vi, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 145, 8: 146, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 150, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 156, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 157, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 158, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: [1, 159], 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 17: 161, 18: 162, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 163, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 160, 100: 32, 107: $Vm, 129: $Vq, 130: $Vr, 145: $Vu }, { 17: 161, 18: 162, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 163, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 164, 100: 32, 107: $Vm, 129: $Vq, 130: $Vr, 145: $Vu }, o($Vp1, $Vq1, { 180: [1, 165], 181: [1, 166], 194: [1, 167] }), o($V11, [2, 337], { 169: [1, 168] }), { 34: 169, 35: $Vj1 }, { 34: 170, 35: $Vj1 }, { 34: 171, 35: $Vj1 }, o($V11, [2, 266]), { 34: 172, 35: $Vj1 }, { 34: 173, 35: $Vj1 }, { 7: 174, 8: 175, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 35: [1, 176], 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vr1, [2, 147], { 53: 30, 74: 31, 100: 32, 51: 33, 76: 34, 75: 35, 96: 61, 73: 62, 42: 63, 48: 65, 37: 78, 67: 79, 44: 88, 89: 152, 17: 161, 18: 162, 60: 163, 34: 177, 98: 179, 35: $Vj1, 38: $V2, 39: $V3, 43: $V4, 45: $V5, 46: $V6, 49: $V7, 50: $V8, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 68: $Vf, 77: $Vg, 86: $Vm1, 90: $Vk, 91: $Vl, 107: $Vm, 111: [1, 178], 129: $Vq, 130: $Vr, 145: $Vu }), { 7: 180, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 35: [1, 181], 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o([1, 6, 35, 36, 47, 69, 70, 93, 127, 135, 146, 148, 149, 150, 156, 157, 174, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $Vs1, { 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 13: 23, 15: 25, 16: 26, 60: 29, 53: 30, 74: 31, 100: 32, 51: 33, 76: 34, 75: 35, 98: 45, 172: 46, 151: 48, 147: 49, 152: 50, 154: 51, 155: 52, 96: 61, 73: 62, 42: 63, 48: 65, 37: 78, 67: 79, 158: 85, 44: 88, 89: 152, 9: 154, 7: 182, 14: $V0, 32: $Vk1, 33: $Vt1, 38: $V2, 39: $V3, 43: $V4, 45: $V5, 46: $V6, 49: $V7, 50: $V8, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 68: $Vf, 77: $Vg, 84: [1, 184], 85: $Vl1, 86: $Vm1, 90: $Vk, 91: $Vl, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 153: $Vx, 167: $Vz, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }), o($VJ, [2, 343], { 169: [1, 185] }), o([1, 6, 36, 47, 69, 70, 93, 127, 135, 146, 148, 149, 150, 156, 157, 174], $Vu1, { 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 13: 23, 15: 25, 16: 26, 60: 29, 53: 30, 74: 31, 100: 32, 51: 33, 76: 34, 75: 35, 98: 45, 172: 46, 151: 48, 147: 49, 152: 50, 154: 51, 155: 52, 96: 61, 73: 62, 42: 63, 48: 65, 37: 78, 67: 79, 158: 85, 44: 88, 89: 152, 9: 154, 7: 186, 14: $V0, 32: $Vk1, 35: $Vv1, 38: $V2, 39: $V3, 43: $V4, 45: $V5, 46: $V6, 49: $V7, 50: $V8, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 68: $Vf, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 90: $Vk, 91: $Vl, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 153: $Vx, 167: $Vz, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }), { 37: 192, 38: $V2, 39: $V3, 44: 188, 45: $V5, 46: $V6, 107: [1, 191], 113: 189, 114: 190, 119: $Vw1 }, { 26: 195, 37: 196, 38: $V2, 39: $V3, 107: [1, 194], 110: $Vn, 118: [1, 197], 122: [1, 198] }, o($Vp1, [2, 120]), o($Vp1, [2, 121]), o($Vb1, [2, 45]), o($Vb1, [2, 46]), o($Vb1, [2, 47]), o($Vb1, [2, 48]), o($Vb1, [2, 49]), o($Vb1, [2, 50]), o($Vb1, [2, 51]), o($Vb1, [2, 52]), { 4: 199, 5: 3, 7: 4, 8: 5, 9: 6, 10: 7, 11: 27, 12: 28, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $V1, 35: [1, 200], 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vi, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 201, 8: 202, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 35: $Vx1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 69: $Vy1, 70: $Vz1, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 93: $VA1, 96: 61, 97: 211, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 131: 204, 132: 205, 136: 210, 137: 207, 138: 206, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 80: $VB1, 81: $VC1, 124: 213, 125: $V91, 126: $V21 }, o($Vb1, [2, 200]), o($Vb1, [2, 201], { 40: 216, 41: $VD1 }), o($VE1, [2, 95]), o($VE1, [2, 96]), o($VF1, [2, 115]), o($VF1, [2, 118]), { 7: 218, 8: 219, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 220, 8: 221, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 222, 8: 223, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 225, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 34: 224, 35: $Vj1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 37: 231, 38: $V2, 39: $V3, 67: 232, 68: $Vf, 73: 234, 85: $VG1, 96: 233, 100: 226, 107: $Vm, 130: $Vi1, 161: 227, 162: $VH1, 163: 230 }, { 159: 235, 160: 236, 164: [1, 237], 165: [1, 238], 166: [1, 239] }, o([6, 35, 93, 109], $VI1, { 44: 88, 108: 240, 62: 241, 63: 242, 64: 243, 66: 244, 42: 246, 71: 248, 37: 249, 40: 250, 67: 251, 72: 252, 73: 253, 74: 254, 75: 255, 76: 256, 38: $V2, 39: $V3, 41: $VD1, 43: $V4, 45: $V5, 46: $V6, 68: $VJ1, 70: $VK1, 77: $VL1, 107: $Vm, 129: $Vq, 130: $Vr, 145: $Vu }), o($VM1, [2, 39]), o($VM1, [2, 40]), o($Vb1, [2, 43]), { 17: 161, 18: 162, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 258, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 163, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 259, 100: 32, 107: $Vm, 129: $Vq, 130: $Vr, 145: $Vu }, o($VN1, [2, 36]), o($VN1, [2, 37]), o($VO1, [2, 41]), { 4: 260, 5: 3, 7: 4, 8: 5, 9: 6, 10: 7, 11: 27, 12: 28, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $V1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vi, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($VI, [2, 5], { 7: 4, 8: 5, 9: 6, 10: 7, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 13: 23, 15: 25, 16: 26, 11: 27, 12: 28, 60: 29, 53: 30, 74: 31, 100: 32, 51: 33, 76: 34, 75: 35, 89: 37, 98: 45, 172: 46, 151: 48, 147: 49, 152: 50, 154: 51, 155: 52, 175: 57, 96: 61, 73: 62, 42: 63, 48: 65, 37: 78, 67: 79, 158: 85, 44: 88, 5: 261, 14: $V0, 32: $V1, 38: $V2, 39: $V3, 43: $V4, 45: $V5, 46: $V6, 49: $V7, 50: $V8, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 68: $Vf, 77: $Vg, 84: $Vh, 85: $Vi, 86: $Vj, 90: $Vk, 91: $Vl, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 148: $Vv, 150: $Vw, 153: $Vx, 156: $Vy, 167: $Vz, 173: $VA, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }), o($V11, [2, 357]), { 7: 262, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 263, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 264, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 265, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 266, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 267, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 268, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 269, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 270, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 271, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 272, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 273, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 274, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 275, 8: 276, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($V11, [2, 265]), o($V11, [2, 270]), { 7: 220, 8: 277, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 222, 8: 278, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 37: 231, 38: $V2, 39: $V3, 67: 232, 68: $Vf, 73: 234, 85: $VG1, 96: 233, 100: 279, 107: $Vm, 130: $Vi1, 161: 227, 162: $VH1, 163: 230 }, { 159: 235, 164: [1, 280], 165: [1, 281], 166: [1, 282] }, { 7: 283, 8: 284, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($V11, [2, 264]), o($V11, [2, 269]), { 44: 285, 45: $V5, 46: $V6, 78: 286, 126: $VP1 }, o($VF1, [2, 116]), o($VQ1, [2, 197]), { 40: 288, 41: $VD1 }, { 40: 289, 41: $VD1 }, o($VF1, [2, 135], { 40: 290, 41: $VD1 }), { 40: 291, 41: $VD1 }, o($VF1, [2, 136]), { 7: 293, 8: 295, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 70: $VR1, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 82: 292, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 106: 294, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 134: 296, 135: $VS1, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 81: $V41, 104: 299, 105: $V81 }, o($VF1, [2, 117]), { 6: [1, 301], 7: 300, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 35: [1, 302], 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($VT1, $VU1, { 92: 305, 88: [1, 303], 93: $VV1 }), o($VW1, [2, 100]), o($VW1, [2, 104], { 61: [1, 307], 70: [1, 306] }), o($VW1, [2, 108], { 37: 136, 67: 137, 96: 138, 73: 139, 95: 308, 38: $V2, 39: $V3, 68: $Vg1, 107: $Vm, 130: $Vi1 }), o($VX1, [2, 109]), o($VX1, [2, 110]), o($VX1, [2, 111]), o($VX1, [2, 112]), { 40: 216, 41: $VD1 }, { 7: 309, 8: 310, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 35: $Vx1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 69: $Vy1, 70: $Vz1, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 93: $VA1, 96: 61, 97: 211, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 131: 204, 132: 205, 136: 210, 137: 207, 138: 206, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($VY1, [2, 92]), o($VJ, [2, 94]), { 4: 312, 5: 3, 7: 4, 8: 5, 9: 6, 10: 7, 11: 27, 12: 28, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $V1, 36: [1, 311], 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vi, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($VZ1, $V_1, { 151: 111, 154: 112, 158: 116, 182: $VQ }), o($VJ, [2, 347]), { 7: 158, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 148: $VK, 150: $VL, 151: 118, 154: 119, 156: $VM, 158: 116, 174: $V01 }, o([1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $Vs1, { 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 13: 23, 15: 25, 16: 26, 60: 29, 53: 30, 74: 31, 100: 32, 51: 33, 76: 34, 75: 35, 98: 45, 172: 46, 151: 48, 147: 49, 152: 50, 154: 51, 155: 52, 96: 61, 73: 62, 42: 63, 48: 65, 37: 78, 67: 79, 158: 85, 44: 88, 89: 152, 9: 154, 7: 182, 14: $V0, 32: $Vk1, 33: $Vt1, 38: $V2, 39: $V3, 43: $V4, 45: $V5, 46: $V6, 49: $V7, 50: $V8, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 68: $Vf, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 90: $Vk, 91: $Vl, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 153: $Vx, 167: $Vz, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }), o($V$1, [2, 349], { 151: 111, 154: 112, 158: 116, 182: $VQ, 184: $VS }), o($Ve1, $Vf1, { 94: 133, 95: 134, 37: 136, 67: 137, 96: 138, 73: 139, 87: 314, 38: $V2, 39: $V3, 68: $Vg1, 70: $Vh1, 107: $Vm, 130: $Vi1 }), { 34: 142, 35: $Vj1 }, { 7: 315, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 148: $VK, 150: $VL, 151: 118, 154: 119, 156: $VM, 158: 116, 174: [1, 316] }, { 7: 317, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($V$1, [2, 350], { 151: 111, 154: 112, 158: 116, 182: $VQ, 184: $VS }), o($V$1, [2, 351], { 151: 111, 154: 112, 158: 116, 182: $VQ, 184: $VS }), o($VZ1, [2, 352], { 151: 111, 154: 112, 158: 116, 182: $VQ }), o($VJ, [2, 90], { 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 13: 23, 15: 25, 16: 26, 60: 29, 53: 30, 74: 31, 100: 32, 51: 33, 76: 34, 75: 35, 98: 45, 172: 46, 151: 48, 147: 49, 152: 50, 154: 51, 155: 52, 96: 61, 73: 62, 42: 63, 48: 65, 37: 78, 67: 79, 158: 85, 44: 88, 89: 152, 9: 154, 7: 318, 14: $V0, 32: $Vk1, 38: $V2, 39: $V3, 43: $V4, 45: $V5, 46: $V6, 49: $V7, 50: $V8, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 68: $Vf, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 90: $Vk, 91: $Vl, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 148: $Vu1, 150: $Vu1, 156: $Vu1, 174: $Vu1, 153: $Vx, 167: $Vz, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }), o($V11, [2, 353], { 45: $Vq1, 46: $Vq1, 80: $Vq1, 81: $Vq1, 101: $Vq1, 102: $Vq1, 103: $Vq1, 105: $Vq1, 125: $Vq1, 126: $Vq1 }), o($VQ1, $V21, { 124: 120, 99: 121, 104: 127, 80: $V31, 81: $V41, 101: $V51, 102: $V61, 103: $V71, 105: $V81, 125: $V91 }), { 80: $V31, 81: $V41, 99: 130, 101: $V51, 102: $V61, 103: $V71, 104: 127, 105: $V81 }, o($V02, $Vc1), o($V11, [2, 354], { 45: $Vq1, 46: $Vq1, 80: $Vq1, 81: $Vq1, 101: $Vq1, 102: $Vq1, 103: $Vq1, 105: $Vq1, 125: $Vq1, 126: $Vq1 }), o($V11, [2, 355]), o($V11, [2, 356]), { 6: [1, 321], 7: 319, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 35: [1, 320], 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 34: 322, 35: $Vj1, 173: [1, 323] }, o($V11, [2, 241], { 141: 324, 142: [1, 325], 143: [1, 326] }), o($V11, [2, 262]), o($V11, [2, 263]), o($V11, [2, 271]), o($V11, [2, 272]), { 35: [1, 327], 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [1, 328] }, { 168: 329, 170: 330, 171: $V12 }, o($V11, [2, 148]), { 7: 332, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vr1, [2, 151], { 34: 333, 35: $Vj1, 45: $Vq1, 46: $Vq1, 80: $Vq1, 81: $Vq1, 101: $Vq1, 102: $Vq1, 103: $Vq1, 105: $Vq1, 125: $Vq1, 126: $Vq1, 111: [1, 334] }), o($V22, [2, 248], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 73: 335, 107: $Vm }, o($V22, [2, 32], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 7: 336, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o([1, 6, 36, 47, 69, 70, 93, 127, 135, 146, 149, 157], [2, 88], { 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 13: 23, 15: 25, 16: 26, 60: 29, 53: 30, 74: 31, 100: 32, 51: 33, 76: 34, 75: 35, 98: 45, 172: 46, 151: 48, 147: 49, 152: 50, 154: 51, 155: 52, 96: 61, 73: 62, 42: 63, 48: 65, 37: 78, 67: 79, 158: 85, 44: 88, 89: 152, 9: 154, 7: 337, 14: $V0, 32: $Vk1, 35: $Vv1, 38: $V2, 39: $V3, 43: $V4, 45: $V5, 46: $V6, 49: $V7, 50: $V8, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 68: $Vf, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 90: $Vk, 91: $Vl, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 148: $Vu1, 150: $Vu1, 156: $Vu1, 174: $Vu1, 153: $Vx, 167: $Vz, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }), { 34: 338, 35: $Vj1, 173: [1, 339] }, o($Va1, $V32, { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 73: 340, 107: $Vm }, o($Va1, [2, 155]), { 33: [1, 341], 93: [1, 342] }, { 33: [1, 343] }, { 35: $V42, 37: 348, 38: $V2, 39: $V3, 109: [1, 344], 115: 345, 116: 346, 118: $V52 }, o([33, 93], [2, 171]), { 117: [1, 350] }, { 35: $V62, 37: 355, 38: $V2, 39: $V3, 109: [1, 351], 118: $V72, 121: 352, 123: 353 }, o($Va1, [2, 175]), { 61: [1, 357] }, { 7: 358, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 35: [1, 359], 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 33: [1, 360] }, { 6: $VH, 146: [1, 361] }, { 4: 362, 5: 3, 7: 4, 8: 5, 9: 6, 10: 7, 11: 27, 12: 28, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $V1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vi, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($V82, $V92, { 151: 111, 154: 112, 158: 116, 134: 363, 70: [1, 364], 135: $VS1, 148: $VK, 150: $VL, 156: $VM, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($V82, $Va2, { 134: 365, 70: $VR1, 135: $VS1 }), o($Vb2, [2, 203]), { 7: 309, 8: 310, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 69: [1, 366], 70: $Vz1, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 93: $VA1, 96: 61, 97: 211, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 136: 368, 138: 367, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o([6, 35, 69], $VU1, { 133: 369, 92: 371, 93: $Vc2 }), o($Vd2, [2, 234]), o($Ve2, [2, 225]), { 7: 309, 8: 310, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 35: $Vx1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 70: $Vz1, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 93: $VA1, 96: 61, 97: 211, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 131: 373, 132: 372, 136: 210, 137: 207, 138: 206, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vd2, [2, 236]), o($Ve2, [2, 230]), o($Vf2, [2, 223]), o($Vf2, [2, 224], { 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 13: 23, 15: 25, 16: 26, 60: 29, 53: 30, 74: 31, 100: 32, 51: 33, 76: 34, 75: 35, 98: 45, 172: 46, 151: 48, 147: 49, 152: 50, 154: 51, 155: 52, 96: 61, 73: 62, 42: 63, 48: 65, 37: 78, 67: 79, 158: 85, 44: 88, 89: 152, 9: 154, 7: 374, 14: $V0, 32: $Vk1, 38: $V2, 39: $V3, 43: $V4, 45: $V5, 46: $V6, 49: $V7, 50: $V8, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 68: $Vf, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 90: $Vk, 91: $Vl, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 148: $Vv, 150: $Vw, 153: $Vx, 156: $Vy, 167: $Vz, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }), { 78: 375, 126: $VP1 }, { 40: 376, 41: $VD1 }, { 7: 377, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vg2, [2, 202]), o($Vg2, [2, 38]), { 34: 378, 35: $Vj1, 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 34: 379, 35: $Vj1 }, o($Vh2, [2, 256], { 151: 111, 154: 112, 158: 116, 148: $VK, 149: [1, 380], 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 35: [2, 252], 149: [1, 381] }, o($Vh2, [2, 259], { 151: 111, 154: 112, 158: 116, 148: $VK, 149: [1, 382], 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 35: [2, 254], 149: [1, 383] }, o($V11, [2, 267]), o($Vi2, [2, 268], { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 35: $Vj2, 157: [1, 384] }, o($Vk2, [2, 278]), { 37: 231, 38: $V2, 39: $V3, 67: 232, 68: $Vg1, 73: 234, 96: 233, 107: $Vm, 130: $Vi1, 161: 385, 163: 230 }, { 37: 231, 38: $V2, 39: $V3, 67: 232, 68: $Vg1, 73: 234, 96: 233, 107: $Vm, 130: $Vi1, 161: 386, 163: 230 }, o($Vk2, [2, 285], { 93: [1, 387] }), o($Vl2, [2, 281]), o($Vl2, [2, 282]), o($Vl2, [2, 283]), o($Vl2, [2, 284]), o($V11, [2, 275]), { 35: [2, 277] }, { 7: 388, 8: 389, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 390, 8: 391, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 392, 8: 393, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vm2, $VU1, { 92: 394, 93: $Vn2 }), o($Vo2, [2, 143]), o($Vo2, [2, 56], { 65: [1, 396] }), o($Vo2, [2, 57]), o($Vp2, [2, 65], { 78: 399, 79: 400, 61: [1, 397], 70: [1, 398], 80: $Vq2, 81: $Vr2, 126: $VP1 }), { 7: 403, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vp2, [2, 67]), { 37: 249, 38: $V2, 39: $V3, 40: 250, 41: $VD1, 66: 404, 67: 251, 71: 405, 72: 252, 73: 253, 74: 254, 75: 255, 76: 256, 77: $VL1, 107: $Vm, 129: $Vq, 130: $Vr, 145: $Vu }, { 70: [1, 406], 78: 407, 79: 408, 80: $Vq2, 81: $Vr2, 126: $VP1 }, o($Vs2, [2, 62]), o($Vs2, [2, 63]), o($Vs2, [2, 64]), o($Vt2, [2, 72]), o($Vt2, [2, 73]), o($Vt2, [2, 74]), o($Vt2, [2, 75]), o($Vt2, [2, 76]), { 78: 409, 80: $VB1, 81: $VC1, 126: $VP1 }, o($V02, $Vd1, { 52: [1, 410] }), o($V02, $Vq1), { 6: $VH, 47: [1, 411] }, o($VI, [2, 4]), o($Vu2, [2, 358], { 151: 111, 154: 112, 158: 116, 182: $VQ, 183: $VR, 184: $VS }), o($Vu2, [2, 359], { 151: 111, 154: 112, 158: 116, 182: $VQ, 183: $VR, 184: $VS }), o($V$1, [2, 360], { 151: 111, 154: 112, 158: 116, 182: $VQ, 184: $VS }), o($V$1, [2, 361], { 151: 111, 154: 112, 158: 116, 182: $VQ, 184: $VS }), o([1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 185, 186, 187, 188, 189, 190, 191, 192, 193], [2, 362], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS }), o([1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 186, 187, 188, 189, 190, 191, 192], [2, 363], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 193: $V$ }), o([1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 187, 188, 189, 190, 191, 192], [2, 364], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 193: $V$ }), o([1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 188, 189, 190, 191, 192], [2, 365], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 193: $V$ }), o([1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 189, 190, 191, 192], [2, 366], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 193: $V$ }), o([1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 190, 191, 192], [2, 367], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 193: $V$ }), o([1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 191, 192], [2, 368], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 193: $V$ }), o([1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 192], [2, 369], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 193: $V$ }), o([1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 157, 174, 186, 187, 188, 189, 190, 191, 192, 193], [2, 370], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT }), o($Vi2, $Vv2, { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($VJ, [2, 346]), { 149: [1, 412] }, { 149: [1, 413] }, o([1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 149, 150, 156, 174, 178, 179, 182, 183, 184, 185, 186, 187, 188, 189, 190, 191, 192, 193], $Vj2, { 157: [1, 414] }), { 7: 415, 8: 416, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 417, 8: 418, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 419, 8: 420, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vi2, $Vw2, { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($VJ, [2, 345]), o($Vx2, [2, 193]), o($Vx2, [2, 194]), { 7: 309, 8: 310, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 35: $Vy2, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 70: $Vz1, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 97: 211, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 127: [1, 421], 128: 422, 129: $Vq, 130: $Vr, 136: 423, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($VF1, [2, 131]), o($VF1, [2, 132]), o($VF1, [2, 133]), o($VF1, [2, 134]), { 83: [1, 425] }, { 70: $VR1, 83: [2, 139], 134: 426, 135: $VS1, 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 83: [2, 140] }, { 70: $VR1, 134: 427, 135: $VS1 }, { 7: 428, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 83: [2, 215], 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vz2, [2, 206]), o($Vz2, $VA2), o($VF1, [2, 138]), o($V22, [2, 53], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 7: 429, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 430, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 89: 431, 90: $Vk, 91: $Vl }, o($VB2, $VC2, { 95: 134, 37: 136, 67: 137, 96: 138, 73: 139, 94: 432, 38: $V2, 39: $V3, 68: $Vg1, 70: $Vh1, 107: $Vm, 130: $Vi1 }), { 6: $VD2, 35: $VE2 }, o($VW1, [2, 105]), { 7: 435, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($VW1, [2, 106]), o($Vf2, $V92, { 151: 111, 154: 112, 158: 116, 70: [1, 436], 148: $VK, 150: $VL, 156: $VM, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($Vf2, $Va2), o($VF2, [2, 34]), { 6: $VH, 36: [1, 437] }, { 7: 438, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($VT1, $VU1, { 92: 305, 88: [1, 439], 93: $VV1 }), o($VZ1, $V_1, { 151: 111, 154: 112, 158: 116, 182: $VQ }), { 7: 440, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 34: 378, 35: $Vj1, 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, o($VJ, [2, 89], { 151: 111, 154: 112, 158: 116, 148: $V32, 150: $V32, 156: $V32, 174: $V32, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($V22, [2, 371], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 7: 441, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 442, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($V11, [2, 338]), { 7: 443, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($V11, [2, 242], { 142: [1, 444] }), { 34: 445, 35: $Vj1 }, { 34: 448, 35: $Vj1, 37: 446, 38: $V2, 39: $V3, 73: 447, 107: $Vm }, { 168: 449, 170: 330, 171: $V12 }, { 168: 450, 170: 330, 171: $V12 }, { 36: [1, 451], 169: [1, 452], 170: 453, 171: $V12 }, o($VH2, [2, 331]), { 7: 455, 8: 456, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 139: 454, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($VI2, [2, 149], { 151: 111, 154: 112, 158: 116, 34: 457, 35: $Vj1, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($V11, [2, 152]), { 7: 458, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 36: [1, 459] }, o($V22, [2, 33], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($VJ, [2, 87], { 151: 111, 154: 112, 158: 116, 148: $V32, 150: $V32, 156: $V32, 174: $V32, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($VJ, [2, 344]), { 7: 461, 8: 460, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 36: [1, 462] }, { 44: 463, 45: $V5, 46: $V6 }, { 107: [1, 465], 114: 464, 119: $Vw1 }, { 44: 466, 45: $V5, 46: $V6 }, { 33: [1, 467] }, o($Vm2, $VU1, { 92: 468, 93: $VJ2 }), o($Vo2, [2, 162]), { 35: $V42, 37: 348, 38: $V2, 39: $V3, 115: 470, 116: 346, 118: $V52 }, o($Vo2, [2, 167], { 117: [1, 471] }), o($Vo2, [2, 169], { 117: [1, 472] }), { 37: 473, 38: $V2, 39: $V3 }, o($Va1, [2, 173]), o($Vm2, $VU1, { 92: 474, 93: $VK2 }), o($Vo2, [2, 183]), { 35: $V62, 37: 355, 38: $V2, 39: $V3, 118: $V72, 121: 476, 123: 353 }, o($Vo2, [2, 188], { 117: [1, 477] }), o($Vo2, [2, 191], { 117: [1, 478] }), { 6: [1, 480], 7: 479, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 35: [1, 481], 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($VL2, [2, 179], { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 73: 482, 107: $Vm }, { 44: 483, 45: $V5, 46: $V6 }, o($Vb1, [2, 250]), { 6: $VH, 36: [1, 484] }, { 7: 485, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o([14, 32, 38, 39, 43, 45, 46, 49, 50, 54, 55, 56, 57, 58, 59, 68, 77, 84, 85, 86, 90, 91, 107, 110, 112, 120, 129, 130, 140, 144, 145, 148, 150, 153, 156, 167, 173, 176, 177, 178, 179, 180, 181], $VA2, { 6: $VM2, 35: $VM2, 69: $VM2, 93: $VM2 }), { 7: 486, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vb2, [2, 204]), o($Vd2, [2, 235]), o($Ve2, [2, 231]), { 6: $VN2, 35: $VO2, 69: [1, 487] }, o($VP2, $VC2, { 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 13: 23, 15: 25, 16: 26, 60: 29, 53: 30, 74: 31, 100: 32, 51: 33, 76: 34, 75: 35, 89: 37, 98: 45, 172: 46, 151: 48, 147: 49, 152: 50, 154: 51, 155: 52, 175: 57, 96: 61, 73: 62, 42: 63, 48: 65, 37: 78, 67: 79, 158: 85, 44: 88, 9: 148, 138: 206, 136: 210, 97: 211, 7: 309, 8: 310, 137: 490, 131: 491, 14: $V0, 32: $Vk1, 38: $V2, 39: $V3, 43: $V4, 45: $V5, 46: $V6, 49: $V7, 50: $V8, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 68: $Vf, 70: $Vz1, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 90: $Vk, 91: $Vl, 93: $VA1, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 148: $Vv, 150: $Vw, 153: $Vx, 156: $Vy, 167: $Vz, 173: $VA, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }), o($VP2, [2, 232]), o($VB2, $VU1, { 92: 371, 133: 492, 93: $Vc2 }), { 7: 309, 8: 310, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 70: $Vz1, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 93: $VA1, 96: 61, 97: 211, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 136: 368, 138: 367, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vf2, [2, 114], { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($Vx2, [2, 195]), o($Vb1, [2, 129]), { 83: [1, 493], 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, o($VQ2, [2, 335]), o($VR2, [2, 341]), { 7: 494, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 495, 8: 496, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 497, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 498, 8: 499, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 500, 8: 501, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vk2, [2, 279]), o($Vk2, [2, 280]), { 37: 231, 38: $V2, 39: $V3, 67: 232, 68: $Vg1, 73: 234, 96: 233, 107: $Vm, 130: $Vi1, 163: 502 }, { 35: $VS2, 148: $VK, 149: [1, 503], 150: $VL, 151: 111, 154: 112, 156: $VM, 157: [1, 504], 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 306], 149: [1, 505], 157: [1, 506] }, { 35: $VT2, 148: $VK, 149: [1, 507], 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 307], 149: [1, 508] }, { 35: $VU2, 148: $VK, 149: [1, 509], 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 322], 149: [1, 510] }, { 6: $VV2, 35: $VW2, 109: [1, 511] }, o($VX2, $VC2, { 44: 88, 63: 242, 64: 243, 66: 244, 42: 246, 71: 248, 37: 249, 40: 250, 67: 251, 72: 252, 73: 253, 74: 254, 75: 255, 76: 256, 62: 514, 38: $V2, 39: $V3, 41: $VD1, 43: $V4, 45: $V5, 46: $V6, 68: $VJ1, 70: $VK1, 77: $VL1, 107: $Vm, 129: $Vq, 130: $Vr, 145: $Vu }), { 7: 515, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 35: [1, 516], 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 517, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 35: [1, 518], 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vo2, [2, 68]), o($Vt2, [2, 78]), o($Vt2, [2, 80]), { 40: 519, 41: $VD1 }, { 7: 293, 8: 295, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 70: $VR1, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 82: 520, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 106: 294, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 134: 296, 135: $VS1, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 69: [1, 521], 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, o($Vo2, [2, 69], { 78: 399, 79: 400, 80: $Vq2, 81: $Vr2, 126: $VP1 }), o($Vo2, [2, 71], { 78: 407, 79: 408, 80: $Vq2, 81: $Vr2, 126: $VP1 }), o($Vo2, [2, 70]), o($Vt2, [2, 79]), o($Vt2, [2, 81]), o($Vt2, [2, 77]), o($Vb1, [2, 44]), o($VO1, [2, 42]), { 7: 522, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 523, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 524, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o([1, 6, 35, 36, 47, 69, 70, 83, 88, 93, 109, 127, 135, 146, 148, 150, 156, 174], $VS2, { 151: 111, 154: 112, 158: 116, 149: [1, 525], 157: [1, 526], 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 149: [1, 527], 157: [1, 528] }, o($VY2, $VT2, { 151: 111, 154: 112, 158: 116, 149: [1, 529], 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 149: [1, 530] }, o($VY2, $VU2, { 151: 111, 154: 112, 158: 116, 149: [1, 531], 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 149: [1, 532] }, o($Vx2, [2, 198]), o([6, 35, 127], $VU1, { 92: 533, 93: $VZ2 }), o($V_2, [2, 216]), { 7: 309, 8: 310, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 35: $Vy2, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 70: $Vz1, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 97: 211, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 128: 535, 129: $Vq, 130: $Vr, 136: 423, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($VF1, [2, 137]), { 7: 536, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 83: [2, 211], 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 537, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 83: [2, 213], 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 83: [2, 214], 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, o($V22, [2, 54], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 36: [1, 538], 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 5: 540, 7: 4, 8: 5, 9: 6, 10: 7, 11: 27, 12: 28, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $V1, 34: 539, 35: $Vj1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vi, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($VW1, [2, 101]), { 37: 136, 38: $V2, 39: $V3, 67: 137, 68: $Vg1, 70: $Vh1, 73: 139, 94: 541, 95: 134, 96: 138, 107: $Vm, 130: $Vi1 }, o($V$2, $Vf1, { 94: 133, 95: 134, 37: 136, 67: 137, 96: 138, 73: 139, 87: 542, 38: $V2, 39: $V3, 68: $Vg1, 70: $Vh1, 107: $Vm, 130: $Vi1 }), o($VW1, [2, 107], { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($Vf2, $VM2), o($VF2, [2, 35]), o($Vi2, $Vv2, { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 89: 543, 90: $Vk, 91: $Vl }, o($Vi2, $Vw2, { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 36: [1, 544], 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, o($V22, [2, 373], { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 34: 545, 35: $Vj1, 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 34: 546, 35: $Vj1 }, o($V11, [2, 243]), { 34: 547, 35: $Vj1 }, { 34: 548, 35: $Vj1 }, o($V03, [2, 247]), { 36: [1, 549], 169: [1, 550], 170: 453, 171: $V12 }, { 36: [1, 551], 169: [1, 552], 170: 453, 171: $V12 }, o($V11, [2, 329]), { 34: 553, 35: $Vj1 }, o($VH2, [2, 332]), { 34: 554, 35: $Vj1, 93: [1, 555] }, o($V13, [2, 237], { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($V13, [2, 238]), o($V11, [2, 150]), o($VI2, [2, 153], { 151: 111, 154: 112, 158: 116, 34: 556, 35: $Vj1, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($V11, [2, 249]), { 34: 557, 35: $Vj1 }, { 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, o($Va1, [2, 85]), o($Va1, [2, 156]), { 33: [1, 558] }, { 35: $V42, 37: 348, 38: $V2, 39: $V3, 115: 559, 116: 346, 118: $V52 }, o($Va1, [2, 157]), { 44: 560, 45: $V5, 46: $V6 }, { 6: $V23, 35: $V33, 109: [1, 561] }, o($VX2, $VC2, { 37: 348, 116: 564, 38: $V2, 39: $V3, 118: $V52 }), o($VB2, $VU1, { 92: 565, 93: $VJ2 }), { 37: 566, 38: $V2, 39: $V3 }, { 37: 567, 38: $V2, 39: $V3 }, { 33: [2, 172] }, { 6: $V43, 35: $V53, 109: [1, 568] }, o($VX2, $VC2, { 37: 355, 123: 571, 38: $V2, 39: $V3, 118: $V72 }), o($VB2, $VU1, { 92: 572, 93: $VK2 }), { 37: 573, 38: $V2, 39: $V3, 118: [1, 574] }, { 37: 575, 38: $V2, 39: $V3 }, o($VL2, [2, 176], { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 7: 576, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 577, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 36: [1, 578] }, o($Va1, [2, 181]), { 146: [1, 579] }, { 69: [1, 580], 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 69: [1, 581], 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, o($Vb2, [2, 205]), { 7: 309, 8: 310, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 70: $Vz1, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 93: $VA1, 96: 61, 97: 211, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 131: 373, 136: 210, 137: 582, 138: 206, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 309, 8: 310, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 35: $Vx1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 70: $Vz1, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 93: $VA1, 96: 61, 97: 211, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 131: 373, 132: 583, 136: 210, 137: 207, 138: 206, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Ve2, [2, 226]), o($VP2, [2, 233], { 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 13: 23, 15: 25, 16: 26, 60: 29, 53: 30, 74: 31, 100: 32, 51: 33, 76: 34, 75: 35, 89: 37, 98: 45, 172: 46, 151: 48, 147: 49, 152: 50, 154: 51, 155: 52, 175: 57, 96: 61, 73: 62, 42: 63, 48: 65, 37: 78, 67: 79, 158: 85, 44: 88, 9: 148, 97: 211, 7: 309, 8: 310, 138: 367, 136: 368, 14: $V0, 32: $Vk1, 38: $V2, 39: $V3, 43: $V4, 45: $V5, 46: $V6, 49: $V7, 50: $V8, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 68: $Vf, 70: $Vz1, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 90: $Vk, 91: $Vl, 93: $VA1, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 148: $Vv, 150: $Vw, 153: $Vx, 156: $Vy, 167: $Vz, 173: $VA, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }), { 6: $VN2, 35: $VO2, 36: [1, 584] }, o($Vb1, [2, 130]), o($Vi2, [2, 257], { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 35: $V63, 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 253] }, o($Vi2, [2, 260], { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 35: $V73, 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 255] }, { 35: $V83, 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 276] }, o($Vk2, [2, 286]), { 7: 585, 8: 586, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 587, 8: 588, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 589, 8: 590, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 591, 8: 592, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 593, 8: 594, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 595, 8: 596, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 597, 8: 598, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 599, 8: 600, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vb2, [2, 141]), { 37: 249, 38: $V2, 39: $V3, 40: 250, 41: $VD1, 42: 246, 43: $V4, 44: 88, 45: $V5, 46: $V6, 62: 601, 63: 242, 64: 243, 66: 244, 67: 251, 68: $VJ1, 70: $VK1, 71: 248, 72: 252, 73: 253, 74: 254, 75: 255, 76: 256, 77: $VL1, 107: $Vm, 129: $Vq, 130: $Vr, 145: $Vu }, o($V$2, $VI1, { 44: 88, 62: 241, 63: 242, 64: 243, 66: 244, 42: 246, 71: 248, 37: 249, 40: 250, 67: 251, 72: 252, 73: 253, 74: 254, 75: 255, 76: 256, 108: 602, 38: $V2, 39: $V3, 41: $VD1, 43: $V4, 45: $V5, 46: $V6, 68: $VJ1, 70: $VK1, 77: $VL1, 107: $Vm, 129: $Vq, 130: $Vr, 145: $Vu }), o($Vo2, [2, 144]), o($Vo2, [2, 58], { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 7: 603, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vo2, [2, 60], { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 7: 604, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($Vt2, [2, 82]), { 83: [1, 605] }, o($Vp2, [2, 66]), o($Vi2, $V63, { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($Vi2, $V73, { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($Vi2, $V83, { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 7: 606, 8: 607, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 608, 8: 609, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 610, 8: 611, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 612, 8: 613, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 614, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 615, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 616, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 7: 617, 9: 154, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vm1, 89: 152, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $Vn1, 176: $Vo1, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, { 6: $V93, 35: $Va3, 127: [1, 618] }, o([6, 35, 36, 127], $VC2, { 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 13: 23, 15: 25, 16: 26, 60: 29, 53: 30, 74: 31, 100: 32, 51: 33, 76: 34, 75: 35, 89: 37, 98: 45, 172: 46, 151: 48, 147: 49, 152: 50, 154: 51, 155: 52, 175: 57, 96: 61, 73: 62, 42: 63, 48: 65, 37: 78, 67: 79, 158: 85, 44: 88, 9: 148, 97: 211, 7: 309, 8: 310, 136: 621, 14: $V0, 32: $Vk1, 38: $V2, 39: $V3, 43: $V4, 45: $V5, 46: $V6, 49: $V7, 50: $V8, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 68: $Vf, 70: $Vz1, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 90: $Vk, 91: $Vl, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 148: $Vv, 150: $Vw, 153: $Vx, 156: $Vy, 167: $Vz, 173: $VA, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }), o($VB2, $VU1, { 92: 622, 93: $VZ2 }), { 83: [2, 210], 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 83: [2, 212], 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, o($V11, [2, 55]), o($VY1, [2, 91]), o($VJ, [2, 93]), o($VW1, [2, 102]), o($VB2, $VU1, { 92: 623, 93: $VV1 }), { 34: 539, 35: $Vj1 }, o($V11, [2, 372]), o($VQ2, [2, 336]), o($V11, [2, 244]), o($V03, [2, 245]), o($V03, [2, 246]), o($V11, [2, 325]), { 34: 624, 35: $Vj1 }, o($V11, [2, 326]), { 34: 625, 35: $Vj1 }, { 36: [1, 626] }, o($VH2, [2, 333], { 6: [1, 627] }), { 7: 628, 8: 629, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52, 156: $Vy, 158: 85, 167: $Vz, 172: 46, 173: $VA, 175: 57, 176: $VB, 177: $VC, 178: $VD, 179: $VE, 180: $VF, 181: $VG }, o($V11, [2, 154]), o($VR2, [2, 342]), { 44: 630, 45: $V5, 46: $V6 }, o($Vm2, $VU1, { 92: 631, 93: $VJ2 }), o($Va1, [2, 158]), { 33: [1, 632] }, { 37: 348, 38: $V2, 39: $V3, 116: 633, 118: $V52 }, { 35: $V42, 37: 348, 38: $V2, 39: $V3, 115: 634, 116: 346, 118: $V52 }, o($Vo2, [2, 163]), { 6: $V23, 35: $V33, 36: [1, 635] }, o($Vo2, [2, 168]), o($Vo2, [2, 170]), o($Va1, [2, 174], { 33: [1, 636] }), { 37: 355, 38: $V2, 39: $V3, 118: $V72, 123: 637 }, { 35: $V62, 37: 355, 38: $V2, 39: $V3, 118: $V72, 121: 638, 123: 353 }, o($Vo2, [2, 184]), { 6: $V43, 35: $V53, 36: [1, 639] }, o($Vo2, [2, 189]), o($Vo2, [2, 190]), o($Vo2, [2, 192]), o($VL2, [2, 177], { 151: 111, 154: 112, 158: 116, 148: $VK, 150: $VL, 156: $VM, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 36: [1, 640], 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, o($Va1, [2, 180]), o($Vb1, [2, 251]), o($Vb1, [2, 208]), o($Vb1, [2, 209]), o($Ve2, [2, 227]), o($VB2, $VU1, { 92: 371, 133: 641, 93: $Vc2 }), o($Ve2, [2, 228]), { 35: $Vb3, 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 157: [1, 642], 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 308], 157: [1, 643] }, { 35: $Vc3, 148: $VK, 149: [1, 644], 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 312], 149: [1, 645] }, { 35: $Vd3, 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 157: [1, 646], 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 309], 157: [1, 647] }, { 35: $Ve3, 148: $VK, 149: [1, 648], 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 313], 149: [1, 649] }, { 35: $Vf3, 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 310] }, { 35: $Vg3, 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 311] }, { 35: $Vh3, 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 323] }, { 35: $Vi3, 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VN, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 35: [2, 324] }, o($Vo2, [2, 145]), o($VB2, $VU1, { 92: 650, 93: $Vn2 }), { 36: [1, 651], 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, { 36: [1, 652], 148: $VK, 150: $VL, 151: 111, 154: 112, 156: $VM, 158: 116, 174: $VG2, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }, o($Vt2, [2, 83]), o($Vj3, $Vb3, { 151: 111, 154: 112, 158: 116, 157: [1, 653], 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 157: [1, 654] }, o($VY2, $Vc3, { 151: 111, 154: 112, 158: 116, 149: [1, 655], 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 149: [1, 656] }, o($Vj3, $Vd3, { 151: 111, 154: 112, 158: 116, 157: [1, 657], 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 157: [1, 658] }, o($VY2, $Ve3, { 151: 111, 154: 112, 158: 116, 149: [1, 659], 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), { 149: [1, 660] }, o($V22, $Vf3, { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($V22, $Vg3, { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($V22, $Vh3, { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($V22, $Vi3, { 151: 111, 154: 112, 158: 116, 178: $VO, 179: $VP, 182: $VQ, 183: $VR, 184: $VS, 185: $VT, 186: $VU, 187: $VV, 188: $VW, 189: $VX, 190: $VY, 191: $VZ, 192: $V_, 193: $V$ }), o($Vx2, [2, 199]), { 7: 309, 8: 310, 9: 148, 13: 23, 14: $V0, 15: 25, 16: 26, 17: 8, 18: 9, 19: 10, 20: 11, 21: 12, 22: 13, 23: 14, 24: 15, 25: 16, 26: 17, 27: 18, 28: 19, 29: 20, 30: 21, 31: 22, 32: $Vk1, 37: 78, 38: $V2, 39: $V3, 42: 63, 43: $V4, 44: 88, 45: $V5, 46: $V6, 48: 65, 49: $V7, 50: $V8, 51: 33, 53: 30, 54: $V9, 55: $Va, 56: $Vb, 57: $Vc, 58: $Vd, 59: $Ve, 60: 29, 67: 79, 68: $Vf, 70: $Vz1, 73: 62, 74: 31, 75: 35, 76: 34, 77: $Vg, 84: $Vh, 85: $Vl1, 86: $Vj, 89: 37, 90: $Vk, 91: $Vl, 96: 61, 97: 211, 98: 45, 100: 32, 107: $Vm, 110: $Vn, 112: $Vo, 120: $Vp, 129: $Vq, 130: $Vr, 136: 661, 140: $Vs, 144: $Vt, 145: $Vu, 147: 49, 148: $Vv, 150: $Vw, 151: 48, 152: 50, 153: $Vx, 154: 51, 155: 52,