// Generated by CoffeeScript 1.3.1
(function() {
  var TestObject, TestObjects,
    __hasProp = {}.hasOwnProperty,
    __extends = function(child, parent) { for (var key in parent) { if (__hasProp.call(parent, key)) child[key] = parent[key]; } function ctor() { this.constructor = child; } ctor.prototype = parent.prototype; child.prototype = new ctor; child.__super__ = parent.prototype; return child; };

  TestObject = (function(_super) {

    __extends(TestObject, _super);

    TestObject.name = 'TestObject';

    function TestObject() {
      return TestObject.__super__.constructor.apply(this, arguments);
    }

    TestObject.prototype.type = 'TestObject';

    return TestObject;

  })(Continuum.HasProperties);

  TestObjects = (function(_super) {

    __extends(TestObjects, _super);

    TestObjects.name = 'TestObjects';

    function TestObjects() {
      return TestObjects.__super__.constructor.apply(this, arguments);
    }

    TestObjects.prototype.model = TestObject;

    TestObjects.prototype.url = "/";

    return TestObjects;

  })(Backbone.Collection);

  test('computed_properties', function() {
    var model, temp;
    Continuum.register_collection('TestObject', new TestObjects());
    model = Continuum.Collections['TestObject'].create({
      'a': 1,
      'b': 1
    });
    model.register_property('c', ['a', 'b'], function() {
      return this.get('a') + this.get('b');
    });
    temp = model.get('c');
    return ok(temp === 2);
  });

  test('cached_properties_react_changes', function() {
    var model, temp;
    Continuum.register_collection('TestObject', new TestObjects());
    model = Continuum.Collections['TestObject'].create({
      'a': 1,
      'b': 1
    });
    model.register_property('c', ['a', 'b'], function() {
      return this.get('a') + this.get('b');
    }, true);
    temp = model.get('c');
    ok(temp === 2);
    temp = model.get_cache('c');
    ok(!_.isUndefined(temp));
    model.set('a', 10);
    temp = model.get_cache('c');
    temp = model.get('c');
    return ok(temp === 11);
  });

  test('has_prop_manages_event_lifcycle', function() {
    var model, model2, triggered;
    Continuum.register_collection('TestObject', new TestObjects());
    model = Continuum.Collections['TestObject'].create({
      'a': 1,
      'b': 1
    });
    model2 = Continuum.Collections['TestObject'].create({
      'a': 1,
      'b': 1
    });
    triggered = false;
    Continuum.safebind(model, model2, 'change', function() {
      return triggered = true;
    });
    model2.set({
      'a': 2
    });
    ok(triggered);
    triggered = false;
    model.destroy();
    model2.set({
      'a': 3
    });
    return ok(!triggered);
  });

  test('has_prop_manages_event_for_views', function() {
    var model, model2, triggered, view;
    Continuum.register_collection('TestObject', new TestObjects());
    model = Continuum.Collections['TestObject'].create({
      'a': 1,
      'b': 1
    });
    model2 = Continuum.Collections['TestObject'].create({
      'a': 1,
      'b': 1
    });
    view = new Continuum.ContinuumView({
      'model': model2
    });
    triggered = false;
    Continuum.safebind(view, model, 'change', function() {
      return triggered = true;
    });
    model.set({
      'a': 2
    });
    ok(triggered);
    triggered = false;
    view.remove();
    model.set({
      'a': 3
    });
    return ok(!triggered);
  });

  test('property_setters', function() {
    var model, prop, setter;
    Continuum.register_collection('TestObject', new TestObjects());
    model = Continuum.Collections['TestObject'].create({
      'a': 1,
      'b': 1
    });
    prop = function() {
      return this.get('a') + this.get('b');
    };
    setter = function(val) {
      this.set('a', val / 2, {
        silent: true
      });
      return this.set('b', val / 2);
    };
    model.register_property('c', ['a', 'b'], prop, true, setter);
    model.set('c', 100);
    ok(model.get('a') === 50);
    return ok(model.get('b') === 50);
  });

}).call(this);
