import 'package:pub2port/pub2port.dart';
import 'package:pubspec_lock/pubspec_lock.dart';
import 'package:test/test.dart';

void main() {
  test('lockToPort', () {
    final lockfile =
        '''
# Generated by pub
# See https://dart.dev/tools/pub/glossary#lockfile
packages:
  _fe_analyzer_shared:
    dependency: transitive
    description:
      name: _fe_analyzer_shared
      sha256: dc27559385e905ad30838356c5f5d574014ba39872d732111cd07ac0beff4c57
      url: "https://pub.dev"
    source: hosted
    version: "80.0.0"
  analyzer:
    dependency: transitive
    description:
      name: analyzer
      sha256: "192d1c5b944e7e53b24b5586db760db934b177d4147c42fbca8c8c5f1eb8d11e"
      url: "https://pub.dev"
    source: hosted
    version: "7.3.0"
  args:
    dependency: "direct main"
    description:
      name: args
      sha256: bf9f5caeea8d8fe6721a9c358dd8a5c1947b27f1cfaa18b39c301273594919e6
      url: "https://pub.dev"
    source: hosted
    version: "2.6.0"
sdks:
  dart: ">=3.7.0 <4.0.0"
'''.loadPubspecLockFromYaml();
    final out = StringBuffer();
    lockToPort(lockfile, out: out);
    expect(out.toString(), r'''
pub.packages \
    _fe_analyzer_shared  80.0.0  dc27559385e905ad30838356c5f5d574014ba39872d732111cd07ac0beff4c57 \
    analyzer              7.3.0  192d1c5b944e7e53b24b5586db760db934b177d4147c42fbca8c8c5f1eb8d11e \
    args                  2.6.0  bf9f5caeea8d8fe6721a9c358dd8a5c1947b27f1cfaa18b39c301273594919e6
''');
  });
}
