/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration.symbol;

import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UEllipse;
import net.sourceforge.plantuml.klimt.shape.URectangle;
import net.sourceforge.plantuml.style.SName;

class USymbolPerson
extends USymbol {
    USymbolPerson() {
    }

    @Override
    public SName[] getSNames() {
        return new SName[]{SName.person};
    }

    private void drawHeadAndBody(UGraphic ug, double shadowing, XDimension2D dimBody, double headSize) {
        UEllipse head = UEllipse.build(headSize, headSize);
        URectangle body = URectangle.build(dimBody).rounded(headSize);
        body.setDeltaShadow(shadowing);
        head.setDeltaShadow(shadowing);
        double posx = (dimBody.getWidth() - headSize) / 2.0;
        ug.apply(UTranslate.dx(posx)).draw(head);
        ug.apply(UTranslate.dy(headSize)).draw(body);
    }

    private double headSize(XDimension2D dimBody) {
        double surface = dimBody.getWidth() * dimBody.getHeight();
        return Math.sqrt(surface) * 0.42;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(10.0, 10.0, 10.0, 10.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, final HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dimFull = this.calculateDimension(ug.getStringBounder());
                XDimension2D dimBody = this.bodyDimension(ug.getStringBounder());
                ug = UGraphicStencil.create(ug, dimFull);
                ug = symbolContext.apply(ug);
                double headSize = USymbolPerson.this.headSize(dimBody);
                USymbolPerson.this.drawHeadAndBody(ug, symbolContext.getDeltaShadow(), dimBody, headSize);
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, stereoAlignment);
                USymbol.Margin margin = USymbolPerson.this.getMargin();
                tb.drawU(ug.apply(new UTranslate(margin.getX1(), margin.getY1() + headSize)));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D body = this.bodyDimension(stringBounder);
                return body.delta(0.0, USymbolPerson.this.headSize(body));
            }

            private XDimension2D bodyDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return USymbolPerson.this.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(TextBlock title, HorizontalAlignment labelAlignment, TextBlock stereotype, double width, double height, Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        throw new UnsupportedOperationException();
    }
}

