amends "../snippetTest.pkl"

local class Empty

local open class Animal {
  species: String
  age: Int
  numberOfFeet: Int = 2
}

local class Dinosaur extends Animal {
  isExtinct: Boolean = true
}

local dino = new Dinosaur {
  numberOfFeet = 4
}

local pigeon = new Animal {
  local n = "Pigeon"
  species = n
  age = 5
}

examples {
  ["getProperty()"] {
    pigeon.getProperty("species")
    pigeon.getProperty("spe" + "cies")
    pigeon.getProperty("age")
    module.catch(() -> pigeon.getProperty("other"))
  }

  ["getPropertyOrNull()"] {
    pigeon.getPropertyOrNull("species")
    pigeon.getPropertyOrNull("speci" + "es")
    pigeon.getPropertyOrNull("age")
    pigeon.getPropertyOrNull("other")
  }

  ["hasProperty()"] {
    pigeon.hasProperty("species")
    pigeon.hasProperty("specie" + "s")
    pigeon.hasProperty("age")
    pigeon.hasProperty("other")

    pigeon.hasProperty("numberOfFeet")
    dino.hasProperty("numberOfFeet")
    dino.hasProperty("isAlive")
  }

  ["toDynamic()"] {
    local dynPigeon = pigeon.toDynamic()
    dynPigeon
    dynPigeon.getClass().simpleName
    (dynPigeon) {
      age = "age" // change type
      ["isExtinct"] = false // add new property
    }
    (new Animal { species = "Pigeon"; age = species.length }.toDynamic()) {
      species = "Pigeon" // no dynamic binding
    }
  }

  ["toMap()"] {
    local mapPigeon = pigeon.toMap()
    mapPigeon
    mapPigeon.getClass().simpleName
    new Empty {}.toMap()
    pigeon.toDynamic().toMap()
    new Dynamic { species = "Pigeon"; age = species.length }.toMap() + Map(
        "species", "Pigeon"
      )
  }
}
